/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;
import org.rhq.modules.plugins.jbossas7.ASConnectionParamsBuilder;
import org.rhq.modules.plugins.jbossas7.SchemeRegistryBuilder;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class ASUploadConnection {
    private static final Log LOG = LogFactory.getLog(ASUploadConnection.class);
    private static final int SOCKET_CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_READ_TIMEOUT = 60000;
    private static final String TRIGGER_AUTH_URI = "/management";
    private static final String UPLOAD_URI = "/management/add-content";
    private static final int FILE_POST_MAX_LOGGABLE_RESPONSE_LENGTH = 2048;
    private static final String EMPTY_JSON_TREE = "{}";
    private static final String JSON_NODE_FAILURE_DESCRIPTION = "failure-description";
    private static final String JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT = "FailureDescription: -input was null-";
    private static final String JSON_NODE_OUTCOME = "outcome";
    private static final String JSON_NODE_OUTCOME_VALUE_FAILED = "failed";
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private final ASConnectionParams asConnectionParams;
    private final int timeout;
    private final URI triggerAuthUri;
    private final URI uploadUri;
    private final UsernamePasswordCredentials credentials;
    private String filename;
    private File cacheFile;
    private BufferedOutputStream cacheOutputStream;

    @Deprecated
    public ASUploadConnection(String host, int port, String user, String password) {
        this(new ASConnectionParamsBuilder().setHost(host).setPort(port).setUsername(user).setPassword(password).createASConnectionParams(), null);
    }

    @Deprecated
    public ASUploadConnection(String host, int port, String user, String password, String fileName) {
        this(new ASConnectionParamsBuilder().setHost(host).setPort(port).setUsername(user).setPassword(password).createASConnectionParams(), fileName);
    }

    @Deprecated
    public ASUploadConnection(ASConnection asConnection) {
        this(asConnection.getAsConnectionParams(), null);
    }

    public ASUploadConnection(ASConnection asConnection, String fileName) {
        this(asConnection.getAsConnectionParams(), fileName);
    }

    public ASUploadConnection(ASConnectionParams params, String filename) {
        this.asConnectionParams = params;
        if (this.asConnectionParams.getHost() == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (this.asConnectionParams.getPort() <= 0 || this.asConnectionParams.getPort() > 65535) {
            throw new IllegalArgumentException("Invalid port: " + this.asConnectionParams.getPort());
        }
        this.filename = filename;
        this.timeout = 60000;
        this.triggerAuthUri = this.buildTriggerAuthUri();
        this.uploadUri = this.buildUploadUri();
        this.credentials = this.asConnectionParams.getUsername() != null && this.asConnectionParams.getPassword() != null ? new UsernamePasswordCredentials(this.asConnectionParams.getUsername(), this.asConnectionParams.getPassword()) : null;
    }

    private URI buildTriggerAuthUri() {
        try {
            return new URIBuilder().setScheme(this.asConnectionParams.isSecure() ? "https" : "http").setHost(this.asConnectionParams.getHost()).setPort(this.asConnectionParams.getPort()).setPath(TRIGGER_AUTH_URI).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not build auth trigger URI: " + e.getMessage(), e);
        }
    }

    private URI buildUploadUri() {
        try {
            return new URIBuilder().setScheme(this.asConnectionParams.isSecure() ? "https" : "http").setHost(this.asConnectionParams.getHost()).setPort(this.asConnectionParams.getPort()).setPath(UPLOAD_URI).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not build upload URI: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static ASUploadConnection newInstanceForServerPluginConfiguration(ServerPluginConfiguration pluginConfig, String fileName) {
        return new ASUploadConnection(ASConnectionParams.createFrom(pluginConfig), fileName);
    }

    @Deprecated
    public OutputStream getOutputStream(String fileName) {
        this.filename = fileName;
        return this.getOutputStream();
    }

    public OutputStream getOutputStream() {
        try {
            this.cacheFile = File.createTempFile(this.getClass().getSimpleName(), ".cache");
            this.cacheOutputStream = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            return this.cacheOutputStream;
        }
        catch (IOException e) {
            LOG.error((Object)("Could not create outputstream for " + this.filename), (Throwable)e);
            return null;
        }
    }

    public void cancelUpload() {
        this.closeQuietly(this.cacheOutputStream);
        this.deleteCacheFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode finishUpload() {
        if (this.filename == null) {
            throw new IllegalStateException("Upload fileName is null");
        }
        this.closeQuietly(this.cacheOutputStream);
        SchemeRegistry schemeRegistry = new SchemeRegistryBuilder(this.asConnectionParams).buildSchemeRegistry();
        BasicClientConnectionManager httpConnectionManager = new BasicClientConnectionManager(schemeRegistry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager);
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.timeout);
        if (this.credentials != null && !this.asConnectionParams.isClientcertAuthentication()) {
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.asConnectionParams.getHost(), this.asConnectionParams.getPort()), (Credentials)this.credentials);
            HttpGet triggerAuthRequest = new HttpGet(this.triggerAuthUri);
            try {
                httpClient.execute((HttpUriRequest)triggerAuthRequest);
            }
            catch (Exception ignore) {
            }
            finally {
                triggerAuthRequest.abort();
            }
        }
        String uploadURL = (this.asConnectionParams.isSecure() ? "https" : "http") + "://" + this.asConnectionParams.getHost() + ":" + this.asConnectionParams.getPort() + UPLOAD_URI;
        HttpPost uploadRequest = new HttpPost(this.uploadUri);
        try {
            MultipartEntity multipartEntity = new MultipartEntity();
            multipartEntity.addPart(this.filename, (ContentBody)new FileBody(this.cacheFile));
            uploadRequest.setEntity((HttpEntity)multipartEntity);
            HttpResponse uploadResponse = httpClient.execute((HttpUriRequest)uploadRequest);
            if (uploadResponse.getStatusLine().getStatusCode() != 200) {
                this.logUploadDoesNotEndWithHttpOkStatus(uploadResponse);
                JsonNode jsonNode = null;
                return jsonNode;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            InputStream responseBodyAsStream = uploadResponse.getEntity().getContent();
            if (responseBodyAsStream == null) {
                LOG.warn((Object)"POST request has no response body");
                JsonNode jsonNode = objectMapper.readTree(EMPTY_JSON_TREE);
                return jsonNode;
            }
            JsonNode jsonNode = objectMapper.readTree(responseBodyAsStream);
            return jsonNode;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            JsonNode jsonNode = null;
            return jsonNode;
        }
        finally {
            uploadRequest.abort();
            httpConnectionManager.shutdown();
            this.deleteCacheFile();
        }
    }

    public static String getFailureDescription(JsonNode jsonNode) {
        if (jsonNode == null) {
            return JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT;
        }
        JsonNode node = jsonNode.findValue(JSON_NODE_FAILURE_DESCRIPTION);
        if (node == null) {
            return JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT;
        }
        return node.getValueAsText();
    }

    public static boolean isErrorReply(JsonNode jsonNode) {
        if (jsonNode == null) {
            return true;
        }
        if (jsonNode.has(JSON_NODE_OUTCOME)) {
            String outcome = null;
            try {
                JsonNode outcomeNode = jsonNode.findValue(JSON_NODE_OUTCOME);
                outcome = outcomeNode.getTextValue();
                if (outcome.equals(JSON_NODE_OUTCOME_VALUE_FAILED)) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
                return true;
            }
        }
        return false;
    }

    private void logUploadDoesNotEndWithHttpOkStatus(HttpResponse uploadResponse) {
        StringBuilder logMessageBuilder = new StringBuilder("File upload failed: ").append(ASConnection.statusAsString(uploadResponse.getStatusLine()));
        if (uploadResponse.getEntity().getContentLength() > 0L && uploadResponse.getEntity().getContentLength() < 2048L) {
            try {
                String responseBodyAsString = EntityUtils.toString((HttpEntity)uploadResponse.getEntity());
                logMessageBuilder.append(SYSTEM_LINE_SEPARATOR).append(responseBodyAsString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.warn((Object)logMessageBuilder.toString());
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteCacheFile() {
        if (this.cacheFile != null) {
            this.cacheFile.delete();
        }
    }

    @Deprecated
    public int getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public void setTimeout(int timeout) {
    }
}

