/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.DatasourceComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.UndefineAttribute;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class ConnectorDiscoveryGroupValidatorComponent
extends BaseComponent<ResourceComponent<?>> {
    private static final String DISCOVERY_GROUP_NAME = "discovery-group-name";

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ConfigurationUpdateHelper configurationUpdateHelper;
        ResourceType resourceType = this.context.getResourceType();
        String resourceTypeName = resourceType.getName();
        if (resourceTypeName.equals("Connection Factory") || resourceTypeName.equals("Pooled Connection Factory")) {
            configurationUpdateHelper = new ConnectionFactoriesConfigurationUpdateHelper(this.getAddress(), report.getConfiguration());
        } else if (resourceTypeName.equals("Bridge") || resourceTypeName.equals("Cluster Connection")) {
            configurationUpdateHelper = new DefaultConfigurationUpdateHelper(this.address, report.getConfiguration());
        } else {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(resourceType + " not supported");
            return;
        }
        if (!configurationUpdateHelper.isConnectorXorDiscoveryGroupNameConfigured()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(configurationUpdateHelper.getErrorMessage());
        } else {
            Operation batchOperation = configurationUpdateHelper.getBatchOperation();
            Result result = this.getASConnection().execute(batchOperation);
            if (!result.isSuccess()) {
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                report.setErrorMessage(result.getFailureDescription());
                return;
            }
            ConfigurationDefinition configDefCopy = DatasourceComponent.copyConfigurationDefinition(resourceType.getResourceConfigurationDefinition());
            configDefCopy.getPropertyDefinitions().remove(DISCOVERY_GROUP_NAME);
            configDefCopy.getPropertyDefinitions().remove(configurationUpdateHelper.getConnectorPropertyName());
            ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDefCopy, this.getASConnection(), this.address);
            delegate.updateResourceConfiguration(report);
        }
    }

    private static class DefaultConfigurationUpdateHelper
    extends ConfigurationUpdateHelper {
        static final String STATIC_CONNECTORS_ATTRIBUTE = "static-connectors";
        static final String STATIC_CONNECTORS_PROPERTY = "static-connectors:nullable";
        final Address address;

        public DefaultConfigurationUpdateHelper(Address address, Configuration configuration) {
            super(configuration);
            this.address = address;
        }

        @Override
        String getConnectorPropertyName() {
            return STATIC_CONNECTORS_PROPERTY;
        }

        @Override
        boolean isConnectorPropertyDefined() {
            PropertyList staticConnectors = this.configuration.getList(STATIC_CONNECTORS_PROPERTY);
            return staticConnectors != null && !staticConnectors.getList().isEmpty();
        }

        @Override
        String getBeginningOfErrorMessage() {
            return "You need to provide either static connectors name OR a discovery-group-name.";
        }

        @Override
        public Operation getBatchOperation() {
            CompositeOperation compositeOperation = new CompositeOperation();
            if (this.hasDiscoveryGroupName()) {
                compositeOperation.addStep(new UndefineAttribute(this.address, STATIC_CONNECTORS_ATTRIBUTE));
                compositeOperation.addStep(new WriteAttribute(this.address, ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME, (Object)this.configuration.getSimpleValue(ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME)));
            } else {
                compositeOperation.addStep(new UndefineAttribute(this.address, ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME));
                List propertyList = this.configuration.getList(STATIC_CONNECTORS_PROPERTY).getList();
                ArrayList<String> staticConnectors = new ArrayList<String>(propertyList.size());
                for (Property property : propertyList) {
                    if (property instanceof PropertySimple) {
                        PropertySimple propertySimple = (PropertySimple)property;
                        staticConnectors.add(propertySimple.getStringValue());
                        continue;
                    }
                    BaseComponent.getLog().warn((Object)(property.getName() + " property has unexpected type: " + property.getClass()));
                }
                compositeOperation.addStep(new WriteAttribute(this.address, STATIC_CONNECTORS_ATTRIBUTE, staticConnectors));
            }
            return compositeOperation;
        }
    }

    private static class ConnectionFactoriesConfigurationUpdateHelper
    extends ConfigurationUpdateHelper {
        static final String CONNECTOR_ATTRIBUTE = "connector";
        static final String CONNECTOR_PROPERTY = "connector:collapsed";
        Address address;

        ConnectionFactoriesConfigurationUpdateHelper(Address address, Configuration configuration) {
            super(configuration);
            this.address = address;
        }

        @Override
        String getConnectorPropertyName() {
            return CONNECTOR_PROPERTY;
        }

        @Override
        boolean isConnectorPropertyDefined() {
            PropertyMap connector = this.configuration.getMap(CONNECTOR_PROPERTY);
            if (connector != null) {
                return StringUtil.isNotBlank((String)connector.getSimpleValue("name:0", ""));
            }
            return false;
        }

        @Override
        String getBeginningOfErrorMessage() {
            return "You need to provide either a connector name OR a discovery-group-name.";
        }

        @Override
        public Operation getBatchOperation() {
            CompositeOperation compositeOperation = new CompositeOperation();
            if (this.hasDiscoveryGroupName()) {
                compositeOperation.addStep(new UndefineAttribute(this.address, CONNECTOR_ATTRIBUTE));
                compositeOperation.addStep(new WriteAttribute(this.address, ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME, (Object)this.configuration.getSimpleValue(ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME)));
            } else {
                compositeOperation.addStep(new UndefineAttribute(this.address, ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME));
                compositeOperation.addStep(new WriteAttribute(this.address, CONNECTOR_ATTRIBUTE, Collections.singletonMap(this.configuration.getMap(CONNECTOR_PROPERTY).getSimpleValue("name:0", ""), null)));
            }
            return compositeOperation;
        }
    }

    private static abstract class ConfigurationUpdateHelper {
        final Configuration configuration;
        final boolean hasDiscoveryGroupName;
        final boolean hasConnector;
        final boolean hasNoneOfTheAlternatives;
        final String errorMessage;

        ConfigurationUpdateHelper(Configuration configuration) {
            this.configuration = configuration;
            this.hasDiscoveryGroupName = StringUtil.isNotBlank((String)this.configuration.getSimpleValue(ConnectorDiscoveryGroupValidatorComponent.DISCOVERY_GROUP_NAME));
            this.hasConnector = this.isConnectorPropertyDefined();
            this.hasNoneOfTheAlternatives = this.hasDiscoveryGroupName == this.hasConnector && !this.hasConnector;
            this.errorMessage = this.getBeginningOfErrorMessage() + (this.hasNoneOfTheAlternatives ? " You provided none." : " You provided both.");
        }

        abstract String getConnectorPropertyName();

        abstract boolean isConnectorPropertyDefined();

        abstract String getBeginningOfErrorMessage();

        boolean isConnectorXorDiscoveryGroupNameConfigured() {
            return this.hasDiscoveryGroupName != this.hasConnector;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        public abstract Operation getBatchOperation();

        boolean hasDiscoveryGroupName() {
            return this.hasDiscoveryGroupName;
        }
    }
}

