/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class MemoryPoolComponent
extends BaseComponent<BaseComponent<?>> {
    private static final String USAGE_THRESHOLD_PREFIX = "usage-threshold-";
    private static final String USAGE_THRESHOLD_SUPPORTED_ATTRIBUTE = "usage-threshold-supported";
    private static final String COLLECTION_USAGE_THRESHOLD_PREFIX = "collection-usage-threshold-";
    private static final String COLLECTION_USAGE_THRESHOLD_SUPPORTED_ATTRIBUTE = "collection-usage-threshold-supported";
    private Boolean usageThresholdSupported;
    private Boolean collectionUsageThresholdSupported;

    @Override
    public void start(ResourceContext<BaseComponent<?>> context) throws Exception {
        super.start(context);
    }

    @Override
    public void stop() {
        super.stop();
        this.usageThresholdSupported = null;
        this.collectionUsageThresholdSupported = null;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        if (this.usageThresholdSupported == null) {
            this.usageThresholdSupported = this.readAttribute(this.getAddress(), USAGE_THRESHOLD_SUPPORTED_ATTRIBUTE, Boolean.class);
        }
        if (this.collectionUsageThresholdSupported == null) {
            this.collectionUsageThresholdSupported = this.readAttribute(this.getAddress(), COLLECTION_USAGE_THRESHOLD_SUPPORTED_ATTRIBUTE, Boolean.class);
        }
        HashSet<MeasurementScheduleRequest> filteredMetrics = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : metrics) {
            String requestName = request.getName();
            if (USAGE_THRESHOLD_SUPPORTED_ATTRIBUTE.equals(requestName)) {
                report.addData(new MeasurementDataTrait(request, String.valueOf(this.usageThresholdSupported)));
                continue;
            }
            if (requestName.startsWith(USAGE_THRESHOLD_PREFIX)) {
                if (this.usageThresholdSupported != Boolean.TRUE) continue;
                filteredMetrics.add(request);
                continue;
            }
            if (COLLECTION_USAGE_THRESHOLD_SUPPORTED_ATTRIBUTE.equals(requestName)) {
                report.addData(new MeasurementDataTrait(request, String.valueOf(this.collectionUsageThresholdSupported)));
                continue;
            }
            if (requestName.startsWith(COLLECTION_USAGE_THRESHOLD_PREFIX)) {
                if (this.collectionUsageThresholdSupported != Boolean.TRUE) continue;
                filteredMetrics.add(request);
                continue;
            }
            filteredMetrics.add(request);
        }
        super.getValues(report, filteredMetrics);
    }
}

