/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ModClusterDiscoveryComponent
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING, true);
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        ASConnection connection = parentComponent.getASConnection();
        Configuration config = context.getDefaultPluginConfiguration();
        String confPath = config.getSimpleValue("path", "");
        if (confPath == null || confPath.isEmpty()) {
            this.log.error((Object)("Path plugin config is null for ResourceType [" + context.getResourceType().getName() + "]."));
            return details;
        }
        String path = parentComponent.getPath() + "," + confPath;
        if (path.startsWith(",")) {
            path = path.substring(1);
        }
        PropertySimple ps = new PropertySimple("path", (Object)path);
        Result result = connection.execute(new ReadResource(new Address(path)));
        if (result.isSuccess()) {
            String resKey = path;
            String name = resKey.substring(resKey.lastIndexOf("=") + 1);
            Configuration config2 = context.getDefaultPluginConfiguration();
            PropertySimple pathProp = new PropertySimple("path", (Object)path);
            config2.put((Property)pathProp);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), path, name, null, context.getResourceType().getDescription(), config2, null);
            details.add(detail);
        }
        return details;
    }
}

