/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class NetworkInterfaceComponent
extends BaseComponent<NetworkInterfaceComponent>
implements ConfigurationFacet {
    private static final String[] wildCards = new String[]{"any-address", "any-ipv4-address", "any-ipv6-address"};
    private static final String WILDCARD_IGNORE = "wildcard:ignore";

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = super.loadResourceConfiguration();
        return configuration;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration config = report.getConfiguration();
        boolean isWildcard = false;
        for (String wildcard : wildCards) {
            isWildcard |= Boolean.valueOf(config.getSimpleValue(wildcard)).booleanValue();
        }
        if (config.getSimpleValue("inet-address") != null) {
            if (isWildcard) {
                report.setErrorMessage("When setting any-address or any-ipv4-address or any-ipv6-address to true inet-address must be unset");
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                return;
            }
            for (String wildcard : wildCards) {
                config.getSimple(wildcard).setValue(null);
            }
        } else if (!isWildcard) {
            report.setErrorMessage("You need to enable either any-address or any-ipv4-address or any-ipv6-address when inet-address is disabled");
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            return;
        }
        super.updateResourceConfiguration(report);
    }

    public static void preProcessCreateChildConfiguration(Configuration configuration) {
        for (String wildCard : wildCards) {
            PropertySimple ps = configuration.getSimple(wildCard);
            if (ps == null || !ps.getStringValue().equals("false")) continue;
            configuration.remove(wildCard);
        }
    }
}

