/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ServerGroupComponent
extends BaseComponent
implements ContentFacet,
CreateChildResourceFacet,
OperationFacet {
    private static final String OUTCOME = "outcome";

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        Operation op = new Operation(name, this.getAddress());
        Result res = this.getASConnection().execute(op, parameters.getSimple("responseTimeout").getIntegerValue());
        OperationResult result = new OperationResult();
        if (res.isSuccess()) {
            result.setSimpleResult("success");
        } else {
            result.setErrorMessage(res.getFailureDescription());
        }
        return result;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        ContentContext cctx = this.context.getContentContext();
        DeployPackagesResponse response = new DeployPackagesResponse();
        for (ResourcePackageDetails details : packages) {
            String packageName = details.getName();
            ASUploadConnection uploadConnection = new ASUploadConnection(this.getServerComponent().getASConnection(), packageName);
            OutputStream out = uploadConnection.getOutputStream();
            if (out == null) {
                response.addPackageResponse(new DeployIndividualPackageResponse(details.getKey(), ContentResponseResult.FAILURE));
                continue;
            }
            try {
                contentServices.downloadPackageBits(cctx, details.getKey(), out, false);
            }
            catch (Exception e) {
                uploadConnection.cancelUpload();
                response.addPackageResponse(new DeployIndividualPackageResponse(details.getKey(), ContentResponseResult.FAILURE));
                continue;
            }
            JsonNode uploadResult = uploadConnection.finishUpload();
            if (uploadResult.has(OUTCOME)) {
                String outcome = uploadResult.get(OUTCOME).getTextValue();
                if (outcome.equals("success")) {
                    JsonNode resultNode = uploadResult.get("result");
                    String hash = resultNode.get("BYTES_VALUE").getTextValue();
                    ASConnection connection = this.getASConnection();
                    Address deploymentsAddress = new Address();
                    deploymentsAddress.add("deployment", packageName);
                    Operation step1 = new Operation("add", deploymentsAddress);
                    ArrayList content = new ArrayList(1);
                    HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
                    contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
                    content.add(contentValues);
                    step1.addAdditionalProperty("content", content);
                    step1.addAdditionalProperty("name", packageName);
                    Address serverGroupAddress = new Address(this.context.getResourceKey());
                    serverGroupAddress.add("deployment", packageName);
                    Operation step2 = new Operation("add", serverGroupAddress);
                    Operation step3 = new Operation("deploy", serverGroupAddress);
                    CompositeOperation cop = new CompositeOperation();
                    cop.addStep(step1);
                    cop.addStep(step2);
                    cop.addStep(step3);
                    Result result = connection.execute(cop);
                    if (!result.isSuccess()) {
                        response.addPackageResponse(new DeployIndividualPackageResponse(details.getKey(), ContentResponseResult.FAILURE));
                        continue;
                    }
                    DeployIndividualPackageResponse individualPackageResponse = new DeployIndividualPackageResponse(details.getKey(), ContentResponseResult.SUCCESS);
                    response.addPackageResponse(individualPackageResponse);
                    response.setOverallRequestResult(ContentResponseResult.SUCCESS);
                    continue;
                }
                response.addPackageResponse(new DeployIndividualPackageResponse(details.getKey(), ContentResponseResult.FAILURE));
                continue;
            }
            response.addPackageResponse(new DeployIndividualPackageResponse(details.getKey(), ContentResponseResult.FAILURE));
        }
        return response;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        ReadChildrenNames op = new ReadChildrenNames(this.address, "deployment");
        Result node = this.getASConnection().execute(op);
        if (!node.isSuccess()) {
            return null;
        }
        List resultList = (List)node.getResult();
        HashSet<ResourcePackageDetails> details = new HashSet<ResourcePackageDetails>();
        for (String file : resultList) {
            String t = file.contains(".") ? file.substring(file.lastIndexOf(".") + 1) : "-none-";
            ResourcePackageDetails detail = new ResourcePackageDetails(new PackageDetailsKey(file, "1.0", t, "all"));
            details.add(detail);
        }
        return details;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }

    private String serverGroupFromKey() {
        String key1 = this.context.getResourceKey();
        return key1.substring(key1.lastIndexOf("/") + 1);
    }
}

