/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.inventory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.system.ProcessInfo;

public class DiscoveredResourceDetails {
    private static final int RESOURCE_KEY_MAX_LENGTH = 500;
    private static final int RESOURCE_NAME_MAX_LENGTH = 500;
    private static final int RESOURCE_VERSION_MAX_LENGTH = 100;
    private static final int RESOURCE_DESCRIPTION_MAX_LENGTH = 1000;
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceType resourceType;
    private String resourceKey;
    private String resourceName;
    private String resourceVersion;
    private String resourceDescription;
    private Configuration pluginConfiguration;
    private ProcessInfo processInfo;

    public DiscoveredResourceDetails(ResourceType resourceType, String resourceKey, String resourceName, String resourceVersion, String resourceDescription, Configuration pluginConfiguration, ProcessInfo processInfo) {
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType==null");
        }
        this.resourceType = resourceType;
        this.processInfo = processInfo;
        this.setResourceKey(resourceKey);
        this.setResourceName(resourceName);
        this.setResourceVersion(resourceVersion);
        this.setResourceDescription(resourceDescription);
        this.setPluginConfiguration(pluginConfiguration);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String resourceKey) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("resourceKey==null");
        }
        if (resourceKey.length() == 0) {
            throw new IllegalArgumentException("resourceKey==\"\"");
        }
        if (resourceKey.length() > 500) {
            throw new IllegalArgumentException("Plugin error: Resource key [" + resourceKey + "] specified by [" + this.resourceType + "] discovery component is longer than the maximum length (" + 500 + ").");
        }
        this.resourceKey = resourceKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName==null");
        }
        if (resourceName.length() == 0) {
            throw new IllegalArgumentException("resourceName==\"\"");
        }
        if (resourceName.length() > 500) {
            this.log.warn((Object)("Plugin error: Resource name [" + resourceName + "] specified by [" + this.resourceType + "] discovery component is longer than the maximum length (" + 500 + " - truncating it to " + 500 + " characters..."));
            this.resourceName = resourceName.substring(0, 500);
        } else {
            this.resourceName = resourceName;
        }
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        if (resourceVersion != null && resourceVersion.length() == 0) {
            this.resourceVersion = null;
        } else if (resourceVersion != null && resourceVersion.length() > 100) {
            this.log.warn((Object)("Plugin error: Resource version [" + resourceVersion + "] specified by [" + this.resourceType + "] discovery component is longer than the maximum length (" + 100 + ") - truncating it to " + 100 + " characters..."));
            this.resourceVersion = resourceVersion.substring(0, 100);
        } else {
            this.resourceVersion = resourceVersion;
        }
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        if (resourceDescription != null && resourceDescription.length() == 0) {
            this.resourceDescription = null;
        } else if (resourceDescription != null && resourceDescription.length() > 1000) {
            this.log.warn((Object)("Plugin error: Resource description [" + resourceDescription + "] specified by [" + this.resourceType + "] discovery component is longer than the maximum length (" + 1000 + " - truncating it to " + 1000 + " characters..."));
            this.resourceDescription = resourceDescription.substring(0, 1000);
        } else {
            this.resourceDescription = resourceDescription;
        }
    }

    public Configuration getPluginConfiguration() {
        if (this.pluginConfiguration == null) {
            this.pluginConfiguration = this.createDefaultPluginConfiguration();
        }
        return this.pluginConfiguration;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public void setPluginConfiguration(Configuration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("key=");
        buf.append(this.getResourceKey());
        buf.append(",name=");
        buf.append(this.getResourceName());
        buf.append(",type=");
        buf.append(this.getResourceType().getName());
        buf.append(",version=");
        buf.append(this.getResourceVersion());
        buf.append(",description=");
        buf.append(this.getResourceDescription());
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveredResourceDetails that = (DiscoveredResourceDetails)o;
        if (!this.resourceKey.equals(that.resourceKey)) {
            return false;
        }
        return this.resourceType.equals((Object)that.resourceType);
    }

    public int hashCode() {
        int result = this.resourceType.hashCode();
        result = 31 * result + this.resourceKey.hashCode();
        return result;
    }

    private Configuration createDefaultPluginConfiguration() {
        ConfigurationTemplate template;
        ConfigurationDefinition definition = this.resourceType.getPluginConfigurationDefinition();
        if (definition != null && (template = definition.getDefaultTemplate()) != null) {
            return template.getConfiguration().deepCopy();
        }
        return new Configuration();
    }
}

