/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.inventory;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityContext;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.component.ComponentInvocationContext;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InventoryContext;
import org.rhq.core.pluginapi.inventory.PluginContainerDeployment;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.inventory.ResourceTypeProcesses;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;
import org.rhq.core.util.MessageDigestGenerator;

public class ResourceContext<T extends ResourceComponent<?>> {
    private static final Log LOG = LogFactory.getLog(ResourceContext.class);
    private final T parentResourceComponent;
    private final ResourceContext<?> parentResourceContext;
    private final Configuration pluginConfiguration;
    private final SystemInfo systemInformation;
    private final ResourceDiscoveryComponent<T> resourceDiscoveryComponent;
    private final Resource resource;
    private File temporaryDirectory;
    private final File baseDataDirectory;
    private final String pluginContainerName;
    private final EventContext eventContext;
    private final OperationContext operationContext;
    private final ContentContext contentContext;
    private final AvailabilityContext availabilityContext;
    private final InventoryContext inventoryContext;
    private final PluginContainerDeployment pluginContainerDeployment;
    private final ResourceTypeProcesses trackedProcesses;
    private final ComponentInvocationContext componentInvocationContext;
    private static Map<Children, ResourceTypeProcesses> PROCESSES_PER_PARENT_PER_RESOURCE_TYPE = new HashMap<Children, ResourceTypeProcesses>();

    @Deprecated
    public ResourceContext(Resource resource, T parentResourceComponent, ResourceContext<?> parentResourceContext, ResourceDiscoveryComponent<T> resourceDiscoveryComponent, SystemInfo systemInfo, File temporaryDirectory, File baseDataDirectory, String pluginContainerName, EventContext eventContext, OperationContext operationContext, ContentContext contentContext, AvailabilityContext availabilityContext, InventoryContext inventoryContext, PluginContainerDeployment pluginContainerDeployment) {
        this(resource, parentResourceComponent, parentResourceContext, resourceDiscoveryComponent, systemInfo, temporaryDirectory, baseDataDirectory, pluginContainerName, eventContext, operationContext, contentContext, availabilityContext, inventoryContext, pluginContainerDeployment, new ComponentInvocationContext(){

            @Override
            public boolean isInterrupted() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void markInterrupted() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public ResourceContext(Resource resource, T parentResourceComponent, ResourceContext<?> parentResourceContext, ResourceDiscoveryComponent<T> resourceDiscoveryComponent, SystemInfo systemInfo, File temporaryDirectory, File baseDataDirectory, String pluginContainerName, EventContext eventContext, OperationContext operationContext, ContentContext contentContext, AvailabilityContext availabilityContext, InventoryContext inventoryContext, PluginContainerDeployment pluginContainerDeployment, ComponentInvocationContext componentInvocationContext) {
        this.resource = resource;
        this.parentResourceComponent = parentResourceComponent;
        this.parentResourceContext = parentResourceContext;
        this.resourceDiscoveryComponent = resourceDiscoveryComponent;
        this.systemInformation = systemInfo;
        this.pluginConfiguration = resource.getPluginConfiguration();
        this.baseDataDirectory = baseDataDirectory;
        this.pluginContainerName = pluginContainerName != null ? pluginContainerName.intern() : null;
        this.pluginContainerDeployment = pluginContainerDeployment;
        this.temporaryDirectory = temporaryDirectory;
        this.eventContext = eventContext;
        this.operationContext = operationContext;
        this.contentContext = contentContext;
        this.availabilityContext = availabilityContext;
        this.inventoryContext = inventoryContext;
        String parentResourceUuid = "";
        if (resource.getParentResource() != null) {
            parentResourceUuid = resource.getParentResource().getUuid();
        }
        this.trackedProcesses = ResourceContext.getTrackedProcesses(parentResourceUuid, resource.getResourceType());
        this.componentInvocationContext = componentInvocationContext;
    }

    public String getResourceKey() {
        return this.resource.getResourceKey();
    }

    public ResourceType getResourceType() {
        return this.resource.getResourceType();
    }

    public String getVersion() {
        return this.resource.getVersion();
    }

    public File getResourceDataDirectory() {
        File resourceDataDirectory = new File(this.baseDataDirectory, this.getAncestryBasedResourceKey());
        try {
            File oldResourceDataDirectory = new File(this.baseDataDirectory, this.resource.getUuid());
            if (oldResourceDataDirectory.exists()) {
                oldResourceDataDirectory.renameTo(resourceDataDirectory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!resourceDataDirectory.exists()) {
            resourceDataDirectory.mkdirs();
        }
        return resourceDataDirectory;
    }

    public File getFutureChildResourceDataDirectory(String childResourceKey) {
        File childResourceDataDirectory = new File(this.baseDataDirectory, this.getAncestryBasedResourceKey(childResourceKey));
        if (!childResourceDataDirectory.exists()) {
            childResourceDataDirectory.mkdirs();
        }
        return childResourceDataDirectory;
    }

    public T getParentResourceComponent() {
        return this.parentResourceComponent;
    }

    protected ResourceContext<?> getParentResourceContext() {
        return this.parentResourceContext;
    }

    public SystemInfo getSystemInformation() {
        return this.systemInformation;
    }

    public Configuration getPluginConfiguration() {
        return this.pluginConfiguration.deepCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInfo getNativeProcess() {
        ProcessInfo processInfo = null;
        ResourceTypeProcesses resourceTypeProcesses = this.trackedProcesses;
        synchronized (resourceTypeProcesses) {
            processInfo = this.trackedProcesses.getProcessInfo(this.resource.getResourceKey());
            if (this.isRediscoveryRequired(processInfo)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"getNativeProcess(): recheck for rediscovery confirmed the need for it");
                }
                try {
                    Set<DiscoveredResourceDetails> details = Collections.emptySet();
                    List<ProcessScanResult> processes = this.getNativeProcessesForType();
                    if (!processes.isEmpty()) {
                        ResourceDiscoveryContext<T> context = new ResourceDiscoveryContext<T>(this.resource.getResourceType(), this.parentResourceComponent, this.parentResourceContext, this.systemInformation, processes, Collections.EMPTY_LIST, this.getPluginContainerName(), this.getPluginContainerDeployment());
                        details = this.resourceDiscoveryComponent.discoverResources(context);
                    }
                    this.trackedProcesses.update(details);
                    processInfo = this.trackedProcesses.getProcessInfo(this.resource.getResourceKey());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Cannot get native process for resource [" + this.resource.getResourceKey() + "] - discovery failed"), (Throwable)e);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"getNativeProcess(): rediscovery done");
        }
        return processInfo;
    }

    private boolean isRediscoveryRequired(ProcessInfo processInfo) {
        return processInfo == null || !processInfo.freshSnapshot().isRunning();
    }

    public List<ProcessScanResult> getNativeProcessesForType() {
        ArrayList<ProcessScanResult> scanResults = new ArrayList<ProcessScanResult>();
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        try {
            Set processScans = this.resource.getResourceType().getProcessScans();
            if (processScans != null && !processScans.isEmpty()) {
                ProcessInfoQuery piq = new ProcessInfoQuery(systemInfo.getAllProcesses());
                for (ProcessScan processScan : processScans) {
                    List queryResults = piq.query(processScan.getQuery());
                    if (queryResults == null || queryResults.size() <= 0) continue;
                    for (ProcessInfo autoDiscoveredProcess : queryResults) {
                        scanResults.add(new ProcessScanResult(processScan, autoDiscoveredProcess));
                    }
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return scanResults;
    }

    public File getTemporaryDirectory() {
        if (this.temporaryDirectory == null) {
            this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"), "AGENT_TMP");
            this.temporaryDirectory.mkdirs();
        }
        return this.temporaryDirectory;
    }

    public File getDataDirectory() {
        return new File(this.baseDataDirectory, this.resource.getResourceType().getPlugin());
    }

    public String getPluginContainerName() {
        return this.pluginContainerName;
    }

    public PluginContainerDeployment getPluginContainerDeployment() {
        return this.pluginContainerDeployment;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public ContentContext getContentContext() {
        return this.contentContext;
    }

    public AvailabilityContext getAvailabilityContext() {
        return this.availabilityContext;
    }

    public InventoryContext getInventoryContext() {
        return this.inventoryContext;
    }

    @Deprecated
    public AvailabilityCollectorRunnable createAvailabilityCollectorRunnable(AvailabilityFacet availChecker, long interval) {
        return this.getAvailabilityContext().createAvailabilityCollectorRunnable(availChecker, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceTypeProcesses getTrackedProcesses(String parentResourceUuid, ResourceType resourceType) {
        Map<Children, ResourceTypeProcesses> map = PROCESSES_PER_PARENT_PER_RESOURCE_TYPE;
        synchronized (map) {
            Children key = new Children(parentResourceUuid, resourceType);
            ResourceTypeProcesses ret = PROCESSES_PER_PARENT_PER_RESOURCE_TYPE.get(key);
            if (ret == null) {
                ret = new ResourceTypeProcesses();
                PROCESSES_PER_PARENT_PER_RESOURCE_TYPE.put(key, ret);
            }
            return ret;
        }
    }

    private String getAncestryBasedResourceKey() {
        return this.getAncestryBasedResourceKey(null);
    }

    private String getAncestryBasedResourceKey(String prefixKey) {
        MessageDigestGenerator messageDigest = new MessageDigestGenerator("SHA-256");
        if (prefixKey != null) {
            messageDigest.add(prefixKey.getBytes());
        }
        messageDigest.add(this.resource.getResourceKey().getBytes());
        for (ResourceContext<?> ancestor = this.parentResourceContext; ancestor != null; ancestor = ancestor.getParentResourceContext()) {
            messageDigest.add(ancestor.getResourceKey().getBytes());
        }
        return messageDigest.getDigestString();
    }

    public ComponentInvocationContext getComponentInvocationContext() {
        return this.componentInvocationContext;
    }

    public String getResourceDetails() {
        return this.resource.toString();
    }

    private static class Children {
        public final ResourceType resourceType;
        public final String parentResourceUuid;

        public Children(String parentResourceUuid, ResourceType resourceType) {
            this.parentResourceUuid = parentResourceUuid;
            this.resourceType = resourceType;
        }

        public int hashCode() {
            int uuidHashCode = this.parentResourceUuid == null ? 1 : this.parentResourceUuid.hashCode();
            return 31 * uuidHashCode * this.resourceType.getId();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Children)) {
                return false;
            }
            Children o = (Children)other;
            return (this.parentResourceUuid == null ? o.parentResourceUuid == null : this.parentResourceUuid.equals(o.parentResourceUuid)) && this.resourceType.equals((Object)o.resourceType);
        }
    }
}

