/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import com.sun.istack.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.pluginapi.util.CommandLineOption;

public class JavaCommandLine {
    private static final String SHORT_OPTION_PREFIX = "-";
    private static final String LONG_OPTION_PREFIX = "--";
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile("-D.+");
    private static final Log log = LogFactory.getLog(JavaCommandLine.class);
    private final List<String> arguments;
    private final boolean includeSystemPropertiesFromClassArguments;
    private final Set<OptionValueDelimiter> shortClassOptionValueDelims;
    private final Set<OptionValueDelimiter> longClassOptionValueDelims;
    private boolean argumentsParsed;
    private File javaExecutable;
    private List<String> classPath;
    private Map<String, String> systemProperties;
    private List<String> javaOptions;
    private String mainClassName;
    private File executableJarFile;
    private List<String> classArguments;
    private Map<String, String> shortClassOptionNameToOptionValueMap;
    private Map<String, String> longClassOptionNameToOptionValueMap;

    public JavaCommandLine(String ... args) {
        this(args, false);
    }

    public JavaCommandLine(String[] args, boolean includeSystemPropertiesFromClassArguments) {
        this(args, includeSystemPropertiesFromClassArguments, null, null);
    }

    public JavaCommandLine(String[] args, boolean includeSystemPropertiesFromClassArguments, Set<OptionValueDelimiter> shortClassOptionValueDelims, Set<OptionValueDelimiter> longClassOptionValueDelims) {
        if (args == null) {
            throw new IllegalArgumentException("'args' parameter is null.");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("'args' parameter is an empty array.");
        }
        this.includeSystemPropertiesFromClassArguments = includeSystemPropertiesFromClassArguments;
        Set<OptionValueDelimiter> set = this.shortClassOptionValueDelims = shortClassOptionValueDelims != null ? shortClassOptionValueDelims : EnumSet.of(OptionValueDelimiter.WHITESPACE);
        if (this.shortClassOptionValueDelims.isEmpty()) {
            throw new IllegalArgumentException("'shortClassOptionValueDelims' parameter is an empty set.");
        }
        Set<OptionValueDelimiter> set2 = this.longClassOptionValueDelims = longClassOptionValueDelims != null ? longClassOptionValueDelims : EnumSet.of(OptionValueDelimiter.EQUALS_SIGN);
        if (this.longClassOptionValueDelims.isEmpty()) {
            throw new IllegalArgumentException("'longClassOptionValueDelims' parameter is an empty set.");
        }
        this.arguments = Arrays.asList(args);
    }

    protected void parseCommandLine() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing " + this + "..."));
        }
        ListIterator<String> argIterator = this.arguments.listIterator();
        ListIterator<String> classArgumentsIterator = this.arguments.listIterator();
        this.javaExecutable = new File(argIterator.next());
        this.classPath = new ArrayList<String>();
        this.systemProperties = new LinkedHashMap<String, String>();
        this.javaOptions = new ArrayList<String>();
        this.classArguments = new ArrayList<String>();
        boolean nextArgIsClassPath = false;
        boolean nextArgIsJarFile = false;
        while (argIterator.hasNext()) {
            String arg = argIterator.next();
            classArgumentsIterator.next();
            if (nextArgIsClassPath) {
                this.classPath.addAll(Arrays.asList(arg.split(File.pathSeparator)));
                nextArgIsClassPath = false;
                continue;
            }
            if (nextArgIsJarFile) {
                this.executableJarFile = new File(arg);
                this.parseClassArguments(argIterator, true);
                break;
            }
            if (arg.charAt(0) != '-') {
                this.mainClassName = arg;
                this.parseClassArguments(argIterator, true);
                break;
            }
            if (arg.equals("-cp") || arg.equals("-classpath")) {
                if (!argIterator.hasNext()) {
                    throw new IllegalArgumentException(arg + " option has no argument.");
                }
                nextArgIsClassPath = true;
                continue;
            }
            if (arg.equals("-jar")) {
                if (!argIterator.hasNext()) {
                    throw new IllegalArgumentException(arg + " option has no argument.");
                }
                nextArgIsJarFile = true;
                continue;
            }
            if (this.isSystemPropertyArgument(arg)) {
                this.parseSystemPropertyArgument(arg);
            }
            this.javaOptions.add(arg);
        }
        this.parseClassOptions();
        this.argumentsParsed = true;
        if (classArgumentsIterator.hasNext()) {
            this.parseClassArguments(classArgumentsIterator, false);
        }
        this.classPath = Collections.unmodifiableList(this.classPath);
        this.javaOptions = Collections.unmodifiableList(this.javaOptions);
        this.classArguments = Collections.unmodifiableList(this.classArguments);
        this.systemProperties = Collections.unmodifiableMap(this.systemProperties);
    }

    protected boolean isArgumentsParsed() {
        return this.argumentsParsed;
    }

    private void parseClassArguments(Iterator<String> arguments, boolean firstPass) {
        if (!arguments.hasNext()) {
            return;
        }
        String classArg = arguments.next();
        while (arguments.hasNext()) {
            String nextArg = arguments.next();
            this.processClassArgument(classArg, nextArg, firstPass);
            classArg = nextArg;
        }
        this.processClassArgument(classArg, null, firstPass);
    }

    private void processClassArgument(String classArg, String nextArg, boolean firstPass) {
        if (firstPass) {
            if (this.includeSystemPropertiesFromClassArguments && this.isSystemPropertyArgument(classArg)) {
                this.parseSystemPropertyArgument(classArg);
            }
            this.classArguments.add(classArg);
        } else {
            this.processClassArgument(classArg, nextArg);
        }
    }

    protected void processClassArgument(String classArg, String nextArg) {
    }

    private void parseClassOptions() {
        this.shortClassOptionNameToOptionValueMap = new HashMap<String, String>();
        this.longClassOptionNameToOptionValueMap = new HashMap<String, String>();
        if (!this.classArguments.isEmpty()) {
            int classArgumentsSize = this.classArguments.size();
            for (int i = 0; i < classArgumentsSize; ++i) {
                int equalsIndex;
                Map<String, String> optionValueMap;
                Set<OptionValueDelimiter> optionValueDelims;
                String optionString;
                String classArg = this.classArguments.get(i);
                if (classArg.startsWith(LONG_OPTION_PREFIX)) {
                    if (classArg.length() == LONG_OPTION_PREFIX.length()) break;
                    optionString = classArg.substring(LONG_OPTION_PREFIX.length());
                    optionValueDelims = this.longClassOptionValueDelims;
                    optionValueMap = this.longClassOptionNameToOptionValueMap;
                } else {
                    if (!classArg.startsWith(SHORT_OPTION_PREFIX)) continue;
                    optionString = classArg.substring(SHORT_OPTION_PREFIX.length());
                    optionValueDelims = this.shortClassOptionValueDelims;
                    optionValueMap = this.shortClassOptionNameToOptionValueMap;
                }
                String optionName = null;
                String optionValue = null;
                if (optionValueDelims.contains((Object)OptionValueDelimiter.WHITESPACE)) {
                    equalsIndex = optionString.indexOf(61);
                    if (equalsIndex >= 1) {
                        if (optionValueDelims.contains((Object)OptionValueDelimiter.EQUALS_SIGN)) {
                            optionName = optionString.substring(0, equalsIndex);
                            optionValue = equalsIndex == optionString.length() - 1 ? "" : optionString.substring(equalsIndex + 1);
                        } else if (optionString.charAt(0) != 'D') {
                            log.warn((Object)("Option [" + classArg + "] contains an equals sign, which is not a valid class option value delimiter for this command line."));
                        }
                    } else {
                        optionName = optionString;
                        optionValue = i + 1 < classArgumentsSize && !this.classArguments.get(i + 1).startsWith(SHORT_OPTION_PREFIX) ? this.classArguments.get(++i) : "";
                    }
                } else if (optionValueDelims.contains((Object)OptionValueDelimiter.EQUALS_SIGN)) {
                    equalsIndex = optionString.indexOf(61);
                    if (equalsIndex == -1) {
                        optionName = optionString;
                        optionValue = "";
                    } else if (equalsIndex >= 1) {
                        optionName = optionString.substring(0, equalsIndex);
                        optionValue = equalsIndex == optionString.length() - 1 ? "" : optionString.substring(equalsIndex + 1);
                    } else {
                        log.warn((Object)("Ignoring malformed option [" + classArg + "] on command line [" + this + "]..."));
                    }
                }
                if (optionName == null) continue;
                optionValueMap.put(optionName, optionValue);
            }
        }
    }

    private boolean isSystemPropertyArgument(String arg) {
        return SYSTEM_PROPERTY_PATTERN.matcher(arg).matches();
    }

    private void parseSystemPropertyArgument(String arg) {
        String value;
        String name;
        String argValue = arg.substring(2);
        int equalsSignIndex = argValue.indexOf(61);
        if (equalsSignIndex >= 0) {
            name = argValue.substring(0, equalsSignIndex);
            value = equalsSignIndex == argValue.length() - 1 ? "" : argValue.substring(equalsSignIndex + 1);
        } else {
            name = argValue;
            value = "";
        }
        this.systemProperties.put(name, value);
    }

    @NotNull
    public List<String> getArguments() {
        return this.arguments;
    }

    @NotNull
    public File getJavaExecutable() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.javaExecutable;
    }

    @NotNull
    public List<String> getClassPath() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.classPath;
    }

    @NotNull
    public Map<String, String> getSystemProperties() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.systemProperties;
    }

    @NotNull
    public List<String> getJavaOptions() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.javaOptions;
    }

    @Nullable
    public String getMainClassName() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.mainClassName;
    }

    @Nullable
    public File getExecutableJarFile() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.executableJarFile;
    }

    @NotNull
    public List<String> getClassArguments() {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.classArguments;
    }

    @Nullable
    public String getClassOption(CommandLineOption option) {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return this.getClassOption(option, null);
    }

    @Nullable
    public String getClassOption(CommandLineOption option, String defaultValue) {
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        String optionValue = null;
        if (option.getLongName() != null && this.longClassOptionNameToOptionValueMap.containsKey(option.getLongName()) && !(optionValue = this.longClassOptionNameToOptionValueMap.get(option.getLongName())).isEmpty() && !option.isExpectsValue()) {
            if (this.longClassOptionValueDelims.equals(EnumSet.of(OptionValueDelimiter.EQUALS_SIGN))) {
                log.warn((Object)("Class option [" + option + "] does not expect a value, but a value was specified on command line [" + this + "]."));
            } else if (this.longClassOptionValueDelims.equals(EnumSet.of(OptionValueDelimiter.WHITESPACE))) {
                optionValue = "";
            }
        }
        if (optionValue == null && option.getShortName() != null && this.shortClassOptionNameToOptionValueMap.containsKey(option.getShortName()) && !(optionValue = this.shortClassOptionNameToOptionValueMap.get(option.getShortName())).isEmpty() && !option.isExpectsValue()) {
            if (this.shortClassOptionValueDelims.equals(EnumSet.of(OptionValueDelimiter.EQUALS_SIGN))) {
                log.warn((Object)("Class option [" + option + "] does not expect a value, but a value was specified on command line [" + this + "]."));
            } else if (this.shortClassOptionValueDelims.equals(EnumSet.of(OptionValueDelimiter.WHITESPACE))) {
                optionValue = "";
            }
        }
        if (optionValue != null && optionValue.isEmpty() && option.isExpectsValue()) {
            log.warn((Object)("Class option [" + option + "] expects a value, but no value was specified on command line [" + this + "]."));
        }
        return optionValue != null ? optionValue : defaultValue;
    }

    public boolean isClassOptionPresent(CommandLineOption option) {
        String optionValue;
        if (!this.argumentsParsed) {
            this.parseCommandLine();
        }
        return (optionValue = this.getClassOption(option)) != null;
    }

    public String toString() {
        return "JavaCommandLine[arguments=" + this.arguments + ", includeSystemPropertiesFromClassArguments=" + this.includeSystemPropertiesFromClassArguments + ", shortClassOptionFormat=" + this.shortClassOptionValueDelims + ", longClassOptionFormat=" + this.longClassOptionValueDelims + "]";
    }

    public static enum OptionValueDelimiter {
        WHITESPACE,
        EQUALS_SIGN;

    }
}

