/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.util.exception.ThrowableUtil;

public class ObjectUtil {
    private static final Log LOG = LogFactory.getLog(ObjectUtil.class);

    @Nullable
    public static Object lookupAttributeProperty(Object obj, String propertyName) {
        Object value = null;
        if (obj instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)obj;
            if (compositeData.containsKey(propertyName)) {
                value = compositeData.get(propertyName);
            } else {
                LOG.debug((Object)("Unable to read attribute/property [" + propertyName + "] from object [" + obj + "] using OpenMBean API - no such property."));
            }
        } else {
            try {
                PropertyDescriptor[] pds = Introspector.getBeanInfo(obj.getClass()).getPropertyDescriptors();
                boolean propertyFound = false;
                for (PropertyDescriptor pd : pds) {
                    if (!pd.getName().equals(propertyName)) continue;
                    propertyFound = true;
                    Method readMethod = pd.getReadMethod();
                    if (readMethod == null) {
                        LOG.debug((Object)("Unable to read attribute/property [" + propertyName + "] from object [" + obj + "] using Reflection - property is not readable (i.e. it has no getter)."));
                        continue;
                    }
                    value = readMethod.invoke(obj, new Object[0]);
                }
                if (!propertyFound) {
                    LOG.debug((Object)("Unable to read attribute/property [" + propertyName + "] from object [" + obj + "] using Reflection - no such property."));
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Unable to read attribute/property [" + propertyName + "] from object [" + obj + "] using Reflection - cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
        }
        return value;
    }

    private static Set<String> getAttributeNames(Set<MeasurementScheduleRequest> requests) {
        HashSet<String> names = new HashSet<String>();
        for (MeasurementScheduleRequest request : requests) {
            names.add(ObjectUtil.getAttributeName(request.getName()));
        }
        return names;
    }

    private static String getAttributeName(String property) {
        if (property.startsWith("{")) {
            return property.substring(1, property.indexOf(46));
        }
        return property;
    }

    private static String getAttributeProperty(String property) {
        if (property.startsWith("{")) {
            return property.substring(property.indexOf(46) + 1, property.length() - 1);
        }
        return null;
    }

    public static Double lookupDeepNumericAttributeProperty(Object value, String propertyPath) {
        Object val = ObjectUtil.lookupDeepAttributeProperty(value, propertyPath);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return Double.NaN;
    }

    public static Object lookupDeepAttributeProperty(Object value, String propertyPath) {
        if (value == null) {
            return null;
        }
        String[] ps = propertyPath.split("\\.", 2);
        String searchProperty = ps[0];
        if (value instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)value;
            if (compositeData.containsKey(searchProperty)) {
                value = compositeData.get(searchProperty);
            } else {
                LOG.debug((Object)("Unable to read attribute property [" + propertyPath + "] from composite data value"));
            }
        } else {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equals(searchProperty)) continue;
                    value = pd.getReadMethod().invoke(value, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Unable to read property from measurement attribute [" + searchProperty + "] not found on [" + (value != null ? value.getClass().getSimpleName() : "null") + "]"));
            }
        }
        if (ps.length > 1) {
            value = ObjectUtil.lookupDeepAttributeProperty(value, ps[1]);
        }
        return value;
    }

    private ObjectUtil() {
    }
}

