/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.rhq.core.system.ProcessExecution;

public class ProcessExecutionUtility {
    private static final boolean OS_IS_WINDOWS = File.separatorChar == '\\';

    private ProcessExecutionUtility() {
    }

    public static ProcessExecution createProcessExecution(File file) {
        return ProcessExecutionUtility.createProcessExecution(null, file);
    }

    public static ProcessExecution createProcessExecution(String prefix, File file) {
        String executable;
        List<Object> prefixArgs = prefix != null ? Arrays.asList(prefix.split("[ \t]+")) : Collections.emptyList();
        ArrayList<Object> args = new ArrayList<Object>();
        if (OS_IS_WINDOWS && ProcessExecutionUtility.isBatchFile(file)) {
            executable = ProcessExecutionUtility.getCmdExeFile().getPath();
            args.add("/c");
            args.addAll(prefixArgs);
            args.add(file.getPath());
        } else if (prefixArgs.isEmpty()) {
            executable = file.getPath();
        } else {
            executable = (String)prefixArgs.get(0);
            if (prefixArgs.size() > 1) {
                args.addAll(prefixArgs.subList(1, prefixArgs.size()));
            }
            args.add(file.getPath());
        }
        ProcessExecution processExecution = new ProcessExecution(executable);
        processExecution.setArguments(args);
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>(System.getenv());
        processExecution.setEnvironmentVariables(envVars);
        processExecution.setWorkingDirectory(file.getParent());
        return processExecution;
    }

    private static boolean isBatchFile(File file) {
        return file.getName().matches(".*\\.((bat)|(cmd))$(?i)");
    }

    private static File getCmdExeFile() {
        String cmdExe = System.getenv("COMSPEC");
        if (cmdExe == null) {
            throw new RuntimeException("COMSPEC environment variable is not defined.");
        }
        File cmdExeFile = new File(cmdExe);
        if (!cmdExeFile.exists()) {
            throw new RuntimeException("COMSPEC environment variable specifies a non-existent path: " + cmdExe);
        }
        return cmdExeFile;
    }
}

