/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import mazz.i18n.Logger;
import org.jboss.remoting.InvokerLocator;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.client.CommandClient;
import org.rhq.enterprise.communications.command.client.JBossRemotingRemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandClient;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class CmdlineClient {
    private static final Logger LOG = CommI18NFactory.getLogger(CmdlineClient.class);
    private String m_commandName;
    private int m_commandVersion = 1;
    private Map<String, Object> m_params;
    private String[] m_packages;
    private String m_classname;
    private String m_locatorUri;
    private String m_subsystem = "RHQ";

    public static void main(String[] args) {
        try {
            CmdlineClient client = new CmdlineClient();
            CommandResponse response = client.issueCommand(args);
            LOG.debug("CmdlineClient.response", new Object[]{response});
        }
        catch (Throwable e) {
            String cmdline = "";
            for (int i = 0; i < args.length; ++i) {
                cmdline = cmdline + "'" + args[i] + "'";
                if (i + 1 >= args.length) continue;
                cmdline = cmdline + " ";
            }
            LOG.error(e, "CmdlineClient.execute-failure", new Object[]{cmdline});
        }
    }

    public CommandClient buildCommandClient(String[] args) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException {
        CommandClient commandClient;
        if (this.processCommandLine(args) != -1) {
            throw new IllegalArgumentException(LOG.getMsgString("CmdlineClient.process-args-failure", new Object[0]));
        }
        try {
            Class commandClientClazz = this.findCommandClientClass();
            commandClient = this.instantiateCommandClient(commandClientClazz);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.debug("CmdlineClient.using-generic-client", new Object[]{cnfe.getMessage()});
            try {
                GenericCommandClient customClient = new GenericCommandClient();
                customClient.setCommandType(new CommandType(this.m_commandName, this.m_commandVersion));
                commandClient = customClient;
            }
            catch (Exception e) {
                throw new ClassNotFoundException(cnfe.toString(), e);
            }
        }
        return commandClient;
    }

    public Command buildCommand(String[] args) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException {
        CommandClient commandClient = this.buildCommandClient(args);
        return commandClient.createNewCommand(this.m_params);
    }

    public CommandResponse issueCommand(String[] args) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, Throwable {
        CommandClient commandClient = this.buildCommandClient(args);
        if (this.m_locatorUri == null) {
            throw new MalformedURLException(LOG.getMsgString("CmdlineClient.null-uri", new Object[0]));
        }
        InvokerLocator invokerLocator = new InvokerLocator(this.m_locatorUri);
        JBossRemotingRemoteCommunicator communicator = new JBossRemotingRemoteCommunicator(invokerLocator, this.m_subsystem, null);
        commandClient.setRemoteCommunicator(communicator);
        CommandResponse response = commandClient.invoke(this.m_params);
        commandClient.disconnectRemoteCommunicator();
        return response;
    }

    public CommandResponse issueCommand(CommandType commandType, String locatorURI, Map<String, String> params) throws IllegalArgumentException, MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, Throwable {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-c");
        args.add(commandType.getName());
        args.add("-v");
        args.add("" + commandType.getVersion());
        args.add("-u");
        args.add(locatorURI);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String paramName = entry.getKey();
                String paramValue = entry.getValue();
                String paramNVP = paramName.toString();
                if (paramValue != null) {
                    paramNVP = paramNVP + "=" + paramValue;
                }
                args.add(paramNVP);
            }
        }
        return this.issueCommand(args.toArray(new String[args.size()]));
    }

    public CommandResponse issueCommand(CommandType commandType, String locatorURI) throws IllegalArgumentException, MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, Throwable {
        return this.issueCommand(commandType, locatorURI, null);
    }

    public String getUsage() {
        return LOG.getMsgString("CmdlineClient.usage", new Object[0]);
    }

    private int processCommandLine(String[] args) {
        int code;
        int exitCode = -1;
        this.m_params = new HashMap<String, Object>();
        String programName = System.getProperty("program.name", this.getClass().getName());
        String sopts = "-:hv:p:c:l:u:s:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("pkgs", 1, null, 112), new LongOpt("cmd", 1, null, 99), new LongOpt("version", 1, null, 118), new LongOpt("class", 1, null, 108), new LongOpt("uri", 1, null, 117), new LongOpt("subsystem", 1, null, 115)};
        Getopt getopt = new Getopt(programName, args, sopts, lopts);
        block13: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    return 1;
                }
                case 1: {
                    String paramValue;
                    String paramName;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        paramName = arg;
                        paramValue = "true";
                    } else {
                        paramName = arg.substring(0, i);
                        paramValue = arg.substring(i + 1, arg.length());
                    }
                    this.m_params.put(paramName, paramValue);
                    LOG.debug("CmdlineClient.cmdline-param", new Object[]{programName, paramName, !"password".equalsIgnoreCase(paramName) ? paramValue : "*"});
                    continue block13;
                }
                case 104: {
                    System.out.println(programName + " " + this.getUsage());
                    System.out.println();
                    return 0;
                }
                case 118: {
                    String arg = getopt.getOptarg();
                    try {
                        this.m_commandVersion = new Integer(arg);
                        continue block13;
                    }
                    catch (NumberFormatException nfe) {
                        LOG.error("CmdlineClient.invalid-cmd-version", new Object[]{arg, nfe});
                        return 1;
                    }
                }
                case 112: {
                    String arg = getopt.getOptarg();
                    LOG.debug("CmdlineClient.packages", new Object[]{programName, arg});
                    ArrayList<String> packageList = new ArrayList<String>();
                    StringTokenizer strtok = new StringTokenizer(arg, ":");
                    while (strtok.hasMoreTokens()) {
                        packageList.add(strtok.nextToken());
                    }
                    this.m_packages = packageList.toArray(new String[packageList.size()]);
                    continue block13;
                }
                case 108: {
                    this.m_classname = getopt.getOptarg();
                    LOG.debug("CmdlineClient.classname", new Object[]{programName, this.m_classname});
                    continue block13;
                }
                case 99: {
                    this.m_commandName = getopt.getOptarg();
                    LOG.debug("CmdlineClient.command", new Object[]{programName, this.m_commandName});
                    continue block13;
                }
                case 117: {
                    this.m_locatorUri = getopt.getOptarg();
                    LOG.debug("CmdlineClient.locator-uri", new Object[]{programName, this.m_locatorUri});
                    continue block13;
                }
                case 115: {
                    this.m_subsystem = getopt.getOptarg();
                    LOG.debug("CmdlineClient.subsystem", new Object[]{programName, this.m_subsystem});
                    continue block13;
                }
            }
            throw new Error(LOG.getMsgString("CmdlineClient.unhandled-option", new Object[]{code}));
        }
        return exitCode;
    }

    private Class findCommandClientClass() throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.m_commandName == null) {
            throw new ClassNotFoundException(LOG.getMsgString("CmdlineClient.cannot-find-client", new Object[0]));
        }
        if (this.m_classname != null) {
            clazz = Class.forName(this.m_classname);
        } else {
            if (this.m_packages == null || this.m_packages.length == 0) {
                this.m_packages = new String[]{"org.rhq.enterprise.communications.command.impl", this.getClass().getPackage().getName()};
            }
            int lastDot = this.m_commandName.lastIndexOf(46);
            String lastElementCapitalized = Character.toUpperCase(this.m_commandName.charAt(lastDot + 1)) + this.m_commandName.substring(lastDot + 2);
            String commandClientClassName = lastElementCapitalized + "CommandClient";
            String classPostfix = "." + this.m_commandName.toLowerCase() + "." + commandClientClassName;
            String versionedClassPostfix = "." + this.m_commandName.toLowerCase() + ".v" + this.m_commandVersion + "." + commandClientClassName;
            String searchFailures = LOG.getMsgString("CmdlineClient.cannot-find-client-searched", new Object[0]);
            ArrayList<String> classesToCheck = new ArrayList<String>();
            for (int i = 0; i < this.m_packages.length && clazz == null; ++i) {
                int firstDot;
                String pkg = this.m_packages[i];
                classesToCheck.clear();
                if ("org.rhq.enterprise.communications.command.impl".equals(pkg) && (firstDot = this.m_commandName.indexOf(46)) > -1) {
                    String prefix = this.m_commandName.substring(0, firstDot);
                    String classPostfixWithoutPrefix = classPostfix.substring(firstDot + 1);
                    String versionedClassPostfixWithoutPrefix = versionedClassPostfix.substring(firstDot + 1);
                    classesToCheck.add("org.rhq.enterprise.communications." + prefix + ".command.impl" + classPostfixWithoutPrefix);
                    classesToCheck.add("org.rhq.enterprise.communications." + prefix + ".command.impl" + versionedClassPostfixWithoutPrefix);
                }
                classesToCheck.add(pkg + classPostfix);
                classesToCheck.add(pkg + versionedClassPostfix);
                Iterator iter = classesToCheck.iterator();
                while (iter.hasNext() && clazz == null) {
                    String classToFind = (String)iter.next();
                    try {
                        clazz = Class.forName(classToFind);
                    }
                    catch (ClassNotFoundException cnfe) {
                        searchFailures = searchFailures + " : " + classToFind;
                    }
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(searchFailures);
            }
        }
        return clazz;
    }

    private CommandClient instantiateCommandClient(Class commandClientClass) throws InstantiationException, IllegalAccessException {
        return (CommandClient)commandClientClass.newInstance();
    }
}

