/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandExecutor;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandResponse;
import org.rhq.enterprise.communications.command.server.CommandService;

public abstract class MultipleCommandService
extends CommandService {
    private Map<CommandType, CommandTypeExecutor> m_executors;

    @Override
    public CommandResponse execute(Command command, InputStream in, OutputStream out) {
        CommandResponse retResponse;
        CommandType commandTypeToExecute = command.getCommandType();
        CommandTypeExecutor typeExecutor = this.getExecutors().get(commandTypeToExecute);
        if (typeExecutor == null) {
            throw new IllegalArgumentException(this.getLog().getMsgString("MultipleCommandService.unknown-command-type", new Object[]{command}));
        }
        try {
            retResponse = typeExecutor.getExecutor().execute(command, null, null);
        }
        catch (Throwable t) {
            retResponse = new GenericCommandResponse(command, false, null, t);
        }
        return retResponse;
    }

    @Override
    public CommandType[] getSupportedCommandTypes() {
        Set<CommandType> executorCommandTypes = this.getExecutors().keySet();
        return executorCommandTypes.toArray(new CommandType[executorCommandTypes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<CommandType, CommandTypeExecutor> getExecutors() {
        if (this.m_executors == null) {
            MultipleCommandService multipleCommandService = this;
            synchronized (multipleCommandService) {
                this.m_executors = new HashMap<CommandType, CommandTypeExecutor>();
                CommandTypeExecutor[] supportedExecutors = this.getSupportedCommandTypeExecutors();
                for (int i = 0; i < supportedExecutors.length; ++i) {
                    this.m_executors.put(supportedExecutors[i].m_type, supportedExecutors[i]);
                }
            }
        }
        return this.m_executors;
    }

    protected abstract CommandTypeExecutor[] getSupportedCommandTypeExecutors();

    protected class CommandTypeExecutor {
        public final CommandType m_type;
        public final Class m_executorClass;
        private CommandExecutor m_executorInstance;

        public CommandTypeExecutor(CommandType type, Class executorClass) {
            if (type == null) {
                throw new IllegalArgumentException("type=null");
            }
            if (executorClass == null) {
                throw new IllegalArgumentException("executorClass=null");
            }
            boolean isAssignable = CommandExecutor.class.isAssignableFrom(executorClass);
            boolean isInterface = executorClass.isInterface();
            boolean isAbstract = Modifier.isAbstract(executorClass.getModifiers());
            boolean isRecursive = MultipleCommandService.class.isAssignableFrom(executorClass);
            if (!isAssignable || isInterface || isAbstract || isRecursive) {
                throw new IllegalArgumentException(MultipleCommandService.this.getLog().getMsgString("MultipleCommandService.invalid-executor-class", new Object[]{executorClass, CommandExecutor.class, MultipleCommandService.class}));
            }
            this.m_type = type;
            this.m_executorClass = executorClass;
            this.m_executorInstance = null;
        }

        public CommandTypeExecutor(CommandType type, CommandExecutor executorInstance) {
            if (type == null) {
                throw new IllegalArgumentException("type=null");
            }
            if (executorInstance == null) {
                throw new IllegalArgumentException("executorInstance=null");
            }
            if (executorInstance instanceof MultipleCommandService) {
                throw new IllegalArgumentException(MultipleCommandService.this.getLog().getMsgString("MultipleCommandService.invalid-executor-instance", new Object[]{executorInstance.getClass(), MultipleCommandService.class}));
            }
            this.m_type = type;
            this.m_executorClass = executorInstance.getClass();
            this.m_executorInstance = executorInstance;
        }

        public CommandExecutor getExecutor() {
            try {
                return this.m_executorInstance != null ? this.m_executorInstance : (CommandExecutor)this.m_executorClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(MultipleCommandService.this.getLog().getMsgString("MultipleCommandService.cannot-create-executor", new Object[0]), e);
            }
        }
    }
}

