/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util.prefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.prefs.Preferences;
import mazz.i18n.Logger;
import mazz.i18n.Msg;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.prefs.PromptInput;
import org.rhq.enterprise.communications.util.prefs.SetupInstruction;

public class Setup {
    private static final String INTERNAL_DEFAULT_PROMPT_VALUE = "!*";
    private static final String HELP_PROMPT_VALUE = "!?";
    private static final String STOP_PROMPT_VALUE = "!+";
    private static final String CANCEL_PROMPT_VALUE = "!-";
    private static final Logger LOG = CommI18NFactory.getLogger(Setup.class);
    private static final Msg MSG = CommI18NFactory.getMsg();
    private final Preferences m_preferences;
    private final String m_introMessage;
    private final List<SetupInstruction> m_instructions;
    private final PromptInput m_in;
    private final PrintWriter m_out;

    public Setup(Preferences preferences, String intro_message, List<SetupInstruction> instructions, PromptInput in, PrintWriter out) {
        this.m_preferences = preferences;
        this.m_introMessage = intro_message;
        this.m_instructions = instructions;
        this.m_in = in;
        this.m_out = out;
    }

    public Preferences getPreferences() {
        return this.m_preferences;
    }

    public String getIntroMessage() {
        return this.m_introMessage;
    }

    public List<SetupInstruction> getInstructions() {
        return this.m_instructions;
    }

    public PromptInput getIn() {
        return this.m_in;
    }

    public PrintWriter getOut() {
        return this.m_out;
    }

    public boolean setup() {
        PromptInput in = this.getIn();
        PrintWriter out = this.getOut();
        List<SetupInstruction> all_instructions = this.getInstructions();
        Preferences preferences = this.getPreferences();
        ByteArrayOutputStream backup = this.backupPreferences(preferences);
        if (all_instructions.size() > 0) {
            if (this.getIntroMessage() != null) {
                out.println(this.getIntroMessage());
            }
            out.println(MSG.getMsg("Setup.standard-intro", new Object[0]));
        }
        boolean user_stop = false;
        boolean user_cancel = false;
        for (SetupInstruction instruction : all_instructions) {
            LOG.debug("Setup.preprocess-instruction", new Object[]{instruction});
            instruction.setPreferences(preferences);
            instruction.preProcess();
            String pref_name = instruction.getPreferenceName();
            String default_value = instruction.getDefaultValue();
            String prompt_message = instruction.getPromptMessage();
            String help_message = instruction.getHelpMessage();
            boolean no_echo = instruction.isUsingNoEchoPrompt();
            String new_value = null;
            if (prompt_message != null) {
                boolean is_valid;
                do {
                    new_value = this.prompt(prompt_message, pref_name, help_message, default_value, in, out, no_echo);
                    is_valid = true;
                    if (new_value == null) continue;
                    if (new_value.length() > 0) {
                        user_stop = new_value.equals(STOP_PROMPT_VALUE);
                        user_cancel = new_value.equals(CANCEL_PROMPT_VALUE);
                        if (instruction.getValidityChecker() == null || user_stop || user_cancel) continue;
                        is_valid = instruction.getValidityChecker().checkValidity(pref_name, new_value, preferences, out);
                        continue;
                    }
                    new_value = default_value;
                } while (!is_valid);
                if (!user_stop && !user_cancel) {
                    LOG.debug("Setup.new-value", new Object[]{pref_name, new_value});
                }
            } else {
                new_value = default_value;
                LOG.debug("Setup.new-value-no-prompt", new Object[]{pref_name, new_value});
            }
            if (user_stop || user_cancel) break;
            if (new_value != null) {
                preferences.put(pref_name, new_value);
            } else {
                preferences.remove(pref_name);
            }
            LOG.debug("Setup.postprocess-instruction", new Object[]{instruction});
            instruction.postProcess();
        }
        if (user_stop) {
            out.println(MSG.getMsg("Setup.user-stop", new Object[]{preferences.absolutePath()}));
        } else if (user_cancel) {
            out.println(MSG.getMsg("Setup.user-cancel", new Object[]{preferences.absolutePath()}));
            this.restorePreferences(backup);
        } else {
            out.println(MSG.getMsg("Setup.complete", new Object[]{preferences.absolutePath()}));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup.complete-with-dump", new Object[]{this.preferencesDump(preferences)});
        }
        return !user_cancel;
    }

    protected String prompt(String prompt_message, String pref_name, String help_message, String default_value, PromptInput in, PrintWriter out, boolean no_echo) {
        String full_prompt = prompt_message + " [" + (default_value != null ? default_value : INTERNAL_DEFAULT_PROMPT_VALUE) + "] : ";
        String new_value = "";
        boolean keep_asking = true;
        while (keep_asking) {
            out.print(full_prompt);
            out.flush();
            try {
                new_value = no_echo ? in.readLineNoEcho() : in.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (new_value.equals(HELP_PROMPT_VALUE)) {
                out.println(help_message);
                out.println("(" + pref_name + ")");
                continue;
            }
            if (new_value.equals(INTERNAL_DEFAULT_PROMPT_VALUE)) {
                new_value = null;
                keep_asking = false;
                continue;
            }
            keep_asking = false;
        }
        return new_value;
    }

    protected String preferencesDump(Preferences prefs) {
        try {
            StringBuffer dump = new StringBuffer(prefs.toString() + '\n');
            String[] pref_keys = prefs.keys();
            for (int i = 0; i < pref_keys.length; ++i) {
                dump.append(pref_keys[i]);
                dump.append('=');
                dump.append(prefs.get(pref_keys[i], "<>"));
                dump.append('\n');
            }
            return dump.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private ByteArrayOutputStream backupPreferences(Preferences preferences) throws RuntimeException {
        try {
            ByteArrayOutputStream backup = new ByteArrayOutputStream();
            preferences.exportSubtree(backup);
            return backup;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void restorePreferences(ByteArrayOutputStream backup) throws RuntimeException {
        try {
            this.getPreferences().clear();
            Preferences.importPreferences(new ByteArrayInputStream(backup.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

