/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.util.ConnectionProviderFactory;
import org.rhq.plugins.jmx.util.JvmResourceKey;
import org.rhq.plugins.jmx.util.JvmUtility;

public class JMXDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet,
ResourceUpgradeFacet {
    private static final Log log = LogFactory.getLog(JMXDiscoveryComponent.class);
    public static final String COMMAND_LINE_CONFIG_PROPERTY = "commandLine";
    public static final String CONNECTOR_ADDRESS_CONFIG_PROPERTY = "connectorAddress";
    public static final String INSTALL_URI = "installURI";
    public static final String CONNECTION_TYPE = "type";
    public static final String PARENT_TYPE = "PARENT";
    public static final String ADDITIONAL_CLASSPATH_ENTRIES = "additionalClassPathEntries";
    private static final String SYSPROP_JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    private static final String SYSPROP_RHQ_JMXPLUGIN_PROCESS_FILTERS = "rhq.jmxplugin.process-filters";
    public static final String SYSPROP_RHQ_RESOURCE_KEY = "org.rhq.resourceKey";
    private static final String SYSPROP_JAVA_VERSION = "java.version";
    private static final String[] DEFAULT_PROCESS_EXCLUDES = new String[]{"org.rhq.enterprise.agent.AgentMain", "org.jboss.Main", "catalina.startup.Bootstrap", "org.apache.cassandra.thrift.CassandraDaemon", "org.apache.cassandra.service.CassandraDaemon"};

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        LinkedHashMap<String, ArrayList<DiscoveredResourceDetails>> duplicatesByKey = new LinkedHashMap<String, ArrayList<DiscoveredResourceDetails>>();
        List<ProcessScanResult> nonExcludedProcesses = this.getNonExcludedJavaProcesses(context);
        for (ProcessScanResult process : nonExcludedProcesses) {
            try {
                ProcessInfo processInfo = process.getProcessInfo();
                DiscoveredResourceDetails details = this.discoverResourceDetails(context, processInfo);
                if (details == null) continue;
                if (discoveredResources.contains(details)) {
                    ArrayList<DiscoveredResourceDetails> duplicates = (ArrayList<DiscoveredResourceDetails>)duplicatesByKey.get(details.getResourceKey());
                    if (duplicates == null) {
                        duplicates = new ArrayList<DiscoveredResourceDetails>();
                        duplicatesByKey.put(details.getResourceKey(), duplicates);
                    }
                    duplicates.add(details);
                }
                discoveredResources.add(details);
            }
            catch (RuntimeException re) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error when trying to discover JVM process [" + process + "]."), (Throwable)re);
                    continue;
                }
                log.warn((Object)("Error when trying to discover JVM process [" + process + "] (enable DEBUG for stack trace): " + re));
            }
        }
        for (String duplicateKey : duplicatesByKey.keySet()) {
            List duplicates = (List)duplicatesByKey.get(duplicateKey);
            log.error((Object)("Multiple Resources with the same key (" + duplicateKey + ") were discovered - none will be reported to the plugin container! This most likely means that there are multiple java processes running with the same value for the " + SYSPROP_RHQ_RESOURCE_KEY + " system property specified on their command lines. Here is the list of Resources: " + duplicates));
            discoveredResources.remove(duplicates.get(0));
        }
        return discoveredResources;
    }

    private List<ProcessScanResult> getNonExcludedJavaProcesses(ResourceDiscoveryContext context) {
        List javaProcesses = context.getAutoDiscoveredProcesses();
        ArrayList<ProcessScanResult> nonExcludedJavaProcesses = new ArrayList<ProcessScanResult>();
        Set<String> processExcludes = this.getProcessExcludes();
        for (ProcessScanResult javaProcess : javaProcesses) {
            String[] args = javaProcess.getProcessInfo().getCommandLine();
            StringBuilder buffer = new StringBuilder();
            for (String arg : args) {
                buffer.append(arg).append(" ");
            }
            String commandLine = buffer.toString();
            if (!this.isExcluded(commandLine, processExcludes)) {
                nonExcludedJavaProcesses.add(javaProcess);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Process [" + javaProcess.getProcessInfo() + "] excluded since its command line contains one of the following: " + processExcludes));
        }
        return nonExcludedJavaProcesses;
    }

    private boolean isExcluded(String commandLine, Set<String> processExcludes) {
        for (String processExclude : processExcludes) {
            if (!commandLine.contains(processExclude)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getProcessExcludes() {
        String overrideProcessExcludes = System.getProperty(SYSPROP_RHQ_JMXPLUGIN_PROCESS_FILTERS);
        HashSet<String> processExcludes = overrideProcessExcludes != null ? new HashSet<String>(Arrays.asList(overrideProcessExcludes.split(","))) : new HashSet<String>(Arrays.asList(DEFAULT_PROCESS_EXCLUDES));
        return processExcludes;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        EmsConnection connection;
        String type = pluginConfig.getSimple(CONNECTION_TYPE).getStringValue();
        if (type.equals(PARENT_TYPE)) {
            throw new InvalidPluginConfigurationException("'PARENT' is not a valid type for a manually added JVM.");
        }
        String connectorAddress = pluginConfig.getSimpleValue(CONNECTOR_ADDRESS_CONFIG_PROPERTY, null);
        if (connectorAddress == null) {
            throw new InvalidPluginConfigurationException("A connector address must be specified when manually adding a JVM.");
        }
        try {
            ConnectionProvider connectionProvider = ConnectionProviderFactory.createConnectionProvider(pluginConfig, null, discoveryContext.getParentResourceContext().getTemporaryDirectory());
            connection = connectionProvider.connect();
            connection.loadSynchronous(false);
        }
        catch (Exception e) {
            if (e.getCause() instanceof SecurityException) {
                throw new InvalidPluginConfigurationException("Failed to authenticate to JVM with connector address [" + connectorAddress + "] - principal and/or credentials connection properties are not set correctly.");
            }
            throw new RuntimeException("Failed to connect to JVM with connector address [" + connectorAddress + "].", e);
        }
        String key = connectorAddress;
        String name = connectorAddress;
        String version = this.getJavaVersion(connection);
        if (version == null) {
            log.warn((Object)("Unable to determine version of JVM with connector address [" + connectorAddress + "]."));
        }
        String connectionType = pluginConfig.getSimpleValue(CONNECTION_TYPE, null);
        String description = connectionType + " JVM (" + connectorAddress + ")";
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, description, pluginConfig, null);
        return resourceDetails;
    }

    private String getJavaVersion(EmsConnection connection) {
        String version = null;
        try {
            EmsBean runtimeMXBean = connection.getBean("java.lang:type=Runtime");
            if (runtimeMXBean != null) {
                EmsAttribute systemPropertiesAttribute = runtimeMXBean.getAttribute("systemProperties");
                TabularData systemProperties = (TabularData)systemPropertiesAttribute.getValue();
                CompositeData compositeData = systemProperties.get(new String[]{SYSPROP_JAVA_VERSION});
                if (compositeData != null) {
                    version = (String)compositeData.get("value");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("An error occurred while trying to determine Java version of remote JVM at [" + connection.getConnectionProvider().getConnectionSettings().getServerUrl() + "]."), (Throwable)e);
        }
        return version;
    }

    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext<ResourceComponent<?>> context, DiscoveredResourceDetails details) throws Exception {
        List<File> jars = ConnectionProviderFactory.getAdditionalJarsFromConfig(details.getPluginConfiguration());
        if (jars == null || jars.isEmpty()) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(jars.size());
        for (File jar : jars) {
            urls.add(jar.toURI().toURL());
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceUpgradeReport upgrade(ResourceUpgradeContext inventoriedResource) {
        JvmResourceKey oldKey = JvmResourceKey.valueOf(inventoriedResource.getResourceKey());
        JvmResourceKey.Type oldKeyType = oldKey.getType();
        if (oldKeyType == JvmResourceKey.Type.Legacy || oldKeyType == JvmResourceKey.Type.JmxRemotingPort) {
            Long pid;
            JMXServiceURL jmxServiceURL;
            if (!inventoriedResource.getSystemInformation().isNative()) {
                log.warn((Object)("Cannot attempt to upgrade Resource key [" + inventoriedResource.getResourceKey() + "] of JVM Resource, because this Agent is not running with native system info support (i.e. SIGAR)."));
                return null;
            }
            Configuration pluginConfig = inventoriedResource.getPluginConfiguration();
            String connectorAddress = pluginConfig.getSimpleValue(CONNECTOR_ADDRESS_CONFIG_PROPERTY, null);
            try {
                jmxServiceURL = new JMXServiceURL(connectorAddress);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to parse connector address: " + connectorAddress, e);
            }
            JMXConnector jmxConnector = null;
            try {
                jmxConnector = JMXDiscoveryComponent.connect(jmxServiceURL);
                MBeanServerConnection mbeanServerConnection = jmxConnector.getMBeanServerConnection();
                RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(mbeanServerConnection, "java.lang:type=Runtime", RuntimeMXBean.class);
                pid = JMXDiscoveryComponent.getJvmPid(runtimeMXBean);
                if (pid == null) {
                    throw new RuntimeException("Failed to determine JVM pid by parsing JVM name.");
                }
            }
            catch (SecurityException e) {
                log.info((Object)("Unable to upgrade key of JVM Resource with key [" + inventoriedResource.getResourceKey() + "], since authenticating to its JMX service URL [" + jmxServiceURL + "] failed: " + e.getMessage()));
                ResourceUpgradeReport runtimeMXBean = null;
                return runtimeMXBean;
            }
            catch (IOException e) {
                log.debug((Object)("Unable to upgrade key of JVM Resource with key [" + inventoriedResource.getResourceKey() + "], since connecting to its JMX service URL [" + jmxServiceURL + "] failed: " + e));
                ResourceUpgradeReport runtimeMXBean = null;
                return runtimeMXBean;
            }
            finally {
                this.close(jmxConnector);
            }
            List processes = inventoriedResource.getSystemInformation().getProcesses("process|pid|match=" + pid);
            if (processes.size() != 1) {
                throw new IllegalStateException("Failed to find process with PID [" + pid + "].");
            }
            ProcessInfo process = (ProcessInfo)processes.get(0);
            String mainClassName = this.getJavaMainClassName(process);
            String explicitKeyValue = this.getSystemPropertyValue(process, SYSPROP_RHQ_RESOURCE_KEY);
            if (oldKeyType == JvmResourceKey.Type.Legacy || explicitKeyValue != null) {
                JvmResourceKey newKey = explicitKeyValue != null ? JvmResourceKey.fromExplicitValue(mainClassName, explicitKeyValue) : JvmResourceKey.fromJmxRemotingPort(mainClassName, oldKey.getJmxRemotingPort());
                ResourceUpgradeReport resourceUpgradeReport = new ResourceUpgradeReport();
                resourceUpgradeReport.setNewResourceKey(newKey.toString());
                return resourceUpgradeReport;
            }
        }
        return null;
    }

    private void close(JMXConnector jmxConnector) {
        try {
            if (jmxConnector != null) {
                jmxConnector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Long getJvmPid(RuntimeMXBean runtimeMXBean) {
        String jvmName = runtimeMXBean.getName();
        int atIndex = jvmName.indexOf(64);
        Long pid = atIndex != -1 ? Long.valueOf(jvmName.substring(0, atIndex)) : null;
        return pid;
    }

    protected DiscoveredResourceDetails discoverResourceDetails(ResourceDiscoveryContext context, ProcessInfo process) {
        Integer jmxRemotingPort = this.getJmxRemotingPort(process);
        JMXServiceURL jmxServiceURL = null;
        if (jmxRemotingPort != null) {
            try {
                jmxServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://127.0.0.1:" + jmxRemotingPort + "/jmxrmi");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            String keyString = this.getSystemPropertyValue(process, SYSPROP_RHQ_RESOURCE_KEY);
            if (keyString != null && !keyString.equals("") && (jmxServiceURL = JvmUtility.extractJMXServiceURL(process)) == null) {
                return null;
            }
        }
        log.debug((Object)("JMX service URL for java process [" + process + "] is [" + jmxServiceURL + "]."));
        return this.buildResourceDetails(context, process, jmxServiceURL, jmxRemotingPort);
    }

    protected DiscoveredResourceDetails buildResourceDetails(ResourceDiscoveryContext context, ProcessInfo process, JMXServiceURL jmxServiceURL, Integer jmxRemotingPort) {
        JvmResourceKey key = this.buildResourceKey(process, jmxRemotingPort);
        if (key == null) {
            return null;
        }
        String name = this.buildResourceName(key);
        String version = this.getJavaVersion(process, jmxServiceURL);
        String description = "JVM, monitored via " + (jmxRemotingPort != null ? "JMX Remoting" : "Sun JVM Attach API");
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        pluginConfig.put((Property)new PropertySimple(CONNECTION_TYPE, (Object)J2SE5ConnectionTypeDescriptor.class.getName()));
        if (jmxRemotingPort != null) {
            pluginConfig.put((Property)new PropertySimple(CONNECTOR_ADDRESS_CONFIG_PROPERTY, (Object)jmxServiceURL));
        }
        return new DiscoveredResourceDetails(context.getResourceType(), key.toString(), name, version, description, pluginConfig, process);
    }

    private JvmResourceKey buildResourceKey(ProcessInfo process, Integer jmxRemotingPort) {
        JvmResourceKey key;
        String mainClassName = this.getJavaMainClassName(process);
        String keyString = this.getSystemPropertyValue(process, SYSPROP_RHQ_RESOURCE_KEY);
        if (keyString != null && !keyString.equals("")) {
            log.debug((Object)("Using explicitly specified Resource key: [" + keyString + "]..."));
            key = JvmResourceKey.fromExplicitValue(mainClassName, keyString);
        } else if (jmxRemotingPort != null) {
            log.debug((Object)("Using JMX remoting port [" + jmxRemotingPort + "] as Resource key..."));
            key = JvmResourceKey.fromJmxRemotingPort(mainClassName, jmxRemotingPort);
        } else {
            log.debug((Object)("Process [" + process.getPid() + "] with command line [" + Arrays.asList(process.getCommandLine()) + "] cannot be discovered, because it does not specify either of the following system properties: " + "-D" + SYSPROP_JMXREMOTE_PORT + "=12345, -D" + SYSPROP_RHQ_RESOURCE_KEY + "=UNIQUE_KEY"));
            key = null;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJavaVersion(ProcessInfo process, JMXServiceURL jmxServiceURL) {
        JMXConnector jmxConnector = null;
        try {
            jmxConnector = JMXDiscoveryComponent.connect(jmxServiceURL);
            String string = this.getJavaVersion(jmxConnector);
            return string;
        }
        catch (SecurityException e) {
            log.warn((Object)("Unable to to authenticate to JMX service URL [" + jmxServiceURL + "]: " + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("Failed to connect to JMX service URL [" + jmxServiceURL + "]."), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Failed to determine JVM version for process [" + process.getPid() + "] with command line [" + Arrays.asList(process.getCommandLine()) + "]."), (Throwable)e);
        }
        finally {
            this.close(jmxConnector);
        }
        return null;
    }

    protected String getJavaVersion(JMXConnector jmxConnector) throws Exception {
        MBeanServerConnection mbeanServerConnection = jmxConnector.getMBeanServerConnection();
        RuntimeMXBean runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(mbeanServerConnection, "java.lang:type=Runtime", RuntimeMXBean.class);
        String version = runtimeMXBean.getSystemProperties().get(SYSPROP_JAVA_VERSION);
        if (version == null) {
            throw new IllegalStateException("System property [java.version] is not defined.");
        }
        return version;
    }

    private static JMXConnector connect(JMXServiceURL jmxServiceURL) throws IOException {
        JMXConnector jmxConnector;
        try {
            jmxConnector = JMXConnectorFactory.connect(jmxServiceURL);
        }
        catch (IOException e) {
            throw new IOException("Failed to connect to JMX service URL [" + jmxServiceURL + "].");
        }
        return jmxConnector;
    }

    private String buildResourceName(JvmResourceKey key) {
        StringBuilder name = new StringBuilder();
        String mainClassName = key.getMainClassName();
        if (mainClassName != null) {
            if (mainClassName.length() <= 200) {
                name.append(mainClassName);
            } else {
                name.append(mainClassName.substring(mainClassName.length() - 200));
            }
        }
        switch (key.getType()) {
            case Legacy: {
                name.append("JMX Server (" + key.getJmxRemotingPort() + ")");
                break;
            }
            case ConnectorAddress: {
                name.append(key.getConnectorAddress());
                break;
            }
            case JmxRemotingPort: {
                name.append(':').append(key.getJmxRemotingPort());
                break;
            }
            case Explicit: {
                name.append(' ').append(key.getExplicitValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported key type: " + (Object)((Object)key.getType()));
            }
        }
        return name.toString();
    }

    protected String getJavaMainClassName(ProcessInfo process) {
        String className = null;
        for (int i = 1; i < process.getCommandLine().length; ++i) {
            String arg = process.getCommandLine()[i];
            if (!arg.startsWith("-")) {
                className = arg;
                break;
            }
            if (!arg.equals("-cp") && !arg.equals("-classpath")) continue;
            ++i;
        }
        return className;
    }

    protected Integer getJmxRemotingPort(ProcessInfo process) {
        String value = this.getSystemPropertyValue(process, SYSPROP_JMXREMOTE_PORT);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected String getSystemPropertyValue(ProcessInfo process, String systemPropertyName) {
        for (String argument : process.getCommandLine()) {
            String prefix = "-D" + systemPropertyName + "=";
            if (!argument.startsWith(prefix)) continue;
            return argument.substring(prefix.length());
        }
        return null;
    }
}

