/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.SQLException;
import org.rhq.core.db.setup.SqlDataSet;
import org.rhq.core.db.setup.Table;

class SQLServerSqlDataSet
extends SqlDataSet {
    protected SQLServerSqlDataSet(Table table) throws SQLException {
        super(table);
    }

    @Override
    protected void executePreCreateCommands() throws SQLException {
        this.doSQL("SET IDENTITY_INSERT " + this.getTableName() + " ON");
    }

    @Override
    protected void executePostCreateCommands() throws SQLException {
        this.doSQL("SET IDENTITY_INSERT " + this.getTableName() + " OFF");
    }

    @Override
    protected void doSQL(String sql) throws SQLException {
        block2: {
            try {
                super.doSQL(sql);
            }
            catch (SQLException sqle) {
                if (this.identityDoesNotExist(sqle)) break block2;
                throw sqle;
            }
        }
    }

    private boolean identityDoesNotExist(SQLException sqle) {
        String errorMessage = sqle.getMessage().toLowerCase();
        return errorMessage.indexOf("does not have the identity property") != -1;
    }
}

