/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cron;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.augeas.Augeas;
import net.augeas.AugeasException;
import org.rhq.augeas.util.GlobFilter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.AugeasConfigurationDiscoveryComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;
import org.rhq.plugins.platform.PlatformComponent;

public class CronComponent
extends AugeasConfigurationComponent<PlatformComponent>
implements CreateChildResourceFacet {
    private static final String HOURLY_JOBS_PROP = "hourlyJobs";
    private static final String HOURLY_JOBS_NODE = "entry[time/minute != \"*\" and time/hour = \"*\" and time/dayofmonth = \"*\" and time/month = \"*\" and time/dayofweek = \"*\"]";
    private static final String DAILY_JOBS_PROP = "dailyJobs";
    private static final String DAILY_JOBS_NODE = "entry[time/minute != \"*\" and time/hour != \"*\" and time/dayofmonth = \"*\" and time/month = \"*\" and time/dayofweek = \"*\"]";
    private static final String WEEKLY_JOBS_PROP = "weeklyJobs";
    private static final String WEEKLY_JOBS_NODE = "entry[time/minute != \"*\" and time/hour != \"*\" and time/dayofmonth = \"*\" and time/month = \"*\" and time/dayofweek != \"*\"]";
    private static final String MONTHLY_JOBS_PROP = "monthlyJobs";
    private static final String MONTHLY_JOBS_NODE = "entry[time/minute != \"*\" and time/hour != \"*\" and time/dayofmonth != \"*\" and time/month = \"*\" and time/dayofweek = \"*\"]";
    private static final String YEARLY_JOBS_PROP = "yearlyJobs";
    private static final String YEARLY_JOBS_NODE = "entry[time/minute != \"*\" and time/hour != \"*\" and time/dayofmonth != \"*\" and time/month != \"*\" and time/dayofweek = \"*\"]";
    private static final String CRONTAB_PROP = "crontab";
    private static final String CRONTAB_NODE = "..";
    private static final String AUGEAS_FILES_PREFIX = "/files";
    private static final int AUGEAS_FILES_PREFIX_LENGTH = "/files".length();
    private static final String CRONTAB_RESOURCE_TYPE_NAME = "Cron Tab";

    protected String getResourceConfigurationRootPath() {
        return "/files/";
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        if (CRONTAB_RESOURCE_TYPE_NAME.equals(report.getResourceType().getName())) {
            try {
                String resourceKey = this.createCrontab(report.getUserSpecifiedResourceName(), report.getResourceType().getResourceConfigurationDefinition(), report.getResourceConfiguration());
                report.setResourceName(resourceKey);
                report.setResourceKey(resourceKey);
                report.setStatus(CreateResourceStatus.SUCCESS);
            }
            catch (Exception e) {
                report.setException((Throwable)e);
                report.setStatus(CreateResourceStatus.FAILURE);
            }
        } else {
            report.setErrorMessage("Don't know how to create resource of type " + report.getResourceType().getName());
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        return report;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setErrorMessage("This is a readonly view of cron tabs. Update isn't supported.");
        report.setStatus(ConfigurationUpdateStatus.FAILURE);
    }

    protected String getAugeasPathRelativeToParent(PropertyDefinition propDef, AugeasNode parentNode, Augeas augeas) {
        String name = propDef.getName();
        if (CRONTAB_PROP.equals(name)) {
            return CRONTAB_NODE;
        }
        if (HOURLY_JOBS_PROP.equals(name)) {
            return HOURLY_JOBS_NODE;
        }
        if (DAILY_JOBS_PROP.equals(name)) {
            return DAILY_JOBS_NODE;
        }
        if (WEEKLY_JOBS_PROP.equals(name)) {
            return WEEKLY_JOBS_NODE;
        }
        if (MONTHLY_JOBS_PROP.equals(name)) {
            return MONTHLY_JOBS_NODE;
        }
        if (YEARLY_JOBS_PROP.equals(name)) {
            return YEARLY_JOBS_NODE;
        }
        return super.getAugeasPathRelativeToParent(propDef, parentNode, augeas);
    }

    protected Object toPropertyValue(PropertyDefinitionSimple propDefSimple, Augeas augeas, AugeasNode node) {
        if (CRONTAB_PROP.equals(propDefSimple.getName())) {
            return this.getEntryCrontabPath(node);
        }
        return super.toPropertyValue(propDefSimple, augeas, node);
    }

    private String getEntryCrontabPath(AugeasNode crontabNode) {
        return crontabNode.getParent().getParent().getPath().substring(AUGEAS_FILES_PREFIX_LENGTH);
    }

    private String createCrontab(String resourceName, ConfigurationDefinition configurationDefinition, Configuration resourceConfiguration) {
        File crontabFile = new File(resourceName);
        try {
            if (!crontabFile.createNewFile()) {
                throw new RuntimeException("File " + resourceName + " already exists. Creating the crontab would overwrite it.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the crontab file named: " + resourceName);
        }
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        List includeGlobs = AugeasConfigurationDiscoveryComponent.getGlobList((PropertySimple)pluginConfiguration.getSimple("configurationFilesInclusionPatterns"));
        List excludeGlobs = AugeasConfigurationDiscoveryComponent.getGlobList((PropertySimple)pluginConfiguration.getSimple("configurationFilesExclusionPatterns"));
        boolean isIncluded = false;
        for (String include : includeGlobs) {
            if (!new GlobFilter(include).accept(crontabFile)) continue;
            isIncluded = true;
            break;
        }
        String errorText = "Given Cron tab file name would be created outside of mapped filters. See the Cron resource connection properties for the inclusion and exclusion filters set up.";
        if (!isIncluded) {
            throw new IllegalArgumentException(errorText);
        }
        for (String exclude : excludeGlobs) {
            if (!new GlobFilter(exclude).accept(crontabFile)) continue;
            throw new IllegalArgumentException(errorText);
        }
        this.updateCrontab(resourceName, configurationDefinition, resourceConfiguration);
        return resourceName;
    }

    protected void updateCrontab(String crontabPath, ConfigurationDefinition crontabConfigurationDefinition, Configuration crontabConfiguration) {
        Augeas augeas = null;
        try {
            augeas = this.getAugeas();
            File crontabFile = new File(crontabPath);
            String basePath = AUGEAS_FILES_PREFIX + crontabFile.getAbsolutePath();
            AugeasNode baseNode = new AugeasNode(basePath);
            PropertyList entries = crontabConfiguration.getList("entries");
            PropertyDefinitionList entriesDef = crontabConfigurationDefinition.getPropertyDefinitionList("entries");
            this.setNodeFromPropertyList(entriesDef, entries, augeas, baseNode);
            PropertyList settings = crontabConfiguration.getList("environmentSettings");
            if (settings != null) {
                for (Property p : settings.getList()) {
                    PropertyMap setting = (PropertyMap)p;
                    String name = setting.getSimpleValue("name", null);
                    String value = setting.getSimpleValue("value", "");
                    if (name == null) continue;
                    String settingPath = basePath + AugeasNode.SEPARATOR + name;
                    augeas.set(settingPath, value);
                }
            }
            augeas.save();
        }
        catch (AugeasException e) {
            if (augeas != null) {
                throw new RuntimeException(this.summarizeAugeasError(augeas), e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.close();
        }
    }
}

