/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system.pquery;

import org.rhq.core.system.pquery.Attribute;

class Conditional {
    private char separator = (char)124;
    private final Category category;
    private final Attribute attribute;
    private final Operator operator;
    private final Qualifier qualifier;

    Conditional(String conditional) {
        String[] tokens;
        char possibleSeparator = conditional.charAt(0);
        if (!Character.isLetter(possibleSeparator)) {
            this.separator = possibleSeparator;
            conditional = conditional.substring(1);
        }
        if ((tokens = conditional.split("\\" + this.separator, 4)).length < 3 || tokens.length > 4) {
            throw new IllegalArgumentException("Conditional needs a category, attribute and operator: " + conditional);
        }
        String categoryString = tokens[0];
        String attributeString = tokens[1];
        String operatorString = tokens[2];
        String qualifierString = tokens.length == 4 ? tokens[3] : null;
        try {
            this.category = Category.valueOf(categoryString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid category: " + conditional);
        }
        this.attribute = new Attribute(attributeString, this.category);
        try {
            this.operator = Operator.valueOf(operatorString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid operator: " + conditional);
        }
        if (qualifierString != null) {
            try {
                this.qualifier = Qualifier.valueOf(qualifierString);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid qualifier: " + qualifierString);
            }
        } else {
            this.qualifier = Qualifier.unspecified;
        }
    }

    Category getCategory() {
        return this.category;
    }

    Attribute getAttribute() {
        return this.attribute;
    }

    Operator getOperator() {
        return this.operator;
    }

    Qualifier getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        String str = "" + (Object)((Object)this.category) + this.separator + this.attribute + this.separator + (Object)((Object)this.operator);
        if (this.qualifier != null) {
            str = str + "" + this.separator + (Object)((Object)this.qualifier);
        }
        return str;
    }

    static enum Qualifier {
        unspecified,
        parent;

    }

    static enum Operator {
        match,
        nomatch;

    }

    static enum Category {
        process,
        arg;

    }
}

