/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system.pquery;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.pquery.Attribute;
import org.rhq.core.system.pquery.Conditional;
import org.rhq.core.system.pquery.Criteria;
import org.rhq.core.system.pquery.Operation;

public class ProcessInfoQuery {
    private static final Log log = LogFactory.getLog(ProcessInfoQuery.class);
    private final Map<Long, ProcessInfo> allProcesses;

    public ProcessInfoQuery(List<ProcessInfo> processes) {
        this.allProcesses = new HashMap<Long, ProcessInfo>(processes.size());
        for (ProcessInfo process : processes) {
            this.allProcesses.put(process.getPid(), process);
        }
    }

    public List<ProcessInfo> getProcesses() {
        return new ArrayList<ProcessInfo>(this.allProcesses.values());
    }

    public List<ProcessInfo> query(String query) {
        List<Criteria> criteriaList = this.getCriteriaList(query);
        if (criteriaList.size() == 0) {
            return new ArrayList<ProcessInfo>();
        }
        HashMap<Long, ProcessInfo> queryResults = new HashMap<Long, ProcessInfo>(this.allProcesses);
        for (Criteria criteria : criteriaList) {
            Map<Long, ProcessInfo> criteriaResults;
            if (criteria.getConditional().getCategory().equals((Object)Conditional.Category.process)) {
                criteriaResults = this.doProcessCriteriaQuery(criteria);
            } else if (criteria.getConditional().getCategory().equals((Object)Conditional.Category.arg)) {
                criteriaResults = this.doArgCriteriaQuery(criteria);
            } else {
                throw new IllegalArgumentException("Unknown category: " + criteria);
            }
            HashSet pids = new HashSet(queryResults.keySet());
            for (Long pid : pids) {
                if (criteriaResults.containsKey(pid)) continue;
                queryResults.remove(pid);
            }
            if (queryResults.size() != 0) continue;
            break;
        }
        ArrayList<ProcessInfo> results = new ArrayList<ProcessInfo>(queryResults.size());
        results.addAll(queryResults.values());
        return results;
    }

    private Map<Long, ProcessInfo> doArgCriteriaQuery(Criteria criteria) {
        HashMap<Long, ProcessInfo> matches = new HashMap<Long, ProcessInfo>();
        Attribute attribute = criteria.getConditional().getAttribute();
        Operation op = new Operation(criteria.getConditional().getOperator());
        Conditional.Qualifier qualifier = criteria.getConditional().getQualifier();
        String operand1 = null;
        String operand2 = criteria.getValue();
        block0: for (ProcessInfo process : this.getProcesses()) {
            ProcessInfo processToMatch = qualifier.equals((Object)Conditional.Qualifier.parent) ? this.getParentProcess(process) : process;
            String[] cmdline = processToMatch != null ? processToMatch.getCommandLine() : null;
            if (cmdline == null || cmdline.length == 0) continue;
            if (attribute.getAttributeValue().equals("*")) {
                for (String arg : cmdline) {
                    operand1 = arg;
                    if (!op.doOperation(operand1, operand2)) continue;
                    matches.put(process.getPid(), process);
                    continue block0;
                }
                continue;
            }
            if (attribute.getAttributeValueAsInteger() != null) {
                int attributeIndex = attribute.getAttributeValueAsInteger();
                if (attributeIndex < 0) {
                    attributeIndex = cmdline.length - 1;
                }
                if (cmdline.length - 1 < attributeIndex || !op.doOperation(operand1 = cmdline[attributeIndex], operand2)) continue;
                matches.put(process.getPid(), process);
                continue;
            }
            String attributeName = attribute.getAttributeValue();
            for (int i = 0; i < cmdline.length; ++i) {
                String arg = cmdline[i];
                if (!arg.startsWith(attributeName)) continue;
                if (arg.equals(attributeName)) {
                    operand1 = i + 1 < cmdline.length ? cmdline[i + 1] : "";
                } else {
                    int equals = arg.indexOf(61);
                    if (equals == -1) continue;
                    String string = operand1 = arg.length() > equals + 1 ? arg.substring(equals + 1) : "";
                }
                if (!op.doOperation(operand1, operand2)) continue;
                matches.put(process.getPid(), process);
                continue block0;
            }
        }
        return matches;
    }

    private Map<Long, ProcessInfo> doProcessCriteriaQuery(Criteria criteria) {
        HashMap<Long, ProcessInfo> matches = new HashMap<Long, ProcessInfo>();
        Attribute attribute = criteria.getConditional().getAttribute();
        Operation op = new Operation(criteria.getConditional().getOperator());
        Conditional.Qualifier qualifier = criteria.getConditional().getQualifier();
        String pidfileContentsCache = null;
        for (ProcessInfo process : this.getProcesses()) {
            String operand2;
            String operand1;
            ProcessInfo processToMatch = qualifier.equals((Object)Conditional.Qualifier.parent) ? this.getParentProcess(process) : process;
            if (attribute.getAttributeValue().equals(Attribute.ProcessCategoryAttributes.name.toString())) {
                operand1 = processToMatch != null ? processToMatch.getName() : "";
                operand2 = criteria.getValue();
            } else if (attribute.getAttributeValue().equals(Attribute.ProcessCategoryAttributes.basename.toString())) {
                operand1 = processToMatch != null ? processToMatch.getBaseName() : "";
                operand2 = criteria.getValue();
            } else if (attribute.getAttributeValue().equals(Attribute.ProcessCategoryAttributes.pid.toString())) {
                operand1 = processToMatch != null ? Long.toString(processToMatch.getPid()) : "";
                operand2 = criteria.getValue();
            } else if (attribute.getAttributeValue().equals(Attribute.ProcessCategoryAttributes.pidfile.toString())) {
                if (pidfileContentsCache == null) {
                    pidfileContentsCache = this.getPidfileContents(criteria.getValue());
                }
                operand1 = processToMatch != null ? String.valueOf(processToMatch.getPid()) : null;
                operand2 = pidfileContentsCache;
            } else {
                throw new IllegalArgumentException("Criteria with 'process' category must have an attribute of either 'name' or 'basename': " + criteria);
            }
            if (!op.doOperation(operand1, operand2)) continue;
            matches.put(process.getPid(), process);
        }
        return matches;
    }

    private ProcessInfo getParentProcess(ProcessInfo child) {
        ProcessInfo parent = null;
        if (child != null) {
            parent = this.allProcesses.get(child.getParentPid());
        }
        return parent;
    }

    private List<Criteria> getCriteriaList(String query) {
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        if (query != null) {
            String[] tokens;
            for (String criteriaString : tokens = query.split(",")) {
                Criteria c = new Criteria(criteriaString);
                criteria.add(c);
            }
        }
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPidfileContents(String pidfileName) {
        String contents;
        try {
            FileInputStream fis = new FileInputStream(pidfileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            try {
                contents = br.readLine();
                if (contents == null) {
                    throw new IOException("empty pid");
                }
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            log.trace((Object)"pid not found");
            return "";
        }
        catch (IOException e) {
            log.warn((Object)("unable to read pid file " + pidfileName), (Throwable)e);
            return "";
        }
        return contents.trim();
    }
}

