/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.content.ContentManagerRemote;

public class ContentUploader {
    private static final int SIZE_32K = 32768;
    private ContentManagerRemote contentManager;

    public ContentUploader(ContentManagerRemote contentManager) {
        this.contentManager = contentManager;
    }

    public String upload(String filename) {
        if (StringUtil.isBlank((String)filename)) {
            throw new IllegalArgumentException("Empty path");
        }
        return this.upload(new File(filename));
    }

    public String upload(File file) {
        String string;
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File expected, found directory: " + file.getAbsolutePath());
        }
        String temporaryContentHandle = this.contentManager.createTemporaryContentHandle();
        FileInputStream fileInputStream = null;
        try {
            int len;
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 32768);
            byte[] bytes = new byte[32768];
            while ((len = bufferedInputStream.read(bytes, 0, bytes.length)) != -1) {
                this.contentManager.uploadContentFragment(temporaryContentHandle, bytes, 0, len);
            }
            string = temporaryContentHandle;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not upload content fragment", e);
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(fileInputStream);
                throw throwable;
            }
        }
        StreamUtil.safeClose((Closeable)fileInputStream);
        return string;
    }
}

