/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.SigarException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.EmsInvocationException;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.cassandra.util.ConfigEditor;
import org.rhq.cassandra.util.ConfigEditorException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.cassandra.util.KeyspaceService;
import org.rhq.plugins.storage.InternodeAuthConfUpdateException;
import org.rhq.plugins.storage.StorageNodeConfigDelegate;
import org.yaml.snakeyaml.error.YAMLException;

public class StorageNodeComponent
extends CassandraNodeComponent
implements OperationFacet,
ConfigurationFacet {
    private Log log = LogFactory.getLog(StorageNodeComponent.class);
    private static final String SYSTEM_AUTH_KEYSPACE = "system_auth";
    private static final String RHQ_KEYSPACE = "rhq";
    private static final String SYSTEM_KEYSPACE = "system";

    public Configuration loadResourceConfiguration() throws Exception {
        return new StorageNodeConfigDelegate(this.getBasedir(), this).loadResourceConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        StorageNodeConfigDelegate configDelegate = new StorageNodeConfigDelegate(this.getBasedir(), this);
        configDelegate.updateResourceConfiguration(configurationUpdateReport);
    }

    private OperationResult shutdownIfNecessary() {
        this.log.info((Object)("Shutting down " + this.getResourceContext().getResourceKey()));
        ProcessInfo process = this.getResourceContext().getNativeProcess();
        if (process == null) {
            File pidFile = new File(this.getBinDir(), "cassandra.pid");
            if (pidFile.exists()) {
                return this.shutdownStorageNode();
            }
            return new OperationResult("Storage node is not running");
        }
        return this.shutdownStorageNode();
    }

    private File getBasedir() {
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        return new File(pluginConfig.getSimpleValue("baseDir"));
    }

    private File getBinDir() {
        return new File(this.getBasedir(), "bin");
    }

    private File getConfDir() {
        return new File(this.getBasedir(), "conf");
    }

    private File getInternodeAuthConfFile() {
        return new File(this.getConfDir(), "rhq-storage-auth.conf");
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("addNodeMaintenance")) {
            return this.nodeAdded(parameters);
        }
        if (name.equals("removeNodeMaintenance")) {
            return this.nodeRemoved(parameters);
        }
        if (name.equals("prepareForUpgrade")) {
            return this.prepareForUpgrade(parameters);
        }
        if (name.equals("repair")) {
            return this.repair();
        }
        if (name.equals("updateConfiguration")) {
            return this.updateConfiguration(parameters);
        }
        if (name.equals("announce")) {
            return this.announce(parameters);
        }
        if (name.equals("unannounce")) {
            return this.unannounce(parameters);
        }
        if (name.equals("prepareForBootstrap")) {
            return this.prepareForBootstrap(parameters);
        }
        if (name.equals("shutdown")) {
            return this.shutdownStorageNode();
        }
        if (name.equals("decommission")) {
            return this.decommission();
        }
        if (name.equals("uninstall")) {
            return this.uninstall();
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult shutdownStorageNode() {
        OperationResult result = new OperationResult();
        File binDir = new File(this.getBasedir(), "bin");
        File pidFile = new File(binDir, "cassandra.pid");
        try {
            if (pidFile.exists()) {
                long pid = this.readPidFile(pidFile);
                this.log.info((Object)("Shutting down storage node with pid " + pid));
                ProcessInfo process = this.findProcessInfo(pid);
                if (process != null) {
                    try {
                        process.kill("KILL");
                        this.waitForNodeToGoDown();
                        pidFile.delete();
                        result.setSimpleResult("Successfully storage node with pid " + pid);
                    }
                    catch (SigarException e) {
                        this.log.error((Object)("Failed to delete storage node with pid " + process.getPid()), (Throwable)e);
                        result.setErrorMessage("Failed to delete storage node with pid " + pid + ": " + ThrowableUtil.getAllMessages((Throwable)e));
                    }
                } else {
                    this.log.warn((Object)("Could not find process info for pid " + pid));
                    result = this.shutdownUsingNativeProcessInfo();
                }
            } else {
                this.log.warn((Object)("Did not find pid file " + pidFile + ". It should not be modified, deleted, or moved."));
                result = this.shutdownUsingNativeProcessInfo();
            }
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("Could not read pid file " + pidFile), (Throwable)e);
            result.setErrorMessage("Could not read pid file " + pidFile + ": " + ThrowableUtil.getAllMessages((Throwable)e));
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"The shutdown operation was cancelled or interrupted. This interruption occurred while trying to verify that the storage node process has exited.");
            result.setErrorMessage("The operation was cancelled or interrupted while trying to verify that the storage node process has exited.");
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private long readPidFile(File pidFile) throws FileNotFoundException {
        return Long.parseLong(StreamUtil.slurp((Reader)new FileReader(pidFile)));
    }

    private ProcessInfo findProcessInfo(long pid) {
        List scanResults = this.getResourceContext().getNativeProcessesForType();
        for (ProcessScanResult scanResult : scanResults) {
            if (scanResult.getProcessInfo().getPid() != pid) continue;
            return scanResult.getProcessInfo();
        }
        return null;
    }

    private OperationResult shutdownUsingNativeProcessInfo() throws InterruptedException {
        this.log.warn((Object)"Could not obtain process info from pid file");
        this.log.info((Object)"Obtaining process info from the system to perform the shutdown");
        OperationResult result = this.shutdownNode();
        this.waitForNodeToGoDown();
        return result;
    }

    private OperationResult updateConfiguration(Configuration params) {
        Configuration config = new Configuration();
        ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.builder().addSimple("jmxPort", (Object)params.getSimpleValue("jmxPort"))).addSimple("jmxPort", (Object)params.getSimpleValue("jmxPort"))).addSimple("minHeapSize", (Object)params.getSimpleValue("heapSize"))).addSimple("maxHeapSize", (Object)params.getSimpleValue("heapSize"))).addSimple("heapNewSize", (Object)params.getSimpleValue("heapNewSize"))).addSimple("threadStackSize", (Object)params.getSimpleValue("threadStackSize"))).addSimple("maxHeapSize", (Object)params.getSimpleValue("heapSize"))).build();
        config.put((Property)new PropertySimple("jmxPort", (Object)params.getSimpleValue("jmxPort")));
        config.put((Property)new PropertySimple("minHeapSize", (Object)params.getSimpleValue("heapSize")));
        config.put((Property)new PropertySimple("maxHeapSize", (Object)params.getSimpleValue("heapSize")));
        config.put((Property)new PropertySimple("heapNewSize", (Object)params.getSimpleValue("heapNewSize")));
        config.put((Property)new PropertySimple("threadStackSize", (Object)params.getSimpleValue("threadStackSize")));
        String restartIfRequiredString = params.getSimpleValue("restartIfRequired");
        boolean restartIfRequired = restartIfRequiredString != null && Boolean.parseBoolean(restartIfRequiredString);
        ConfigurationUpdateReport configurationUpdateReport = new ConfigurationUpdateReport(config);
        StorageNodeConfigDelegate configDelegate = new StorageNodeConfigDelegate(this.getBasedir(), this);
        configDelegate.updateResourceConfigurationAndRestartIfNecessary(configurationUpdateReport, restartIfRequired);
        OperationResult result = new OperationResult("Configuration updated.");
        if (!configurationUpdateReport.getStatus().equals((Object)ConfigurationUpdateStatus.SUCCESS)) {
            result.setErrorMessage(configurationUpdateReport.getErrorMessage());
        }
        return result;
    }

    private OperationResult decommission() {
        this.log.info((Object)("Decommissioning " + this.getResourceContext().getResourceKey()));
        OperationResult result = new OperationResult();
        try {
            EmsConnection emsConnection = this.getEmsConnection();
            EmsBean storageService = emsConnection.getBean("org.apache.cassandra.db:type=StorageService");
            EmsAttribute operationModeAttr = storageService.getAttribute("OperationMode");
            String operationMode = (String)operationModeAttr.refresh();
            if (operationMode.equals("DECOMMISSIONED")) {
                this.log.info((Object)("The storage node " + this.getHost() + " is already decommissioned."));
            } else {
                Class[] emptyParams = new Class[]{};
                EmsOperation operation = storageService.getOperation("decommission", emptyParams);
                operation.invoke((Object[])emptyParams);
                operationMode = (String)operationModeAttr.refresh();
                if (!operationMode.equals("DECOMMISSIONED")) {
                    result.setErrorMessage("Failed to decommission storage node " + this.getHost() + ". The " + "StorageService is reporting " + operationMode + " for its operation mode but it should be " + "reporting DECOMMISSIONED. The StorageService operation mode is not to be confused with the " + "Storage Node operation mode.");
                }
            }
        }
        catch (EmsInvocationException e) {
            result.setErrorMessage("Decommission operation failed: " + ThrowableUtil.getAllMessages((Throwable)e));
        }
        return result;
    }

    private OperationResult uninstall() {
        this.log.info((Object)("Uninstalling storage node at " + this.getResourceContext().getResourceKey()));
        OperationResult result = new OperationResult();
        OperationResult shutdownResult = this.shutdownIfNecessary();
        if (shutdownResult.getErrorMessage() != null) {
            result.setErrorMessage("Failed to shut down storage node: " + shutdownResult.getErrorMessage());
        } else {
            File basedir = this.getBasedir();
            if (basedir.exists()) {
                this.log.info((Object)"Purging data directories");
                Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
                String yamlProp = pluginConfig.getSimpleValue("yamlConfiguration");
                File yamlFile = new File(yamlProp);
                ConfigEditor yamlEditor = new ConfigEditor(yamlFile);
                yamlEditor.load();
                this.purgeDataDirs(yamlEditor);
                this.log.info((Object)("Purging installation directory " + basedir));
                this.purgeDir(basedir);
                this.log.info((Object)("Finished deleting storage node " + this.getResourceContext().getResourceKey()));
            } else {
                this.log.info((Object)(basedir + " does not exist. Storage node files have already been purged."));
            }
        }
        return result;
    }

    private OperationResult announce(Configuration params) {
        OperationResult result = new OperationResult();
        Set<String> addressesToAdd = null;
        try {
            addressesToAdd = this.getAddreses(params);
            this.log.info((Object)("Announcing " + addressesToAdd));
            this.createSnapshots(addressesToAdd, "pre_" + StringUtil.collectionToString(addressesToAdd) + "_bootstrap_");
            Set<String> knownAddresses = this.getAuthAddresses();
            knownAddresses.addAll(addressesToAdd);
            this.setAuthAddresses(knownAddresses);
            this.reloadInternodeAuthConfig();
            result.getComplexResults().put((Property)new PropertySimple("details", (Object)("Successfully announced " + addressesToAdd)));
        }
        catch (InternodeAuthConfUpdateException e) {
            result.setErrorMessage("Failed to update authorized nodes due to the following error(s): " + ThrowableUtil.getAllMessages((Throwable)e));
        }
        return result;
    }

    private OperationResult unannounce(Configuration params) {
        OperationResult result = new OperationResult();
        Set<String> addressesToRemove = null;
        try {
            addressesToRemove = this.getAddreses(params);
            this.log.info((Object)("Unannouncing " + addressesToRemove));
            this.createSnapshots(addressesToRemove, "pre_" + StringUtil.collectionToString(addressesToRemove) + "_decommission_");
            Set<String> knownAddresses = this.getAuthAddresses();
            knownAddresses.removeAll(addressesToRemove);
            this.setAuthAddresses(knownAddresses);
            this.reloadInternodeAuthConfig();
            result.getComplexResults().put((Property)new PropertySimple("details", (Object)("Successfully unannounced " + addressesToRemove)));
        }
        catch (InternodeAuthConfUpdateException e) {
            result.setErrorMessage("Failed to update authorized nodes due to the following error(s): " + ThrowableUtil.getAllMessages((Throwable)e));
        }
        return result;
    }

    private Set<String> getAddreses(Configuration params) {
        PropertyList propertyList = params.getList("addresses");
        HashSet<String> ipAddresses = new HashSet<String>();
        for (Property property : propertyList.getList()) {
            PropertySimple propertySimple = (PropertySimple)property;
            ipAddresses.add(propertySimple.getStringValue());
        }
        return ipAddresses;
    }

    private void createSnapshots(Set<String> addressesToAdd, String snapshotPrefix) {
        EmsConnection emsConnection = this.getEmsConnection();
        KeyspaceService keyspaceService = new KeyspaceService(emsConnection);
        keyspaceService.takeSnapshot(SYSTEM_KEYSPACE, snapshotPrefix + System.currentTimeMillis());
        keyspaceService.takeSnapshot(SYSTEM_AUTH_KEYSPACE, snapshotPrefix + System.currentTimeMillis());
        keyspaceService.takeSnapshot(RHQ_KEYSPACE, snapshotPrefix + System.currentTimeMillis());
    }

    private void reloadInternodeAuthConfig() {
        EmsBean authBean = this.getEmsConnection().getBean("org.rhq.cassandra.auth:type=RhqInternodeAuthenticator");
        EmsOperation emsOperation = authBean.getOperation("reloadConfiguration");
        emsOperation.invoke(new Object[0]);
    }

    private OperationResult updateKnownNodes(Configuration params) {
        OperationResult result = new OperationResult();
        PropertyList propertyList = params.getList("addresses");
        HashSet<String> ipAddresses = new HashSet<String>();
        for (Property property : propertyList.getList()) {
            PropertySimple propertySimple = (PropertySimple)property;
            ipAddresses.add(propertySimple.getStringValue());
        }
        try {
            this.updateInternodeAuthConfFile(ipAddresses);
            EmsBean authBean = this.getEmsConnection().getBean("org.rhq.cassandra.auth:type=RhqInternodeAuthenticator");
            EmsOperation emsOperation = authBean.getOperation("reloadConfiguration");
            emsOperation.invoke(new Object[0]);
            Configuration complexResults = result.getComplexResults();
            complexResults.put((Property)new PropertySimple("details", (Object)"Successfully updated the set of known nodes."));
            return result;
        }
        catch (InternodeAuthConfUpdateException e) {
            File authFile = this.getInternodeAuthConfFile();
            this.log.error((Object)("Failed to update set of trusted nodes in " + authFile + " due to the following error(s): " + ThrowableUtil.getAllMessages((Throwable)e)));
            result.setErrorMessage("Failed to update set of trusted nodes in " + authFile + " due to the following " + "error(s): " + ThrowableUtil.getAllMessages((Throwable)e));
            return result;
        }
    }

    private OperationResult prepareForBootstrap(Configuration params) {
        this.log.info((Object)("Preparing " + (Object)((Object)this) + " for bootstrap..."));
        ResourceContext context = this.getResourceContext();
        OperationResult result = new OperationResult();
        this.log.info((Object)"Stopping storage node");
        OperationResult shutdownResult = this.shutdownIfNecessary();
        if (shutdownResult.getErrorMessage() != null) {
            this.log.error((Object)("Failed to stop storage node " + this.getResourceContext().getResourceKey() + ". The storage node " + "must be shut down in order for the changes made by this operation to take effect."));
            result.setErrorMessage("Failed to stop the storage node. The storage node must be shut down in order for the changes made by this operation to take effect. The attempt to stop shut down the storage node failed with this error: " + shutdownResult.getErrorMessage());
            return result;
        }
        Configuration pluginConfig = context.getPluginConfiguration();
        String yamlProp = pluginConfig.getSimpleValue("yamlConfiguration");
        File yamlFile = new File(yamlProp);
        ConfigEditor configEditor = new ConfigEditor(yamlFile);
        try {
            configEditor.load();
            this.purgeDataDirs(configEditor);
            this.log.info((Object)"Updating cluster settings");
            String address = pluginConfig.getSimpleValue("host");
            int cqlPort = Integer.parseInt(params.getSimpleValue("cqlPort"));
            int gossipPort = Integer.parseInt(params.getSimpleValue("gossipPort"));
            List addresses = this.getAddresses(params.getList("addresses"));
            ArrayList seeds = new ArrayList(addresses);
            seeds.remove(address);
            this.log.info((Object)("Updating seeds property to " + seeds));
            configEditor.setSeeds(seeds.toArray(new String[seeds.size()]));
            configEditor.setNativeTransportPort(Integer.valueOf(cqlPort));
            configEditor.setStoragePort(Integer.valueOf(gossipPort));
            configEditor.save();
            this.log.info((Object)("Cluster configuration settings have been applied to " + yamlFile));
            this.updateInternodeAuthConfFile(new HashSet<String>(addresses));
            this.log.info((Object)((Object)((Object)this) + " is ready to be bootstrap. Restarting storage node..."));
            OperationResult startResult = this.startNode();
            if (startResult.getErrorMessage() != null) {
                this.log.error((Object)("Failed to restart storage node:\n" + startResult.getErrorMessage()));
                result.setErrorMessage("Failed to restart storage node:\n" + startResult.getErrorMessage());
            } else {
                result.setSimpleResult("The storage node was succesfully updated is now bootstrapping into the cluster.");
            }
            return result;
        }
        catch (ConfigEditorException e) {
            EmsConnection emsConnection;
            EmsBean storageService;
            EmsAttribute attribute;
            String operationMode;
            this.log.error((Object)("There was an error while trying to update " + yamlFile), (Throwable)e);
            if (e.getCause() instanceof YAMLException) {
                this.log.info((Object)("Attempting to restore " + yamlFile));
                try {
                    configEditor.restore();
                    result.setErrorMessage("Failed to update configuration file [" + yamlFile + "]: " + ThrowableUtil.getAllMessages((Throwable)e.getCause()));
                }
                catch (ConfigEditorException e1) {
                    this.log.error((Object)("Failed to restore " + yamlFile + ". A copy of the file prior to any modifications " + "can be found at " + configEditor.getBackupFile()));
                    result.setErrorMessage("There was an error updating [" + yamlFile + "] and undoing the changes " + "Failed. A copy of the file can be found at " + configEditor.getBackupFile() + ". See the " + "agent logs for more details");
                }
            }
            if (!(operationMode = (String)(attribute = (storageService = (emsConnection = this.getEmsConnection()).getBean("org.apache.cassandra.db:type=StorageService")).getAttribute("OperationMode")).refresh()).equals("NORMAL")) {
                result.setErrorMessage("Bootstrapping " + this.getHost() + " failed. The StorageService is reporting " + operationMode + " for its operation mode but it should be reporting NORMAL. The StorageService " + "operation mode is not to be confused with the Storage Node operation mode.");
            }
            return result;
        }
        catch (InternodeAuthConfUpdateException e) {
            File authFile = this.getInternodeAuthConfFile();
            result.setErrorMessage("Failed to update " + authFile + " due to the following error(s): " + ThrowableUtil.getAllMessages((Throwable)e));
            return result;
        }
    }

    private void purgeDataDirs(ConfigEditor configEditor) {
        this.purgeDir(new File(configEditor.getCommitLogDirectory()));
        this.purgeDir(new File(configEditor.getCommitLogDirectory()));
        for (String path : configEditor.getDataFileDirectories()) {
            this.purgeDir(new File(path));
        }
        this.purgeDir(new File(configEditor.getSavedCachesDirectory()));
    }

    private void purgeDir(File dir) {
        if (dir.isAbsolute()) {
            this.log.info((Object)("Purging " + dir));
            FileUtil.purge((File)dir, (boolean)true);
        } else {
            File relativeDir = new File(this.getBinDir(), dir.getPath());
            this.log.info((Object)("Purging " + relativeDir));
            FileUtil.purge((File)relativeDir, (boolean)true);
        }
    }

    private Set<String> getAuthAddresses() throws InternodeAuthConfUpdateException {
        File authFile = null;
        try {
            authFile = this.getInternodeAuthConfFile();
            String contents = StreamUtil.slurp((Reader)new FileReader(authFile));
            TreeSet<String> addresses = new TreeSet<String>();
            for (String address : contents.split("\\n")) {
                addresses.add(address);
            }
            return addresses;
        }
        catch (FileNotFoundException e) {
            throw new InternodeAuthConfUpdateException("Could not load internode authentication file " + authFile, e);
        }
    }

    private void setAuthAddresses(Set<String> addresses) throws InternodeAuthConfUpdateException {
        File authFile = null;
        this.log.info((Object)("Updating " + authFile));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating authorized storage node addresses to " + addresses));
        }
        try {
            authFile = this.getInternodeAuthConfFile();
            StreamUtil.copy((Reader)new StringReader(StringUtil.collectionToString(addresses, (String)"\n")), (Writer)new FileWriter(authFile), (boolean)true);
        }
        catch (Exception e) {
            throw new InternodeAuthConfUpdateException("An error occurred while trying to update " + authFile, e);
        }
    }

    private void updateInternodeAuthConfFile(Set<String> ipAddresses) throws InternodeAuthConfUpdateException {
        File authFile = this.getInternodeAuthConfFile();
        this.log.info((Object)("Updating " + authFile));
        try {
            StreamUtil.copy((Reader)new StringReader(StringUtil.collectionToString(ipAddresses, (String)"\n")), (Writer)new FileWriter(authFile), (boolean)true);
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while trying to update " + authFile), (Throwable)e);
            throw new InternodeAuthConfUpdateException("An error occurred while trying to update " + authFile, e);
        }
    }

    String getOperationMode() {
        EmsConnection emsConnection = this.getEmsConnection();
        EmsBean storageService = emsConnection.getBean("org.apache.cassandra.db:type=StorageService");
        EmsAttribute attribute = storageService.getAttribute("OperationMode");
        return (String)attribute.refresh();
    }

    private OperationResult nodeAdded(Configuration params) {
        return this.performTopologyChangeMaintenance(params);
    }

    private OperationResult nodeRemoved(Configuration params) {
        return this.performTopologyChangeMaintenance(params);
    }

    private OperationResult performTopologyChangeMaintenance(Configuration params) {
        boolean runRepair = params.getSimple("runRepair").getBooleanValue();
        boolean updateSeedsList = params.getSimple("updateSeedsList").getBooleanValue();
        EmsConnection emsConnection = this.getEmsConnection();
        KeyspaceService keyspaceService = new KeyspaceService(emsConnection);
        boolean hasErrors = false;
        OperationResult result = new OperationResult();
        Configuration resultConfig = result.getComplexResults();
        PropertyList resultsList = new PropertyList("results");
        OpResult opResult = null;
        if (runRepair) {
            opResult = this.repairKeyspace(keyspaceService, SYSTEM_AUTH_KEYSPACE);
            if (!opResult.succeeded) {
                hasErrors = true;
            }
            resultsList.add((Property)this.toPropertyMap(opResult));
        }
        opResult = this.cleanupKeyspace(keyspaceService, SYSTEM_AUTH_KEYSPACE);
        if (!opResult.succeeded) {
            hasErrors = true;
        }
        resultsList.add((Property)this.toPropertyMap(opResult));
        if (runRepair) {
            opResult = this.repairKeyspace(keyspaceService, RHQ_KEYSPACE);
            if (!opResult.succeeded) {
                hasErrors = true;
            }
            resultsList.add((Property)this.toPropertyMap(opResult));
        }
        opResult = this.cleanupKeyspace(keyspaceService, RHQ_KEYSPACE);
        if (!opResult.succeeded) {
            hasErrors = true;
        }
        resultsList.add((Property)this.toPropertyMap(opResult));
        if (updateSeedsList) {
            List addresses = this.getAddresses(params.getList("seedsList"));
            try {
                opResult = new OpResult();
                opResult.operation = "Update seeds list";
                this.updateSeedsList(addresses);
                opResult.succeeded = true;
            }
            catch (Exception e) {
                this.log.error((Object)("An error occurred while updating the seeds lists for " + this.getResourceContext().getResourceKey()), (Throwable)e);
                opResult.succeeded = false;
                Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
                opResult.details = "An error occurred while updating the seeds list: " + ThrowableUtil.getStackAsString((Throwable)rootCause);
            }
            resultsList.add((Property)this.toPropertyMap(opResult));
        }
        resultConfig.put((Property)resultsList);
        if (hasErrors) {
            result.setErrorMessage("One or more tasks failed to complete successfully.");
        }
        return result;
    }

    private OperationResult repair() {
        KeyspaceService keyspaceService = new KeyspaceService(this.getEmsConnection());
        OperationResult result = new OperationResult();
        Configuration resultConfig = result.getComplexResults();
        PropertyList resultsList = new PropertyList("results");
        OpResult opResult = this.repairKeyspace(keyspaceService, RHQ_KEYSPACE);
        resultsList.add((Property)this.toPropertyMap(opResult));
        opResult = this.repairKeyspace(keyspaceService, SYSTEM_AUTH_KEYSPACE);
        resultsList.add((Property)this.toPropertyMap(opResult));
        resultConfig.put((Property)resultsList);
        return result;
    }

    private OpResult repairKeyspace(KeyspaceService keyspaceService, String keyspace) {
        OpResult result = new OpResult();
        result.operation = "repair " + keyspace + " keyspace";
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Running primary range repair on " + keyspace + " keyspace"));
            }
            long start = System.currentTimeMillis();
            keyspaceService.repairPrimaryRange(keyspace, new String[0]);
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finsihed primary range repair on " + keyspace + " keyspace in " + (end - start) + " ms"));
            }
            result.succeeded = true;
            result.details = "Completed repair operation in " + (end - start) + " ms.";
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while running repair on " + keyspace), (Throwable)e);
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            result.succeeded = false;
            result.details = "An error occurred while running repair: " + ThrowableUtil.getStackAsString((Throwable)rootCause);
        }
        return result;
    }

    private OpResult cleanupKeyspace(KeyspaceService keyspaceService, String keyspace) {
        OpResult result = new OpResult();
        result.operation = "cleanup " + keyspace + " keyspace";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Running cleanup on " + keyspace + " keyspace"));
        }
        long start = System.currentTimeMillis();
        try {
            keyspaceService.cleanup(keyspace);
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished cleanup on " + keyspace + " keyspace in " + (end - start) + " ms"));
            }
            result.succeeded = true;
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while running cleanup on " + keyspace + " keyspace"), (Throwable)e);
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            result.succeeded = false;
            result.details = "An error occurred while running cleanup: " + ThrowableUtil.getStackAsString((Throwable)rootCause);
        }
        return result;
    }

    private OperationResult prepareForUpgrade(Configuration parameters) throws Exception {
        EmsConnection emsConnection = this.getEmsConnection();
        EmsBean storageService = emsConnection.getBean("org.apache.cassandra.db:type=StorageService");
        Class[] emptyParams = new Class[]{};
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Disabling native transport...");
        }
        EmsOperation operation = storageService.getOperation("stopNativeTransport", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Disabling gossip...");
        }
        operation = storageService.getOperation("stopGossiping", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Taking the snapshot...");
        }
        operation = storageService.getOperation("takeSnapshot", new Class[]{String.class, String[].class});
        String snapshotName = parameters.getSimpleValue("snapshotName");
        if (snapshotName == null || snapshotName.trim().isEmpty()) {
            snapshotName = System.currentTimeMillis() + "";
        }
        operation.invoke(new Object[]{snapshotName, new String[0]});
        this.waitForTaskToComplete(500, 10, 150);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initiating drain...");
        }
        operation = storageService.getOperation("drain", emptyParams);
        operation.invoke((Object[])emptyParams);
        return new OperationResult();
    }

    private void waitForTaskToComplete(int initialWaiting, int maxTries, int sleepMillis) throws InterruptedException {
        Thread.sleep(initialWaiting);
        EmsConnection emsConnection = this.getEmsConnection();
        EmsBean flushWriterBean = emsConnection.getBean("org.apache.cassandra.internal:type=FlushWriter");
        EmsAttribute attribute = flushWriterBean.getAttribute("PendingTasks");
        Long valueObject = (Long)attribute.refresh();
        while (valueObject > 0L && maxTries-- > 0) {
            Thread.sleep(sleepMillis);
            valueObject = (Long)attribute.refresh();
        }
        flushWriterBean.unload();
    }

    private PropertyMap toPropertyMap(OpResult opResult) {
        PropertyMap map = new PropertyMap("resultsMap");
        map.put((Property)new PropertySimple("task", (Object)opResult.operation));
        map.put((Property)new PropertySimple("succeeded", (Object)opResult.succeeded));
        map.put((Property)new PropertySimple("details", (Object)opResult.details));
        return map;
    }

    public String toString() {
        return StorageNodeComponent.class.getSimpleName() + "[resourceKey: " + this.getResourceContext().getResourceKey() + "]";
    }

    private static class OpResult {
        String operation;
        boolean succeeded;
        String details;

        private OpResult() {
        }
    }
}

