/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemoveIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.platform.LinuxDistroInfo;
import org.rhq.plugins.platform.PosixPlatformComponent;
import org.rhq.plugins.platform.content.RpmPackageDiscoveryDelegate;
import org.rhq.plugins.platform.content.yum.PluginContext;
import org.rhq.plugins.platform.content.yum.YumProxy;
import org.rhq.plugins.platform.content.yum.YumServer;

public class LinuxPlatformComponent
extends PosixPlatformComponent
implements ContentFacet {
    private static final String DISTRO_TRAIT_NAME_PREFIX = "distro.";
    private static final String TRAIT_DISTRO_NAME = "distro.name";
    private static final String TRAIT_DISTRO_VERSION = "distro.version";
    private final Log log = LogFactory.getLog(LinuxPlatformComponent.class);
    private YumServer yumServer;
    private YumProxy yumProxy;
    private boolean enableContentDiscovery = false;
    private boolean enableInternalYumServer = false;

    @Override
    public void start(ResourceContext context) {
        Boolean bool;
        Boolean bool2;
        super.start(context);
        Configuration pluginConfiguration = context.getPluginConfiguration();
        PropertySimple contentProp = pluginConfiguration.getSimple("enableContentDiscovery");
        this.enableContentDiscovery = contentProp != null ? ((bool2 = contentProp.getBooleanValue()) != null ? bool2 : false) : false;
        PropertySimple yumProp = pluginConfiguration.getSimple("enableInternalYumServer");
        this.enableInternalYumServer = yumProp != null ? ((bool = yumProp.getBooleanValue()) != null ? bool : false) : false;
        if (this.enableContentDiscovery) {
            RpmPackageDiscoveryDelegate.setSystemInfo(this.resourceContext.getSystemInformation());
            RpmPackageDiscoveryDelegate.checkExecutables();
        }
        this.startWithContentContext(context.getContentContext());
    }

    @Override
    public void stop() {
        if (this.yumServer != null) {
            try {
                this.yumServer.halt();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to shutdown the yum server.", (Throwable)e);
            }
        }
        super.stop();
    }

    private void startWithContentContext(ContentContext context) {
        if (this.enableInternalYumServer) {
            this.yumServer = new YumServer();
            this.yumProxy = new YumProxy();
            int port = this.yumPort();
            this.log.debug((Object)("yum port=[" + port + "]"));
            try {
                PluginContext yumContext = new PluginContext(port, this.resourceContext, context);
                this.yumServer.start(yumContext);
                this.yumProxy.init(this.resourceContext);
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to start yum server.", (Throwable)e);
            }
        } else {
            this.log.info((Object)"Internal yum server is disabled.");
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        Set<ResourcePackageDetails> detailsSet = new HashSet<ResourcePackageDetails>();
        if (this.enableContentDiscovery && type.getName().equals("rpm")) {
            try {
                detailsSet = RpmPackageDiscoveryDelegate.discoverPackages(type);
            }
            catch (IOException e) {
                this.log.error((Object)"Error while trying to discover RPMs", (Throwable)e);
            }
        }
        return detailsSet;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        if (!this.enableInternalYumServer) {
            throw new UnsupportedOperationException("Internal yum server is disabled - this operation is a no-op.");
        }
        try {
            DeployPackagesResponse result = new DeployPackagesResponse(ContentResponseResult.SUCCESS);
            ArrayList<String> pkgs = new ArrayList<String>();
            for (ResourcePackageDetails p : packages) {
                String pkgInfo = p.getName();
                String version = p.getVersion();
                if (version != null && !"".equals(version)) {
                    pkgInfo = pkgInfo + "-" + version;
                }
                this.log.info((Object)("Adding <" + pkgInfo + "> to list of packages to deploy, original package object was: " + p));
                pkgs.add(pkgInfo);
                result.addPackageResponse(new DeployIndividualPackageResponse(p.getKey(), ContentResponseResult.SUCCESS));
            }
            this.yumProxy.install(pkgs);
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)"Install packages failed", (Throwable)e);
            return new DeployPackagesResponse(ContentResponseResult.FAILURE);
        }
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        if (!this.enableInternalYumServer) {
            throw new UnsupportedOperationException("Internal yum server is disabled - this operation is a no-op.");
        }
        try {
            RemovePackagesResponse result = new RemovePackagesResponse(ContentResponseResult.SUCCESS);
            ArrayList<String> pkgs = new ArrayList<String>();
            for (ResourcePackageDetails p : packages) {
                pkgs.add(p.getName());
                result.addPackageResponse(new RemoveIndividualPackageResponse(p.getKey(), ContentResponseResult.SUCCESS));
            }
            this.yumProxy.remove(pkgs);
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)"Remove packages failed", (Throwable)e);
            return new RemovePackagesResponse(ContentResponseResult.FAILURE);
        }
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metricRequests) {
        super.getValues(report, metricRequests);
        for (MeasurementScheduleRequest metricRequest : metricRequests) {
            if (!metricRequest.getName().startsWith(DISTRO_TRAIT_NAME_PREFIX)) continue;
            report.addData(this.getDistroTrait(metricRequest));
        }
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("cleanYumMetadataCache".equals(name)) {
            if (!this.enableInternalYumServer) {
                throw new UnsupportedOperationException("Internal yum server is disabled - this operation is a no-op.");
            }
            this.log.info((Object)"Cleaning yum metadata...");
            this.yumServer.cleanMetadata();
            this.yumProxy.cleanMetadata();
            return new OperationResult();
        }
        return super.invokeOperation(name, parameters);
    }

    private MeasurementDataTrait getDistroTrait(MeasurementScheduleRequest metricRequest) {
        MeasurementDataTrait trait = new MeasurementDataTrait(metricRequest, "?");
        if (metricRequest.getName().equals(TRAIT_DISTRO_NAME)) {
            trait.setValue(LinuxDistroInfo.getInstance().getName());
        } else if (metricRequest.getName().equals(TRAIT_DISTRO_VERSION)) {
            trait.setValue(LinuxDistroInfo.getInstance().getVersion());
        } else {
            this.log.error((Object)("Being asked to collect an unknown Linux distro trait: " + metricRequest.getName()));
        }
        return trait;
    }

    private int yumPort() {
        PropertySimple p = this.resourceContext.getPluginConfiguration().getSimple("yumPort");
        return p != null ? p.getIntegerValue() : 9080;
    }
}

