/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.List;
import java.util.Vector;

public class ThreadPool {
    protected Vector taskManagers;
    protected String name = "ThreadPool";
    protected volatile boolean stop = false;
    protected boolean respawnThreads = false;

    protected ThreadPool() {
    }

    protected String getTaskManagerName(String string, int n) {
        return string + "." + n;
    }

    protected void setup(String string, int n) {
        this.name = string;
        this.taskManagers = new Vector(n);
        for (int i = 0; i < n; ++i) {
            TaskManager taskManager = new TaskManager(this.getTaskManagerName(string, i));
            this.taskManagers.add(taskManager);
            taskManager.start();
        }
    }

    public static ThreadPool create(String string, int n) {
        ThreadPool threadPool = new ThreadPool();
        threadPool.setup(string, n);
        return threadPool;
    }

    public synchronized void execute(Runnable runnable) {
        while (true) {
            for (int i = 0; i < this.taskManagers.size(); ++i) {
                TaskManager taskManager = (TaskManager)this.taskManagers.get(i);
                if (this.respawnThreads && !taskManager.isAlive()) {
                    taskManager = new TaskManager(this.getTaskManagerName(this.name, i));
                }
                if (!taskManager.isIdle()) continue;
                taskManager.execute(runnable);
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized boolean tryToExecute(Runnable runnable) {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager taskManager = (TaskManager)this.taskManagers.get(i);
            if (this.respawnThreads && !taskManager.isAlive()) {
                taskManager = new TaskManager(this.getTaskManagerName(this.name, i));
            }
            if (!taskManager.isIdle()) continue;
            taskManager.execute(runnable);
            return true;
        }
        return false;
    }

    public boolean isRespawnThreads() {
        return this.respawnThreads;
    }

    public void setRespawnThreads(boolean bl) {
        this.respawnThreads = bl;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List list;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.stop = true;
            list = (List)this.taskManagers.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            TaskManager taskManager = (TaskManager)list.get(i);
            taskManager.terminate();
            TaskManager taskManager2 = taskManager;
            synchronized (taskManager2) {
                taskManager.notify();
            }
            try {
                taskManager.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void cancel() {
        this.stop = true;
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager taskManager = (TaskManager)this.taskManagers.get(i);
            taskManager.terminate();
            taskManager.interrupt();
        }
    }

    public synchronized void interrupt() {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager taskManager = (TaskManager)this.taskManagers.get(i);
            taskManager.interrupt();
        }
    }

    public synchronized boolean isIdle() {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager taskManager = (TaskManager)this.taskManagers.get(i);
            if (taskManager.isIdle()) continue;
            return false;
        }
        return true;
    }

    class TaskManager
    extends Thread {
        private Runnable task;
        private volatile boolean run;

        public TaskManager(String string) {
            super(string);
            this.task = null;
            this.run = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            while (!ThreadPool.this.stop && this.run) {
                if (this.task != null) {
                    this.task.run();
                    ThreadPool threadPool = ThreadPool.this;
                    synchronized (threadPool) {
                        this.task = null;
                        ThreadPool.this.notify();
                        continue;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.run = ThreadPool.this.respawnThreads;
                    break;
                }
            }
        }

        public boolean isIdle() {
            return this.task == null && this.run;
        }

        public boolean isStopped() {
            return ThreadPool.this.stop;
        }

        public void terminate() {
            ThreadPool.this.stop = true;
        }

        public synchronized void execute(Runnable runnable) {
            if (this.task != null) {
                throw new IllegalStateException("TaskManager is not idle");
            }
            this.task = runnable;
            this.notify();
        }
    }
}

