/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.menu;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.menu.MenuComponent;
import net.sf.navigator.util.LoadableResource;
import net.sf.navigator.util.LoadableResourceException;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuRepository
implements LoadableResource {
    public static final String MENU_REPOSITORY_KEY = "net.sf.navigator.menu.MENU_REPOSITORY";
    private static Log log = LogFactory.getLog((Class)(class$net$sf$navigator$menu$MenuRepository == null ? (class$net$sf$navigator$menu$MenuRepository = MenuRepository.class$("net.sf.navigator.menu.MenuRepository")) : class$net$sf$navigator$menu$MenuRepository));
    protected String config = null;
    protected String name = null;
    protected ServletContext servletContext = null;
    protected FastHashMap menus = new FastHashMap();
    protected FastHashMap displayers = new FastHashMap();
    protected FastHashMap templates = new FastHashMap();
    static /* synthetic */ Class class$net$sf$navigator$menu$MenuRepository;

    public Set getMenuNames() {
        return this.menus.keySet();
    }

    public List getTopMenus() {
        ArrayList<MenuComponent> topMenus = new ArrayList<MenuComponent>();
        if (this.menus == null) {
            log.warn((Object)"No menus found in repository!");
            return topMenus;
        }
        Iterator it = this.menus.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            MenuComponent menu = this.getMenu(name);
            if (menu.getParent() != null) continue;
            topMenus.add(menu);
        }
        return topMenus;
    }

    public MenuComponent getMenu(String menuName) {
        return (MenuComponent)this.menus.get((Object)menuName);
    }

    public MenuDisplayerMapping getMenuDisplayerMapping(String displayerName) {
        MenuDisplayerMapping mapping = (MenuDisplayerMapping)this.displayers.get((Object)displayerName);
        return mapping;
    }

    protected Digester initDigester() {
        Digester digester = new Digester();
        digester.setClassLoader(Thread.currentThread().getContextClassLoader());
        digester.push((Object)this);
        digester.addObjectCreate("MenuConfig/Menus/Menu", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu");
        digester.addSetNext("MenuConfig/Menus/Menu", "addMenu");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Displayers/Displayer", "net.sf.navigator.displayer.MenuDisplayerMapping", "mapping");
        digester.addSetProperties("MenuConfig/Displayers/Displayer");
        digester.addSetNext("MenuConfig/Displayers/Displayer", "addMenuDisplayerMapping", "net.sf.navigator.displayer.MenuDisplayerMapping");
        digester.addSetProperty("MenuConfig/Displayers/Displayer/SetProperty", "property", "value");
        return digester;
    }

    public void addMenu(MenuComponent menu) {
        if (this.menus.containsKey((Object)menu.getName())) {
            List children;
            if (log.isDebugEnabled()) {
                log.warn((Object)("Menu '" + menu.getName() + "' already exists in repository"));
            }
            if ((children = this.getMenu(menu.getName()).getComponents()) != null && menu.getComponents() != null) {
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    MenuComponent child = (MenuComponent)it.next();
                    menu.addMenuComponent(child);
                }
            }
        }
        this.menus.put((Object)menu.getName(), (Object)menu);
    }

    public void removeMenu(String name) {
        if (this.menus.containsKey((Object)name)) {
            this.menus.remove((Object)this.getMenu(name));
        }
    }

    public void addMenuDisplayerMapping(MenuDisplayerMapping displayerMapping) {
        this.displayers.put((Object)displayerMapping.getName(), (Object)displayerMapping);
    }

    public FastHashMap getDisplayers() {
        return this.displayers;
    }

    public void setDisplayers(FastHashMap displayers) {
        this.displayers = displayers;
    }

    public void load() throws LoadableResourceException {
        if (this.getServletContext() == null) {
            throw new LoadableResourceException("no reference to servlet context found");
        }
        InputStream input = null;
        Digester digester = this.initDigester();
        try {
            input = this.getServletContext().getResourceAsStream(this.config);
            digester.parse(input);
            this.menus.setFast(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoadableResourceException("Error parsing resource file: " + this.config + " nested exception is: " + e.getMessage());
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }

    public void reload() throws LoadableResourceException {
        this.menus.setFast(false);
        this.menus.clear();
        this.displayers.setFast(false);
        this.displayers.clear();
        this.load();
    }

    public void setLoadParam(String loadParam) {
        this.config = loadParam;
    }

    public String getLoadParam() {
        return this.config;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

