/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.samba;

import java.util.List;
import java.util.Set;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.NetworkStats;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;

public class SambaServerComponent
extends AugeasConfigurationComponent<ResourceComponent<?>>
implements OperationFacet,
MeasurementFacet {
    static final String ENABLE_RECYCLING = "enableRecycleBin";
    static final String AUTHCONFIG_PATH = "/usr/bin/authconfig";
    static final String NET_PATH = "/usr/bin/net";
    static final String SPACE = " ";
    private static final int PORT = 445;
    private ProcessInfo processInfo;
    private ResourceContext resourceContext;

    public void start(ResourceContext resourceContext) throws Exception {
        this.resourceContext = resourceContext;
        super.start(resourceContext);
        this.getProcess();
    }

    public void stop() {
        super.stop();
    }

    public AvailabilityType getAvailability() {
        return super.getAvailability();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        return super.loadResourceConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        super.updateResourceConfiguration(report);
    }

    public CreateResourceReport createResource(CreateResourceReport reportIn) {
        CreateResourceReport report = reportIn;
        Configuration config = report.getResourceConfiguration();
        String name = config.getSimple("name").getStringValue();
        report.setResourceKey(name);
        report.setResourceName(name);
        return super.createResource(report);
    }

    protected String getChildResourceConfigurationRootPath(ResourceType resourceType, Configuration resourceConfig) {
        if (resourceType.getName().equals("Samba Share")) {
            String targetName = resourceConfig.getSimple("name").getStringValue();
            return "/files/etc/samba/smb.conf/target[.='" + targetName + "']";
        }
        throw new IllegalArgumentException("Unsupported child Resource type: " + resourceType);
    }

    protected String getChildResourceConfigurationRootLabel(ResourceType resourceType, Configuration resourceConfig) {
        if (resourceType.getName().equals("Samba Share")) {
            return resourceConfig.getSimple("name").getStringValue();
        }
        throw new IllegalArgumentException("Unsupported child Resource type: " + resourceType);
    }

    protected void setNodeFromPropertySimple(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        if (ENABLE_RECYCLING.equals(propDefSimple.getName())) {
            if (propSimple.getBooleanValue().booleanValue()) {
                String path = node.getParent().getPath();
                augeas.set(path + "/vfs\\ objects", "recycle");
                augeas.set(path + "/recycle:repository", ".recycle");
                augeas.set(path + "/recycle:keeptree", "yes");
                augeas.set(path + "/recycle:versions", "yes");
            } else {
                String path = node.getParent().getPath();
                augeas.remove(path + "/vfs\\ objects");
                augeas.remove(path + "/recycle:repository");
                augeas.remove(path + "/recycle:keeptree");
                augeas.remove(path + "/recycle:versions");
            }
        } else {
            super.setNodeFromPropertySimple(augeas, node, propDefSimple, propSimple);
        }
    }

    protected Object toPropertyValue(PropertyDefinitionSimple propDefSimple, Augeas augeas, AugeasNode node) {
        if (ENABLE_RECYCLING.equals(propDefSimple.getName())) {
            return "recycle".equals(augeas.get(node.getParent().getPath() + "/vfs\\ objects"));
        }
        return super.toPropertyValue(propDefSimple, augeas, node);
    }

    private void getProcess() {
        List procs = this.resourceContext.getSystemInformation().getProcesses("process|basename|match=smbd,process|basename|nomatch|parent=smbd");
        if (procs.size() == 1) {
            this.processInfo = ((ProcessInfo)procs.get(0)).getAggregateProcessTree();
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        NetworkStats stats = this.resourceContext.getSystemInformation().getNetworkStats("localhost", 445);
        if (this.processInfo != null) {
            this.processInfo.refresh();
            for (MeasurementScheduleRequest request : metrics) {
                if (request.getName().startsWith("NetworkStat.")) {
                    int val = stats.getByName(request.getName().substring("NetworkStat.".length()));
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(val)));
                    continue;
                }
                if (!request.getName().startsWith("Process.")) continue;
                Double value = ObjectUtil.lookupDeepNumericAttributeProperty((Object)this.processInfo, (String)request.getName().substring("Process.".length()));
                report.addData(new MeasurementDataNumeric(request, value));
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        OperationResult result = null;
        if (name.equals("join")) {
            result = this.updateSmbAds(params);
        } else if (name.equals("disconnect")) {
            result = this.disconnectSmbAds(params);
        }
        return result;
    }

    private OperationResult disconnectSmbAds(Configuration params) throws Exception {
        Configuration resourceConfig = this.loadResourceConfiguration();
        OperationResult result = new OperationResult();
        String username = resourceConfig.getSimple("username").getStringValue();
        String password = resourceConfig.getSimple("password").getStringValue();
        if (username == null || password == null) {
            result.setSimpleResult("Missing required connection parameters");
            return result;
        }
        StringBuilder netArgs = new StringBuilder();
        netArgs.append("ads leave");
        netArgs.append(" -U " + username + "%" + password);
        ProcessExecutionResults netResults = this.execute(NET_PATH, netArgs.toString());
        String results = netResults.getCapturedOutput();
        result.setSimpleResult(results);
        return result;
    }

    private OperationResult updateSmbAds(Configuration params) throws Exception {
        Configuration resourceConfig = this.loadResourceConfiguration();
        OperationResult result = new OperationResult();
        String realm = resourceConfig.getSimple("realm").getStringValue();
        String controller = resourceConfig.getSimple("controller").getStringValue();
        String username = resourceConfig.getSimple("username").getStringValue();
        String password = resourceConfig.getSimple("password").getStringValue();
        String workgroup = resourceConfig.getSimple("workgroup").getStringValue();
        String idmapuid = resourceConfig.getSimple("idmap uid").getStringValue();
        String idmapgid = resourceConfig.getSimple("idmap gid").getStringValue();
        String shell = resourceConfig.getSimple("template shell").getStringValue();
        if (realm == null || controller == null || username == null || password == null || workgroup == null) {
            result.setSimpleResult("Missing required connection parameters");
            return result;
        }
        StringBuilder authArgs = new StringBuilder();
        StringBuilder netArgs = new StringBuilder();
        authArgs.append("--smbservers=" + controller);
        authArgs.append(" --smbrealm=" + realm);
        authArgs.append(" --enablewinbind --smbsecurity=ads");
        if (idmapuid != null) {
            authArgs.append(" --smbidmapuid=" + idmapuid);
        }
        if (idmapgid != null) {
            authArgs.append(" --smbidmapgid=" + idmapgid);
        }
        if (shell != null) {
            authArgs.append(" --winbindtemplateshell=" + shell);
        }
        authArgs.append(" --update");
        netArgs.append("join");
        netArgs.append(" -w " + workgroup);
        netArgs.append(" -S " + controller);
        netArgs.append(" -U " + username + "%" + password);
        ProcessExecutionResults authResults = this.execute(AUTHCONFIG_PATH, authArgs.toString());
        ProcessExecutionResults netResults = this.execute(NET_PATH, netArgs.toString());
        String results = authResults.getCapturedOutput() + netResults.getCapturedOutput();
        result.setSimpleResult(results);
        return result;
    }

    private ProcessExecutionResults execute(String path, String args) throws InvalidPluginConfigurationException {
        ProcessExecution processExecution = new ProcessExecution(path);
        SystemInfo sysInfo = this.resourceContext.getSystemInformation();
        if (args != null) {
            processExecution.setArguments(args.split(SPACE));
        }
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(1000L);
        processExecution.setKillOnTimeout(true);
        ProcessExecutionResults results = sysInfo.executeProcess(processExecution);
        return results;
    }
}

