/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.samba;

import java.util.List;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;
import org.rhq.plugins.samba.SambaServerComponent;

public class SambaShareComponent
extends AugeasConfigurationComponent<SambaServerComponent> {
    public static final String TARGET_NAME_PROP = "targetName";
    public static final String NAME_RESOURCE_CONFIG_PROP = "name";
    static final String RESOURCE_TYPE_NAME = "Samba Share";

    public void start(ResourceContext<SambaServerComponent> resourceContext) throws Exception {
        super.start(resourceContext);
    }

    protected String getResourceConfigurationRootPath() {
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        String targetName = pluginConfig.getSimple(TARGET_NAME_PROP).getStringValue();
        String targetPath = "/files/etc/samba/smb.conf/target[.='" + targetName + "']";
        AugeasNode targetNode = new AugeasNode(targetPath);
        Augeas augeas = this.getAugeas();
        List matches = augeas.match(targetNode.getPath());
        return (String)matches.get(0);
    }

    public void stop() {
        super.stop();
    }

    public AvailabilityType getAvailability() {
        return super.getAvailability();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration resourceConfig = super.loadResourceConfiguration();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        String targetName = pluginConfig.getSimple(TARGET_NAME_PROP).getStringValue();
        resourceConfig.put((Property)new PropertySimple(NAME_RESOURCE_CONFIG_PROP, (Object)targetName));
        return resourceConfig;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        super.updateResourceConfiguration(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        this.initAugeas();
        String rootPath = this.getResourceConfigurationRootPath();
        try {
            Augeas augeas = this.getAugeas();
            augeas.remove(rootPath);
            augeas.save();
        }
        finally {
            this.close();
        }
    }
}

