/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.util.GlobFilter;

public class Glob {
    private static final Log log = LogFactory.getLog(Glob.class);
    public static final Comparator<File> ALPHABETICAL_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            String path1 = o1.getAbsolutePath();
            String path2 = o2.getAbsolutePath();
            return path1.compareTo(path2);
        }
    };

    private Glob() {
    }

    public static boolean isWildcard(String globPattern) {
        for (char specialChar : GlobFilter.WILDCARD_CHARS) {
            if (globPattern.indexOf(specialChar) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(File rootPath, String globPattern, File file) {
        String rootPortion = Glob.rootPortion(globPattern);
        globPattern = globPattern.substring(rootPortion.length());
        globPattern = new File(rootPath, globPattern).getAbsolutePath();
        return new GlobFilter(globPattern).accept(file);
    }

    public static List<File> match(File parentPath, String globPattern) {
        return Glob.match(parentPath, globPattern, null);
    }

    public static List<File> match(File parentPath, String globPattern, Comparator<? super File> resultComparator) {
        if (!parentPath.exists()) {
            throw new IllegalArgumentException("Path '" + parentPath + "' does not exist.");
        }
        if (!parentPath.isDirectory()) {
            throw new IllegalArgumentException("Path '" + parentPath + "' is not a directory.");
        }
        String rootPortion = Glob.rootPortion(globPattern);
        globPattern = globPattern.substring(rootPortion.length());
        int specialCharIdx = globPattern.length();
        for (char specialChar : GlobFilter.WILDCARD_CHARS) {
            int idx = globPattern.indexOf(specialChar);
            if (idx < 0 || specialCharIdx <= idx) continue;
            specialCharIdx = idx;
        }
        if (specialCharIdx > 0) {
            int globParentIdx = globPattern.lastIndexOf(File.separatorChar, specialCharIdx);
            if (globParentIdx > 0) {
                parentPath = new File(parentPath, globPattern.substring(0, globParentIdx));
                globPattern = Glob.createGlobPattern(parentPath.getAbsolutePath(), globPattern.substring(globParentIdx));
            } else {
                globPattern = Glob.createGlobPattern(parentPath.getAbsolutePath(), globPattern);
            }
        } else {
            globPattern = Glob.createGlobPattern(parentPath.getAbsolutePath(), globPattern);
        }
        globPattern = new File(globPattern).getAbsolutePath();
        File[] files = parentPath.listFiles(new GlobFilter(globPattern));
        if (files == null) {
            log.debug((Object)("Could list files in " + parentPath));
            return Collections.emptyList();
        }
        if (resultComparator != null) {
            Arrays.sort(files, resultComparator);
        }
        return Arrays.asList(files);
    }

    private static String createGlobPattern(String parent, String pattern) {
        if (!parent.endsWith(File.separator)) {
            parent = parent + File.separatorChar;
        }
        return parent + pattern;
    }

    public static List<File> matchAll(File parentPath, List<String> globPatterns) {
        return Glob.matchAll(parentPath, globPatterns, null);
    }

    public static List<File> matchAll(File parentPath, List<String> globPatterns, Comparator<? super File> resultComparator) {
        ArrayList<File> matches = new ArrayList<File>();
        for (String p : globPatterns) {
            matches.addAll(Glob.match(parentPath, p, null));
        }
        if (resultComparator != null) {
            Collections.sort(matches, resultComparator);
        }
        return matches;
    }

    public static void exclude(List<File> matches, String globPattern) {
        GlobFilter filter = new GlobFilter(globPattern);
        Iterator<File> it = matches.iterator();
        while (it.hasNext()) {
            if (!filter.accept(it.next())) continue;
            it.remove();
        }
    }

    public static void excludeAll(List<File> matches, String ... globPattern) {
        Glob.excludeAll(matches, Arrays.asList(globPattern));
    }

    public static void excludeAll(List<File> matches, List<String> globPatterns) {
        for (String p : globPatterns) {
            Glob.exclude(matches, p);
        }
    }

    public static String rootPortion(String path) {
        File[] roots;
        if (File.separator.equals("\\")) {
            try {
                File f = new File(path);
                path = f.isAbsolute() ? f.getCanonicalPath() : f.getPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((roots = File.listRoots()) != null) {
            for (File root : roots) {
                if (!path.startsWith(root.getPath())) continue;
                return root.getPath();
            }
        } else {
            log.warn((Object)"Could not determine file system roots. This is strange.");
        }
        return "";
    }
}

