/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.Iterator;
import org.rhq.server.metrics.CQLException;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class SimplePagedResult<T>
implements Iterable<T> {
    private static final int DEFAULT_PAGE_SIZE = 200;
    private final ResultSetMapper<T> mapper;
    private final Query query;
    private final StorageSession session;
    private final int pageSize;

    public SimplePagedResult(Query query, ResultSetMapper<T> mapper, StorageSession session, int pageSize) {
        this.query = query;
        this.mapper = mapper;
        this.session = session;
        this.pageSize = pageSize;
    }

    public SimplePagedResult(String query, ResultSetMapper<T> mapper, StorageSession session, int pageSize) {
        this((Query)new SimpleStatement(query), mapper, session, pageSize);
    }

    public SimplePagedResult(Query query, ResultSetMapper<T> mapper, StorageSession session) {
        this(query, mapper, session, 200);
    }

    public SimplePagedResult(String query, ResultSetMapper<T> mapper, StorageSession session) {
        this((Query)new SimpleStatement(query), mapper, session);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    private ResultSet retrieveInitialResultSet() {
        try {
            return this.session.execute(this.query);
        }
        catch (NoHostAvailableException e) {
            throw new CQLException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final ResultSet resultSet;
            private T lastRetrievedItem;
            {
                this.resultSet = SimplePagedResult.this.retrieveInitialResultSet();
                this.lastRetrievedItem = null;
            }

            @Override
            public boolean hasNext() {
                return this.resultSet != null && !this.resultSet.isExhausted();
            }

            @Override
            public T next() {
                this.lastRetrievedItem = SimplePagedResult.this.mapper.mapOne(this.resultSet);
                return this.lastRetrievedItem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

