/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.Iterator;
import org.rhq.server.metrics.CQLException;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class SlicedPagedResult<T>
implements Iterable<T> {
    private static final int DEFAULT_PAGE_SIZE = 30000;
    private final ResultSetMapper<T> mapper;
    private final Session session;
    private final int pageSize;
    private final QueryCreator<T> queryCreator;

    public SlicedPagedResult(QueryCreator<T> queryCreator, ResultSetMapper<T> mapper, Session session, int pageSize) {
        this.mapper = mapper;
        this.session = session;
        this.pageSize = pageSize;
        this.queryCreator = queryCreator;
    }

    public SlicedPagedResult(QueryCreator<T> queryCreator, ResultSetMapper<T> mapper, Session session) {
        this(queryCreator, mapper, session, 30000);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    private ResultSet retrieveNextResultSet(ResultSet existingResultSet, T lastRetrievedItem) {
        try {
            if (existingResultSet != null && existingResultSet.isExhausted() && existingResultSet.all().size() == this.pageSize) {
                return this.session.execute(this.queryCreator.buildNextQuery(lastRetrievedItem));
            }
        }
        catch (NoHostAvailableException e) {
            throw new CQLException(e);
        }
        return existingResultSet;
    }

    private ResultSet retrieveInitialResultSet() {
        try {
            return this.session.execute(this.queryCreator.buildInitialQuery());
        }
        catch (NoHostAvailableException e) {
            throw new CQLException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private T lastRetrievedItem = null;
            private ResultSet resultSet = SlicedPagedResult.access$000(SlicedPagedResult.this);

            @Override
            public boolean hasNext() {
                this.resultSet = SlicedPagedResult.this.retrieveNextResultSet(this.resultSet, this.lastRetrievedItem);
                return this.resultSet != null && !this.resultSet.isExhausted();
            }

            @Override
            public T next() {
                this.lastRetrievedItem = SlicedPagedResult.this.mapper.mapOne(this.resultSet);
                return this.lastRetrievedItem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static /* synthetic */ ResultSet access$000(SlicedPagedResult x0) {
        return x0.retrieveInitialResultSet();
    }

    public static interface QueryCreator<T> {
        public String buildInitialQuery();

        public String buildNextQuery(T var1);
    }
}

