/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;

public class CustomTableDiscoveryComponent
implements ManualAddFacet<ResourceComponent<?>>,
ResourceDiscoveryComponent<ResourceComponent<?>> {
    protected Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ResourceComponent<?>> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        Set<DiscoveredResourceDetails> set;
        ResourceComponent parentComponent = discoveryContext.getParentResourceComponent();
        Configuration config = discoveryContext.getDefaultPluginConfiguration();
        String table = config.getSimpleValue("table", "");
        ResourceType resourceType = discoveryContext.getResourceType();
        String resourceName = config.getSimpleValue("name", resourceType.getName());
        String resourceDescription = config.getSimpleValue("description", resourceType.getDescription());
        if (!DatabasePluginUtil.canProvideConnection(parentComponent)) {
            if (!this.log.isDebugEnabled()) return Collections.emptySet();
            this.log.debug((Object)("Parent component does not provide JDBC connections, cannot discover" + resourceName));
            return Collections.emptySet();
        }
        if (table.isEmpty()) {
            if (!this.log.isDebugEnabled()) return Collections.emptySet();
            this.log.debug((Object)("'table' value not set, cannot discover " + resourceName));
            return Collections.emptySet();
        }
        Statement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = DatabasePluginUtil.getConnectionFromComponent(parentComponent);
            if (connection == null) {
                throw new InvalidPluginConfigurationException("cannot obtain connection from parent");
            }
            statement = connection.createStatement();
            statement.setMaxRows(1);
            statement.setFetchSize(1);
            resultSet = statement.executeQuery("SELECT * FROM " + table);
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), table + resourceName, resourceName, null, resourceDescription, config, null);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("discovered " + details));
            }
            set = Collections.singleton(details);
        }
        catch (SQLException e) {
            block8: {
                try {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)("discovery failed " + e + " for " + table));
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose(null, statement, resultSet);
                    if (!DatabasePluginUtil.hasConnectionPoolingSupport(parentComponent)) throw throwable;
                    DatabasePluginUtil.safeClose(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DatabasePluginUtil.safeClose(null, statement, resultSet);
            if (!DatabasePluginUtil.hasConnectionPoolingSupport(parentComponent)) return Collections.emptySet();
            DatabasePluginUtil.safeClose(connection, statement, resultSet);
            return Collections.emptySet();
        }
        DatabasePluginUtil.safeClose(null, statement, resultSet);
        if (!DatabasePluginUtil.hasConnectionPoolingSupport(parentComponent)) return set;
        DatabasePluginUtil.safeClose(connection, statement, resultSet);
        return set;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext<ResourceComponent<?>> discoveryContext) throws InvalidPluginConfigurationException {
        Configuration config = pluginConfiguration;
        String table = config.getSimpleValue("table", null);
        String resourceName = config.getSimpleValue("name", table);
        String resourceDescription = config.getSimpleValue("description", discoveryContext.getResourceType().getDescription());
        String resourceVersion = config.getSimpleValue("version", null);
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), table + resourceName, resourceName, resourceVersion, resourceDescription, config, null);
        return details;
    }
}

