/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.plugins.apache.mapping.DirectiveMapping;
import org.rhq.plugins.apache.mapping.SpecificParams;

public class ApacheDirectiveRegExpression {
    private static final Map<String, DirectiveMapping> MAPPING_TYPE = new HashMap<String, DirectiveMapping>();
    public static final String WORD = "\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+";
    public static final String WS = "[ \t]*";
    public static final String WS_MAN = "[ \t]+";
    public static final String NUM = "[0-9]+";
    private static final Map<String, Pattern[]> DIRECTIVE_REGEX;
    private static final Map<String, Pattern[]> DIRECTIVEREGEX_TO_AUGEAS;

    public static List<String> getParams(AugeasNode parentNode) {
        StringBuilder value = new StringBuilder();
        String nodeName = parentNode.getLabel();
        ArrayList<String> result = new ArrayList<String>();
        List nodes = parentNode.getChildNodes();
        for (AugeasNode node : nodes) {
            value.append(node.getValue());
            value.append(" ");
        }
        if (value.length() > 0) {
            value.deleteCharAt(value.length() - 1);
        }
        if (!DIRECTIVE_REGEX.containsKey(nodeName)) {
            result.add(value.toString());
            return result;
        }
        value = SpecificParams.prepareForConfiguration(nodeName, value);
        Pattern[] patterns = DIRECTIVE_REGEX.get(nodeName);
        int startIndex = 0;
        boolean updated = true;
        while (updated & startIndex < value.length()) {
            updated = false;
        }
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(value);
            while (m.find(startIndex)) {
                for (int i = 1; i <= m.groupCount(); ++i) {
                    String val = m.group(i);
                    result.add(val);
                }
                updated = true;
                startIndex = m.end();
            }
        }
        return result;
    }

    public static List<String> createParams(String params, String name) {
        ArrayList<String> nodeParams = new ArrayList<String>();
        if (!DIRECTIVEREGEX_TO_AUGEAS.containsKey(name)) {
            nodeParams.add(params);
            return nodeParams;
        }
        if (name.equals("Allow") || name.equals("Deny")) {
            nodeParams.add("from");
        }
        Pattern[] patterns = DIRECTIVEREGEX_TO_AUGEAS.get(name);
        int startIndex = 0;
        boolean updated = true;
        params = SpecificParams.prepareForAugeas(name, params);
        while (updated & startIndex < params.length()) {
            updated = false;
        }
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(params);
            while (m.find(startIndex)) {
                for (int i = 1; i <= m.groupCount(); ++i) {
                    String val = m.group(i);
                    if (val == null) continue;
                    nodeParams.add(val);
                }
                updated = true;
                startIndex = m.end();
            }
        }
        if (name.equals("Options")) {
            int i = 0;
            for (String param : nodeParams) {
                param = param.replaceAll(" ", "");
                nodeParams.set(i, param);
                ++i;
            }
        }
        return nodeParams;
    }

    public static DirectiveMapping getMappingType(String directiveName) {
        DirectiveMapping map = MAPPING_TYPE.get(directiveName);
        if (map == null) {
            map = DirectiveMapping.SIMPLE_PROP;
        }
        return map;
    }

    static {
        MAPPING_TYPE.put("Alias", DirectiveMapping.DIRECTIVE_PER_MAP);
        MAPPING_TYPE.put("Listen", DirectiveMapping.DIRECTIVE_PER_MAP);
        MAPPING_TYPE.put("ErrorDocument", DirectiveMapping.DIRECTIVE_PER_MAP);
        MAPPING_TYPE.put("Options", DirectiveMapping.PARAM_PER_MAP);
        MAPPING_TYPE.put("ServerAlias", DirectiveMapping.PARAM_PER_MAP);
        MAPPING_TYPE.put("Allow", DirectiveMapping.PARAM_PER_MAP);
        MAPPING_TYPE.put("Deny", DirectiveMapping.PARAM_PER_MAP);
        MAPPING_TYPE.put("CustomLog", DirectiveMapping.DIRECTIVE_PER_MAP_INDEX);
        MAPPING_TYPE.put("AllowOverride", DirectiveMapping.PARAM_PER_MAP);
        MAPPING_TYPE.put("DirectoryIndex", DirectiveMapping.PARAM_PER_MAP);
        MAPPING_TYPE.put("NameVirtualHost", DirectiveMapping.DIRECTIVE_PER_MAP_INDEX);
        MAPPING_TYPE.put("IfModules", DirectiveMapping.POSITION_PROPERTY);
        DIRECTIVE_REGEX = new HashMap<String, Pattern[]>();
        DIRECTIVE_REGEX.put("Alias", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*")});
        DIRECTIVE_REGEX.put("CustomLog", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))?[ \t]*")});
        DIRECTIVE_REGEX.put("ErrorDocument", new Pattern[]{Pattern.compile("[ \t]*([0-9]+)[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*")});
        DIRECTIVE_REGEX.put("Options", new Pattern[]{Pattern.compile("[ \t]*(Add|Remove|Set)[ \t]*([a-zA-Z]+)")});
        DIRECTIVE_REGEX.put("Allow", new Pattern[]{Pattern.compile("from"), Pattern.compile("(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))")});
        DIRECTIVE_REGEX.put("Deny", new Pattern[]{Pattern.compile("from"), Pattern.compile("(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))")});
        DIRECTIVE_REGEX.put("Listen", new Pattern[]{Pattern.compile("(?:((?:\\[[a-zA-Z0-9:]+\\])|(?:[0-9\\.]+)):)?([0-9]+)(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))?")});
        DIRECTIVE_REGEX.put("ServerAlias", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)")});
        DIRECTIVE_REGEX.put("AllowOverride", new Pattern[]{Pattern.compile("[ \t]*(All|None|AuthConfig|FileInfo|Indexes|Limit|Options)")});
        DIRECTIVE_REGEX.put("DirectoryIndex", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*")});
        DIRECTIVE_REGEX.put("NameVirtualHost", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*")});
        DIRECTIVEREGEX_TO_AUGEAS = new HashMap<String, Pattern[]>();
        DIRECTIVEREGEX_TO_AUGEAS.put("Options", new Pattern[]{Pattern.compile("[ \t]*([+-]?[ \t]*[a-zA-Z]+)[ \t]*")});
        DIRECTIVEREGEX_TO_AUGEAS.put("Allow", new Pattern[]{Pattern.compile("(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))")});
        DIRECTIVEREGEX_TO_AUGEAS.put("Deny", new Pattern[]{Pattern.compile("(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))")});
        DIRECTIVEREGEX_TO_AUGEAS.put("ServerAlias", new Pattern[]{Pattern.compile("[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)")});
        DIRECTIVEREGEX_TO_AUGEAS.put("DirectoryIndex", new Pattern[]{Pattern.compile("[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)")});
        DIRECTIVEREGEX_TO_AUGEAS.put("Alias", new Pattern[]{Pattern.compile("[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*")});
        DIRECTIVEREGEX_TO_AUGEAS.put("CustomLog", new Pattern[]{Pattern.compile("[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)(?:[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+))?")});
        DIRECTIVEREGEX_TO_AUGEAS.put("AllowOverride", new Pattern[]{Pattern.compile("[ \t]*(All|None|AuthConfig|FileInfo|Indexes|Limit|Options)")});
        DIRECTIVEREGEX_TO_AUGEAS.put("Listen", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)")});
        DIRECTIVEREGEX_TO_AUGEAS.put("NameVirtualHost", new Pattern[]{Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*")});
        DIRECTIVEREGEX_TO_AUGEAS.put("ErrorDocument", new Pattern[]{Pattern.compile("[ \t]+([0-9]+)[ \t]+(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)")});
    }
}

