/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;

public class ApacheBinaryInfo {
    private static final Log LOG = LogFactory.getLog((String)ApacheBinaryInfo.class.getName());
    private static final Map<String, ApacheBinaryInfo> CACHE = new HashMap<String, ApacheBinaryInfo>();
    private static final String APACHE_VERSION = "Apache/";
    private static final String SERVER_BUILT = "Server built:";
    private static final String MPM_DIR = "-D APACHE_MPM_DIR=\"";
    private static final String HTTPD_ROOT_DEFINE = "HTTPD_ROOT";
    private static final String SERVER_CONFIG_FILE_DEFINE = "SERVER_CONFIG_FILE";
    private String version;
    private String root;
    private String binaryPath;
    private String ctl;
    private String built;
    private String mpm;
    private long lastModified = 0L;
    private Set<String> compiledInModules = new HashSet<String>();
    private Set<String> compiledInDefines = new HashSet<String>();

    protected ApacheBinaryInfo(@NotNull String binaryPath) {
        this.binaryPath = binaryPath;
    }

    @NotNull
    public static synchronized ApacheBinaryInfo getInfo(String binaryPath, SystemInfo systemInfo) throws Exception {
        ApacheBinaryInfo info = CACHE.get(binaryPath);
        long lastModified = new File(binaryPath).lastModified();
        if (info == null || lastModified != info.lastModified) {
            info = new ApacheBinaryInfo(binaryPath);
            CACHE.put(binaryPath, info);
            info.getApacheBinaryInfo(binaryPath, systemInfo);
        }
        return info;
    }

    private String findVersion(String binaryPath) throws Exception {
        String line = FileUtils.findString((String)binaryPath, (String)APACHE_VERSION);
        if (line == null) {
            throw new Exception("Unable to find 'Apache/' in: " + binaryPath);
        }
        int spaceIndex = line.indexOf(" ");
        if (spaceIndex != -1) {
            line = line.substring(0, spaceIndex);
        }
        int slashIndex = line.lastIndexOf(47);
        String version = line.substring(slashIndex + 1);
        return version;
    }

    private String findDefine(String binaryPath, String name) throws Exception {
        String define = "-D " + name + "=\"";
        String line = FileUtils.findString((String)binaryPath, (String)define);
        if (line == null) {
            throw new Exception("Unable to find -D " + name + " in: " + binaryPath);
        }
        String value = line.substring(define.length(), line.length() - 1);
        if (value.length() == 0) {
            LOG.debug((Object)("Found -D " + name + " in: " + binaryPath + " but value is empty"));
            value = null;
        }
        return value;
    }

    private String findRoot(String binaryPath) throws Exception {
        File conf;
        String file;
        String root = this.findDefine(binaryPath, HTTPD_ROOT_DEFINE);
        if (root == null && (file = this.findDefine(binaryPath, SERVER_CONFIG_FILE_DEFINE)) != null && (conf = new File(file)).isAbsolute() && conf.exists()) {
            root = conf.getParent();
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getVersionCommandInfo(String binaryPath, SystemInfo systemInfo) {
        BufferedReader is = null;
        try {
            String line;
            this.compiledInDefines.clear();
            ProcessExecution processExecution = new ProcessExecution(binaryPath);
            processExecution.setArguments(new String[]{"-V"});
            processExecution.setWaitForCompletion(10000L);
            processExecution.setCaptureOutput(true);
            ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
            if (results.getError() != null) {
                throw results.getError();
            }
            is = new BufferedReader(new StringReader(results.getCapturedOutput()));
            while ((line = is.readLine()) != null) {
                if ((line = line.trim()).startsWith(SERVER_BUILT)) {
                    this.built = line = line.substring(SERVER_BUILT.length()).trim();
                    continue;
                }
                if (line.startsWith(MPM_DIR)) {
                    int ix = (line = line.substring(MPM_DIR.length()).trim()).lastIndexOf(34);
                    if (ix != -1) {
                        line = line.substring(0, ix);
                    }
                    if ((ix = line.lastIndexOf("/")) != -1) {
                        line = line.substring(ix + 1);
                    }
                    this.mpm = line;
                    continue;
                }
                if (!line.startsWith("-D")) continue;
                String define = line.substring(3);
                int equalsIdx = define.indexOf(61);
                if (equalsIdx >= 0) {
                    define = define.substring(0, equalsIdx);
                }
                this.compiledInDefines.add(define);
            }
        }
        catch (Throwable t) {
            String msg = "Error running binary '" + binaryPath + "': " + t.getMessage();
            LOG.error((Object)msg, t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCompiledInModules(String binaryPath, SystemInfo systemInfo) {
        BufferedReader is = null;
        try {
            String line;
            this.compiledInModules.clear();
            ProcessExecution processExecution = new ProcessExecution(binaryPath);
            processExecution.setArguments(new String[]{"-l"});
            processExecution.setWaitForCompletion(10000L);
            processExecution.setCaptureOutput(true);
            ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
            if (results.getError() != null) {
                throw results.getError();
            }
            is = new BufferedReader(new StringReader(results.getCapturedOutput()));
            boolean firstLine = true;
            while ((line = is.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                    continue;
                }
                this.compiledInModules.add(line.trim());
            }
        }
        catch (Throwable t) {
            String msg = "Error running binary '" + binaryPath + "': " + t.getMessage();
            LOG.error((Object)msg, t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void getApacheBinaryInfo(String binaryPath, SystemInfo systemInfo) throws Exception {
        File binaryFile = new File(binaryPath);
        if (!binaryFile.exists()) {
            throw new IOException(binaryFile + " does not exist.");
        }
        if (binaryFile.isDirectory()) {
            throw new IOException(binaryFile + " is a directory.");
        }
        this.lastModified = binaryFile.lastModified();
        this.getVersionCommandInfo(binaryPath, systemInfo);
        this.getCompiledInModules(binaryPath, systemInfo);
        File libHttpd = this.getHttpdSharedLibrary(binaryFile);
        this.version = this.findVersion(libHttpd != null ? libHttpd.getPath() : this.binaryPath);
        this.root = this.findRoot(binaryPath);
        this.ctl = this.findDefine(binaryPath, SERVER_CONFIG_FILE_DEFINE);
    }

    private File getHttpdSharedLibrary(File binaryFile) throws Exception {
        File libhttpd;
        File bindir = binaryFile.getParentFile();
        if (bindir == null) {
            throw new Exception(this.binaryPath + " has no parent directory");
        }
        if (ApacheBinaryInfo.isUnix()) {
            libhttpd = bindir.getParentFile();
            if (libhttpd != null) {
                libhttpd = new File(libhttpd, "libexec/libhttpd.so");
            }
        } else {
            libhttpd = new File(bindir, "libhttpd.dll");
        }
        if (libhttpd != null && libhttpd.exists()) {
            return libhttpd;
        }
        return null;
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty("exe", this.binaryPath);
        if (this.mpm != null) {
            props.setProperty("mpm", this.mpm);
        }
        if (this.built != null) {
            props.setProperty("built", this.built);
        }
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApacheBinaryInfo that = (ApacheBinaryInfo)o;
        return this.binaryPath.equals(that.binaryPath);
    }

    public int hashCode() {
        return this.binaryPath.hashCode();
    }

    public String toString() {
        String info = "version=" + this.version + ", root=" + this.root + ", binary=" + this.binaryPath + ", ctl=" + this.ctl;
        if (this.mpm != null) {
            info = info + ", mpm=" + this.mpm;
        }
        if (this.built != null) {
            info = info + ", build=" + this.built;
        }
        return info;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getRoot() {
        return this.root;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public String getCtl() {
        return this.ctl;
    }

    public String getBuilt() {
        return this.built;
    }

    public String getMpm() {
        return this.mpm;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public static void main(String[] args) throws Exception {
        String binary = args[0];
        System.out.println(ApacheBinaryInfo.getInfo(binary, SystemInfoFactory.createJavaSystemInfo()));
    }

    private static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public Set<String> getCompiledInModules() {
        return this.compiledInModules;
    }

    public Set<String> getCompiledInDefines() {
        return this.compiledInDefines;
    }
}

