/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.system.SigarAccess;

public abstract class OsProcessUtility {
    private static final String[] NO_ARGS = new String[0];
    private static final List<String> NO_MODULES = Collections.emptyList();

    @Nullable
    public static File getProcExe(long pid, String name) {
        SigarProxy sigar = SigarAccess.getSigar();
        try {
            String exe = sigar.getProcExe(pid).getName();
            if (exe.length() > 0) {
                return new File(exe);
            }
        }
        catch (SigarException e) {
            // empty catch block
        }
        File argv0 = null;
        String[] args = OsProcessUtility.getProcArgs(pid, sigar);
        if (args.length != 0 && (argv0 = new File(args[0])).exists() && argv0.isAbsolute()) {
            return argv0;
        }
        List<String> modules = OsProcessUtility.getProcModules(pid, sigar);
        if (modules.size() > 0) {
            if (name == null) {
                return new File(modules.get(0));
            }
            name = File.separator + name;
            for (String module : modules) {
                if (!module.endsWith(name)) continue;
                return new File(module);
            }
        }
        return argv0;
    }

    @NotNull
    private static String[] getProcArgs(long pid, SigarProxy sigar) {
        try {
            return sigar.getProcArgs(pid);
        }
        catch (SigarException e) {
            return NO_ARGS;
        }
    }

    @NotNull
    private static List<String> getProcModules(long pid, SigarProxy sigar) {
        try {
            return sigar.getProcModules(pid);
        }
        catch (SigarException e) {
            return NO_MODULES;
        }
    }

    private OsProcessUtility() {
    }
}

