/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hudson;

import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.hudson.HudsonJSONUtility;
import org.rhq.plugins.hudson.HudsonServerComponent;

public class HudsonProjectComponent
implements ResourceComponent<HudsonServerComponent>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(HudsonProjectComponent.class);
    private ResourceContext<HudsonServerComponent> resourceContext;

    public void start(ResourceContext<HudsonServerComponent> hudsonServerComponentResourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = hudsonServerComponentResourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            JSONArray healthArray = ((HudsonServerComponent)this.resourceContext.getParentResourceComponent()).getProjectHealth(this.resourceContext.getResourceKey());
            if (healthArray != null) {
                JSONObject healthReport = healthArray.getJSONObject(0);
                return healthReport.getInt("score") == 100 ? AvailabilityType.UP : AvailabilityType.DOWN;
            }
            return AvailabilityType.DOWN;
        }
        catch (JSONException e) {
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        try {
            String path = this.resourceContext.getResourceKey();
            JSONObject job = HudsonJSONUtility.getData(path, 1);
            JSONObject lastSuccessfulBuild = job.has("lastSuccessfulBuild") ? job.getJSONObject("lastSuccessfulBuild") : null;
            JSONObject lastBuild = job.has("lastBuild") ? job.getJSONObject("lastBuild") : null;
            JSONArray healthArray = job.has("healthReport") ? job.getJSONArray("healthReport") : null;
            JSONObject healthReport = healthArray != null && healthArray.length() > 0 ? healthArray.getJSONObject(0) : null;
            long currentTime = System.currentTimeMillis();
            for (MeasurementScheduleRequest request : metrics) {
                try {
                    if (request.getName().equals("lastSuccessfulBuildNumber") && lastSuccessfulBuild != null) {
                        report.addData(new MeasurementDataTrait(request, lastSuccessfulBuild.getString("number")));
                        continue;
                    }
                    if (request.getName().equals("lastSuccessfulBuildTime") && lastSuccessfulBuild != null) {
                        report.addData(new MeasurementDataTrait(request, new Date(lastSuccessfulBuild.getLong("timestamp")).toString()));
                        continue;
                    }
                    if (request.getName().equals("lastSuccessfulBuildElapsedTime") && lastSuccessfulBuild != null) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf((double)(currentTime - lastSuccessfulBuild.getLong("timestamp")) / 1000.0)));
                        continue;
                    }
                    if (request.getName().equals("lastBuildNumber") && lastBuild != null) {
                        report.addData(new MeasurementDataTrait(request, lastBuild.getString("number")));
                        continue;
                    }
                    if (request.getName().equals("lastBuildTime") && lastBuild != null) {
                        report.addData(new MeasurementDataTrait(request, new Date(lastBuild.getLong("timestamp")).toString()));
                        continue;
                    }
                    if (request.getName().equals("lastBuildElapsedTime") && lastBuild != null) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf((double)(currentTime - lastBuild.getLong("timestamp")) / 1000.0)));
                        continue;
                    }
                    if (request.getName().equals("lastBuildResult") && lastBuild != null) {
                        report.addData(new MeasurementDataTrait(request, lastBuild.getString("result")));
                        continue;
                    }
                    if (request.getName().equals("healthScore") && healthReport != null) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(healthReport.getDouble("score") / 100.0)));
                        continue;
                    }
                    if (!request.getName().equals("lastBuildDuration") || lastBuild == null) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(lastBuild.getDouble("duration"))));
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }
}

