/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.rhq.cassandra.util.ConfigEditorException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigEditor {
    private File configFile;
    private File backupFile;
    private Yaml yaml;
    private Map config;

    public ConfigEditor(File cassandraYamlFile) {
        this.configFile = cassandraYamlFile;
    }

    public void load() {
        FileInputStream inputStream = null;
        try {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
            inputStream = new FileInputStream(this.configFile);
            this.config = (Map)this.yaml.load((InputStream)inputStream);
            this.createBackup();
        }
        catch (FileNotFoundException e) {
            throw new ConfigEditorException("Failed to load " + this.configFile, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void save() {
        try {
            this.yaml.dump((Object)this.config, (Writer)new FileWriter(this.configFile));
            this.backupFile.delete();
            this.yaml = null;
            this.config = null;
            this.backupFile = null;
        }
        catch (Exception e) {
            throw new ConfigEditorException("Failed to save changes to " + this.configFile, e);
        }
    }

    public void restore() {
        try {
            ConfigEditor.copyFile(this.backupFile, this.configFile);
            this.backupFile.delete();
            this.yaml = null;
            this.config = null;
            this.backupFile = null;
        }
        catch (IOException e) {
            throw new ConfigEditorException("Failed to restore " + this.configFile + " from " + this.backupFile, e);
        }
    }

    private void createBackup() {
        this.backupFile = new File(this.configFile.getParent(), "." + this.configFile.getName() + ".bak");
        try {
            ConfigEditor.copyFile(this.configFile, this.backupFile);
        }
        catch (IOException e) {
            throw new ConfigEditorException("Failed to create " + this.backupFile, e);
        }
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public String getClusterName() {
        return (String)this.config.get("cluster_name");
    }

    public String getListenAddress() {
        return (String)this.config.get("listen_address");
    }

    public void setListenAddress(String address) {
        this.config.put("listen_address", address);
    }

    public String getRpcAddress() {
        return (String)this.config.get("rpc_address");
    }

    public void setRpcAddress(String address) {
        this.config.put("rpc_address", address);
    }

    public String getAuthenticator() {
        return (String)this.config.get("authenticator");
    }

    public String getCommitLogDirectory() {
        return (String)this.config.get("commitlog_directory");
    }

    public void setCommitLogDirectory(String dir) {
        this.config.put("commitlog_directory", dir);
    }

    public List<String> getDataFileDirectories() {
        return (List)this.config.get("data_file_directories");
    }

    public void setDataFileDirectories(List<String> dirs) {
        this.config.put("data_file_directories", dirs);
    }

    public String getSavedCachesDirectory() {
        return (String)this.config.get("saved_caches_directory");
    }

    public void setSavedCachesDirectory(String dir) {
        this.config.put("saved_caches_directory", dir);
    }

    public void setSeeds(String ... seeds) {
        List seedProviderList = (List)this.config.get("seed_provider");
        Map seedProvider = (Map)seedProviderList.get(0);
        List paramsList = (List)seedProvider.get("parameters");
        Map params = (Map)paramsList.get(0);
        StringBuilder seedsString = new StringBuilder();
        for (int i = 0; i < seeds.length; ++i) {
            if (i > 0) {
                seedsString.append(",");
            }
            seedsString.append(seeds[i]);
        }
        params.put("seeds", seedsString.toString());
    }

    public Integer getNativeTransportPort() {
        return (Integer)this.config.get("native_transport_port");
    }

    public void setNativeTransportPort(Integer port) {
        this.config.put("native_transport_port", port);
    }

    public Integer getStoragePort() {
        return (Integer)this.config.get("storage_port");
    }

    public void setStoragePort(Integer port) {
        this.config.put("storage_port", port);
    }

    public String getInternodeAuthenticator() {
        return (String)this.config.get("internode_authenticator");
    }

    public void setInternodeAuthenticator(String clazz) {
        this.config.put("internode_authenticator", clazz);
    }

    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
        int bufferSize = 32768;
        try {
            is = new BufferedInputStream(is, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = is.read(buffer);
            while (bytesRead != -1) {
                os.write(buffer, 0, bytesRead);
                bytesRead = is.read(buffer);
            }
            os.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        finally {
            os.close();
            is.close();
        }
    }
}

