
package com.smartgwt.client.docs;

/**
 * <h3>Skinning / Theming</h3>
 * Skinning (aka "theming" or "branding") is the process of modifying Smart GWT's default
 *  look and feel to match the desired look and feel for your application.  Smart GWT supports
 *  an extremely powerful and simple skinning system that allows designers with a basic grasp of
 *  CSS and JSON to skin any Smart GWT component.
 *  <P>
 *  <h4>Basics</h4>
 *  <P>
 *  <ul>
 *  <li> Smart GWT components create their visual appearance by dynamically generating HTML,
 *  within the browser, using JavaScript.
 * 
 *  <li> the HTML generated by Smart GWT components contains CSS style names and URLs to
 *  images
 * 
 *  <li> Smart GWT components can be skinned by replacing the CSS styles and images that
 *  the components use by default, or by using JavaScript properties to configure
 *  components to use new CSS styles and new image URLs.
 * 
 *  <li> You can change the appearance of an individual Smart GWT component by 
 *  
 *  
 *  calling setter methods such as {@link com.smartgwt.client.widgets.Canvas#getStyleName setStyleName()} or
 *  {@link com.smartgwt.client.widgets.Canvas#getBackgroundColor setBackgroundColor()}, or you can skin all
 *  components of the same class at once, by using Canvas.setDefaultProperties().
 *  to change the defaults for the class.
 *  
 * 
 *  <li> A "skin" consists of:
 *  <ul>
 *  <li> a single CSS stylesheet containing all CSS styles used by Smart GWT components
 *  (<code>skin_styles.css</code>)
 *  <li> a single JavaScript file that sets component defaults (<code>load_skin.js</code>)
 *  <li> a directory tree of images organized by component
 *  </ul>
 *  
 *  <li>
 *  The example skins that come with Smart GWT are 
 *    
 *  inside smartgwt.jar and smartgwt-skins.jar as GWT modules.  
 *  The standard directory layout for a skin is:
 *  <pre>
 *         skin_styles.css
 *         load_skin.js
 *         images/
 *             ListGrid/
 *                 sort_ascending.gif
 *                 ...
 *             Tab/
 *             ... other directories containing
 *                 component or shared media ...
 *  </pre>
 *  <li> 
 *  
 *  
 *  A skin is implicitly loaded when you add an &lt;inherits&gt; tag in your .gwt.xml file to
 *  include SmartGWT components (name="com.smartgwt(ee).SmartGWT(Pro|Power|EE)").  To switch skins,
 *  add the "NoTheme" suffix to the "name" attribute of this &lt;inherits&gt; tag, then add
 *  &lt;inherits name="com.smartclient.theme.enterpriseblue.<i>SkinName</i>"/&gt;.  These
 *  tags cause a &lt;SCRIPT SRC=&gt; tag to be injected into your bootstrap .html page, which loads
 *  load_skin.js for the appropriate skin.
 *  
 *  load_skin.js loads the stylesheet and sets the CSS styleNames and media URLs that
 *  Smart GWT components will use.
 *  </ul>
 *  <P>
 *  <h4>Modifying Skins</h4>
 *  <P>
 *  To modify a skin, first create a copy of one of the skins that comes with the Smart GWT
 *  SDK, then modify the copy.  Full instructions are provided in Chapter 9 of the 
 *  ${isc.DocUtils.linkForDocNode('QuickStartGuide', 'QuickStart Guide')}.
 *  <P>
 *  <h4>Locating Skinning Properties</h4>
 *  <P>
 *  <b>Starting from the name of the component</b>
 *  <P>
 *  
 *  
 *  Given a Smart GWT component that you want to skin, open it's JavaDoc:
 *  
 *  <ul>
 *  <li> for properties that set CSS styles, look for properties whose name includes "style", eg
 *  {@link com.smartgwt.client.widgets.Button#getBaseStyle baseStyle}
 *  <li> for properties that control URLs to media, look for properties whose name includes
 *  "src", "image" or "icon", such as {@link com.smartgwt.client.widgets.Img#getSrc src}
 *  <li> for subcomponents that also support skinning, 
 *  
 *  
 *  look for methods like set<i>Subcomponent</i>Properties(), such as Window.setPaneContainerProperties().
 *  
 *  </ul>
 *  
 *  <P>
 *  <b>Starting from a running example</b>
 *  <P>
 *  
 *  <P>
 *  Specific browsers offer alternate approaches to quickly discover the images or style names
 *  being used for a part of a Smart GWT component's appearance: 
 *  <ul>
 *  <li> the Firefox browser offers a dialog via Tools->"Page Info" that gives a manifest of
 *  media used in the page.
 * <li> the <a href='http://www.getfirebug.com/' onclick="window.open('http://www.getfirebug.com/');return
 * false;">Firebug</a> extension for Firefox has an
 *  "Inspect" feature that allows you to see the HTML, CSS and media in use for a given area of
 *  the screen
 *  <li> right clicking (option-click on a Mac) on an image and choosing "Properties" shows a
 *  dialog that provides the image URL in most browsers.  Tips:
 *  <ul>
 *  <li> if a Smart GWT component is showing text over an image, right-click at the very edge of
 *  the underlying image to get image properties rather than information about the text label
 *  <li> on some browsers, in order to see the full image URL, you may need to drag select the 
 *  partial URL of the image shown in the properties dialog
 *  </ul>
 *  </ul>
 *  <P>
 *  <h4>Image URLs in Smart GWT</h4>
 *  <P>
 * Properties that refer to images by URL, such as {@link com.smartgwt.client.widgets.Img#getSrc src} and {@link
 * com.smartgwt.client.widgets.Button#getIcon icon}, are
 *  specially interpreted in Smart GWT to allow for simpler and more uniform image URLs,
 *  and to allow applications to be restructured more easily.
 *  <P>
 *  Unlike the URL used with an HTML &lt;IMG&gt; element, the image URL passed to a Smart GWT
 *  component is not assumed to be relative to the current page.  See String for a
 *  full explanation of the default application image directory, and the meaning of the "[SKIN]"
 *  prefix.
 *  <P>
 *  <h4>Specifying Image URLs</h4>
 *  <P>
 *  Default image URLs for Smart GWT components are specified in <code>load_skin.js</code> via
 *  JavaScript, using calls to  Class.addProperties and
 *   Class.changeDefaults.  For example, the <code>load_skin.js</code> file
 *  from the "Enterprise" skin includes the following code to establish the media used by
 *  {@link com.smartgwt.client.widgets.Window#getMinimizeButton minimizeButton}:
 *  <pre>
 *     isc.Window.changeDefaults("minimizeButtonDefaults", { 
 *          src:"[SKIN]/Window/minimize.png"
 *     });
 *  </pre>
 *  <P>
 *  <b>NOTE:</b> These are JavaScript APIs and hence do not appear in SmartGWT
 *  JavaDoc - you may want to refer to the &#83;martClient Reference available at
 * <a href='http://www.smartclient.com/product/documentation.jsp'
 * onclick="window.open('http://www.smartclient.com/product/documentation.jsp');return false;">Isomorphic.com</a> for these
 * specific
 *  APIs.
 *  
 *  <h4>Specifying Image Sizes</h4>
 *  <P>
 *  Many Smart GWT components must know some image sizes in advance, in order to allow those
 *  components to autosize to data or content.
 *  <P>
 * For example, the {@link com.smartgwt.client.widgets.tab.ImgTab}s used in {@link com.smartgwt.client.widgets.tab.TabSet}s
 * are capable of automatically sizing
 * to a variable length {@link com.smartgwt.client.widgets.tab.Tab#getTitle title}.  To make this possible, Smart GWT must
 * know the
 *  sizes of the images used as "endcaps" on each tab in advance.
 *  <P>
 *  Like image URLs, image sizes are specified in <code>load_skin.js</code>.  The following code
 *  sample establishes the default size of the "endcaps" for tabs, by setting a default value
 *  for {@link com.smartgwt.client.widgets.tab.ImgTab#getCapSize capSize}:
 *  <pre>
 *      isc.ImgTab.addProperties({
 *          capSize:4
 *      })
 *  </pre>
 *  <P>
 *  <h4>CSS usage in Smart GWT</h4>
 *  <P>
 *  In Smart GWT, screen layout and sizing are controlled via JavaScript, and appearance via
 *  CSS and images.  
 *  <P>
 *  CSS borders, margins and padding applied to Smart GWT components can be treated as purely
 *  visual properties with no effect on sizing or layout.  Unlike HTML elements, a Smart GWT
 *  component will always have the exact size you specify via JavaScript, regardless of browser
 *  platform, browser compatibility mode, or borders, margins, or padding, all of which normally
 *  affect the final size of an HTML element. 
 *  <P>
 *  For this reason, Smart GWT skinning requires only novice-level familiarity with CSS, as CSS
 *  is used principally for colors and fonts.  See String for
 *  further details on what properties should be set via CSS vs via JavaScript.
 *  <P>
 *  <h4>Statefulness and Suffixes</h4>
 *  <P>
 *  Some components or areas within components, including buttons and the cells within a grid, are
 *  "stateful", meaning that they can be in one of a set of states each of which has a distinct
 *  visual appearance.
 *  <P>
 *  Stateful components switch the CSS styles or image URLs they are using as they transition
 *  from state to state, appending state information as suffixes on the style names or URL.
 * See {@link com.smartgwt.client.widgets.Img#getSrc src} and {@link com.smartgwt.client.widgets.Button#getBaseStyle
 * baseStyle} for details and examples.
 *  <P>
 *  Smart GWT has built-in logic to manage a series of state transitions, such as:
 *  <ul>
 *  <li> "rollover": showing a different appearance when the mouse is over a component
 *  <li> "button down": showing a different appearance when the mouse is pressed over a
 *  component
 *  <li> "disabled": showing a different appearance when a component cannot be interacted with
 *  <li> "selected": showing one of a set of components in a different state to indicate
 *  selection
 *  </ul>
 * Flags on some components, such as {@link com.smartgwt.client.widgets.ImgButton#getShowRollOver showRollOver}, allow you
 * to control whether the
 *  component will switch CSS style or image URL when the component transitions into a given state.
 *  <P>
 *  <h4>StretchImg: 3-segment stretchable images</h4>
 *  <P>
 *  A {@link com.smartgwt.client.widgets.StretchImg} is Smart GWT component that renders out a compound image composed of 3
 *  image files: two fixed-size endcaps images and a stretchable center segment.  Like stateful
 *  components, the names of each image segment is appended to the image URL as a suffix.  See
 *  {@link com.smartgwt.client.widgets.StretchImg#getSrc src} for details.
 *  <P>
 *  <h4>EdgedCanvas</h4>
 *  <P>
 *  Similar to a StretchImg, an {@link com.smartgwt.client.widgets.EdgedCanvas} provides an image-based decorative edge
 *  around and/or behind another component, with up to 9 segments (a 3x3 grid).  Decorative
 *  edges can be added to any component by setting {@link com.smartgwt.client.widgets.Canvas#getShowEdges showEdges:true}.
 *  EdgedCanvas is also used to construct dropshadows, which can be enabled on any component via
 *  {@link com.smartgwt.client.widgets.Canvas#getShowShadow showShadow:true}.
 *  <P>
 *  <h4>Multiple looks for the same component type</h4>
 *  <P>
 *  In some cases you need to create two variations in appearance for a component with the same
 *  behavior.  For example, you may want to create a specialized Window, called "PaletteWindow",
 *  that behaves like a normal Window but has a very compact look & feel.  To create a
 * separately skinnable component for PaletteWindow, use {@link com.smartgwt.client.util.isc#defineClass isc.defineClass}. 
 * For
 *  example:
 *  <pre>
 *     isc.defineClass("PaletteWindow", "Window");
 *     isc.PaletteWindow.addProperties({
 *         showFooter:false,
 *         ...
 *     })
 *  </pre>
 *  This creates a &#83;martClient class, which does not exist as a Java class.  To
 *  make your SmartGWT widget use the settings on this Smart GWT class, call setScClassName() passing
 *  the String name of the Smart GWT class.
 *  <P>
 *  <h4>Where to put skin-related JavaScript</h4>
 *  <P>
 *  If you're creating a custom skin, you can place JavaScript snippets such as those shown above in your
 *  custom skin's load_skin.js file.  If you prefer not to create a custom skin for small customizations,
 * you can execute JavaScript via a <a href='http://www.google.com/search?q=gwt+jsni'
 * onclick="window.open('http://www.google.com/search?q=gwt+jsni');return false;">JSNI</a> method in
 *  your Java code.  With this latter approach, be sure to change "isc." to "$wnd.isc." wherever it
 *  appears, and to call the JSNI method before creating any SmartGWT components.
 * 
 */
public interface Skinning {
}
