function RuntimeException_3(cause){
  $fillInStackTrace(this);
  this.detailMessage = !cause?null:$toString_0(cause);
  this.cause = cause;
}

defineSeed(6, 7, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable]), RuntimeException_3);
function $setDate(this$static, dayOfMonth){
  this$static.setDate(dayOfMonth);
  return this$static.getTime();
}

function $setFullYear(this$static, year, month, day){
  this$static.setFullYear(year, month, day);
  return this$static.getTime();
}

function $setHours(this$static, hours){
  this$static.setHours(hours);
  return this$static.getTime();
}

function $setHours_0(this$static, hours, mins, secs, ms){
  this$static.setHours(hours, mins, secs, ms);
  return this$static.getTime();
}

function $setMinutes(this$static, minutes){
  this$static.setMinutes(minutes);
  return this$static.getTime();
}

function $setSeconds(this$static, seconds){
  this$static.setSeconds(seconds);
  return this$static.getTime();
}

function $setTime(this$static, milliseconds){
  this$static.setTime(milliseconds);
  return this$static.getTime();
}

function create_1(year, month, dayOfMonth, hours, minutes, seconds, millis){
  return new Date(year, month, dayOfMonth, hours, minutes, seconds, millis);
}

function $flushPostEventPumpCommands(this$static){
  var oldDeferred;
  if (this$static.deferredCommands) {
    oldDeferred = this$static.deferredCommands;
    this$static.deferredCommands = null;
    !this$static.incrementalCommands && (this$static.incrementalCommands = []);
    runScheduledTasks(oldDeferred, this$static.incrementalCommands);
  }
  !!this$static.incrementalCommands && (this$static.incrementalCommands = runRepeatingTasks(this$static.incrementalCommands));
}

function $isWorkQueued(this$static){
  return !!this$static.deferredCommands || !!this$static.incrementalCommands;
}

function $maybeSchedulePostEventPumpCommands(this$static){
  if (!this$static.shouldBeRunning) {
    this$static.shouldBeRunning = true;
    !this$static.flusher && (this$static.flusher = new SchedulerImpl$Flusher_0(this$static));
    scheduleFixedDelayImpl(this$static.flusher, 1);
    !this$static.rescue && (this$static.rescue = new SchedulerImpl$Rescuer_0(this$static));
    scheduleFixedDelayImpl(this$static.rescue, 50);
  }
}

function $scheduleDeferred(this$static, cmd){
  this$static.deferredCommands = push(this$static.deferredCommands, [cmd, false]);
  $maybeSchedulePostEventPumpCommands(this$static);
}

function execute(cmd){
  return cmd.execute();
}

function runRepeatingTasks(tasks){
  var canceledSomeTasks, i, length_0, newTasks, start, t;
  length_0 = tasks.length;
  if (length_0 == 0) {
    return null;
  }
  canceledSomeTasks = false;
  start = currentTimeMillis();
  while (currentTimeMillis() - start < 100) {
    for (i = 0; i < length_0; ++i) {
      t = tasks[i];
      if (!t) {
        continue;
      }
      if (!t[0].execute()) {
        tasks[i] = null;
        canceledSomeTasks = true;
      }
    }
  }
  if (canceledSomeTasks) {
    newTasks = [];
    for (i = 0; i < length_0; ++i) {
      !!tasks[i] && (newTasks[newTasks.length] = tasks[i] , undefined);
    }
    return newTasks.length == 0?null:newTasks;
  }
   else {
    return tasks;
  }
}

function scheduleFixedDelayImpl(cmd, delayMs){
  $clinit_SchedulerImpl();
  $wnd.setTimeout(function(){
    var ret = $entry(execute)(cmd);
    ret && $wnd.setTimeout(arguments.callee, delayMs);
  }
  , delayMs);
}

function SchedulerImpl$Flusher_0(this$0){
  this.this$0 = this$0;
}

defineSeed(26, 1, {}, SchedulerImpl$Flusher_0);
_.execute = function execute_0(){
  this.this$0.flushRunning = true;
  $flushPostEventPumpCommands(this.this$0);
  this.this$0.flushRunning = false;
  return this.this$0.shouldBeRunning = $isWorkQueued(this.this$0);
}
;
_.this$0 = null;
function SchedulerImpl$Rescuer_0(this$0){
  this.this$0 = this$0;
}

defineSeed(27, 1, {}, SchedulerImpl$Rescuer_0);
_.execute = function execute_1(){
  this.this$0.flushRunning && scheduleFixedDelayImpl(this.this$0.flusher, 1);
  return this.this$0.shouldBeRunning;
}
;
_.this$0 = null;
function $getFirstChildElement(elem){
  var child = elem.firstChild;
  while (child && child.nodeType != 1)
    child = child.nextSibling;
  return child;
}

function valueOf_0(enumType, name_0){
  var enumValueOfFunc;
  enumValueOfFunc = enumType.enumValueOfFunc;
  if (!enumValueOfFunc) {
    throw new IllegalArgumentException_0;
  }
  return enumValueOfFunc(name_0);
}

function $doRemoveNow(this$static, type, source, handler){
  var l_0, removed, sourceMap;
  l_0 = $getHandlerList(this$static, type, source);
  removed = l_0.remove_1(handler);
  removed && l_0.isEmpty_0() && (sourceMap = dynamicCast(this$static.map_0.get_2(type), Q$Map) , dynamicCast(sourceMap.remove_4(source), Q$List) , sourceMap.isEmpty_0() && this$static.map_0.remove_4(type) , undefined);
}

function $doRemove(this$static, type, source, handler){
  this$static.firingDepth > 0?$defer(this$static, new SimpleEventBus$3_0(this$static, type, source, handler)):$doRemoveNow(this$static, type, source, handler);
}

function encode(decodedURL){
  throwIfNull('decodedURL', decodedURL);
  return encodeURI(decodedURL);
}

function $getDefaultNative(){
  return ['JPY', '\uFFE5', 0, 'JP\xA5', '\xA5'];
}

function $getNumberConstants(this$static){
  !this$static.numberConstants && (this$static.numberConstants = new NumberConstantsImpl_ja_0);
  return this$static.numberConstants;
}

function $clinit_NumberFormat(){
  $clinit_NumberFormat = nullMethod;
  $getNumberConstants(($clinit_LocaleInfo() , $clinit_LocaleInfo() , instance_0));
}

function $addExponent(this$static, digits){
  var exponentDigits, i;
  digits.impl.string += 'E';
  if (this$static.exponent < 0) {
    this$static.exponent = -this$static.exponent;
    digits.impl.string += '-';
  }
  exponentDigits = '' + this$static.exponent;
  for (i = exponentDigits.length; i < this$static.minExponentDigits; ++i) {
    digits.impl.string += '0';
  }
  $append_2(digits.impl, exponentDigits);
}

function $addZeroAndDecimal(this$static, digits, decimalSeparator){
  if (this$static.digitsLength == 0) {
    $replace(digits.impl, 0, 0, '0');
    ++this$static.decimalPosition;
    ++this$static.digitsLength;
  }
  if (this$static.decimalPosition < this$static.digitsLength || this$static.decimalSeparatorAlwaysShown) {
    $insert_0(digits, this$static.decimalPosition, String.fromCharCode(decimalSeparator));
    ++this$static.digitsLength;
  }
}

function $adjustFractionDigits(this$static, digits){
  var requiredDigits, toRemove;
  requiredDigits = this$static.decimalPosition + this$static.minimumFractionDigits;
  if (this$static.digitsLength < requiredDigits) {
    while (this$static.digitsLength < requiredDigits) {
      digits.impl.string += '0';
      ++this$static.digitsLength;
    }
  }
   else {
    toRemove = this$static.decimalPosition + this$static.maximumFractionDigits;
    toRemove > this$static.digitsLength && (toRemove = this$static.digitsLength);
    while (toRemove > requiredDigits && $charAt(digits.impl.string, toRemove - 1) == 48) {
      --toRemove;
    }
    if (toRemove < this$static.digitsLength) {
      $delete_0(digits, toRemove, this$static.digitsLength);
      this$static.digitsLength = toRemove;
    }
  }
}

function $computeExponent(this$static, digits){
  var remainder, strip;
  strip = 0;
  while (strip < this$static.digitsLength - 1 && $charAt(digits.impl.string, strip) == 48) {
    ++strip;
  }
  if (strip > 0) {
    $replace(digits.impl, 0, strip, '');
    this$static.digitsLength -= strip;
    this$static.exponent -= strip;
  }
  if (this$static.maximumIntegerDigits > this$static.minimumIntegerDigits && this$static.maximumIntegerDigits > 0) {
    this$static.exponent += this$static.decimalPosition - 1;
    remainder = this$static.exponent % this$static.maximumIntegerDigits;
    remainder < 0 && (remainder += this$static.maximumIntegerDigits);
    this$static.decimalPosition = remainder + 1;
    this$static.exponent -= remainder;
  }
   else {
    this$static.exponent += this$static.decimalPosition - this$static.minimumIntegerDigits;
    this$static.decimalPosition = this$static.minimumIntegerDigits;
  }
  if (this$static.digitsLength == 1 && digits.impl.string.charCodeAt(0) == 48) {
    this$static.exponent = 0;
    this$static.decimalPosition = this$static.minimumIntegerDigits;
  }
}

function $format_0(this$static, number){
  var buf, isNegative, preRound, scale, useExponent, currentGroupingSize;
  if (isNaN(number)) {
    return 'NaN\uFF08\u975E\u6570\uFF09';
  }
  isNegative = number < 0 || number == 0 && 1 / number < 0;
  isNegative && (number = -number);
  buf = new StringBuilder_0;
  if (!isFinite(number)) {
    $append_13(buf, isNegative?this$static.negativePrefix:this$static.positivePrefix);
    buf.impl.string += '\u221E';
    $append_13(buf, isNegative?this$static.negativeSuffix:this$static.positiveSuffix);
    return buf.impl.string;
  }
  number *= this$static.multiplier;
  scale = toScaledString(buf, number);
  preRound = buf.impl.string.length + scale + this$static.maximumFractionDigits + 3;
  if (preRound > 0 && preRound < buf.impl.string.length && $charAt(buf.impl.string, preRound) == 57) {
    $propagateCarry(this$static, buf, preRound - 1);
    scale += buf.impl.string.length - preRound;
    $delete_0(buf, preRound, buf.impl.string.length);
  }
  this$static.exponent = 0;
  this$static.digitsLength = buf.impl.string.length;
  this$static.decimalPosition = this$static.digitsLength + scale;
  useExponent = this$static.useExponentialNotation;
  currentGroupingSize = this$static.groupingSize;
  this$static.decimalPosition > 1024 && (useExponent = true);
  useExponent && $computeExponent(this$static, buf);
  $processLeadingZeros(this$static, buf);
  $roundValue(this$static, buf);
  $insertGroupingSeparators(this$static, buf, 44, currentGroupingSize);
  $adjustFractionDigits(this$static, buf);
  $addZeroAndDecimal(this$static, buf, 46);
  useExponent && $addExponent(this$static, buf);
  $insert_0(buf, 0, isNegative?this$static.negativePrefix:this$static.positivePrefix);
  $append_13(buf, isNegative?this$static.negativeSuffix:this$static.positiveSuffix);
  return buf.impl.string;
}

function $insertGroupingSeparators(this$static, digits, groupingSeparator, g){
  var i;
  if (g > 0) {
    for (i = g; i < this$static.decimalPosition; i += g + 1) {
      $insert_0(digits, this$static.decimalPosition - i, String.fromCharCode(groupingSeparator));
      ++this$static.decimalPosition;
      ++this$static.digitsLength;
    }
  }
}

function $parse(this$static, text){
  var pos, result;
  pos = initValues(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, [0]);
  result = $parse_0(this$static, text, pos);
  if (pos[0] == 0 || pos[0] != text.length) {
    throw new NumberFormatException_1(text);
  }
  return result;
}

function $parse_0(this$static, text, inOutPos){
  var gotNegative, gotNegativePrefix, gotNegativeSuffix, gotPositive, gotPositivePrefix, gotPositiveSuffix, ret, tempPos, valueOnly;
  gotPositivePrefix = $startsWith(text, this$static.positivePrefix, inOutPos[0]);
  gotNegativePrefix = $startsWith(text, this$static.negativePrefix, inOutPos[0]);
  gotPositiveSuffix = $endsWith(text, this$static.positiveSuffix);
  gotNegativeSuffix = $endsWith(text, this$static.negativeSuffix);
  gotPositive = gotPositivePrefix && gotPositiveSuffix;
  gotNegative = gotNegativePrefix && gotNegativeSuffix;
  if (gotPositive && gotNegative) {
    this$static.positivePrefix.length > this$static.negativePrefix.length?(gotNegative = false):this$static.positivePrefix.length < this$static.negativePrefix.length?(gotPositive = false):this$static.positiveSuffix.length > this$static.negativeSuffix.length?(gotNegative = false):this$static.positiveSuffix.length < this$static.negativeSuffix.length?(gotPositive = false):(gotNegative = false);
  }
   else if (!gotPositive && !gotNegative) {
    throw new NumberFormatException_1(text + ' does not have either positive or negative affixes');
  }
  if (gotPositive) {
    inOutPos[0] += this$static.positivePrefix.length;
    valueOnly = $substring_0(text, inOutPos[0], text.length - this$static.positiveSuffix.length);
  }
   else {
    inOutPos[0] += this$static.negativePrefix.length;
    valueOnly = $substring_0(text, inOutPos[0], text.length - this$static.negativeSuffix.length);
  }
  if ($equals_6(valueOnly, '\u221E')) {
    inOutPos[0] += 1;
    ret = Infinity;
  }
   else if ($equals_6(valueOnly, 'NaN\uFF08\u975E\u6570\uFF09')) {
    inOutPos[0] += 7;
    ret = NaN;
  }
   else {
    tempPos = initValues(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, [0]);
    ret = $parseNumber(this$static, valueOnly, tempPos);
    inOutPos[0] += tempPos[0];
  }
  gotPositive?(inOutPos[0] += this$static.positiveSuffix.length):gotNegative && (inOutPos[0] += this$static.negativeSuffix.length);
  gotNegative && (ret = -ret);
  return ret;
}

function $parseAffix(this$static, pattern, start, affix, inNegativePattern){
  var ch, inQuote, len, pos;
  $delete(affix, affix.impl.string.length);
  inQuote = false;
  len = pattern.length;
  for (pos = start; pos < len; ++pos) {
    ch = pattern.charCodeAt(pos);
    if (ch == 39) {
      if (pos + 1 < len && pattern.charCodeAt(pos + 1) == 39) {
        ++pos;
        affix.impl.string += "'";
      }
       else {
        inQuote = !inQuote;
      }
      continue;
    }
    if (inQuote) {
      $appendNonNull(affix.impl, String.fromCharCode(ch));
    }
     else {
      switch (ch) {
        case 35:
        case 48:
        case 44:
        case 46:
        case 59:
          return pos - start;
        case 164:
          this$static.isCurrencyFormat = true;
          if (pos + 1 < len && pattern.charCodeAt(pos + 1) == 164) {
            ++pos;
            if (pos < len - 3 && pattern.charCodeAt(pos + 1) == 164 && pattern.charCodeAt(pos + 2) == 164) {
              pos += 2;
              $append_6(affix, $getSimpleCurrencySymbol(this$static.currencyData));
            }
             else {
              $append_6(affix, this$static.currencyData[0]);
            }
          }
           else {
            $append_6(affix, this$static.currencyData[1]);
          }

          break;
        case 37:
          if (!inNegativePattern) {
            if (this$static.multiplier != 1) {
              throw new IllegalArgumentException_1('Too many percent/per mille characters in pattern "' + pattern + '"');
            }
            this$static.multiplier = 100;
          }

          affix.impl.string += '%';
          break;
        case 8240:
          if (!inNegativePattern) {
            if (this$static.multiplier != 1) {
              throw new IllegalArgumentException_1('Too many percent/per mille characters in pattern "' + pattern + '"');
            }
            this$static.multiplier = 1000;
          }

          affix.impl.string += '\u2030';
          break;
        case 45:
          affix.impl.string += '-';
          break;
        default:$appendNonNull(affix.impl, String.fromCharCode(ch));
      }
    }
  }
  return len - start;
}

function $parseNumber(this$static, text, pos){
  var $e0, ch, decimal, digit, grouping, normalizedText, ret, sawDecimal, sawDigit, sawExponent, scale;
  sawDecimal = false;
  sawExponent = false;
  sawDigit = false;
  scale = 1;
  decimal = this$static.isCurrencyFormat?'.':'.';
  grouping = this$static.isCurrencyFormat?',':',';
  normalizedText = new StringBuffer_0;
  for (; pos[0] < text.length; ++pos[0]) {
    ch = text.charCodeAt(pos[0]);
    digit = 48 <= ch && ch <= 57?ch - 48:48 <= ch && ch <= 57?ch - 48:-1;
    if (digit >= 0 && digit <= 9) {
      $appendNonNull(normalizedText.impl, String.fromCharCode(digit + 48 & 65535));
      sawDigit = true;
    }
     else if (ch == decimal.charCodeAt(0)) {
      if (sawDecimal || sawExponent) {
        break;
      }
      normalizedText.impl.string += '.';
      sawDecimal = true;
    }
     else if (ch == grouping.charCodeAt(0)) {
      if (sawDecimal || sawExponent) {
        break;
      }
      continue;
    }
     else if (ch == 69) {
      if (sawExponent) {
        break;
      }
      normalizedText.impl.string += 'E';
      sawExponent = true;
    }
     else if (ch == 43 || ch == 45) {
      $appendNonNull(normalizedText.impl, String.fromCharCode(ch));
    }
     else if (ch == 37) {
      if (scale != 1) {
        break;
      }
      scale = 100;
      if (sawDigit) {
        ++pos[0];
        break;
      }
    }
     else if (ch == 8240) {
      if (scale != 1) {
        break;
      }
      scale = 1000;
      if (sawDigit) {
        ++pos[0];
        break;
      }
    }
     else {
      break;
    }
  }
  try {
    ret = __parseAndValidateDouble(normalizedText.impl.string);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$NumberFormatException)) {
      throw new NumberFormatException_1(text);
    }
     else 
      throw $e0;
  }
  ret = ret / scale;
  return ret;
}

function $parsePattern_0(this$static, pattern){
  var affix, pos;
  pos = 0;
  affix = new StringBuffer_0;
  pos += $parseAffix(this$static, pattern, 0, affix, false);
  this$static.positivePrefix = affix.impl.string;
  pos += $parseTrunk(this$static, pattern, pos, false);
  pos += $parseAffix(this$static, pattern, pos, affix, false);
  this$static.positiveSuffix = affix.impl.string;
  if (pos < pattern.length && pattern.charCodeAt(pos) == 59) {
    ++pos;
    pos += $parseAffix(this$static, pattern, pos, affix, true);
    this$static.negativePrefix = affix.impl.string;
    pos += $parseTrunk(this$static, pattern, pos, true);
    pos += $parseAffix(this$static, pattern, pos, affix, true);
    this$static.negativeSuffix = affix.impl.string;
  }
   else {
    this$static.negativePrefix = '-' + this$static.positivePrefix;
    this$static.negativeSuffix = this$static.positiveSuffix;
  }
}

function $parseTrunk(this$static, pattern, start, ignorePattern){
  var ch, decimalPos, digitLeftCount, digitRightCount, effectiveDecimalPos, groupingCount, len, loop, n, pos, totalDigits, zeroDigitCount;
  decimalPos = -1;
  digitLeftCount = 0;
  zeroDigitCount = 0;
  digitRightCount = 0;
  groupingCount = -1;
  len = pattern.length;
  pos = start;
  loop = true;
  for (; pos < len && loop; ++pos) {
    ch = pattern.charCodeAt(pos);
    switch (ch) {
      case 35:
        zeroDigitCount > 0?++digitRightCount:++digitLeftCount;
        groupingCount >= 0 && decimalPos < 0 && ++groupingCount;
        break;
      case 48:
        if (digitRightCount > 0) {
          throw new IllegalArgumentException_1("Unexpected '0' in pattern \"" + pattern + '"');
        }

        ++zeroDigitCount;
        groupingCount >= 0 && decimalPos < 0 && ++groupingCount;
        break;
      case 44:
        groupingCount = 0;
        break;
      case 46:
        if (decimalPos >= 0) {
          throw new IllegalArgumentException_1('Multiple decimal separators in pattern "' + pattern + '"');
        }

        decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
        break;
      case 69:
        if (!ignorePattern) {
          if (this$static.useExponentialNotation) {
            throw new IllegalArgumentException_1('Multiple exponential symbols in pattern "' + pattern + '"');
          }
          this$static.useExponentialNotation = true;
          this$static.minExponentDigits = 0;
        }

        while (pos + 1 < len && pattern.charCodeAt(pos + 1) == 48) {
          ++pos;
          ignorePattern || ++this$static.minExponentDigits;
        }

        if (!ignorePattern && digitLeftCount + zeroDigitCount < 1 || this$static.minExponentDigits < 1) {
          throw new IllegalArgumentException_1('Malformed exponential pattern "' + pattern + '"');
        }

        loop = false;
        break;
      default:--pos;
        loop = false;
    }
  }
  if (zeroDigitCount == 0 && digitLeftCount > 0 && decimalPos >= 0) {
    n = decimalPos;
    decimalPos == 0 && ++n;
    digitRightCount = digitLeftCount - n;
    digitLeftCount = n - 1;
    zeroDigitCount = 1;
  }
  if (decimalPos < 0 && digitRightCount > 0 || decimalPos >= 0 && (decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount == 0) {
    throw new IllegalArgumentException_1('Malformed pattern "' + pattern + '"');
  }
  if (ignorePattern) {
    return pos - start;
  }
  totalDigits = digitLeftCount + zeroDigitCount + digitRightCount;
  this$static.maximumFractionDigits = decimalPos >= 0?totalDigits - decimalPos:0;
  if (decimalPos >= 0) {
    this$static.minimumFractionDigits = digitLeftCount + zeroDigitCount - decimalPos;
    this$static.minimumFractionDigits < 0 && (this$static.minimumFractionDigits = 0);
  }
  effectiveDecimalPos = decimalPos >= 0?decimalPos:totalDigits;
  this$static.minimumIntegerDigits = effectiveDecimalPos - digitLeftCount;
  if (this$static.useExponentialNotation) {
    this$static.maximumIntegerDigits = digitLeftCount + this$static.minimumIntegerDigits;
    this$static.maximumFractionDigits == 0 && this$static.minimumIntegerDigits == 0 && (this$static.minimumIntegerDigits = 1);
  }
  this$static.groupingSize = groupingCount > 0?groupingCount:0;
  this$static.decimalSeparatorAlwaysShown = decimalPos == 0 || decimalPos == totalDigits;
  return pos - start;
}

function $processLeadingZeros(this$static, digits){
  var i, prefix, strip;
  if (this$static.decimalPosition > this$static.digitsLength) {
    while (this$static.digitsLength < this$static.decimalPosition) {
      digits.impl.string += '0';
      ++this$static.digitsLength;
    }
  }
  if (!this$static.useExponentialNotation) {
    if (this$static.decimalPosition < this$static.minimumIntegerDigits) {
      prefix = new StringBuilder_0;
      while (this$static.decimalPosition < this$static.minimumIntegerDigits) {
        prefix.impl.string += '0';
        ++this$static.decimalPosition;
        ++this$static.digitsLength;
      }
      $insert_0(digits, 0, prefix.impl.string);
    }
     else if (this$static.decimalPosition > this$static.minimumIntegerDigits) {
      strip = this$static.decimalPosition - this$static.minimumIntegerDigits;
      for (i = 0; i < strip; ++i) {
        if ($charAt(digits.impl.string, i) != 48) {
          strip = i;
          break;
        }
      }
      if (strip > 0) {
        $replace(digits.impl, 0, strip, '');
        this$static.digitsLength -= strip;
        this$static.decimalPosition -= strip;
      }
    }
  }
}

function $propagateCarry(this$static, digits, i){
  var carry, digit;
  carry = true;
  while (carry && i >= 0) {
    digit = $charAt(digits.impl.string, i);
    if (digit == 57) {
      $setCharAt(digits, i--, 48);
    }
     else {
      $setCharAt(digits, i, digit + 1 & 65535);
      carry = false;
    }
  }
  if (carry) {
    $replace(digits.impl, 0, 0, '1');
    ++this$static.decimalPosition;
    ++this$static.digitsLength;
  }
}

function $roundValue(this$static, digits){
  var i;
  if (this$static.digitsLength > this$static.decimalPosition + this$static.maximumFractionDigits && $charAt_0(digits, this$static.decimalPosition + this$static.maximumFractionDigits) >= 53) {
    i = this$static.decimalPosition + this$static.maximumFractionDigits - 1;
    $propagateCarry(this$static, digits, i);
  }
}

function NumberFormat_0(pattern, cdata, userSuppliedPattern){
  if (!cdata) {
    throw new IllegalArgumentException_1('Unknown currency code');
  }
  this.pattern = pattern;
  this.currencyData = cdata;
  $parsePattern_0(this, this.pattern);
  if (!userSuppliedPattern && this.isCurrencyFormat) {
    this.minimumFractionDigits = this.currencyData[2] & 7;
    this.maximumFractionDigits = this.minimumFractionDigits;
  }
}

function NumberFormat_1(pattern, cdata, userSuppliedPattern){
  $clinit_NumberFormat();
  NumberFormat_0.call(this, pattern, cdata, userSuppliedPattern);
}

function toScaledString(buf, val){
  var dot, expDigits, expIdx, scale, startLen;
  startLen = buf.impl.string.length;
  $append_13(buf, val.toPrecision(20));
  scale = 0;
  expIdx = $indexOf_3(buf.impl.string, 'e', startLen);
  expIdx < 0 && (expIdx = $indexOf_3(buf.impl.string, 'E', startLen));
  if (expIdx >= 0) {
    expDigits = expIdx + 1;
    expDigits < buf.impl.string.length && $charAt(buf.impl.string, expDigits) == 43 && ++expDigits;
    expDigits < buf.impl.string.length && (scale = __parseAndValidateInt($substring(buf.impl.string, expDigits)));
    $delete_0(buf, expIdx, buf.impl.string.length);
  }
  dot = $indexOf_3(buf.impl.string, '.', startLen);
  if (dot >= 0) {
    $replace(buf.impl, dot, dot + 1, '');
    scale -= buf.impl.string.length - dot;
  }
  return scale;
}

defineSeed(97, 1, {}, NumberFormat_1);
_.currencyData = null;
_.decimalPosition = 0;
_.decimalSeparatorAlwaysShown = false;
_.digitsLength = 0;
_.exponent = 0;
_.groupingSize = 3;
_.isCurrencyFormat = false;
_.maximumFractionDigits = 3;
_.maximumIntegerDigits = 40;
_.minExponentDigits = 0;
_.minimumFractionDigits = 0;
_.minimumIntegerDigits = 1;
_.multiplier = 1;
_.negativePrefix = '-';
_.negativeSuffix = '';
_.pattern = null;
_.positivePrefix = '';
_.positiveSuffix = '';
_.useExponentialNotation = false;
var cachedDecimalFormat = null;
function NumberConstantsImpl_ja_0(){
}

defineSeed(99, 1, {}, NumberConstantsImpl_ja_0);
function $getSimpleCurrencySymbol(this$static){
  return this$static[4] || this$static[1];
}

function $after(this$static, when){
  return gt(this$static.getTime_0(), when.getTime_0());
}

function $fixDaylightSavings(this$static, hours){
  var badHours, copy, day, newTime, timeDiff, timeDiffHours, timeDiffMinutes;
  if (this$static.jsdate.getHours() % 24 != hours % 24) {
    copy = create_0(this$static.jsdate.getTime());
    $setDate(copy, copy.getDate() + 1);
    timeDiff = this$static.jsdate.getTimezoneOffset() - copy.getTimezoneOffset();
    if (timeDiff > 0) {
      timeDiffHours = ~~(timeDiff / 60);
      timeDiffMinutes = timeDiff % 60;
      day = this$static.jsdate.getDate();
      badHours = this$static.jsdate.getHours();
      badHours + timeDiffHours >= 24 && ++day;
      newTime = create_1(this$static.jsdate.getFullYear(), this$static.jsdate.getMonth(), day, hours + timeDiffHours, this$static.jsdate.getMinutes() + timeDiffMinutes, this$static.jsdate.getSeconds(), this$static.jsdate.getMilliseconds());
      $setTime(this$static.jsdate, newTime.getTime());
    }
  }
}

function $setTime_0(this$static, time){
  $setTime(this$static.jsdate, toDouble(time));
}

function Date_2(year, month, date, hrs, min){
  this.jsdate = new Date;
  $setFullYear(this.jsdate, year + 1900, month, date);
  $setHours_0(this.jsdate, hrs, min, 0, 0);
  $fixDaylightSavings(this, hrs);
}

defineSeed(106, 1, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), Date_2);
_.setDate_0 = function setDate(date){
  var hours;
  hours = this.jsdate.getHours();
  $setDate(this.jsdate, date);
  $fixDaylightSavings(this, hours);
}
;
_.setHours_0 = function setHours(hours){
  $setHours(this.jsdate, hours);
  $fixDaylightSavings(this, hours);
}
;
_.setMinutes_0 = function setMinutes(minutes){
  var hours;
  hours = this.getHours_0() + ~~(minutes / 60);
  $setMinutes(this.jsdate, minutes);
  $fixDaylightSavings(this, hours);
}
;
_.setSeconds_0 = function setSeconds(seconds){
  var hours;
  hours = this.getHours_0() + ~~(seconds / 3600);
  $setSeconds(this.jsdate, seconds);
  $fixDaylightSavings(this, hours);
}
;
_.setTime_0 = function setTime(time){
  $setTime_0(this, time);
}
;
function DateRecord_0(){
  Date_1.call(this);
  this.era = -1;
  this.ambiguousYear = false;
  this.year = -2147483648;
  this.month = -1;
  this.dayOfMonth = -1;
  this.ampm = -1;
  this.hours = -1;
  this.minutes = -1;
  this.seconds = -1;
  this.milliseconds = -1;
  this.dayOfWeek = -1;
  this.tzOffset = -2147483648;
}

defineSeed(105, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), DateRecord_0);
_.setHours_0 = function setHours_0(hours){
  this.hours = hours;
}
;
_.setMinutes_0 = function setMinutes_0(minutes){
  this.minutes = minutes;
}
;
_.setSeconds_0 = function setSeconds_0(seconds){
  this.seconds = seconds;
}
;
_.ambiguousYear = false;
_.ampm = 0;
_.dayOfMonth = 0;
_.dayOfWeek = 0;
_.era = 0;
_.hours = 0;
_.milliseconds = 0;
_.minutes = 0;
_.month = 0;
_.seconds = 0;
_.tzOffset = 0;
_.year = 0;
function deserialize_1(streamReader, instance){
  setAmbiguousYear(instance, $readBoolean(streamReader));
  setAmpm(instance, $readInt(streamReader));
  setDayOfMonth(instance, $readInt(streamReader));
  setDayOfWeek(instance, $readInt(streamReader));
  setEra(instance, $readInt(streamReader));
  setHours_1(instance, $readInt(streamReader));
  setMilliseconds(instance, $readInt(streamReader));
  setMinutes_1(instance, $readInt(streamReader));
  setMonth(instance, $readInt(streamReader));
  setSeconds_1(instance, $readInt(streamReader));
  setTzOffset(instance, $readInt(streamReader));
  setYear(instance, $readInt(streamReader));
}

function instantiate_1(streamReader){
  return new DateRecord_0;
}

function serialize(streamWriter, instance){
  $writeBoolean(streamWriter, instance.ambiguousYear);
  $writeInt(streamWriter, instance.ampm);
  $writeInt(streamWriter, instance.dayOfMonth);
  $writeInt(streamWriter, instance.dayOfWeek);
  $writeInt(streamWriter, instance.era);
  $writeInt(streamWriter, instance.hours);
  $writeInt(streamWriter, instance.milliseconds);
  $writeInt(streamWriter, instance.minutes);
  $writeInt(streamWriter, instance.month);
  $writeInt(streamWriter, instance.seconds);
  $writeInt(streamWriter, instance.tzOffset);
  $writeInt(streamWriter, instance.year);
  $append_4(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
}

function setAmbiguousYear(instance, value){
  instance.ambiguousYear = value;
}

function setAmpm(instance, value){
  instance.ampm = value;
}

function setDayOfMonth(instance, value){
  instance.dayOfMonth = value;
}

function setDayOfWeek(instance, value){
  instance.dayOfWeek = value;
}

function setEra(instance, value){
  instance.era = value;
}

function setHours_1(instance, value){
  instance.hours = value;
}

function setMilliseconds(instance, value){
  instance.milliseconds = value;
}

function setMinutes_1(instance, value){
  instance.minutes = value;
}

function setMonth(instance, value){
  instance.month = value;
}

function setSeconds_1(instance, value){
  instance.seconds = value;
}

function setTzOffset(instance, value){
  instance.tzOffset = value;
}

function setYear(instance, value){
  instance.year = value;
}

function appendChild(parent_0, child){
  $appendChild(parent_0, ($clinit_PotentialElement() , child.__gwt_resolve?child.__gwt_resolve():child));
}

function back_0(){
  $clinit_History();
  $wnd.history.back();
}

function $setEventListener(elem, listener){
  elem.__listener = listener;
}

function $sinkEventsImpl(elem, bits){
  var chMask = (elem.__eventBits || 0) ^ bits;
  elem.__eventBits = bits;
  if (!chMask)
    return;
  chMask & 1 && (elem.onclick = bits & 1?dispatchEvent_1:null);
  chMask & 2 && (elem.ondblclick = bits & 2?dispatchEvent_1:null);
  chMask & 4 && (elem.onmousedown = bits & 4?dispatchEvent_1:null);
  chMask & 8 && (elem.onmouseup = bits & 8?dispatchEvent_1:null);
  chMask & 16 && (elem.onmouseover = bits & 16?dispatchEvent_1:null);
  chMask & 32 && (elem.onmouseout = bits & 32?dispatchEvent_1:null);
  chMask & 64 && (elem.onmousemove = bits & 64?dispatchEvent_1:null);
  chMask & 128 && (elem.onkeydown = bits & 128?dispatchEvent_1:null);
  chMask & 256 && (elem.onkeypress = bits & 256?dispatchEvent_1:null);
  chMask & 512 && (elem.onkeyup = bits & 512?dispatchEvent_1:null);
  chMask & 1024 && (elem.onchange = bits & 1024?dispatchEvent_1:null);
  chMask & 2048 && (elem.onfocus = bits & 2048?dispatchEvent_1:null);
  chMask & 4096 && (elem.onblur = bits & 4096?dispatchEvent_1:null);
  chMask & 8192 && (elem.onlosecapture = bits & 8192?dispatchEvent_1:null);
  chMask & 16384 && (elem.onscroll = bits & 16384?dispatchEvent_1:null);
  chMask & 32768 && (elem.onload = bits & 32768?dispatchUnhandledEvent:null);
  chMask & 65536 && (elem.onerror = bits & 65536?dispatchEvent_1:null);
  chMask & 131072 && (elem.onmousewheel = bits & 131072?dispatchEvent_1:null);
  chMask & 262144 && (elem.oncontextmenu = bits & 262144?dispatchEvent_1:null);
  chMask & 524288 && (elem.onpaste = bits & 524288?dispatchEvent_1:null);
  chMask & 1048576 && (elem.ontouchstart = bits & 1048576?dispatchEvent_1:null);
  chMask & 2097152 && (elem.ontouchmove = bits & 2097152?dispatchEvent_1:null);
  chMask & 4194304 && (elem.ontouchend = bits & 4194304?dispatchEvent_1:null);
  chMask & 8388608 && (elem.ontouchcancel = bits & 8388608?dispatchEvent_1:null);
  chMask & 16777216 && (elem.ongesturestart = bits & 16777216?dispatchEvent_1:null);
  chMask & 33554432 && (elem.ongesturechange = bits & 33554432?dispatchEvent_1:null);
  chMask & 67108864 && (elem.ongestureend = bits & 67108864?dispatchEvent_1:null);
}

function $sinkEvents(elem, bits){
  $maybeInitializeEventSystem();
  $sinkEventsImpl(elem, bits);
  bits & 131072 && elem.addEventListener('DOMMouseScroll', dispatchEvent_1, false);
}

function deserialize_35(streamReader, instance){
  var i, n;
  for (i = 0 , n = instance.length; i < n; ++i) {
    instance[i] = $getString(streamReader, $readInt(streamReader));
  }
}

function instantiate_34(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, size, 0);
}

function deserialize_44(streamReader, instance){
}

function instantiate_43(streamReader){
  return new Date_5($readLong(streamReader));
}

function serialize_15(streamWriter, instance){
  $append_4(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
}

function deserialize_45(streamReader, instance){
}

function instantiate_44(streamReader){
  return new Time_0($readLong(streamReader));
}

function serialize_16(streamWriter, instance){
  $append_4(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
}

function deserialize_46(streamReader, instance){
  $setNanos(instance, $readInt(streamReader));
}

function instantiate_45(streamReader){
  return new Timestamp_0($readLong(streamReader));
}

function serialize_17(streamWriter, instance){
  $append_4(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
  $writeInt(streamWriter, instance.nanos);
}

function deserialize_47(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_46(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_AbstractList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$AbstractList, size, 0);
}

function deserialize_48(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_47(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_AbstractSequentialList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$AbstractSequentialList, size, 0);
}

function deserialize_49(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_48(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_ArrayList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ArrayList, size, 0);
}

function deserialize_58(streamReader, instance){
}

function instantiate_56(streamReader){
  return new Date_3($readLong(streamReader));
}

function serialize_25(streamWriter, instance){
  $append_4(streamWriter, toBase64(instance.getTime_0()));
}

function deserialize_60(streamReader, instance){
  deserialize_69(streamReader, instance);
}

function instantiate_58(streamReader){
  var clazz, exemplar;
  exemplar = $readObject(streamReader);
  clazz = getClass__devirtual$(exemplar);
  return new EnumMap_0(clazz);
}

function deserialize_66(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_64(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_LinkedList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$LinkedList, size, 0);
}

function deserialize_68(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_66(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_List_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$List, size, 0);
}

function deserialize_71(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_68(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_Stack_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Stack, size, 0);
}

function deserialize_76(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_73(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_Vector_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Vector, size, 0);
}

function setStylePrimaryName(elem, style){
  if (!elem) {
    throw new RuntimeException_1('Null widget handle. If you are creating a composite, ensure that initWidget() has been called.');
  }
  style = $trim(style);
  if (style.length == 0) {
    throw new IllegalArgumentException_1('Style names cannot be empty');
  }
  updatePrimaryAndDependentStyleNames(elem, style);
}

function updatePrimaryAndDependentStyleNames(elem, newPrimaryStyle){
  var classes = elem.className.split(/\s+/);
  if (!classes) {
    return;
  }
  var oldPrimaryStyle = classes[0];
  var oldPrimaryStyleLen = oldPrimaryStyle.length;
  classes[0] = newPrimaryStyle;
  for (var i = 1, n = classes.length; i < n; i++) {
    var name_0 = classes[i];
    name_0.length > oldPrimaryStyleLen && name_0.charAt(oldPrimaryStyleLen) == '-' && name_0.indexOf(oldPrimaryStyle) == 0 && (classes[i] = newPrimaryStyle + name_0.substring(oldPrimaryStyleLen));
  }
  elem.className = classes.join(' ');
}

function $onAttach(this$static){
  var bitsToAdd;
  if (this$static.attached) {
    throw new IllegalStateException_1("Should only call onAttach when the widget is detached from the browser's document");
  }
  this$static.attached = true;
  $setEventListener(this$static.getElement(), this$static);
  bitsToAdd = this$static.eventsToSink;
  this$static.eventsToSink = -1;
  bitsToAdd > 0 && (this$static.eventsToSink == -1?$sinkEvents(this$static.getElement(), bitsToAdd | (this$static.getElement().__eventBits || 0)):(this$static.eventsToSink |= bitsToAdd));
  this$static.doAttachChildren();
}

function $onDetach(this$static){
  if (!this$static.attached) {
    throw new IllegalStateException_1("Should only call onDetach when the widget is attached to the browser's document");
  }
  try {
    this$static.doDetachChildren();
  }
   finally {
    this$static.getElement().__listener = null;
    this$static.attached = false;
  }
}

function $removeFromParent(this$static){
  if (!this$static.parent_0) {
    ($clinit_RootPanel() , $contains_2(widgetsToDetach, this$static)) && detachNow(this$static);
  }
   else if (this$static.parent_0) {
    $remove_1(this$static.parent_0, this$static);
  }
   else if (this$static.parent_0) {
    throw new IllegalStateException_1("This widget's parent does not implement HasWidgets");
  }
}

function $setParent_0(this$static, parent_0){
  var oldParent;
  oldParent = this$static.parent_0;
  if (!parent_0) {
    try {
      !!oldParent && oldParent.attached && $onDetach(this$static);
    }
     finally {
      this$static.parent_0 = null;
    }
  }
   else {
    if (oldParent) {
      throw new IllegalStateException_1('Cannot set a new parent without first clearing the old parent');
    }
    this$static.parent_0 = parent_0;
    parent_0.attached && this$static.onAttach();
  }
}

defineSeed(287, 288, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget]));
_.doAttachChildren = function doAttachChildren(){
}
;
_.doDetachChildren = function doDetachChildren(){
}
;
_.onAttach = function onAttach(){
  $onAttach(this);
}
;
defineSeed(286, 287, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$Iterable]));
_.doAttachChildren = function doAttachChildren_0(){
  tryCommand(this, ($clinit_AttachDetachException() , attachCommand));
}
;
_.doDetachChildren = function doDetachChildren_0(){
  tryCommand(this, ($clinit_AttachDetachException() , detachCommand));
}
;
function $add_0(this$static, child, container){
  $removeFromParent(child);
  $add_4(this$static.children_0, child);
  appendChild(container, child.element);
  $setParent_0(child, this$static);
}

function $remove_0(this$static, w){
  var elem;
  if (w.parent_0 != this$static) {
    return false;
  }
  try {
    $setParent_0(w, null);
  }
   finally {
    elem = w.getElement();
    $removeChild($getParentElement(elem), elem);
    $remove_6(this$static.children_0, w);
  }
  return true;
}

defineSeed(285, 286, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$Iterable]));
_.iterator = function iterator_1(){
  return new WidgetCollection$WidgetIterator_0(this.children_0);
}
;
_.remove_0 = function remove_0(w){
  return $remove_0(this, w);
}
;
function $add_1(this$static, w){
  $add_0(this$static, w, this$static.element);
}

function $remove_1(this$static, w){
  var removed;
  removed = $remove_0(this$static, w);
  removed && changeToStaticPositioning(w.getElement());
  return removed;
}

function changeToStaticPositioning(elem){
  elem.style['left'] = '';
  elem.style['top'] = '';
  elem.style['position'] = '';
}

defineSeed(284, 285, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$Iterable]));
_.remove_0 = function remove_1(w){
  return $remove_1(this, w);
}
;
function $clinit_AttachDetachException(){
  $clinit_AttachDetachException = nullMethod;
  attachCommand = new AttachDetachException$1_0;
  detachCommand = new AttachDetachException$2_0;
}

function AttachDetachException_0(causes){
  UmbrellaException_4.call(this, causes);
}

function tryCommand(hasWidgets, c){
  $clinit_AttachDetachException();
  var $e0, caught, e, w, w$iterator;
  caught = null;
  for (w$iterator = hasWidgets.iterator(); w$iterator.hasNext();) {
    w = dynamicCast(w$iterator.next_0(), Q$Widget);
    try {
      c.execute_0(w);
    }
     catch ($e0) {
      $e0 = caught_0($e0);
      if (instanceOf($e0, Q$Throwable)) {
        e = $e0;
        !caught && (caught = new HashSet_0);
        $add_7(caught, e);
      }
       else 
        throw $e0;
    }
  }
  if (caught) {
    throw new AttachDetachException_0(caught);
  }
}

defineSeed(289, 67, makeCastMap([Q$UmbrellaException, Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable]), AttachDetachException_0);
var attachCommand, detachCommand;
function AttachDetachException$1_0(){
}

defineSeed(290, 1, {}, AttachDetachException$1_0);
_.execute_0 = function execute_2(w){
  w.onAttach();
}
;
function AttachDetachException$2_0(){
}

defineSeed(291, 1, {}, AttachDetachException$2_0);
_.execute_0 = function execute_3(w){
  $onDetach(w);
}
;
function $clear_0(this$static){
  var iter;
  iter = this$static.iterator();
  while (iter.hasNext()) {
    iter.next_0();
    iter.remove_3();
  }
}

function $removeAll(this$static, c){
  var changed, iter;
  iter = new AbstractList$IteratorImpl_0(this$static);
  changed = false;
  while (iter.i < iter.this$0_0.size_1()) {
    if ($indexOf_0(c, $next_0(iter), 0) != -1) {
      $remove_8(iter);
      changed = true;
    }
  }
  return changed;
}

defineSeed(295, 1, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection]));
_.clear_0 = function clear(){
  $clear_0(this);
}
;
_.remove_1 = function remove_2(o){
  return $remove_2(this, o);
}
;
defineSeed(294, 295, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List]));
_.clear_0 = function clear_0(){
  $clear_1(this);
}
;
_.set_0 = function set_0(index, o){
  throw new UnsupportedOperationException_1('Set not supported on this list');
}
;
_.subList = function subList(fromIndex, toIndex){
  return new AbstractList$SubList_0(this, fromIndex, toIndex);
}
;
function ArrayList_2(c){
  $$init(this);
  spliceArray(this.array, 0, 0, c.toArray());
  this.size_0 = this.array.length;
}

defineSeed(293, 294, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), ArrayList_2);
_.clear_0 = function clear_1(){
  $clear_2(this);
}
;
_.remove_1 = function remove_5(o){
  return $remove_4(this, o);
}
;
_.set_0 = function set_1(index, o){
  return $set(this, index, o);
}
;
function ChangeListenerCollection_0(){
  $$init(this);
}

defineSeed(292, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), ChangeListenerCollection_0);
function deserialize_83(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_80(streamReader){
  return new ChangeListenerCollection_0;
}

function ClickListenerCollection_0(){
  $$init(this);
}

defineSeed(297, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), ClickListenerCollection_0);
function deserialize_84(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_81(streamReader){
  return new ClickListenerCollection_0;
}

function FocusListenerCollection_0(){
  $$init(this);
}

defineSeed(300, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), FocusListenerCollection_0);
function deserialize_85(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_82(streamReader){
  return new FocusListenerCollection_0;
}

function $setHorizontalAlignment(this$static, align){
  this$static.autoHorizontalAlignment = align;
  $updateHorizontalAlignment(this$static);
}

function $setText(this$static, text){
  $setTextOrHtml(this$static.directionalTextHelper, text, false);
  $updateHorizontalAlignment(this$static);
}

function KeyboardListenerCollection_0(){
  $$init(this);
}

defineSeed(307, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), KeyboardListenerCollection_0);
function deserialize_86(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_83(streamReader){
  return new KeyboardListenerCollection_0;
}

function $clinit_PotentialElement(){
  $clinit_PotentialElement = nullMethod;
  declareShim();
}

function declareShim(){
  var shim = function(){
  }
  ;
  shim.prototype = {className:'', clientHeight:0, clientWidth:0, dir:'', getAttribute:function(name_0, value){
    return this[name_0];
  }
  , href:'', id:'', lang:'', nodeType:1, removeAttribute:function(name_0, value){
    this[name_0] = undefined;
  }
  , setAttribute:function(name_0, value){
    this[name_0] = value;
  }
  , src:'', style:{}, title:''};
  $wnd.GwtPotentialElementShim = shim;
}

function RootPanel_0(elem){
  this.children_0 = new WidgetCollection_0(this);
  this.element = elem;
  $onAttach(this);
}

function detachNow(widget){
  $clinit_RootPanel();
  try {
    $onDetach(widget);
  }
   finally {
    $remove_11(widgetsToDetach, widget);
  }
}

function detachWidgets(){
  $clinit_RootPanel();
  try {
    tryCommand(widgetsToDetach, maybeDetachCommand);
  }
   finally {
    widgetsToDetach.map_0.clear_0();
    rootPanels.clear_0();
  }
}

function get_1(id){
  $clinit_RootPanel();
  var elem, rp;
  rp = dynamicCast(rootPanels.get_2(id), Q$RootPanel);
  elem = null;
  if (id != null) {
    if (!(elem = $getElementById($doc, id))) {
      return null;
    }
  }
  if (rp) {
    if (!elem || rp.element == elem) {
      return rp;
    }
  }
  if (rootPanels.size_1() == 0) {
    addCloseHandler(new RootPanel$2_0);
    ($clinit_LocaleInfo() , false) && setDirectionOnElement($doc, ($clinit_HasDirection$Direction() , RTL));
  }
  !elem?(rp = new RootPanel$DefaultRootPanel_0):(rp = new RootPanel_0(elem));
  rootPanels.put(id, rp);
  $add_7(widgetsToDetach, rp);
  return rp;
}

defineSeed(310, 284, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$RootPanel, Q$UIObject, Q$Widget, Q$Iterable]), RootPanel_0);
defineSeed(311, 1, {});
_.execute_0 = function execute_4(w){
  w.attached && $onDetach(w);
}
;
function RootPanel$2_0(){
}

defineSeed(312, 1, makeCastMap([Q$CloseHandler, Q$EventHandler]), RootPanel$2_0);
_.onClose = function onClose_0(closeEvent){
  detachWidgets();
}
;
function RootPanel$DefaultRootPanel_0(){
  RootPanel_0.call(this, getBodyElement());
}

defineSeed(313, 310, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$RootPanel, Q$UIObject, Q$Widget, Q$Iterable]), RootPanel$DefaultRootPanel_0);
function $add_4(this$static, w){
  $insert(this$static, w, this$static.size_0);
}

function $indexOf_1(this$static, w){
  var i;
  for (i = 0; i < this$static.size_0; ++i) {
    if (this$static.array[i] == w) {
      return i;
    }
  }
  return -1;
}

function $insert(this$static, w, beforeIndex){
  var i, newArray;
  if (beforeIndex < 0 || beforeIndex > this$static.size_0) {
    throw new IndexOutOfBoundsException_0;
  }
  if (this$static.size_0 == this$static.array.length) {
    newArray = initDim(_3Lcom_google_gwt_user_client_ui_Widget_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Widget, this$static.array.length * 2, 0);
    for (i = 0; i < this$static.array.length; ++i) {
      setCheck(newArray, i, this$static.array[i]);
    }
    this$static.array = newArray;
  }
  ++this$static.size_0;
  for (i = this$static.size_0 - 1; i > beforeIndex; --i) {
    setCheck(this$static.array, i, this$static.array[i - 1]);
  }
  setCheck(this$static.array, beforeIndex, w);
}

function $remove_5(this$static, index){
  var i;
  if (index < 0 || index >= this$static.size_0) {
    throw new IndexOutOfBoundsException_0;
  }
  --this$static.size_0;
  for (i = index; i < this$static.size_0; ++i) {
    setCheck(this$static.array, i, this$static.array[i + 1]);
  }
  setCheck(this$static.array, this$static.size_0, null);
}

function $remove_6(this$static, w){
  var index;
  index = $indexOf_1(this$static, w);
  if (index == -1) {
    throw new NoSuchElementException_0;
  }
  $remove_5(this$static, index);
}

function WidgetCollection_0(parent_0){
  this.parent_0 = parent_0;
  this.array = initDim(_3Lcom_google_gwt_user_client_ui_Widget_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Widget, 4, 0);
}

defineSeed(314, 1, makeCastMap([Q$Iterable]), WidgetCollection_0);
_.iterator = function iterator_3(){
  return new WidgetCollection$WidgetIterator_0(this);
}
;
_.array = null;
_.parent_0 = null;
_.size_0 = 0;
function $next(this$static){
  if (this$static.index_0 >= this$static.this$0.size_0) {
    throw new NoSuchElementException_0;
  }
  return this$static.this$0.array[++this$static.index_0];
}

function WidgetCollection$WidgetIterator_0(this$0){
  this.this$0 = this$0;
}

defineSeed(315, 1, {}, WidgetCollection$WidgetIterator_0);
_.hasNext = function hasNext(){
  return this.index_0 < this.this$0.size_0 - 1;
}
;
_.next_0 = function next_0(){
  return $next(this);
}
;
_.remove_3 = function remove_6(){
  if (this.index_0 < 0 || this.index_0 >= this.this$0.size_0) {
    throw new IllegalStateException_0;
  }
  this.this$0.parent_0.remove_0(this.this$0.array[this.index_0--]);
}
;
_.index_0 = -1;
_.this$0 = null;
function $clinit_CalendarUtil(){
  $clinit_CalendarUtil = nullMethod;
  $getDateTimeFormatInfo(($clinit_LocaleInfo() , $clinit_LocaleInfo() , instance_0));
}

function addDaysToDate(date, days){
  $clinit_CalendarUtil();
  date.setDate_0(date.getDate_0() + days);
}

function copyDate(date){
  var newDate;
  if (!date) {
    return null;
  }
  newDate = new Date_1;
  newDate.setTime_0(date.getTime_0());
  return newDate;
}

function getDaysBetween(start, finish){
  $clinit_CalendarUtil();
  var aTime, adjust, bTime;
  start = copyDate(start);
  resetTime(start);
  finish = copyDate(finish);
  resetTime(finish);
  aTime = start.getTime_0();
  bTime = finish.getTime_0();
  adjust = P36ee80_longLit;
  adjust = gt(bTime, aTime)?adjust:neg(adjust);
  return toInt(div(add(sub(bTime, aTime), adjust), P5265c00_longLit));
}

function resetTime(date){
  var msec;
  msec = date.getTime_0();
  msec = mul(div(msec, P3e8_longLit), P3e8_longLit);
  date.setTime_0(msec);
  date.setHours_0(12);
  date.setMinutes_0(0);
  date.setSeconds_0(0);
}

function $removeHandler(this$static){
  $doRemove(this$static.this$0, this$static.val$type, this$static.val$source, this$static.val$handler);
}

function SimpleEventBus$3_0(this$0, val$type, val$source, val$handler){
  this.this$0 = this$0;
  this.val$type = val$type;
  this.val$source = val$source;
  this.val$handler = val$handler;
}

defineSeed(325, 1, makeCastMap([Q$SimpleEventBus$Command]), SimpleEventBus$3_0);
_.execute_1 = function execute_6(){
  $doRemoveNow(this.this$0, this.val$type, this.val$source, this.val$handler);
}
;
_.this$0 = null;
_.val$handler = null;
_.val$source = null;
_.val$type = null;
function $getAttributeAsJavaScriptObject(this$static, property){
  var ret;
  if (this$static.isCreated()) {
    var widget = this$static.getJsObj();
    ret = widget.getProperty(property);
  }
   else {
    var config = this$static.config;
    if (config[property] != undefined) {
      ret = config[property];
    }
     else {
      var scClassName = this$static.scClassName;
      ret = eval('($wnd.isc.' + scClassName + ".getInstanceProperty('" + property + "'))");
    }
  }
  return ret === undefined?null:ret;
}

function $setAttribute(this$static, value){
  var self_0;
  $isCreated(this$static)?$isCreated(this$static)?($getJsObj(this$static)['root'] = value , undefined):(self_0 = this$static.getJsObj() , self_0.setProperty('root', value) , undefined):(this$static.config['root'] = value , undefined);
}

function $setAttribute_0(this$static, attribute, value, allowPostCreate){
  $isCreated_0(this$static)?allowPostCreate?$setProperty_0(this$static, attribute, value.value_0):undefined:setAttribute_5(this$static.config, attribute, value);
}

function $setAttribute_1(this$static, attribute, value, allowPostCreate){
  this$static.isCreated()?allowPostCreate?this$static.setProperty_0(attribute, value):undefined:(this$static.config[attribute] = value , undefined);
}

function $setProperty(this$static, property, value){
  var self_0 = this$static.getJsObj();
  self_0.setProperty(property, value);
}

function $setProperty_0(this$static, property, value){
  var self_0 = this$static.getJsObj();
  self_0.setProperty(property, value);
}

defineSeed(329, 1, makeCastMap([Q$BaseClass]));
_.setProperty_0 = function setProperty(property, value){
  $setProperty(this, property, value);
}
;
defineSeed(331, 1, makeCastMap([Q$JsObject]));
_.setJsObj = function setJsObj(jsObj){
  this.jsObj = jsObj;
}
;
function $getAttributeAsBoolean_0(this$static, property){
  return $clinit_Boolean() , getAttributeAsBoolean(this$static.jsObj, property)?TRUE:FALSE;
}

function $getAttributeAsDouble(this$static, property){
  return getAttributeAsDouble(this$static.jsObj, property);
}

function $getAttributeAsJavaScriptObject_0(this$static, property){
  return getAttributeAsJavaScriptObject(this$static.jsObj, property);
}

function $getAttributeAsLong(this$static, property){
  var dVal;
  dVal = getAttributeAsDouble(this$static.jsObj, property);
  return !dVal?null:valueOf_50(fromDouble(dVal.value_0));
}

function $setAttribute_6(this$static, value){
  this$static.jsObj['optionDataSource'] = !value?null:$getOrCreateJsObj(value);
}

function $setAttribute_9(this$static, property, value){
  setAttribute_6(this$static.jsObj, property, value);
}

function $setAttribute_10(this$static, property, value){
  setAttribute_7(this$static.jsObj, property, value);
}

function $setAttribute_15(this$static, property, value){
  setAttribute_10(this$static.jsObj, property, value);
}

function $setAttribute_17(this$static, property, value){
  this$static.jsObj[property] = convertToJavaScriptArray_0(value);
}

function Criteria_0(){
  DataClass_0.call(this);
}

function Criteria_2(field, value){
  Criteria_0.call(this);
  this.jsObj[field] = value;
}

defineSeed(336, 330, makeCastMap([Q$DataClass, Q$JsObject]), Criteria_0, Criteria_2);
function $getCriteria(this$static){
  if (dynamicCast(getEnum(($clinit_DSOperationType() , $clinit_DSOperationType() , $VALUES_10), getAttribute(this$static.jsObj, 'operationType')), Q$DSOperationType) == FETCH) {
    return !getAttributeAsJavaScriptObject(this$static.jsObj, 'data')?null:new Criteria_1(getAttributeAsJavaScriptObject(this$static.jsObj, 'data'));
  }
   else {
    throw new IllegalStateException_1('This method should only be called during FETCH operations');
  }
}

function $getSortBy(this$static){
  var self_0 = this$static.getJsObj();
  var sortBy = self_0.sortBy;
  if (sortBy == null || sortBy === undefined)
    return null;
  $wnd.isc.isA.Array(sortBy) && (sortBy = sortBy.join(','));
  return convertToArray(sortBy);
}

function $setAttribute_18(this$static, value){
  !value?(this$static.jsObj['parameters'] = null , undefined):(this$static.jsObj['parameters'] = value , undefined);
}

function $setEndRow(this$static, endRow){
  setAttribute_8(this$static.jsObj, 'endRow', endRow);
}

function $setStartRow(this$static, startRow){
  setAttribute_8(this$static.jsObj, 'startRow', startRow);
}

function DSRequest_0(){
  DataClass_0.call(this);
}

defineSeed(337, 338, makeCastMap([Q$DataClass, Q$JsObject]), DSRequest_0);
function $getData(this$static){
  var dataJS;
  dataJS = getAttributeAsJavaScriptObject(this$static.jsObj, 'data');
  return convertToRecordArray(dataJS);
}

function $getErrors(this$static){
  var jsObj, result;
  jsObj = getAttributeAsJavaScriptObject(this$static.jsObj, 'errors');
  isArray(jsObj) && (jsObj = (result = jsObj[0] , result == null || result === undefined?null:result));
  return convertToMap(jsObj);
}

function $setTotalRows(this$static, totalRows){
  setAttribute_8(this$static.jsObj, 'totalRows', totalRows);
}

function DSResponse_0(){
  DataClass_0.call(this);
}

defineSeed(339, 340, makeCastMap([Q$DataClass, Q$JsObject]), DSResponse_0);
function $fetchData(this$static, criteria, callback){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $fetchData_0(this$static, criteria, callback, requestProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  var requestPropertiesJS = requestProperties == null?null:requestProperties.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ), requestPropertiesJS);
}

function $getField(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getField(fieldName);
  if (ret == null || ret === undefined)
    return null;
  return new DataSourceField_0(ret);
}

function $getFieldNames(this$static, excludeHidden){
  var self_0 = this$static.getOrCreateJsObj();
  var value = self_0.getFieldNames(excludeHidden);
  if (value == null)
    return null;
  !isArray(value) && (value = [value]);
  return convertToJavaStringArray(value);
}

function $processResponse(this$static, requestId, responseProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var responsePropertiesJS = responseProperties == null?null:responseProperties.getJsObj();
  self_0.processResponse(requestId, responsePropertiesJS);
}

function $setCacheAllData(this$static, cacheAllData){
  $isCreated_0(this$static)?$setProperty_0(this$static, 'cacheAllData', cacheAllData.value_0):setAttribute_5(this$static.config, 'cacheAllData', cacheAllData);
}

function $setCanMultiSort(this$static, canMultiSort){
  $isCreated_0(this$static)?undefined:setAttribute_5(this$static.config, 'canMultiSort', canMultiSort);
}

function $setDropExtraFields(this$static, dropExtraFields){
  $isCreated_0(this$static)?undefined:setAttribute_5(this$static.config, 'dropExtraFields', dropExtraFields);
}

function DataSourceField_0(jsObj){
  this.jsObj = jsObj;
}

function DataSourceField_1(name_0, type){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  $setAttribute_13(this, 'type', type.value_0);
}

function DataSourceField_3(name_0, type, title, length_0){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  $setAttribute_13(this, 'type', type.value_0);
  this.jsObj['title'] = title;
  $setAttribute_11(this, 'length', valueOf_49(length_0));
}

function DataSourceField_4(name_0, type, title, length_0){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  $setAttribute_13(this, 'type', type.value_0);
  this.jsObj['title'] = title;
  $setAttribute_11(this, 'length', valueOf_49(length_0));
  $setAttribute_8(this, 'required', ($clinit_Boolean() , $clinit_Boolean() , TRUE));
}

function getOrCreateRef_0(jsObj){
  if (!jsObj)
    return null;
  return new DataSourceField_0(jsObj);
}

defineSeed(342, 330, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceField_0);
function $getEndDate(this$static){
  if (this$static.endDate)
    return this$static.endDate;
  if (this$static.relativeEndDate)
    return getAbsoluteDate_0(this$static.relativeEndDate);
  return null;
}

function $getStartDate(this$static){
  if (this$static.startDate)
    return this$static.startDate;
  if (this$static.relativeStartDate)
    return getAbsoluteDate_0(this$static.relativeStartDate);
  return null;
}

function $isEmpty_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isEmpty();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

defineSeed(346, 330, makeCastMap([Q$DataClass, Q$JsObject, Q$RelativeDate]));
_.getValue_0 = function getValue(){
  return this.value_0;
}
;
defineSeed(347, 345, makeCastMap([Q$HasHandlers, Q$BaseClass]));
_.setProperty_0 = function setProperty_0(property, value){
  this.jsObj[property] = value;
}
;
function convertToArray(sortByString){
  var i, sortDirection, sortField, sortFields, sortSpecifiers;
  if (sortByString == null) {
    return initValues(_3Lcom_smartgwt_client_data_SortSpecifier_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SortSpecifier, []);
  }
  sortFields = $split(sortByString, ',', 0);
  sortSpecifiers = initDim(_3Lcom_smartgwt_client_data_SortSpecifier_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SortSpecifier, sortFields.length, 0);
  for (i = 0; i < sortFields.length; ++i) {
    sortField = sortFields[i];
    sortDirection = ($clinit_SortDirection() , ASCENDING);
    if (sortField.indexOf('-') == 0) {
      sortDirection = DESCENDING;
      sortField = $substring_0(sortField, 1, sortField.length);
    }
    sortSpecifiers[i] = new SortSpecifier_0(sortField, sortDirection);
  }
  return sortSpecifiers;
}

function DataSourceBooleanField_0(name_0){
  DataSourceField_1.call(this, name_0, ($clinit_FieldType() , BOOLEAN_0));
}

defineSeed(349, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceBooleanField_0);
function DataSourceDateTimeField_0(name_0, title){
  DataSourceField_2.call(this, name_0, ($clinit_FieldType() , DATETIME), title);
}

defineSeed(350, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceDateTimeField_0);
function DataSourceImageField_0(){
  DataSourceField_1.call(this, 'category', ($clinit_FieldType() , IMAGE));
}

function DataSourceImageField_1(name_0, title){
  DataSourceField_2.call(this, name_0, ($clinit_FieldType() , IMAGE), title);
}

function DataSourceImageField_2(name_0, title){
  DataSourceField_3.call(this, name_0, ($clinit_FieldType() , IMAGE), title, 20);
}

defineSeed(351, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceImageField_0, DataSourceImageField_1, DataSourceImageField_2);
function DataSourceIntegerField_0(){
  DataSourceField_1.call(this, 'count', ($clinit_FieldType() , INTEGER));
}

function DataSourceIntegerField_1(name_0, title){
  DataSourceField_2.call(this, name_0, ($clinit_FieldType() , INTEGER), title);
}

function DataSourceIntegerField_2(name_0, title, length_0){
  DataSourceField_3.call(this, name_0, ($clinit_FieldType() , INTEGER), title, length_0);
}

defineSeed(352, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceIntegerField_0, DataSourceIntegerField_1, DataSourceIntegerField_2);
function DataSourceLinkField_0(){
  DataSourceField_1.call(this, 'typeName', ($clinit_FieldType() , LINK));
}

function DataSourceLinkField_1(){
  DataSourceField_2.call(this, 'parent', ($clinit_FieldType() , LINK), '\u89AA');
}

defineSeed(353, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceLinkField_0, DataSourceLinkField_1);
function DataSourcePasswordField_0(name_0, title){
  DataSourceField_4.call(this, name_0, ($clinit_FieldType() , PASSWORD), title, 100);
}

defineSeed(354, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourcePasswordField_0);
function DataSourceTextField_0(name_0){
  DataSourceField_1.call(this, name_0, ($clinit_FieldType() , TEXT_0));
}

function DataSourceTextField_2(name_0, title, length_0){
  DataSourceField_3.call(this, name_0, ($clinit_FieldType() , TEXT_0), title, length_0);
}

function DataSourceTextField_3(name_0, title, length_0){
  DataSourceField_4.call(this, name_0, ($clinit_FieldType() , TEXT_0), title, length_0);
}

defineSeed(355, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceTextField_0, DataSourceTextField_2, DataSourceTextField_3);
function $clinit_AnimationEffect(){
  $clinit_AnimationEffect = nullMethod;
  SLIDE = new AnimationEffect_0('SLIDE', 0, 'slide');
  WIPE = new AnimationEffect_0('WIPE', 1, 'wipe');
  FADE = new AnimationEffect_0('FADE', 2, 'fade');
  FLY = new AnimationEffect_0('FLY', 3, 'fly');
  $VALUES_4 = initValues(_3Lcom_smartgwt_client_types_AnimationEffect_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$AnimationEffect, [SLIDE, WIPE, FADE, FLY]);
}

function AnimationEffect_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_6(name_0){
  $clinit_AnimationEffect();
  return valueOf(($clinit_AnimationEffect$Map() , $MAP_4), name_0);
}

function values_5(){
  $clinit_AnimationEffect();
  return $VALUES_4;
}

defineSeed(360, 49, makeCastMap([Q$AnimationEffect, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), AnimationEffect_0);
_.getValue_0 = function getValue_1(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_4, FADE, FLY, SLIDE, WIPE;
function $clinit_AnimationEffect$Map(){
  $clinit_AnimationEffect$Map = nullMethod;
  $MAP_4 = createValueOfMap(($clinit_AnimationEffect() , $VALUES_4));
}

var $MAP_4;
function $clinit_AutoFitWidthApproach(){
  $clinit_AutoFitWidthApproach = nullMethod;
  VALUE = new AutoFitWidthApproach_0('VALUE', 0, 'value');
  TITLE = new AutoFitWidthApproach_0('TITLE', 1, 'title');
  BOTH = new AutoFitWidthApproach_0('BOTH', 2, 'both');
  $VALUES_5 = initValues(_3Lcom_smartgwt_client_types_AutoFitWidthApproach_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$AutoFitWidthApproach, [VALUE, TITLE, BOTH]);
}

function AutoFitWidthApproach_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_7(name_0){
  $clinit_AutoFitWidthApproach();
  return valueOf(($clinit_AutoFitWidthApproach$Map() , $MAP_5), name_0);
}

function values_6(){
  $clinit_AutoFitWidthApproach();
  return $VALUES_5;
}

defineSeed(362, 49, makeCastMap([Q$AutoFitWidthApproach, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), AutoFitWidthApproach_0);
_.getValue_0 = function getValue_2(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_5, BOTH, TITLE, VALUE;
function $clinit_AutoFitWidthApproach$Map(){
  $clinit_AutoFitWidthApproach$Map = nullMethod;
  $MAP_5 = createValueOfMap(($clinit_AutoFitWidthApproach() , $VALUES_5));
}

var $MAP_5;
function $clinit_Autofit(){
  $clinit_Autofit = nullMethod;
  VERTICAL = new Autofit_0('VERTICAL', 0, 'vertical');
  HORIZONTAL = new Autofit_0('HORIZONTAL', 1, 'horizontal');
  BOTH_0 = new Autofit_0('BOTH', 2, 'both');
  $VALUES_6 = initValues(_3Lcom_smartgwt_client_types_Autofit_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Autofit, [VERTICAL, HORIZONTAL, BOTH_0]);
}

function Autofit_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_8(name_0){
  $clinit_Autofit();
  return valueOf(($clinit_Autofit$Map() , $MAP_6), name_0);
}

function values_7(){
  $clinit_Autofit();
  return $VALUES_6;
}

defineSeed(364, 49, makeCastMap([Q$Autofit, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Autofit_0);
_.getValue_0 = function getValue_3(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_6, BOTH_0, HORIZONTAL, VERTICAL;
function $clinit_Autofit$Map(){
  $clinit_Autofit$Map = nullMethod;
  $MAP_6 = createValueOfMap(($clinit_Autofit() , $VALUES_6));
}

var $MAP_6;
function $clinit_ContentsType(){
  $clinit_ContentsType = nullMethod;
  PAGE = new ContentsType_0('PAGE', 0, 'page');
  FRAGMENT = new ContentsType_0('FRAGMENT', 1, 'fragment');
  $VALUES_7 = initValues(_3Lcom_smartgwt_client_types_ContentsType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ContentsType, [PAGE, FRAGMENT]);
}

function ContentsType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_9(name_0){
  $clinit_ContentsType();
  return valueOf(($clinit_ContentsType$Map() , $MAP_7), name_0);
}

function values_8(){
  $clinit_ContentsType();
  return $VALUES_7;
}

defineSeed(366, 49, makeCastMap([Q$ContentsType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ContentsType_0);
_.getValue_0 = function getValue_4(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_7, FRAGMENT, PAGE;
function $clinit_ContentsType$Map(){
  $clinit_ContentsType$Map = nullMethod;
  $MAP_7 = createValueOfMap(($clinit_ContentsType() , $VALUES_7));
}

var $MAP_7;
function $clinit_Cursor(){
  $clinit_Cursor = nullMethod;
  DEFAULT_0 = new Cursor_0('DEFAULT', 0, 'default');
  AUTO = new Cursor_0('AUTO', 1, 'auto');
  WAIT = new Cursor_0('WAIT', 2, 'wait');
  HAND = new Cursor_0('HAND', 3, 'hand');
  MOVE = new Cursor_0('MOVE', 4, 'move');
  HELP = new Cursor_0('HELP', 5, 'help');
  TEXT = new Cursor_0('TEXT', 6, 'text');
  POINTER = new Cursor_0('POINTER', 7, 'pointer');
  ARROW = new Cursor_0('ARROW', 8, 'arrow');
  ALL_SCROLL = new Cursor_0('ALL_SCROLL', 9, 'all-scroll');
  CROSSHAIR = new Cursor_0('CROSSHAIR', 10, 'crosshair');
  COL_RESIZE = new Cursor_0('COL_RESIZE', 11, 'col-resize');
  ROW_RESIZE = new Cursor_0('ROW_RESIZE', 12, 'row-resize');
  E_RESIZE = new Cursor_0('E_RESIZE', 13, 'e-resize');
  W_RESIZE = new Cursor_0('W_RESIZE', 14, 'w-resize');
  N_RESIZE = new Cursor_0('N_RESIZE', 15, 'n-resize');
  S_RESIZE = new Cursor_0('S_RESIZE', 16, 's-resize');
  SE_RESIZE = new Cursor_0('SE_RESIZE', 17, 'se-resize');
  NE_RESIZE = new Cursor_0('NE_RESIZE', 18, 'ne-resize');
  NW_RESIZE = new Cursor_0('NW_RESIZE', 19, 'nw-resize');
  SW_RESIZE = new Cursor_0('SW_RESIZE', 20, 'sw-resize');
  NOT_ALLOWED = new Cursor_0('NOT_ALLOWED', 21, 'not-allowed');
  $VALUES_8 = initValues(_3Lcom_smartgwt_client_types_Cursor_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Cursor, [DEFAULT_0, AUTO, WAIT, HAND, MOVE, HELP, TEXT, POINTER, ARROW, ALL_SCROLL, CROSSHAIR, COL_RESIZE, ROW_RESIZE, E_RESIZE, W_RESIZE, N_RESIZE, S_RESIZE, SE_RESIZE, NE_RESIZE, NW_RESIZE, SW_RESIZE, NOT_ALLOWED]);
}

function Cursor_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_10(name_0){
  $clinit_Cursor();
  return valueOf(($clinit_Cursor$Map() , $MAP_8), name_0);
}

function values_9(){
  $clinit_Cursor();
  return $VALUES_8;
}

defineSeed(368, 49, makeCastMap([Q$Cursor, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Cursor_0);
_.getValue_0 = function getValue_5(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_8, ALL_SCROLL, ARROW, AUTO, COL_RESIZE, CROSSHAIR, DEFAULT_0, E_RESIZE, HAND, HELP, MOVE, NE_RESIZE, NOT_ALLOWED, NW_RESIZE, N_RESIZE, POINTER, ROW_RESIZE, SE_RESIZE, SW_RESIZE, S_RESIZE, TEXT, WAIT, W_RESIZE;
function $clinit_Cursor$Map(){
  $clinit_Cursor$Map = nullMethod;
  $MAP_8 = createValueOfMap(($clinit_Cursor() , $VALUES_8));
}

var $MAP_8;
function $clinit_DSDataFormat(){
  $clinit_DSDataFormat = nullMethod;
  ISCSERVER = new DSDataFormat_0('ISCSERVER', 0, 'iscServer');
  XML = new DSDataFormat_0('XML', 1, 'xml');
  JSON = new DSDataFormat_0('JSON', 2, 'json');
  CUSTOM = new DSDataFormat_0('CUSTOM', 3, 'custom');
  $VALUES_9 = initValues(_3Lcom_smartgwt_client_types_DSDataFormat_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DSDataFormat, [ISCSERVER, XML, JSON, CUSTOM]);
}

function DSDataFormat_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_11(name_0){
  $clinit_DSDataFormat();
  return valueOf(($clinit_DSDataFormat$Map() , $MAP_9), name_0);
}

function values_10(){
  $clinit_DSDataFormat();
  return $VALUES_9;
}

defineSeed(370, 49, makeCastMap([Q$DSDataFormat, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DSDataFormat_0);
_.getValue_0 = function getValue_6(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_9, CUSTOM, ISCSERVER, JSON, XML;
function $clinit_DSDataFormat$Map(){
  $clinit_DSDataFormat$Map = nullMethod;
  $MAP_9 = createValueOfMap(($clinit_DSDataFormat() , $VALUES_9));
}

var $MAP_9;
function $clinit_DSOperationType(){
  $clinit_DSOperationType = nullMethod;
  FETCH = new DSOperationType_0('FETCH', 0, 'fetch');
  ADD = new DSOperationType_0('ADD', 1, 'add');
  UPDATE = new DSOperationType_0('UPDATE', 2, 'update');
  REMOVE = new DSOperationType_0('REMOVE', 3, 'remove');
  VALIDATE = new DSOperationType_0('VALIDATE', 4, 'validate');
  CUSTOM_0 = new DSOperationType_0('CUSTOM', 5, 'custom');
  $VALUES_10 = initValues(_3Lcom_smartgwt_client_types_DSOperationType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DSOperationType, [FETCH, ADD, UPDATE, REMOVE, VALIDATE, CUSTOM_0]);
}

function DSOperationType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_12(name_0){
  $clinit_DSOperationType();
  return valueOf(($clinit_DSOperationType$Map() , $MAP_10), name_0);
}

function values_11(){
  $clinit_DSOperationType();
  return $VALUES_10;
}

defineSeed(372, 49, makeCastMap([Q$DSOperationType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DSOperationType_0);
_.getValue_0 = function getValue_7(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_10, ADD, CUSTOM_0, FETCH, REMOVE, UPDATE, VALIDATE;
function $clinit_DSOperationType$Map(){
  $clinit_DSOperationType$Map = nullMethod;
  $MAP_10 = createValueOfMap(($clinit_DSOperationType() , $VALUES_10));
}

var $MAP_10;
function $clinit_DSProtocol(){
  $clinit_DSProtocol = nullMethod;
  GETPARAMS = new DSProtocol_0('GETPARAMS', 0, 'getParams');
  POSTPARAMS = new DSProtocol_0('POSTPARAMS', 1, 'postParams');
  POSTXML = new DSProtocol_0('POSTXML', 2, 'postXML');
  SOAP = new DSProtocol_0('SOAP', 3, 'soap');
  POSTMESSAGE = new DSProtocol_0('POSTMESSAGE', 4, 'postMessage');
  CLIENTCUSTOM = new DSProtocol_0('CLIENTCUSTOM', 5, 'clientCustom');
  $VALUES_11 = initValues(_3Lcom_smartgwt_client_types_DSProtocol_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DSProtocol, [GETPARAMS, POSTPARAMS, POSTXML, SOAP, POSTMESSAGE, CLIENTCUSTOM]);
}

function DSProtocol_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_13(name_0){
  $clinit_DSProtocol();
  return valueOf(($clinit_DSProtocol$Map() , $MAP_11), name_0);
}

function values_12(){
  $clinit_DSProtocol();
  return $VALUES_11;
}

defineSeed(374, 49, makeCastMap([Q$DSProtocol, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DSProtocol_0);
_.getValue_0 = function getValue_8(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_11, CLIENTCUSTOM, GETPARAMS, POSTMESSAGE, POSTPARAMS, POSTXML, SOAP;
function $clinit_DSProtocol$Map(){
  $clinit_DSProtocol$Map = nullMethod;
  $MAP_11 = createValueOfMap(($clinit_DSProtocol() , $VALUES_11));
}

var $MAP_11;
function $clinit_DateDisplayFormat(){
  $clinit_DateDisplayFormat = nullMethod;
  TOSTRING = new DateDisplayFormat_0('TOSTRING', 0, 'toString');
  TOLOCALESTRING = new DateDisplayFormat_0('TOLOCALESTRING', 1, 'toLocaleString');
  TOUSSHORTDATE = new DateDisplayFormat_0('TOUSSHORTDATE', 2, 'toUSShortDate');
  TOUSSHORTDATETIME = new DateDisplayFormat_0('TOUSSHORTDATETIME', 3, 'toUSShortDatetime');
  TOEUROPEANSHORTDATE = new DateDisplayFormat_0('TOEUROPEANSHORTDATE', 4, 'toEuropeanShortDate');
  TOEUROPEANSHORTDATETIME = new DateDisplayFormat_0('TOEUROPEANSHORTDATETIME', 5, 'toEuropeanShortDatetime');
  TOJAPANSHORTDATE = new DateDisplayFormat_0('TOJAPANSHORTDATE', 6, 'toJapanShortDate');
  TOJAPANSHORTDATETIME = new DateDisplayFormat_0('TOJAPANSHORTDATETIME', 7, 'toJapanShortDatetime');
  TOSERIALIZEABLEDATE = new DateDisplayFormat_0('TOSERIALIZEABLEDATE', 8, 'toSerializeableDate');
  TODATESTAMP = new DateDisplayFormat_0('TODATESTAMP', 9, 'toDateStamp');
  $VALUES_12 = initValues(_3Lcom_smartgwt_client_types_DateDisplayFormat_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DateDisplayFormat, [TOSTRING, TOLOCALESTRING, TOUSSHORTDATE, TOUSSHORTDATETIME, TOEUROPEANSHORTDATE, TOEUROPEANSHORTDATETIME, TOJAPANSHORTDATE, TOJAPANSHORTDATETIME, TOSERIALIZEABLEDATE, TODATESTAMP]);
}

function DateDisplayFormat_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_14(name_0){
  $clinit_DateDisplayFormat();
  return valueOf(($clinit_DateDisplayFormat$Map() , $MAP_12), name_0);
}

function values_13(){
  $clinit_DateDisplayFormat();
  return $VALUES_12;
}

defineSeed(376, 49, makeCastMap([Q$DateDisplayFormat, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DateDisplayFormat_0);
_.getValue_0 = function getValue_9(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_12, TODATESTAMP, TOEUROPEANSHORTDATE, TOEUROPEANSHORTDATETIME, TOJAPANSHORTDATE, TOJAPANSHORTDATETIME, TOLOCALESTRING, TOSERIALIZEABLEDATE, TOSTRING, TOUSSHORTDATE, TOUSSHORTDATETIME;
function $clinit_DateDisplayFormat$Map(){
  $clinit_DateDisplayFormat$Map = nullMethod;
  $MAP_12 = createValueOfMap(($clinit_DateDisplayFormat() , $VALUES_12));
}

var $MAP_12;
function $clinit_DragAppearance(){
  $clinit_DragAppearance = nullMethod;
  NONE = new DragAppearance_0('NONE', 0, 'none');
  TRACKER = new DragAppearance_0('TRACKER', 1, 'tracker');
  TARGET = new DragAppearance_0('TARGET', 2, 'target');
  OUTLINE = new DragAppearance_0('OUTLINE', 3, 'outline');
  $VALUES_13 = initValues(_3Lcom_smartgwt_client_types_DragAppearance_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DragAppearance, [NONE, TRACKER, TARGET, OUTLINE]);
}

function DragAppearance_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_15(name_0){
  $clinit_DragAppearance();
  return valueOf(($clinit_DragAppearance$Map() , $MAP_13), name_0);
}

function values_14(){
  $clinit_DragAppearance();
  return $VALUES_13;
}

defineSeed(378, 49, makeCastMap([Q$DragAppearance, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DragAppearance_0);
_.getValue_0 = function getValue_10(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_13, NONE, OUTLINE, TARGET, TRACKER;
function $clinit_DragAppearance$Map(){
  $clinit_DragAppearance$Map = nullMethod;
  $MAP_13 = createValueOfMap(($clinit_DragAppearance() , $VALUES_13));
}

var $MAP_13;
function $clinit_DragDataAction(){
  $clinit_DragDataAction = nullMethod;
  NONE_0 = new DragDataAction_0('NONE', 0, 'none');
  COPY = new DragDataAction_0('COPY', 1, 'copy');
  MOVE_0 = new DragDataAction_0('MOVE', 2, 'move');
  $VALUES_14 = initValues(_3Lcom_smartgwt_client_types_DragDataAction_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DragDataAction, [NONE_0, COPY, MOVE_0]);
}

function DragDataAction_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_16(name_0){
  $clinit_DragDataAction();
  return valueOf(($clinit_DragDataAction$Map() , $MAP_14), name_0);
}

function values_15(){
  $clinit_DragDataAction();
  return $VALUES_14;
}

defineSeed(380, 49, makeCastMap([Q$DragDataAction, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DragDataAction_0);
_.getValue_0 = function getValue_11(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_14, COPY, MOVE_0, NONE_0;
function $clinit_DragDataAction$Map(){
  $clinit_DragDataAction$Map = nullMethod;
  $MAP_14 = createValueOfMap(($clinit_DragDataAction() , $VALUES_14));
}

var $MAP_14;
function $clinit_DragTrackerMode(){
  $clinit_DragTrackerMode = nullMethod;
  NONE_1 = new DragTrackerMode_0('NONE', 0, 'none');
  ICON = new DragTrackerMode_0('ICON', 1, 'icon');
  TITLE_0 = new DragTrackerMode_0('TITLE', 2, 'title');
  RECORD = new DragTrackerMode_0('RECORD', 3, 'record');
  $VALUES_15 = initValues(_3Lcom_smartgwt_client_types_DragTrackerMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DragTrackerMode, [NONE_1, ICON, TITLE_0, RECORD]);
}

function DragTrackerMode_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_17(name_0){
  $clinit_DragTrackerMode();
  return valueOf(($clinit_DragTrackerMode$Map() , $MAP_15), name_0);
}

function values_16(){
  $clinit_DragTrackerMode();
  return $VALUES_15;
}

defineSeed(382, 49, makeCastMap([Q$DragTrackerMode, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DragTrackerMode_0);
_.getValue_0 = function getValue_12(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_15, ICON, NONE_1, RECORD, TITLE_0;
function $clinit_DragTrackerMode$Map(){
  $clinit_DragTrackerMode$Map = nullMethod;
  $MAP_15 = createValueOfMap(($clinit_DragTrackerMode() , $VALUES_15));
}

var $MAP_15;
function $clinit_EmbeddedPosition(){
  $clinit_EmbeddedPosition = nullMethod;
  EXPAND = new EmbeddedPosition_0('EXPAND', 0, 'expand');
  WITHIN = new EmbeddedPosition_0('WITHIN', 1, 'within');
  $VALUES_16 = initValues(_3Lcom_smartgwt_client_types_EmbeddedPosition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$EmbeddedPosition, [EXPAND, WITHIN]);
}

function EmbeddedPosition_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_18(name_0){
  $clinit_EmbeddedPosition();
  return valueOf(($clinit_EmbeddedPosition$Map() , $MAP_16), name_0);
}

function values_17(){
  $clinit_EmbeddedPosition();
  return $VALUES_16;
}

defineSeed(384, 49, makeCastMap([Q$EmbeddedPosition, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), EmbeddedPosition_0);
_.getValue_0 = function getValue_13(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_16, EXPAND, WITHIN;
function $clinit_EmbeddedPosition$Map(){
  $clinit_EmbeddedPosition$Map = nullMethod;
  $MAP_16 = createValueOfMap(($clinit_EmbeddedPosition() , $VALUES_16));
}

var $MAP_16;
function $clinit_Encoding(){
  $clinit_Encoding = nullMethod;
  NORMAL = new Encoding_0('NORMAL', 0, 'normal');
  MULTIPART = new Encoding_0('MULTIPART', 1, 'multipart');
  $VALUES_17 = initValues(_3Lcom_smartgwt_client_types_Encoding_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Encoding, [NORMAL, MULTIPART]);
}

function Encoding_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_19(name_0){
  $clinit_Encoding();
  return valueOf(($clinit_Encoding$Map() , $MAP_17), name_0);
}

function values_18(){
  $clinit_Encoding();
  return $VALUES_17;
}

defineSeed(386, 49, makeCastMap([Q$Encoding, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Encoding_0);
_.getValue_0 = function getValue_14(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_17, MULTIPART, NORMAL;
function $clinit_Encoding$Map(){
  $clinit_Encoding$Map = nullMethod;
  $MAP_17 = createValueOfMap(($clinit_Encoding() , $VALUES_17));
}

var $MAP_17;
function $clinit_ExpansionMode(){
  $clinit_ExpansionMode = nullMethod;
  DETAIL_FIELD = new ExpansionMode_0('DETAIL_FIELD', 0, 'detailField');
  DETAILS = new ExpansionMode_0('DETAILS', 1, 'details');
  RELATED = new ExpansionMode_0('RELATED', 2, 'related');
  EDITOR = new ExpansionMode_0('EDITOR', 3, 'editor');
  DETAIL_RELATED = new ExpansionMode_0('DETAIL_RELATED', 4, 'detailRelated');
  $VALUES_18 = initValues(_3Lcom_smartgwt_client_types_ExpansionMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ExpansionMode, [DETAIL_FIELD, DETAILS, RELATED, EDITOR, DETAIL_RELATED]);
}

function ExpansionMode_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_20(name_0){
  $clinit_ExpansionMode();
  return valueOf(($clinit_ExpansionMode$Map() , $MAP_18), name_0);
}

function values_19(){
  $clinit_ExpansionMode();
  return $VALUES_18;
}

defineSeed(388, 49, makeCastMap([Q$ExpansionMode, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ExpansionMode_0);
_.getValue_0 = function getValue_15(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_18, DETAILS, DETAIL_FIELD, DETAIL_RELATED, EDITOR, RELATED;
function $clinit_ExpansionMode$Map(){
  $clinit_ExpansionMode$Map = nullMethod;
  $MAP_18 = createValueOfMap(($clinit_ExpansionMode() , $VALUES_18));
}

var $MAP_18;
function $clinit_FormLayoutType(){
  $clinit_FormLayoutType = nullMethod;
  TABLE = new FormLayoutType_0('TABLE', 0, 'table');
  ABSOLUTE = new FormLayoutType_0('ABSOLUTE', 1, 'absolute');
  $VALUES_21 = initValues(_3Lcom_smartgwt_client_types_FormLayoutType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$FormLayoutType, [TABLE, ABSOLUTE]);
}

function FormLayoutType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_23(name_0){
  $clinit_FormLayoutType();
  return valueOf(($clinit_FormLayoutType$Map() , $MAP_21), name_0);
}

function values_22(){
  $clinit_FormLayoutType();
  return $VALUES_21;
}

defineSeed(394, 49, makeCastMap([Q$FormLayoutType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), FormLayoutType_0);
_.getValue_0 = function getValue_18(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_21, ABSOLUTE, TABLE;
function $clinit_FormLayoutType$Map(){
  $clinit_FormLayoutType$Map = nullMethod;
  $MAP_21 = createValueOfMap(($clinit_FormLayoutType() , $VALUES_21));
}

var $MAP_21;
function $clinit_GroupStartOpen(){
  $clinit_GroupStartOpen = nullMethod;
  ALL = new GroupStartOpen_0('ALL', 0, 'all');
  FIRST = new GroupStartOpen_0('FIRST', 1, 'first');
  NONE_2 = new GroupStartOpen_0('NONE', 2, 'none');
  $VALUES_22 = initValues(_3Lcom_smartgwt_client_types_GroupStartOpen_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$GroupStartOpen, [ALL, FIRST, NONE_2]);
}

function GroupStartOpen_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_24(name_0){
  $clinit_GroupStartOpen();
  return valueOf(($clinit_GroupStartOpen$Map() , $MAP_22), name_0);
}

function values_23(){
  $clinit_GroupStartOpen();
  return $VALUES_22;
}

defineSeed(396, 49, makeCastMap([Q$GroupStartOpen, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), GroupStartOpen_0);
_.getValue_0 = function getValue_19(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_22, ALL, FIRST, NONE_2;
function $clinit_GroupStartOpen$Map(){
  $clinit_GroupStartOpen$Map = nullMethod;
  $MAP_22 = createValueOfMap(($clinit_GroupStartOpen() , $VALUES_22));
}

var $MAP_22;
function $clinit_HeaderControls(){
  $clinit_HeaderControls = nullMethod;
  HEADER_ICON = new HeaderControls_0('HEADER_ICON', 0, 'headerIcon');
  HEADER_LABEL = new HeaderControls_0('HEADER_LABEL', 1, 'headerLabel');
  MINIMIZE_BUTTON = new HeaderControls_0('MINIMIZE_BUTTON', 2, 'minimizeButton');
  MAXIMIZE_BUTTON = new HeaderControls_0('MAXIMIZE_BUTTON', 3, 'maximizeButton');
  CLOSE_BUTTON = new HeaderControls_0('CLOSE_BUTTON', 4, 'closeButton');
  $VALUES_23 = initValues(_3Lcom_smartgwt_client_types_HeaderControls_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$HeaderControls, [HEADER_ICON, HEADER_LABEL, MINIMIZE_BUTTON, MAXIMIZE_BUTTON, CLOSE_BUTTON]);
}

function HeaderControls_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_25(name_0){
  $clinit_HeaderControls();
  return valueOf(($clinit_HeaderControls$Map() , $MAP_23), name_0);
}

function values_24(){
  $clinit_HeaderControls();
  return $VALUES_23;
}

defineSeed(398, 49, makeCastMap([Q$HeaderControls, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), HeaderControls_0);
_.getValue_0 = function getValue_20(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_23, CLOSE_BUTTON, HEADER_ICON, HEADER_LABEL, MAXIMIZE_BUTTON, MINIMIZE_BUTTON;
function $clinit_HeaderControls$Map(){
  $clinit_HeaderControls$Map = nullMethod;
  $MAP_23 = createValueOfMap(($clinit_HeaderControls() , $VALUES_23));
}

var $MAP_23;
function $clinit_ImageStyle(){
  $clinit_ImageStyle = nullMethod;
  CENTER_1 = new ImageStyle_0('CENTER', 0, 'center');
  TILE = new ImageStyle_0('TILE', 1, 'tile');
  STRETCH = new ImageStyle_0('STRETCH', 2, 'stretch');
  NORMAL_0 = new ImageStyle_0('NORMAL', 3, 'normal');
  $VALUES_24 = initValues(_3Lcom_smartgwt_client_types_ImageStyle_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ImageStyle, [CENTER_1, TILE, STRETCH, NORMAL_0]);
}

function ImageStyle_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_26(name_0){
  $clinit_ImageStyle();
  return valueOf(($clinit_ImageStyle$Map() , $MAP_24), name_0);
}

function values_25(){
  $clinit_ImageStyle();
  return $VALUES_24;
}

defineSeed(400, 49, makeCastMap([Q$ImageStyle, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ImageStyle_0);
_.getValue_0 = function getValue_21(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_24, CENTER_1, NORMAL_0, STRETCH, TILE;
function $clinit_ImageStyle$Map(){
  $clinit_ImageStyle$Map = nullMethod;
  $MAP_24 = createValueOfMap(($clinit_ImageStyle() , $VALUES_24));
}

var $MAP_24;
function $clinit_LayoutPolicy(){
  $clinit_LayoutPolicy = nullMethod;
  NONE_3 = new LayoutPolicy_0('NONE', 0, 'none');
  FILL = new LayoutPolicy_0('FILL', 1, 'fill');
  $VALUES_25 = initValues(_3Lcom_smartgwt_client_types_LayoutPolicy_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$LayoutPolicy, [NONE_3, FILL]);
}

function LayoutPolicy_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_27(name_0){
  $clinit_LayoutPolicy();
  return valueOf(($clinit_LayoutPolicy$Map() , $MAP_25), name_0);
}

function values_26(){
  $clinit_LayoutPolicy();
  return $VALUES_25;
}

defineSeed(402, 49, makeCastMap([Q$LayoutPolicy, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), LayoutPolicy_0);
_.getValue_0 = function getValue_22(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_25, FILL, NONE_3;
function $clinit_LayoutPolicy$Map(){
  $clinit_LayoutPolicy$Map = nullMethod;
  $MAP_25 = createValueOfMap(($clinit_LayoutPolicy() , $VALUES_25));
}

var $MAP_25;
function $clinit_ListGridEditEvent(){
  $clinit_ListGridEditEvent = nullMethod;
  CLICK = new ListGridEditEvent_0('CLICK', 0, 'click');
  DOUBLECLICK = new ListGridEditEvent_0('DOUBLECLICK', 1, 'doubleClick');
  NONE_4 = new ListGridEditEvent_0('NONE', 2, 'none');
  $VALUES_26 = initValues(_3Lcom_smartgwt_client_types_ListGridEditEvent_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ListGridEditEvent, [CLICK, DOUBLECLICK, NONE_4]);
}

function ListGridEditEvent_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_28(name_0){
  $clinit_ListGridEditEvent();
  return valueOf(($clinit_ListGridEditEvent$Map() , $MAP_26), name_0);
}

function values_27(){
  $clinit_ListGridEditEvent();
  return $VALUES_26;
}

defineSeed(404, 49, makeCastMap([Q$ListGridEditEvent, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ListGridEditEvent_0);
_.getValue_0 = function getValue_23(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_26, CLICK, DOUBLECLICK, NONE_4;
function $clinit_ListGridEditEvent$Map(){
  $clinit_ListGridEditEvent$Map = nullMethod;
  $MAP_26 = createValueOfMap(($clinit_ListGridEditEvent() , $VALUES_26));
}

var $MAP_26;
function $clinit_MultipleAppearance(){
  $clinit_MultipleAppearance = nullMethod;
  PICKLIST = new MultipleAppearance_0('PICKLIST', 0, 'picklist');
  GRID = new MultipleAppearance_0('GRID', 1, 'grid');
  $VALUES_28 = initValues(_3Lcom_smartgwt_client_types_MultipleAppearance_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$MultipleAppearance, [PICKLIST, GRID]);
}

function MultipleAppearance_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_30(name_0){
  $clinit_MultipleAppearance();
  return valueOf(($clinit_MultipleAppearance$Map() , $MAP_28), name_0);
}

function values_29(){
  $clinit_MultipleAppearance();
  return $VALUES_28;
}

defineSeed(408, 49, makeCastMap([Q$MultipleAppearance, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), MultipleAppearance_0);
_.getValue_0 = function getValue_25(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_28, GRID, PICKLIST;
function $clinit_MultipleAppearance$Map(){
  $clinit_MultipleAppearance$Map = nullMethod;
  $MAP_28 = createValueOfMap(($clinit_MultipleAppearance() , $VALUES_28));
}

var $MAP_28;
function $clinit_RelativeDateRangePosition(){
  $clinit_RelativeDateRangePosition = nullMethod;
  START = new RelativeDateRangePosition_0('START', 0, 'start');
  END = new RelativeDateRangePosition_0('END', 1, 'end');
  $VALUES_31 = initValues(_3Lcom_smartgwt_client_types_RelativeDateRangePosition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$RelativeDateRangePosition, [START, END]);
}

function RelativeDateRangePosition_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_33(name_0){
  $clinit_RelativeDateRangePosition();
  return valueOf(($clinit_RelativeDateRangePosition$Map() , $MAP_31), name_0);
}

function values_32(){
  $clinit_RelativeDateRangePosition();
  return $VALUES_31;
}

defineSeed(414, 49, makeCastMap([Q$RelativeDateRangePosition, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), RelativeDateRangePosition_0);
_.getValue_0 = function getValue_28(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_31, END, START;
function $clinit_RelativeDateRangePosition$Map(){
  $clinit_RelativeDateRangePosition$Map = nullMethod;
  $MAP_31 = createValueOfMap(($clinit_RelativeDateRangePosition() , $VALUES_31));
}

var $MAP_31;
function $clinit_SelectionAppearance(){
  $clinit_SelectionAppearance = nullMethod;
  ROW_STYLE = new SelectionAppearance_0('ROW_STYLE', 0, 'rowStyle');
  CHECKBOX = new SelectionAppearance_0('CHECKBOX', 1, 'checkbox');
  $VALUES_32 = initValues(_3Lcom_smartgwt_client_types_SelectionAppearance_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$SelectionAppearance, [ROW_STYLE, CHECKBOX]);
}

function SelectionAppearance_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_34(name_0){
  $clinit_SelectionAppearance();
  return valueOf(($clinit_SelectionAppearance$Map() , $MAP_32), name_0);
}

function values_33(){
  $clinit_SelectionAppearance();
  return $VALUES_32;
}

defineSeed(416, 49, makeCastMap([Q$SelectionAppearance, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), SelectionAppearance_0);
_.getValue_0 = function getValue_29(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_32, CHECKBOX, ROW_STYLE;
function $clinit_SelectionAppearance$Map(){
  $clinit_SelectionAppearance$Map = nullMethod;
  $MAP_32 = createValueOfMap(($clinit_SelectionAppearance() , $VALUES_32));
}

var $MAP_32;
function $clinit_SelectionType(){
  $clinit_SelectionType = nullMethod;
  BUTTON = new SelectionType_0('BUTTON', 0, 'button');
  CHECKBOX_0 = new SelectionType_0('CHECKBOX', 1, 'checkbox');
  RADIO = new SelectionType_0('RADIO', 2, 'radio');
  $VALUES_34 = initValues(_3Lcom_smartgwt_client_types_SelectionType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$SelectionType, [BUTTON, CHECKBOX_0, RADIO]);
}

function SelectionType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_36(name_0){
  $clinit_SelectionType();
  return valueOf(($clinit_SelectionType$Map() , $MAP_34), name_0);
}

function values_35(){
  $clinit_SelectionType();
  return $VALUES_34;
}

defineSeed(420, 49, makeCastMap([Q$SelectionType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), SelectionType_0);
_.getValue_0 = function getValue_31(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_34, BUTTON, CHECKBOX_0, RADIO;
function $clinit_SelectionType$Map(){
  $clinit_SelectionType$Map = nullMethod;
  $MAP_34 = createValueOfMap(($clinit_SelectionType() , $VALUES_34));
}

var $MAP_34;
function $clinit_Side(){
  $clinit_Side = nullMethod;
  LEFT_2 = new Side_0('LEFT', 0, 'left');
  RIGHT_2 = new Side_0('RIGHT', 1, 'right');
  TOP_0 = new Side_0('TOP', 2, 'top');
  BOTTOM_0 = new Side_0('BOTTOM', 3, 'bottom');
  $VALUES_35 = initValues(_3Lcom_smartgwt_client_types_Side_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Side, [LEFT_2, RIGHT_2, TOP_0, BOTTOM_0]);
}

function Side_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_37(name_0){
  $clinit_Side();
  return valueOf(($clinit_Side$Map() , $MAP_35), name_0);
}

function values_36(){
  $clinit_Side();
  return $VALUES_35;
}

defineSeed(422, 49, makeCastMap([Q$Side, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Side_0);
_.getValue_0 = function getValue_32(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_35, BOTTOM_0, LEFT_2, RIGHT_2, TOP_0;
function $clinit_Side$Map(){
  $clinit_Side$Map = nullMethod;
  $MAP_35 = createValueOfMap(($clinit_Side() , $VALUES_35));
}

var $MAP_35;
function $clinit_TabBarControls(){
  $clinit_TabBarControls = nullMethod;
  TAB_SCROLLER = new TabBarControls_0('TAB_SCROLLER', 0, 'tabScroller');
  TAB_PICKER = new TabBarControls_0('TAB_PICKER', 1, 'tabPicker');
  $VALUES_37 = initValues(_3Lcom_smartgwt_client_types_TabBarControls_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$TabBarControls, [TAB_SCROLLER, TAB_PICKER]);
}

function TabBarControls_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_39(name_0){
  $clinit_TabBarControls();
  return valueOf(($clinit_TabBarControls$Map() , $MAP_37), name_0);
}

function values_38(){
  $clinit_TabBarControls();
  return $VALUES_37;
}

defineSeed(426, 49, makeCastMap([Q$TabBarControls, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), TabBarControls_0);
_.getValue_0 = function getValue_34(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_37, TAB_PICKER, TAB_SCROLLER;
function $clinit_TabBarControls$Map(){
  $clinit_TabBarControls$Map = nullMethod;
  $MAP_37 = createValueOfMap(($clinit_TabBarControls() , $VALUES_37));
}

var $MAP_37;
function $clinit_TextMatchStyle(){
  $clinit_TextMatchStyle = nullMethod;
  EXACT = new TextMatchStyle_0('EXACT', 0, 'exact');
  SUBSTRING = new TextMatchStyle_0('SUBSTRING', 1, 'substring');
  STARTS_WITH = new TextMatchStyle_0('STARTS_WITH', 2, 'startsWith');
  $VALUES_38 = initValues(_3Lcom_smartgwt_client_types_TextMatchStyle_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$TextMatchStyle, [EXACT, SUBSTRING, STARTS_WITH]);
}

function TextMatchStyle_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_40(name_0){
  $clinit_TextMatchStyle();
  return valueOf(($clinit_TextMatchStyle$Map() , $MAP_38), name_0);
}

function values_39(){
  $clinit_TextMatchStyle();
  return $VALUES_38;
}

defineSeed(428, 49, makeCastMap([Q$TextMatchStyle, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), TextMatchStyle_0);
_.getValue_0 = function getValue_35(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_38, EXACT, STARTS_WITH, SUBSTRING;
function $clinit_TextMatchStyle$Map(){
  $clinit_TextMatchStyle$Map = nullMethod;
  $MAP_38 = createValueOfMap(($clinit_TextMatchStyle() , $VALUES_38));
}

var $MAP_38;
function $clinit_TitleOrientation(){
  $clinit_TitleOrientation = nullMethod;
  LEFT_3 = new TitleOrientation_0('LEFT', 0, 'left');
  TOP_1 = new TitleOrientation_0('TOP', 1, 'top');
  RIGHT_3 = new TitleOrientation_0('RIGHT', 2, 'right');
  $VALUES_40 = initValues(_3Lcom_smartgwt_client_types_TitleOrientation_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$TitleOrientation, [LEFT_3, TOP_1, RIGHT_3]);
}

function TitleOrientation_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_42(name_0){
  $clinit_TitleOrientation();
  return valueOf(($clinit_TitleOrientation$Map() , $MAP_40), name_0);
}

function values_41(){
  $clinit_TitleOrientation();
  return $VALUES_40;
}

defineSeed(432, 49, makeCastMap([Q$TitleOrientation, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), TitleOrientation_0);
_.getValue_0 = function getValue_37(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_40, LEFT_3, RIGHT_3, TOP_1;
function $clinit_TitleOrientation$Map(){
  $clinit_TitleOrientation$Map = nullMethod;
  $MAP_40 = createValueOfMap(($clinit_TitleOrientation() , $VALUES_40));
}

var $MAP_40;
function $clinit_TreeModelType(){
  $clinit_TreeModelType = nullMethod;
  PARENT = new TreeModelType_0('PARENT', 0, 'parent');
  CHILDREN = new TreeModelType_0('CHILDREN', 1, 'children');
  $VALUES_41 = initValues(_3Lcom_smartgwt_client_types_TreeModelType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$TreeModelType, [PARENT, CHILDREN]);
}

function TreeModelType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_43(name_0){
  $clinit_TreeModelType();
  return valueOf(($clinit_TreeModelType$Map() , $MAP_41), name_0);
}

function values_42(){
  $clinit_TreeModelType();
  return $VALUES_41;
}

defineSeed(434, 49, makeCastMap([Q$TreeModelType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), TreeModelType_0);
_.getValue_0 = function getValue_38(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_41, CHILDREN, PARENT;
function $clinit_TreeModelType$Map(){
  $clinit_TreeModelType$Map = nullMethod;
  $MAP_41 = createValueOfMap(($clinit_TreeModelType() , $VALUES_41));
}

var $MAP_41;
function $clinit_VisibilityMode(){
  $clinit_VisibilityMode = nullMethod;
  MUTEX = new VisibilityMode_0('MUTEX', 0, 'mutex');
  MULTIPLE_0 = new VisibilityMode_0('MULTIPLE', 1, 'multiple');
  $VALUES_44 = initValues(_3Lcom_smartgwt_client_types_VisibilityMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$VisibilityMode, [MUTEX, MULTIPLE_0]);
}

function VisibilityMode_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_46(name_0){
  $clinit_VisibilityMode();
  return valueOf(($clinit_VisibilityMode$Map() , $MAP_44), name_0);
}

function values_45(){
  $clinit_VisibilityMode();
  return $VALUES_44;
}

defineSeed(440, 49, makeCastMap([Q$ValueEnum, Q$VisibilityMode, Q$Serializable, Q$Comparable, Q$Enum]), VisibilityMode_0);
_.getValue_0 = function getValue_41(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_44, MULTIPLE_0, MUTEX;
function $clinit_VisibilityMode$Map(){
  $clinit_VisibilityMode$Map = nullMethod;
  $MAP_44 = createValueOfMap(($clinit_VisibilityMode() , $VALUES_44));
}

var $MAP_44;
function getAbsoluteDate(relativeDate, baseDate, position){
  relativeDate = relativeDate.getJsObj();
  baseDate != null && (baseDate = convertToJavaScriptDate(baseDate));
  position != null && (position = position.getValue_0());
  var jsDate = $wnd.isc.DateUtil.getAbsoluteDate(relativeDate, baseDate, position);
  if (jsDate == null)
    return null;
  return toDate(jsDate.getTime());
}

function getEnum(enums, value){
  var anEnum, anEnum$index, anEnum$max;
  if (value == null)
    return null;
  for (anEnum$index = 0 , anEnum$max = enums.length; anEnum$index < anEnum$max; ++anEnum$index) {
    anEnum = enums[anEnum$index];
    if ($equals_6(anEnum.getValue_0(), value)) {
      return anEnum;
    }
  }
  return null;
}

function getDragTarget(){
  var ret = $wnd.isc.EventHandler.getDragTarget();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef_0(ret);
  retVal == null && (retVal = new Canvas_2(ret));
  return retVal;
}

function apply_0(config, jsObj){
  for (var k in config) {
    jsObj[k] = config[k];
  }
}

function convertToJavaIntArray(array){
  var arr, i, length_0;
  length_0 = array.length;
  arr = initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, length_0, 1);
  for (i = 0; i < length_0; ++i) {
    arr[i] = array[i];
  }
  return arr;
}

function convertToJavaScriptArray(array){
  var i, jsArray;
  if (array == null)
    return null;
  jsArray = createJavaScriptArray();
  for (i = 0; i < array.length; ++i) {
    jsArray[i] = array[i];
  }
  return jsArray;
}

function convertToJavaStringArray(array){
  var arr, i, length_0, result;
  if (!array)
    return initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, []);
  length_0 = array.length;
  arr = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, length_0, 0);
  for (i = 0; i < length_0; ++i) {
    arr[i] = (result = array[i] , result == null || result === undefined?null:result);
  }
  return arr;
}

function getAttributeAsBoolean(elem, attr){
  var ret = elem[attr];
  return ret == null || ret === undefined?false:ret;
}

function getAttributeAsDouble(elem, attr){
  var ret = elem[attr];
  if (ret === undefined || ret == null) {
    return null;
  }
   else {
    if (typeof ret == 'object') {
      return ret;
    }
     else {
      return new Double_0(ret);
    }
  }
}

function getAttributeAsFloat(elem, attr){
  var ret = elem[attr];
  return ret === undefined || ret == null?null:new Float_0(ret);
}

function getAttributeAsIntArray(elem, attr){
  var hold, i, rtn;
  rtn = null;
  hold = getAttributeAsJavaScriptObject(elem, attr);
  if (hold) {
    rtn = initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, getJavaScriptObjectArraySize(hold), 1);
    for (i = 0; i < rtn.length; ++i) {
      rtn[i] = hold[i];
    }
  }
  return rtn;
}

function getAttributeAsStringArray(elem, attr){
  var hold, i, rtn;
  rtn = null;
  hold = getAttributeAsJavaScriptObject(elem, attr);
  if (hold) {
    rtn = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, getJavaScriptObjectArraySize(hold), 0);
    for (i = 0; i < rtn.length; ++i) {
      rtn[i] = hold[i];
    }
  }
  return rtn;
}

function getProperties(jsObj){
  var props = createJavaScriptArray();
  for (var k in jsObj) {
    props.push(k);
  }
  return convertToJavaStringArray(props);
}

function setAttribute_6(elem, attr, value){
  !value?setNullAttribute(elem, attr):(elem[attr] = value.value_0 , undefined);
}

function ask_0(title, message, callback){
  $wnd.isc.ask(message, function(value){
    var valueJ = value == null?null:toBoolean(value);
    callback.execute_3(valueJ);
  }
  , {title:title});
}

function askforValue(message, callback){
  $wnd.isc.askForValue(message, function(value){
    value === undefined && (value = null);
    callback.execute_4(value);
  }
  , {width:275});
}

function confirm_0(message, callback){
  $wnd.isc.confirm(message, function(value){
    var valueJ = value == null?null:toBoolean(value);
    callback.execute_3(valueJ);
  }
  );
}

function say(message){
  $wnd.isc.say(message);
}

function warn(message, callback){
  $wnd.isc.warn(message, function(value){
    var valueJ = value == null?null:toBoolean(value);
    callback != null && callback.execute_3(valueJ);
  }
  );
}

function $setAttribute_21(this$static, attribute, value){
  var valueJS;
  valueJS = value.configOnly?value.config_0:$getOrCreateJsObj_0(value);
  $isCreated_1(this$static)?($toString_5(value) , undefined):(this$static.config_0[attribute] = valueJS , undefined);
}

function $setAttribute_26(this$static, value){
  $isCreated_1(this$static)?undefined:(this$static.config_0['tabBarControls'] = convertToJavaScriptArray_0(value) , undefined);
}

function $addChild(this$static, newChild){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.addChild(newChild.getOrCreateJsObj());
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef_0(ret);
  retVal == null && (retVal = new Canvas_2(ret));
  return retVal;
}

function $addDragResizeStartHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_6 && (TYPE_6 = new GwtEvent$Type_0) , TYPE_6)) == 0 && $setupDragResizeStartEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_6 && (TYPE_6 = new GwtEvent$Type_0) , TYPE_6));
}

function $addDragResizeStopHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_7 && (TYPE_7 = new GwtEvent$Type_0) , TYPE_7)) == 0 && $setupDragResizeStopEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_7 && (TYPE_7 = new GwtEvent$Type_0) , TYPE_7));
}

function $addDropHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_9 && (TYPE_9 = new GwtEvent$Type_0) , TYPE_9)) == 0 && $setupDropEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_9 && (TYPE_9 = new GwtEvent$Type_0) , TYPE_9));
}

function $addKeyPressHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_10 && (TYPE_10 = new GwtEvent$Type_0) , TYPE_10)) == 0 && $setupKeyPressEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_10 && (TYPE_10 = new GwtEvent$Type_0) , TYPE_10));
}

function $addMouseOutHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_12 && (TYPE_12 = new GwtEvent$Type_0) , TYPE_12)) == 0 && $setupMouseOutEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_12 && (TYPE_12 = new GwtEvent$Type_0) , TYPE_12));
}

function $addMouseOverHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_13 && (TYPE_13 = new GwtEvent$Type_0) , TYPE_13)) == 0 && $setupMouseOverEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_13 && (TYPE_13 = new GwtEvent$Type_0) , TYPE_13));
}

function $addResizedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_14 && (TYPE_14 = new GwtEvent$Type_0) , TYPE_14)) == 0 && $setupResizedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_14 && (TYPE_14 = new GwtEvent$Type_0) , TYPE_14));
}

function $addVisibilityChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_17 && (TYPE_17 = new GwtEvent$Type_0) , TYPE_17)) == 0 && $setupVisibilityChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_17 && (TYPE_17 = new GwtEvent$Type_0) , TYPE_17));
}

function $animateHide(this$static, effect){
  var effectVal = effect.getValue_0();
  var self_0 = this$static.getOrCreateJsObj();
  self_0.animateHide(effectVal);
}

function $animateHide_0(this$static, effect, callback){
  var effectVal = effect.getValue_0();
  var self_0 = this$static.getOrCreateJsObj();
  self_0.animateHide(effectVal, $entry(function(earlyFinish){
    earlyFinish = earlyFinish === undefined?false:earlyFinish;
    callback != null && callback.execute_5(earlyFinish);
  }
  ));
}

function $animateRect(this$static, left, top_0, width, height, callback, duration){
  var self_0 = this$static.getOrCreateJsObj();
  var leftJS = left == null?null:left.intValue();
  var topJS = top_0 == null?null:top_0.intValue();
  var widthJS = width == null?null:width.intValue();
  var heightJS = height == null?null:height.intValue();
  self_0.animateRect(leftJS, topJS, widthJS, heightJS, $entry(function(earlyFinish){
    earlyFinish = earlyFinish === undefined?false:earlyFinish;
    callback != null && callback.execute_5(earlyFinish);
  }
  ), duration);
}

function $animateShow(this$static, effect){
  var effectVal = effect.getValue_0();
  var self_0 = this$static.getOrCreateJsObj();
  self_0.animateShow(effectVal);
}

function $getDisabled(this$static){
  var disabled;
  disabled = $getAttributeAsBoolean_1(this$static, 'disabled');
  return !!disabled && disabled.value_0;
}

function $getPageLeft(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getPageLeft();
}

function $getPageTop(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getPageTop();
}

function $getParentElement_0(this$static){
  var canvas, parentJS;
  parentJS = $getAttributeAsJavaScriptObject_1(this$static, 'parentElement');
  if (!parentJS)
    return null;
  canvas = dynamicCast(!parentJS?null:dynamicCast(getAttributeAsObject(parentJS, '__ref'), Q$BaseWidget), Q$Canvas);
  !canvas && (canvas = new Canvas_2(parentJS));
  return canvas;
}

function $isDisabled(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isDisabled();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $moveTo(this$static, left, top_0){
  var widget = this$static.getOrCreateJsObj();
  return widget.moveTo(left, top_0);
}

function $setBackgroundColor(this$static, backgroundColor){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'backgroundColor', backgroundColor):(this$static.config_0['backgroundColor'] = backgroundColor , undefined);
}

function $setBorder(this$static, border){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'border', border):(this$static.config_0['border'] = border , undefined);
}

function $setCanAcceptDrop(this$static, canAcceptDrop){
  $isCreated_1(this$static)?!canAcceptDrop?$setNullProperty(this$static, 'canAcceptDrop'):$setProperty_5(this$static, 'canAcceptDrop', canAcceptDrop.value_0):setAttribute_5(this$static.config_0, 'canAcceptDrop', canAcceptDrop);
}

function $setCanDrag(this$static, canDrag){
  $isCreated_1(this$static)?!canDrag?$setNullProperty(this$static, 'canDrag'):$setProperty_5(this$static, 'canDrag', canDrag.value_0):setAttribute_5(this$static.config_0, 'canDrag', canDrag);
}

function $setCanDragResize(this$static, canDragResize){
  $isCreated_1(this$static)?!canDragResize?$setNullProperty(this$static, 'canDragResize'):$setProperty_5(this$static, 'canDragResize', canDragResize.value_0):setAttribute_5(this$static.config_0, 'canDragResize', canDragResize);
}

function $setCanDrop(this$static, canDrop){
  $isCreated_1(this$static)?!canDrop?$setNullProperty(this$static, 'canDrop'):$setProperty_5(this$static, 'canDrop', canDrop.value_0):setAttribute_5(this$static.config_0, 'canDrop', canDrop);
}

function $setContextMenu(this$static, contextMenu){
  $setAttribute_20(this$static, 'contextMenu', !contextMenu?null:$getOrCreateJsObj_0(contextMenu), true);
}

function $setDragOpacity(this$static, dragOpacity){
  $isCreated_1(this$static)?!dragOpacity?$setNullProperty(this$static, 'dragOpacity'):$setProperty_2(this$static, 'dragOpacity', dragOpacity.value_0):setAttribute_8(this$static.config_0, 'dragOpacity', dragOpacity);
}

function $setEdgeMarginSize(this$static){
  $isCreated_1(this$static)?$setProperty_1(this$static, 'edgeMarginSize', 0):(this$static.config_0['edgeMarginSize'] = 0 , undefined);
}

function $setEdgeSize(this$static){
  $isCreated_1(this$static)?undefined:(this$static.config_0['edgeSize'] = 0 , undefined);
}

function $setExtraSpace(this$static, extraSpace){
  $isCreated_1(this$static)?undefined:(this$static.config_0['extraSpace'] = extraSpace , undefined);
}

function $setGroupTitle(this$static, groupTitle){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'groupTitle', groupTitle):(this$static.config_0['groupTitle'] = groupTitle , undefined);
}

function $setHoverWidth(this$static, hoverWidth){
  $isCreated_1(this$static)?!hoverWidth?$setNullProperty(this$static, 'hoverWidth'):$setProperty_2(this$static, 'hoverWidth', hoverWidth.value_0):setAttribute_8(this$static.config_0, 'hoverWidth', hoverWidth);
}

function $setHoverWrap(this$static, hoverWrap){
  $isCreated_1(this$static)?!hoverWrap?$setNullProperty(this$static, 'hoverWrap'):$setProperty_5(this$static, 'hoverWrap', hoverWrap.value_0):setAttribute_5(this$static.config_0, 'hoverWrap', hoverWrap);
}

function $setIsGroup(this$static, isGroup){
  $isCreated_1(this$static)?!isGroup?$setNullProperty(this$static, 'isGroup'):$setProperty_5(this$static, 'isGroup', isGroup.value_0):setAttribute_5(this$static.config_0, 'isGroup', isGroup);
}

function $setRedrawOnResize(this$static, redrawOnResize){
  $isCreated_1(this$static)?!redrawOnResize?$setNullProperty(this$static, 'redrawOnResize'):$setProperty_5(this$static, 'redrawOnResize', redrawOnResize.value_0):setAttribute_5(this$static.config_0, 'redrawOnResize', redrawOnResize);
}

function $setShowEdges(this$static, showEdges){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'showEdges', showEdges);
}

function $setShowResizeBar(this$static, showResizeBar){
  $isCreated_1(this$static)?!showResizeBar?$setNullProperty(this$static, 'showResizeBar'):$setProperty_5(this$static, 'showResizeBar', showResizeBar.value_0):setAttribute_5(this$static.config_0, 'showResizeBar', showResizeBar);
}

function $setShowShadow(this$static, showShadow){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'showShadow', showShadow);
}

function $setupDragResizeStartEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({dragResizeStart:$debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStartEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.dragResizeStart = $debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStartEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupDragResizeStopEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({dragResizeStop:$debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStopEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.dragResizeStop = $debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStopEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupDropEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onDrop:$debox($entry(function(){
      var param = {};
      var event_0 = new DropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onDrop = $debox($entry(function(){
      var param = {};
      var event_0 = new DropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupKeyPressEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({keyPress:$debox($entry(function(){
      var param = {};
      var event_0 = new KeyPressEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.keyPress = $debox($entry(function(){
      var param = {};
      var event_0 = new KeyPressEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupMouseOutEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({mouseOut:$debox($entry(function(){
      var param = {};
      var event_0 = new MouseOutEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.mouseOut = $debox($entry(function(){
      var param = {};
      var event_0 = new MouseOutEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupMouseOverEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({mouseOver:$debox($entry(function(){
      var param = {};
      var event_0 = new MouseOverEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.mouseOver = $debox($entry(function(){
      var param = {};
      var event_0 = new MouseOverEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupResizedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({resized:$entry(function(){
      var param = {};
      var event_0 = new ResizedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.resized = $entry(function(){
      var param = {};
      var event_0 = new ResizedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupVisibilityChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({visibilityChanged:$entry(function(){
      var param = {isVisible:arguments[0]};
      var event_0 = new VisibilityChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.visibilityChanged = $entry(function(){
      var param = {isVisible:arguments[0]};
      var event_0 = new VisibilityChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function getImgURL(URL){
  $clinit_BaseWidget();
  return $wnd.isc.Canvas.getImgURL(URL);
}

function imgHTML(src){
  $clinit_BaseWidget();
  return $wnd.isc.Canvas.imgHTML(src);
}

function imgHTML_0(src, width, height){
  $clinit_BaseWidget();
  return $wnd.isc.Canvas.imgHTML(src, width, height);
}

defineSeed(455, 452, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.hide_0 = function hide(){
  $hide(this);
}
;
_.redraw_0 = function redraw(){
  $redraw(this);
}
;
_.setContents = function setContents_0(contents){
  $isCreated_1(this)?$setProperty_4(this, 'contents', contents):(this.config_0['contents'] = contents , undefined);
}
;
_.setDisabled_0 = function setDisabled(disabled){
  $setDisabled(this, disabled);
}
;
_.setOverflow = function setOverflow(overflow){
  $setAttribute_24(this, 'overflow', overflow.value_0, true);
}
;
function $setIcon(this$static, icon){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'icon', icon):(this$static.config_0['icon'] = icon , undefined);
}

function $setShowRollOver(this$static, showRollOver){
  $isCreated_1(this$static)?!showRollOver?$setNullProperty(this$static, 'showRollOver'):$setProperty_5(this$static, 'showRollOver', showRollOver.value_0):setAttribute_5(this$static.config_0, 'showRollOver', showRollOver);
}

defineSeed(454, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.setAlign = function setAlign(align){
  $setAttribute_24(this, 'align', align.value_0, true);
}
;
_.setValign = function setValign(valign){
  $setAttribute_24(this, 'valign', valign.value_0, true);
}
;
function $setDisabled_0(this$static, disabled){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setDisabled(disabled);
}

function $setShowRollOver_0(this$static, showRollOver){
  $isCreated_1(this$static)?!showRollOver?$setNullProperty(this$static, 'showRollOver'):$setProperty_5(this$static, 'showRollOver', showRollOver.value_0):setAttribute_5(this$static.config_0, 'showRollOver', showRollOver);
}

function Button_1(jsObj){
  Canvas_2.call(this, jsObj);
}

function Button_2(title){
  $clinit_BaseWidget();
  StatefulCanvas_0.call(this);
  $isCreated_1(this)?$setProperty_4(this, 'title', title):(this.config_0['title'] = title , undefined);
  this.scClassName = 'Button';
}

function getOrCreateRef_4(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$Button):new Button_1(jsObj);
}

defineSeed(453, 454, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Button, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), Button_1, Button_2);
_.setAlign = function setAlign_0(align){
  $setAttribute_24(this, 'align', align.value_0, true);
}
;
_.setAutoFit = function setAutoFit(autoFit){
  $isCreated_1(this)?!autoFit?$setNullProperty(this, 'autoFit'):$setProperty_5(this, 'autoFit', autoFit.value_0):setAttribute_5(this.config_0, 'autoFit', autoFit);
}
;
_.setDisabled_0 = function setDisabled_0(disabled){
  $setDisabled_0(this, disabled);
}
;
_.setValign = function setValign_0(valign){
  $setAttribute_24(this, 'valign', valign.value_0, true);
}
;
function $getMember_0(this$static, memberID){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getMember(memberID);
  return ret == null?null:getOrCreateRef_3(ret);
}

function $getMemberNumber(this$static, memberID){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getMemberNumber(memberID);
}

function $hasMember(this$static, canvas){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasMember(canvas.getOrCreateJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $setAnimateMemberTime(this$static, animateMemberTime){
  $isCreated_1(this$static)?!animateMemberTime?$setNullProperty(this$static, 'animateMemberTime'):$setProperty_2(this$static, 'animateMemberTime', animateMemberTime.value_0):setAttribute_8(this$static.config_0, 'animateMemberTime', animateMemberTime);
}

function $setAnimateMembers(this$static, animateMembers){
  $isCreated_1(this$static)?!animateMembers?$setNullProperty(this$static, 'animateMembers'):$setProperty_5(this$static, 'animateMembers', animateMembers.value_0):setAttribute_5(this$static.config_0, 'animateMembers', animateMembers);
}

function $setLayoutTopMargin(this$static, layoutTopMargin){
  $isCreated_1(this$static)?!layoutTopMargin?$setNullProperty(this$static, 'layoutTopMargin'):$setProperty_2(this$static, 'layoutTopMargin', layoutTopMargin.value_0):setAttribute_8(this$static.config_0, 'layoutTopMargin', layoutTopMargin);
}

function $setMembers(this$static, members){
  var member, member$index, member$max, membersToRemove;
  if ($isCreated_1(this$static)) {
    membersToRemove = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static, 'members'));
    for (member$index = 0 , member$max = membersToRemove.length; member$index < member$max; ++member$index) {
      member = membersToRemove[member$index];
      $removeMember(this$static, member);
    }
    for (member$index = 0 , member$max = members.length; member$index < member$max; ++member$index) {
      member = members[member$index];
      this$static.addMember_0(member);
    }
  }
   else {
    $isCreated_1(this$static)?$setProperty_3(this$static, 'members', convertToJavaScriptArray_0(members)):(this$static.config_0['members'] = convertToJavaScriptArray_0(members) , undefined);
  }
}

function $setShowDragPlaceHolder(this$static, showDragPlaceHolder){
  $isCreated_1(this$static)?!showDragPlaceHolder?$setNullProperty(this$static, 'showDragPlaceHolder'):$setProperty_5(this$static, 'showDragPlaceHolder', showDragPlaceHolder.value_0):setAttribute_5(this$static.config_0, 'showDragPlaceHolder', showDragPlaceHolder);
}

function $setVertical(this$static, vertical){
  $isCreated_1(this$static)?!vertical?$setNullProperty(this$static, 'vertical'):$setProperty_5(this$static, 'vertical', vertical.value_0):setAttribute_5(this$static.config_0, 'vertical', vertical);
}

function $setVisibleMember(this$static, member){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setVisibleMember(member.getOrCreateJsObj());
}

defineSeed(460, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout]));
_.setOverflow = function setOverflow_0(overflow){
  $setAttribute_24(this, 'overflow', overflow.value_0, false);
}
;
function VLayout_1(membersMargin){
  $clinit_BaseWidget();
  Layout_0.call(this);
  $isCreated_1(this)?$setProperty_1(this, 'membersMargin', membersMargin):(this.config_0['membersMargin'] = membersMargin , undefined);
  this.scClassName = 'VLayout';
}

defineSeed(459, 460, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), VLayout_1);
function $addMinimizeClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_11 && (TYPE_11 = new GwtEvent$Type_0) , TYPE_11)) == 0 && $setupMinimizeClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_11 && (TYPE_11 = new GwtEvent$Type_0) , TYPE_11));
}

function $addRestoreClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_15 && (TYPE_15 = new GwtEvent$Type_0) , TYPE_15)) == 0 && $setupRestoreClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_15 && (TYPE_15 = new GwtEvent$Type_0) , TYPE_15));
}

function $setAnimateMinimize(this$static, animateMinimize){
  $isCreated_1(this$static)?!animateMinimize?$setNullProperty(this$static, 'animateMinimize'):$setProperty_5(this$static, 'animateMinimize', animateMinimize.value_0):setAttribute_5(this$static.config_0, 'animateMinimize', animateMinimize);
}

function $setDismissOnOutsideClick(this$static, dismissOnOutsideClick){
  $isCreated_1(this$static)?!dismissOnOutsideClick?$setNullProperty(this$static, 'dismissOnOutsideClick'):$setProperty_5(this$static, 'dismissOnOutsideClick', dismissOnOutsideClick.value_0):setAttribute_5(this$static.config_0, 'dismissOnOutsideClick', dismissOnOutsideClick);
}

function $setHeaderControls(this$static, headerControls){
  $isCreated_1(this$static)?undefined:(this$static.config_0['headerControls'] = convertToJavaScriptArray_0(headerControls) , undefined);
}

function $setShowFooter(this$static, showFooter){
  $isCreated_1(this$static)?!showFooter?$setNullProperty(this$static, 'showFooter'):$setProperty_5(this$static, 'showFooter', showFooter.value_0):setAttribute_5(this$static.config_0, 'showFooter', showFooter);
}

function $setShowHeader(this$static, showHeader){
  $isCreated_1(this$static)?!showHeader?$setNullProperty(this$static, 'showHeader'):$setProperty_5(this$static, 'showHeader', showHeader.value_0):setAttribute_5(this$static.config_0, 'showHeader', showHeader);
}

function $setupMinimizeClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onMinimizeClick:$debox($entry(function(){
      var param = {};
      var event_0 = new MinimizeClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onMinimizeClick = $debox($entry(function(){
      var param = {};
      var event_0 = new MinimizeClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRestoreClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onRestoreClick:$debox($entry(function(){
      var param = {};
      var event_0 = new RestoreClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onRestoreClick = $debox($entry(function(){
      var param = {};
      var event_0 = new RestoreClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $clinit_Dialog(){
  $clinit_Dialog = nullMethod;
  $clinit_BaseWidget();
  new Button_2('OK');
  new Button_2('Apply');
  new Button_2('Yes');
  new Button_2('No');
  new Button_2('Cancel');
  new Button_2('Done');
}

defineSeed(457, 458, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]));
_.create_0 = function create_15(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.setStyleName = function setStyleName_0(styleName){
  $isCreated_1(this)?$setProperty_4(this, 'styleName', styleName):(this.config_0['styleName'] = styleName , undefined);
}
;
function $setContents(this$static, contents){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'contents', contents):(this$static.config_0['contents'] = contents , undefined);
}

defineSeed(461, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.setContents = function setContents_1(contents){
  $setContents(this, contents);
}
;
function Img_0(){
  $clinit_BaseWidget();
  StatefulCanvas_0.call(this);
  this.scClassName = 'Img';
}

function $clinit_HeaderControl(){
  var imgType;
  $clinit_HeaderControl = nullMethod;
  $clinit_BaseWidget();
  IMG_TYPE = (imgType = $wnd.isc.headerImgType , imgType == null || imgType === undefined?'png':imgType);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_down.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_left.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_right.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_up.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/calculator.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/cart.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/cascade.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/clipboard.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/clock.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/close.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/comment.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/document.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_down.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_left.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_right.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_up.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/favourite.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/find.' + IMG_TYPE);
  HELP_0 = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/help.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/home.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/mail.' + IMG_TYPE);
  MAXIMIZE = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/maximize.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/minimize.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/minus.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/person.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/pin_down.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/pin_left.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/plus.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/print.' + IMG_TYPE);
  REFRESH = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/refresh.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/refresh_thin.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/save.' + IMG_TYPE);
  SETTINGS = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/settings.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/transfer.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/trash.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/zoom.' + IMG_TYPE);
}

function HeaderControl_0(icon){
  $clinit_HeaderControl();
  Img_0.call(this);
  $setSrc(this, icon.url);
  $isCreated_1(this)?$setProperty_1(this, 'width', 15):(this.config_0['width'] = 15 , undefined);
  $isCreated_1(this)?$setProperty_1(this, 'height', 15):(this.config_0['height'] = 15 , undefined);
  $setAttribute_24(this, 'layoutAlign', ($clinit_Alignment() , CENTER_0).value_0, false);
  $setShowRollOver(this, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
}

function HeaderControl_1(icon, clickHandler){
  $clinit_HeaderControl();
  HeaderControl_0.call(this, icon);
  $getHandlerCount_1(this, (!TYPE_3 && (TYPE_3 = new GwtEvent$Type_0) , TYPE_3)) == 0 && $setupClickEvent(this);
  $doAddHandler_0(this, clickHandler, (!TYPE_3 && (TYPE_3 = new GwtEvent$Type_0) , TYPE_3));
}

defineSeed(463, 464, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), HeaderControl_0, HeaderControl_1);
var HELP_0, IMG_TYPE, MAXIMIZE, REFRESH, SETTINGS;
function HeaderControl$HeaderIcon_0(url){
  this.url = url;
}

defineSeed(465, 1, {}, HeaderControl$HeaderIcon_0);
_.url = null;
function $setIcon_0(this$static, icon){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'icon', icon):(this$static.config_0['icon'] = icon , undefined);
}

function $setIconHeight(this$static, iconHeight){
  $isCreated_1(this$static)?undefined:setAttribute_8(this$static.config_0, 'iconHeight', iconHeight);
}

function $setIconOrientation(this$static){
  $isCreated_1(this$static)?undefined:(this$static.config_0['iconOrientation'] = 'left' , undefined);
}

function $setIconWidth(this$static, iconWidth){
  $isCreated_1(this$static)?undefined:setAttribute_8(this$static.config_0, 'iconWidth', iconWidth);
}

function $setShowDown(this$static, showDown){
  $isCreated_1(this$static)?!showDown?$setNullProperty(this$static, 'showDown'):$setProperty_5(this$static, 'showDown', showDown.value_0):setAttribute_5(this$static.config_0, 'showDown', showDown);
}

function $setShowTitle(this$static, showTitle){
  $isCreated_1(this$static)?!showTitle?$setNullProperty(this$static, 'showTitle'):$setProperty_5(this$static, 'showTitle', showTitle.value_0):setAttribute_5(this$static.config_0, 'showTitle', showTitle);
}

function $setTitle_0(this$static, title){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'title', title):(this$static.config_0['title'] = title , undefined);
}

function $setWrap(this$static, wrap){
  $isCreated_1(this$static)?!wrap?$setNullProperty(this$static, 'wrap'):$setProperty_5(this$static, 'wrap', wrap.value_0):setAttribute_5(this$static.config_0, 'wrap', wrap);
}

defineSeed(467, 468, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$StretchImg, Q$StretchImgButton, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.setAlign = function setAlign_1(align){
  $setAttribute_24(this, 'align', align.value_0, true);
}
;
_.setValign = function setValign_1(valign){
  $setAttribute_24(this, 'valign', valign.value_0, true);
}
;
function IButton_0(){
  $clinit_BaseWidget();
  StretchImgButton_0.call(this);
  this.scClassName = 'IButton';
}

defineSeed(466, 467, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$IButton, Q$StatefulCanvas, Q$StretchImg, Q$StretchImgButton, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), IButton_0);
function $setDisabled_1(this$static, disabled){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setDisabled(disabled);
}

defineSeed(469, 464, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.create_0 = function create_22(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.setAlign = function setAlign_2(align){
  $setAttribute_24(this, 'align', align.value_0, true);
}
;
_.setDisabled_0 = function setDisabled_1(disabled){
  $setDisabled_1(this, disabled);
}
;
_.setSrc = function setSrc_0(src){
  $isCreated_1(this)?$setProperty_4(this, 'src', src):(this.config_0['src'] = src , undefined);
}
;
_.setValign = function setValign_2(valign){
  $setAttribute_24(this, 'valign', valign.value_0, true);
}
;
function ImgProperties_0(src){
  DataClass_0.call(this);
  this.jsObj['src'] = src;
  $setAttribute_11(this, 'width', valueOf_49(16));
  $setAttribute_11(this, 'height', valueOf_49(16));
}

defineSeed(470, 330, makeCastMap([Q$DataClass, Q$JsObject]), ImgProperties_0);
function $setAutoFit_0(this$static, autoFit){
  $isCreated_1(this$static)?!autoFit?$setNullProperty(this$static, 'autoFit'):$setProperty_5(this$static, 'autoFit', autoFit.value_0):setAttribute_5(this$static.config_0, 'autoFit', autoFit);
}

defineSeed(471, 453, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Button, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.setAlign = function setAlign_3(align){
  $setAttribute_24(this, 'align', align.value_0, true);
}
;
_.setAutoFit = function setAutoFit_0(autoFit){
  $setAutoFit_0(this, autoFit);
}
;
_.setContents = function setContents_2(contents){
  $setContents_0(this, contents);
}
;
_.setValign = function setValign_3(valign){
  $setAttribute_24(this, 'valign', valign.value_0, true);
}
;
function $clinit_TransferImgButton(){
  var imgType;
  $clinit_TransferImgButton = nullMethod;
  $clinit_BaseWidget();
  IMG_TYPE_0 = (imgType = $wnd.isc.transferImgType , imgType == null || imgType === undefined?'png':imgType);
  LEFT_4 = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/left.' + IMG_TYPE_0);
  LEFT_ALL = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/left_all.' + IMG_TYPE_0);
  RIGHT_4 = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/right.' + IMG_TYPE_0);
  RIGHT_ALL = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/right_all.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/up.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/up_first.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/down.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/down_last.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/delete.' + IMG_TYPE_0);
}

function TransferImgButton_0(transferImg){
  $clinit_TransferImgButton();
  $clinit_BaseWidget();
  Img_0.call(this);
  this.scClassName = 'ImgButton';
  $setAttribute_24(this, 'src', transferImg.url, true);
  $isCreated_1(this)?$setProperty_1(this, 'width', 24):(this.config_0['width'] = 24 , undefined);
  $isCreated_1(this)?$setProperty_1(this, 'height', 22):(this.config_0['height'] = 22 , undefined);
  $setAttribute_24(this, 'layoutAlign', ($clinit_Alignment() , CENTER_0).value_0, false);
  $setAttribute_22(this, 'showRollOver', ($clinit_Boolean() , $clinit_Boolean() , TRUE), true);
  $setAttribute_22(this, 'showDownIcon', FALSE, false);
  $setAttribute_22(this, 'showDown', FALSE, true);
}

defineSeed(472, 469, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), TransferImgButton_0);
var IMG_TYPE_0, LEFT_4, LEFT_ALL, RIGHT_4, RIGHT_ALL;
function TransferImgButton$TransferImg_0(url){
  this.url = url;
}

defineSeed(473, 1, {}, TransferImgButton$TransferImg_0);
_.url = null;
function WidgetCanvas_0(widget){
  $clinit_BaseWidget();
  var height, width;
  Canvas_1.call(this);
  this.widget = widget;
  $setRedrawOnResize(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setAttribute_22(this, '_redrawWithParent', FALSE, false);
  $setAttribute_22(this, '_clearWithRemoveChild', TRUE, false);
  $setAttribute_24(this, 'overflow', ($clinit_Overflow() , VISIBLE).value_0, true);
  width = widget.element.style['width'];
  height = widget.element.style['height'];
  width != null && !$equals_6(width, '') && ($isCreated_1(this)?$setProperty_4(this, 'width', width):(this.config_0['width'] = width , undefined));
  height != null && !$equals_6(height, '') && ($isCreated_1(this)?$setProperty_4(this, 'height', height):(this.config_0['height'] = height , undefined));
}

defineSeed(474, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), WidgetCanvas_0);
_.getInnerHTML_0 = function getInnerHTML_0(){
  this.widget.attached && $removeFromParent(this.widget);
  return "<DIV STYLE='width:100%;height:100%' ID=" + this.id_0 + '_widget><\/DIV>';
}
;
_.onDraw_0 = function onDraw_0(){
  var attached, height, rp, width;
  attached = this.widget.attached;
  if (!attached) {
    rp = get_1(this.id_0 + '_widget');
    $add_1(rp, this.widget);
    width = this.widget.element.style['width'];
    width != null && !$equals_6(width, '') && ($isCreated_1(this)?$setProperty_4(this, 'width', width):(this.config_0['width'] = width , undefined));
    height = this.widget.element.style['height'];
    height != null && !$equals_6(height, '') && ($isCreated_1(this)?$setProperty_4(this, 'height', height):(this.config_0['height'] = height , undefined));
  }
}
;
_.widget = null;
function $isRightButtonDown(){
  return $wnd.isc.EH.rightButtonDown();
}

function DragResizeStartEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(479, 475, {}, DragResizeStartEvent_0);
_.dispatch = function dispatch_6(handler){
  dynamicCast(dynamicCast(handler, Q$DragResizeStartHandler), Q$PortalLayout$2).this$0.dragResizeColumnCount = valueOf_49(0);
}
;
_.getAssociatedType = function getAssociatedType_6(){
  return TYPE_6;
}
;
_.isCancelled = function isCancelled_1(){
  return false;
}
;
var TYPE_6 = null;
function $dispatch_0(this$static, handler){
  $setHeight_3(handler.this$0.storedPortlet, $getAttributeAsInt_0(dynamicCast(this$static.source, Q$Canvas), 'height').value_0);
  $resize(handler.this$0.dashboardView.portalLayout);
  $save_5(handler.this$0.dashboardView);
}

function DragResizeStopEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(480, 475, {}, DragResizeStopEvent_0);
_.dispatch = function dispatch_7(handler){
  $dispatch_0(this, dynamicCast(handler, Q$DragResizeStopHandler));
}
;
_.getAssociatedType = function getAssociatedType_7(){
  return TYPE_7;
}
;
_.isCancelled = function isCancelled_2(){
  return false;
}
;
var TYPE_7 = null;
function DropEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(482, 475, {}, DropEvent_0);
_.dispatch = function dispatch_9(handler){
  $onDrop(dynamicCast(handler, Q$DropHandler));
}
;
_.getAssociatedType = function getAssociatedType_9(){
  return TYPE_9;
}
;
_.isCancelled = function isCancelled_3(){
  return false;
}
;
var TYPE_9 = null;
function $dispatch_1(handler){
  var keyName;
  $equals_6('Delete', (keyName = $wnd.isc.EventHandler.getKey() , keyName == undefined?null:keyName)) && handler.this$0.removeSelectedRows();
}

function KeyPressEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(483, 475, {}, KeyPressEvent_0);
_.dispatch = function dispatch_10(handler){
  $dispatch_1(dynamicCast(handler, Q$KeyPressHandler));
}
;
_.getAssociatedType = function getAssociatedType_10(){
  return TYPE_10;
}
;
_.isCancelled = function isCancelled_4(){
  return false;
}
;
var TYPE_10 = null;
function MinimizeClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(484, 475, {}, MinimizeClickEvent_0);
_.dispatch = function dispatch_11(handler){
  $hide(dynamicCast(dynamicCast(handler, Q$MinimizeClickHandler), Q$PortletWindow$10).this$0.maximizeHeaderControl);
}
;
_.getAssociatedType = function getAssociatedType_11(){
  return TYPE_11;
}
;
_.isCancelled = function isCancelled_5(){
  return false;
}
;
var TYPE_11 = null;
function MouseOutEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(485, 475, {}, MouseOutEvent_0);
_.dispatch = function dispatch_12(handler){
  dynamicCast(handler, Q$MouseOutHandler).onMouseOut(this);
}
;
_.getAssociatedType = function getAssociatedType_12(){
  return TYPE_12;
}
;
_.isCancelled = function isCancelled_6(){
  return false;
}
;
var TYPE_12 = null;
function MouseOverEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(486, 475, {}, MouseOverEvent_0);
_.dispatch = function dispatch_13(handler){
  dynamicCast(handler, Q$MouseOverHandler).onMouseOver(this);
}
;
_.getAssociatedType = function getAssociatedType_13(){
  return TYPE_13;
}
;
_.isCancelled = function isCancelled_7(){
  return false;
}
;
var TYPE_13 = null;
function ResizedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(487, 475, {}, ResizedEvent_0);
_.dispatch = function dispatch_14(handler){
  $onResized(dynamicCast(handler, Q$ResizedHandler));
}
;
_.getAssociatedType = function getAssociatedType_14(){
  return TYPE_14;
}
;
var TYPE_14 = null;
function RestoreClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(488, 475, {}, RestoreClickEvent_0);
_.dispatch = function dispatch_15(handler){
  $show(dynamicCast(dynamicCast(handler, Q$RestoreClickHandler), Q$PortletWindow$11).this$0.maximizeHeaderControl);
}
;
_.getAssociatedType = function getAssociatedType_15(){
  return TYPE_15;
}
;
_.isCancelled = function isCancelled_8(){
  return false;
}
;
var TYPE_15 = null;
function $dispatch_3(this$static, handler){
  var jsObj;
  (jsObj = this$static.jsObj , jsObj.isVisible) || ask(($clinit_Enhanced() , '\u7DE8\u96C6\u3057\u305F\u30A2\u30E9\u30FC\u30C8\u5B9A\u7FA9\u3092\u4FDD\u5B58\u3057\u307E\u3059\u304B?'), new SingleAlertDefinitionView$5$1_0(handler));
}

function VisibilityChangedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(490, 475, {}, VisibilityChangedEvent_0);
_.dispatch = function dispatch_17(handler){
  $dispatch_3(this, dynamicCast(handler, Q$VisibilityChangedHandler));
}
;
_.getAssociatedType = function getAssociatedType_17(){
  return TYPE_17;
}
;
var TYPE_17 = null;
function $addColorSelectedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_18 && (TYPE_18 = new GwtEvent$Type_0) , TYPE_18)) == 0 && $setupColorSelectedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_18 && (TYPE_18 = new GwtEvent$Type_0) , TYPE_18));
}

function $setupColorSelectedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({colorSelected:$entry(function(){
      var param = {color:arguments[0], opacity:arguments[1]};
      var event_0 = new ColorSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.colorSelected = $entry(function(){
      var param = {color:arguments[0], opacity:arguments[1]};
      var event_0 = new ColorSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function ColorPicker_0(){
  $clinit_BaseWidget();
  Window_1.call(this);
  this.scClassName = 'ColorPicker';
}

defineSeed(491, 458, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), ColorPicker_0);
_.create_0 = function create_24(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
function $addFormSubmitFailedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_19 && (TYPE_19 = new GwtEvent$Type_0) , TYPE_19)) == 0 && $setupFormSubmitFailedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_19 && (TYPE_19 = new GwtEvent$Type_0) , TYPE_19));
}

function $addItemChangeHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_20 && (TYPE_20 = new GwtEvent$Type_0) , TYPE_20)) == 0 && $setupItemChangeEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_20 && (TYPE_20 = new GwtEvent$Type_0) , TYPE_20));
}

function $addItemChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_21 && (TYPE_21 = new GwtEvent$Type_0) , TYPE_21)) == 0 && $setupItemChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_21 && (TYPE_21 = new GwtEvent$Type_0) , TYPE_21));
}

function $clearValue(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.clearValue(fieldName);
}

function $editRecord(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.editRecord(record.getJsObj());
}

function $fetchData_1(this$static, criteria, callback){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $getField_0(this$static, name_0){
  var field, field$array, field$index, field$max, fieldJS;
  if (this$static.fields_0 != null) {
    for (field$array = this$static.fields_0 , field$index = 0 , field$max = field$array.length; field$index < field$max; ++field$index) {
      field = field$array[field$index];
      if ($equals_6(name_0, $isCreated_2(field)?$getPropertyAsString(field, 'name'):getAttribute(field.jsObj, 'name'))) {
        return field;
      }
    }
  }
   else {
    fieldJS = $getFieldJS(this$static, name_0);
    return fieldJS?getFormItem(fieldJS):null;
  }
  return null;
}

function $getValue(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  var val = self_0.getValue(fieldName);
  return val == null || val === undefined?null:$wnd.SmartGWT.convertToJavaType(val);
}

function $hideItem(this$static, itemName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.hideItem(itemName);
}

function $isNewRecord(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isNewRecord();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $resetValues(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.resetValues();
}

function $saveData(this$static, callback){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.saveData($entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $saveData_0(this$static, callback, requestProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var requestPropertiesJS = requestProperties == null?null:requestProperties.getJsObj();
  self_0.saveData($entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ), requestPropertiesJS);
}

function $setAction(this$static, action){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'action', action):(this$static.config_0['action'] = action , undefined);
}

function $setAutoFetchData(this$static, autoFetchData){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'autoFetchData', autoFetchData);
}

function $setCanFocus(this$static, canFocus){
  $isCreated_1(this$static)?!canFocus?$setNullProperty(this$static, 'canFocus'):$setProperty_5(this$static, 'canFocus', canFocus.value_0):setAttribute_5(this$static.config_0, 'canFocus', canFocus);
}

function $setCellPadding(this$static){
  $isCreated_1(this$static)?$setProperty_1(this$static, 'cellPadding', 5):(this$static.config_0['cellPadding'] = 5 , undefined);
}

function $setColWidths(this$static, colWidths){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'colWidths', convertToJavaScriptArray_0(colWidths)):(this$static.config_0['colWidths'] = convertToJavaScriptArray_0(colWidths) , undefined);
}

function $setErrors(this$static, errors, showErrors){
  var self_0 = this$static.getOrCreateJsObj();
  var errorsJS = convertMapToJavascriptObject(errors);
  return self_0.setErrors(errorsJS, showErrors);
}

function $setHiliteRequiredFields(this$static, hiliteRequiredFields){
  $isCreated_1(this$static)?!hiliteRequiredFields?$setNullProperty(this$static, 'hiliteRequiredFields'):$setProperty_5(this$static, 'hiliteRequiredFields', hiliteRequiredFields.value_0):setAttribute_5(this$static.config_0, 'hiliteRequiredFields', hiliteRequiredFields);
}

function $setShowInlineErrors(this$static, showInlineErrors){
  $isCreated_1(this$static)?!showInlineErrors?$setNullProperty(this$static, 'showInlineErrors'):$setProperty_5(this$static, 'showInlineErrors', showInlineErrors.value_0):setAttribute_5(this$static.config_0, 'showInlineErrors', showInlineErrors);
}

function $setStopOnError(this$static, stopOnError){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'stopOnError', stopOnError);
}

function $setTarget(this$static, target){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'target', target):(this$static.config_0['target'] = target , undefined);
}

function $setValidateOnChange(this$static, validateOnChange){
  $isCreated_1(this$static)?!validateOnChange?$setNullProperty(this$static, 'validateOnChange'):$setProperty_5(this$static, 'validateOnChange', validateOnChange.value_0):setAttribute_5(this$static.config_0, 'validateOnChange', validateOnChange);
}

function $setValue(this$static, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setValue(fieldName, value);
}

function $setValue_1(this$static, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setValue(fieldName, value);
}

function $setValue_2(this$static, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  var valueJS = convertToJavaScriptArray_0(value);
  self_0.setValue(fieldName, valueJS);
}

function $setupFormSubmitFailedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({formSubmitFailed:$entry(function(){
      var param = {};
      var event_0 = new FormSubmitFailedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.formSubmitFailed = $entry(function(){
      var param = {};
      var event_0 = new FormSubmitFailedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupItemChangeEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({itemChange:$debox($entry(function(){
      var param = {item:arguments[0], newValue:arguments[1], oldValue:arguments[2]};
      var event_0 = new ItemChangeEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.itemChange = $debox($entry(function(){
      var param = {item:arguments[0], newValue:arguments[1], oldValue:arguments[2]};
      var event_0 = new ItemChangeEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupItemChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({itemChanged:$entry(function(){
      var param = {item:arguments[0], newValue:arguments[1]};
      var event_0 = new ItemChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.itemChanged = $entry(function(){
      var param = {item:arguments[0], newValue:arguments[1]};
      var event_0 = new ItemChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $showItem(this$static, itemName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.showItem(itemName);
}

function $submitForm(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.submitForm();
}

function $validate_0(this$static, validateHiddenFields){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.validate(validateHiddenFields);
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function DynamicForm_1(jsObj){
  Canvas_2.call(this, jsObj);
}

function getOrCreateRef_5(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$DynamicForm):new DynamicForm_1(jsObj);
}

defineSeed(492, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$DynamicForm]), DynamicForm_1);
function $addMember_1(this$static, member){
  var self_0 = this$static.getOrCreateJsObj();
  var memberJS = member.getOrCreateJsObj();
  self_0.addMember(memberJS);
}

function $getErrors_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var value = self_0.getErrors();
  if (value == null)
    return null;
  var valueJ = convertToMap(value);
  return valueJ;
}

function $hasErrors(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasErrors();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $validate_1(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.validate();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function ValuesManager_0(){
  BaseClass_0.call(this);
  this.scClassName = 'ValuesManager';
}

defineSeed(493, 329, makeCastMap([Q$HasHandlers, Q$BaseClass]), ValuesManager_0);
_.create_0 = function create_26(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  return $wnd.isc[scClassName].create(config);
}
;
function $getColor_0(this$static){
  var jsObj = this$static.jsObj;
  return jsObj.color;
}

function ColorSelectedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(494, 475, {}, ColorSelectedEvent_0);
_.dispatch = function dispatch_18(handler){
  dynamicCast(handler, Q$ColorSelectedHandler).onColorSelected(this);
}
;
_.getAssociatedType = function getAssociatedType_18(){
  return TYPE_18;
}
;
var TYPE_18 = null;
function FormSubmitFailedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(495, 475, {}, FormSubmitFailedEvent_0);
_.dispatch = function dispatch_19(handler){
  dynamicCast(handler, Q$FormSubmitFailedHandler).onFormSubmitFailed(this);
}
;
_.getAssociatedType = function getAssociatedType_19(){
  return TYPE_19;
}
;
var TYPE_19 = null;
function $dispatch_4(this$static, handler){
  $onItemChange(handler, this$static);
}

function $getNewValue(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.newValue);
}

function ItemChangeEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(496, 475, {}, ItemChangeEvent_0);
_.dispatch = function dispatch_20(handler){
  $dispatch_4(this, dynamicCast(handler, Q$ItemChangeHandler));
}
;
_.getAssociatedType = function getAssociatedType_20(){
  return TYPE_20;
}
;
_.isCancelled = function isCancelled_10(){
  return false;
}
;
var TYPE_20 = null;
function ItemChangedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(497, 475, {}, ItemChangedEvent_0);
_.dispatch = function dispatch_21(handler){
  dynamicCast(handler, Q$ItemChangedHandler).onItemChanged(this);
}
;
_.getAssociatedType = function getAssociatedType_21(){
  return TYPE_21;
}
;
var TYPE_21 = null;
function $addBlurHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_23 && (TYPE_23 = new GwtEvent$Type_0) , TYPE_23)) == 0 && $setupBlurEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_23 && (TYPE_23 = new GwtEvent$Type_0) , TYPE_23));
}

function $addChangeHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_24 && (TYPE_24 = new GwtEvent$Type_0) , TYPE_24)) == 0 && $setupChangeEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_24 && (TYPE_24 = new GwtEvent$Type_0) , TYPE_24));
}

function $addChangedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_25 && (TYPE_25 = new GwtEvent$Type_0) , TYPE_25)) == 0 && $setupChangedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_25 && (TYPE_25 = new GwtEvent$Type_0) , TYPE_25));
}

function $addFocusHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_28 && (TYPE_28 = new GwtEvent$Type_0) , TYPE_28)) == 0 && $setupFocusEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_28 && (TYPE_28 = new GwtEvent$Type_0) , TYPE_28));
}

function $addIconClickHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_30 && (TYPE_30 = new GwtEvent$Type_0) , TYPE_30)) == 0 && $setupIconClickEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_30 && (TYPE_30 = new GwtEvent$Type_0) , TYPE_30));
}

function $addItemHoverHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_31 && (TYPE_31 = new GwtEvent$Type_0) , TYPE_31)) == 0 && $setupItemHoverEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_31 && (TYPE_31 = new GwtEvent$Type_0) , TYPE_31));
}

function $doSetValue(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $getAttribute_0(this$static, attribute){
  return $isCreated_2(this$static)?$getPropertyAsString(this$static, attribute):getAttribute(this$static.jsObj, attribute);
}

function $getAttributeAsInt_1(this$static){
  var self_0, ret;
  return $isCreated_2(this$static)?(self_0 = this$static.getJsObj() , ret = self_0.getProperty('singleResourceId') , ret == null || ret === undefined?null:valueOf_49(ret)):getAttributeAsInt(this$static.jsObj, 'singleResourceId');
}

function $getConfig(this$static){
  var self_0 = this$static.getJsObj();
  var config = {};
  for (var k in self_0) {
    k != '__ref' && k != 'type' && k != 'editorType' && k != 'name' && (config[k] = self_0[k]);
  }
  self_0.transformInput && (config['transformInput'] = self_0.transformInput);
  return config;
}

function $getDisplayValue(this$static){
  var self_0 = this$static.getJsObj();
  if (self_0.setValue) {
    var val = self_0.getDisplayValue();
    return val == null?null:val.toString();
  }
   else {
    return '';
  }
}

function $getForm(this$static){
  var self_0 = this$static.getJsObj();
  if (self_0.form) {
    return getOrCreateRef_5(self_0.form);
  }
   else {
    return null;
  }
}

function $getIcon(this$static, name_0){
  var self_0 = this$static.getJsObj();
  var ret = self_0.getIcon(name_0);
  if (ret == null || ret === undefined)
    return null;
  return new FormItemIcon_1(ret);
}

function $getPropertyAsBoolean(this$static, property){
  var self_0 = this$static.getJsObj();
  var ret = self_0.getProperty(property);
  return ret == null || ret === undefined?null:toBoolean(ret);
}

function $getTitle(this$static){
  return $isCreated_2(this$static)?$getPropertyAsString(this$static, 'title'):getAttribute(this$static.jsObj, 'title');
}

function $isDisabled_0(this$static){
  var self_0 = this$static.getJsObj();
  var retVal = self_0.isDisabled();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $redraw_0(this$static){
  var self_0 = this$static.getJsObj();
  self_0.setValue && self_0.redraw();
}

function $setCanEdit(this$static, canEdit){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'canEdit', canEdit.value_0):setAttribute_5(this$static.jsObj, 'canEdit', canEdit);
}

function $setCanFocus_0(this$static, canFocus){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'canFocus', canFocus.value_0):setAttribute_5(this$static.jsObj, 'canFocus', canFocus);
}

function $setCellStyle(this$static, cellStyle){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'cellStyle', cellStyle):(this$static.jsObj['cellStyle'] = cellStyle , undefined);
}

function $setColSpan_0(this$static, colSpan){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'colSpan', colSpan):(this$static.jsObj['colSpan'] = colSpan , undefined);
}

function $setDefaultValue(this$static, defaultValue){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'defaultValue', defaultValue.value_0):setAttribute_5(this$static.jsObj, 'defaultValue', defaultValue);
}

function $setDefaultValue_0(this$static, defaultValue){
  setAttribute_8(this$static.jsObj, 'defaultValue', defaultValue);
}

function $setDefaultValue_1(this$static, defaultValue){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'defaultValue', defaultValue):(this$static.jsObj['defaultValue'] = defaultValue , undefined);
}

function $setEmptyDisplayValue(this$static, emptyDisplayValue){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'emptyDisplayValue', emptyDisplayValue):(this$static.jsObj['emptyDisplayValue'] = emptyDisplayValue , undefined);
}

function $setEndRow_0(this$static, endRow){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'endRow', endRow.value_0):setAttribute_5(this$static.jsObj, 'endRow', endRow);
}

function $setErrorOrientation_0(this$static, errorOrientation){
  this$static.jsObj['errorOrientation'] = !errorOrientation?null:errorOrientation.value_0;
}

function $setHeight_1(this$static, height){
  $equals_6('100%', height) && (height = '*');
  $isCreated_2(this$static)?$setProperty_9(this$static, 'height', height):(this$static.jsObj['height'] = height , undefined);
}

function $setHint(this$static, hint){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'hint', hint):(this$static.jsObj['hint'] = hint , undefined);
}

function $setHoverWidth_0(this$static, hoverWidth){
  setAttribute_8(this$static.jsObj, 'hoverWidth', hoverWidth);
}

function $setIcons(this$static, icons){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'icons', convertToJavaScriptArray_0(icons)):(this$static.jsObj['icons'] = convertToJavaScriptArray_0(icons) , undefined);
}

function $setPrompt_1(this$static, prompt_0){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'prompt', prompt_0):(this$static.jsObj['prompt'] = prompt_0 , undefined);
}

function $setRedrawOnChange(this$static){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'redrawOnChange', true):(this$static.jsObj['redrawOnChange'] = true , undefined);
}

function $setShowHint(this$static, showHint){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'showHint', showHint.value_0):setAttribute_5(this$static.jsObj, 'showHint', showHint);
}

function $setShowIcons(this$static, showIcons){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'showIcons', showIcons.value_0):setAttribute_5(this$static.jsObj, 'showIcons', showIcons);
}

function $setShowIfCondition(this$static, showIf){
  var self_0 = this$static.getJsObj();
  self_0.showIf = $debox($entry(function(item, value, form, values){
    var itemJ = getOrCreateRef_6(item);
    var valueJ = $wnd.SmartGWT.convertToJavaType(value);
    var formJ = getOrCreateRef_5(form);
    return showIf.execute_6(itemJ, valueJ, formJ);
  }
  ));
}

function $setShowPickerIcon(this$static, showPickerIcon){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'showPickerIcon', showPickerIcon.value_0):setAttribute_5(this$static.jsObj, 'showPickerIcon', showPickerIcon);
}

function $setShowValueIconOnly(this$static, showValueIconOnly){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'showValueIconOnly', showValueIconOnly.value_0):setAttribute_5(this$static.jsObj, 'showValueIconOnly', showValueIconOnly);
}

function $setStartRow_0(this$static, startRow){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'startRow', startRow.value_0):setAttribute_5(this$static.jsObj, 'startRow', startRow);
}

function $setTabIndex(this$static, tabIndex){
  setAttribute_8(this$static.jsObj, 'tabIndex', tabIndex);
}

function $setType(this$static, type){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'type', type):(this$static.jsObj['type'] = type , undefined);
}

function $setValidateOnChange_0(this$static, validateOnChange){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'validateOnChange', validateOnChange.value_0):setAttribute_5(this$static.jsObj, 'validateOnChange', validateOnChange);
}

function $setValidateOnExit_0(this$static, validateOnExit){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'validateOnExit', validateOnExit.value_0):setAttribute_5(this$static.jsObj, 'validateOnExit', validateOnExit);
}

function $setValue_3(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValue_4(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValue_5(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValue_6(this$static, value){
  value == null || instanceOf(value, Q$String)?this$static.setValue_4(dynamicCast(value, Q$String)):instanceOf(value, Q$Integer)?this$static.setValue_2(dynamicCast(value, Q$Integer).value_0):instanceOf(value, Q$Long)?this$static.setValue_2(toInt(dynamicCast(value, Q$Long).value_0)):instanceOf(value, Q$Double)?this$static.setValue_0(dynamicCast(value, Q$Double).value_0):instanceOf(value, Q$Float)?this$static.setValue_1(dynamicCast(value, Q$Float).value_0):instanceOf(value, Q$Boolean)?this$static.setValue_6(dynamicCast(value, Q$Boolean).value_0):instanceOf(value, Q$Date)?this$static.setValue_5(dynamicCast(value, Q$Date)):instanceOf(value, Q$RelativeDate)?this$static.setValue_4(dynamicCast(value, Q$RelativeDate).value_0):$doSetValue(this$static, value);
}

function $setValue_8(this$static, value){
  var self_0 = this$static.getJsObj();
  var valueJS = convertToJavaScriptDate(value);
  self_0.setValue?self_0.setValue(valueJS):(self_0.value = valueJS);
}

function $setValue_9(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValueIconHeight(this$static, valueIconHeight){
  setAttribute_8(this$static.jsObj, 'valueIconHeight', valueIconHeight);
}

function $setValueIconWidth(this$static, valueIconWidth){
  setAttribute_8(this$static.jsObj, 'valueIconWidth', valueIconWidth);
}

function $setValueIcons(this$static, valueIcons){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'valueIcons', convertMapToJavascriptObject(valueIcons)):(this$static.jsObj['valueIcons'] = convertMapToJavascriptObject(valueIcons) , undefined);
}

function $setValueMap(this$static, valueMap){
  $isCreated_2(this$static)?$setValueMapMethod(this$static, convertMapToJavascriptObject(valueMap)):$isCreated_2(this$static)?$setProperty_8(this$static, 'valueMap', convertMapToJavascriptObject(valueMap)):(this$static.jsObj['valueMap'] = convertMapToJavascriptObject(valueMap) , undefined);
}

function $setValueMap_0(this$static, valueMap){
  $isCreated_2(this$static)?$setValueMapMethod(this$static, convertToJavaScriptArray_0(valueMap)):$isCreated_2(this$static)?$setProperty_8(this$static, 'valueMap', convertToJavaScriptArray_0(valueMap)):(this$static.jsObj['valueMap'] = convertToJavaScriptArray_0(valueMap) , undefined);
}

function $setValueMapMethod(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValueMap(value);
}

function $setupBlurEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.blur = $entry(function(){
    var param = {form:arguments[0], item:arguments[1]};
    var event_0 = new BlurEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupChangeEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.change = $debox($entry(function(){
    var param = {form:arguments[0], item:arguments[1], value:arguments[2], oldValue:arguments[3]};
    var event_0 = new ChangeEvent_0(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function $setupFocusEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.focus = $entry(function(){
    var param = {form:arguments[0], item:arguments[1]};
    var event_0 = new FocusEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupIconClickEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.iconClick = $entry(function(){
    var param = {form:arguments[0], item:arguments[1], icon:arguments[2]};
    var event_0 = new IconClickEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupItemHoverEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.itemHover = $entry(function(){
    var param = {item:arguments[0], form:arguments[1]};
    var event_0 = new ItemHoverEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $validate_2(this$static){
  var self_0 = this$static.getJsObj();
  var retVal = self_0.validate();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

defineSeed(501, 335, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.addClickHandler = function addClickHandler(handler){
  return $addClickHandler_0(this, handler);
}
;
_.enable_0 = function enable(){
  $setDisabled_2(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
}
;
_.getPrompt = function getPrompt(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'prompt'):getAttribute(this.jsObj, 'prompt');
}
;
_.getShowTitle = function getShowTitle(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.getTitle = function getTitle(){
  return $getTitle(this);
}
;
_.setDefaultValue = function setDefaultValue(defaultValue){
  $setDefaultValue_0(this, defaultValue);
}
;
_.setDefaultValue_0 = function setDefaultValue_0(defaultValue){
  $setDefaultValue_1(this, defaultValue);
}
;
_.setEndRow = function setEndRow(endRow){
  $setEndRow_0(this, endRow);
}
;
_.setIconVAlign = function setIconVAlign(iconVAlign){
  $setAttribute_30(this, 'iconVAlign', iconVAlign.value_0);
}
;
_.setPrompt = function setPrompt(prompt_0){
  $setPrompt_1(this, prompt_0);
}
;
_.setStartRow = function setStartRow(startRow){
  $setStartRow_0(this, startRow);
}
;
_.setValidateOnChange = function setValidateOnChange(validateOnChange){
  $setValidateOnChange_0(this, validateOnChange);
}
;
_.setValidateOnExit = function setValidateOnExit(validateOnExit){
  $setValidateOnExit_0(this, validateOnExit);
}
;
_.setValue_0 = function setValue(value){
  $setValue_3(this, value);
}
;
_.setValue_1 = function setValue_0(value){
  $setValue_4(this, value);
}
;
_.setValue_2 = function setValue_1(value){
  $setValue_5(this, value);
}
;
_.setValue_3 = function setValue_2(value){
  $setValue_6(this, value);
}
;
_.setValue_4 = function setValue_3(value){
  $setValue_7(this, value);
}
;
_.setValue_5 = function setValue_4(value){
  $setValue_8(this, value);
}
;
_.setValue_6 = function setValue_5(value){
  $setValue_9(this, value);
}
;
_.setValueMap_0 = function setValueMap(valueMap){
  $setValueMap(this, valueMap);
}
;
_.setValueMap_1 = function setValueMap_0(valueMap){
  $setValueMap_0(this, valueMap);
}
;
_.validate_1 = function validate_0(){
  return $validate_2(this);
}
;
function $getValueAsString_0(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $setLength(this$static, length_0){
  setAttribute_8(this$static.jsObj, 'length', length_0);
}

function $setSelectionRange(this$static, start, end){
  var self_0 = this$static.getJsObj();
  self_0.setSelectionRange(start, end);
}

function TextAreaItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'TextAreaItem'):(this.jsObj['editorType'] = 'TextAreaItem' , undefined);
}

function TextAreaItem_1(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'recipeText'):(this.jsObj['name'] = 'recipeText' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'TextAreaItem'):(this.jsObj['editorType'] = 'TextAreaItem' , undefined);
}

function TextAreaItem_2(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'TextAreaItem'):(this.jsObj['editorType'] = 'TextAreaItem' , undefined);
}

defineSeed(500, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextAreaItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), TextAreaItem_0, TextAreaItem_1, TextAreaItem_2);
_.setIconVAlign = function setIconVAlign_0(iconVAlign){
  $setAttribute_30(this, 'iconVAlign', iconVAlign.value_0);
}
;
_.setWidth = function setWidth_0(width){
  $isCreated_2(this)?$setProperty_7(this, 'width', width):(this.jsObj['width'] = width , undefined);
}
;
function AutoFitTextAreaItem_0(title){
  TextAreaItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'description'):(this.jsObj['name'] = 'description' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'AutoFitTextAreaItem'):(this.jsObj['editorType'] = 'AutoFitTextAreaItem' , undefined);
}

defineSeed(499, 500, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextAreaItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), AutoFitTextAreaItem_0);
function $setPrompt_2(this$static, prompt_0){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'prompt', prompt_0):(this$static.jsObj['prompt'] = prompt_0 , undefined);
}

function CanvasItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'CanvasItem'):(this.jsObj['editorType'] = 'CanvasItem' , undefined);
  $setupCanvasConstructor(this);
}

defineSeed(503, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), CanvasItem_1);
_.getCanvas = function getCanvas(){
  return getOrCreateRef_3($isCreated_2(this)?$getPropertyAsJSO(this, 'canvas'):getAttributeAsJavaScriptObject(this.jsObj, 'canvas'));
}
;
_.getPrompt = function getPrompt_0(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'prompt'):getAttribute(this.jsObj, 'prompt');
}
;
_.setPrompt = function setPrompt_0(prompt_0){
  $setPrompt_2(this, prompt_0);
}
;
function $addClickHandler_1(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26)) == 0 && $setupClickEvent_1(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26));
}

function $setAutoFit_1(this$static, autoFit){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'autoFit', autoFit.value_0):setAttribute_5(this$static.jsObj, 'autoFit', autoFit);
}

function $setEndRow_1(this$static, endRow){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'endRow', endRow.value_0):setAttribute_5(this$static.jsObj, 'endRow', endRow);
}

function $setIcon_2(this$static){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'icon', 'global/upload.png'):(this$static.jsObj['icon'] = 'global/upload.png' , undefined);
}

function $setStartRow_1(this$static, startRow){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'startRow', startRow.value_0):setAttribute_5(this$static.jsObj, 'startRow', startRow);
}

function $setupClickEvent_1(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.click = $entry(function(){
    var param = {form:arguments[0], item:arguments[1]};
    var event_0 = new ClickEvent_2(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function ButtonItem_0(){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', '\u30A2\u30C3\u30D7\u30ED\u30FC\u30C9'):(this.jsObj['name'] = '\u30A2\u30C3\u30D7\u30ED\u30FC\u30C9' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'ButtonItem'):(this.jsObj['editorType'] = 'ButtonItem' , undefined);
}

function ButtonItem_1(name_0, title){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  this.setTitle(title);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'ButtonItem'):(this.jsObj['editorType'] = 'ButtonItem' , undefined);
}

defineSeed(502, 503, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), ButtonItem_1);
_.addClickHandler = function addClickHandler_0(handler){
  return $addClickHandler_1(this, handler);
}
;
_.getCanvas = function getCanvas_0(){
  return getOrCreateRef_4($isCreated_2(this)?$getPropertyAsJSO(this, 'canvas'):getAttributeAsJavaScriptObject(this.jsObj, 'canvas'));
}
;
_.getShowTitle = function getShowTitle_0(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setEndRow = function setEndRow_0(endRow){
  $setEndRow_1(this, endRow);
}
;
_.setStartRow = function setStartRow_0(startRow){
  $setStartRow_1(this, startRow);
}
;
function $getValueAsBoolean(this$static){
  var origValue;
  origValue = dynamicCast($getValue_0(this$static), Q$Boolean);
  return $clinit_Boolean() , !(!($isCreated_2(this$static)?$getPropertyAsBoolean(this$static, 'allowEmptyValue'):getAttributeAsBoolean(this$static.jsObj, 'allowEmptyValue')?TRUE:FALSE).value_0 && !origValue) && origValue.value_0?TRUE:FALSE;
}

function $setLabelAsTitle(this$static, labelAsTitle){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'labelAsTitle', labelAsTitle.value_0):setAttribute_5(this$static.jsObj, 'labelAsTitle', labelAsTitle);
}

function $setShowLabel(this$static, showLabel){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'showLabel', showLabel.value_0):setAttribute_5(this$static.jsObj, 'showLabel', showLabel);
}

function $setShowTitle_2(this$static, showTitle){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'showTitle', showTitle.value_0):setAttribute_5(this$static.jsObj, 'showTitle', showTitle);
}

function CheckboxItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'CheckboxItem'):(this.jsObj['editorType'] = 'CheckboxItem' , undefined);
}

function CheckboxItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'CheckboxItem'):(this.jsObj['editorType'] = 'CheckboxItem' , undefined);
}

function CheckboxItem_2(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'CheckboxItem'):(this.jsObj['editorType'] = 'CheckboxItem' , undefined);
}

defineSeed(504, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CheckboxItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), CheckboxItem_0, CheckboxItem_1, CheckboxItem_2);
_.getShowTitle = function getShowTitle_1(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setShowTitle = function setShowTitle_1(showTitle){
  $setShowTitle_2(this, showTitle);
}
;
function $getEnteredValue(this$static){
  var self_0 = this$static.getJsObj();
  return self_0.getEnteredValue();
}

function $setKeyPressFilter(this$static){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'keyPressFilter', '[0-9.]'):(this$static.jsObj['keyPressFilter'] = '[0-9.]' , undefined);
}

function $setLength_0(this$static, length_0){
  setAttribute_8(this$static.jsObj, 'length', length_0);
}

function $setSelectOnFocus(this$static, selectOnFocus){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'selectOnFocus', selectOnFocus.value_0):setAttribute_5(this$static.jsObj, 'selectOnFocus', selectOnFocus);
}

defineSeed(506, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getEnteredValue_0 = function getEnteredValue(){
  return $getEnteredValue(this);
}
;
function $clinit_ComboBoxItem(){
  $clinit_ComboBoxItem = nullMethod;
  init_2();
}

function $addDataArrivedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_27 && (TYPE_27 = new GwtEvent$Type_0) , TYPE_27)) == 0 && $setupDataArrivedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_27 && (TYPE_27 = new GwtEvent$Type_0) , TYPE_27));
}

function $getEnteredValue_0(this$static){
  var self_0 = this$static.getJsObj();
  return self_0.getEnteredValue();
}

function $getSelectedRecord(this$static){
  var self_0 = this$static.getJsObj();
  var ret = self_0.getSelectedRecord();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef(ret);
  retVal == null && (retVal = new ListGridRecord_1(ret));
  return retVal;
}

function $setAddUnknownValues(this$static, addUnknownValues){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'addUnknownValues', addUnknownValues.value_0):setAttribute_5(this$static.jsObj, 'addUnknownValues', addUnknownValues);
}

function $setDefaultToFirstOption(this$static, defaultToFirstOption){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'defaultToFirstOption', defaultToFirstOption.value_0):setAttribute_5(this$static.jsObj, 'defaultToFirstOption', defaultToFirstOption);
}

function $setOptionDataSource(this$static, dataSource){
  this$static.jsObj['optionDataSource'] = !dataSource?null:$getOrCreateJsObj(dataSource);
}

function $setPickListWidth(this$static, pickListWidth){
  setAttribute_8(this$static.jsObj, 'pickListWidth', pickListWidth);
}

function $setupDataArrivedEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.dataArrived = $entry(function(){
    var param = {startRow:arguments[0], endRow:arguments[1], data:arguments[2]};
    var event_0 = new DataArrivedEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function ComboBoxItem_0(){
  $clinit_ComboBoxItem();
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'ComboBoxItem'):(this.jsObj['editorType'] = 'ComboBoxItem' , undefined);
}

function ComboBoxItem_1(){
  $clinit_ComboBoxItem();
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'tag'):(this.jsObj['name'] = 'tag' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'ComboBoxItem'):(this.jsObj['editorType'] = 'ComboBoxItem' , undefined);
}

function ComboBoxItem_2(name_0, title){
  $clinit_ComboBoxItem();
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'ComboBoxItem'):(this.jsObj['editorType'] = 'ComboBoxItem' , undefined);
}

function init_2(){
  if ($wnd.isc.ComboBoxItem.getPrototype().__getPickListFilterCriteria == null) {
    $wnd.isc.ComboBoxItem.getPrototype().__getPickListFilterCriteria = $wnd.isc.ComboBoxItem.getPrototype().getPickListFilterCriteria;
    $wnd.isc.ComboBoxItem.getPrototype().getPickListFilterCriteria = $entry(function(){
      var jObj = this.__ref;
      if (jObj && instanceOf(jObj, Q$ComboBoxItem)) {
        jObj.setJsObj(this);
        var critJ = jObj.getPickListFilterCriteria_0();
        return critJ == null?{}:critJ.getJsObj();
      }
       else {
        return this.__getPickListFilterCriteria();
      }
    }
    );
  }
}

defineSeed(505, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$ComboBoxItem, Q$FormItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), ComboBoxItem_0, ComboBoxItem_1);
_.getEnteredValue_0 = function getEnteredValue_0(){
  return $getEnteredValue_0(this);
}
;
_.getPickListFilterCriteria_0 = function getPickListFilterCriteria(){
  var self_0 = this.getJsObj();
  var critJS = self_0.__getPickListFilterCriteria();
  return critJS == null?null:new Criteria_1(critJS);
}
;
_.getValueAsString = function getValueAsString_0(){
  var self_0 = this.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}
;
function $getValueAsDate(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null?null:toDate(ret.getTime());
}

function $setEndDate_0(this$static, endDate){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'endDate', convertToJavaScriptDate(endDate)):setAttribute_9(this$static.jsObj, 'endDate', endDate);
}

function $setEnforceDate(this$static, enforceDate){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'enforceDate', enforceDate.value_0):setAttribute_5(this$static.jsObj, 'enforceDate', enforceDate);
}

function $setStartDate_0(this$static, startDate){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'startDate', convertToJavaScriptDate(startDate)):setAttribute_9(this$static.jsObj, 'startDate', startDate);
}

function $setUseMask(this$static, useMask){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'useMask', useMask.value_0):setAttribute_5(this$static.jsObj, 'useMask', useMask);
}

function $setUseTextField(this$static, useTextField){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'useTextField', useTextField.value_0):setAttribute_5(this$static.jsObj, 'useTextField', useTextField);
}

function DateItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'DateItem'):(this.jsObj['editorType'] = 'DateItem' , undefined);
}

function DateItem_1(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'DateItem'):(this.jsObj['editorType'] = 'DateItem' , undefined);
}

defineSeed(507, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), DateItem_1);
function $setUseTextField_0(this$static, useTextField){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'useTextField', useTextField.value_0):setAttribute_5(this$static.jsObj, 'useTextField', useTextField);
}

function DateTimeItem_0(name_0){
  DateItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'DateTimeItem'):(this.jsObj['editorType'] = 'DateTimeItem' , undefined);
}

function DateTimeItem_1(name_0, title){
  DateItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'DateTimeItem'):(this.jsObj['editorType'] = 'DateTimeItem' , undefined);
}

defineSeed(509, 507, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$DateTimeItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), DateTimeItem_0, DateTimeItem_1);
function FloatItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'type', 'float'):(this.jsObj['type'] = 'float' , undefined);
}

defineSeed(510, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), FloatItem_0);
function $addFormItemClickHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_29 && (TYPE_29 = new GwtEvent$Type_0) , TYPE_29)) == 0 && $setupFormItemClickEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_29 && (TYPE_29 = new GwtEvent$Type_0) , TYPE_29));
}

function $setHeight_2(this$static, height){
  setAttribute_8(this$static.jsObj, 'height', height);
}

function $setWidth_4(this$static, width){
  setAttribute_8(this$static.jsObj, 'width', width);
}

function $setupFormItemClickEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.click = $entry(function(){
    var param = {form:arguments[0], item:arguments[1], icon:arguments[2]};
    var event_0 = new FormItemIconClickEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function FormItemIcon_1(jsObj){
  this.jsObj = jsObj;
}

defineSeed(512, 330, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$FormItemIcon, Q$HasFormItemClickHandlers]), FormItemIcon_1);
function HeaderItem_1(title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'header'):(this.jsObj['name'] = 'header' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'HeaderItem'):(this.jsObj['editorType'] = 'HeaderItem' , undefined);
}

defineSeed(513, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), HeaderItem_1);
_.getShowTitle = function getShowTitle_2(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setDefaultValue_0 = function setDefaultValue_1(defaultValue){
  $isCreated_2(this)?$setProperty_9(this, 'defaultValue', defaultValue):(this.jsObj['defaultValue'] = defaultValue , undefined);
}
;
_.setEndRow = function setEndRow_1(endRow){
  $isCreated_2(this)?$setProperty_10(this, 'endRow', endRow.value_0):setAttribute_5(this.jsObj, 'endRow', endRow);
}
;
_.setStartRow = function setStartRow_1(startRow){
  $isCreated_2(this)?$setProperty_10(this, 'startRow', startRow.value_0):setAttribute_5(this.jsObj, 'startRow', startRow);
}
;
defineSeed(514, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getShowTitle = function getShowTitle_3(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
defineSeed(516, 503, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
function IPickTreeItem_0(title){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'PickTreeItem'):(this.jsObj['editorType'] = 'PickTreeItem' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'type'):(this.jsObj['name'] = 'type' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'IPickTreeItem'):(this.jsObj['editorType'] = 'IPickTreeItem' , undefined);
}

defineSeed(515, 516, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), IPickTreeItem_0);
function IntegerItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'type', 'integer'):(this.jsObj['type'] = 'integer' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'TextItem'):(this.jsObj['editorType'] = 'TextItem' , undefined);
}

function IntegerItem_1(title){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'value'):(this.jsObj['name'] = 'value' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'type', 'integer'):(this.jsObj['type'] = 'integer' , undefined);
}

defineSeed(517, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$IntegerItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), IntegerItem_0, IntegerItem_1);
function $setEscapeHTML(this$static, escapeHTML){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'escapeHTML', escapeHTML.value_0):setAttribute_5(this$static.jsObj, 'escapeHTML', escapeHTML);
}

function $setTextBoxStyle(this$static){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'textBoxStyle', null):(this$static.jsObj['textBoxStyle'] = null , undefined);
}

function $setWrap_1(this$static, wrap){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'wrap', wrap.value_0):setAttribute_5(this$static.jsObj, 'wrap', wrap);
}

function $addClickHandler_2(this$static, handler){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'target', 'javascript'):(this$static.jsObj['target'] = 'javascript' , undefined);
  return $getHandlerCount_0(this$static, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26)) == 0 && $setupClickEvent_0(this$static) , $doAddHandler(this$static, handler, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26));
}

function LinkItem_0(){
  StaticTextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'LinkItem'):(this.jsObj['editorType'] = 'LinkItem' , undefined);
}

defineSeed(518, 519, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$StaticTextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), LinkItem_0);
_.addClickHandler = function addClickHandler_1(handler){
  return $addClickHandler_2(this, handler);
}
;
function PasswordItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'PasswordItem'):(this.jsObj['editorType'] = 'PasswordItem' , undefined);
}

function PasswordItem_1(name_0){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'PasswordItem'):(this.jsObj['editorType'] = 'PasswordItem' , undefined);
}

defineSeed(520, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$PasswordItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), PasswordItem_0, PasswordItem_1);
function $clinit_PickerIcon(){
  var imgType;
  $clinit_PickerIcon = nullMethod;
  IMG_TYPE_1 = (imgType = $wnd.isc.pickerImgType , imgType == null || imgType === undefined?'png':imgType);
  CLEAR = new PickerIcon$Picker_0('[SKIN]/pickers/clear_picker.' + IMG_TYPE_1);
  new PickerIcon$Picker_0('[SKIN]/pickers/comboBoxPicker.' + IMG_TYPE_1);
  new PickerIcon$Picker_0('[SKIN]/pickers/date_picker.' + IMG_TYPE_1);
  REFRESH_0 = new PickerIcon$Picker_0('[SKIN]/pickers/refresh_picker.' + IMG_TYPE_1);
  new PickerIcon$Picker_0('[SKIN]/pickers/search_picker.' + IMG_TYPE_1);
}

function PickerIcon_0(icon, clickHandler){
  $clinit_PickerIcon();
  FormItemIcon_0.call(this);
  $setAttribute_13(this, 'src', icon.url);
  $setWidth_4(this, valueOf_49(18));
  $setHeight_2(this, valueOf_49(22));
  this.jsObj['hspace'] = 0;
  $getHandlerCount_0(this, (!TYPE_29 && (TYPE_29 = new GwtEvent$Type_0) , TYPE_29)) == 0 && $setupFormItemClickEvent(this);
  $doAddHandler(this, clickHandler, (!TYPE_29 && (TYPE_29 = new GwtEvent$Type_0) , TYPE_29));
}

defineSeed(521, 512, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$FormItemIcon, Q$HasFormItemClickHandlers]), PickerIcon_0);
var CLEAR, IMG_TYPE_1, REFRESH_0;
function PickerIcon$Picker_0(url){
  this.url = url;
}

defineSeed(522, 1, {}, PickerIcon$Picker_0);
_.url = null;
function $getValueAsString_2(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $setVertical_0(this$static, vertical){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'vertical', vertical.value_0):setAttribute_5(this$static.jsObj, 'vertical', vertical);
}

function $setWrap_2(this$static, wrap){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'wrap', wrap.value_0):setAttribute_5(this$static.jsObj, 'wrap', wrap);
}

function RadioGroupItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'RadioGroupItem'):(this.jsObj['editorType'] = 'RadioGroupItem' , undefined);
}

function RadioGroupItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'RadioGroupItem'):(this.jsObj['editorType'] = 'RadioGroupItem' , undefined);
}

function RadioGroupItem_2(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'RadioGroupItem'):(this.jsObj['editorType'] = 'RadioGroupItem' , undefined);
}

defineSeed(523, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$RadioGroupItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), RadioGroupItem_0, RadioGroupItem_1, RadioGroupItem_2);
function getAbsoluteDate_0(relativeDate){
  var retVal = $wnd.isc.RelativeDateItem.getAbsoluteDate(relativeDate.getValue_0());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toDate(retVal.getTime());
  }
}

function SpacerItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SpacerItem'):(this.jsObj['editorType'] = 'SpacerItem' , undefined);
}

defineSeed(526, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SpacerItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SpacerItem_1);
_.getShowTitle = function getShowTitle_4(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
defineSeed(525, 526, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SpacerItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getShowTitle = function getShowTitle_5(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setEndRow = function setEndRow_2(endRow){
  $isCreated_2(this)?$setProperty_10(this, 'endRow', endRow.value_0):setAttribute_5(this.jsObj, 'endRow', endRow);
}
;
_.setStartRow = function setStartRow_2(startRow){
  $isCreated_2(this)?$setProperty_10(this, 'startRow', startRow.value_0):setAttribute_5(this.jsObj, 'startRow', startRow);
}
;
function SectionItem_0(name_0){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SectionItem'):(this.jsObj['editorType'] = 'SectionItem' , undefined);
}

defineSeed(527, 503, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SectionItem_0);
function $clinit_SelectItem(){
  $clinit_SelectItem = nullMethod;
  init_3();
}

function $fetchData_2(this$static){
  var self_0 = this$static.getJsObj();
  self_0.fetchData();
}

function $getValueAsString_3(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $getValues(this$static){
  var self_0 = this$static.getJsObj();
  var value;
  self_0.getValue?(value = self_0.getValue()):(value = self_0.value);
  value == null?(value = []):!$wnd.isc.isA.Array(value) && (value = [value]);
  return convertToJavaStringArray(value);
}

function $setAllowEmptyValue(this$static, allowEmptyValue){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'allowEmptyValue', allowEmptyValue.value_0):setAttribute_5(this$static.jsObj, 'allowEmptyValue', allowEmptyValue);
}

function $setDefaultToFirstOption_0(this$static, defaultToFirstOption){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'defaultToFirstOption', defaultToFirstOption.value_0):setAttribute_5(this$static.jsObj, 'defaultToFirstOption', defaultToFirstOption);
}

function $setMultiple(this$static, multiple){
  $isCreated_2(this$static)?$setProperty_10(this$static, 'multiple', multiple.value_0):setAttribute_5(this$static.jsObj, 'multiple', multiple);
}

function $setOptionDataSource_0(this$static, dataSource){
  this$static.jsObj['optionDataSource'] = !dataSource?null:$getOrCreateJsObj(dataSource);
}

function $setValues(this$static, values){
  var self_0 = this$static.getJsObj();
  var valuesJS = convertToJavaScriptArray_0(values);
  self_0.setValue?self_0.setValue(valuesJS):(self_0.value = valuesJS);
}

function SelectItem_0(){
  $clinit_SelectItem();
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SelectItem'):(this.jsObj['editorType'] = 'SelectItem' , undefined);
}

function SelectItem_1(name_0){
  $clinit_SelectItem();
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SelectItem'):(this.jsObj['editorType'] = 'SelectItem' , undefined);
}

function SelectItem_2(name_0, title){
  $clinit_SelectItem();
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SelectItem'):(this.jsObj['editorType'] = 'SelectItem' , undefined);
}

function init_3(){
  if ($wnd.isc.SelectItem.getPrototype().__getPickListFilterCriteria == null) {
    $wnd.isc.SelectItem.getPrototype().__getPickListFilterCriteria = $wnd.isc.SelectItem.getPrototype().getPickListFilterCriteria;
    $wnd.isc.SelectItem.getPrototype().getPickListFilterCriteria = $entry(function(){
      var jObj = this.__ref;
      if (jObj && instanceOf(jObj, Q$SelectItem)) {
        jObj.setJsObj(this);
        var critJ = jObj.getPickListFilterCriteria_0();
        return critJ == null?{}:critJ.getJsObj();
      }
       else {
        return this.__getPickListFilterCriteria();
      }
    }
    );
  }
}

defineSeed(528, 501, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SelectItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SelectItem_0, SelectItem_1, SelectItem_2);
_.getPickListFilterCriteria_0 = function getPickListFilterCriteria_0(){
  var self_0 = this.getJsObj();
  var critJS = self_0.__getPickListFilterCriteria();
  return critJS == null?null:new Criteria_1(critJS);
}
;
_.setValues = function setValues(values){
  $setValues(this, values);
}
;
function SliderItem_0(){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', 'exceptionItem'):(this.jsObj['name'] = 'exceptionItem' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', 'Exception Depth'):(this.jsObj['title'] = 'Exception Depth' , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SliderItem'):(this.jsObj['editorType'] = 'SliderItem' , undefined);
}

defineSeed(529, 503, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SliderItem_0);
function $setDefaultValue_2(this$static, defaultValue){
  setAttribute_8(this$static.jsObj, 'defaultValue', defaultValue);
}

function $setMax(this$static, max){
  setAttribute_8(this$static.jsObj, 'max', max);
}

function $setMin(this$static, min){
  setAttribute_8(this$static.jsObj, 'min', min);
}

function $setStep(this$static){
  $isCreated_2(this$static)?$setProperty_7(this$static, 'step', 1):(this$static.jsObj['step'] = 1 , undefined);
}

function SpinnerItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SpinnerItem'):(this.jsObj['editorType'] = 'SpinnerItem' , undefined);
}

function SpinnerItem_1(name_0, title){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'SpinnerItem'):(this.jsObj['editorType'] = 'SpinnerItem' , undefined);
}

defineSeed(530, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SpinnerItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SpinnerItem_0, SpinnerItem_1);
_.setDefaultValue = function setDefaultValue_2(defaultValue){
  $setDefaultValue_2(this, defaultValue);
}
;
defineSeed(531, 502, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getTitle = function getTitle_0(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'title'):getAttribute(this.jsObj, 'title');
}
;
function UploadItem_0(name_0, title){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_9(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_9(this, 'editorType', 'UploadItem'):(this.jsObj['editorType'] = 'UploadItem' , undefined);
}

defineSeed(532, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextItem, Q$UploadItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), UploadItem_0);
function $getItem(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_6(jsObj.item);
}

function BlurEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(533, 356, {}, BlurEvent_0);
_.dispatch = function dispatch_23(handler){
  dynamicCast(handler, Q$BlurHandler).onBlur(this);
}
;
_.getAssociatedType = function getAssociatedType_23(){
  return TYPE_23;
}
;
var TYPE_23 = null;
function $getValue_1(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function ChangeEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(534, 356, {}, ChangeEvent_0);
_.dispatch = function dispatch_24(handler){
  dynamicCast(handler, Q$ChangeHandler).onChange(this);
}
;
_.getAssociatedType = function getAssociatedType_24(){
  return TYPE_24;
}
;
_.isCancelled = function isCancelled_11(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_24 = null;
function $getItem_0(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_6(jsObj.item);
}

function $getValue_2(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function DataArrivedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(537, 356, {}, DataArrivedEvent_0);
_.dispatch = function dispatch_27(handler){
  $onDataArrived(dynamicCast(handler, Q$DataArrivedHandler));
}
;
_.getAssociatedType = function getAssociatedType_27(){
  return TYPE_27;
}
;
var TYPE_27 = null;
function $dispatch_5(handler){
  $handleFocusChange(handler.this$0, handler.val$valueItem, handler.val$unsetItem);
}

function FocusEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(538, 356, {}, FocusEvent_0);
_.dispatch = function dispatch_28(handler){
  $dispatch_5(dynamicCast(handler, Q$FocusHandler));
}
;
_.getAssociatedType = function getAssociatedType_28(){
  return TYPE_28;
}
;
var TYPE_28 = null;
function FormItemIconClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(539, 356, {}, FormItemIconClickEvent_0);
_.dispatch = function dispatch_29(handler){
  dynamicCast(handler, Q$FormItemClickHandler).onFormItemClick(this);
}
;
_.getAssociatedType = function getAssociatedType_29(){
  return TYPE_29;
}
;
var TYPE_29 = null;
function $getIcon_0(this$static){
  var jsObj = this$static.jsObj;
  return new FormItemIcon_1(jsObj.icon);
}

function IconClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(540, 356, {}, IconClickEvent_0);
_.dispatch = function dispatch_30(handler){
  dynamicCast(handler, Q$IconClickHandler).onIconClick(this);
}
;
_.getAssociatedType = function getAssociatedType_30(){
  return TYPE_30;
}
;
var TYPE_30 = null;
function ItemHoverEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(541, 356, {}, ItemHoverEvent_0);
_.dispatch = function dispatch_31(handler){
  $onItemHover(dynamicCast(handler, Q$ItemHoverHandler));
}
;
_.getAssociatedType = function getAssociatedType_31(){
  return TYPE_31;
}
;
var TYPE_31 = null;
function $setup(this$static, jsObj){
  var self_0 = this$static;
  jsObj.condition = function(item, validator, value, record){
    var ref;
    if ($wnd.isc.isA.FormItem(item)) {
      self_0.formItem = getFormItem(item);
    }
     else {
      if (item.__ref && (ref = getAttributeAsObject(item, '__ref') , ref != null && instanceOf(ref, Q$DataSourceField))) {
        self_0.dataSourceField = getOrCreateRef_0(item);
      }
       else {
        var dataSourceField = $wnd.isc.addProperties({}, item);
        dataSourceField.__ref && delete dataSourceField.__ref;
        self_0.dataSourceField = new DataSourceField_0(dataSourceField);
      }
    }
    validator && (self_0.validatorProperties = convertToMap(validator));
    record != null && (self_0.record_0 = getOrCreateRef_1(record));
    var valueJ = $wnd.SmartGWT.convertToJavaType(value);
    var ret = self_0.condition_1(valueJ);
    var jsValidatorDefinition = self_0.getJsObj();
    var resultingValue = self_0.resultingValue_0;
    resultingValue != null && validator && (validator.resultingValue = $wnd.SmartGWT.convertToPrimitiveType(resultingValue));
    if (validator && validator != jsValidatorDefinition && jsValidatorDefinition.errorMessage != null) {
      validator.errorMessage = jsValidatorDefinition.errorMessage;
      jsValidatorDefinition.errorMessage = null;
    }
    self_0.reset_0();
    return ret;
  }
  ;
}

function CustomValidator_0(){
  Validator_0.call(this);
  this.validatorProperties = new HashMap_0;
  this.jsObj['type'] = 'custom';
  $setup(this, this.jsObj);
}

defineSeed(544, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]));
_.reset_0 = function reset(){
  this.formItem = null;
  this.dataSourceField = null;
  this.record_0 = null;
  this.validatorProperties.clear_0();
  this.resultingValue_0 = null;
}
;
_.dataSourceField = null;
_.formItem = null;
_.record_0 = null;
_.resultingValue_0 = null;
function FloatRangeValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'floatRange';
}

defineSeed(546, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), FloatRangeValidator_0);
function IntegerRangeValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'integerRange';
}

defineSeed(547, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), IntegerRangeValidator_0);
function IsFloatValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'isFloat';
}

defineSeed(548, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), IsFloatValidator_0);
function IsIntegerValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'isInteger';
}

defineSeed(549, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), IsIntegerValidator_0);
function $setMax_0(this$static, max){
  setAttribute_8(this$static.jsObj, 'max', max);
}

function $setMin_0(this$static, min){
  setAttribute_8(this$static.jsObj, 'min', min);
}

function LengthRangeValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'lengthRange';
}

defineSeed(550, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), LengthRangeValidator_0);
function MatchesFieldValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'matchesField';
}

defineSeed(551, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), MatchesFieldValidator_0);
function RegExpValidator_1(expression){
  RegExpValidator_0.call(this);
  this.jsObj['expression'] = expression;
}

defineSeed(552, 545, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), RegExpValidator_1);
function $addCellClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_34 && (TYPE_34 = new GwtEvent$Type_0) , TYPE_34)) == 0 && $setupCellClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_34 && (TYPE_34 = new GwtEvent$Type_0) , TYPE_34));
}

function $addData_0(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var recordJS = record.getJsObj();
  self_0.addData(recordJS);
}

function $addFieldStateChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_38 && (TYPE_38 = new GwtEvent$Type_0) , TYPE_38)) == 0 && $setupFieldStateChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_38 && (TYPE_38 = new GwtEvent$Type_0) , TYPE_38));
}

function $addRecordCollapseHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_40 && (TYPE_40 = new GwtEvent$Type_0) , TYPE_40)) == 0 && $setupRecordCollapseEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_40 && (TYPE_40 = new GwtEvent$Type_0) , TYPE_40));
}

function $addRecordExpandHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_43 && (TYPE_43 = new GwtEvent$Type_0) , TYPE_43)) == 0 && $setupRecordExpandEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_43 && (TYPE_43 = new GwtEvent$Type_0) , TYPE_43));
}

function $addRowEditorExitHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_44 && (TYPE_44 = new GwtEvent$Type_0) , TYPE_44)) == 0 && $setupRowEditorExitEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_44 && (TYPE_44 = new GwtEvent$Type_0) , TYPE_44));
}

function $addSortChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_46 && (TYPE_46 = new GwtEvent$Type_0) , TYPE_46)) == 0 && $setupSortChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_46 && (TYPE_46 = new GwtEvent$Type_0) , TYPE_46));
}

function $anySelected(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.anySelected();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $deselectRecord(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var recordJS = record.getJsObj();
  self_0.deselectRecord(recordJS);
}

function $deselectRecords(this$static, records){
  var self_0 = this$static.getOrCreateJsObj();
  var recordsJS = convertToJavaScriptArray_0(records);
  self_0.deselectRecords(recordsJS);
}

function $expandRecord(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.expandRecord(record.getJsObj());
}

function $getCriteria_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getCriteria();
  if (ret == null || ret === undefined)
    return null;
  return new Criteria_1(ret);
}

function $getFieldName(this$static, colNum){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getFieldName(colNum);
}

function $getRecords(this$static){
  return getOrCreateRef_14($getAttributeAsJavaScriptObject_1(this$static, 'groupTree'))?convertToListGridRecordArray($getAttributeAsJavaScriptObject_1(this$static, 'originalData')):convertToListGridRecordArray($getAttributeAsJavaScriptObject_1(this$static, 'data'));
}

function $getViewState(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getViewState();
}

function $groupBy(this$static, fields){
  var self_0 = this$static.getOrCreateJsObj();
  fieldsJS = convertToJavaScriptArray_0(fields);
  self_0.groupBy(fieldsJS);
}

function $hasErrors_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasErrors();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $isSelected(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isSelected(record.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $removeSelectedData(this$static, callback, requestProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var requestPropertiesJS = requestProperties == null?null:requestProperties.getJsObj();
  self_0.removeSelectedData($entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ), requestPropertiesJS);
}

function $selectAllRecords(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.selectAllRecords();
}

function $selectRecords(this$static, records){
  var self_0 = this$static.getOrCreateJsObj();
  var recordsJS = convertToJavaScriptArray_0(records);
  self_0.selectRecords(recordsJS);
}

function $setAutoFetchData_0(this$static, autoFetchData){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'autoFetchData', autoFetchData);
}

function $setAutoFitFieldWidths(this$static, autoFitFieldWidths){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'autoFitFieldWidths', autoFitFieldWidths);
}

function $setAutoSaveEdits(this$static, autoSaveEdits){
  $isCreated_1(this$static)?!autoSaveEdits?$setNullProperty(this$static, 'autoSaveEdits'):$setProperty_5(this$static, 'autoSaveEdits', autoSaveEdits.value_0):setAttribute_5(this$static.config_0, 'autoSaveEdits', autoSaveEdits);
}

function $setCanCollapseGroup(this$static, canCollapseGroup){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'canCollapseGroup', canCollapseGroup);
}

function $setCanEdit_0(this$static, canEdit){
  $isCreated_1(this$static)?!canEdit?$setNullProperty(this$static, 'canEdit'):$setProperty_5(this$static, 'canEdit', canEdit.value_0):setAttribute_5(this$static.config_0, 'canEdit', canEdit);
}

function $setCanExpandMultipleRecords(this$static, canExpandMultipleRecords){
  $isCreated_1(this$static)?!canExpandMultipleRecords?$setNullProperty(this$static, 'canExpandMultipleRecords'):$setProperty_5(this$static, 'canExpandMultipleRecords', canExpandMultipleRecords.value_0):setAttribute_5(this$static.config_0, 'canExpandMultipleRecords', canExpandMultipleRecords);
}

function $setCanExpandRecords(this$static, canExpandRecords){
  $isCreated_1(this$static)?!canExpandRecords?$setNullProperty(this$static, 'canExpandRecords'):$setProperty_5(this$static, 'canExpandRecords', canExpandRecords.value_0):setAttribute_5(this$static.config_0, 'canExpandRecords', canExpandRecords);
}

function $setCanHover(this$static, canHover){
  $isCreated_1(this$static)?!canHover?$setNullProperty(this$static, 'canHover'):$setProperty_5(this$static, 'canHover', canHover.value_0):setAttribute_5(this$static.config_0, 'canHover', canHover);
}

function $setEditByCell(this$static, editByCell){
  $isCreated_1(this$static)?!editByCell?$setNullProperty(this$static, 'editByCell'):$setProperty_5(this$static, 'editByCell', editByCell.value_0):setAttribute_5(this$static.config_0, 'editByCell', editByCell);
}

function $setEditValue(this$static, rowNum, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setEditValue(rowNum, fieldName, value);
}

function $setEditValue_0(this$static, rowNum, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setEditValue(rowNum, fieldName, value);
}

function $setFields_1(this$static, fields){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'fields', convertToJavaScriptArray_0(fields)):(this$static.config_0['fields'] = convertToJavaScriptArray_0(fields) , undefined);
}

function $setFixedRecordHeights(this$static, fixedRecordHeights){
  $isCreated_1(this$static)?!fixedRecordHeights?$setNullProperty(this$static, 'fixedRecordHeights'):$setProperty_5(this$static, 'fixedRecordHeights', fixedRecordHeights.value_0):setAttribute_5(this$static.config_0, 'fixedRecordHeights', fixedRecordHeights);
}

function $setGroupStartOpen(this$static, group){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'groupStartOpen', group.value_0):(this$static.config_0['groupStartOpen'] = group.value_0 , undefined);
}

function $setHoverCustomizer(this$static, hoverCustomizer){
  var self_0;
  this$static.isCreated()?(self_0 = this$static.getJsObj()):(self_0 = this$static.getConfig());
  self_0.cellHoverHTML = $debox($entry(function(record, rowNum, colNum){
    var recordJ = getOrCreateRef_9(record);
    var valueJ = null;
    return hoverCustomizer.hoverHTML_0(valueJ, recordJ, rowNum, colNum);
  }
  ));
}

function $setLeaveScrollbarGap(this$static, leaveScrollbarGap){
  $isCreated_1(this$static)?!leaveScrollbarGap?$setNullProperty(this$static, 'leaveScrollbarGap'):$setProperty_5(this$static, 'leaveScrollbarGap', leaveScrollbarGap.value_0):setAttribute_5(this$static.config_0, 'leaveScrollbarGap', leaveScrollbarGap);
}

function $setLoadingDataMessage(this$static){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'loadingDataMessage', null):(this$static.config_0['loadingDataMessage'] = null , undefined);
}

function $setLoadingMessage(this$static, loadingMessage){
  $isCreated_1(this$static)?undefined:(this$static.config_0['loadingMessage'] = loadingMessage , undefined);
}

function $setRecords(this$static, records){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'data', convertToJavaScriptArray_0(records)):(this$static.config_0['data'] = convertToJavaScriptArray_0(records) , undefined);
}

function $setResizeFieldsInRealTime(this$static, resizeFieldsInRealTime){
  $isCreated_1(this$static)?!resizeFieldsInRealTime?$setNullProperty(this$static, 'resizeFieldsInRealTime'):$setProperty_5(this$static, 'resizeFieldsInRealTime', resizeFieldsInRealTime.value_0):setAttribute_5(this$static.config_0, 'resizeFieldsInRealTime', resizeFieldsInRealTime);
}

function $setShowAllRecords(this$static, showAllRecords){
  $isCreated_1(this$static)?!showAllRecords?$setNullProperty(this$static, 'showAllRecords'):$setProperty_5(this$static, 'showAllRecords', showAllRecords.value_0):setAttribute_5(this$static.config_0, 'showAllRecords', showAllRecords);
}

function $setShowEmptyMessage(this$static, showEmptyMessage){
  $isCreated_1(this$static)?!showEmptyMessage?$setNullProperty(this$static, 'showEmptyMessage'):$setProperty_5(this$static, 'showEmptyMessage', showEmptyMessage.value_0):setAttribute_5(this$static.config_0, 'showEmptyMessage', showEmptyMessage);
}

function $setShowGroupSummary(this$static, showGroupSummary){
  $isCreated_1(this$static)?!showGroupSummary?$setNullProperty(this$static, 'showGroupSummary'):$setProperty_5(this$static, 'showGroupSummary', showGroupSummary.value_0):setAttribute_5(this$static.config_0, 'showGroupSummary', showGroupSummary);
}

function $setShowGroupSummaryInHeader(this$static, showGroupSummaryInHeader){
  $isCreated_1(this$static)?!showGroupSummaryInHeader?$setNullProperty(this$static, 'showGroupSummaryInHeader'):$setProperty_5(this$static, 'showGroupSummaryInHeader', showGroupSummaryInHeader.value_0):setAttribute_5(this$static.config_0, 'showGroupSummaryInHeader', showGroupSummaryInHeader);
}

function $setShowHover(this$static, showHover){
  $isCreated_1(this$static)?!showHover?$setNullProperty(this$static, 'showHover'):$setProperty_5(this$static, 'showHover', showHover.value_0):setAttribute_5(this$static.config_0, 'showHover', showHover);
}

function $setShowRecordComponents(this$static, showRecordComponents){
  $isCreated_1(this$static)?!showRecordComponents?$setNullProperty(this$static, 'showRecordComponents'):$setProperty_5(this$static, 'showRecordComponents', showRecordComponents.value_0):setAttribute_5(this$static.config_0, 'showRecordComponents', showRecordComponents);
}

function $setShowRecordComponentsByCell(this$static, showRecordComponentsByCell){
  $isCreated_1(this$static)?!showRecordComponentsByCell?$setNullProperty(this$static, 'showRecordComponentsByCell'):$setProperty_5(this$static, 'showRecordComponentsByCell', showRecordComponentsByCell.value_0):setAttribute_5(this$static.config_0, 'showRecordComponentsByCell', showRecordComponentsByCell);
  showRecordComponentsByCell.value_0 && $setAttribute_24(this$static, 'recordComponentPosition', ($clinit_EmbeddedPosition() , WITHIN).value_0, true);
}

function $setShowRollOver_1(this$static, showRollOver){
  $isCreated_1(this$static)?!showRollOver?$setNullProperty(this$static, 'showRollOver'):$setProperty_5(this$static, 'showRollOver', showRollOver.value_0):setAttribute_5(this$static.config_0, 'showRollOver', showRollOver);
}

function $setSort(this$static, sortSpecifiers){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setSort(convertToJavaScriptArray_0(sortSpecifiers));
}

function $setSortDirection(this$static, sortDirection){
  !sortDirection?$isCreated_1(this$static)?$setNullProperty(this$static, 'sortDirection'):setAttribute_5(this$static.config_0, 'sortDirection', null):$setAttribute_22(this$static, 'sortDirection', ($clinit_Boolean() , sortDirection == ($clinit_SortDirection() , ASCENDING)?TRUE:FALSE), true);
}

function $setSortField(this$static){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'sortField', 'name'):(this$static.config_0['sortField'] = 'name' , undefined);
}

function $setUseAllDataSourceFields(this$static, useAllDataSourceFields){
  $isCreated_1(this$static)?!useAllDataSourceFields?$setNullProperty(this$static, 'useAllDataSourceFields'):$setProperty_5(this$static, 'useAllDataSourceFields', useAllDataSourceFields.value_0):setAttribute_5(this$static.config_0, 'useAllDataSourceFields', useAllDataSourceFields);
}

function $setViewState(this$static, viewState){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setViewState(viewState);
}

function $setWrapCells(this$static, wrapCells){
  $isCreated_1(this$static)?!wrapCells?$setNullProperty(this$static, 'wrapCells'):$setProperty_5(this$static, 'wrapCells', wrapCells.value_0):setAttribute_5(this$static.config_0, 'wrapCells', wrapCells);
}

function $setupCellClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({cellClick:$debox($entry(function(){
      var param = {record:arguments[0], rowNum:arguments[1], colNum:arguments[2]};
      var event_0 = new CellClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.cellClick = $debox($entry(function(){
      var param = {record:arguments[0], rowNum:arguments[1], colNum:arguments[2]};
      var event_0 = new CellClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupFieldStateChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({fieldStateChanged:$entry(function(){
      var param = {};
      var event_0 = new FieldStateChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.fieldStateChanged = $entry(function(){
      var param = {};
      var event_0 = new FieldStateChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupRecordCollapseEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onCollapseRecord:$debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordCollapseEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onCollapseRecord = $debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordCollapseEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRecordDropEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onRecordDrop:$debox($entry(function(){
      var param = {dropRecords:arguments[0], targetRecord:arguments[1], index:arguments[2], sourceWidget:arguments[3]};
      var event_0 = new RecordDropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onRecordDrop = $debox($entry(function(){
      var param = {dropRecords:arguments[0], targetRecord:arguments[1], index:arguments[2], sourceWidget:arguments[3]};
      var event_0 = new RecordDropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRecordExpandEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onExpandRecord:$debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordExpandEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onExpandRecord = $debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordExpandEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRowEditorExitEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({rowEditorExit:$debox($entry(function(){
      var param = {editCompletionEvent:arguments[0], record:arguments[1], newValues:arguments[2], rowNum:arguments[3]};
      var event_0 = new RowEditorExitEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.rowEditorExit = $debox($entry(function(){
      var param = {editCompletionEvent:arguments[0], record:arguments[1], newValues:arguments[2], rowNum:arguments[3]};
      var event_0 = new RowEditorExitEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupSortChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({sortChanged:$entry(function(){
      var param = {sortSpecifiers:arguments[0]};
      var event_0 = new SortEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.sortChanged = $entry(function(){
      var param = {sortSpecifiers:arguments[0]};
      var event_0 = new SortEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $showField(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.showField(fieldName);
}

function $sort(this$static, sortField, sortDirection){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.sort(sortField, sortDirection.getValue_0());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $updateData(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var recordJS = record.getJsObj();
  self_0.updateData(recordJS);
}

function $validateRow(this$static, rowNum){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.validateRow(rowNum);
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function ListGrid_1(jsObj){
  Canvas_2.call(this, jsObj);
}

function getOrCreateRef_7(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$ListGrid):new ListGrid_1(jsObj);
}

defineSeed(554, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers]), ListGrid_1);
_.addRecordDropHandler = function addRecordDropHandler(handler){
  $getHandlerCount_1(this, (!TYPE_42 && (TYPE_42 = new GwtEvent$Type_0) , TYPE_42)) == 0 && $setupRecordDropEvent(this);
  return $doAddHandler_0(this, handler, (!TYPE_42 && (TYPE_42 = new GwtEvent$Type_0) , TYPE_42));
}
;
_.getRecords = function getRecords(){
  return $getRecords(this);
}
;
_.getSelectedRecord_0 = function getSelectedRecord(){
  var self_0 = this.getOrCreateJsObj();
  var ret = self_0.getSelectedRecord();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef(ret);
  retVal == null && (retVal = new ListGridRecord_1(ret));
  return retVal;
}
;
_.setCanAcceptDroppedRecords = function setCanAcceptDroppedRecords(canAcceptDroppedRecords){
  $isCreated_1(this)?!canAcceptDroppedRecords?$setNullProperty(this, 'canAcceptDroppedRecords'):$setProperty_5(this, 'canAcceptDroppedRecords', canAcceptDroppedRecords.value_0):setAttribute_5(this.config_0, 'canAcceptDroppedRecords', canAcceptDroppedRecords);
}
;
_.setCanDragRecordsOut = function setCanDragRecordsOut(canDragRecordsOut){
  $isCreated_1(this)?!canDragRecordsOut?$setNullProperty(this, 'canDragRecordsOut'):$setProperty_5(this, 'canDragRecordsOut', canDragRecordsOut.value_0):setAttribute_5(this.config_0, 'canDragRecordsOut', canDragRecordsOut);
}
;
_.setCanReorderRecords = function setCanReorderRecords(canReorderRecords){
  $isCreated_1(this)?!canReorderRecords?$setNullProperty(this, 'canReorderRecords'):$setProperty_5(this, 'canReorderRecords', canReorderRecords.value_0):setAttribute_5(this.config_0, 'canReorderRecords', canReorderRecords);
}
;
_.setData = function setData(data){
  $isCreated_1(this)?$setProperty_3(this, 'data', convertToJavaScriptArray_0(data)):(this.config_0['data'] = convertToJavaScriptArray_0(data) , undefined);
}
;
function $addChangeHandler_0(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_35 && (TYPE_35 = new GwtEvent$Type_0) , TYPE_35)) == 0 && $setupChangeEvent_0(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_35 && (TYPE_35 = new GwtEvent$Type_0) , TYPE_35));
}

function $addChangedHandler_0(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_36 && (TYPE_36 = new GwtEvent$Type_0) , TYPE_36)) == 0 && $setupChangedEvent_0(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_36 && (TYPE_36 = new GwtEvent$Type_0) , TYPE_36));
}

function $addRecordClickHandler_0(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_39 && (TYPE_39 = new GwtEvent$Type_0) , TYPE_39)) == 0 && $setupRecordClickEvent_0(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_39 && (TYPE_39 = new GwtEvent$Type_0) , TYPE_39));
}

function $setEditorType(this$static, editorType){
  var editorConfig, fiEditorType;
  if (!$equals_6(editorType.___clazz$.typeName, Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit.typeName)) {
    fiEditorType = $isCreated_2(editorType)?$getPropertyAsString(editorType, 'editorType'):getAttribute(editorType.jsObj, 'editorType');
    fiEditorType == null && (fiEditorType = $isCreated_2(editorType)?$getPropertyAsString(editorType, 'type'):getAttribute(editorType.jsObj, 'type'));
    fiEditorType != null && (this$static.jsObj['editorType'] = fiEditorType , undefined);
  }
  editorConfig = $getConfig(editorType);
  this$static.jsObj['editorProperties'] = editorConfig;
}

function $setFilterEditorType(this$static, filterEditorType){
  var editorConfig, type;
  type = $isCreated_2(filterEditorType)?$getPropertyAsString(filterEditorType, 'editorType'):getAttribute(filterEditorType.jsObj, 'editorType');
  type == null && (type = $isCreated_2(filterEditorType)?$getPropertyAsString(filterEditorType, 'type'):getAttribute(filterEditorType.jsObj, 'type'));
  this$static.jsObj['filterEditorType'] = type;
  editorConfig = $getConfig(filterEditorType);
  this$static.jsObj['filterEditorProperties'] = editorConfig;
}

function $setGroupValueFunction(this$static, groupValueFunction){
  var self_0 = this$static.getJsObj();
  self_0.getGroupValue = $debox($entry(function(value, record, field, fieldName, grid){
    var valueJ = $wnd.SmartGWT.convertToJavaType(value);
    var recordJ = getOrCreateRef_9(record);
    var fieldJ = getOrCreateRef_8(field);
    var gridJ = getOrCreateRef_7(grid);
    var val = groupValueFunction.getGroupValue_0(valueJ, recordJ, fieldJ, fieldName, gridJ);
    return $wnd.SmartGWT.convertToPrimitiveType(val);
  }
  ));
}

function $setIconHeight_1(this$static, iconHeight){
  setAttribute_8(this$static.jsObj, 'iconHeight', iconHeight);
}

function $setIconWidth_1(this$static, iconWidth){
  setAttribute_8(this$static.jsObj, 'iconWidth', iconWidth);
}

function $setSummaryFunction(this$static, summaryFunction){
  var self_0 = this$static.getJsObj();
  summaryFunction == null?(self_0.summaryFunction = null):(self_0.summaryFunction = $debox($entry(function(records, field){
    var recordsJ = convertToRecordArray(records);
    var fieldJ = getOrCreateRef_8(field);
    var val = summaryFunction.getSummaryValue(recordsJ, fieldJ);
    if (val == null || $wnd.isc.isA.String(val) || $wnd.isc.isA.Number(val))
      return val;
    if (instanceOf(val, Q$Number))
      return val.doubleValue();
    if (instanceOf(val, Q$Date))
      return convertToJavaScriptDate(val);
    $wnd.isc.logWarn('Unrecognized type of value ' + val + ' returned by the summaryFunction');
  }
  )));
}

function $setValueIconHeight_0(this$static, valueIconHeight){
  setAttribute_8(this$static.jsObj, 'valueIconHeight', valueIconHeight);
}

function $setValueIconSize(this$static, valueIconSize){
  setAttribute_8(this$static.jsObj, 'valueIconSize', valueIconSize);
}

function $setValueIconWidth_0(this$static, valueIconWidth){
  setAttribute_8(this$static.jsObj, 'valueIconWidth', valueIconWidth);
}

function $setupChangeEvent_0(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.change = $debox($entry(function(){
    var param = {form:arguments[0], item:arguments[1], value:arguments[2], oldValue:arguments[3], sourceJSO:this};
    var event_0 = new ChangeEvent_2(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function $setupChangedEvent_0(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.changed = $entry(function(){
    var param = {form:arguments[0], item:arguments[1], value:arguments[2], sourceJSO:this};
    var event_0 = new ChangedEvent_2(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupRecordClickEvent_0(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.recordClick = $debox($entry(function(){
    var param = {viewer:arguments[0], record:arguments[1], recordNum:arguments[2], field:arguments[3], fieldNum:arguments[4], value:arguments[5], rawValue:arguments[6]};
    var event_0 = new RecordClickEvent_0(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function ListGridField_2(name_0, width){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  this.jsObj['width'] = width;
}

function ListGridField_4(name_0, title, width){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  this.jsObj['title'] = title;
  this.jsObj['width'] = width;
}

defineSeed(555, 330, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$ListGridField, Q$HasCellSavedHandlers, Q$HasChangeHandlers_0, Q$HasChangedHandlers_0, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers]), ListGridField_2, ListGridField_4);
function $setBackgroundComponent(this$static, backgroundComponent){
  $setAttribute_5(this$static, 'backgroundComponent', !backgroundComponent?null:$getOrCreateJsObj_0(backgroundComponent));
}

defineSeed(556, 344, makeCastMap([Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Record, Q$ListGridRecord]));
_.getEnabled = function getEnabled(){
  return $clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'enabled')?TRUE:FALSE;
}
;
_.setEnabled = function setEnabled(enabled){
  setAttribute_5(this.jsObj, 'enabled', enabled);
}
;
function $getRecord_0(this$static){
  var jsObj = this$static.jsObj;
  if (jsObj.record == null)
    return null;
  var retVal = getRef(jsObj.record);
  retVal == null && (retVal = new ListGridRecord_1(jsObj.record));
  return retVal;
}

defineSeed(558, 475, {});
function CellClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(557, 558, {}, CellClickEvent_0);
_.dispatch = function dispatch_34(handler){
  dynamicCast(handler, Q$CellClickHandler).onCellClick(this);
}
;
_.getAssociatedType = function getAssociatedType_34(){
  return TYPE_34;
}
;
_.isCancelled = function isCancelled_14(){
  return false;
}
;
var TYPE_34 = null;
function $dispatch_6(this$static, handler){
  var rowNum;
  rowNum = $getRowNum(this$static);
  $getValue_3(this$static) == null || toString__devirtual$($getValue_3(this$static)).length == 0?$setEditValue_0(handler.val$memberValuesGrid, rowNum, 'memberValuesEditor-unsetField', true):$setEditValue_0(handler.val$memberValuesGrid, rowNum, 'memberValuesEditor-unsetField', false);
}

function $getRowNum(this$static){
  var jsObj = this$static.jsObj;
  if (jsObj.item) {
    return jsObj.item.rowNum;
  }
   else {
    var listGrid = jsObj.sourceJSO;
    return listGrid.getEventRow();
  }
}

function $getValue_3(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function ChangeEvent_2(jsObj){
  this.jsObj = jsObj;
}

defineSeed(559, 356, {}, ChangeEvent_2);
_.dispatch = function dispatch_35(handler){
  $dispatch_6(this, dynamicCast(handler, Q$ChangeHandler_0));
}
;
_.getAssociatedType = function getAssociatedType_35(){
  return TYPE_35;
}
;
_.isCancelled = function isCancelled_15(){
  return false;
}
;
var TYPE_35 = null;
function $getRowNum_0(this$static){
  var jsObj = this$static.jsObj;
  if (jsObj.item) {
    return jsObj.item.rowNum;
  }
   else {
    var listGrid = jsObj.sourceJSO;
    return listGrid.getEventRow();
  }
}

function $getValue_4(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function ChangedEvent_2(jsObj){
  this.jsObj = jsObj;
}

defineSeed(560, 356, {}, ChangedEvent_2);
_.dispatch = function dispatch_36(handler){
  dynamicCast(handler, Q$ChangedHandler_0).onChanged_0(this);
}
;
_.getAssociatedType = function getAssociatedType_36(){
  return TYPE_36;
}
;
var TYPE_36 = null;
function FieldStateChangedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(562, 475, {}, FieldStateChangedEvent_0);
_.dispatch = function dispatch_38(handler){
  dynamicCast(handler, Q$FieldStateChangedHandler).onFieldStateChanged(this);
}
;
_.getAssociatedType = function getAssociatedType_38(){
  return TYPE_38;
}
;
var TYPE_38 = null;
function $getRecord_2(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_1(jsObj.record);
}

function RecordCollapseEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(564, 475, {}, RecordCollapseEvent_0);
_.dispatch = function dispatch_40(handler){
  dynamicCast(handler, Q$RecordCollapseHandler).onRecordCollapse(this);
}
;
_.getAssociatedType = function getAssociatedType_40(){
  return TYPE_40;
}
;
_.isCancelled = function isCancelled_17(){
  return false;
}
;
var TYPE_40 = null;
function RecordDropEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(566, 475, {}, RecordDropEvent_0);
_.dispatch = function dispatch_42(handler){
  dynamicCast(handler, Q$RecordDropHandler).onRecordDrop_0(this);
}
;
_.getAssociatedType = function getAssociatedType_42(){
  return TYPE_42;
}
;
_.isCancelled = function isCancelled_18(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_42 = null;
function $getRecord_3(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_1(jsObj.record);
}

function RecordExpandEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(567, 475, {}, RecordExpandEvent_0);
_.dispatch = function dispatch_43(handler){
  dynamicCast(handler, Q$RecordExpandHandler).onRecordExpand(this);
}
;
_.getAssociatedType = function getAssociatedType_43(){
  return TYPE_43;
}
;
_.isCancelled = function isCancelled_19(){
  return false;
}
;
var TYPE_43 = null;
function $dispatch_7(this$static, handler){
  var jsObj;
  $validateRow(handler.val$memberValuesGrid, (jsObj = this$static.jsObj , jsObj.rowNum));
  $hasErrors_0(handler.val$memberValuesGrid).value_0?$disable(handler.val$okButton):$enable(handler.val$okButton);
}

function RowEditorExitEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(568, 475, {}, RowEditorExitEvent_0);
_.dispatch = function dispatch_44(handler){
  $dispatch_7(this, dynamicCast(handler, Q$RowEditorExitHandler));
}
;
_.getAssociatedType = function getAssociatedType_44(){
  return TYPE_44;
}
;
_.isCancelled = function isCancelled_20(){
  return false;
}
;
var TYPE_44 = null;
function $getRecord_4(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_1(jsObj.record);
}

function $getState(this$static){
  var jsObj = this$static.jsObj;
  return jsObj.state;
}

function SortEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(570, 475, {}, SortEvent_0);
_.dispatch = function dispatch_46(handler){
  dynamicCast(handler, Q$SortChangedHandler).onSortChanged(this);
}
;
_.getAssociatedType = function getAssociatedType_46(){
  return TYPE_46;
}
;
var TYPE_46 = null;
function HLayout_1(membersMargin){
  $clinit_BaseWidget();
  Layout_0.call(this);
  $isCreated_1(this)?$setProperty_1(this, 'membersMargin', membersMargin):(this.config_0['membersMargin'] = membersMargin , undefined);
  this.scClassName = 'HLayout';
}

defineSeed(571, 460, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout]), HLayout_1);
function $addSection(this$static, section){
  var componentJS, container, config;
  componentJS = section.jsObj;
  $isCreated_1(this$static)?(container = this$static.getOrCreateJsObj() , container.addSection(componentJS) , undefined):(config = this$static.config_0 , !config.sections && (config.sections = createJavaScriptArray()) , config.sections.push(componentJS) , undefined);
  section.stack_0 = this$static;
}

function $collapseSection(this$static, index){
  var container = this$static.getOrCreateJsObj();
  container.collapseSection(index);
}

function $collapseSection_0(this$static, sectionID){
  var container = this$static.getOrCreateJsObj();
  container.collapseSection(sectionID);
}

function $expandSection(this$static, index){
  var container = this$static.getOrCreateJsObj();
  container.expandSection(index);
}

function $expandSection_0(this$static, sectionID){
  var container = this$static.getOrCreateJsObj();
  container.expandSection(sectionID);
}

function $getSection(this$static, sectionID){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getSectionConfig(sectionID);
  if (ret == null || ret === undefined)
    return null;
  var retVal = getOrCreateRef_10(ret);
  return retVal;
}

function $getSections(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.sections;
  if (ret == null || ret === undefined)
    return null;
  var sectionsArr = createJavaScriptArray();
  for (var i = 0; i < ret.length; i++) {
    var jsSectionHeader = ret[i];
    sectionsArr[i] = jsSectionHeader.getSectionConfig?jsSectionHeader.getSectionConfig():jsSectionHeader;
  }
  return this$static.convertToSectionArray(sectionsArr);
}

function $setCanResizeSections(this$static, canResizeSections){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'canResizeSections', canResizeSections);
}

function $setScrollSectionIntoView(this$static, scrollSectionIntoView){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'scrollSectionIntoView', scrollSectionIntoView);
}

function $setSectionTitle(this$static, sectionID, newTitle){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.setSectionTitle(sectionID, newTitle);
}

function $showSection(this$static, index){
  var container = this$static.getOrCreateJsObj();
  container.showSection(index);
}

function SectionStack_0(){
  $clinit_BaseWidget();
  VLayout_0.call(this);
  this.scClassName = 'SectionStack';
}

defineSeed(574, 459, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), SectionStack_0);
_.convertToSectionArray = function convertToSectionArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_layout_SectionStackSection_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SectionStackSection, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_layout_SectionStackSection_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SectionStackSection, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = getOrCreateRef_10(componentJS);
    objects[i] = obj_0;
  }
  return objects;
}
;
_.create_0 = function create_31(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.setOverflow = function setOverflow_1(overflow){
  $setAttribute_24(this, 'overflow', overflow.value_0, false);
}
;
_.setStyleName = function setStyleName_3(styleName){
  $isCreated_1(this)?undefined:(this.config_0['styleName'] = styleName , undefined);
}
;
function $addItemJS(this$static, componentJS){
  var jsObj = this$static.getJsObj();
  !jsObj.items && (jsObj.items = createJavaScriptArray());
  jsObj.items.push(componentJS);
}

function $setExpanded(this$static, expanded){
  !this$static.stack_0 || !$isDrawn(this$static.stack_0).value_0?setAttribute_5(this$static.jsObj, 'expanded', expanded):expanded.value_0?$expandSection_0(this$static.stack_0, getAttribute(this$static.jsObj, 'name')):$collapseSection_0(this$static.stack_0, getAttribute(this$static.jsObj, 'name'));
}

function $setItems(this$static, items){
  var item, item$index, item$max;
  for (item$index = 0 , item$max = items.length; item$index < item$max; ++item$index) {
    item = items[item$index];
    $addItemJS(this$static, $getOrCreateJsObj_0(item));
  }
}

function SectionStackSection_0(jsObj){
  RefDataClass_1.call(this, jsObj);
}

function SectionStackSection_1(title){
  RefDataClass_0.call(this);
  !this.stack_0 || !$isDrawn(this.stack_0).value_0?(this.jsObj['title'] = title , undefined):$setSectionTitle(this.stack_0, getAttribute(this.jsObj, 'name'), title);
  $setAttribute_13(this, 'ID', generateID('SectionStackSection'));
}

function getOrCreateRef_10(jsObj){
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = getRef(jsObj);
  if (obj_0) {
    obj_0.jsObj = jsObj;
    return dynamicCast(obj_0, Q$SectionStackSection);
  }
   else {
    return new SectionStackSection_0(jsObj);
  }
}

defineSeed(575, 335, makeCastMap([Q$DataClass, Q$JsObject, Q$RefDataClass, Q$SectionStackSection]), SectionStackSection_0, SectionStackSection_1);
_.stack_0 = null;
function VStack_0(){
  $clinit_BaseWidget();
  Layout_0.call(this);
  this.scClassName = 'VStack';
}

defineSeed(576, 460, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout]), VStack_0);
_.create_0 = function create_32(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
function $setShowMenuBelow(this$static, showMenuBelow){
  $isCreated_1(this$static)?!showMenuBelow?$setNullProperty(this$static, 'showMenuBelow'):$setProperty_5(this$static, 'showMenuBelow', showMenuBelow.value_0):setAttribute_5(this$static.config_0, 'showMenuBelow', showMenuBelow);
}

function IMenuButton_1(title, menu){
  $clinit_BaseWidget();
  StretchImgButton_0.call(this);
  $isCreated_1(this)?$setProperty_4(this, 'title', title):(this.config_0['title'] = title , undefined);
  $setAttribute_20(this, 'menu', !menu?null:$getOrCreateJsObj_0(menu), true);
  this.scClassName = 'IMenuButton';
}

defineSeed(577, 467, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$StretchImg, Q$StretchImgButton, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), IMenuButton_1);
function $addItemClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_47 && (TYPE_47 = new GwtEvent$Type_0) , TYPE_47)) == 0 && $setupItemClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_47 && (TYPE_47 = new GwtEvent$Type_0) , TYPE_47));
}

function $getItemNum(this$static, item){
  var self_0 = this$static.getOrCreateJsObj();
  var itemJS = item.getJsObj();
  return self_0.getItemNum(itemJS);
}

function $setupItemClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({itemClick:$debox($entry(function(){
      var param = {item:arguments[0], colNum:arguments[1]};
      var event_0 = new ItemClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.itemClick = $debox($entry(function(){
      var param = {item:arguments[0], colNum:arguments[1]};
      var event_0 = new ItemClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function Menu_1(jsObj){
  ListGrid_1.call(this, jsObj);
}

function getOrCreateRef_11(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$Menu):new Menu_1(jsObj);
}

defineSeed(578, 554, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers, Q$Menu]), Menu_1);
_.setData = function setData_0(data){
  $isCreated_1(this)?$setProperty_3(this, 'data', convertToJavaScriptArray_0(data)):(this.config_0['data'] = convertToJavaScriptArray_0(data) , undefined);
}
;
defineSeed(579, 556, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Record, Q$ListGridRecord, Q$MenuItem, Q$HasClickHandlers_1]));
_.getEnabled = function getEnabled_0(){
  return $clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'enabled')?TRUE:FALSE;
}
;
_.setEnabled = function setEnabled_0(enabled){
  setAttribute_5(this.jsObj, 'enabled', enabled);
}
;
function $dispatch_8(this$static, handler){
  $onItemClick(handler, this$static);
}

function $getItem_1(this$static){
  var jsObj = this$static.jsObj;
  var retVal = getOrCreateRef_12(jsObj.item);
  return retVal;
}

function ItemClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(581, 475, {}, ItemClickEvent_0);
_.dispatch = function dispatch_47(handler){
  $dispatch_8(this, dynamicCast(handler, Q$ItemClickHandler));
}
;
_.getAssociatedType = function getAssociatedType_47(){
  return TYPE_47;
}
;
_.isCancelled = function isCancelled_21(){
  return false;
}
;
var TYPE_47 = null;
function $getItem_2(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_12(jsObj.item);
}

function $addTabDeselectedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_50 && (TYPE_50 = new GwtEvent$Type_0) , TYPE_50)) == 0 && $setupTabDeselectedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_50 && (TYPE_50 = new GwtEvent$Type_0) , TYPE_50));
}

function $addTabSelectedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_51 && (TYPE_51 = new GwtEvent$Type_0) , TYPE_51)) == 0 && $setupTabSelectedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_51 && (TYPE_51 = new GwtEvent$Type_0) , TYPE_51));
}

function $setID_1(this$static, ID){
  isValidID(ID);
  this$static.jsObj['ID'] = ID;
}

function $setIcon_3(this$static, icon){
  !this$static.tabSet || !$isDrawn(this$static.tabSet).value_0?(this$static.jsObj['icon'] = icon , undefined):$setTabIcon(this$static.tabSet, getAttribute(this$static.jsObj, 'ID'), icon);
}

function $setPane(this$static, pane){
  !this$static.tabSet || !$isCreated_1(this$static.tabSet)?$setAttribute_5(this$static, 'pane', $getOrCreateJsObj_0(pane)):$updateTab(this$static.tabSet, this$static, pane);
}

function $setTitle_2(this$static, title){
  !this$static.tabSet || !$isDrawn(this$static.tabSet).value_0?(this$static.jsObj['title'] = title , undefined):$setTabTitle(this$static.tabSet, this$static, title);
}

function $setupTabDeselectedEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.tabDeselected = $debox($entry(function(){
    var param = {tabSet:arguments[0], tabNum:arguments[1], tabPane:arguments[2], ID:arguments[3], tab:arguments[4], newTab:arguments[5]};
    var event_0 = new TabDeselectedEvent_0(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function $setupTabSelectedEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.tabSelected = $entry(function(){
    var param = {tabSet:arguments[0], tabNum:arguments[1], tabPane:arguments[2], ID:arguments[3], tab:arguments[4]};
    var event_0 = new TabSelectedEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function Tab_0(jsObj){
  RefDataClass_1.call(this, jsObj);
}

function Tab_1(title){
  RefDataClass_0.call(this);
  !this.tabSet || !$isDrawn(this.tabSet).value_0?(this.jsObj['title'] = title , undefined):$setTabTitle(this.tabSet, this, title);
  $setID_1(this, generateID(this.___clazz$.typeName));
}

function Tab_2(title, icon){
  RefDataClass_0.call(this);
  !this.tabSet || !$isDrawn(this.tabSet).value_0?(this.jsObj['title'] = title , undefined):$setTabTitle(this.tabSet, this, title);
  !this.tabSet || !$isDrawn(this.tabSet).value_0?(this.jsObj['icon'] = icon , undefined):$setTabIcon(this.tabSet, getAttribute(this.jsObj, 'ID'), icon);
  $setID_1(this, generateID(this.___clazz$.typeName));
}

function getOrCreateRef_13(jsObj){
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = getRef(jsObj);
  if (obj_0) {
    obj_0.jsObj = jsObj;
    return dynamicCast(obj_0, Q$Tab);
  }
   else {
    return new Tab_0(jsObj);
  }
}

defineSeed(583, 335, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Tab, Q$HasTabDeselectedHandlers, Q$HasTabSelectedHandlers]), Tab_0, Tab_1, Tab_2);
_.getPane = function getPane(){
  return getOrCreateRef_3(getAttributeAsJavaScriptObject(this.jsObj, 'pane'));
}
;
_.getTabSet = function getTabSet(){
  return this.tabSet;
}
;
_.getTitle = function getTitle_1(){
  return !this.tabSet || !$isDrawn(this.tabSet).value_0?getAttribute(this.jsObj, 'title'):$getAttributeAsString($getTab(this.tabSet, getAttribute(this.jsObj, 'ID')), 'title');
}
;
_.tabSet = null;
function $addCloseClickHandler_0(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_49 && (TYPE_49 = new GwtEvent$Type_0) , TYPE_49)) == 0 && $setupCloseClickEvent_0(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_49 && (TYPE_49 = new GwtEvent$Type_0) , TYPE_49));
}

function $addTab(this$static, tab){
  var tabJS, container, config;
  tab.tabSet = this$static;
  tabJS = tab.jsObj;
  $isCreated_1(this$static)?(container = this$static.getOrCreateJsObj() , container.addTab(tabJS) , undefined):(config = this$static.config_0 , !config.tabs && (config.tabs = createJavaScriptArray()) , config.tabs.push(tabJS) , undefined);
}

function $addTab_0(this$static, tab, position){
  var tabJS, container, config;
  tabJS = tab.jsObj;
  $isCreated_1(this$static)?(container = this$static.getOrCreateJsObj() , container.addTab(tabJS, position) , undefined):(config = this$static.config_0 , !config.tabs && (config.tabs = createJavaScriptArray()) , config.tabs.splice(position, 0, tabJS) , undefined);
}

function $addTabSelectedHandler_0(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_51 && (TYPE_51 = new GwtEvent$Type_0) , TYPE_51)) == 0 && $setupTabSelectedEvent_0(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_51 && (TYPE_51 = new GwtEvent$Type_0) , TYPE_51));
}

function $getSelectedTab(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getSelectedTab();
  return ret == null?null:getRef(ret);
}

function $getTab(this$static, ID){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getTabObject(ID);
  return ret == null?null:getRef(ret);
}

function $getTabNumber(this$static, ID){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getTabNumber(ID);
}

function $removeTab(this$static, tab){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  self_0.removeTab(tabJS);
}

function $selectTab(this$static, tabIndex){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.selectTab(tabIndex);
}

function $selectTab_0(this$static, tab){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  self_0.selectTab(tabJS);
}

function $setDestroyPanes(this$static, destroyPanes){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'destroyPanes', destroyPanes);
}

function $setTabIcon(this$static, ID, iconURL){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setTabIcon(ID, iconURL);
}

function $setTabTitle(this$static, tab, title){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  self_0.setTabTitle(tabJS, title);
}

function $setTabs(this$static, tabs){
  var tab, tab$index, tab$max;
  for (tab$index = 0 , tab$max = tabs.length; tab$index < tab$max; ++tab$index) {
    tab = tabs[tab$index];
    $addTab(this$static, tab);
  }
}

function $setupCloseClickEvent_0(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onCloseClick:$debox($entry(function(){
      var liveTab = arguments[0];
      var tabObj = this.getTabObject(liveTab);
      var param = {tab:tabObj};
      var event_0 = new TabCloseClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onCloseClick = $debox($entry(function(){
      var liveTab = arguments[0];
      var tabObj = this.getTabObject(liveTab);
      var param = {tab:tabObj};
      var event_0 = new TabCloseClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupTabSelectedEvent_0(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({tabSelected:$entry(function(){
      var param = {tabNum:arguments[0], tabPane:arguments[1], ID:arguments[2], tab:arguments[3]};
      var event_0 = new TabSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.tabSelected = $entry(function(){
      var param = {tabNum:arguments[0], tabPane:arguments[1], ID:arguments[2], tab:arguments[3]};
      var event_0 = new TabSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $updateTab(this$static, tab, pane){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  var paneJS = pane == null?null:pane.getOrCreateJsObj();
  self_0.updateTab(tabJS, paneJS);
}

function TabSet_0(){
  $clinit_BaseWidget();
  Canvas_1.call(this);
  this.scClassName = 'TabSet';
}

function convertToTabArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_tab_Tab_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Tab, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_tab_Tab_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Tab, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = dynamicCast(getRef(componentJS), Q$Tab);
    setCheck(objects, i, obj_0);
  }
  return objects;
}

defineSeed(584, 455, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$HasTabDeselectedHandlers, Q$HasTabSelectedHandlers]), TabSet_0);
_.create_0 = function create_35(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
function $dispatch_9(this$static, handler){
  var dashboardView;
  this$static.cancel = true;
  dashboardView = dynamicCast($getTab_0(this$static).getPane(), Q$DashboardView);
  ask(($clinit_Enhanced() , '\u524A\u9664\u3057\u3066\u3082\u3088\u308D\u3057\u3044\u3067\u3059\u304B') + ' [' + dashboardView.storedDashboard.name_0 + ']?', new DashboardsView$6$1_0(handler, this$static, dashboardView));
}

function $getTab_0(this$static){
  var jsObj = this$static.jsObj;
  var retVal = getOrCreateRef_13(jsObj.tab);
  retVal == null && (retVal = new Tab_0(jsObj.tab));
  return retVal;
}

function TabCloseClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(585, 475, {}, TabCloseClickEvent_0);
_.dispatch = function dispatch_49(handler){
  $dispatch_9(this, dynamicCast(handler, Q$CloseClickHandler_0));
}
;
_.getAssociatedType = function getAssociatedType_49(){
  return TYPE_49;
}
;
_.isCancelled = function isCancelled_22(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_49 = null;
function $dispatch_10(this$static, handler){
  $validate_3(handler.this$0.generalProperties) || (this$static.cancel = true);
}

function TabDeselectedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(586, 475, {}, TabDeselectedEvent_0);
_.dispatch = function dispatch_50(handler){
  $dispatch_10(this, dynamicCast(handler, Q$TabDeselectedHandler));
}
;
_.getAssociatedType = function getAssociatedType_50(){
  return TYPE_50;
}
;
_.isCancelled = function isCancelled_23(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_50 = null;
function $getTabNum(this$static){
  var jsObj = this$static.jsObj;
  return jsObj.tabNum;
}

function TabSelectedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(587, 475, {}, TabSelectedEvent_0);
_.dispatch = function dispatch_51(handler){
  dynamicCast(handler, Q$TabSelectedHandler).onTabSelected(this);
}
;
_.getAssociatedType = function getAssociatedType_51(){
  return TYPE_51;
}
;
var TYPE_51 = null;
function $addFormItem(this$static, formItem){
  var dynamicForm;
  dynamicForm = new DynamicForm_0;
  $isCreated_1(dynamicForm)?$setProperty_1(dynamicForm, 'cellPadding', 3):(dynamicForm.config_0['cellPadding'] = 3 , undefined);
  $isCreated_1(dynamicForm)?$setProperty_1(dynamicForm, 'minWidth', 50):(dynamicForm.config_0['minWidth'] = 50 , undefined);
  $isCreated_1(dynamicForm)?$setProperty_1(dynamicForm, 'numCols', 1):(dynamicForm.config_0['numCols'] = 1 , undefined);
  dynamicForm.setFields(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [formItem]));
  applyWidth(dynamicForm.config_0, formItem.jsObj);
  $addMember(this$static, dynamicForm);
}

function $addSpacer(this$static, toolStripSpacer){
  var canvas;
  canvas = new Canvas_1;
  $isCreated_1(canvas)?$setProperty_1(canvas, 'width', 1):(canvas.config_0['width'] = 1 , undefined);
  $isCreated_1(canvas)?$setProperty_1(canvas, 'height', 1):(canvas.config_0['height'] = 1 , undefined);
  $isCreated_1(canvas)?$setProperty_4(canvas, 'border', 'none'):(canvas.config_0['border'] = 'none' , undefined);
  $setExtraSpace(canvas, toolStripSpacer.space);
  $addMember(this$static, canvas);
}

function applyWidth(formJS, itemJS){
  formJS.width = itemJS.width;
}

function ToolStripSpacer_0(space){
  this.space = space;
}

defineSeed(590, 1, {}, ToolStripSpacer_0);
_.space = 0;
function $add_5(this$static, node, parent_0){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.add(node.getJsObj(), parent_0.getJsObj());
  if (ret == null || ret === undefined || ret === false)
    return null;
  var retVal = getOrCreateRef_15(ret);
  return retVal;
}

function $find(this$static, fieldNameOrPath, value){
  var self_0 = this$static.getOrCreateJsObj();
  var nodeJS = self_0.find(fieldNameOrPath, value);
  return nodeJS == null?null:getOrCreateRef_15(nodeJS);
}

function $getAttributeAsJavaScriptObject_2(this$static){
  return $isCreated(this$static)?getAttributeAsJavaScriptObject($getJsObj(this$static), 'root'):$getAttributeAsJavaScriptObject(this$static, 'root');
}

function $getChildren(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = self_0.getChildren(node.getJsObj());
  return convertToTreeNodeArray(nodesJS);
}

function $getOpenList(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = self_0.getOpenList(node.getJsObj());
  return convertToTreeNodeArray(nodesJS);
}

function $getParent(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var parent_0 = self_0.getParent(node.getJsObj());
  if (parent_0 == null || parent_0 === undefined)
    return null;
  var parentJ = getOrCreateRef_15(parent_0);
  return parentJ;
}

function $getParents(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = self_0.getParents(node.getJsObj());
  return convertToTreeNodeArray(nodesJS);
}

function $getRoot(this$static){
  return getOrCreateRef_15($isCreated(this$static)?getAttributeAsJavaScriptObject($getJsObj(this$static), 'root'):$getAttributeAsJavaScriptObject(this$static, 'root'));
}

function $hasChildren(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasChildren(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $isLoaded(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isLoaded(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $isOpen(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isOpen(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $isRoot(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isRoot(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $linkNodes(this$static, nodes){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = convertToJavaScriptArray_0(nodes);
  self_0.linkNodes(nodesJS);
}

function $loadChildren(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.loadChildren(node.getJsObj());
}

function $openFolder(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.openFolder(node.getJsObj());
}

function $openFolders(this$static, nodeList){
  var self_0 = this$static.getOrCreateJsObj();
  var nodeListJS = convertToJavaScriptArray_0(nodeList);
  self_0.openFolders(nodeListJS);
}

function $reloadChildren(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.reloadChildren(node.getJsObj());
}

function $remove_7(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.remove(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function Tree_0(){
  BaseClass_0.call(this);
  this.scClassName = 'Tree';
}

function convertToTreeNodeArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = getOrCreateRef_15(componentJS);
    setCheck(objects, i, obj_0);
  }
  return objects;
}

function convertToTreeNodeRecordArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = dynamicCast(getRef(componentJS), Q$ListGridRecord);
    !obj_0 && (obj_0 = new TreeNode_1(componentJS));
    setCheck(objects, i, obj_0);
  }
  return objects;
}

defineSeed(591, 329, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$Tree]), Tree_0);
_.setProperty_0 = function setProperty_1(property, value){
  $isCreated(this)?($getJsObj(this)[property] = value , undefined):$setProperty(this, property, value);
}
;
function $addDataArrivedHandler_1(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_52 && (TYPE_52 = new GwtEvent$Type_0) , TYPE_52)) == 0 && $setupDataArrivedEvent_1(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_52 && (TYPE_52 = new GwtEvent$Type_0) , TYPE_52));
}

function $addNodeClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_53 && (TYPE_53 = new GwtEvent$Type_0) , TYPE_53)) == 0 && $setupNodeClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_53 && (TYPE_53 = new GwtEvent$Type_0) , TYPE_53));
}

function $addNodeContextClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_54 && (TYPE_54 = new GwtEvent$Type_0) , TYPE_54)) == 0 && $setupNodeContextClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_54 && (TYPE_54 = new GwtEvent$Type_0) , TYPE_54));
}

function $fetchData_4(this$static, criteria){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.fetchData(criteria == null?null:criteria.getJsObj());
}

function $fetchData_5(this$static, criteria, callback){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $getIcon_1(this$static, node, defaultState){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0._getIcon(node.getJsObj(), defaultState);
}

function $getRecords_0(this$static){
  var i, node, nodes, records, root, tree, dataJS;
  tree = getOrCreateRef_14($getAttributeAsJavaScriptObject_1(this$static, 'data'));
  if ($isCreated_1(this$static)) {
    root = getOrCreateRef_15($getAttributeAsJavaScriptObject_2(tree));
    if (!root) {
      return null;
    }
     else {
      nodes = $getOpenList(tree, getOrCreateRef_15($getAttributeAsJavaScriptObject_2(tree)));
      records = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, nodes.length, 0);
      for (i = 0; i < nodes.length; ++i) {
        node = nodes[i];
        setCheck(records, i, new ListGridRecord_1(node.jsObj));
      }
      return records;
    }
  }
   else {
    return dataJS = $isCreated(tree)?getAttributeAsJavaScriptObject($getJsObj(tree), 'data'):$getAttributeAsJavaScriptObject(tree, 'data') , convertToTreeNodeRecordArray(dataJS);
  }
}

function $getSelectedRecord_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getSelectedRecord();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getOrCreateRef_15(ret);
  return retVal;
}

function $onInit_TreeGrid(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0._getNodeTitle = self_0.getNodeTitle;
  self_0.getNodeTitle = $debox($entry(function(node, recordNum, field){
    var jObj = this.__ref;
    var nodeJ = getOrCreateRef_1(node);
    var fieldJ = getOrCreateRef_8(field);
    return jObj.getNodeTitle_0(nodeJ, recordNum, fieldJ);
  }
  ));
  self_0._getIcon = self_0.getIcon;
  self_0.getIcon = $debox($entry(function(node, defaultState){
    defaultState = !!defaultState;
    $wnd.isc.isA.Number(node) && (node = this.data.get(node));
    var jObj = this.__ref;
    var nodeJ = getOrCreateRef_1(node);
    return jObj.getIcon_0(nodeJ, defaultState);
  }
  ));
}

function $setAnimateFolders(this$static, animateFolders){
  $isCreated_1(this$static)?!animateFolders?$setNullProperty(this$static, 'animateFolders'):$setProperty_5(this$static, 'animateFolders', animateFolders.value_0):setAttribute_5(this$static.config_0, 'animateFolders', animateFolders);
}

function $setData_0(this$static, data){
  $setAttribute_20(this$static, 'data', !data?null:$getOrCreateJsObj(data), true);
}

function $setFields_2(this$static, fields){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'fields', convertToJavaScriptArray_0(fields)):(this$static.config_0['fields'] = convertToJavaScriptArray_0(fields) , undefined);
}

function $setFolderIcon(this$static){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'folderIcon', 'global/DiscoveryQueue_Platform_16.png'):(this$static.config_0['folderIcon'] = 'global/DiscoveryQueue_Platform_16.png' , undefined);
}

function $setLoadDataOnDemand(this$static, loadDataOnDemand){
  $isCreated_1(this$static)?!loadDataOnDemand?$setNullProperty(this$static, 'loadDataOnDemand'):$setProperty_5(this$static, 'loadDataOnDemand', loadDataOnDemand.value_0):setAttribute_5(this$static.config_0, 'loadDataOnDemand', loadDataOnDemand);
}

function $setNodeIcon(this$static, nodeIcon){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'nodeIcon', nodeIcon):(this$static.config_0['nodeIcon'] = nodeIcon , undefined);
}

function $setTreeFieldTitle(this$static){
  $isCreated_1(this$static)?undefined:(this$static.config_0['treeFieldTitle'] = 'Resource Name' , undefined);
}

function $setupDataArrivedEvent_1(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({dataArrived:$entry(function(){
      var param = {parentNode:arguments[0]};
      var event_0 = new DataArrivedEvent_4(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.dataArrived = $entry(function(){
      var param = {parentNode:arguments[0]};
      var event_0 = new DataArrivedEvent_4(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupNodeClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({nodeClick:$entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeClickEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.nodeClick = $entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeClickEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupNodeContextClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({nodeContextClick:$debox($entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeContextClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.nodeContextClick = $debox($entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeContextClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function TreeGrid_0(){
  $clinit_BaseWidget();
  ListGrid_0.call(this);
  $isCreated_1(this)?$setProperty_1(this, 'animateFolderSpeed', 3000):(this.config_0['animateFolderSpeed'] = 3000 , undefined);
  $setAlternateRecordStyles(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  this.scClassName = 'TreeGrid';
}

defineSeed(592, 554, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers, Q$TreeGrid]), TreeGrid_0);
_.addRecordDropHandler = function addRecordDropHandler_0(handler){
  throw new UnsupportedOperationException_1('This event inherited from ListGrid does not fire for a TreeGrid. Use TreeGrid.addFolgerDropHandler instead');
}
;
_.create_0 = function create_39(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.fetchData_0 = function fetchData_1(){
  var self_0 = this.getOrCreateJsObj();
  self_0.fetchData();
}
;
_.fetchData_1 = function fetchData_2(criteria){
  $fetchData_4(this, criteria);
}
;
_.getIcon_0 = function getIcon(node, defaultState){
  return $getIcon_1(this, node, defaultState);
}
;
_.getNodeTitle_0 = function getNodeTitle(node, recordNum, field){
  var self_0 = this.getOrCreateJsObj();
  var title = self_0._getNodeTitle(node.getJsObj(), recordNum, field.getJsObj());
  return title == null?'':title.toString();
}
;
_.getRecord_0 = function getRecord_0(recordNum){
  var self_0 = this.getOrCreateJsObj();
  var ret = self_0.getRecord(recordNum);
  if (ret == null || ret === undefined)
    return null;
  var retVal = getOrCreateRef_15(ret);
  return retVal;
}
;
_.getRecords = function getRecords_0(){
  return $getRecords_0(this);
}
;
_.getSelectedRecord_0 = function getSelectedRecord_0(){
  return $getSelectedRecord_0(this);
}
;
_.onInit = function onInit_6(){
  $onInit(this);
  $onInit_ListGrid(this);
  $onInit_TreeGrid(this);
}
;
_.setCanAcceptDroppedRecords = function setCanAcceptDroppedRecords_0(canAcceptDroppedRecords){
  $isCreated_1(this)?!canAcceptDroppedRecords?$setNullProperty(this, 'canAcceptDroppedRecords'):$setProperty_5(this, 'canAcceptDroppedRecords', canAcceptDroppedRecords.value_0):setAttribute_5(this.config_0, 'canAcceptDroppedRecords', canAcceptDroppedRecords);
}
;
_.setCanDragRecordsOut = function setCanDragRecordsOut_0(canDragRecordsOut){
  $isCreated_1(this)?!canDragRecordsOut?$setNullProperty(this, 'canDragRecordsOut'):$setProperty_5(this, 'canDragRecordsOut', canDragRecordsOut.value_0):setAttribute_5(this.config_0, 'canDragRecordsOut', canDragRecordsOut);
}
;
_.setCanReorderRecords = function setCanReorderRecords_0(canReorderRecords){
  $isCreated_1(this)?!canReorderRecords?$setNullProperty(this, 'canReorderRecords'):$setProperty_5(this, 'canReorderRecords', canReorderRecords.value_0):setAttribute_5(this.config_0, 'canReorderRecords', canReorderRecords);
}
;
_.willAcceptDrop_0 = function willAcceptDrop_1(){
  return $willAcceptDrop(this);
}
;
function TreeGridField_0(name_0){
  ListGridField_1.call(this, name_0);
}

function TreeGridField_1(name_0, title){
  ListGridField_3.call(this, name_0, title);
}

function TreeGridField_2(name_0, title, width){
  ListGridField_4.call(this, name_0, title, width);
}

defineSeed(593, 555, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$ListGridField, Q$HasCellSavedHandlers, Q$HasChangeHandlers_0, Q$HasChangedHandlers_0, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers, Q$TreeGridField]), TreeGridField_0, TreeGridField_1, TreeGridField_2);
function TreeNode_0(){
  ListGridRecord_0.call(this);
}

function TreeNode_2(name_0){
  ListGridRecord_0.call(this);
  this.setName(name_0);
}

defineSeed(594, 556, makeCastMap([Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Record, Q$ListGridRecord, Q$TreeNode]), TreeNode_0, TreeNode_2);
_.getEnabled = function getEnabled_1(){
  return $clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'enabled')?TRUE:FALSE;
}
;
_.setChildren = function setChildren(children){
  this.jsObj['children'] = convertToJavaScriptArray_0(children);
}
;
_.setEnabled = function setEnabled_1(enabled){
  setAttribute_5(this.jsObj, 'enabled', enabled);
}
;
_.setID = function setID_1(id){
  this.jsObj['id'] = id;
}
;
_.setName = function setName(name_0){
  this.jsObj['name'] = name_0;
}
;
_.setParentID = function setParentID(parentID){
  this.jsObj['parentId'] = parentID;
}
;
function $getParentNode(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_15(jsObj.parentNode);
}

function DataArrivedEvent_4(jsObj){
  this.jsObj = jsObj;
}

defineSeed(595, 475, {}, DataArrivedEvent_4);
_.dispatch = function dispatch_52(handler){
  dynamicCast(handler, Q$DataArrivedHandler_1).onDataArrived_0(this);
}
;
_.getAssociatedType = function getAssociatedType_52(){
  return TYPE_52;
}
;
var TYPE_52 = null;
function $dispatch_11(this$static, handler){
  $onNodeClick(handler, this$static);
}

function NodeClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(596, 475, {}, NodeClickEvent_0);
_.dispatch = function dispatch_53(handler){
  $dispatch_11(this, dynamicCast(handler, Q$NodeClickHandler));
}
;
_.getAssociatedType = function getAssociatedType_53(){
  return TYPE_53;
}
;
var TYPE_53 = null;
function $getNode(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_15(jsObj.node);
}

function NodeContextClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(597, 475, {}, NodeContextClickEvent_0);
_.dispatch = function dispatch_54(handler){
  dynamicCast(handler, Q$NodeContextClickHandler).onNodeContextClick(this);
}
;
_.getAssociatedType = function getAssociatedType_54(){
  return TYPE_54;
}
;
_.isCancelled = function isCancelled_24(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_54 = null;
defineSeed(607, 608, makeCastMap([Q$Serializable, Q$Byte, Q$Comparable, Q$Number]));
_.intValue = function intValue_0(){
  return this.value_0;
}
;
_.longValue = function longValue_0(){
  return fromInt(this.value_0);
}
;
defineSeed(614, 608, makeCastMap([Q$Serializable, Q$Comparable, Q$Double, Q$Number]));
_.intValue = function intValue_1(){
  return round_int(this.value_0);
}
;
_.longValue = function longValue_1(){
  return fromDouble(this.value_0);
}
;
defineSeed(615, 608, makeCastMap([Q$Serializable, Q$Comparable, Q$Float, Q$Number]));
_.intValue = function intValue_2(){
  return round_int(this.value_0);
}
;
_.longValue = function longValue_2(){
  return fromDouble(this.value_0);
}
;
function Integer_1(s){
  this.value_0 = __parseAndValidateInt(s);
}

defineSeed(618, 608, makeCastMap([Q$Serializable, Q$Comparable, Q$Integer, Q$Number]), Integer_1);
_.longValue = function longValue_3(){
  return fromInt(this.value_0);
}
;
defineSeed(620, 608, makeCastMap([Q$Serializable, Q$Comparable, Q$Long, Q$Number]));
_.intValue = function intValue_4(){
  return toInt(this.value_0);
}
;
_.longValue = function longValue_4(){
  return this.value_0;
}
;
function abs(x){
  return x <= 0?0 - x:x;
}

function max_0(x, y){
  return x > y?x:y;
}

function min_1(x, y){
  return x < y?x:y;
}

defineSeed(629, 608, makeCastMap([Q$Serializable, Q$Comparable, Q$Number, Q$Short]));
_.intValue = function intValue_5(){
  return this.value_0;
}
;
_.longValue = function longValue_5(){
  return fromInt(this.value_0);
}
;
function $replace_0(this$static, from, to){
  var regex;
  if (from < 256) {
    regex = toPowerOfTwoString(from);
    regex = '\\x' + '00'.substring(regex.length) + regex;
  }
   else {
    regex = String.fromCharCode(from);
  }
  return this$static.replace(RegExp(regex, 'g'), String.fromCharCode(to));
}

function $replace_1(this$static, from, to){
  var regex, replacement;
  regex = $replaceAll(from, '([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])', '\\\\$1');
  replacement = $replaceAll($replaceAll(to, '\\\\', '\\\\\\\\'), '\\$', '\\\\$');
  return $replaceAll(this$static, regex, replacement);
}

function $startsWith(this$static, prefix, toffset){
  return !(toffset < 0 || toffset >= this$static.length) && this$static.indexOf(prefix, toffset) == toffset;
}

function $delete(this$static, end){
  return $replace(this$static.impl, 0, end, '') , this$static;
}

function $replace_2(this$static, start, toInsert){
  $replace(this$static.impl, start, 9, toInsert);
  return this$static;
}

function $append_15(this$static, x){
  $appendNonNull(this$static.impl, valueOf_53(x));
  return this$static;
}

function $charAt_0(this$static, index){
  return $charAt(this$static.impl.string, index);
}

function $delete_0(this$static, start, end){
  return $replace(this$static.impl, start, end, '') , this$static;
}

function $deleteCharAt(this$static, start){
  return $replace(this$static.impl, start, start + 1, '') , this$static;
}

function $insert_0(this$static, index, x){
  return $replace(this$static.impl, index, index, x) , this$static;
}

function $replace_3(this$static, start, end, toInsert){
  $replace(this$static.impl, start, end, toInsert);
  return this$static;
}

function $setCharAt(this$static, index, x){
  $replace_3(this$static, index, index + 1, String.fromCharCode(x));
}

function $setLength_1(this$static, newLength){
  var oldLength;
  oldLength = this$static.impl.string.length;
  newLength < oldLength?($replace(this$static.impl, newLength, oldLength, '') , this$static):newLength > oldLength && $append_15(this$static, initDim(_3C_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, newLength - oldLength, 1));
}

function $substring_1(this$static, end){
  return $substring_0(this$static.impl.string, 0, end);
}

function Date_5(date){
  Date_3.call(this, date);
}

defineSeed(643, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), Date_5);
_.getHours_0 = function getHours_0(){
  throw new IllegalArgumentException_0;
}
;
_.getMinutes_0 = function getMinutes_0(){
  throw new IllegalArgumentException_0;
}
;
_.getSeconds_0 = function getSeconds_0(){
  throw new IllegalArgumentException_0;
}
;
_.setHours_0 = function setHours_2(i){
  throw new IllegalArgumentException_0;
}
;
_.setMinutes_0 = function setMinutes_2(i){
  throw new IllegalArgumentException_0;
}
;
_.setSeconds_0 = function setSeconds_2(i){
  throw new IllegalArgumentException_0;
}
;
_.toString$ = function toString_25(){
  return '' + (1900 + (this.jsdate.getFullYear() - 1900)) + '-' + padTwo(this.jsdate.getMonth() + 1) + '-' + padTwo(this.jsdate.getDate());
}
;
function Time_0(time){
  Date_3.call(this, time);
}

defineSeed(644, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), Time_0);
_.getDate_0 = function getDate_0(){
  throw new IllegalArgumentException_0;
}
;
_.getDay_0 = function getDay_0(){
  throw new IllegalArgumentException_0;
}
;
_.getMonth_0 = function getMonth_0(){
  throw new IllegalArgumentException_0;
}
;
_.getYear = function getYear_0(){
  throw new IllegalArgumentException_0;
}
;
_.setDate_0 = function setDate_0(i){
  throw new IllegalArgumentException_0;
}
;
_.toString$ = function toString_26(){
  return padTwo(this.jsdate.getHours()) + ':' + padTwo(this.jsdate.getMinutes()) + ':' + padTwo(this.jsdate.getSeconds());
}
;
function $compareTo_8(this$static, o){
  var sign;
  sign = signum(sub(fromDouble(this$static.jsdate.getTime()), fromDouble(o.jsdate.getTime())));
  return sign == 0?this$static.nanos - o.nanos:sign;
}

function $equals_7(this$static, ts){
  return eq(fromDouble(this$static.jsdate.getTime()), fromDouble(ts.jsdate.getTime())) && this$static.nanos == ts.nanos;
}

function $setNanos(this$static, n){
  if (n < 0 || n > 999999999) {
    throw new IllegalArgumentException_1('nanos out of range ' + n);
  }
  this$static.nanos = n;
  $setTime_0(this$static, add(mul(div(fromDouble(this$static.jsdate.getTime()), P3e8_longLit), P3e8_longLit), fromInt(~~(this$static.nanos / 1000000))));
}

function Timestamp_0(time){
  Date_3.call(this, time);
  this.nanos = toInt(mod(time, P3e8_longLit)) * 1000000;
}

function padNine(value){
  var asString, toReturn;
  toReturn = new StringBuffer_2('000000000');
  asString = '' + value;
  toReturn = $replace_2(toReturn, 9 - asString.length, asString);
  return toReturn.impl.string;
}

defineSeed(645, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Timestamp, Q$Date]), Timestamp_0);
_.compareTo = function compareTo_12(o){
  return instanceOf(o, Q$Timestamp)?$compareTo_8(this, dynamicCast(o, Q$Timestamp)):$compareTo_8(this, new Timestamp_0(o.getTime_0()));
}
;
_.equals$ = function equals_14(ts){
  return instanceOf(ts, Q$Timestamp) && $equals_7(this, dynamicCast(ts, Q$Timestamp));
}
;
_.getTime_0 = function getTime_0(){
  return fromDouble(this.jsdate.getTime());
}
;
_.hashCode$ = function hashCode_16(){
  return $hashCode(this);
}
;
_.setTime_0 = function setTime_0(time){
  $setTime(this.jsdate, toDouble(time));
  this.nanos = toInt(mod(time, P3e8_longLit)) * 1000000;
}
;
_.toString$ = function toString_27(){
  return '' + (1900 + (this.jsdate.getFullYear() - 1900)) + '-' + padTwo(1 + this.jsdate.getMonth()) + '-' + padTwo(this.jsdate.getDate()) + ' ' + padTwo(this.jsdate.getHours()) + ':' + padTwo(this.jsdate.getMinutes()) + ':' + padTwo(this.jsdate.getSeconds()) + '.' + padNine(this.nanos);
}
;
_.nanos = 0;
function $putAll(this$static, t){
  var e, iter;
  for (iter = t.entrySet().iterator(); iter.hasNext();) {
    e = dynamicCast(iter.next_0(), Q$Map$Entry);
    this$static.put(e.getKey_0(), e.getValue_1());
  }
}

function $values(this$static){
  var entrySet;
  entrySet = this$static.entrySet();
  return new AbstractMap$2_0(this$static, entrySet);
}

defineSeed(647, 1, makeCastMap([Q$Map]));
_.clear_0 = function clear_2(){
  this.entrySet().clear_0();
}
;
_.containsValue = function containsValue(value){
  var entry, iter, v;
  for (iter = this.entrySet().iterator(); iter.hasNext();) {
    entry = dynamicCast(iter.next_0(), Q$Map$Entry);
    v = entry.getValue_1();
    if (value == null?v == null:equals__devirtual$(value, v)) {
      return true;
    }
  }
  return false;
}
;
_.putAll = function putAll(t){
  $putAll(this, t);
}
;
_.remove_4 = function remove_7(key){
  var entry;
  entry = $implFindEntry(this, key, true);
  return !entry?null:entry.getValue_1();
}
;
_.values_0 = function values_46(){
  return $values(this);
}
;
function $containsHashValue(this$static, value){
  var hashCodeMap = this$static.hashCodeMap;
  for (var hashCode in hashCodeMap) {
    var hashCodeInt = parseInt(hashCode, 10);
    if (hashCode == hashCodeInt) {
      var array = hashCodeMap[hashCodeInt];
      for (var i = 0, c = array.length; i < c; ++i) {
        var entry = array[i];
        var entryValue = entry.getValue_1();
        if (this$static.equalsBridge(value, entryValue)) {
          return true;
        }
      }
    }
  }
  return false;
}

function $containsStringValue(this$static, value){
  var stringMap = this$static.stringMap;
  for (var key in stringMap) {
    if (key.charCodeAt(0) == 58) {
      var entryValue = stringMap[key];
      if (this$static.equalsBridge(value, entryValue)) {
        return true;
      }
    }
  }
  return false;
}

defineSeed(646, 647, makeCastMap([Q$Map]));
_.containsValue = function containsValue_0(value){
  if (this.nullSlotLive && this.equals(this.nullSlot, value)) {
    return true;
  }
   else if ($containsStringValue(this, value)) {
    return true;
  }
   else if ($containsHashValue(this, value)) {
    return true;
  }
  return false;
}
;
function $removeAll_0(this$static, c){
  var iter, o, size;
  size = this$static.map_0.size_1();
  if (size < c.val$entrySet.size_1()) {
    for (iter = $iterator($keySet(this$static.map_0)); iter.val$outerIter.hasNext();) {
      o = $next_1(iter);
      c.this$0.containsKey(o) && iter.val$outerIter.remove_3();
    }
  }
   else {
    for (iter = $iterator(c); iter.val$outerIter.hasNext();) {
      o = $next_1(iter);
      this$static.map_0.remove_4(o) != null;
    }
  }
  return size != this$static.map_0.size_1();
}

defineSeed(648, 649, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.clear_0 = function clear_4(){
  this.this$0.clear_0();
}
;
_.remove_1 = function remove_9(entry){
  var key;
  if ($contains(this, entry)) {
    key = dynamicCast(entry, Q$Map$Entry).getKey_0();
    this.this$0.remove_4(key);
    return true;
  }
  return false;
}
;
defineSeed(656, 294, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List]));
_.set_0 = function set_2(index, element){
  checkIndex(index, this.size_0);
  return this.wrapped.set_0(this.fromIndex + index, element);
}
;
function $iterator_0(this$static){
  var outerIter;
  outerIter = this$static.val$entrySet.iterator();
  return new AbstractMap$2$1_0(outerIter);
}

function AbstractMap$2_0(this$0, val$entrySet){
  this.this$0 = this$0;
  this.val$entrySet = val$entrySet;
}

defineSeed(659, 295, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection]), AbstractMap$2_0);
_.contains = function contains_3(value){
  return this.this$0.containsValue(value);
}
;
_.iterator = function iterator_6(){
  return $iterator_0(this);
}
;
_.size_1 = function size_6(){
  return this.val$entrySet.size_1();
}
;
_.this$0 = null;
_.val$entrySet = null;
function $next_2(this$static){
  var value;
  value = dynamicCast(this$static.val$outerIter.next_0(), Q$Map$Entry).getValue_1();
  return value;
}

function AbstractMap$2$1_0(val$outerIter){
  this.val$outerIter = val$outerIter;
}

defineSeed(660, 1, {}, AbstractMap$2$1_0);
_.hasNext = function hasNext_3(){
  return this.val$outerIter.hasNext();
}
;
_.next_0 = function next_4(){
  return $next_2(this);
}
;
_.remove_3 = function remove_14(){
  this.val$outerIter.remove_3();
}
;
_.val$outerIter = null;
defineSeed(661, 294, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$AbstractSequentialList, Q$Collection, Q$List]));
_.set_0 = function set_3(index, element){
  var $e0, iter, old;
  iter = $listIterator(this, index);
  try {
    old = $next_5(iter);
    $verifyCurrentElement(iter);
    iter.lastNode.value_0 = element;
    return old;
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$NoSuchElementException)) {
      throw new IndexOutOfBoundsException_1("Can't set element " + index);
    }
     else 
      throw $e0;
  }
}
;
function fill(a, toIndex){
  var i;
  for (i = 0; i < toIndex; ++i) {
    a[i] = 0;
  }
}

function insertionSort(array, low, high, comp){
  var i, j, t;
  for (i = low + 1; i < high; ++i) {
    for (j = i; j > low && comp.compare(array[j - 1], array[j]) > 0; --j) {
      t = array[j];
      setCheck(array, j, array[j - 1]);
      setCheck(array, j - 1, t);
    }
  }
}

function merge(src, srcLow, srcMid, srcHigh, dest, destLow, destHigh, comp){
  var topIdx;
  topIdx = srcMid;
  while (destLow < destHigh) {
    topIdx >= srcHigh || srcLow < srcMid && comp.compare(src[srcLow], src[topIdx]) <= 0?setCheck(dest, destLow++, src[srcLow++]):setCheck(dest, destLow++, src[topIdx++]);
  }
}

function mergeSort(x, fromIndex, toIndex, comp){
  var temp;
  temp = cloneSubrange(x, fromIndex, toIndex);
  mergeSort_0(temp, x, fromIndex, toIndex, -fromIndex, comp);
}

function mergeSort_0(temp, array, low, high, ofs, comp){
  var length_0, tempHigh, tempLow, tempMid;
  length_0 = high - low;
  if (length_0 < 7) {
    insertionSort(array, low, high, comp);
    return;
  }
  tempLow = low + ofs;
  tempHigh = high + ofs;
  tempMid = tempLow + (tempHigh - tempLow >> 1);
  mergeSort_0(array, temp, tempLow, tempMid, -ofs, comp);
  mergeSort_0(array, temp, tempMid, tempHigh, -ofs, comp);
  if (comp.compare(temp[tempMid - 1], temp[tempMid]) <= 0) {
    while (low < high) {
      setCheck(array, low++, temp[tempLow++]);
    }
    return;
  }
  merge(temp, tempLow, tempMid, tempHigh, array, low, high, comp);
}

function toString_30(a){
  var b, i;
  if (a == null) {
    return 'null';
  }
  b = new StringBuffer_2('[');
  for (i = 0; i < a.length; ++i) {
    i != 0 && (b.impl.string += ', ' , b);
    $append_2(b.impl, '' + a[i]);
  }
  b.impl.string += ']';
  return b.impl.string;
}

function toString_31(x){
  if (x == null) {
    return 'null';
  }
  return $toString_4(new Arrays$ArrayList_0(x));
}

defineSeed(663, 294, makeCastMap([Q$Serializable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List, Q$RandomAccess]));
_.set_0 = function set_4(index, value){
  var was;
  checkIndex(index, this.array.length);
  was = this.array[index];
  setCheck(this.array, index, value);
  return was;
}
;
function replaceContents(target, x){
  var i, size;
  size = target.size_1();
  for (i = 0; i < size; ++i) {
    target.set_0(i, x[i]);
  }
}

function sort_0(target){
  $clinit_Collections();
  var x;
  x = cloneSubrange(target.array, 0, target.size_0);
  mergeSort(x, 0, x.length, ($clinit_Comparators() , $clinit_Comparators() , NATURAL));
  replaceContents(target, x);
}

function sort_1(target, c){
  $clinit_Collections();
  var x;
  x = target.toArray();
  mergeSort(x, 0, x.length, c?c:($clinit_Comparators() , $clinit_Comparators() , NATURAL));
  replaceContents(target, x);
}

defineSeed(666, 647, makeCastMap([Q$Serializable, Q$Map]));
_.containsValue = function containsValue_1(value){
  return false;
}
;
_.values_0 = function values_47(){
  return $clinit_Collections() , EMPTY_LIST;
}
;
function $clinit_Comparators(){
  $clinit_Comparators = nullMethod;
  NATURAL = new Comparators$1_0;
}

var NATURAL;
function Comparators$1_0(){
}

defineSeed(671, 1, makeCastMap([Q$Comparator]), Comparators$1_0);
_.compare = function compare_0(o1, o2){
  return dynamicCast(o1, Q$Comparable).compareTo$(o2);
}
;
function $clear_4(this$static){
  $clear_0(this$static.keySet);
  this$static.values = initDim(_3Ljava_lang_Object_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Object, this$static.values.length, 0);
}

defineSeed(675, 647, makeCastMap([Q$Map]));
_.clear_0 = function clear_5(){
  $clear_4(this);
}
;
_.containsValue = function containsValue_2(value){
  var key, key$iterator;
  for (key$iterator = new EnumSet$EnumSetImpl$IteratorImpl_0(this.keySet); key$iterator.i < key$iterator.this$1.all.length;) {
    key = $next_3(key$iterator);
    if (equalsWithNullCheck(value, this.values[key.ordinal])) {
      return true;
    }
  }
  return false;
}
;
_.remove_4 = function remove_17(key){
  return $remove_9(this, key);
}
;
defineSeed(676, 649, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.clear_0 = function clear_6(){
  $clear_4(this.this$0);
}
;
_.remove_1 = function remove_18(entry){
  var key;
  if ($contains_0(this, entry)) {
    key = dynamicCast(entry, Q$Map$Entry).getKey_0();
    $remove_9(this.this$0, key);
    return true;
  }
  return false;
}
;
function allOf(elementType){
  var all, set;
  all = dynamicCast($getEnumConstants(elementType), Q$Enum_$1);
  set = dynamicCast(cloneSubrange(all, 0, all.length), Q$Enum_$1);
  return new EnumSet$EnumSetImpl_0(all, set, all.length);
}

function complementOf(other){
  var all, c, i, newSet, oldSet;
  all = other.all;
  oldSet = other.set;
  newSet = dynamicCast(createFrom(oldSet, oldSet.length), Q$Enum_$1);
  for (i = 0 , c = oldSet.length; i < c; ++i) {
    !oldSet[i] && setCheck(newSet, i, all[i]);
  }
  return new EnumSet$EnumSetImpl_0(all, newSet, all.length - other.size_0);
}

function of(first){
  var all, set;
  all = dynamicCast($getEnumConstants($getDeclaringClass(first)), Q$Enum_$1);
  set = dynamicCast(createFrom(all, all.length), Q$Enum_$1);
  setCheck(set, first.ordinal, first);
  return new EnumSet$EnumSetImpl_0(all, set, 1);
}

function of_0(first, rest){
  var all, e, e$index, e$max, ordinal, set, size;
  all = dynamicCast($getEnumConstants($getDeclaringClass(first)), Q$Enum_$1);
  set = dynamicCast(createFrom(all, all.length), Q$Enum_$1);
  setCheck(set, first.ordinal, first);
  size = 1;
  for (e$index = 0 , e$max = rest.length; e$index < e$max; ++e$index) {
    e = rest[e$index];
    ordinal = e.ordinal;
    if (!set[ordinal]) {
      setCheck(set, ordinal, e);
      ++size;
    }
  }
  return new EnumSet$EnumSetImpl_0(all, set, size);
}

defineSeed(680, 679, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$EnumSet, Q$Set]));
_.remove_1 = function remove_20(o){
  return $remove_10(this, o);
}
;
defineSeed(682, 1, {});
function HashMap_3(toBeCopied){
  $clearImpl(this);
  this.putAll(toBeCopied);
}

defineSeed(683, 646, makeCastMap([Q$Serializable, Q$Cloneable, Q$HashMap, Q$Map]), HashMap_3);
defineSeed(684, 649, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.clear_0 = function clear_7(){
  this.map_0.clear_0();
}
;
_.remove_1 = function remove_22(o){
  return $remove_11(this, o);
}
;
function LinkedHashMap_4(toBeCopied){
  $clearImpl(this);
  $$init_4(this);
  $putAll(this, toBeCopied);
}

defineSeed(686, 683, makeCastMap([Q$Serializable, Q$Cloneable, Q$HashMap, Q$Map]), LinkedHashMap_4);
_.containsValue = function containsValue_3(value){
  var node;
  node = this.head.next;
  while (node != this.head) {
    if (equalsWithNullCheck(node.value_0, value)) {
      return true;
    }
    node = node.next;
  }
  return false;
}
;
defineSeed(689, 649, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.clear_0 = function clear_9(){
  $clear_5(this.this$0);
}
;
defineSeed(692, 661, makeCastMap([Q$Serializable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$AbstractSequentialList, Q$Collection, Q$LinkedList, Q$List, Q$Queue]));
_.clear_0 = function clear_10(){
  $clear_6(this);
}
;
function MissingResourceException_0(s){
  RuntimeException_1.call(this, s);
}

defineSeed(695, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable, Q$MissingResourceException]), MissingResourceException_0);
defineSeed(698, 294, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List, Q$RandomAccess, Q$Vector]));
_.clear_0 = function clear_11(){
  $clear_2(this.arrayList);
}
;
_.set_0 = function set_5(index, elem){
  return $set(this.arrayList, index, elem);
}
;
_.subList = function subList_0(fromIndex, toIndex){
  return new AbstractList$SubList_0(this.arrayList, fromIndex, toIndex);
}
;
function $clear_7(this$static){
  this$static.root = null;
  this$static.size_0 = 0;
}

defineSeed(700, 647, makeCastMap([Q$Serializable, Q$Map]));
_.clear_0 = function clear_12(){
  $clear_7(this);
}
;
_.remove_4 = function remove_27(keyObj){
  return $remove_16(this, keyObj);
}
;
defineSeed(703, 649, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.clear_0 = function clear_13(){
  $clear_7(this.this$0);
}
;
_.remove_1 = function remove_29(o){
  var entry, state;
  if (!instanceOf(o, Q$Map$Entry)) {
    return false;
  }
  entry = dynamicCast(o, Q$Map$Entry);
  state = new TreeMap$State_0;
  state.matchValue = true;
  state.value_0 = entry.getValue_1();
  return $removeWithState(this.this$0, entry.getKey_0(), state);
}
;
function $remove_17(this$static, o){
  return $remove_16(this$static.map_0, o) != null;
}

defineSeed(711, 649, makeCastMap([Q$Serializable, Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.clear_0 = function clear_14(){
  $clear_7(this.map_0);
}
;
_.remove_1 = function remove_30(o){
  return $remove_17(this, o);
}
;
function $setCategory(this$static, category){
  this$static.category = category;
}

function $setComparator(this$static, comparator){
  this$static.comparator = comparator;
}

function $setMeasurementDefinition(this$static, measurementDefinition){
  this$static.measurementDefinition = measurementDefinition;
}

function $setName_1(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setOption(this$static, option){
  this$static.option = option;
}

function $setThreshold(this$static, threshold){
  this$static.threshold = threshold;
}

function $setTriggerId(this$static, triggerId){
  this$static.triggerId = triggerId;
}

function AlertCondition_1(cond){
  $$init_5(this);
  this.category = cond.category;
  this.measurementDefinition = cond.measurementDefinition;
  this.name_0 = cond.name_0;
  this.comparator = cond.comparator;
  this.threshold = cond.threshold;
  this.option = cond.option;
  this.triggerId = cond.triggerId;
}

defineSeed(734, 1, makeCastMap([Q$Serializable, Q$AlertCondition]), AlertCondition_1);
function $clinit_AlertConditionOperator(){
  $clinit_AlertConditionOperator = nullMethod;
  LESS_THAN_OR_EQUAL_TO = new AlertConditionOperator_0('LESS_THAN_OR_EQUAL_TO', 0);
  LESS_THAN = new AlertConditionOperator_0('LESS_THAN', 1);
  EQUALS = new AlertConditionOperator_0('EQUALS', 2);
  REGEX = new AlertConditionOperator_0('REGEX', 3);
  GREATER_THAN = new AlertConditionOperator_0('GREATER_THAN', 4);
  GREATER_THAN_OR_EQUAL_TO = new AlertConditionOperator_0('GREATER_THAN_OR_EQUAL_TO', 5);
  CHANGES = new AlertConditionOperator_0('CHANGES', 6);
  CHANGES_TO = new AlertConditionOperator_0('CHANGES_TO', 7);
  CHANGES_FROM = new AlertConditionOperator_0('CHANGES_FROM', 8);
  AVAIL_GOES_DOWN = new AlertConditionOperator_0('AVAIL_GOES_DOWN', 9);
  AVAIL_GOES_DISABLED = new AlertConditionOperator_0('AVAIL_GOES_DISABLED', 10);
  AVAIL_GOES_UNKNOWN = new AlertConditionOperator_0('AVAIL_GOES_UNKNOWN', 11);
  AVAIL_GOES_NOT_UP = new AlertConditionOperator_0('AVAIL_GOES_NOT_UP', 12);
  AVAIL_GOES_UP = new AlertConditionOperator_0('AVAIL_GOES_UP', 13);
  AVAIL_DURATION_DOWN = new AlertConditionOperator_0('AVAIL_DURATION_DOWN', 14);
  AVAIL_DURATION_NOT_UP = new AlertConditionOperator_0('AVAIL_DURATION_NOT_UP', 15);
  $VALUES_47 = initValues(_3Lorg_rhq_core_domain_alert_AlertConditionOperator_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$AlertConditionOperator, [LESS_THAN_OR_EQUAL_TO, LESS_THAN, EQUALS, REGEX, GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, CHANGES, CHANGES_TO, CHANGES_FROM, AVAIL_GOES_DOWN, AVAIL_GOES_DISABLED, AVAIL_GOES_UNKNOWN, AVAIL_GOES_NOT_UP, AVAIL_GOES_UP, AVAIL_DURATION_DOWN, AVAIL_DURATION_NOT_UP]);
}

function AlertConditionOperator_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_56(name_0){
  $clinit_AlertConditionOperator();
  return valueOf(($clinit_AlertConditionOperator$Map() , $MAP_47), name_0);
}

function values_50(){
  $clinit_AlertConditionOperator();
  return $VALUES_47;
}

defineSeed(740, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$AlertConditionOperator]), AlertConditionOperator_0);
var $VALUES_47, AVAIL_DURATION_DOWN, AVAIL_DURATION_NOT_UP, AVAIL_GOES_DISABLED, AVAIL_GOES_DOWN, AVAIL_GOES_NOT_UP, AVAIL_GOES_UNKNOWN, AVAIL_GOES_UP, CHANGES, CHANGES_FROM, CHANGES_TO, EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO, REGEX;
function $clinit_AlertConditionOperator$Map(){
  $clinit_AlertConditionOperator$Map = nullMethod;
  $MAP_47 = createValueOfMap(($clinit_AlertConditionOperator() , $VALUES_47));
}

var $MAP_47;
function $setPeriod(this$static, period){
  this$static.period = period;
}

function $setPeriodUnits(this$static, periodUnits){
  this$static.periodUnits = periodUnits;
}

function $setValue_11(this$static, value){
  this$static.value_0 = value;
}

function AlertDampening_1(category){
  $$init_6(this);
  this.category = category;
}

defineSeed(744, 1, makeCastMap([Q$Serializable, Q$AlertDampening]), AlertDampening_1);
function $removeAllConditions(this$static){
  var condition, condition$iterator;
  for (condition$iterator = this$static.conditions.iterator(); condition$iterator.hasNext();) {
    condition = dynamicCast(condition$iterator.next_0(), Q$AlertCondition);
    condition.alertDefinition = null;
  }
  this$static.conditions.clear_0();
}

function $setAlertDampening(this$static, alertDampening){
  this$static.alertDampening = alertDampening;
}

function $setAlertNotifications(this$static, alertNotifications){
  !alertNotifications && (alertNotifications = new ArrayList_0);
  this$static.alertNotifications = alertNotifications;
}

function $setConditionExpression(this$static, conditionExpression){
  this$static.conditionExpression = conditionExpression;
}

function $setConditions(this$static, conditions){
  var condition, condition$iterator;
  $removeAllConditions(this$static);
  if (conditions) {
    for (condition$iterator = $iterator($keySet(conditions.map_0)); condition$iterator.val$outerIter.hasNext();) {
      condition = dynamicCast($next_1(condition$iterator), Q$AlertCondition);
      this$static.conditions.add_0(condition);
      condition.alertDefinition = this$static;
    }
  }
}

function $setDescription(this$static, description){
  this$static.description = description;
}

function $setEnabled(this$static, enabled){
  this$static.enabled = enabled;
}

function $setGroup(this$static, group){
  this$static.group = group;
}

function $setGroupAlertDefinition(this$static, groupAlertDefinition){
  this$static.groupAlertDefinition = groupAlertDefinition;
}

function $setId(this$static, id){
  this$static.id = id;
}

function $setName_2(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setParentId(this$static, parentId){
  this$static.parentId = parentId;
}

function $setPriority(this$static, priority){
  this$static.priority = priority;
}

function $setReadOnly(this$static, readOnly){
  this$static.readOnly = readOnly;
}

function $setRecoveryId(this$static, actOnTriggerId){
  if (this$static.willRecover && actOnTriggerId.value_0 != 0) {
    throw new IllegalStateException_1('An alert definition can either be a recovery definition or a definition to-be-recovered, but not both.');
  }
  this$static.recoveryId = actOnTriggerId;
}

function $setResource(this$static, resource){
  var alertDefinitions;
  this$static.resource = resource;
  if (this$static.resource) {
    alertDefinitions = $getAlertDefinitions(this$static.resource);
    if (alertDefinitions.equals$(($clinit_Collections() , $clinit_Collections() , EMPTY_SET))) {
      alertDefinitions = new HashSet_1(1);
      alertDefinitions.add_0(this$static);
      $setAlertDefinitions(this$static.resource, alertDefinitions);
    }
     else {
      alertDefinitions.add_0(this$static);
    }
  }
}

function $setResourceType(this$static, resourceType){
  this$static.resourceType = resourceType;
}

function $setWillRecover(this$static, willRecover){
  if (willRecover && this$static.recoveryId.value_0 != 0) {
    throw new IllegalStateException_1('An alert definition can either be a recovery definition or a definition to-be-recovered, but not both.');
  }
  this$static.willRecover = willRecover;
}

function serialize_47(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function $setAlertDefinition(this$static, alertDefinition){
  if (!alertDefinition) {
    throw new IllegalArgumentException_1('alertDefinition must be non-null.');
  }
  this$static.alertDefinition = alertDefinition;
}

function $setConfiguration(this$static, configuration){
  if (!configuration) {
    throw new IllegalArgumentException_1('configuration must be non-null');
  }
  this$static.configuration = configuration;
}

function $setExtraConfiguration(this$static, extraConfiguration){
  this$static.extraConfiguration = extraConfiguration;
}

function AlertNotification_1(sender){
  this.senderName = sender;
}

defineSeed(767, 1, makeCastMap([Q$Serializable, Q$AlertNotification]), AlertNotification_1);
function $setFactive(this$static, factive){
  this$static.factive = factive;
}

function $setFsystem(this$static, fsystem){
  this$static.fsystem = fsystem;
}

function $setId_0(this$static, id){
  this$static.id = id;
}

function $setRoles(this$static, roles){
  this$static.roles = roles;
}

function $addPermission(this$static, permission){
  this$static.permissions.add_0(permission);
}

function $setDescription_0(this$static, description){
  this$static.description = description;
}

function $setId_1(this$static, id){
  this$static.id = id;
}

function $setName_4(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setResourceGroups(this$static, resourceGroups){
  var resourceGroup, resourceGroup$iterator;
  if (!resourceGroups) {
    this$static.resourceGroups = new HashSet_0;
  }
   else {
    this$static.resourceGroups = resourceGroups;
    for (resourceGroup$iterator = this$static.resourceGroups.iterator(); resourceGroup$iterator.hasNext();) {
      resourceGroup = dynamicCast(resourceGroup$iterator.next_0(), Q$ResourceGroup);
      (!resourceGroup.roles && (resourceGroup.roles = new HashSet_0) , resourceGroup.roles).add_0(this$static);
    }
  }
}

function $setSubjects(this$static, subjects){
  var subject, subject$iterator;
  if (!subjects) {
    this$static.subjects = new HashSet_0;
  }
   else {
    this$static.subjects = subjects;
    for (subject$iterator = $iterator($keySet(subjects.map_0)); subject$iterator.val$outerIter.hasNext();) {
      subject = dynamicCast($next_1(subject$iterator), Q$Subject);
      !subject.roles && (subject.roles = new HashSet_0);
      subject.roles.add_0(this$static);
    }
  }
}

function $setBundleVersion(this$static, bundleVersion){
  this$static.bundleVersion = bundleVersion;
}

function $setResourceDeployments(this$static, resourceDeployments){
  this$static.resourceDeployments = resourceDeployments;
}

function $setDeployDir(this$static, deployDir){
  this$static.deployDir = deployDir;
}

function $setDescription_1(this$static, description){
  this$static.description = description;
}

function $setDestinationBaseDirectoryName(this$static, destinationBaseDirectoryName){
  this$static.destinationBaseDirectoryName = destinationBaseDirectoryName;
}

function $setName_5(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setBundles(this$static, bundles){
  var bundle, bundle$iterator;
  for (bundle$iterator = (!this$static.bundles && (this$static.bundles = new HashSet_0) , this$static.bundles).iterator(); bundle$iterator.hasNext();) {
    bundle = dynamicCast(bundle$iterator.next_0(), Q$Bundle);
    (!bundle.bundleGroups && (bundle.bundleGroups = new HashSet_0) , bundle.bundleGroups).remove_1(this$static);
  }
  this$static.bundles.clear_0();
  if (bundles) {
    for (bundle$iterator = $iterator($keySet(bundles.map_0)); bundle$iterator.val$outerIter.hasNext();) {
      bundle = dynamicCast($next_1(bundle$iterator), Q$Bundle);
      (!this$static.bundles && (this$static.bundles = new HashSet_0) , this$static.bundles).add_0(bundle);
      (!bundle.bundleGroups && (bundle.bundleGroups = new HashSet_0) , bundle.bundleGroups).add_0(this$static);
    }
  }
}

function $setDescription_2(this$static, description){
  this$static.description = description;
}

function $setId_2(this$static, id){
  this$static.id = id;
}

function $setName_6(this$static, name_0){
  this$static.name_0 = name_0;
}

function BundleNotFoundException_1(message){
  RuntimeException_1.call(this, message);
}

defineSeed(801, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable, Q$BundleNotFoundException]), BundleNotFoundException_1);
function $setBundle(this$static, bundle){
  this$static.bundle = bundle;
}

function $getBundleDestinationBaseDirectories(this$static){
  var bdbd, description, list, listItem, listItem$iterator, map, name_0, propertyList, retVal, valueContext, valueName;
  if (!this$static.bundleConfiguration) {
    return null;
  }
  propertyList = $getList(this$static.bundleConfiguration, 'bundleDestBaseDirsList');
  if (!propertyList) {
    return null;
  }
  list = (!propertyList.list && (propertyList.list = new ArrayList_0) , propertyList.list);
  if (list.size_1() == 0) {
    return null;
  }
  retVal = new HashSet_1(list.size_1());
  for (listItem$iterator = list.iterator(); listItem$iterator.hasNext();) {
    listItem = dynamicCast(listItem$iterator.next_0(), Q$Property);
    map = dynamicCast(listItem, Q$PropertyMap);
    name_0 = $getSimpleValue_0(map, 'name', null);
    valueContext = $getSimpleValue_0(map, 'valueContext', null);
    valueName = $getSimpleValue_0(map, 'valueName', null);
    description = $getSimpleValue_0(map, 'description', null);
    bdbd = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory_0(name_0, valueContext, valueName, description);
    $add_7(retVal, bdbd);
  }
  return retVal;
}

function ResourceTypeBundleConfiguration_0(){
  this.bundleConfiguration = null;
}

defineSeed(821, 1, makeCastMap([Q$Serializable, Q$ResourceTypeBundleConfiguration]), ResourceTypeBundleConfiguration_0);
function ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory_0(name_0, valueContext, valueName, description){
  if (name_0 == null) {
    throw new NullPointerException_1('name == null');
  }
  this.name_0 = name_0;
  this.valueContext = ($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context() , dynamicCast(valueOf(($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map() , $MAP_59), valueContext), Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context));
  this.valueName = valueName;
  this.description = description;
}

defineSeed(822, 1, makeCastMap([Q$Serializable, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory]), ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory_0);
_.equals$ = function equals_39(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory);
  return $equals_6(this.name_0, other.name_0);
}
;
_.hashCode$ = function hashCode_39(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_61(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_13($append_13($append_13($append_13($append_12($append_13($append_13((builder.impl.string += 'BundleDestinationBaseDirectory [name=' , builder), this.name_0), ', valueContext='), this.valueContext), ', valueName='), this.valueName), ', description='), this.description), ']');
  return builder.impl.string;
}
;
_.description = null;
_.name_0 = null;
_.valueContext = null;
_.valueName = null;
function $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context(){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context = nullMethod;
  pluginConfiguration_0 = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('pluginConfiguration', 0);
  resourceConfiguration_0 = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('resourceConfiguration', 1);
  measurementTrait = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('measurementTrait', 2);
  fileSystem = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('fileSystem', 3);
  $VALUES_59 = initValues(_3Lorg_rhq_core_domain_bundle_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context, [pluginConfiguration_0, resourceConfiguration_0, measurementTrait, fileSystem]);
}

function ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_68(name_0){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context();
  return valueOf(($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map() , $MAP_59), name_0);
}

function values_62(){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context();
  return $VALUES_59;
}

defineSeed(823, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context]), ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0);
var $VALUES_59, fileSystem, measurementTrait, pluginConfiguration_0, resourceConfiguration_0;
function $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map(){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map = nullMethod;
  $MAP_59 = createValueOfMap(($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context() , $VALUES_59));
}

var $MAP_59;
function deserialize_130(streamReader, instance){
  setBundleConfiguration(instance, dynamicCast($readObject(streamReader), Q$Configuration));
}

function instantiate_127(streamReader){
  return new ResourceTypeBundleConfiguration_0;
}

function setBundleConfiguration(instance, value){
  instance.bundleConfiguration = value;
}

function BundleGroupAssignmentComposite_0(){
}

defineSeed(826, 1, makeCastMap([Q$Serializable, Q$BundleGroupAssignmentComposite]), BundleGroupAssignmentComposite_0);
_.toString$ = function toString_62(){
  return 'BundleGroupAssignmentComposite [subject=' + this.subject + ', bundle=' + this.bundle + ', bundleGroups=' + this.bundleGroupMap.keySet_0() + ', canBeUnassigned=' + this.canBeUnassigned + ']';
}
;
_.bundle = null;
_.bundleGroupMap = null;
_.canBeUnassigned = false;
_.subject = null;
function deserialize_131(streamReader, instance){
  setBundle_1(instance, dynamicCast($readObject(streamReader), Q$Bundle));
  setBundleGroupMap(instance, dynamicCast($readObject(streamReader), Q$Map));
  setCanBeUnassigned(instance, $readBoolean(streamReader));
  setSubject(instance, dynamicCast($readObject(streamReader), Q$Subject));
}

function instantiate_128(streamReader){
  return new BundleGroupAssignmentComposite_0;
}

function setBundle_1(instance, value){
  instance.bundle = value;
}

function setBundleGroupMap(instance, value){
  instance.bundleGroupMap = value;
}

function setCanBeUnassigned(instance, value){
  instance.canBeUnassigned = value;
}

function setSubject(instance, value){
  instance.subject = value;
}

function BundleWithLatestVersionComposite_0(){
}

defineSeed(828, 1, makeCastMap([Q$Serializable, Q$BundleWithLatestVersionComposite]), BundleWithLatestVersionComposite_0);
_.toString$ = function toString_63(){
  var builder;
  builder = new StringBuilder_0;
  $append_12((builder.impl.string += 'BundleWithLatestVersionComposite [bundleId=' , builder), this.bundleId);
  $append_13((builder.impl.string += ', bundleName=' , builder), this.bundleName);
  $append_13((builder.impl.string += ', bundleDescription=' , builder), this.bundleDescription);
  $append_13((builder.impl.string += ', latestVersion=' , builder), this.latestVersion);
  $append_12((builder.impl.string += ', versionsCount=' , builder), this.versionsCount);
  builder.impl.string += ']';
  return builder.impl.string;
}
;
_.bundleDescription = null;
_.bundleId = null;
_.bundleName = null;
_.latestVersion = null;
_.versionsCount = null;
function deserialize_132(streamReader, instance){
  setBundleDescription(instance, $getString(streamReader, $readInt(streamReader)));
  setBundleId(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setBundleName(instance, $getString(streamReader, $readInt(streamReader)));
  setLatestVersion(instance, $getString(streamReader, $readInt(streamReader)));
  setVersionsCount(instance, dynamicCast($readObject(streamReader), Q$Long));
}

function instantiate_129(streamReader){
  return new BundleWithLatestVersionComposite_0;
}

function setBundleDescription(instance, value){
  instance.bundleDescription = value;
}

function setBundleId(instance, value){
  instance.bundleId = value;
}

function setBundleName(instance, value){
  instance.bundleName = value;
}

function setLatestVersion(instance, value){
  instance.latestVersion = value;
}

function setVersionsCount(instance, value){
  instance.versionsCount = value;
}

function $setName_7(this$static, name_0){
  this$static.name_0 = name_0;
}

function AffinityGroup_1(name_0){
  $$init_7(this);
  this.name_0 = name_0;
}

defineSeed(830, 1, makeCastMap([Q$Serializable, Q$AffinityGroup]), AffinityGroup_1);
function $equals_16(this$static, obj_0){
  var other;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$FailoverList)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$FailoverList);
  if (this$static.agentId != other.agentId) {
    return false;
  }
  if (neq(this$static.ctime, other.ctime)) {
    return false;
  }
  return true;
}

function FailoverList_0(){
  this.serverList = new ArrayList_0;
}

defineSeed(832, 1, makeCastMap([Q$Serializable, Q$FailoverList]), FailoverList_0);
_.equals$ = function equals_41(obj_0){
  return $equals_16(this, obj_0);
}
;
_.hashCode$ = function hashCode_41(){
  var result;
  result = 31 + this.agentId;
  result = 31 * result + toInt(xor(this.ctime, shru(this.ctime, 32)));
  return result;
}
;
_.agentId = 0;
_.ctime = P0_longLit;
_.id = 0;
function FailoverListDetails_0(){
}

defineSeed(833, 1, makeCastMap([Q$Serializable, Q$FailoverListDetails]), FailoverListDetails_0);
_.equals$ = function equals_42(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$FailoverListDetails)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$FailoverListDetails);
  if (!this.failoverList) {
    if (other.failoverList) {
      return false;
    }
  }
   else if (!$equals_16(this.failoverList, other.failoverList)) {
    return false;
  }
  if (this.ordinal != other.ordinal) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_42(){
  var result;
  result = 31 + this.serverId;
  return result;
}
;
_.failoverList = null;
_.id = 0;
_.ordinal = 0;
_.server = null;
_.serverId = 0;
function deserialize_134(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_131(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_FailoverListDetails_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FailoverListDetails, size, 0);
}

function deserialize_135(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  instance.failoverList = dynamicCast($readObject(streamReader), Q$FailoverList);
  setId_18(instance, $readInt(streamReader));
  setOrdinal(instance, $readInt(streamReader));
  instance.server = dynamicCast($readObject(streamReader), Q$Server);
  setServerId(instance, $readInt(streamReader));
}

function instantiate_132(streamReader){
  return new FailoverListDetails_0;
}

function setId_18(instance, value){
  instance.id = value;
}

function setOrdinal(instance, value){
  instance.ordinal = value;
}

function setServerId(instance, value){
  instance.serverId = value;
}

function deserialize_136(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_133(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_FailoverList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FailoverList, size, 0);
}

function deserialize_137(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  dynamicCast($readObject(streamReader), Q$Agent);
  setAgentId(instance, $readInt(streamReader));
  setCtime_6(instance, $readLong(streamReader));
  setId_19(instance, $readInt(streamReader));
  dynamicCast($readObject(streamReader), Q$PartitionEvent);
  setServerList(instance, dynamicCast($readObject(streamReader), Q$List));
}

function instantiate_134(streamReader){
  return new FailoverList_0;
}

function setAgentId(instance, value){
  instance.agentId = value;
}

function setCtime_6(instance, value){
  instance.ctime = value;
}

function setId_19(instance, value){
  instance.id = value;
}

function setServerList(instance, value){
  instance.serverList = value;
}

function $equals_17(this$static, obj_0){
  var other;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$PartitionEvent)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$PartitionEvent);
  if (neq(this$static.ctime, other.ctime)) {
    return false;
  }
  if (this$static.subjectName == null) {
    if (other.subjectName != null) {
      return false;
    }
  }
   else if (!$equals_6(this$static.subjectName, other.subjectName)) {
    return false;
  }
  return true;
}

function $hashCode_6(this$static){
  var result;
  result = 31 + toInt(xor(this$static.ctime, shru(this$static.ctime, 32)));
  result = 31 * result + (this$static.subjectName == null?0:getHashCode_0(this$static.subjectName));
  return result;
}

function PartitionEvent_0(){
  this.partitionDetails = new ArrayList_0;
  this.serverLists = new ArrayList_0;
}

defineSeed(838, 1, makeCastMap([Q$Serializable, Q$PartitionEvent]), PartitionEvent_0);
_.equals$ = function equals_43(obj_0){
  return $equals_17(this, obj_0);
}
;
_.hashCode$ = function hashCode_43(){
  return $hashCode_6(this);
}
;
_.ctime = P0_longLit;
_.eventDetail = null;
_.eventType = null;
_.executionStatus = null;
_.id = 0;
_.subjectName = null;
function $clinit_PartitionEvent$ExecutionStatus(){
  $clinit_PartitionEvent$ExecutionStatus = nullMethod;
  AUDIT = new PartitionEvent$ExecutionStatus_0('AUDIT', 0);
  COMPLETED = new PartitionEvent$ExecutionStatus_0('COMPLETED', 1);
  IMMEDIATE = new PartitionEvent$ExecutionStatus_0('IMMEDIATE', 2);
  REQUESTED = new PartitionEvent$ExecutionStatus_0('REQUESTED', 3);
  $VALUES_60 = initValues(_3Lorg_rhq_core_domain_cloud_PartitionEvent$ExecutionStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEvent$ExecutionStatus_$1]), Q$PartitionEvent$ExecutionStatus, [AUDIT, COMPLETED, IMMEDIATE, REQUESTED]);
}

function PartitionEvent$ExecutionStatus_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_69(name_0){
  $clinit_PartitionEvent$ExecutionStatus();
  return valueOf(($clinit_PartitionEvent$ExecutionStatus$Map() , $MAP_60), name_0);
}

function values_63(){
  $clinit_PartitionEvent$ExecutionStatus();
  return $VALUES_60;
}

defineSeed(839, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PartitionEvent$ExecutionStatus]), PartitionEvent$ExecutionStatus_0);
var $VALUES_60, AUDIT, COMPLETED, IMMEDIATE, REQUESTED;
function $clinit_PartitionEvent$ExecutionStatus$Map(){
  $clinit_PartitionEvent$ExecutionStatus$Map = nullMethod;
  $MAP_60 = createValueOfMap(($clinit_PartitionEvent$ExecutionStatus() , $VALUES_60));
}

var $MAP_60;
function PartitionEventDetails_0(){
}

defineSeed(841, 1, makeCastMap([Q$Serializable, Q$PartitionEventDetails]), PartitionEventDetails_0);
_.equals$ = function equals_44(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$PartitionEventDetails)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$PartitionEventDetails);
  if (this.agentName == null) {
    if (other.agentName != null) {
      return false;
    }
  }
   else if (!$equals_6(this.agentName, other.agentName)) {
    return false;
  }
  if (this.serverName == null) {
    if (other.serverName != null) {
      return false;
    }
  }
   else if (!$equals_6(this.serverName, other.serverName)) {
    return false;
  }
  if (!this.partitionEvent) {
    if (other.partitionEvent) {
      return false;
    }
  }
   else if (!$equals_17(this.partitionEvent, other.partitionEvent)) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_44(){
  var result;
  result = 31 + (this.agentName == null?0:getHashCode_0(this.agentName));
  result = 31 * result + (!this.partitionEvent?0:$hashCode_6(this.partitionEvent));
  result = 31 * result + (this.serverName == null?0:getHashCode_0(this.serverName));
  return result;
}
;
_.agentName = null;
_.id = 0;
_.partitionEvent = null;
_.serverName = null;
function deserialize_138(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_135(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_PartitionEventDetails_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PartitionEventDetails, size, 0);
}

function deserialize_139(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  instance.agentName = $getString(streamReader, $readInt(streamReader));
  setId_20(instance, $readInt(streamReader));
  instance.partitionEvent = dynamicCast($readObject(streamReader), Q$PartitionEvent);
  instance.serverName = $getString(streamReader, $readInt(streamReader));
}

function instantiate_136(streamReader){
  return new PartitionEventDetails_0;
}

function setId_20(instance, value){
  instance.id = value;
}

function $clinit_PartitionEventType(){
  $clinit_PartitionEventType = nullMethod;
  AGENT_REGISTRATION = new PartitionEventType_0('AGENT_REGISTRATION', 0);
  AGENT_CONNECT = new PartitionEventType_0('AGENT_CONNECT', 1);
  AGENT_SHUTDOWN = new PartitionEventType_0('AGENT_SHUTDOWN', 2);
  AGENT_LEAVE = new PartitionEventType_0('AGENT_LEAVE', 3);
  SERVER_DELETION = new PartitionEventType_0('SERVER_DELETION', 4);
  SERVER_COMPUTE_POWER_CHANGE = new PartitionEventType_0('SERVER_COMPUTE_POWER_CHANGE', 5);
  OPERATION_MODE_CHANGE = new PartitionEventType_0('OPERATION_MODE_CHANGE', 6);
  AGENT_AFFINITY_GROUP_ASSIGN = new PartitionEventType_0('AGENT_AFFINITY_GROUP_ASSIGN', 7);
  AGENT_AFFINITY_GROUP_REMOVE = new PartitionEventType_0('AGENT_AFFINITY_GROUP_REMOVE', 8);
  SERVER_AFFINITY_GROUP_ASSIGN = new PartitionEventType_0('SERVER_AFFINITY_GROUP_ASSIGN', 9);
  SERVER_AFFINITY_GROUP_REMOVE = new PartitionEventType_0('SERVER_AFFINITY_GROUP_REMOVE', 10);
  AFFINITY_GROUP_CHANGE = new PartitionEventType_0('AFFINITY_GROUP_CHANGE', 11);
  AFFINITY_GROUP_DELETE = new PartitionEventType_0('AFFINITY_GROUP_DELETE', 12);
  ADMIN_INITIATED_PARTITION = new PartitionEventType_0('ADMIN_INITIATED_PARTITION', 13);
  SYSTEM_INITIATED_PARTITION = new PartitionEventType_0('SYSTEM_INITIATED_PARTITION', 14);
  $VALUES_61 = initValues(_3Lorg_rhq_core_domain_cloud_PartitionEventType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEventType_$1]), Q$PartitionEventType, [AGENT_REGISTRATION, AGENT_CONNECT, AGENT_SHUTDOWN, AGENT_LEAVE, SERVER_DELETION, SERVER_COMPUTE_POWER_CHANGE, OPERATION_MODE_CHANGE, AGENT_AFFINITY_GROUP_ASSIGN, AGENT_AFFINITY_GROUP_REMOVE, SERVER_AFFINITY_GROUP_ASSIGN, SERVER_AFFINITY_GROUP_REMOVE, AFFINITY_GROUP_CHANGE, AFFINITY_GROUP_DELETE, ADMIN_INITIATED_PARTITION, SYSTEM_INITIATED_PARTITION]);
}

function PartitionEventType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_70(name_0){
  $clinit_PartitionEventType();
  return valueOf(($clinit_PartitionEventType$Map() , $MAP_61), name_0);
}

function values_64(){
  $clinit_PartitionEventType();
  return $VALUES_61;
}

defineSeed(844, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PartitionEventType]), PartitionEventType_0);
var $VALUES_61, ADMIN_INITIATED_PARTITION, AFFINITY_GROUP_CHANGE, AFFINITY_GROUP_DELETE, AGENT_AFFINITY_GROUP_ASSIGN, AGENT_AFFINITY_GROUP_REMOVE, AGENT_CONNECT, AGENT_LEAVE, AGENT_REGISTRATION, AGENT_SHUTDOWN, OPERATION_MODE_CHANGE, SERVER_AFFINITY_GROUP_ASSIGN, SERVER_AFFINITY_GROUP_REMOVE, SERVER_COMPUTE_POWER_CHANGE, SERVER_DELETION, SYSTEM_INITIATED_PARTITION;
function $clinit_PartitionEventType$Map(){
  $clinit_PartitionEventType$Map = nullMethod;
  $MAP_61 = createValueOfMap(($clinit_PartitionEventType() , $VALUES_61));
}

var $MAP_61;
function serialize_79(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_140(streamReader, instance){
}

function instantiate_137(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PartitionEventType() , $clinit_PartitionEventType() , $VALUES_61);
  return values[ordinal];
}

function serialize_80(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function serialize_81(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_141(streamReader, instance){
}

function instantiate_138(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PartitionEvent$ExecutionStatus() , $clinit_PartitionEvent$ExecutionStatus() , $VALUES_60);
  return values[ordinal];
}

function serialize_82(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function deserialize_142(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setCtime_7(instance, $readLong(streamReader));
  setEventDetail(instance, $getString(streamReader, $readInt(streamReader)));
  setEventType_0(instance, dynamicCast($readObject(streamReader), Q$PartitionEventType));
  setExecutionStatus(instance, dynamicCast($readObject(streamReader), Q$PartitionEvent$ExecutionStatus));
  setId_21(instance, $readInt(streamReader));
  setPartitionDetails(instance, dynamicCast($readObject(streamReader), Q$List));
  setServerLists(instance, dynamicCast($readObject(streamReader), Q$List));
  instance.subjectName = $getString(streamReader, $readInt(streamReader));
}

function instantiate_139(streamReader){
  return new PartitionEvent_0;
}

function setCtime_7(instance, value){
  instance.ctime = value;
}

function setEventDetail(instance, value){
  instance.eventDetail = value;
}

function setEventType_0(instance, value){
  instance.eventType = value;
}

function setExecutionStatus(instance, value){
  instance.executionStatus = value;
}

function setId_21(instance, value){
  instance.id = value;
}

function setPartitionDetails(instance, value){
  instance.partitionDetails = value;
}

function setServerLists(instance, value){
  instance.serverLists = value;
}

function $setAddress(this$static, address){
  this$static.address = address;
}

function $setOperationMode(this$static, operationMode){
  this$static.operationMode = operationMode;
}

function $setPort(this$static, port){
  this$static.port = port;
}

function $setSecurePort(this$static, securePort){
  this$static.securePort = securePort;
}

function serialize_85(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function $setAutomaticDeployment(this$static, automaticDeployment){
  this$static.automaticDeployment = automaticDeployment;
}

function $setCqlPort(this$static, cqlPort){
  this$static.cqlPort = cqlPort;
}

function $setGossipPort(this$static, gossipPort){
  this$static.gossipPort = gossipPort;
}

function $setPasswordHash(this$static, passwordHash){
  this$static.passwordHash = passwordHash;
}

function $setUsername(this$static, username){
  this$static.username = username;
}

function StorageClusterSettings_0(){
}

defineSeed(858, 1, makeCastMap([Q$Serializable, Q$StorageClusterSettings]), StorageClusterSettings_0);
_.equals$ = function equals_46(o){
  var that;
  if (this === o)
    return true;
  if (o == null || Lorg_rhq_core_domain_cloud_StorageClusterSettings_2_classLit != getClass__devirtual$(o))
    return false;
  that = dynamicCast(o, Q$StorageClusterSettings);
  if (this.cqlPort != that.cqlPort)
    return false;
  if (this.gossipPort != that.gossipPort)
    return false;
  if (this.automaticDeployment != that.automaticDeployment)
    return false;
  if (this.username != that.username)
    return false;
  if (this.passwordHash != that.passwordHash)
    return false;
  return true;
}
;
_.hashCode$ = function hashCode_46(){
  var result;
  result = this.cqlPort;
  result = 29 * result + this.gossipPort;
  result = 29 * result + (this.automaticDeployment.value_0?1231:1237);
  result = 29 * result + (this.username == null?0:getHashCode_0(this.username));
  result = 29 * result + (this.passwordHash == null?0:getHashCode_0(this.passwordHash));
  return result;
}
;
_.toString$ = function toString_65(){
  return 'StorageClusterSettings[cqlPort=' + this.cqlPort + ', gossipPort=' + this.gossipPort + ', automaticDeployment=' + this.automaticDeployment + ', username (read-only)=' + this.username + ', passwordHash=********]';
}
;
_.automaticDeployment = null;
_.cqlPort = 0;
_.gossipPort = 0;
_.passwordHash = null;
_.username = null;
function deserialize_146(streamReader, instance){
  setAutomaticDeployment(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setCqlPort(instance, $readInt(streamReader));
  setGossipPort(instance, $readInt(streamReader));
  setPasswordHash(instance, $getString(streamReader, $readInt(streamReader)));
  setUsername(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_143(streamReader){
  return new StorageClusterSettings_0;
}

function serialize_87(streamWriter, instance){
  $writeObject(streamWriter, instance.automaticDeployment);
  $writeInt(streamWriter, instance.cqlPort);
  $writeInt(streamWriter, instance.gossipPort);
  $writeString(streamWriter, instance.passwordHash);
  $writeString(streamWriter, instance.username);
}

function setAutomaticDeployment(instance, value){
  instance.automaticDeployment = value;
}

function setCqlPort(instance, value){
  instance.cqlPort = value;
}

function setGossipPort(instance, value){
  instance.gossipPort = value;
}

function setPasswordHash(instance, value){
  instance.passwordHash = value;
}

function setUsername(instance, value){
  instance.username = value;
}

function $getStatus(this$static){
  if (this$static.operationMode == ($clinit_StorageNode$OperationMode() , INSTALLED_0)) {
    return $clinit_StorageNode$Status() , INSTALLED_1;
  }
  if (this$static.operationMode == ANNOUNCE || this$static.operationMode == BOOTSTRAP || this$static.operationMode == ADD_MAINTENANCE) {
    return this$static.errorMessage_0 == null && !this$static.failedOperation?($clinit_StorageNode$Status() , JOINING):($clinit_StorageNode$Status() , DOWN_1);
  }
  if (this$static.operationMode == DECOMMISSION || this$static.operationMode == UNANNOUNCE || this$static.operationMode == REMOVE_MAINTENANCE || this$static.operationMode == UNINSTALL) {
    return this$static.errorMessage_0 == null && !this$static.failedOperation?($clinit_StorageNode$Status() , LEAVING):($clinit_StorageNode$Status() , DOWN_1);
  }
  if (this$static.operationMode == NORMAL_2) {
    return $clinit_StorageNode$Status() , NORMAL_3;
  }
  return $clinit_StorageNode$Status() , DOWN_1;
}

function $setId_3(this$static, id){
  this$static.id = id;
}

function StorageNode_0(){
}

function StorageNode_1(storageNodeId){
  this.id = storageNodeId;
}

defineSeed(860, 1, makeCastMap([Q$Serializable, Q$StorageNode]), StorageNode_0, StorageNode_1);
_.equals$ = function equals_47(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$StorageNode)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$StorageNode);
  if (this.address == null) {
    if (other.address != null) {
      return false;
    }
  }
   else if (!$equals_6(this.address, other.address)) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_47(){
  var result;
  result = 31 + (this.address == null?0:getHashCode_0(this.address));
  return result;
}
;
_.toString$ = function toString_66(){
  return 'StorageNode[id=' + this.id + ', address=' + this.address + ', cqlPort=' + this.cqlPort + ', operationMode=' + this.operationMode + ', mtime=' + toString_8(this.mtime) + ']';
}
;
_.address = null;
_.cqlPort = 0;
_.ctime = P0_longLit;
_.errorMessage_0 = null;
_.failedOperation = null;
_.id = 0;
_.maintenancePending = false;
_.mtime = P0_longLit;
_.operationMode = null;
_.resource = null;
function $clinit_StorageNode$OperationMode(){
  $clinit_StorageNode$OperationMode = nullMethod;
  DECOMMISSION = new StorageNode$OperationMode_0('DECOMMISSION', 0);
  DOWN_0 = new StorageNode$OperationMode_0('DOWN', 1);
  INSTALLED_0 = new StorageNode$OperationMode_0('INSTALLED', 2);
  MAINTENANCE_0 = new StorageNode$OperationMode_0('MAINTENANCE', 3);
  NORMAL_2 = new StorageNode$OperationMode_0('NORMAL', 4);
  ANNOUNCE = new StorageNode$OperationMode_0('ANNOUNCE', 5);
  UNANNOUNCE = new StorageNode$OperationMode_0('UNANNOUNCE', 6);
  BOOTSTRAP = new StorageNode$OperationMode_0('BOOTSTRAP', 7);
  ADD_MAINTENANCE = new StorageNode$OperationMode_0('ADD_MAINTENANCE', 8);
  REMOVE_MAINTENANCE = new StorageNode$OperationMode_0('REMOVE_MAINTENANCE', 9);
  UNINSTALL = new StorageNode$OperationMode_0('UNINSTALL', 10);
  $VALUES_63 = initValues(_3Lorg_rhq_core_domain_cloud_StorageNode$OperationMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$StorageNode$OperationMode_$1]), Q$StorageNode$OperationMode, [DECOMMISSION, DOWN_0, INSTALLED_0, MAINTENANCE_0, NORMAL_2, ANNOUNCE, UNANNOUNCE, BOOTSTRAP, ADD_MAINTENANCE, REMOVE_MAINTENANCE, UNINSTALL]);
}

function StorageNode$OperationMode_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_72(name_0){
  $clinit_StorageNode$OperationMode();
  return valueOf(($clinit_StorageNode$OperationMode$Map() , $MAP_63), name_0);
}

function values_66(){
  $clinit_StorageNode$OperationMode();
  return $VALUES_63;
}

defineSeed(861, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$StorageNode$OperationMode]), StorageNode$OperationMode_0);
var $VALUES_63, ADD_MAINTENANCE, ANNOUNCE, BOOTSTRAP, DECOMMISSION, DOWN_0, INSTALLED_0, MAINTENANCE_0, NORMAL_2, REMOVE_MAINTENANCE, UNANNOUNCE, UNINSTALL;
function $clinit_StorageNode$OperationMode$Map(){
  $clinit_StorageNode$OperationMode$Map = nullMethod;
  $MAP_63 = createValueOfMap(($clinit_StorageNode$OperationMode() , $VALUES_63));
}

var $MAP_63;
function $clinit_StorageNode$Status(){
  $clinit_StorageNode$Status = nullMethod;
  INSTALLED_1 = new StorageNode$Status_0('INSTALLED', 0);
  DOWN_1 = new StorageNode$Status_0('DOWN', 1);
  NORMAL_3 = new StorageNode$Status_0('NORMAL', 2);
  JOINING = new StorageNode$Status_0('JOINING', 3);
  LEAVING = new StorageNode$Status_0('LEAVING', 4);
  $VALUES_64 = initValues(_3Lorg_rhq_core_domain_cloud_StorageNode$Status_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$StorageNode$Status, [INSTALLED_1, DOWN_1, NORMAL_3, JOINING, LEAVING]);
}

function StorageNode$Status_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_73(name_0){
  $clinit_StorageNode$Status();
  return valueOf(($clinit_StorageNode$Status$Map() , $MAP_64), name_0);
}

function values_67(){
  $clinit_StorageNode$Status();
  return $VALUES_64;
}

defineSeed(863, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$StorageNode$Status]), StorageNode$Status_0);
var $VALUES_64, DOWN_1, INSTALLED_1, JOINING, LEAVING, NORMAL_3;
function $clinit_StorageNode$Status$Map(){
  $clinit_StorageNode$Status$Map = nullMethod;
  $MAP_64 = createValueOfMap(($clinit_StorageNode$Status() , $VALUES_64));
}

var $MAP_64;
function $equals_18(this$static, obj_0){
  var other;
  if (this$static === obj_0)
    return true;
  if (obj_0 == null)
    return false;
  if (Lorg_rhq_core_domain_cloud_StorageNodeConfigurationComposite_2_classLit != getClass__devirtual$(obj_0))
    return false;
  other = dynamicCast(obj_0, Q$StorageNodeConfigurationComposite);
  if (this$static.heapNewSize == null) {
    if (other.heapNewSize != null)
      return false;
  }
   else if (!$equals_6(this$static.heapNewSize, other.heapNewSize))
    return false;
  if (this$static.heapSize == null) {
    if (other.heapSize != null)
      return false;
  }
   else if (!$equals_6(this$static.heapSize, other.heapSize))
    return false;
  if (this$static.jmxPort != other.jmxPort)
    return false;
  if (this$static.threadStackSize == null) {
    if (other.threadStackSize != null)
      return false;
  }
   else if (!$equals_6(this$static.threadStackSize, other.threadStackSize))
    return false;
  return true;
}

function $setHeapNewSize(this$static, heapNewSize){
  this$static.heapNewSize = heapNewSize;
}

function $setHeapSize(this$static, heapSize){
  this$static.heapSize = heapSize;
}

function $setJmxPort(this$static, jmxPort){
  this$static.jmxPort = jmxPort;
}

function $setThreadStackSize(this$static, threadStackSize){
  this$static.threadStackSize = threadStackSize;
}

function StorageNodeConfigurationComposite_0(){
}

function StorageNodeConfigurationComposite_1(storageNode){
  this.storageNode = storageNode;
}

defineSeed(865, 1, makeCastMap([Q$Serializable, Q$StorageNodeConfigurationComposite]), StorageNodeConfigurationComposite_0, StorageNodeConfigurationComposite_1);
_.equals$ = function equals_48(obj_0){
  return $equals_18(this, obj_0);
}
;
_.hashCode$ = function hashCode_48(){
  var result;
  result = 31 + (this.heapNewSize == null?0:getHashCode_0(this.heapNewSize));
  result = 31 * result + (this.heapSize == null?0:getHashCode_0(this.heapSize));
  result = 31 * result + this.jmxPort;
  result = 31 * result + (this.threadStackSize == null?0:getHashCode_0(this.threadStackSize));
  return result;
}
;
_.toString$ = function toString_67(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_13((builder.impl.string += 'storageNode.addresss=' , builder), !this.storageNode?'unknown':this.storageNode.address), ', ');
  $append_13($append_10((builder.impl.string += 'jmxPort=' , builder), this.jmxPort), ',');
  $append_13($append_13((builder.impl.string += 'heapSize=' , builder), this.heapSize), ', ');
  $append_13($append_13((builder.impl.string += 'heapNewSize=' , builder), this.heapSize), ', ');
  $append_13($append_13((builder.impl.string += 'threadStackSize=' , builder), this.threadStackSize), '');
  return builder.impl.string;
}
;
_.heapNewSize = null;
_.heapSize = null;
_.jmxPort = 0;
_.storageNode = null;
_.threadStackSize = null;
function deserialize_147(streamReader, instance){
  setHeapNewSize(instance, $getString(streamReader, $readInt(streamReader)));
  setHeapSize(instance, $getString(streamReader, $readInt(streamReader)));
  setJmxPort(instance, $readInt(streamReader));
  setStorageNode(instance, dynamicCast($readObject(streamReader), Q$StorageNode));
  setThreadStackSize(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_144(streamReader){
  return new StorageNodeConfigurationComposite_0;
}

function serialize_88(streamWriter, instance){
  $writeString(streamWriter, instance.heapNewSize);
  $writeString(streamWriter, instance.heapSize);
  $writeInt(streamWriter, instance.jmxPort);
  $writeObject(streamWriter, instance.storageNode);
  $writeString(streamWriter, instance.threadStackSize);
}

function setHeapNewSize(instance, value){
  instance.heapNewSize = value;
}

function setHeapSize(instance, value){
  instance.heapSize = value;
}

function setJmxPort(instance, value){
  instance.jmxPort = value;
}

function setStorageNode(instance, value){
  instance.storageNode = value;
}

function setThreadStackSize(instance, value){
  instance.threadStackSize = value;
}

function StorageNodeLoadComposite_0(){
}

defineSeed(867, 1, makeCastMap([Q$Serializable, Q$StorageNodeLoadComposite]), StorageNodeLoadComposite_0);
_.toString$ = function toString_68(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_13((builder.impl.string += 'storageNode.addresss=' , builder), this.storageNode.address), ', ');
  $append_13($append_13((builder.impl.string += 'hostname=' , builder), this.hostname), ', ');
  $append_13($append_11((builder.impl.string += 'beginTime=' , builder), this.beginTime), ', ');
  $append_13($append_11((builder.impl.string += 'beginTime=' , builder), this.beginTime), ', ');
  $append_13($append_10((builder.impl.string += 'unackAlerts=' , builder), this.unackAlerts), ', ');
  $append_13($append_12((builder.impl.string += 'heapUsed=' , builder), this.heapUsed), ', ');
  $append_13($append_12((builder.impl.string += 'heapPercentageUsed=' , builder), this.heapPercentageUsed), ', ');
  $append_13($append_12((builder.impl.string += 'load=' , builder), this.load), ', ');
  $append_13($append_12((builder.impl.string += 'dataUsedPercentage=' , builder), this.dataDiskUsedPercentage), ', ');
  $append_13($append_12((builder.impl.string += 'dataDiskUsed=' , builder), this.dataDiskUsed), ', ');
  $append_13($append_12((builder.impl.string += 'tokens=' , builder), this.tokens), ', ');
  $append_12((builder.impl.string += 'actuallyOwns=' , builder), this.actuallyOwns);
  return builder.impl.string;
}
;
_.actuallyOwns = null;
_.beginTime = P0_longLit;
_.dataDiskUsed = null;
_.dataDiskUsedPercentage = null;
_.endTime = P0_longLit;
_.freeDiskToDataSizeRatio = null;
_.heapCommitted = null;
_.heapPercentageUsed = null;
_.heapUsed = null;
_.hostname = null;
_.load = null;
_.storageNode = null;
_.tokens = null;
_.totalDiskUsedPercentage = null;
_.unackAlerts = 0;
function StorageNodeLoadComposite$MeasurementAggregateWithUnits_0(){
}

defineSeed(868, 1, makeCastMap([Q$Serializable, Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits]), StorageNodeLoadComposite$MeasurementAggregateWithUnits_0);
_.toString$ = function toString_69(){
  if (this.formattedValue != null) {
    return this.formattedValue;
  }
  return $toString_12(this.aggregate) + ' (' + this.units.displayUnits + ')';
}
;
_.aggregate = null;
_.formattedValue = null;
_.units = null;
function deserialize_148(streamReader, instance){
  setActuallyOwns(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setBeginTime(instance, $readLong(streamReader));
  setDataDiskUsed(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setDataDiskUsedPercentage(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setEndTime(instance, $readLong(streamReader));
  setFreeDiskToDataSizeRatio(instance, dynamicCast($readObject(streamReader), Q$MeasurementAggregate));
  setHeapCommitted(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setHeapPercentageUsed(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setHeapUsed(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setHostname(instance, $getString(streamReader, $readInt(streamReader)));
  setLoad(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setStorageNode_0(instance, dynamicCast($readObject(streamReader), Q$StorageNode));
  setTokens(instance, dynamicCast($readObject(streamReader), Q$MeasurementAggregate));
  setTotalDiskUsedPercentage(instance, dynamicCast($readObject(streamReader), Q$StorageNodeLoadComposite$MeasurementAggregateWithUnits));
  setUnackAlerts(instance, $readInt(streamReader));
}

function instantiate_145(streamReader){
  return new StorageNodeLoadComposite_0;
}

function setActuallyOwns(instance, value){
  instance.actuallyOwns = value;
}

function setBeginTime(instance, value){
  instance.beginTime = value;
}

function setDataDiskUsed(instance, value){
  instance.dataDiskUsed = value;
}

function setDataDiskUsedPercentage(instance, value){
  instance.dataDiskUsedPercentage = value;
}

function setEndTime(instance, value){
  instance.endTime = value;
}

function setFreeDiskToDataSizeRatio(instance, value){
  instance.freeDiskToDataSizeRatio = value;
}

function setHeapCommitted(instance, value){
  instance.heapCommitted = value;
}

function setHeapPercentageUsed(instance, value){
  instance.heapPercentageUsed = value;
}

function setHeapUsed(instance, value){
  instance.heapUsed = value;
}

function setHostname(instance, value){
  instance.hostname = value;
}

function setLoad(instance, value){
  instance.load = value;
}

function setStorageNode_0(instance, value){
  instance.storageNode = value;
}

function setTokens(instance, value){
  instance.tokens = value;
}

function setTotalDiskUsedPercentage(instance, value){
  instance.totalDiskUsedPercentage = value;
}

function setUnackAlerts(instance, value){
  instance.unackAlerts = value;
}

function deserialize_149(streamReader, instance){
  setAggregate(instance, dynamicCast($readObject(streamReader), Q$MeasurementAggregate));
  setFormattedValue(instance, $getString(streamReader, $readInt(streamReader)));
  setUnits(instance, dynamicCast($readObject(streamReader), Q$MeasurementUnits));
}

function instantiate_146(streamReader){
  return new StorageNodeLoadComposite$MeasurementAggregateWithUnits_0;
}

function setAggregate(instance, value){
  instance.aggregate = value;
}

function setFormattedValue(instance, value){
  instance.formattedValue = value;
}

function setUnits(instance, value){
  instance.units = value;
}

function deserialize_150(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_147(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_StorageNode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$StorageNode, size, 0);
}

function deserialize_151(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setAddress_0(instance, $getString(streamReader, $readInt(streamReader)));
  setCqlPort_0(instance, $readInt(streamReader));
  setCtime_9(instance, $readLong(streamReader));
  setErrorMessage(instance, $getString(streamReader, $readInt(streamReader)));
  setFailedOperation(instance, dynamicCast($readObject(streamReader), Q$ResourceOperationHistory));
  setId_23(instance, $readInt(streamReader));
  setMaintenancePending(instance, $readBoolean(streamReader));
  setMtime_4(instance, $readLong(streamReader));
  setOperationMode_0(instance, dynamicCast($readObject(streamReader), Q$StorageNode$OperationMode));
  setResource_1(instance, dynamicCast($readObject(streamReader), Q$Resource));
}

function instantiate_148(streamReader){
  return new StorageNode_0;
}

function serialize_89(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeString(streamWriter, instance.address);
  $writeInt(streamWriter, instance.cqlPort);
  $append_4(streamWriter, toBase64(instance.ctime));
  $writeString(streamWriter, instance.errorMessage_0);
  $writeObject(streamWriter, instance.failedOperation);
  $writeInt(streamWriter, instance.id);
  $writeBoolean(streamWriter, instance.maintenancePending);
  $append_4(streamWriter, toBase64(instance.mtime));
  $writeObject(streamWriter, instance.operationMode);
  $writeObject(streamWriter, instance.resource);
}

function setAddress_0(instance, value){
  instance.address = value;
}

function setCqlPort_0(instance, value){
  instance.cqlPort = value;
}

function setCtime_9(instance, value){
  instance.ctime = value;
}

function setErrorMessage(instance, value){
  instance.errorMessage_0 = value;
}

function setFailedOperation(instance, value){
  instance.failedOperation = value;
}

function setId_23(instance, value){
  instance.id = value;
}

function setMaintenancePending(instance, value){
  instance.maintenancePending = value;
}

function setMtime_4(instance, value){
  instance.mtime = value;
}

function setOperationMode_0(instance, value){
  instance.operationMode = value;
}

function setResource_1(instance, value){
  instance.resource = value;
}

function serialize_90(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_152(streamReader, instance){
}

function instantiate_149(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_StorageNode$OperationMode() , $clinit_StorageNode$OperationMode() , $VALUES_63);
  return values[ordinal];
}

function serialize_91(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function AffinityGroupCountComposite_0(){
}

defineSeed(875, 1, makeCastMap([Q$Serializable, Q$AffinityGroupCountComposite]), AffinityGroupCountComposite_0);
_.affinityGroup = null;
_.agentCount = 0;
_.serverCount = 0;
function deserialize_153(streamReader, instance){
  setAffinityGroup_0(instance, dynamicCast($readObject(streamReader), Q$AffinityGroup));
  setAgentCount(instance, $readInt(streamReader));
  setServerCount(instance, $readInt(streamReader));
}

function instantiate_150(streamReader){
  return new AffinityGroupCountComposite_0;
}

function setAffinityGroup_0(instance, value){
  instance.affinityGroup = value;
}

function setAgentCount(instance, value){
  instance.agentCount = value;
}

function setServerCount(instance, value){
  instance.serverCount = value;
}

function ServerWithAgentCountComposite_0(){
}

defineSeed(877, 1, makeCastMap([Q$Serializable, Q$ServerWithAgentCountComposite]), ServerWithAgentCountComposite_0);
_.agentCount = 0;
_.server = null;
function deserialize_154(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_151(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_composite_ServerWithAgentCountComposite_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ServerWithAgentCountComposite, size, 0);
}

function deserialize_155(streamReader, instance){
  setAgentCount_0(instance, $readInt(streamReader));
  setServer(instance, dynamicCast($readObject(streamReader), Q$Server));
}

function instantiate_152(streamReader){
  return new ServerWithAgentCountComposite_0;
}

function setAgentCount_0(instance, value){
  instance.agentCount = value;
}

function setServer(instance, value){
  instance.server = value;
}

function $isAutoCluster(this$static){
  return ($clinit_EntityContext$Type() , ResourceGroup) == this$static.type_0 && this$static.isAutoCluster;
}

function $isAutoGroup(this$static){
  return ($clinit_EntityContext$Type() , ResourceGroup) == this$static.type_0 && this$static.isAutoGroup;
}

function $isSubsystemView(this$static){
  return ($clinit_EntityContext$Type() , SubsystemView) == this$static.type_0;
}

function $toShortString(this$static){
  switch (this$static.type_0.ordinal) {
    case 0:
      return 'resource[id=' + this$static.resourceId + ']';
    case 2:
      return 'resourceGroup[groupId=' + this$static.resourceId + ']';
    case 3:
      return 'autoGroup[parent=' + this$static.parentResourceId + ',type=' + this$static.resourceTypeId + ']';
    case 1:
      return 'template[type=' + this$static.resourceTypeId + ']';
    default:return 'EntityContext[category=' + this$static.type_0 + ',resourceId=' + this$static.resourceId + ',groupId=' + this$static.groupId + ',parent=' + this$static.parentResourceId + ',type=' + this$static.resourceTypeId + ']';
  }
}

function EntityContext_0(){
}

function forGroup(groupId, isAutoCluster, isAutoGroup){
  var context;
  context = new EntityContext_1(null, valueOf_49(groupId), null);
  context.isAutoCluster = isAutoCluster;
  context.isAutoGroup = isAutoGroup;
  return context;
}

defineSeed(880, 1, makeCastMap([Q$Serializable]), EntityContext_0);
function serialize_92(streamWriter, instance){
  $writeInt(streamWriter, instance.groupId);
  $writeBoolean(streamWriter, instance.isAutoCluster);
  $writeBoolean(streamWriter, instance.isAutoGroup);
  $writeInt(streamWriter, instance.parentResourceId);
  $writeInt(streamWriter, instance.resourceId);
  $writeInt(streamWriter, instance.resourceTypeId);
  $writeObject(streamWriter, instance.type_0);
}

function serialize_93(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function JobTrigger_0(){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , NONE_7), null);
}

function JobTrigger_1(repeatInterval, repeatCount){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , REPEAT_COUNT));
  this.repeatInterval = valueOf_50(repeatInterval);
  this.repeatCount = valueOf_49(repeatCount);
}

function JobTrigger_2(repeatInterval, endDate){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , DATETIME_0));
  this.repeatInterval = valueOf_50(repeatInterval);
  this.endDate = endDate;
}

function JobTrigger_3(cronExpression){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , CRON_EXPRESSION), ($clinit_JobTrigger$EndType() , NEVER));
  this.cronExpression = cronExpression;
}

function JobTrigger_4(startDate){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , DATETIME_1), ($clinit_JobTrigger$RecurrenceType() , NONE_7), ($clinit_JobTrigger$EndType() , REPEAT_COUNT));
  this.startDate = startDate;
  this.repeatCount = valueOf_49(1);
}

function JobTrigger_5(startDate, repeatInterval, repeatCount){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , DATETIME_1), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , REPEAT_COUNT));
  this.startDate = startDate;
  this.repeatInterval = valueOf_50(repeatInterval);
  this.repeatCount = valueOf_49(repeatCount);
}

function JobTrigger_6(startDate, repeatInterval, endDate){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , DATETIME_1), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , DATETIME_0));
  this.startDate = startDate;
  this.repeatInterval = valueOf_50(repeatInterval);
  this.endDate = endDate;
}

function JobTrigger_7(startType, recurrenceType, endType){
  this.startType = startType;
  this.recurrenceType = recurrenceType;
  this.endType = endType;
}

defineSeed(885, 1, makeCastMap([Q$Serializable, Q$JobTrigger]), JobTrigger_0, JobTrigger_1, JobTrigger_2, JobTrigger_3, JobTrigger_4, JobTrigger_5, JobTrigger_6);
_.toString$ = function toString_71(){
  var sb;
  sb = new StringBuilder_0;
  sb.impl.string += 'Trigger';
  $append_8($append_13((sb.impl.string += "[cronExpression='" , sb), this.cronExpression), 39);
  $append_12((sb.impl.string += ', startType=' , sb), this.startType);
  $append_12((sb.impl.string += ', recurrenceType=' , sb), this.recurrenceType);
  $append_12((sb.impl.string += ', endType=' , sb), this.endType);
  $append_12((sb.impl.string += ', startDate=' , sb), this.startDate);
  $append_12((sb.impl.string += ', repeatInterval=' , sb), this.repeatInterval);
  $append_12((sb.impl.string += ', endDate=' , sb), this.endDate);
  $append_12((sb.impl.string += ', repeatCount=' , sb), this.repeatCount);
  sb.impl.string += ']';
  return sb.impl.string;
}
;
_.cronExpression = null;
_.endDate = null;
_.endType = null;
_.recurrenceType = null;
_.repeatCount = null;
_.repeatInterval = null;
_.startDate = null;
_.startType = null;
function $clinit_JobTrigger$EndType(){
  $clinit_JobTrigger$EndType = nullMethod;
  NEVER = new JobTrigger$EndType_0('NEVER', 0);
  DATETIME_0 = new JobTrigger$EndType_0('DATETIME', 1);
  REPEAT_COUNT = new JobTrigger$EndType_0('REPEAT_COUNT', 2);
  $VALUES_66 = initValues(_3Lorg_rhq_core_domain_common_JobTrigger$EndType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$JobTrigger$EndType, [NEVER, DATETIME_0, REPEAT_COUNT]);
}

function JobTrigger$EndType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_75(name_0){
  $clinit_JobTrigger$EndType();
  return valueOf(($clinit_JobTrigger$EndType$Map() , $MAP_66), name_0);
}

function values_69(){
  $clinit_JobTrigger$EndType();
  return $VALUES_66;
}

defineSeed(886, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$JobTrigger$EndType]), JobTrigger$EndType_0);
var $VALUES_66, DATETIME_0, NEVER, REPEAT_COUNT;
function $clinit_JobTrigger$EndType$Map(){
  $clinit_JobTrigger$EndType$Map = nullMethod;
  $MAP_66 = createValueOfMap(($clinit_JobTrigger$EndType() , $VALUES_66));
}

var $MAP_66;
function $clinit_JobTrigger$RecurrenceType(){
  $clinit_JobTrigger$RecurrenceType = nullMethod;
  NONE_7 = new JobTrigger$RecurrenceType_0('NONE', 0);
  REPEAT_INTERVAL = new JobTrigger$RecurrenceType_0('REPEAT_INTERVAL', 1);
  CRON_EXPRESSION = new JobTrigger$RecurrenceType_0('CRON_EXPRESSION', 2);
  $VALUES_67 = initValues(_3Lorg_rhq_core_domain_common_JobTrigger$RecurrenceType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$JobTrigger$RecurrenceType, [NONE_7, REPEAT_INTERVAL, CRON_EXPRESSION]);
}

function JobTrigger$RecurrenceType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_76(name_0){
  $clinit_JobTrigger$RecurrenceType();
  return valueOf(($clinit_JobTrigger$RecurrenceType$Map() , $MAP_67), name_0);
}

function values_70(){
  $clinit_JobTrigger$RecurrenceType();
  return $VALUES_67;
}

defineSeed(888, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$JobTrigger$RecurrenceType]), JobTrigger$RecurrenceType_0);
var $VALUES_67, CRON_EXPRESSION, NONE_7, REPEAT_INTERVAL;
function $clinit_JobTrigger$RecurrenceType$Map(){
  $clinit_JobTrigger$RecurrenceType$Map = nullMethod;
  $MAP_67 = createValueOfMap(($clinit_JobTrigger$RecurrenceType() , $VALUES_67));
}

var $MAP_67;
function $clinit_JobTrigger$StartType(){
  $clinit_JobTrigger$StartType = nullMethod;
  NOW = new JobTrigger$StartType_0('NOW', 0);
  DATETIME_1 = new JobTrigger$StartType_0('DATETIME', 1);
  $VALUES_68 = initValues(_3Lorg_rhq_core_domain_common_JobTrigger$StartType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$JobTrigger$StartType, [NOW, DATETIME_1]);
}

function JobTrigger$StartType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_77(name_0){
  $clinit_JobTrigger$StartType();
  return valueOf(($clinit_JobTrigger$StartType$Map() , $MAP_68), name_0);
}

function values_71(){
  $clinit_JobTrigger$StartType();
  return $VALUES_68;
}

defineSeed(890, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$JobTrigger$StartType]), JobTrigger$StartType_0);
var $VALUES_68, DATETIME_1, NOW;
function $clinit_JobTrigger$StartType$Map(){
  $clinit_JobTrigger$StartType$Map = nullMethod;
  $MAP_68 = createValueOfMap(($clinit_JobTrigger$StartType() , $VALUES_68));
}

var $MAP_68;
function deserialize_156(streamReader, instance){
}

function instantiate_153(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_JobTrigger$EndType() , $clinit_JobTrigger$EndType() , $VALUES_66);
  return values[ordinal];
}

function serialize_94(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function deserialize_157(streamReader, instance){
  setCronExpression(instance, $getString(streamReader, $readInt(streamReader)));
  setEndDate_0(instance, dynamicCast($readObject(streamReader), Q$Date));
  setEndType(instance, dynamicCast($readObject(streamReader), Q$JobTrigger$EndType));
  setRecurrenceType(instance, dynamicCast($readObject(streamReader), Q$JobTrigger$RecurrenceType));
  setRepeatCount(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setRepeatInterval(instance, dynamicCast($readObject(streamReader), Q$Long));
  setStartDate_0(instance, dynamicCast($readObject(streamReader), Q$Date));
  setStartType(instance, dynamicCast($readObject(streamReader), Q$JobTrigger$StartType));
}

function instantiate_154(streamReader){
  return new JobTrigger_0;
}

function serialize_95(streamWriter, instance){
  $writeString(streamWriter, instance.cronExpression);
  $writeObject(streamWriter, instance.endDate);
  $writeObject(streamWriter, instance.endType);
  $writeObject(streamWriter, instance.recurrenceType);
  $writeObject(streamWriter, instance.repeatCount);
  $writeObject(streamWriter, instance.repeatInterval);
  $writeObject(streamWriter, instance.startDate);
  $writeObject(streamWriter, instance.startType);
}

function setCronExpression(instance, value){
  instance.cronExpression = value;
}

function setEndDate_0(instance, value){
  instance.endDate = value;
}

function setEndType(instance, value){
  instance.endType = value;
}

function setRecurrenceType(instance, value){
  instance.recurrenceType = value;
}

function setRepeatCount(instance, value){
  instance.repeatCount = value;
}

function setRepeatInterval(instance, value){
  instance.repeatInterval = value;
}

function setStartDate_0(instance, value){
  instance.startDate = value;
}

function setStartType(instance, value){
  instance.startType = value;
}

function deserialize_158(streamReader, instance){
}

function instantiate_155(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_JobTrigger$RecurrenceType() , $clinit_JobTrigger$RecurrenceType() , $VALUES_67);
  return values[ordinal];
}

function serialize_96(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function deserialize_159(streamReader, instance){
}

function instantiate_156(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_JobTrigger$StartType() , $clinit_JobTrigger$StartType() , $VALUES_68);
  return values[ordinal];
}

function serialize_97(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function getByInternalName(internalName){
  $clinit_SystemSetting();
  var p, p$array, p$index, p$max;
  for (p$array = $VALUES_70 , p$index = 0 , p$max = p$array.length; p$index < p$max; ++p$index) {
    p = p$array[p$index];
    if ($equals_6(p.internalName, internalName)) {
      return p;
    }
  }
  return null;
}

function $toConfiguration(this$static){
  var e, e$iterator, ret;
  ret = new Configuration_0;
  for (e$iterator = new AbstractHashMap$EntrySetIterator_0((new AbstractHashMap$EntrySet_0(this$static)).this$0); $hasNext(e$iterator.iter);) {
    e = e$iterator.last = dynamicCast($next_0(e$iterator.iter), Q$Map$Entry);
    $put_4(ret, new PropertySimple_1(dynamicCast(e.getKey_0(), Q$SystemSetting).internalName, e.getValue_1()));
  }
  return ret;
}

function fromMap(properties){
  var e, e$iterator, p, ret;
  ret = new SystemSettings_0;
  for (e$iterator = properties.entrySet().iterator(); e$iterator.hasNext();) {
    e = dynamicCast(e$iterator.next_0(), Q$Map$Entry);
    p = getByInternalName(dynamicCast(e.getKey_0(), Q$String));
    if (!p) {
      throw new IllegalArgumentException_1("'" + dynamicCast(e.getKey_0(), Q$String) + "' is not a system property.");
    }
    $put_3(ret, p, dynamicCast(e.getValue_1(), Q$String));
  }
  return ret;
}

defineSeed(906, 683, makeCastMap([Q$Serializable, Q$Cloneable, Q$HashMap, Q$Map, Q$SystemSettings]));
_.putAll = function putAll_0(m_0){
  var e, e$iterator;
  for (e$iterator = m_0.entrySet().iterator(); e$iterator.hasNext();) {
    e = dynamicCast(e$iterator.next_0(), Q$Map$Entry);
    $put_3(this, dynamicCast(e.getKey_0(), Q$SystemSetting), dynamicCast(e.getValue_1(), Q$String));
  }
}
;
function $addRawConfiguration(this$static, rawConfiguration){
  rawConfiguration.configuration = this$static;
  !this$static.rawConfigurations && (this$static.rawConfigurations = new HashSet_1(1));
  this$static.rawConfigurations.add_0(rawConfiguration);
}

function $createDeepCopyOfProperties(this$static, copy, keepId){
  var property, property$iterator;
  for (property$iterator = this$static.properties.values_0().iterator(); property$iterator.hasNext();) {
    property = dynamicCast(property$iterator.next_0(), Q$Property);
    $put_4(copy, property.deepCopy(keepId));
  }
}

function $createDeepCopyOfRawConfigs(this$static, copy, keepId){
  var rawConfig, rawConfig$iterator, copy_0;
  if (!this$static.rawConfigurations) {
    return;
  }
  for (rawConfig$iterator = this$static.rawConfigurations.iterator(); rawConfig$iterator.hasNext();) {
    rawConfig = dynamicCast(rawConfig$iterator.next_0(), Q$RawConfiguration);
    $addRawConfiguration(copy, (copy_0 = new RawConfiguration_0 , keepId && (copy_0.id = rawConfig.id) , copy_0.path = rawConfig.path , rawConfig.contents_0 != null && $setContents_1(copy_0, rawConfig.contents_0, rawConfig.sha256) , copy_0.errorMessage_0 = rawConfig.errorMessage_0 , copy_0));
  }
}

function $deepCopy(this$static, keepIds){
  var copy;
  copy = new Configuration_0;
  keepIds && (copy.id = this$static.id);
  copy.notes = this$static.notes;
  copy.version_0 = this$static.version_0;
  $createDeepCopyOfProperties(this$static, copy, keepIds);
  $createDeepCopyOfRawConfigs(this$static, copy, keepIds);
  return copy;
}

function $deepCopyWithoutProxies(this$static){
  var copy;
  copy = new Configuration_0;
  copy.notes = this$static.notes;
  copy.version_0 = this$static.version_0;
  $createDeepCopyOfProperties(this$static, copy, false);
  $createDeepCopyOfRawConfigs(this$static, copy, false);
  return copy;
}

function $get_6(this$static, name_0){
  return dynamicCast(this$static.properties.get_2(name_0), Q$Property);
}

function $getAllProperties(this$static){
  if (!this$static.properties) {
    return $clinit_Collections() , $clinit_Collections() , EMPTY_MAP;
  }
  return this$static.properties;
}

function $getSimple(this$static, name_0){
  return dynamicCast(this$static.properties.get_2(name_0), Q$PropertySimple);
}

function $getSimpleProperties(this$static){
  var map, prop, prop$iterator;
  map = new LinkedHashMap_0;
  for (prop$iterator = (!this$static.propertiesProxy && (this$static.propertiesProxy = new Configuration$PropertiesProxy_0(this$static)) , $iterator_1(this$static.propertiesProxy)); prop$iterator.hasNext();) {
    prop = dynamicCast(prop$iterator.next_0(), Q$Property);
    instanceOf(prop, Q$PropertySimple) && $put_1(map, prop.name_0, dynamicCast(prop, Q$PropertySimple));
  }
  return map;
}

function $remove_18(this$static, name_0){
  return dynamicCast(this$static.properties.remove_4(name_0), Q$Property);
}

defineSeed(912, 1, makeCastMap([Q$Serializable, Q$Cloneable, Q$AbstractPropertyMap, Q$Configuration]));
_.get_3 = function get_16(name_0){
  return $get_6(this, name_0);
}
;
_.getList = function getList(name_0){
  return $getList(this, name_0);
}
;
_.getMap = function getMap(){
  return this.properties;
}
;
_.getMap_0 = function getMap_0(name_0){
  return $getMap(this, name_0);
}
;
_.getSimple = function getSimple(name_0){
  return $getSimple(this, name_0);
}
;
_.put_0 = function put_5(value){
  $put_4(this, value);
}
;
function $clinit_Configuration$EmptyIterator(){
  $clinit_Configuration$EmptyIterator = nullMethod;
  EMPTY_ITERATOR = new Configuration$EmptyIterator_0;
}

function Configuration$EmptyIterator_0(){
}

defineSeed(913, 1, {}, Configuration$EmptyIterator_0);
_.hasNext = function hasNext_10(){
  return false;
}
;
_.next_0 = function next_11(){
  throw new NoSuchElementException_0;
}
;
_.remove_3 = function remove_31(){
  throw new IllegalStateException_0;
}
;
var EMPTY_ITERATOR;
function $add_10(this$static, e){
  $put_4(this$static.this$0, e);
  return true;
}

function $isEmpty_1(this$static){
  return !this$static.this$0.properties || this$static.this$0.properties.isEmpty_0();
}

function $iterator_1(this$static){
  return !this$static.this$0.properties?($clinit_Configuration$EmptyIterator() , EMPTY_ITERATOR):this$static.this$0.properties.values_0().iterator();
}

function Configuration$PropertiesProxy_0(this$0){
  this.this$0 = this$0;
}

defineSeed(914, 1, makeCastMap([Q$Iterable, Q$Collection]), Configuration$PropertiesProxy_0);
_.add_0 = function add_13(e){
  return $add_10(this, dynamicCast(e, Q$Property));
}
;
_.equals$ = function equals_51(obj_0){
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$Collection)) {
    return false;
  }
  return this.this$0.properties.values_0().equals$(obj_0);
}
;
_.hashCode$ = function hashCode_51(){
  return this.this$0.properties.values_0().hashCode$();
}
;
_.iterator = function iterator_16(){
  return $iterator_1(this);
}
;
_.size_1 = function size_23(){
  return !this.this$0.properties?0:this.this$0.properties.size_1();
}
;
_.toArray = function toArray_8(){
  return !this.this$0.properties?initValues(_3Ljava_lang_Object_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Object, []):this.this$0.properties.values_0().toArray();
}
;
_.toString$ = function toString_74(){
  return this.this$0.properties.values_0().toString$();
}
;
_.this$0 = null;
function serialize_102(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function normalizeConfiguration(configuration, configurationDefinition){
  var childPropertyDefinition, childPropertyDefinition$iterator, childPropertyDefinitions;
  if (!configuration) {
    throw new IllegalArgumentException_1('Configuration parameter is null.');
  }
  if (configurationDefinition) {
    childPropertyDefinitions = (!configurationDefinition.propertyDefinitions && (configurationDefinition.propertyDefinitions = new LinkedHashMap_0) , configurationDefinition.propertyDefinitions);
    for (childPropertyDefinition$iterator = childPropertyDefinitions.values_0().iterator(); childPropertyDefinition$iterator.hasNext();) {
      childPropertyDefinition = dynamicCast(childPropertyDefinition$iterator.next_0(), Q$PropertyDefinition);
      normalizeProperty(childPropertyDefinition, configuration, true);
    }
  }
}

function normalizeProperty(propertyDefinition, parentPropertyMap, normalizeRequiredDefaults){
  var listMemberPropertyDefinition, property, property$iterator, propertyDefinitionList, propertyDefinitionMap, propertyList, propertyMap, propertySimple, value;
  if (parentPropertyMap.getMap().keySet_0().contains(propertyDefinition.name_0)) {
    if (instanceOf(propertyDefinition, Q$PropertyDefinitionSimple)) {
      propertySimple = parentPropertyMap.getSimple(propertyDefinition.name_0);
      value = propertySimple.stringValue;
      value != null && ($equals_6(value, '')?$setValue_12(propertySimple, null):value.length > 2000 && $setValue_12(propertySimple, value.substr(0, 2000 - 0)));
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionMap)) {
      propertyMap = parentPropertyMap.getMap_0(propertyDefinition.name_0);
      propertyDefinitionMap = dynamicCast(propertyDefinition, Q$PropertyDefinitionMap);
      normalizePropertyMap(propertyMap, propertyDefinitionMap);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionList)) {
      propertyDefinitionList = dynamicCast(propertyDefinition, Q$PropertyDefinitionList);
      listMemberPropertyDefinition = propertyDefinitionList.memberDefinition;
      if (instanceOf(listMemberPropertyDefinition, Q$PropertyDefinitionMap)) {
        propertyDefinitionMap = dynamicCast(listMemberPropertyDefinition, Q$PropertyDefinitionMap);
        propertyList = parentPropertyMap.getList(propertyDefinition.name_0);
        for (property$iterator = (!propertyList.list && (propertyList.list = new ArrayList_0) , propertyList.list).iterator(); property$iterator.hasNext();) {
          property = dynamicCast(property$iterator.next_0(), Q$Property);
          propertyMap = dynamicCast(property, Q$PropertyMap);
          normalizePropertyMap(propertyMap, propertyDefinitionMap);
        }
      }
    }
  }
   else {
    if (instanceOf(propertyDefinition, Q$PropertyDefinitionSimple)) {
      value = null;
      normalizeRequiredDefaults && propertyDefinition.required && (value = dynamicCast(propertyDefinition, Q$PropertyDefinitionSimple).defaultValue);
      property = new PropertySimple_1(propertyDefinition.name_0, value);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionMap)) {
      property = new PropertyMap_1(propertyDefinition.name_0);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionList)) {
      property = new PropertyList_1(propertyDefinition.name_0);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionDynamic)) {
      property = new PropertySimple_1(propertyDefinition.name_0, null);
    }
     else {
      throw new IllegalStateException_1('Unsupported PropertyDefinition subclass: ' + propertyDefinition.___clazz$.typeName);
    }
    parentPropertyMap.put_0(property);
  }
}

function normalizePropertyMap(propertyMap, propertyDefinitionMap){
  var childPropertyDefinition, childPropertyDefinition$iterator, childPropertyDefinitions;
  childPropertyDefinitions = (!propertyDefinitionMap.map_0 && (propertyDefinitionMap.map_0 = new HashMap_0) , propertyDefinitionMap.map_0);
  for (childPropertyDefinition$iterator = childPropertyDefinitions.values_0().iterator(); childPropertyDefinition$iterator.hasNext();) {
    childPropertyDefinition = dynamicCast(childPropertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    normalizeProperty(childPropertyDefinition, propertyMap, false);
  }
}

function $setErrorMessage(this$static, errorMessage){
  this$static.errorMessage_0 = errorMessage != null?$trim(errorMessage):null;
}

function Property_1(original, keepId){
  keepId && (this.id = original.id);
  this.errorMessage_0 = original.errorMessage_0;
  original.name_0 != null && (this.name_0 = $intern(original.name_0));
}

defineSeed(923, 1, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$Property]));
_.deepCopy = function deepCopy(keepId){
  return null;
}
;
function $getIntegerValue(this$static){
  return this$static.stringValue == null?null:valueOf_49(__parseAndValidateInt(this$static.stringValue));
}

function $setOverride(this$static, override){
  this$static.override = override;
}

function PropertySimple_2(original, keepId){
  Property_1.call(this, original, keepId);
  this.stringValue = original.stringValue;
  this.override = original.override;
}

defineSeed(922, 923, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$Property, Q$PropertySimple]), PropertySimple_2);
_.deepCopy = function deepCopy_0(keepId){
  return this.deepCopy_0(keepId);
}
;
_.deepCopy_0 = function deepCopy_1(keepId){
  return new PropertySimple_2(this, keepId);
}
;
function ObfuscatedPropertySimple_1(original, keepId){
  PropertySimple_2.call(this, original, keepId);
}

defineSeed(921, 922, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$ObfuscatedPropertySimple, Q$Property, Q$PropertySimple]), ObfuscatedPropertySimple_1);
_.deepCopy_0 = function deepCopy_2(keepId){
  return new ObfuscatedPropertySimple_1(this, keepId);
}
;
defineSeed(926, 910, makeCastMap([Q$Serializable, Q$AbstractConfigurationUpdate, Q$AbstractResourceConfigurationUpdate, Q$PluginConfigurationUpdate]));
_.getAbstractGroupConfigurationUpdate = function getAbstractGroupConfigurationUpdate(){
  return this.groupConfigurationUpdate;
}
;
_.getResource = function getResource(){
  return this.resource;
}
;
function $setConfigurationDefinition(this$static, configurationDefinition){
  this$static.configurationDefinition = configurationDefinition;
}

function $setDisplayName(this$static, displayName){
  displayName != null?(this$static.displayName = String(displayName)):(this$static.displayName = null);
}

function $setOrder(this$static, order){
  this$static.order = order;
}

function $setReadOnly_0(this$static, readOnly){
  this$static.readOnly = readOnly;
}

function PropertyDefinition_1(name_0, description, required){
  name_0 != null && (this.name_0 = String(name_0));
  this.description = description;
  this.required = required;
}

function $add_11(this$static, property){
  this$static.memberPropertyName == null && (this$static.memberPropertyName = property.name_0);
  if (!$equals_6(property.name_0, this$static.memberPropertyName)) {
    throw new IllegalStateException_1('All properties in a PropertyList (id=[' + this$static.id + '], name=[' + this$static.name_0 + ']) must have the same name: [' + property.name_0 + '] != [' + this$static.memberPropertyName + ']');
  }
  (!this$static.list && (this$static.list = new ArrayList_0) , this$static.list).add_0(property);
  property.parentList = this$static;
}

function $deepCopy_0(this$static, keepId){
  var copy, property, property$iterator;
  copy = new PropertyList_3(this$static, keepId);
  for (property$iterator = this$static.list.iterator(); property$iterator.hasNext();) {
    property = dynamicCast(property$iterator.next_0(), Q$Property);
    $add_11(copy, property.deepCopy(false));
  }
  return copy;
}

function $getList_0(this$static){
  !this$static.list && (this$static.list = new ArrayList_0);
  return this$static.list;
}

function PropertyList_1(name_0){
  $$init_8(this);
  name_0 != null && (this.name_0 = String(name_0));
}

function PropertyList_2(name_0, startingList){
  var property, property$index, property$max;
  PropertyList_1.call(this, name_0);
  for (property$index = 0 , property$max = startingList.length; property$index < property$max; ++property$index) {
    property = startingList[property$index];
    $add_11(this, property);
  }
}

function PropertyList_3(original, keepId){
  Property_1.call(this, original, keepId);
  $$init_8(this);
}

defineSeed(935, 923, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$Property, Q$PropertyList]), PropertyList_1, PropertyList_2, PropertyList_3);
_.deepCopy = function deepCopy_3(keepId){
  return $deepCopy_0(this, keepId);
}
;
function $deepCopy_1(this$static, keepId){
  var copy, property, property$iterator;
  copy = new PropertyMap_2(this$static, keepId);
  for (property$iterator = this$static.map_0.values_0().iterator(); property$iterator.hasNext();) {
    property = dynamicCast(property$iterator.next_0(), Q$Property);
    $put_5(copy, property.deepCopy(keepId));
  }
  return copy;
}

function $get_7(this$static, name_0){
  return dynamicCast((!this$static.map_0 && (this$static.map_0 = new LinkedHashMap_0) , this$static.map_0).get_2(name_0), Q$Property);
}

function $getSimple_0(this$static, name_0){
  return dynamicCast(dynamicCast((!this$static.map_0 && (this$static.map_0 = new LinkedHashMap_0) , this$static.map_0).get_2(name_0), Q$Property), Q$PropertySimple);
}

function $put_5(this$static, property){
  (!this$static.map_0 && (this$static.map_0 = new LinkedHashMap_0) , this$static.map_0).put(property.name_0, property);
  property.parentMap = this$static;
}

function PropertyMap_1(name_0){
  $$init_9(this);
  name_0 != null && (this.name_0 = String(name_0));
}

function PropertyMap_2(original, keepId){
  Property_1.call(this, original, keepId);
  $$init_9(this);
}

defineSeed(937, 923, makeCastMap([Q$Serializable, Q$Comparable, Q$AbstractPropertyMap, Q$DeepCopyable, Q$Property, Q$PropertyMap]), PropertyMap_1, PropertyMap_2);
_.deepCopy = function deepCopy_4(keepId){
  return $deepCopy_1(this, keepId);
}
;
_.get_3 = function get_17(name_0){
  return $get_7(this, name_0);
}
;
_.getList = function getList_0(name_0){
  return dynamicCast(dynamicCast((!this.map_0 && (this.map_0 = new LinkedHashMap_0) , this.map_0).get_2(name_0), Q$Property), Q$PropertyList);
}
;
_.getMap = function getMap_1(){
  return !this.map_0 && (this.map_0 = new LinkedHashMap_0) , this.map_0;
}
;
_.getMap_0 = function getMap_2(name_0){
  return dynamicCast(dynamicCast((!this.map_0 && (this.map_0 = new LinkedHashMap_0) , this.map_0).get_2(name_0), Q$Property), Q$PropertyMap);
}
;
_.getSimple = function getSimple_0(name_0){
  return $getSimple_0(this, name_0);
}
;
_.put_0 = function put_6(property){
  $put_5(this, property);
}
;
function $setContents_1(this$static, contents, sha256){
  this$static.contents_0 = contents;
  this$static.errorMessage_0 = null;
  this$static.sha256 = sha256;
}

defineSeed(945, 910, makeCastMap([Q$Serializable, Q$AbstractConfigurationUpdate, Q$AbstractResourceConfigurationUpdate, Q$ResourceConfigurationUpdate]));
_.getAbstractGroupConfigurationUpdate = function getAbstractGroupConfigurationUpdate_0(){
  return this.groupConfigurationUpdate;
}
;
_.getResource = function getResource_0(){
  return this.resource;
}
;
function ResourceConfigurationComposite_0(resourceId, configuration){
  this.resourceId = resourceId;
  this.configuration = configuration;
}

defineSeed(948, 1, makeCastMap([Q$Serializable]), ResourceConfigurationComposite_0);
_.configuration = null;
_.resourceId = 0;
function serialize_120(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function serialize_121(streamWriter, instance){
  $writeObject(streamWriter, instance.configuration);
  $writeInt(streamWriter, instance.resourceId);
}

function $get_8(this$static, name_0){
  return dynamicCast(this$static.propertyDefinitions.get_2(name_0), Q$PropertyDefinition);
}

function $getConfigurationFormat(this$static){
  !this$static.configurationFormat && (this$static.configurationFormat = ($clinit_ConfigurationFormat() , STRUCTURED));
  return this$static.configurationFormat;
}

function $getDefaultTemplate(this$static){
  return dynamicCast((!this$static.templates && (this$static.templates = new LinkedHashMap_0) , this$static.templates).get_2('default'), Q$ConfigurationTemplate);
}

function $getGroupDefinitions(this$static){
  var group, group$iterator, groupSet, groups, propertyDefinition, propertyDefinition$iterator;
  groupSet = new HashSet_0;
  for (propertyDefinition$iterator = (!this$static.propertyDefinitions && (this$static.propertyDefinitions = new LinkedHashMap_0) , this$static.propertyDefinitions).values_0().iterator(); propertyDefinition$iterator.hasNext();) {
    propertyDefinition = dynamicCast(propertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    !!propertyDefinition.propertyGroupDefinition && $add_7(groupSet, propertyDefinition.propertyGroupDefinition);
  }
  groups = new ArrayList_1(groupSet.map_0.size_1());
  for (group$iterator = $iterator($keySet(groupSet.map_0)); group$iterator.val$outerIter.hasNext();) {
    group = dynamicCast($next_1(group$iterator), Q$PropertyGroupDefinition);
    groups.add_0(group);
  }
  sort_1(groups, new ConfigurationDefinition$GroupComparator_0);
  return groups;
}

function $getNonGroupedProperties(this$static){
  var propertyDefinition, propertyDefinition$iterator, propertyDefinitions;
  propertyDefinitions = new ArrayList_0;
  for (propertyDefinition$iterator = this$static.propertyDefinitions.values_0().iterator(); propertyDefinition$iterator.hasNext();) {
    propertyDefinition = dynamicCast(propertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    !propertyDefinition.propertyGroupDefinition && propertyDefinitions.add_0(propertyDefinition);
  }
  sort_1(propertyDefinitions, new ConfigurationDefinition$PropertyDefinitionComparator_0);
  return propertyDefinitions;
}

function $getPropertiesInGroup(this$static, groupName){
  var group, propertyDefinition, propertyDefinition$iterator, propertyDefinitions;
  propertyDefinitions = new ArrayList_0;
  for (propertyDefinition$iterator = this$static.propertyDefinitions.values_0().iterator(); propertyDefinition$iterator.hasNext();) {
    propertyDefinition = dynamicCast(propertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    group = propertyDefinition.propertyGroupDefinition;
    !!group && $equals_6(group.name_0, groupName) && propertyDefinitions.add_0(propertyDefinition);
  }
  sort_1(propertyDefinitions, new ConfigurationDefinition$PropertyDefinitionComparator_0);
  return propertyDefinitions;
}

function $put_6(this$static, propertyDefinition){
  !this$static.propertyDefinitions && (this$static.propertyDefinitions = new LinkedHashMap_0);
  this$static.propertyDefinitions.put(propertyDefinition.name_0, propertyDefinition);
  propertyDefinition.configurationDefinition = this$static;
}

function $setConfigurationFormat(this$static, configurationFormat){
  this$static.configurationFormat = configurationFormat;
}

function ConfigurationDefinition_1(name_0, description){
  $$init_10(this);
  this.name_0 = String(name_0);
  this.description = description;
}

defineSeed(954, 1, makeCastMap([Q$Serializable, Q$ConfigurationDefinition]), ConfigurationDefinition_1);
function $compare_0(group1, group2){
  return group1.order == group2.order?compareTo_11(group1.name_0, group2.name_0):$compareTo_5(valueOf_49(group1.order), valueOf_49(group2.order));
}

function ConfigurationDefinition$GroupComparator_0(){
}

defineSeed(955, 1, makeCastMap([Q$Comparator]), ConfigurationDefinition$GroupComparator_0);
_.compare = function compare_2(group1, group2){
  return $compare_0(dynamicCast(group1, Q$PropertyGroupDefinition), dynamicCast(group2, Q$PropertyGroupDefinition));
}
;
function $compare_1(propDef1, propDef2){
  return propDef1.order == propDef2.order?compareTo_11(propDef1.name_0, propDef2.name_0):$compareTo_5(valueOf_49(propDef1.order), valueOf_49(propDef2.order));
}

function ConfigurationDefinition$PropertyDefinitionComparator_0(){
}

defineSeed(956, 1, makeCastMap([Q$Comparator]), ConfigurationDefinition$PropertyDefinitionComparator_0);
_.compare = function compare_3(propDef1, propDef2){
  return $compare_1(dynamicCast(propDef1, Q$PropertyDefinition), dynamicCast(propDef2, Q$PropertyDefinition));
}
;
function ConfigurationTemplate_1(){
  this.name_0 = 'default';
  this.description = 'default template';
}

defineSeed(961, 1, makeCastMap([Q$Serializable, Q$ConfigurationTemplate]), ConfigurationTemplate_1);
function $setOrderIndex(this$static, orderIndex){
  this$static.orderIndex = orderIndex;
}

function PropertyDefinitionEnumeration_1(name_0, value){
  this.name_0 = name_0;
  this.value_0 = value;
}

defineSeed(963, 1, makeCastMap([Q$Serializable, Q$PropertyDefinitionEnumeration]), PropertyDefinitionEnumeration_1);
function $setMax_1(this$static, max){
  this$static.max_0 = max;
}

function $setMin_1(this$static, min){
  this$static.min_0 = min;
}

function PropertyDefinitionList_1(name_0, description, required, memberDefinition){
  PropertyDefinition_1.call(this, name_0, description, required);
  this.memberDefinition = memberDefinition;
  !!memberDefinition && (this.memberDefinition.parentPropertyListDefinition = this , undefined);
}

defineSeed(966, 930, makeCastMap([Q$Serializable, Q$PropertyDefinition, Q$PropertyDefinitionList]), PropertyDefinitionList_1);
function $get_9(this$static, name_0){
  return dynamicCast((!this$static.map_0 && (this$static.map_0 = new HashMap_0) , this$static.map_0).get_2(name_0), Q$PropertyDefinition);
}

function $getPropertyDefinitions(this$static){
  var key, key$iterator, map, orderComparator, result;
  map = (!this$static.map_0 && (this$static.map_0 = new HashMap_0) , this$static.map_0);
  if (map.size_1() <= 1) {
    return map;
  }
  orderComparator = new PropertyDefinitionMap$1_0(this$static);
  result = new TreeMap_1(orderComparator);
  for (key$iterator = map.keySet_0().iterator(); key$iterator.hasNext();) {
    key = dynamicCast(key$iterator.next_0(), Q$String);
    $put_2(result, key, dynamicCast(map.get_2(key), Q$PropertyDefinition));
  }
  return result;
}

function $put_7(this$static, propertyDefinition){
  var map, order, p, p$iterator, size;
  map = (!this$static.map_0 && (this$static.map_0 = new HashMap_0) , this$static.map_0);
  if (map.isEmpty_0()) {
    propertyDefinition.order = 0;
  }
   else {
    order = propertyDefinition.order;
    size = map.size_1();
    if (order <= 0 || order >= size) {
      propertyDefinition.order = size;
    }
     else {
      for (p$iterator = map.values_0().iterator(); p$iterator.hasNext();) {
        p = dynamicCast(p$iterator.next_0(), Q$PropertyDefinition);
        p.order >= order && $setOrder(p, p.order + 1);
      }
    }
  }
  map.put(propertyDefinition.name_0, propertyDefinition);
  propertyDefinition.parentPropertyMapDefinition = this$static;
}

function PropertyDefinitionMap_1(name_0, description, required, properties){
  var property, property$index, property$max;
  PropertyDefinition_1.call(this, name_0, description, required);
  if (properties != null) {
    for (property$index = 0 , property$max = properties.length; property$index < property$max; ++property$index) {
      property = properties[property$index];
      $put_7(this, property);
    }
  }
}

defineSeed(968, 930, makeCastMap([Q$Serializable, Q$PropertyDefinition, Q$PropertyDefinitionMap]), PropertyDefinitionMap_1);
function $compare_2(this$static, o1, o2){
  return $compareTo_5(valueOf_49($get_9(this$static.this$0, o1).order), valueOf_49($get_9(this$static.this$0, o2).order));
}

function PropertyDefinitionMap$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(969, 1, makeCastMap([Q$Comparator]), PropertyDefinitionMap$1_0);
_.compare = function compare_4(o1, o2){
  return $compare_2(this, dynamicCast(o1, Q$String), dynamicCast(o2, Q$String));
}
;
_.this$0 = null;
function $addConstraints(this$static, constraintsToAdd){
  var constraint, constraint$index, constraint$max;
  !this$static.constraints && (this$static.constraints = new HashSet_1(constraintsToAdd.length));
  for (constraint$index = 0 , constraint$max = constraintsToAdd.length; constraint$index < constraint$max; ++constraint$index) {
    constraint = constraintsToAdd[constraint$index];
    $getConstraints(this$static).add_0(constraint);
    constraint.propertyDefinitionSimple = this$static;
  }
}

function $addEnumeratedValues(this$static, enumerations){
  var enumeration, enumeration$index, enumeration$max;
  !this$static.enumeratedValues && (this$static.enumeratedValues = new ArrayList_1(1));
  for (enumeration$index = 0 , enumeration$max = enumerations.length; enumeration$index < enumeration$max; ++enumeration$index) {
    enumeration = enumerations[enumeration$index];
    enumeration.propertyDefinitionSimple = this$static;
    $getEnumeratedValues(this$static).add_0(enumeration);
  }
  $ensureOrdering(this$static);
}

function $ensureOrdering(this$static){
  var i, size;
  if (!this$static.enumeratedValues) {
    return;
  }
  for (i = 0 , size = $getEnumeratedValues(this$static).size_1(); i < size; ++i) {
    $setOrderIndex(dynamicCast($getEnumeratedValues(this$static).get_0(i), Q$PropertyDefinitionEnumeration), i);
  }
}

function $getConstraints(this$static){
  if (!this$static.constraints) {
    return $clinit_Collections() , EMPTY_SET;
  }
  return this$static.constraints;
}

function $getEnumeratedValues(this$static){
  if (!this$static.enumeratedValues) {
    return new ArrayList_1(1);
  }
  return this$static.enumeratedValues;
}

function $setDefaultValue_3(this$static, defaultValue){
  this$static.defaultValue = defaultValue;
}

function $setEnumeratedValues(this$static, enumeratedValues){
  $addEnumeratedValues(this$static, dynamicCast($toArray_1(enumeratedValues, initDim(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinitionEnumeration_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$PropertyDefinitionEnumeration_$1]), Q$PropertyDefinitionEnumeration, enumeratedValues.size_0, 0)), Q$PropertyDefinitionEnumeration_$1));
  this$static.allowCustomEnumeratedValue = false;
  $ensureOrdering(this$static);
}

function PropertyDefinitionSimple_1(name_0, description, required, type){
  PropertyDefinition_1.call(this, name_0, description, required);
  this.type_0 = type;
}

defineSeed(971, 930, makeCastMap([Q$Serializable, Q$PropertyDefinition, Q$PropertyDefinitionSimple]), PropertyDefinitionSimple_1);
function $setDefaultHidden(this$static, defaultHidden){
  this$static.defaultHidden = defaultHidden;
}

function $setDisplayName_0(this$static, displayName){
  this$static.displayName = displayName;
}

function PropertyGroupDefinition_1(name_0){
  this.name_0 = name_0;
}

defineSeed(974, 1, makeCastMap([Q$Serializable, Q$PropertyGroupDefinition]), PropertyGroupDefinition_1);
function IntegerRangeConstraint_1(minimum, maximum){
  var min, max;
  this.minimum = minimum;
  this.maximum = maximum;
  min = !this.minimum?'*':'' + toString_8(this.minimum.value_0);
  max = !this.maximum?'*':'' + toString_8(this.maximum.value_0);
  this.details = min + '#' + max;
}

defineSeed(992, 988, makeCastMap([Q$Serializable, Q$Constraint, Q$IntegerRangeConstraint]), IntegerRangeConstraint_1);
function deserialize_213(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_206(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_content_Architecture_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Architecture, size, 0);
}

function PackageVersionFormatDescription_0(){
}

defineSeed(1063, 1, makeCastMap([Q$Serializable, Q$PackageVersionFormatDescription]), PackageVersionFormatDescription_0);
_.fullFormatRegex = null;
_.osgiVersionExtractionRegex = null;
_.osgiVersionGroupIndex = 0;
_.textualDesctiption = null;
function deserialize_237(streamReader, instance){
  setFullFormatRegex(instance, $getString(streamReader, $readInt(streamReader)));
  setOsgiVersionExtractionRegex(instance, $getString(streamReader, $readInt(streamReader)));
  setOsgiVersionGroupIndex(instance, $readInt(streamReader));
  setTextualDesctiption(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_230(streamReader){
  return new PackageVersionFormatDescription_0;
}

function setFullFormatRegex(instance, value){
  instance.fullFormatRegex = value;
}

function setOsgiVersionExtractionRegex(instance, value){
  instance.osgiVersionExtractionRegex = value;
}

function setOsgiVersionGroupIndex(instance, value){
  instance.osgiVersionGroupIndex = value;
}

function setTextualDesctiption(instance, value){
  instance.textualDesctiption = value;
}

function PackageAndLatestVersionComposite_0(){
}

defineSeed(1098, 1, makeCastMap([Q$Serializable, Q$PackageAndLatestVersionComposite]), PackageAndLatestVersionComposite_0);
_.generalPackage = null;
_.latestPackageVersion = null;
function deserialize_257(streamReader, instance){
  setGeneralPackage_0(instance, dynamicCast($readObject(streamReader), Q$Package));
  setLatestPackageVersion(instance, dynamicCast($readObject(streamReader), Q$PackageVersion));
}

function instantiate_250(streamReader){
  return new PackageAndLatestVersionComposite_0;
}

function setGeneralPackage_0(instance, value){
  instance.generalPackage = value;
}

function setLatestPackageVersion(instance, value){
  instance.latestPackageVersion = value;
}

function PackageTypeAndVersionFormatComposite_0(){
}

defineSeed(1100, 1, makeCastMap([Q$Serializable, Q$PackageTypeAndVersionFormatComposite]), PackageTypeAndVersionFormatComposite_0);
_.packageType = null;
_.versionFormat = null;
function deserialize_258(streamReader, instance){
  setPackageType_1(instance, dynamicCast($readObject(streamReader), Q$PackageType));
  setVersionFormat(instance, dynamicCast($readObject(streamReader), Q$PackageVersionFormatDescription));
}

function instantiate_251(streamReader){
  return new PackageTypeAndVersionFormatComposite_0;
}

function setPackageType_1(instance, value){
  instance.packageType = value;
}

function setVersionFormat(instance, value){
  instance.versionFormat = value;
}

function $addRequiredPermissions(this$static, requiredPermissions){
  this$static.requiredPermissions = new Arrays$ArrayList_0(requiredPermissions);
}

function $getAlias(this$static){
  var className, classSimpleName;
  if (this$static.alias == null) {
    className = this$static.getPersistentClass().typeName;
    classSimpleName = $substring(className, className.lastIndexOf('.') + 1);
    this$static.alias = classSimpleName.toLowerCase();
  }
  return this$static.alias;
}

function $setRestriction(this$static, restriction){
  this$static.restriction = restriction;
}

function $setSearchExpression(this$static, searchExpression){
  this$static.searchExpression = searchExpression;
}

defineSeed(1106, 1, makeCastMap([Q$Serializable, Q$Criteria]));
_.getPageControlOverrides = function getPageControlOverrides(){
  return this.pageControlOverrides;
}
;
_.setPageControl = function setPageControl(pageControl){
  this.pageControlOverrides = pageControl;
}
;
function $addFilterEndTime(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterStartTime(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function $addSortStatus(this$static, sortStatus){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(115)) + 'tatus');
  this$static.sortStatus = sortStatus;
}

function AbstractConfigurationUpdateCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('startTime', 'createdTime >= ?');
  this.filterOverrides.put('endTime', 'createdTime <= ?');
  this.filterOverrides.put('statuses', 'status IN ( ? )');
}

defineSeed(1105, 1106, makeCastMap([Q$Serializable, Q$Criteria]));
_.fetchConfiguration = false;
_.filterEndTime = null;
_.filterStartTime = null;
_.filterStatus = null;
_.filterStatuses = null;
_.sortCreatedTime = null;
_.sortStatus = null;
function serialize_194(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchConfiguration);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.filterStatus);
  $writeObject(streamWriter, instance.filterStatuses);
  $writeObject(streamWriter, instance.sortCreatedTime);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_208(streamWriter, instance);
}

function $addFilterResourceGroupIds(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = filterResourceGroupIds;
}

function AbstractGroupConfigurationUpdateCriteria_0(){
  AbstractConfigurationUpdateCriteria_0.call(this);
  this.filterOverrides.put('resourceGroupIds', 'group.id IN ( ? )');
}

defineSeed(1108, 1105, makeCastMap([Q$Serializable, Q$Criteria]));
_.fetchConfigurationUpdates = false;
_.filterResourceGroupIds = null;
function serialize_195(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchConfigurationUpdates);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  serialize_194(streamWriter, instance);
}

function AbstractResourceConfigurationUpdateCriteria_0(){
  AbstractConfigurationUpdateCriteria_0.call(this);
}

defineSeed(1110, 1105, makeCastMap([Q$Serializable, Q$Criteria]));
function $addFilterAddress(this$static, filterAddress){
  this$static.filterAddress = filterAddress;
}

function $addFilterAffinityGroupId(this$static, filterAffinityGroupId){
  this$static.filterAffinityGroupId = filterAffinityGroupId;
}

function $addFilterAgenttoken(this$static, filterAgenttoken){
  this$static.filterAgenttoken = filterAgenttoken;
}

function $addFilterName(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterPort(this$static, filterPort){
  this$static.filterPort = filterPort;
}

function $addFilterServerId(this$static, filterServerId){
  this$static.filterServerId = filterServerId;
}

function AgentCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('serverId', 'server.id = ?');
  this.filterOverrides.put('affinityGroupId', 'affinityGroup.id = ?');
}

defineSeed(1111, 1106, makeCastMap([Q$Serializable, Q$AgentCriteria, Q$Criteria]), AgentCriteria_0);
_.getPersistentClass = function getPersistentClass(){
  return Lorg_rhq_core_domain_resource_Agent_2_classLit;
}
;
_.fetchAffinityGroup = false;
_.fetchServer = false;
_.filterAddress = null;
_.filterAffinityGroupId = null;
_.filterAgenttoken = null;
_.filterName = null;
_.filterPort = null;
_.filterServerId = null;
_.sortCtime = null;
_.sortName = null;
function serialize_196(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAffinityGroup);
  $writeBoolean(streamWriter, instance.fetchServer);
  $writeString(streamWriter, instance.filterAddress);
  $writeObject(streamWriter, instance.filterAffinityGroupId);
  $writeString(streamWriter, instance.filterAgenttoken);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPort);
  $writeObject(streamWriter, instance.filterServerId);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterEndTime_0(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterEntityContext(this$static, filterEntityContext){
  filterEntityContext.type_0 == ($clinit_EntityContext$Type() , Resource)?$addFilterResourceIds(this$static, initValues(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, [valueOf_49(filterEntityContext.resourceId)])):filterEntityContext.type_0 == ResourceGroup && $addFilterResourceGroupIds_0(this$static, initValues(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, [valueOf_49(filterEntityContext.groupId)]));
}

function $addFilterResourceGroupIds_0(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = getListIgnoringNulls(filterResourceGroupIds);
}

function $addFilterResourceIds(this$static, filterResourceIds){
  this$static.filterResourceIds = getListIgnoringNulls(filterResourceIds);
}

function $addFilterStartTime_0(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function AlertCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('triggeredOperationName', 'triggeredOperation like ?');
  this.filterOverrides.put('startTime', 'ctime >= ?');
  this.filterOverrides.put('endTime', 'ctime <= ?');
  this.filterOverrides.put('name', 'alertDefinition.name like ?');
  this.filterOverrides.put('description', 'alertDefinition.description like ?');
  this.filterOverrides.put('priorities', 'alertDefinition.priority IN ( ? )');
  this.filterOverrides.put('resourceTypeId', 'alertDefinition.resource.resourceType.id = ?');
  this.filterOverrides.put('resourceTypeName', 'alertDefinition.resource.resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'alertDefinition.resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'alertDefinition.resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.filterOverrides.put('alertDefinitionIds', 'alertDefinition.id IN ( ? )');
  this.filterOverrides.put('groupAlertDefinitionIds', 'alertDefinition.groupAlertDefinition.id IN ( ? )');
  this.filterOverrides.put('unacknowledgedOnly', 'acknowledgingSubject IS NULL');
  this.sortOverrides.put('name', 'alertDefinition.name');
  this.sortOverrides.put('priority', 'alertDefinition.priority');
  this.sortOverrides.put('resourceId', 'alertDefinition.resource.id');
  this.sortOverrides.put('resourceName', 'alertDefinition.resource.name');
  this.fetchConditionLogs = true;
}

defineSeed(1113, 1106, makeCastMap([Q$Serializable, Q$AlertCriteria, Q$Criteria]), AlertCriteria_0);
_.getPersistentClass = function getPersistentClass_0(){
  return Lorg_rhq_core_domain_alert_Alert_2_classLit;
}
;
_.fetchAlertDefinition = false;
_.fetchConditionLogs = false;
_.fetchNotificationLogs = false;
_.fetchRecoveryAlertDefinition = false;
_.filterAcknowledgingSubject = null;
_.filterAlertDefinitionIds = null;
_.filterDescription = null;
_.filterEndTime = null;
_.filterGroupAlertDefinitionIds = null;
_.filterName = null;
_.filterPriorities = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.filterStartTime = null;
_.filterTriggeredOperationName = null;
_.filterUnacknowledgedOnly = null;
_.sortCtime = null;
_.sortName = null;
_.sortPriority = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_197(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAlertDefinition);
  $writeBoolean(streamWriter, instance.fetchConditionLogs);
  $writeBoolean(streamWriter, instance.fetchNotificationLogs);
  $writeBoolean(streamWriter, instance.fetchRecoveryAlertDefinition);
  $writeString(streamWriter, instance.filterAcknowledgingSubject);
  $writeObject(streamWriter, instance.filterAlertDefinitionIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterGroupAlertDefinitionIds);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPriorities);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeString(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeString(streamWriter, instance.filterTriggeredOperationName);
  $writeObject(streamWriter, instance.filterUnacknowledgedOnly);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortPriority);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_208(streamWriter, instance);
}

function $addFilterAlertId(this$static, filterAlertId){
  this$static.filterAlertId = filterAlertId;
}

function $addFilterAlertTemplateResourceTypeId(this$static, filterAlertTemplateResourceTypeId){
  this$static.filterAlertTemplateResourceTypeId = filterAlertTemplateResourceTypeId;
}

function $addFilterResourceGroupIds_1(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function $addFilterResourceIds_0(this$static, filterResourceIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceIds);
}

function AlertDefinitionCriteria_0(){
  Criteria_4.call(this);
  this.filterDeleted = ($clinit_Boolean() , $clinit_Boolean() , FALSE);
  this.filterOverrides.put('alertId', 'id IN ( SELECT alert.alertDefinition.id           FROM Alert alert          WHERE alert.id = ? )');
  this.filterOverrides.put('alertTemplateOnly', 'resourceType IS NOT NULL');
  this.filterOverrides.put('alertTemplateParentId', 'parentId = ?');
  this.filterOverrides.put('alertTemplateResourceTypeId', 'resourceType.id = ?');
  this.filterOverrides.put('alertTemplateResourceTypeName', 'resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'group.id IN ( ? )');
  this.filterOverrides.put('groupAlertDefinitionId', 'groupAlertDefinition.id = ?');
  this.filterOverrides.put('groupAlertDefinitionGroupId', 'groupAlertDefinition.group.id = ?');
  this.filterOverrides.put('resourceOnly', 'resource IS NOT NULL');
  this.filterOverrides.put('notificationSenderNames', 'id IN (SELECT notif.alertDefinition.id FROM AlertNotification notif WHERE notif.senderName IN ( ? ))');
  this.sortOverrides.put('resourceId', 'resource.id');
  this.sortOverrides.put('resourceName', 'resource.name');
  this.fetchGroupAlertDefinition = true;
}

defineSeed(1115, 1106, makeCastMap([Q$Serializable, Q$AlertDefinitionCriteria, Q$Criteria]), AlertDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_1(){
  return Lorg_rhq_core_domain_alert_AlertDefinition_2_classLit;
}
;
_.fetchAlertNotifications = false;
_.fetchAlerts = false;
_.fetchConditions = false;
_.fetchGroupAlertDefinition = false;
_.fetchResource = false;
_.fetchResourceType = false;
_.filterAlertId = null;
_.filterAlertTemplateOnly = null;
_.filterAlertTemplateParentId = null;
_.filterAlertTemplateResourceTypeId = null;
_.filterAlertTemplateResourceTypeName = null;
_.filterDescription = null;
_.filterEnabled = null;
_.filterGroupAlertDefinitionGroupId = null;
_.filterGroupAlertDefinitionId = null;
_.filterName = null;
_.filterNotificationSenderNames = null;
_.filterPriority = null;
_.filterReadOnly = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceOnly = null;
_.sortName = null;
_.sortPriority = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_198(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAlertNotifications);
  $writeBoolean(streamWriter, instance.fetchAlerts);
  $writeBoolean(streamWriter, instance.fetchConditions);
  $writeBoolean(streamWriter, instance.fetchGroupAlertDefinition);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeBoolean(streamWriter, instance.fetchResourceType);
  $writeObject(streamWriter, instance.filterAlertId);
  $writeObject(streamWriter, instance.filterAlertTemplateOnly);
  $writeObject(streamWriter, instance.filterAlertTemplateParentId);
  $writeObject(streamWriter, instance.filterAlertTemplateResourceTypeId);
  $writeString(streamWriter, instance.filterAlertTemplateResourceTypeName);
  $writeObject(streamWriter, instance.filterDeleted);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterEnabled);
  $writeObject(streamWriter, instance.filterGroupAlertDefinitionGroupId);
  $writeObject(streamWriter, instance.filterGroupAlertDefinitionId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterNotificationSenderNames);
  $writeObject(streamWriter, instance.filterPriority);
  $writeObject(streamWriter, instance.filterReadOnly);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterResourceOnly);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortPriority);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_208(streamWriter, instance);
}

function serialize_199(streamWriter, instance){
  $writeBoolean(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  serialize_208(streamWriter, instance);
}

function $addFilterTagName(this$static, filterTagName){
  if (filterTagName == null) {
    return;
  }
  !this$static.filterTag && (this$static.filterTag = new Tag_0);
  $setName_13(this$static.filterTag, filterTagName);
}

function $addFilterTagNamespace(this$static, filterTagNamespace){
  if (filterTagNamespace == null) {
    return;
  }
  !this$static.filterTag && (this$static.filterTag = new Tag_0);
  $setNamespace(this$static.filterTag, filterTagNamespace);
}

function $addFilterTagSemantic(this$static, filterTagSemantic){
  if (filterTagSemantic == null) {
    return;
  }
  !this$static.filterTag && (this$static.filterTag = new Tag_0);
  $setSemantic(this$static.filterTag, filterTagSemantic);
}

function $addFilterBundleTypeId(this$static, filterBundleTypeId){
  this$static.filterBundleTypeId = filterBundleTypeId;
}

function $addFilterName_0(this$static, filterName){
  this$static.filterName = filterName;
}

function BundleCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleVersionIds', 'id IN ( SELECT bv.bundle.id           FROM BundleVersion bv          WHERE bv.id IN ( ? ) )');
  this.filterOverrides.put('bundleTypeId', 'bundleType.id = ?');
  this.filterOverrides.put('bundleTypeName', 'bundleType.name like ?');
  this.filterOverrides.put('bundleGroupIds', 'id IN ( SELECT innerbundle.id           FROM Bundle innerbundle           JOIN innerbundle.bundleGroups bg         WHERE bg.id IN ( ? ) )');
  this.filterOverrides.put('destinationIds', 'id IN ( SELECT bd.bundle.id           FROM BundleDestination bd          WHERE bd.id IN ( ? ) )');
  this.filterOverrides.put('packageTypeId', 'packageType.id = ?');
  this.filterOverrides.put('packageTypeName', 'packageType.name like ?');
}

defineSeed(1118, 1119, makeCastMap([Q$Serializable, Q$BundleCriteria, Q$Criteria]), BundleCriteria_0);
_.getPersistentClass = function getPersistentClass_2(){
  return Lorg_rhq_core_domain_bundle_Bundle_2_classLit;
}
;
_.fetchBundleGroups = false;
_.fetchBundleVersions = false;
_.fetchDestinations = false;
_.fetchPackageType = false;
_.fetchRepo = false;
_.filterBundleGroupIds = null;
_.filterBundleTypeId = null;
_.filterBundleTypeName = null;
_.filterBundleVersionIds = null;
_.filterDescription = null;
_.filterDestinationIds = null;
_.filterName = null;
_.filterPackageTypeId = null;
_.filterPackageTypeName = null;
_.sortDescription = null;
_.sortName = null;
function serialize_200(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleGroups);
  $writeBoolean(streamWriter, instance.fetchBundleVersions);
  $writeBoolean(streamWriter, instance.fetchDestinations);
  $writeBoolean(streamWriter, instance.fetchPackageType);
  $writeBoolean(streamWriter, instance.fetchRepo);
  $writeObject(streamWriter, instance.filterBundleGroupIds);
  $writeObject(streamWriter, instance.filterBundleTypeId);
  $writeString(streamWriter, instance.filterBundleTypeName);
  $writeObject(streamWriter, instance.filterBundleVersionIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterDestinationIds);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPackageTypeId);
  $writeString(streamWriter, instance.filterPackageTypeName);
  $writeObject(streamWriter, instance.sortDescription);
  $writeObject(streamWriter, instance.sortName);
  serialize_244(streamWriter, instance);
}

function $addFilterBundleId(this$static, filterBundleId){
  this$static.filterBundleId = filterBundleId;
}

function $addFilterBundleVersionId(this$static, filterBundleVersionId){
  this$static.filterBundleVersionId = filterBundleVersionId;
}

function $addFilterDestinationId(this$static, filterDestinationId){
  this$static.filterDestinationId = filterDestinationId;
}

function $addFilterIsLive(this$static, filterIsLive){
  this$static.filterIsLive = filterIsLive;
}

function $addSortStatus_0(this$static, sortStatus){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(115)) + 'ort');
  this$static.sortStatus = sortStatus;
}

function BundleDeploymentCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleId', 'bundleVersion.bundle.id = ?');
  this.filterOverrides.put('bundleVersionId', 'bundleVersion.id = ?');
  this.filterOverrides.put('destinationId', 'destination.id = ?');
  this.filterOverrides.put('destinationName', 'destination.name like ?');
}

defineSeed(1121, 1119, makeCastMap([Q$Serializable, Q$BundleDeploymentCriteria, Q$Criteria]), BundleDeploymentCriteria_0);
_.getPersistentClass = function getPersistentClass_3(){
  return Lorg_rhq_core_domain_bundle_BundleDeployment_2_classLit;
}
;
_.fetchBundleVersion = false;
_.fetchConfiguration = false;
_.fetchDestination = false;
_.fetchResourceDeployments = false;
_.filterBundleId = null;
_.filterBundleVersionId = null;
_.filterDescription = null;
_.filterDestinationId = null;
_.filterDestinationName = null;
_.filterIsLive = null;
_.filterName = null;
_.filterStatus = null;
_.filterSubjectName = null;
_.sortStatus = null;
function serialize_201(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleVersion);
  $writeBoolean(streamWriter, instance.fetchConfiguration);
  $writeBoolean(streamWriter, instance.fetchDestination);
  $writeBoolean(streamWriter, instance.fetchResourceDeployments);
  $writeObject(streamWriter, instance.filterBundleId);
  $writeObject(streamWriter, instance.filterBundleVersionId);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterDestinationId);
  $writeString(streamWriter, instance.filterDestinationName);
  $writeObject(streamWriter, instance.filterIsLive);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterStatus);
  $writeString(streamWriter, instance.filterSubjectName);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_244(streamWriter, instance);
}

function $addFilterBundleId_0(this$static, filterBundleId){
  this$static.filterBundleId = filterBundleId;
}

function BundleDestinationCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleId', 'bundle.id = ?');
  this.filterOverrides.put('bundleVersionId', 'deployments.bundleVersion.id = ?');
  this.filterOverrides.put('status', 'deployment.status like ?');
  this.filterOverrides.put('groupId', 'group.id = ?');
}

defineSeed(1123, 1119, makeCastMap([Q$Serializable, Q$BundleDestinationCriteria, Q$Criteria]), BundleDestinationCriteria_0);
_.getPersistentClass = function getPersistentClass_4(){
  return Lorg_rhq_core_domain_bundle_BundleDestination_2_classLit;
}
;
_.fetchBundle = false;
_.fetchDeployments = false;
_.fetchGroup = false;
_.filterBundleId = null;
_.filterBundleVersionId = null;
_.filterDeployDir = null;
_.filterDescription = null;
_.filterGroupId = null;
_.filterName = null;
_.filterStatus = null;
function serialize_202(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundle);
  $writeBoolean(streamWriter, instance.fetchDeployments);
  $writeBoolean(streamWriter, instance.fetchGroup);
  $writeObject(streamWriter, instance.filterBundleId);
  $writeObject(streamWriter, instance.filterBundleVersionId);
  $writeString(streamWriter, instance.filterDeployDir);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterGroupId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterStatus);
  serialize_244(streamWriter, instance);
}

function $addFilterBundleVersionId_0(this$static, filterBundleVersionId){
  this$static.filterBundleVersionId = filterBundleVersionId;
}

function BundleFileCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('bundleVersionId', 'bundleVersion.id = ?');
  this.filterOverrides.put('packageVersionId', 'packageVersion.id = ?');
}

defineSeed(1125, 1106, makeCastMap([Q$Serializable, Q$Criteria]), BundleFileCriteria_0);
_.getPersistentClass = function getPersistentClass_5(){
  return Lorg_rhq_core_domain_bundle_BundleFile_2_classLit;
}
;
_.fetchBundleVersion = false;
_.fetchPackageVersion = false;
_.filterBundleVersionId = null;
_.filterPackageVersionId = null;
function serialize_203(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleVersion);
  $writeBoolean(streamWriter, instance.fetchPackageVersion);
  $writeObject(streamWriter, instance.filterBundleVersionId);
  $writeObject(streamWriter, instance.filterPackageVersionId);
  serialize_208(streamWriter, instance);
}

function $addFilterBundleIds(this$static, filterBundleIds){
  this$static.filterBundleIds = getListIgnoringNulls(filterBundleIds);
}

function $addFilterName_1(this$static, filterName){
  this$static.filterName = filterName;
}

function BundleGroupCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('bundleIds', 'id IN ( SELECT bg.id           FROM Bundle b           JOIN b.bundleGroups bg         WHERE b.id IN ( ? ) )');
  this.filterOverrides.put('roleIds', 'id IN ( SELECT bg.id           FROM Role r           JOIN r.bundleGroups bg         WHERE r.id IN ( ? ) )');
}

defineSeed(1127, 1106, makeCastMap([Q$Serializable, Q$BundleGroupCriteria, Q$Criteria]), BundleGroupCriteria_0);
_.getPersistentClass = function getPersistentClass_6(){
  return Lorg_rhq_core_domain_bundle_BundleGroup_2_classLit;
}
;
_.fetchBundles = false;
_.fetchRoles = false;
_.filterBundleIds = null;
_.filterDescription = null;
_.filterName = null;
_.filterRoleIds = null;
_.sortDescription = null;
_.sortName = null;
function serialize_204(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundles);
  $writeBoolean(streamWriter, instance.fetchRoles);
  $writeObject(streamWriter, instance.filterBundleIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterRoleIds);
  $writeObject(streamWriter, instance.sortDescription);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterBundleDeploymentId(this$static, filterBundleDeploymentId){
  this$static.filterBundleDeploymentId = filterBundleDeploymentId;
}

function BundleResourceDeploymentCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('bundleDeploymentId', 'bundleDeployment.id = ?');
  this.filterOverrides.put('bundleDeploymentName', 'bundleDeployment.name like ?');
  this.filterOverrides.put('resourceId', 'resource.id = ?');
  this.filterOverrides.put('resourceName', 'resource.name like ?');
}

defineSeed(1129, 1106, makeCastMap([Q$Serializable, Q$Criteria]), BundleResourceDeploymentCriteria_0);
_.getPersistentClass = function getPersistentClass_7(){
  return Lorg_rhq_core_domain_bundle_BundleResourceDeployment_2_classLit;
}
;
_.fetchBundleDeployment = false;
_.fetchHistories = false;
_.fetchResource = false;
_.filterBundleDeploymentId = null;
_.filterBundleDeploymentName = null;
_.filterResourceId = null;
_.filterResourceName = null;
_.filterStatus = null;
function serialize_205(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleDeployment);
  $writeBoolean(streamWriter, instance.fetchHistories);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterBundleDeploymentId);
  $writeString(streamWriter, instance.filterBundleDeploymentName);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeString(streamWriter, instance.filterResourceName);
  $writeObject(streamWriter, instance.filterStatus);
  serialize_208(streamWriter, instance);
}

function $addFilterBundleId_1(this$static, filterBundleId){
  this$static.filterBundleId = filterBundleId;
}

function BundleVersionCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleId', 'bundle.id = ?');
  this.filterOverrides.put('bundleName', 'bundle.name like ?');
}

defineSeed(1131, 1119, makeCastMap([Q$Serializable, Q$BundleVersionCriteria, Q$Criteria]), BundleVersionCriteria_0);
_.getPersistentClass = function getPersistentClass_8(){
  return Lorg_rhq_core_domain_bundle_BundleVersion_2_classLit;
}
;
_.fetchBundle = false;
_.fetchBundleDeployments = false;
_.fetchBundleFiles = false;
_.fetchConfigurationDefinition = false;
_.filterBundleId = null;
_.filterBundleName = null;
_.filterDescription = null;
_.filterName = null;
_.filterVersion = null;
function serialize_206(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundle);
  $writeBoolean(streamWriter, instance.fetchBundleDeployments);
  $writeBoolean(streamWriter, instance.fetchBundleFiles);
  $writeBoolean(streamWriter, instance.fetchConfigurationDefinition);
  $writeObject(streamWriter, instance.filterBundleId);
  $writeString(streamWriter, instance.filterBundleName);
  $writeString(streamWriter, instance.filterDescription);
  $writeString(streamWriter, instance.filterName);
  $writeString(streamWriter, instance.filterVersion);
  serialize_244(streamWriter, instance);
}

function $addFilterBeginTime(this$static, filterBeginTime){
  this$static.filterBeginTime = filterBeginTime;
}

function $addFilterEndTime_1(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function CallTimeDataCriteria_0(){
  Criteria_4.call(this);
  this.filterDataType = ($clinit_DataType() , CALLTIME);
  this.filterOverrides.put('resourceId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData    WHERE callData.key.schedule.resource.id = ? )');
  this.filterOverrides.put('resourceGroupId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData, Resource res     JOIN res.implicitGroups ig    WHERE callData.key.schedule.resource.id = res.id      AND ig.id = ? ) ');
  this.filterOverrides.put('autoGroupResourceTypeId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData, Resource res    WHERE callData.key.schedule.resource.id = res.id      AND res.resourceType.id = ? )');
  this.filterOverrides.put('autoGroupParentResourceId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData, Resource res    WHERE callData.key.schedule.resource.id = res.id      AND res.parentResource.id = ? )');
  this.filterOverrides.put('beginTime', 'beginTime > ?');
  this.filterOverrides.put('endTime', 'endTime < ?');
  this.filterOverrides.put('destination', 'key.callDestination like ?');
  this.filterOverrides.put('dataType', 'key.schedule.definition.dataType = ?');
  this.sortOverrides.put('minimum', 'MIN(' + $getAlias(this) + '.minimum)');
  this.sortOverrides.put('maximum', 'MAX(' + $getAlias(this) + '.maximum)');
  this.sortOverrides.put('average', '(SUM(' + $getAlias(this) + '.total) / SUM(' + $getAlias(this) + '.count))');
  this.sortOverrides.put('total', 'SUM(' + $getAlias(this) + '.total)');
  this.sortOverrides.put('count', 'SUM(' + $getAlias(this) + '.count)');
}

defineSeed(1133, 1106, makeCastMap([Q$Serializable, Q$CallTimeDataCriteria, Q$Criteria]), CallTimeDataCriteria_0);
_.getPersistentClass = function getPersistentClass_9(){
  return Lorg_rhq_core_domain_measurement_calltime_CallTimeDataValue_2_classLit;
}
;
_.filterAutoGroupParentResourceId = null;
_.filterAutoGroupResourceTypeId = null;
_.filterBeginTime = null;
_.filterCount = null;
_.filterDestination = null;
_.filterEndTime = null;
_.filterMaximum = null;
_.filterMinimum = null;
_.filterResourceGroupId = null;
_.filterResourceId = null;
_.filterTotal = null;
_.sortAverage = null;
_.sortCount = null;
_.sortMaximum = null;
_.sortMinimum = null;
_.sortTotal = null;
function serialize_207(streamWriter, instance){
  $writeObject(streamWriter, instance.filterAutoGroupParentResourceId);
  $writeObject(streamWriter, instance.filterAutoGroupResourceTypeId);
  $writeObject(streamWriter, instance.filterBeginTime);
  $writeObject(streamWriter, instance.filterCount);
  $writeObject(streamWriter, instance.filterDataType);
  $writeString(streamWriter, instance.filterDestination);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterMaximum);
  $writeObject(streamWriter, instance.filterMinimum);
  $writeObject(streamWriter, instance.filterResourceGroupId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterTotal);
  $writeObject(streamWriter, instance.sortAverage);
  $writeObject(streamWriter, instance.sortCount);
  $writeObject(streamWriter, instance.sortMaximum);
  $writeObject(streamWriter, instance.sortMinimum);
  $writeObject(streamWriter, instance.sortTotal);
  serialize_208(streamWriter, instance);
}

function $addFilterCategory(this$static, category){
  this$static.filterCategory = category;
}

function $addFilterGroupId(this$static, filterGroupId){
  this$static.filterGroupId = filterGroupId;
}

function $addFilterResourceId(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function $addSortName(this$static, sortName){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(110)) + 'ame');
  this$static.sortName = sortName;
}

function DashboardCriteria_0(){
  Criteria_4.call(this);
  this.filterCategory = ($clinit_DashboardCategory() , INVENTORY);
  this.filterOverrides.put('groupId', 'group.id = ?');
  this.filterOverrides.put('ownerId', 'owner.id = ?');
  this.filterOverrides.put('resourceId', 'resource.id = ?');
}

defineSeed(1142, 1106, makeCastMap([Q$Serializable, Q$Criteria]), DashboardCriteria_0);
_.getPersistentClass = function getPersistentClass_10(){
  return Lorg_rhq_core_domain_dashboard_Dashboard_2_classLit;
}
;
_.fetchConfiguration = false;
_.fetchOwner = false;
_.filterGroupId = null;
_.filterName = null;
_.filterOwnerId = null;
_.filterResourceId = null;
_.filterShared = null;
_.sortName = null;
function serialize_211(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchConfiguration);
  $writeBoolean(streamWriter, instance.fetchOwner);
  $writeObject(streamWriter, instance.filterCategory);
  $writeObject(streamWriter, instance.filterGroupId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterOwnerId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterShared);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterResourceIds_1(this$static, filterResourceIds){
  this$static.filterResourceIds = getListIgnoringNulls(filterResourceIds);
}

function $addFilterTemplateId(this$static, filterTemplateId){
  this$static.filterTemplateId = filterTemplateId;
}

function $fetchConfiguration(this$static, fetchConfiguration){
  this$static.fetchConfiguration = fetchConfiguration;
}

function $fetchResource(this$static, fetchResource){
  this$static.fetchResource = fetchResource;
}

function $fetchTemplate(this$static, fetchTemplate){
  this$static.fetchTemplate = fetchTemplate;
}

function DriftDefinitionCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('templateId', 'template.id = ?');
}

defineSeed(1144, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$DriftDefinitionCriteria]), DriftDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_11(){
  return Lorg_rhq_core_domain_drift_DriftDefinition_2_classLit;
}
;
_.fetchConfiguration = null;
_.fetchResource = null;
_.fetchTemplate = null;
_.filterName = null;
_.filterResourceIds = null;
_.filterTemplateId = null;
_.sortName = null;
function serialize_212(streamWriter, instance){
  $writeObject(streamWriter, instance.fetchConfiguration);
  $writeObject(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.fetchTemplate);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterTemplateId);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterResourceTypeId(this$static, filterResourceTypeId){
  this$static.filterResourceTypeId = filterResourceTypeId;
}

function DriftDefinitionTemplateCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceTypeId', 'resourceType.id = ?');
}

defineSeed(1146, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$DriftDefinitionTemplateCriteria]), DriftDefinitionTemplateCriteria_0);
_.getPersistentClass = function getPersistentClass_12(){
  return Lorg_rhq_core_domain_drift_DriftDefinitionTemplate_2_classLit;
}
;
_.fetchDriftDefinitions = false;
_.fetchResourceType = false;
_.filterName = null;
_.filterResourceTypeId = null;
function serialize_213(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchDriftDefinitions);
  $writeBoolean(streamWriter, instance.fetchResourceType);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  serialize_208(streamWriter, instance);
}

function $addFilterAutoGroupParentResourceId(this$static, filterAutoGroupParentResourceId){
  this$static.filterAutoGroupParentResourceId = filterAutoGroupParentResourceId;
}

function $addFilterAutoGroupResourceTypeId(this$static, filterAutoGroupResourceTypeId){
  this$static.filterAutoGroupResourceTypeId = filterAutoGroupResourceTypeId;
}

function $addFilterDetail(this$static, filterDetail){
  this$static.filterDetail = filterDetail;
}

function $addFilterEndTime_2(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterEntityContext_0(this$static, filterEntityContext){
  if (filterEntityContext.type_0 == ($clinit_EntityContext$Type() , Resource)) {
    $addFilterResourceId_0(this$static, valueOf_49(filterEntityContext.resourceId));
  }
   else if (filterEntityContext.type_0 == ResourceGroup) {
    $addFilterResourceGroupId(this$static, valueOf_49(filterEntityContext.groupId));
  }
   else if (filterEntityContext.type_0 == AutoGroup) {
    $addFilterAutoGroupParentResourceId(this$static, valueOf_49(filterEntityContext.parentResourceId));
    $addFilterAutoGroupResourceTypeId(this$static, valueOf_49(filterEntityContext.resourceTypeId));
  }
}

function $addFilterResourceGroupId(this$static, filterResourceGroupId){
  this$static.filterResourceGroupId = filterResourceGroupId;
}

function $addFilterResourceId_0(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function $addFilterSourceName(this$static, filterSourceName){
  this$static.filterSourceName = filterSourceName;
}

function $addFilterStartTime_1(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function EventCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('sourceName', 'source.location like ?');
  this.filterOverrides.put('sourceId', 'source.id = ?');
  this.filterOverrides.put('startTime', 'timestamp >= ?');
  this.filterOverrides.put('endTime', 'timestamp <= ?');
  this.filterOverrides.put('resourceId', 'source.resourceId = ?');
  this.filterOverrides.put('resourceGroupId', 'source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.implicitGroups ig    WHERE ig.id = ? )');
  this.filterOverrides.put('autoGroupResourceTypeId', 'source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.resourceType type    WHERE type.id = ? )');
  this.filterOverrides.put('autoGroupParentResourceId', 'source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.parentResource parent    WHERE parent.id = ? )');
  this.filterOverrides.put('severities', 'severity IN ( ? )');
}

defineSeed(1148, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$EventCriteria]), EventCriteria_0);
_.getPersistentClass = function getPersistentClass_13(){
  return Lorg_rhq_core_domain_event_Event_2_classLit;
}
;
_.fetchSource = false;
_.filterAutoGroupParentResourceId = null;
_.filterAutoGroupResourceTypeId = null;
_.filterDetail = null;
_.filterEndTime = null;
_.filterResourceGroupId = null;
_.filterResourceId = null;
_.filterSeverities = null;
_.filterSourceId = null;
_.filterSourceName = null;
_.filterStartTime = null;
_.sortSeverity = null;
_.sortTimestamp = null;
function serialize_214(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchSource);
  $writeObject(streamWriter, instance.filterAutoGroupParentResourceId);
  $writeObject(streamWriter, instance.filterAutoGroupResourceTypeId);
  $writeString(streamWriter, instance.filterDetail);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterResourceGroupId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterSeverities);
  $writeObject(streamWriter, instance.filterSourceId);
  $writeString(streamWriter, instance.filterSourceName);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.sortSeverity);
  $writeObject(streamWriter, instance.sortTimestamp);
  serialize_208(streamWriter, instance);
}

function $addFilterDriftDefinitionId(this$static, filterDriftDefId){
  this$static.filterDriftDefId = filterDriftDefId;
}

function $addSortVersion(this$static, sortVersion){
  this$static.sortVersion = sortVersion;
}

function GenericDriftChangeSetCriteria_0(){
}

defineSeed(1150, 1, makeCastMap([Q$Serializable, Q$GenericDriftChangeSetCriteria]), GenericDriftChangeSetCriteria_0);
_.getPageControlOverrides = function getPageControlOverrides_0(){
  return this.pageControl;
}
;
_.setPageControl = function setPageControl_0(pageControl){
  this.pageControl = pageControl;
}
;
_.fetchDrifts = false;
_.filterCategory = null;
_.filterCreatedAfter = null;
_.filterCreatedBefore = null;
_.filterDriftCategories = null;
_.filterDriftDefId = null;
_.filterDriftDirectory = null;
_.filterDriftPath = null;
_.filterEndVersion = null;
_.filterId = null;
_.filterResourceId = null;
_.filterStartVersion = null;
_.filterVersion = null;
_.pageControl = null;
_.sortId = null;
_.sortVersion = null;
_.strict = false;
function serialize_215(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchDrifts);
  $writeObject(streamWriter, instance.filterCategory);
  $writeObject(streamWriter, instance.filterCreatedAfter);
  $writeObject(streamWriter, instance.filterCreatedBefore);
  $writeObject(streamWriter, instance.filterDriftCategories);
  $writeObject(streamWriter, instance.filterDriftDefId);
  $writeString(streamWriter, instance.filterDriftDirectory);
  $writeString(streamWriter, instance.filterDriftPath);
  $writeString(streamWriter, instance.filterEndVersion);
  $writeString(streamWriter, instance.filterId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeString(streamWriter, instance.filterStartVersion);
  $writeString(streamWriter, instance.filterVersion);
  $writeObject(streamWriter, instance.pageControl);
  $writeObject(streamWriter, instance.sortId);
  $writeObject(streamWriter, instance.sortVersion);
  $writeBoolean(streamWriter, instance.strict);
}

function $addFilterChangeSetId(this$static, filterChangeSetId){
  this$static.filterChangeSetId = filterChangeSetId;
}

function $addFilterChangeSetStartVersion(this$static, filterChangeSetStartVersion){
  this$static.filterChangeSetStartVersion = filterChangeSetStartVersion;
}

function $addFilterDriftHandlingModes(this$static, filterDriftHandlingModes){
  this$static.filterDriftHandlingModes = getListIgnoringNulls(filterDriftHandlingModes);
}

function $addFilterEndTime_3(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterResourceIds_2(this$static, filterResourceIds){
  this$static.filterResourceIds = getListIgnoringNulls(filterResourceIds);
}

function $addFilterStartTime_2(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function GenericDriftCriteria_0(){
  this.filterCategories = new ArrayList_0;
  this.filterDriftHandlingModes = new ArrayList_0;
  this.filterResourceIds = new ArrayList_0;
}

defineSeed(1152, 1, makeCastMap([Q$Serializable, Q$GenericDriftCriteria]), GenericDriftCriteria_0);
_.getPageControlOverrides = function getPageControlOverrides_1(){
  return this.pageControl;
}
;
_.setPageControl = function setPageControl_1(pageControl){
  this.pageControl = pageControl;
}
;
_.fetchChangeSet = false;
_.filterChangeSetEndVersion = null;
_.filterChangeSetId = null;
_.filterChangeSetStartVersion = null;
_.filterDirectory = null;
_.filterDriftDefinitionId = null;
_.filterEndTime = null;
_.filterId = null;
_.filterPath = null;
_.filterStartTime = null;
_.pageControl = null;
_.sortCtime = null;
_.sortId = null;
_.strict = false;
function serialize_216(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchChangeSet);
  $writeObject(streamWriter, instance.filterCategories);
  $writeObject(streamWriter, instance.filterChangeSetEndVersion);
  $writeString(streamWriter, instance.filterChangeSetId);
  $writeObject(streamWriter, instance.filterChangeSetStartVersion);
  $writeString(streamWriter, instance.filterDirectory);
  $writeObject(streamWriter, instance.filterDriftDefinitionId);
  $writeObject(streamWriter, instance.filterDriftHandlingModes);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeString(streamWriter, instance.filterId);
  $writeString(streamWriter, instance.filterPath);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.pageControl);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortId);
  $writeBoolean(streamWriter, instance.strict);
}

function $addFilterResourceGroupIds_2(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function GroupBundleDeploymentCriteria_0(){
  BundleDeploymentCriteria_0.call(this);
  this.filterOverrides.put('resourceGroupIds', 'destination.group.id IN ( SELECT rg.id     FROM ResourceGroup rg     JOIN rg.bundleDestinations bds    WHERE rg.id = ? )');
}

defineSeed(1154, 1121, makeCastMap([Q$Serializable, Q$BundleDeploymentCriteria, Q$Criteria]), GroupBundleDeploymentCriteria_0);
_.filterResourceGroupIds = null;
function serialize_217(streamWriter, instance){
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  serialize_201(streamWriter, instance);
}

function $addFilterEndTime_4(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterStartTime_3(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function $addSortEndTime(this$static, sortEndTime){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(101)) + 'ndTime');
  this$static.sortEndTime = sortEndTime;
}

function OperationHistoryCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('operationDefinitionId', 'operationDefinition.id = ?');
  this.filterOverrides.put('operationName', 'operationDefinition.name like ?');
  this.filterOverrides.put('startTime', 'startedTime >= ?');
  this.filterOverrides.put('endTime', 'modifiedTime <= ?');
  this.filterOverrides.put('resourceIds', 'id IN  ( SELECT roh.id      FROM ResourceOperationHistory roh     WHERE roh.resource.id IN ( ? ) ) ');
  this.filterOverrides.put('statuses', 'status IN ( ? )');
  this.sortOverrides.put('startTime', 'startedTime');
  this.sortOverrides.put('endTime', 'modifiedTime');
  this.sortOverrides.put('operationName', 'operationDefinition.name');
}

defineSeed(1157, 1106, makeCastMap([Q$Serializable, Q$Criteria]));
_.getPersistentClass = function getPersistentClass_14(){
  return Lorg_rhq_core_domain_operation_OperationHistory_2_classLit;
}
;
_.fetchOperationDefinition = false;
_.fetchParameters = false;
_.filterEndTime = null;
_.filterErrorMessage = null;
_.filterJobGroup = null;
_.filterJobName = null;
_.filterOperationDefinitionId = null;
_.filterOperationName = null;
_.filterStartTime = null;
_.filterStatus = null;
_.filterStatuses = null;
_.sortEndTime = null;
_.sortOperationName = null;
_.sortStartTime = null;
_.sortStatus = null;
function $addFilterResourceGroupIds_3(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = filterResourceGroupIds;
}

function GroupOperationHistoryCriteria_0(){
  OperationHistoryCriteria_0.call(this);
  this.filterOverrides.put('resourceGroupIds', 'group.id IN ( ? )');
}

defineSeed(1156, 1157, makeCastMap([Q$Serializable, Q$Criteria, Q$GroupOperationHistoryCriteria]), GroupOperationHistoryCriteria_0);
_.getPersistentClass = function getPersistentClass_15(){
  return Lorg_rhq_core_domain_operation_GroupOperationHistory_2_classLit;
}
;
_.filterResourceGroupIds = null;
function serialize_218(streamWriter, instance){
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  serialize_225(streamWriter, instance);
}

function GroupPluginConfigurationUpdateCriteria_0(){
  AbstractGroupConfigurationUpdateCriteria_0.call(this);
}

defineSeed(1159, 1108, makeCastMap([Q$Serializable, Q$Criteria, Q$GroupPluginConfigurationUpdateCriteria]), GroupPluginConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_16(){
  return Lorg_rhq_core_domain_configuration_group_GroupPluginConfigurationUpdate_2_classLit;
}
;
function serialize_219(streamWriter, instance){
  serialize_195(streamWriter, instance);
}

function GroupResourceConfigurationUpdateCriteria_0(){
  AbstractGroupConfigurationUpdateCriteria_0.call(this);
}

defineSeed(1161, 1108, makeCastMap([Q$Serializable, Q$Criteria, Q$GroupResourceConfigurationUpdateCriteria]), GroupResourceConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_17(){
  return Lorg_rhq_core_domain_configuration_group_GroupResourceConfigurationUpdate_2_classLit;
}
;
function serialize_220(streamWriter, instance){
  serialize_195(streamWriter, instance);
}

function $addFilterResourceGroupIds_4(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function $addFilterResourceId_1(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function $addSortStatus_1(this$static, sortStatus){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(115)) + 'ort');
  this$static.sortStatus = sortStatus;
}

function InstalledPackageHistoryCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('installationTimeMinimum', 'installationDate >= ?');
  this.filterOverrides.put('installationTimeMaximum', 'installationDate <= ?');
  this.filterOverrides.put('packageVersionId', 'packageVersion.id = ? ');
  this.filterOverrides.put('resourceId', 'resource.id = ? ');
  this.filterOverrides.put('groupId', 'resource.explicitGroups.id = ? ');
  this.filterOverrides.put('resourceGroupIds', 'resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.filterOverrides.put('userId', 'user.id = ? ');
}

defineSeed(1163, 1106, makeCastMap([Q$Serializable, Q$Criteria]), InstalledPackageHistoryCriteria_0);
_.getPersistentClass = function getPersistentClass_18(){
  return Lorg_rhq_core_domain_content_InstalledPackageHistory_2_classLit;
}
;
_.fetchPackageVersion = false;
_.fetchResource = false;
_.fetchUser = false;
_.filterInstallationTimeMaximum = null;
_.filterInstallationTimeMinimum = null;
_.filterPackageVersionId = null;
_.filterResourceGroupIds = null;
_.filterResourceId = null;
_.filterUserId = null;
_.sortInstallationDate = null;
_.sortStatus = null;
function serialize_221(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchPackageVersion);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeBoolean(streamWriter, instance.fetchUser);
  $writeObject(streamWriter, instance.filterInstallationTimeMaximum);
  $writeObject(streamWriter, instance.filterInstallationTimeMinimum);
  $writeObject(streamWriter, instance.filterPackageVersionId);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterUserId);
  $writeObject(streamWriter, instance.sortInstallationDate);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_208(streamWriter, instance);
}

function $addFilterGroupId_0(this$static, filterGroupId){
  if (this$static.filterResourceId) {
    throw new IllegalArgumentException_1('This criteria cannot be filtered by both a Resource id and a group id.');
  }
  this$static.filterGroupId = filterGroupId;
}

function $addFilterResourceId_2(this$static, filterResourceId){
  if (this$static.filterGroupId) {
    throw new IllegalArgumentException_1('This criteria cannot be filtered by both a Resource id and a group id.');
  }
  this$static.filterResourceId = filterResourceId;
}

function MeasurementDataTraitCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('scheduleId', 'id.scheduleId = ?');
  this.filterOverrides.put('resourceId', 'schedule.resource.id = ?');
  this.filterOverrides.put('groupId', 'schedule.resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.explicitGroups grp    WHERE grp.id = ? )');
  this.filterOverrides.put('definitionId', 'schedule.definition.id = ?');
  this.filterOverrides.put('maxTimestamp', 'id.timestamp = ( SELECT MAX(mdt.id.timestamp)     FROM MeasurementDataTrait mdt    WHERE mdt.id.scheduleId = ' + $getAlias(this) + '.id.scheduleId )      AND 1 = ?');
  this.filterOverrides.put('enabled', 'schedule.enabled = ?');
  this.sortOverrides.put('timestamp', 'id.timestamp');
  this.sortOverrides.put('displayName', 'schedule.definition.displayName');
  this.sortOverrides.put('resourceName', 'schedule.resource.name');
}

defineSeed(1165, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$MeasurementDataTraitCriteria]), MeasurementDataTraitCriteria_0);
_.getPersistentClass = function getPersistentClass_19(){
  return Lorg_rhq_core_domain_measurement_MeasurementDataTrait_2_classLit;
}
;
_.isSupportsAddFilterId = function isSupportsAddFilterId_0(){
  return false;
}
;
_.isSupportsAddFilterIds = function isSupportsAddFilterIds_0(){
  return false;
}
;
_.fetchSchedule = false;
_.filterDefinitionId = null;
_.filterEnabled = null;
_.filterGroupId = null;
_.filterMaxTimestamp = null;
_.filterResourceId = null;
_.filterScheduleId = null;
_.sortDisplayName = null;
_.sortResourceName = null;
_.sortTimestamp = null;
function serialize_222(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchSchedule);
  $writeObject(streamWriter, instance.filterDefinitionId);
  $writeObject(streamWriter, instance.filterEnabled);
  $writeObject(streamWriter, instance.filterGroupId);
  $writeObject(streamWriter, instance.filterMaxTimestamp);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterScheduleId);
  $writeObject(streamWriter, instance.sortDisplayName);
  $writeObject(streamWriter, instance.sortResourceName);
  $writeObject(streamWriter, instance.sortTimestamp);
  serialize_208(streamWriter, instance);
}

function MeasurementDefinitionCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceTypeName', 'resourceType.name like ?');
  this.filterOverrides.put('resourceTypeId', 'resourceType.id = ?');
  this.sortOverrides.put('resourceTypeName', 'resourceType.name');
}

defineSeed(1167, 1106, makeCastMap([Q$Serializable, Q$Criteria]), MeasurementDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_20(){
  return Lorg_rhq_core_domain_measurement_MeasurementDefinition_2_classLit;
}
;
_.fetchResourceType = false;
_.filterCategory = null;
_.filterDataType = null;
_.filterDefaultInterval = null;
_.filterDefaultOn = null;
_.filterDescription = null;
_.filterDisplayName = null;
_.filterDisplayType = null;
_.filterName = null;
_.filterNumericType = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.filterUnits = null;
_.sortCategory = null;
_.sortDataType = null;
_.sortDefaultInterval = null;
_.sortDefaultOn = null;
_.sortDisplayName = null;
_.sortDisplayType = null;
_.sortName = null;
_.sortNumericType = null;
_.sortResourceTypeName = null;
_.sortUnits = null;
function serialize_223(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchResourceType);
  $writeObject(streamWriter, instance.filterCategory);
  $writeObject(streamWriter, instance.filterDataType);
  $writeObject(streamWriter, instance.filterDefaultInterval);
  $writeObject(streamWriter, instance.filterDefaultOn);
  $writeString(streamWriter, instance.filterDescription);
  $writeString(streamWriter, instance.filterDisplayName);
  $writeObject(streamWriter, instance.filterDisplayType);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterNumericType);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.filterUnits);
  $writeObject(streamWriter, instance.sortCategory);
  $writeObject(streamWriter, instance.sortDataType);
  $writeObject(streamWriter, instance.sortDefaultInterval);
  $writeObject(streamWriter, instance.sortDefaultOn);
  $writeObject(streamWriter, instance.sortDisplayName);
  $writeObject(streamWriter, instance.sortDisplayType);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortNumericType);
  $writeObject(streamWriter, instance.sortResourceTypeName);
  $writeObject(streamWriter, instance.sortUnits);
  serialize_208(streamWriter, instance);
}

function $addFilterEnabled(this$static, filterEnabled){
  this$static.filterEnabled = filterEnabled;
}

function $addFilterResourceGroupId_0(this$static, filterResourceGroupId){
  this$static.filterResourceGroupId = filterResourceGroupId;
}

function $addFilterResourceId_3(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function MeasurementScheduleCriteria_0(){
  var defaults;
  Criteria_4.call(this);
  this.filterOverrides.put('definitionIds', 'definition.id IN ( ? )');
  this.filterOverrides.put('resourceId', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupId', 'resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.explicitGroups eg    WHERE eg.id = ? )');
  this.filterOverrides.put('resourceInventoryStatuses', 'resource.inventoryStatus IN ( ? )');
  this.filterOverrides.put('autoGroupResourceTypeId', 'resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.resourceType type    WHERE type.id = ? )');
  this.filterOverrides.put('autoGroupParentResourceId', 'resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.parentResource parent    WHERE parent.id = ? )');
  this.filterOverrides.put('resourceTypeId', 'resource.type.id = ?');
  this.sortOverrides.put('definitionId', 'definition.id');
  this.sortOverrides.put('name', 'definition.name');
  this.sortOverrides.put('displayName', 'definition.displayName');
  this.sortOverrides.put('dataType', 'definition.dataType');
  defaults = new ArrayList_1(1);
  defaults.add_0(($clinit_InventoryStatus() , COMMITTED));
  this.filterResourceInventoryStatuses = defaults;
}

defineSeed(1169, 1106, makeCastMap([Q$Serializable, Q$Criteria]), MeasurementScheduleCriteria_0);
_.getPersistentClass = function getPersistentClass_21(){
  return Lorg_rhq_core_domain_measurement_MeasurementSchedule_2_classLit;
}
;
_.fetchBaseline = false;
_.fetchDefinition = false;
_.fetchResource = false;
_.filterAutoGroupParentResourceId = null;
_.filterAutoGroupResourceTypeId = null;
_.filterDefinitionIds = null;
_.filterEnabled = null;
_.filterResourceGroupId = null;
_.filterResourceId = null;
_.filterResourceInventoryStatuses = null;
_.filterResourceTypeId = null;
_.sortDataType = null;
_.sortDisplayName = null;
_.sortName = null;
function serialize_224(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBaseline);
  $writeBoolean(streamWriter, instance.fetchDefinition);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterAutoGroupParentResourceId);
  $writeObject(streamWriter, instance.filterAutoGroupResourceTypeId);
  $writeObject(streamWriter, instance.filterDefinitionIds);
  $writeObject(streamWriter, instance.filterEnabled);
  $writeObject(streamWriter, instance.filterResourceGroupId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterResourceInventoryStatuses);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeObject(streamWriter, instance.sortDataType);
  $writeObject(streamWriter, instance.sortDisplayName);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function serialize_225(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchOperationDefinition);
  $writeBoolean(streamWriter, instance.fetchParameters);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeString(streamWriter, instance.filterErrorMessage);
  $writeString(streamWriter, instance.filterJobGroup);
  $writeString(streamWriter, instance.filterJobName);
  $writeObject(streamWriter, instance.filterOperationDefinitionId);
  $writeString(streamWriter, instance.filterOperationName);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.filterStatus);
  $writeObject(streamWriter, instance.filterStatuses);
  $writeObject(streamWriter, instance.sortEndTime);
  $writeObject(streamWriter, instance.sortOperationName);
  $writeObject(streamWriter, instance.sortStartTime);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_208(streamWriter, instance);
}

function $addFilterPackageTypeId(this$static, packageTypeId){
  this$static.filterPackageTypeId = packageTypeId;
}

function $addFilterRepoId(this$static, repoId){
  this$static.filterRepoId = repoId;
}

function PackageCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('packageTypeId', 'packageType.id = ? ');
  this.filterOverrides.put('repoId', 'id IN (SELECT rpv.packageVersion.generalPackage.id FROM RepoPackageVersion rpv WHERE rpv.repo.id = ?)');
}

defineSeed(1172, 1106, makeCastMap([Q$Serializable, Q$Criteria]), PackageCriteria_0);
_.getPersistentClass = function getPersistentClass_22(){
  return Lorg_rhq_core_domain_content_Package_2_classLit;
}
;
_.fetchVersions = false;
_.filterClassification = null;
_.filterName = null;
_.filterPackageTypeId = null;
_.filterRepoId = null;
_.sortName = null;
function serialize_226(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchVersions);
  $writeString(streamWriter, instance.filterClassification);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPackageTypeId);
  $writeObject(streamWriter, instance.filterRepoId);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function serialize_227(streamWriter, instance){
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  serialize_208(streamWriter, instance);
}

function $addFilterEventDetail(this$static, eventDetail){
  this$static.filterEventDetail = eventDetail;
}

function PartitionEventCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('eventType', 'eventType IN ( ? )');
  this.filterOverrides.put('executionStatus', 'executionStatus IN ( ? )');
}

defineSeed(1175, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$PartitionEventCriteria]), PartitionEventCriteria_0);
_.getPersistentClass = function getPersistentClass_23(){
  return Lorg_rhq_core_domain_cloud_PartitionEvent_2_classLit;
}
;
_.filterEventDetail = null;
_.filterEventType = null;
_.filterExecutionStatus = null;
_.sortCtime = null;
function serialize_228(streamWriter, instance){
  $writeString(streamWriter, instance.filterEventDetail);
  $writeObject(streamWriter, instance.filterEventType);
  $writeObject(streamWriter, instance.filterExecutionStatus);
  $writeObject(streamWriter, instance.sortCtime);
  serialize_208(streamWriter, instance);
}

function $addFilterGroupConfigurationUpdateId(this$static, filterGroupConfigurationUpdateId){
  this$static.filterGroupConfigurationUpdateId = filterGroupConfigurationUpdateId;
}

function PluginConfigurationUpdateCriteria_0(){
  AbstractResourceConfigurationUpdateCriteria_0.call(this);
  this.filterOverrides.put('groupConfigurationUpdateId', 'groupConfigurationUpdate.id = ?');
  this.filterOverrides.put('resourceTypeId', 'resource.resourceType.id = ?');
  this.filterOverrides.put('resourceTypeName', 'resource.resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.sortOverrides.put('name', 'resource.name');
  this.sortOverrides.put('resourceId', 'resource.id');
}

defineSeed(1177, 1110, makeCastMap([Q$Serializable, Q$Criteria, Q$PluginConfigurationUpdateCriteria]), PluginConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_24(){
  return Lorg_rhq_core_domain_configuration_PluginConfigurationUpdate_2_classLit;
}
;
_.fetchGroupConfigurationUpdate = false;
_.fetchResource = false;
_.filterGroupConfigurationUpdateId = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.sortName = null;
_.sortResourceId = null;
function serialize_229(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchGroupConfigurationUpdate);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterGroupConfigurationUpdateId);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortResourceId);
  serialize_194(streamWriter, instance);
}

function RepoCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceIds', 'resourceRepos.resource.id IN ( ? )');
  this.filterOverrides.put('contentSourceIds', 'id IN ( SELECT innerRepo           FROM Repo innerRepo           JOIN innerRepo.repoContentSources rcs          WHERE rcs.contentSource.id IN ( ? ))');
  this.filterOverrides.put('ownerId', 'owner.id = ?');
}

defineSeed(1179, 1106, makeCastMap([Q$Serializable, Q$Criteria]), RepoCriteria_0);
_.getPersistentClass = function getPersistentClass_25(){
  return Lorg_rhq_core_domain_content_Repo_2_classLit;
}
;
_.fetchRepoContentSources = false;
_.fetchRepoPackageVersions = false;
_.fetchRepoRepoGroups = false;
_.fetchRepoRepoRelationships = false;
_.fetchResourceRepos = false;
_.filterCandidate = null;
_.filterContentSourceIds = null;
_.filterDescription = null;
_.filterIsPrivate = null;
_.filterName = null;
_.filterOwnerId = null;
_.filterResourceIds = null;
_.sortName = null;
function serialize_230(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchRepoContentSources);
  $writeBoolean(streamWriter, instance.fetchRepoPackageVersions);
  $writeBoolean(streamWriter, instance.fetchRepoRepoGroups);
  $writeBoolean(streamWriter, instance.fetchRepoRepoRelationships);
  $writeBoolean(streamWriter, instance.fetchResourceRepos);
  $writeObject(streamWriter, instance.filterCandidate);
  $writeObject(streamWriter, instance.filterContentSourceIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterIsPrivate);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterOwnerId);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterResourceIds_3(this$static, filterResourceGroupIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function ResourceBundleDeploymentCriteria_0(){
  BundleDeploymentCriteria_0.call(this);
  this.filterOverrides.put('resourceIds', 'id IN ( SELECT ibd.id     FROM BundleDeployment ibd     JOIN ibd.resourceDeployments resourceDeployment    WHERE resourceDeployment.resource.id IN ( ? ) )');
}

defineSeed(1181, 1121, makeCastMap([Q$Serializable, Q$BundleDeploymentCriteria, Q$Criteria]), ResourceBundleDeploymentCriteria_0);
_.filterResourceIds = null;
function serialize_231(streamWriter, instance){
  $writeObject(streamWriter, instance.filterResourceIds);
  serialize_201(streamWriter, instance);
}

function $addFilterGroupConfigurationUpdateId_0(this$static, filterGroupConfigurationUpdateId){
  this$static.filterGroupConfigurationUpdateId = filterGroupConfigurationUpdateId;
}

function $addFilterResourceIds_4(this$static, filterResourceIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceIds);
}

function ResourceConfigurationUpdateCriteria_0(){
  AbstractResourceConfigurationUpdateCriteria_0.call(this);
  $addRequiredPermissions(this, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [($clinit_Permission() , CONFIGURE_READ)]));
  this.filterOverrides.put('groupConfigurationUpdateId', 'groupConfigurationUpdate.id = ?');
  this.filterOverrides.put('resourceTypeId', 'resource.resourceType.id = ?');
  this.filterOverrides.put('resourceTypeName', 'resource.resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.sortOverrides.put('resourceName', 'resource.name');
  this.sortOverrides.put('resourceId', 'resource.id');
}

defineSeed(1183, 1110, makeCastMap([Q$Serializable, Q$Criteria, Q$ResourceConfigurationUpdateCriteria]), ResourceConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_26(){
  return Lorg_rhq_core_domain_configuration_ResourceConfigurationUpdate_2_classLit;
}
;
_.fetchGroupConfigurationUpdate = false;
_.fetchResource = false;
_.filterGroupConfigurationUpdateId = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_232(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchGroupConfigurationUpdate);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterGroupConfigurationUpdateId);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_194(streamWriter, instance);
}

function $addFilterCurrentAvailability(this$static, filterCurrentAvailability){
  this$static.filterCurrentAvailability = filterCurrentAvailability;
}

function $addFilterExplicitGroupIds(this$static, filterExplicitGroupIds){
  this$static.filterExplicitGroupIds = getListIgnoringNulls(filterExplicitGroupIds);
}

function $addFilterImplicitGroupIds(this$static, filterImplicitGroupIds){
  this$static.filterImplicitGroupIds = getListIgnoringNulls(filterImplicitGroupIds);
}

function $addFilterInventoryStatuses(this$static, filterInventoryStatuses){
  this$static.filterInventoryStatuses = filterInventoryStatuses;
  this$static.filterInventoryStatus = null;
}

function $addFilterName_2(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterParentResourceCategory(this$static, filterParentResourceCategory){
  this$static.filterParentResourceCategory = filterParentResourceCategory;
}

function $addFilterParentResourceId(this$static, filterParentResourceId){
  this$static.filterParentResourceId = filterParentResourceId;
}

function $addFilterPluginName(this$static, filterPluginName){
  this$static.filterPluginName = filterPluginName;
}

function $addFilterResourceCategories(this$static, filterResourceCategories){
  this$static.filterResourceCategories = getListIgnoringNulls(filterResourceCategories);
}

function $addFilterResourceTypeId_0(this$static, filterResourceTypeId){
  this$static.filterResourceTypeId = filterResourceTypeId;
}

function $addFilterVersion(this$static, filterVersion){
  this$static.filterVersion = filterVersion;
}

function $addSortName_0(this$static, sortName){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(110)) + 'ame');
  this$static.sortName = sortName;
}

function $addFilterAutoGroupParentResourceId_0(this$static, filterAutoGroupParentResourceId){
  this$static.filterAutoGroupParentResourceId = filterAutoGroupParentResourceId;
}

function $addFilterDownMemberCount(this$static, filterDownMemberCount){
  this$static.filterDownMemberCount = filterDownMemberCount;
}

function $addFilterExplicitResourceIds(this$static, filterExplicitResourceIds){
  this$static.filterExplicitResourceIds = getListIgnoringNulls(filterExplicitResourceIds);
}

function $addFilterGroupCategory(this$static, filterGroupCategory){
  this$static.filterGroupCategory = filterGroupCategory;
}

function $addFilterGroupDefinitionId(this$static, filterGroupDefinitionId){
  this$static.filterGroupDefinitionId = filterGroupDefinitionId;
}

function $addFilterName_3(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterPrivate(this$static, filterPrivate){
  this$static.filterPrivate = filterPrivate;
}

function $addFilterResourceTypeId_1(this$static, filterResourceTypeId){
  this$static.filterResourceTypeId = filterResourceTypeId;
}

function $addFilterVisible(this$static, filterVisible){
  if (!filterVisible) {
    throw new IllegalArgumentException_1('A single fetch may be for visible or invisible groups, but not both.');
  }
  this$static.filterVisible = filterVisible;
}

function ResourceGroupDefinitionCriteria_0(){
  Criteria_4.call(this);
}

defineSeed(1189, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$ResourceGroupDefinitionCriteria]), ResourceGroupDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_29(){
  return Lorg_rhq_core_domain_resource_group_GroupDefinition_2_classLit;
}
;
_.fetchManagedResourceGroups = false;
_.filterDescription = null;
_.filterExpression = null;
_.filterName = null;
_.filterRecursive = null;
_.sortDescription = null;
_.sortExpression = null;
_.sortName = null;
_.sortRecursive = null;
function $addFilterGroupOperationHistoryId(this$static, groupOperationHistoryId){
  this$static.filterGroupOperationHistoryId = groupOperationHistoryId;
}

function $addFilterResourceIds_5(this$static, filterResourceIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceIds);
}

function ResourceOperationHistoryCriteria_0(){
  OperationHistoryCriteria_0.call(this);
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('groupOperationHistoryId', 'groupOperationHistory.id = ?');
  this.sortOverrides.put('resourceName', 'resource.id');
  this.sortOverrides.put('resourceName', 'resource.name');
}

defineSeed(1191, 1157, makeCastMap([Q$Serializable, Q$Criteria, Q$ResourceOperationHistoryCriteria]), ResourceOperationHistoryCriteria_0);
_.getPersistentClass = function getPersistentClass_30(){
  return Lorg_rhq_core_domain_operation_ResourceOperationHistory_2_classLit;
}
;
_.fetchResults = false;
_.filterGroupOperationHistoryId = null;
_.filterResourceIds = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_236(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchResults);
  $writeObject(streamWriter, instance.filterGroupOperationHistoryId);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_225(streamWriter, instance);
}

function $addFilterIgnored(this$static, ignored){
  this$static.filterIgnored = ignored;
}

function $addFilterPermissions(this$static, filterPermissions){
  this$static.filterPermissions = filterPermissions;
}

function $addFilterSubjectId(this$static, filterSubjectId){
  this$static.filterSubjectId = filterSubjectId;
}

function RoleCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('subjectId', 'id IN ( SELECT innerRole1.id           FROM Role innerRole1           JOIN innerRole1.subjects innerSubject1          WHERE innerSubject1.id = ? )');
  this.filterOverrides.put('ldapSubjectId', 'id IN ( SELECT innerRole2.id           FROM Role innerRole2           JOIN innerRole2.ldapSubjects innerSubject2          WHERE innerSubject2.id = ? )');
  this.filterOverrides.put('permissions', 'id IN ( SELECT innerRole3.id           FROM Role innerRole3           JOIN innerRole3.permissions perm          WHERE perm IN ( ? ) )');
}

defineSeed(1195, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$RoleCriteria]), RoleCriteria_0);
_.getPersistentClass = function getPersistentClass_32(){
  return Lorg_rhq_core_domain_authz_Role_2_classLit;
}
;
_.fetchBundleGroups = false;
_.fetchLdapGroups = false;
_.fetchPermissions = false;
_.fetchResourceGroups = false;
_.fetchRoleNotifications = false;
_.fetchSubjects = false;
_.filterDescription = null;
_.filterLdapSubjectId = null;
_.filterName = null;
_.filterPermissions = null;
_.filterSubjectId = null;
_.sortName = null;
function serialize_238(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleGroups);
  $writeBoolean(streamWriter, instance.fetchLdapGroups);
  $writeBoolean(streamWriter, instance.fetchPermissions);
  $writeBoolean(streamWriter, instance.fetchResourceGroups);
  $writeBoolean(streamWriter, instance.fetchRoleNotifications);
  $writeBoolean(streamWriter, instance.fetchSubjects);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterLdapSubjectId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPermissions);
  $writeObject(streamWriter, instance.filterSubjectId);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterAddress_0(this$static, filterAddress){
  this$static.filterAddress = filterAddress;
}

function $addFilterAffinityGroupId_0(this$static, filterAffinityGroupId){
  this$static.filterAffinityGroupId = filterAffinityGroupId;
}

function $addFilterComputePower(this$static, filterComputePower){
  this$static.filterComputePower = filterComputePower;
}

function $addFilterName_4(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterPort_0(this$static, filterPort){
  this$static.filterPort = filterPort;
}

function $addFilterSecurePort(this$static, filterSecurePort){
  this$static.filterSecurePort = filterSecurePort;
}

function ServerCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('operationMode', 'operationMode IN ( ? )');
  this.filterOverrides.put('affinityGroupId', 'affinityGroup.id = ?');
}

defineSeed(1199, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$ServerCriteria]), ServerCriteria_0);
_.getPersistentClass = function getPersistentClass_34(){
  return Lorg_rhq_core_domain_cloud_Server_2_classLit;
}
;
_.fetchAffinityGroup = false;
_.fetchAgents = false;
_.filterAddress = null;
_.filterAffinityGroupId = null;
_.filterComputePower = null;
_.filterName = null;
_.filterOperationMode = null;
_.filterPort = null;
_.filterSecurePort = null;
_.sortComputePower = null;
_.sortCtime = null;
_.sortName = null;
function serialize_240(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAffinityGroup);
  $writeBoolean(streamWriter, instance.fetchAgents);
  $writeString(streamWriter, instance.filterAddress);
  $writeObject(streamWriter, instance.filterAffinityGroupId);
  $writeObject(streamWriter, instance.filterComputePower);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterOperationMode);
  $writeObject(streamWriter, instance.filterPort);
  $writeObject(streamWriter, instance.filterSecurePort);
  $writeObject(streamWriter, instance.sortComputePower);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortName);
  serialize_208(streamWriter, instance);
}

function $addFilterAddress_1(this$static, filterAddress){
  this$static.filterAddress = filterAddress;
}

function StorageNodeCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('operationMode', 'operationMode IN ( ? )');
  this.filterOverrides.put('resourceId', 'resource.id = ?');
}

defineSeed(1201, 1106, makeCastMap([Q$Serializable, Q$Criteria, Q$StorageNodeCriteria]), StorageNodeCriteria_0);
_.getPersistentClass = function getPersistentClass_35(){
  return Lorg_rhq_core_domain_cloud_StorageNode_2_classLit;
}
;
_.fetchResource = false;
_.filterAddress = null;
_.filterCqlPort = null;
_.filterJmxPort = null;
_.filterOperationMode = null;
_.filterResourceId = null;
_.sortAddress = null;
_.sortCtime = null;
function serialize_241(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeString(streamWriter, instance.filterAddress);
  $writeObject(streamWriter, instance.filterCqlPort);
  $writeObject(streamWriter, instance.filterJmxPort);
  $writeObject(streamWriter, instance.filterOperationMode);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.sortAddress);
  $writeObject(streamWriter, instance.sortCtime);
  serialize_208(streamWriter, instance);
}

function $addFilterFsystem(this$static, filterFsystem){
  this$static.filterFsystem = filterFsystem;
}

function $addSortName_2(this$static, sortName){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(110)) + 'ame');
  this$static.sortName = sortName;
}

function $addSortNamespace(this$static, sortNamespace){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(110)) + 'amespace');
  this$static.sortNamespace = sortNamespace;
}

function $addSortSemantic(this$static, sortSemantic){
  this$static.orderingFieldNames.add_0('sort' + charToString(toUpperCase(115)) + 'emantic');
  this$static.sortSemantic = sortSemantic;
}

function TagCriteria_0(){
  Criteria_4.call(this);
}

defineSeed(1205, 1106, makeCastMap([Q$Serializable, Q$Criteria]), TagCriteria_0);
_.getPersistentClass = function getPersistentClass_37(){
  return Lorg_rhq_core_domain_tagging_Tag_2_classLit;
}
;
_.filterName = null;
_.filterNamespace = null;
_.filterSemantic = null;
_.sortName = null;
_.sortNamespace = null;
_.sortSemantic = null;
function serialize_243(streamWriter, instance){
  $writeString(streamWriter, instance.filterName);
  $writeString(streamWriter, instance.filterNamespace);
  $writeString(streamWriter, instance.filterSemantic);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortNamespace);
  $writeObject(streamWriter, instance.sortSemantic);
  serialize_208(streamWriter, instance);
}

function $addPortlet(this$static, storedPortlet){
  var bestColumn, column, columnCounts, dashboardPortlet, dashboardPortlet$iterator, minPortlets;
  columnCounts = initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, valueOf_49(__parseAndValidateInt($getSimpleValue(this$static.configuration, 'columns', '1'))).value_0, 1);
  fill(columnCounts, columnCounts.length);
  for (dashboardPortlet$iterator = this$static.portlets.iterator(); dashboardPortlet$iterator.hasNext();) {
    dashboardPortlet = dynamicCast(dashboardPortlet$iterator.next_0(), Q$DashboardPortlet);
    ++columnCounts[dashboardPortlet.column];
  }
  bestColumn = -1;
  minPortlets = 2147483647;
  for (column = 0; column < columnCounts.length; ++column) {
    if (columnCounts[column] < minPortlets) {
      bestColumn = column;
      minPortlets = columnCounts[column];
    }
  }
  $addPortlet_0(this$static, storedPortlet, bestColumn, minPortlets);
}

function $addPortlet_0(this$static, storedPortlet, column, index){
  storedPortlet.column = column;
  storedPortlet.index_0 = index;
  storedPortlet.dashboard = this$static;
  this$static.portlets.add_0(storedPortlet);
}

function $getPortlets(this$static, column){
  var columnPortlets, p, p$iterator;
  columnPortlets = new ArrayList_0;
  for (p$iterator = this$static.portlets.iterator(); p$iterator.hasNext();) {
    p = dynamicCast(p$iterator.next_0(), Q$DashboardPortlet);
    p.column == column && columnPortlets.add_0(p);
  }
  sort_1(columnPortlets, new Dashboard$1_0);
  return columnPortlets;
}

function $removePortlet(this$static, storedPortlet){
  var col, i, index, next;
  if (!this$static.portlets.contains(storedPortlet)) {
    return false;
  }
  col = storedPortlet.column;
  index = storedPortlet.index_0;
  this$static.portlets.remove_1(storedPortlet);
  for (i = this$static.portlets.iterator(); i.hasNext();) {
    next = dynamicCast(i.next_0(), Q$DashboardPortlet);
    col == next.column && index < next.index_0 && $setIndex(next, next.index_0 - 1);
  }
  return true;
}

function $setCategory_0(this$static, category){
  this$static.category = category;
}

function $setColumnWidths(this$static, columnWidths){
  var i, sb;
  if (null == columnWidths || columnWidths.length == 0) {
    return;
  }
  sb = new StringBuilder_0;
  $append_2(sb.impl, columnWidths[0]);
  for (i = 1; i < columnWidths.length; ++i) {
    sb.impl.string += ',';
    $append_2(sb.impl, columnWidths[i]);
  }
  $put_4(this$static.configuration, new PropertySimple_1('widths', sb));
}

function $setColumns(this$static, columns){
  $put_4(this$static.configuration, new PropertySimple_1('columns', valueOf_49(columns)));
}

function $setName_8(this$static, name_0){
  this$static.name_0 = name_0;
}

function $compare_4(o1, o2){
  return o1.index_0 < o2.index_0?-1:o1.index_0 == o2.index_0?0:1;
}

function Dashboard$1_0(){
}

defineSeed(1209, 1, makeCastMap([Q$Comparator]), Dashboard$1_0);
_.compare = function compare_6(o1, o2){
  return $compare_4(dynamicCast(o1, Q$DashboardPortlet), dynamicCast(o2, Q$DashboardPortlet));
}
;
function $setColumn(this$static, column){
  this$static.column = column;
}

function $setConfiguration_0(this$static, configuration){
  this$static.configuration = configuration;
}

function $setHeight_3(this$static, height){
  this$static.height = height;
}

function $setIndex(this$static, index){
  this$static.index_0 = index;
}

function DashboardPortlet_1(name_0, portletKey, height){
  $$init_11(this);
  this.name_0 = name_0;
  this.portletKey = portletKey;
  this.height = height;
}

defineSeed(1213, 1, makeCastMap([Q$Serializable, Q$DashboardPortlet]), DashboardPortlet_1);
defineSeed(1217, 1, makeCastMap([Q$Serializable]));
_.dataSize = null;
function $clinit_DriftCategory(){
  $clinit_DriftCategory = nullMethod;
  FILE_ADDED = new DriftCategory_0('FILE_ADDED', 0);
  FILE_CHANGED = new DriftCategory_0('FILE_CHANGED', 1);
  FILE_REMOVED = new DriftCategory_0('FILE_REMOVED', 2);
  $VALUES_88 = initValues(_3Lorg_rhq_core_domain_drift_DriftCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$DriftCategory_$1]), Q$DriftCategory, [FILE_ADDED, FILE_CHANGED, FILE_REMOVED]);
}

function DriftCategory_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_97(name_0){
  $clinit_DriftCategory();
  return valueOf(($clinit_DriftCategory$Map() , $MAP_88), name_0);
}

function values_91(){
  $clinit_DriftCategory();
  return $VALUES_88;
}

defineSeed(1219, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$DriftCategory]), DriftCategory_0);
var $VALUES_88, FILE_ADDED, FILE_CHANGED, FILE_REMOVED;
function $clinit_DriftCategory$Map(){
  $clinit_DriftCategory$Map = nullMethod;
  $MAP_88 = createValueOfMap(($clinit_DriftCategory() , $VALUES_88));
}

var $MAP_88;
function serialize_249(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_264(streamReader, instance){
}

function instantiate_257(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_DriftCategory() , $clinit_DriftCategory() , $VALUES_88);
  return values[ordinal];
}

function serialize_250(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function $clinit_DriftChangeSetCategory(){
  $clinit_DriftChangeSetCategory = nullMethod;
  COVERAGE = new DriftChangeSetCategory_0('COVERAGE', 0);
  DRIFT_0 = new DriftChangeSetCategory_0('DRIFT', 1);
  $VALUES_89 = initValues(_3Lorg_rhq_core_domain_drift_DriftChangeSetCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DriftChangeSetCategory, [COVERAGE, DRIFT_0]);
}

function DriftChangeSetCategory_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_98(name_0){
  $clinit_DriftChangeSetCategory();
  return valueOf(($clinit_DriftChangeSetCategory$Map() , $MAP_89), name_0);
}

function values_92(){
  $clinit_DriftChangeSetCategory();
  return $VALUES_89;
}

defineSeed(1223, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$DriftChangeSetCategory]), DriftChangeSetCategory_0);
var $VALUES_89, COVERAGE, DRIFT_0;
function $clinit_DriftChangeSetCategory$Map(){
  $clinit_DriftChangeSetCategory$Map = nullMethod;
  $MAP_89 = createValueOfMap(($clinit_DriftChangeSetCategory() , $VALUES_89));
}

var $MAP_89;
function deserialize_265(streamReader, instance){
}

function instantiate_258(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_DriftChangeSetCategory() , $clinit_DriftChangeSetCategory() , $VALUES_89);
  return values[ordinal];
}

function serialize_251(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function fromCode(code){
  $clinit_DriftComplianceStatus();
  switch (code) {
    case 0:
      return IN_COMPLIANCE;
    case 1:
      return OUT_OF_COMPLIANCE_NO_BASEDIR;
    case 2:
      return OUT_OF_COMPLIANCE_DRIFT;
    default:throw new IllegalArgumentException_1(code + ' is not a DriftComplianceStatus code');
  }
}

function DriftComposite_0(){
}

defineSeed(1229, 1, makeCastMap([Q$Serializable, Q$DriftComposite]), DriftComposite_0);
_.drift = null;
_.driftDefName = null;
_.resource = null;
function deserialize_267(streamReader, instance){
  setDrift(instance, dynamicCast($readObject(streamReader), Q$Drift));
  setDriftDefName(instance, $getString(streamReader, $readInt(streamReader)));
  setResource_9(instance, dynamicCast($readObject(streamReader), Q$Resource));
}

function instantiate_260(streamReader){
  return new DriftComposite_0;
}

function setDrift(instance, value){
  instance.drift = value;
}

function setDriftDefName(instance, value){
  instance.driftDefName = value;
}

function setResource_9(instance, value){
  instance.resource = value;
}

function $clinit_DriftConfigurationDefinition(){
  $clinit_DriftConfigurationDefinition = nullMethod;
  DEFAULT_DRIFT_HANDLING_MODE = ($clinit_DriftConfigurationDefinition$DriftHandlingMode() , normal);
  INSTANCE_0 = new ConfigurationDefinition_1('GLOBAL_DRIFT_CONFIG_DEF', 'The drift detection definition');
  INSTANCE_FOR_EXISTING_CONFIGS = new ConfigurationDefinition_1('GLOBAL_DRIFT_CONFIG_DEF', 'The drift detection definition');
  NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE = new ConfigurationDefinition_1('NEW_RESOURCE_DRIFT_DEF_BY_PINNED_TEMPLATE', 'A new resource drift definition created from a pinned template');
  EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE = new ConfigurationDefinition_1('EXISTING_RESOURCE_DRIFT_DEF_BY_PINNED_TEMPLATE', 'An existing resource drift definition created from a pinned template');
  NEW_TEMPLATE_INSTANCE = new ConfigurationDefinition_1('NEW_TEMPLATE_DRIFT_CONFIG_DEF', 'A new template drift definition');
  EXISTING_TEMPLATE_INSTANCE = new ConfigurationDefinition_1('EXISTING_TEMPLATE_DRIFT_CONFIG_DEF', 'An existing template drift definition');
  NEW_PINNED_TEMPLATE_INSTANCE = new ConfigurationDefinition_1('NEW_PINNED_TEMPLATE_DRIFT_CONFIG_DEF', 'A new pinned template drift definition');
  $setConfigurationFormat(INSTANCE_0, ($clinit_ConfigurationFormat() , STRUCTURED));
  $put_6(INSTANCE_0, createName(INSTANCE_0, false));
  $put_6(INSTANCE_0, createDescription(INSTANCE_0));
  $put_6(INSTANCE_0, createEnabled(INSTANCE_0));
  $put_6(INSTANCE_0, createDriftHandlingMode(INSTANCE_0));
  $put_6(INSTANCE_0, createInterval_0(INSTANCE_0));
  $put_6(INSTANCE_0, createBasedir(INSTANCE_0, false));
  $put_6(INSTANCE_0, createIncludes(INSTANCE_0, false));
  $put_6(INSTANCE_0, createExcludes(INSTANCE_0, false));
  $put_6(INSTANCE_0, createPinned(INSTANCE_0, false));
  $put_6(INSTANCE_0, createAttached(INSTANCE_0, false));
  $setConfigurationFormat(INSTANCE_FOR_EXISTING_CONFIGS, STRUCTURED);
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createName(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createDescription(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createEnabled(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createDriftHandlingMode(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createInterval_0(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createBasedir(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createIncludes(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createExcludes(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createExcludes(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createAttached(INSTANCE_FOR_EXISTING_CONFIGS, false));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createPinned(INSTANCE_FOR_EXISTING_CONFIGS, false));
  $setConfigurationFormat(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, STRUCTURED);
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createName(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, false));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDescription(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createInterval_0(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createEnabled(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDriftHandlingMode(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createBasedir(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createIncludes(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createExcludes(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createPinned(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createAttached(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $setConfigurationFormat(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, STRUCTURED);
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createName(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDescription(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createInterval_0(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createEnabled(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDriftHandlingMode(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createBasedir(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createIncludes(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createExcludes(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createPinned(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createAttached(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $setConfigurationFormat(NEW_TEMPLATE_INSTANCE, STRUCTURED);
  $put_6(NEW_TEMPLATE_INSTANCE, createName(NEW_TEMPLATE_INSTANCE, false));
  $put_6(NEW_TEMPLATE_INSTANCE, createDescription(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createInterval_0(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createEnabled(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createDriftHandlingMode(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createBasedir(NEW_TEMPLATE_INSTANCE, false));
  $put_6(NEW_TEMPLATE_INSTANCE, createIncludes(NEW_TEMPLATE_INSTANCE, false));
  $put_6(NEW_TEMPLATE_INSTANCE, createExcludes(NEW_TEMPLATE_INSTANCE, false));
  $setConfigurationFormat(EXISTING_TEMPLATE_INSTANCE, STRUCTURED);
  $put_6(EXISTING_TEMPLATE_INSTANCE, createName(EXISTING_TEMPLATE_INSTANCE, true));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createDescription(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createInterval_0(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createEnabled(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createDriftHandlingMode(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createBasedir(EXISTING_TEMPLATE_INSTANCE, true));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createIncludes(EXISTING_TEMPLATE_INSTANCE, true));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createExcludes(EXISTING_TEMPLATE_INSTANCE, true));
  $setConfigurationFormat(NEW_PINNED_TEMPLATE_INSTANCE, STRUCTURED);
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createName(NEW_PINNED_TEMPLATE_INSTANCE, false));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createDescription(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createInterval_0(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createEnabled(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createDriftHandlingMode(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createBasedir(NEW_PINNED_TEMPLATE_INSTANCE, true));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createIncludes(NEW_PINNED_TEMPLATE_INSTANCE, true));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createExcludes(NEW_PINNED_TEMPLATE_INSTANCE, true));
}

function createAttached(configDef, readOnly){
  var pd, type;
  type = ($clinit_PropertySimpleType() , BOOLEAN_2);
  pd = new PropertyDefinitionSimple_1('attached', 'A flag that indicates whether or not the definition is attached to the template from which it is created. When a template is updated, the changes will be propagated to any attached definitions. Furthermore, if you pin an existing template to a snapshot, then attached definitions will become pinned as well. Finally, if you delete a template, attached definitions will also be deleted.', true, type);
  pd.displayName = 'Attached to Template';
  pd.defaultValue = 'true';
  pd.order = 3;
  pd.readOnly = readOnly;
  pd.configurationDefinition = configDef;
  return pd;
}

function createBasedir(configDef, readOnly){
  var pd, valueContext, valueName, type, pd_0, pcEnum, rcEnum, mtEnum, fsEnum, pdEnums, type_0, pd_1, constraint;
  valueContext = (type = ($clinit_PropertySimpleType() , STRING_0) , pd_0 = new PropertyDefinitionSimple_1('valueContext', 'Identifies where the named value can be found.', true, type) , pd_0.displayName = 'Value Context' , pd_0.readOnly = readOnly , pd_0.summary = true , pd_0.order = 0 , pcEnum = new PropertyDefinitionEnumeration_1(($clinit_DriftConfigurationDefinition$BaseDirValueContext() , pluginConfiguration_1).name_0, pluginConfiguration_1.name_0) , pcEnum.orderIndex = 0 , rcEnum = new PropertyDefinitionEnumeration_1(resourceConfiguration_1.name_0, resourceConfiguration_1.name_0) , rcEnum.orderIndex = 1 , mtEnum = new PropertyDefinitionEnumeration_1(measurementTrait_0.name_0, measurementTrait_0.name_0) , mtEnum.orderIndex = 2 , fsEnum = new PropertyDefinitionEnumeration_1(fileSystem_0.name_0, fileSystem_0.name_0) , fsEnum.orderIndex = 3 , pdEnums = new ArrayList_1(4) , pdEnums.add_0(pcEnum) , pdEnums.add_0(rcEnum) , pdEnums.add_0(mtEnum) , pdEnums.add_0(fsEnum) , $setEnumeratedValues(pd_0, pdEnums) , pd_0);
  valueName = (type_0 = STRING_0 , pd_1 = new PropertyDefinitionSimple_1('valueName', 'The name of the value as found in the context.', true, type_0) , pd_1.displayName = 'Value Name' , pd_1.readOnly = readOnly , pd_1.summary = true , pd_1.order = 1 , pd_1.allowCustomEnumeratedValue = false , constraint = new RegexConstraint_0 , constraint.details = '[ \\.\\-\\(\\)\\w/\\:\\\\]+' , $addConstraints(pd_1, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint])) , pd_1);
  pd = new PropertyDefinitionMap_1('basedir', 'The root directory from which snapshots will be generated during drift monitoring.', true, initValues(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PropertyDefinition, [valueContext, valueName]));
  pd.displayName = 'Base Directory';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 7;
  pd.configurationDefinition = configDef;
  return pd;
}

function createDescription(configDef){
  var pd, type;
  type = ($clinit_PropertySimpleType() , STRING_0);
  pd = new PropertyDefinitionSimple_1('description', 'A description of the drift detection definition or template', false, type);
  pd.displayName = 'Drift Definition Description';
  pd.summary = true;
  pd.order = 1;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  return pd;
}

function createDriftHandlingMode(configDef){
  var normalEnum, pd, pdEnums, plannedEnum, type;
  type = ($clinit_PropertySimpleType() , STRING_0);
  pd = new PropertyDefinitionSimple_1('driftHandlingMode', "Specifies the way in which drift instances will be handled when reported. Normal handling implies the reported drift is unexpected and as such can trigger alerts, will be present in recent drift reports, etc.  Setting to 'Planned Changes' implies that the reported drift is happening at a time when drift is expected due to planned changes in the monitored environment, such as an application deployment, a configuration change, or something similar.  With this setting drift is only reported  for inspection, in drift snapshot views.", true, type);
  pd.displayName = 'Drift Handling Mode';
  pd.readOnly = false;
  pd.summary = true;
  pd.order = 4;
  pd.configurationDefinition = configDef;
  normalEnum = new PropertyDefinitionEnumeration_1(($clinit_DriftConfigurationDefinition$DriftHandlingMode() , normal).name_0, normal.name_0);
  normalEnum.orderIndex = 0;
  plannedEnum = new PropertyDefinitionEnumeration_1(plannedChanges.name_0, plannedChanges.name_0);
  plannedEnum.orderIndex = 1;
  pdEnums = new ArrayList_1(2);
  pdEnums.add_0(normalEnum);
  pdEnums.add_0(plannedEnum);
  $setEnumeratedValues(pd, pdEnums);
  $setDefaultValue_3(pd, DEFAULT_DRIFT_HANDLING_MODE.name_0);
  return pd;
}

function createEnabled(configDef){
  var pd, type;
  type = ($clinit_PropertySimpleType() , BOOLEAN_2);
  pd = new PropertyDefinitionSimple_1('enabled', 'Enables or disables the drift definition', true, type);
  pd.displayName = 'Enabled';
  pd.readOnly = false;
  pd.summary = true;
  pd.order = 2;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  pd.defaultValue = 'true';
  return pd;
}

function createExcludes(configDef, readOnly){
  var map, pd, path, type, pd_0, pattern, type_0, pd_1, pd_2;
  map = (path = (type = ($clinit_PropertySimpleType() , STRING_0) , pd_0 = new PropertyDefinitionSimple_1('path', "A file system directory path that is relative to (a sub-directory of) the base directory of the drift definition. The default is '.', the base directory itself.  Note that '/' and './' will be normalized to '.' for consistent handling.", true, type) , pd_0.displayName = 'Path' , pd_0.readOnly = readOnly , pd_0.summary = true , pd_0.order = 0 , pd_0.allowCustomEnumeratedValue = false , pd_0) , pattern = (type_0 = STRING_0 , pd_1 = new PropertyDefinitionSimple_1('pattern', 'Pathname pattern that must match for the items in the directory path to be excluded.', false, type_0) , pd_1.displayName = 'Pattern' , pd_1.readOnly = readOnly , pd_1.summary = true , pd_1.order = 1 , pd_1.allowCustomEnumeratedValue = false , pd_1) , pd_2 = new PropertyDefinitionMap_1('exclude', 'A pattern that specifies a file or directory to exclude.', true, initValues(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PropertyDefinition, [path, pattern])) , pd_2.displayName = 'Exclude' , pd_2.readOnly = readOnly , pd_2.summary = true , pd_2.order = 0 , pd_2);
  pd = new PropertyDefinitionList_1('excludes', 'A set of patterns that specify files and/or directories to exclude.', false, map);
  pd.displayName = 'Excludes';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 9;
  pd.configurationDefinition = configDef;
  return pd;
}

function createIncludes(configDef, readOnly){
  var map, pd, path, type, pd_0, constraint, pattern, type_0, pd_1, constraint_0, pd_2;
  map = (path = (type = ($clinit_PropertySimpleType() , STRING_0) , pd_0 = new PropertyDefinitionSimple_1('path', "A file system directory path that is relative to (a sub-directory of) the base directory of the drift definition. The default is '.', the base directory itself.  Note that '/' and './' will be normalized to '.' for consistent handling.", false, type) , pd_0.displayName = 'Path' , pd_0.readOnly = readOnly , pd_0.summary = true , pd_0.order = 0 , pd_0.allowCustomEnumeratedValue = false , pd_0.defaultValue = '.' , constraint = new RegexConstraint_0 , constraint.details = '[ \\.\\-\\(\\)\\w/\\\\]+' , $addConstraints(pd_0, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint])) , pd_0) , pattern = (type_0 = STRING_0 , pd_1 = new PropertyDefinitionSimple_1('pattern', "Pathname pattern that must match for the items in the directory path to be included. '*' matches zero or more characters, '?' matches one character. For example, '*.txt' (no quotes) will match text files in the filter's path directory.  '**/*.txt' will match text files in any subdirectory below the filter's path directory.", false, type_0) , pd_1.displayName = 'Pattern' , pd_1.readOnly = readOnly , pd_1.summary = true , pd_1.order = 1 , pd_1.allowCustomEnumeratedValue = false , constraint_0 = new RegexConstraint_0 , constraint_0.details = '[ \\.\\-\\(\\)\\w/\\\\\\?\\*]+' , $addConstraints(pd_1, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint_0])) , pd_1) , pd_2 = new PropertyDefinitionMap_1('include', 'A pattern that specifies a file or directory to include.', true, initValues(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PropertyDefinition, [path, pattern])) , pd_2.displayName = 'Include' , pd_2.readOnly = readOnly , pd_2.summary = true , pd_2.order = 0 , pd_2);
  pd = new PropertyDefinitionList_1('includes', 'A set of patterns that specify files and/or directories to include.', false, map);
  pd.displayName = 'Includes';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 8;
  pd.configurationDefinition = configDef;
  return pd;
}

function createInterval_0(configDef){
  var pd, type;
  type = ($clinit_PropertySimpleType() , LONG_0);
  pd = new PropertyDefinitionSimple_1('interval', 'The frequency in seconds in which drift detection should run. Defaults to 1800 seconds (i.e. 30 minutes)', false, type);
  pd.displayName = 'Interval';
  pd.readOnly = false;
  pd.summary = true;
  pd.order = 6;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  pd.defaultValue = '1800';
  return pd;
}

function createName(configDef, readOnly){
  var constraint, pd, type;
  type = ($clinit_PropertySimpleType() , STRING_0);
  pd = new PropertyDefinitionSimple_1('name', 'The drift detection definition name', true, type);
  pd.displayName = 'Drift Definition Name';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 0;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  constraint = new RegexConstraint_0;
  constraint.details = '[ \\.\\-\\w]+';
  $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint]));
  return pd;
}

function createPinned(configDef, readOnly){
  var pd, type;
  type = ($clinit_PropertySimpleType() , BOOLEAN_2);
  pd = new PropertyDefinitionSimple_1('pinned', 'If set, pins the snapshot that the agent uses for comparing files during drift detection. Normally, the agent compares those files being monitored for drift against the latest snapshot. If you pin a snapshot, the agent will use that pinned version to compare against files being monitored for drift', true, type);
  pd.displayName = 'Pinned';
  pd.defaultValue = 'false';
  pd.order = 5;
  pd.readOnly = readOnly;
  pd.configurationDefinition = configDef;
  return pd;
}

var DEFAULT_DRIFT_HANDLING_MODE, EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, EXISTING_TEMPLATE_INSTANCE, INSTANCE_0, INSTANCE_FOR_EXISTING_CONFIGS, NEW_PINNED_TEMPLATE_INSTANCE, NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, NEW_TEMPLATE_INSTANCE;
function serialize_253(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function $addExclude(this$static, filter){
  var filterMap, filtersList;
  filtersList = $getList(this$static.configuration, 'excludes');
  if (!filtersList) {
    filtersList = new PropertyList_1('excludes');
    $put_4(this$static.configuration, filtersList);
  }
  filterMap = new PropertyMap_1('exclude');
  $put_5(filterMap, new PropertySimple_1('path', useForwardSlash(filter.path)));
  $put_5(filterMap, new PropertySimple_1('pattern', filter.pattern));
  $add_11(filtersList, filterMap);
}

function $addInclude(this$static, filter){
  var filterMap, filtersList;
  filtersList = $getList(this$static.configuration, 'includes');
  if (!filtersList) {
    filtersList = new PropertyList_1('includes');
    $put_4(this$static.configuration, filtersList);
  }
  filterMap = new PropertyMap_1('include');
  $put_5(filterMap, new PropertySimple_1('path', useForwardSlash(filter.path)));
  $put_5(filterMap, new PropertySimple_1('pattern', filter.pattern));
  $add_11(filtersList, filterMap);
}

function $setAttached(this$static, attached){
  this$static.attached = attached.value_0;
  $setAttachedProperty(this$static, attached.value_0);
}

function $setAttachedProperty(this$static, attached){
  $put_4(this$static.configuration, new PropertySimple_1('attached', '' + attached));
}

function $setBasedir(this$static, basedir){
  var basedirMap, valueContext, valueName;
  if (!basedir) {
    throw new NullPointerException_1('basedir is null');
  }
  if (!basedir.context) {
    throw new NullPointerException_1('valueContext is null');
  }
  if (basedir.name_0 == null) {
    throw new NullPointerException_1('valueName is null');
  }
  valueContext = basedir.context.name_0;
  valueName = basedir.name_0;
  basedirMap = new PropertyMap_1('basedir');
  $put_5(basedirMap, new PropertySimple_1('valueContext', valueContext));
  $put_5(basedirMap, new PropertySimple_1('valueName', ($clinit_StringUtils() , null != valueName?$replace_0(valueName, 92, 47):null)));
  $put_4(this$static.configuration, basedirMap);
}

function $setExcludes(this$static, excludesFilters){
  var filter, filter$iterator;
  $remove_18(this$static.configuration, 'excludes');
  if (excludesFilters) {
    for (filter$iterator = excludesFilters.iterator(); filter$iterator.hasNext();) {
      filter = dynamicCast(filter$iterator.next_0(), Q$Filter);
      $addExclude(this$static, filter);
    }
  }
}

function $setIncludes(this$static, includesFilters){
  var filter, filter$iterator;
  $remove_18(this$static.configuration, 'includes');
  if (includesFilters) {
    for (filter$iterator = includesFilters.iterator(); filter$iterator.hasNext();) {
      filter = dynamicCast(filter$iterator.next_0(), Q$Filter);
      $addInclude(this$static, filter);
    }
  }
}

function $setPinned(this$static, isPinned){
  this$static.isPinned = isPinned;
  $put_4(this$static.configuration, new PropertySimple_1('pinned', ($clinit_Boolean() , isPinned?TRUE:FALSE)));
}

function $setTemplate(this$static, template){
  this$static.template = template;
}

function DriftDefinition_1(c){
  var baseDir;
  $$init_12(this);
  this.configuration = c;
  baseDir = $getBasedir(this);
  !!baseDir && $setBasedir(this, baseDir);
  $setIncludes(this, $getFilters(this, 'includes'));
  $setExcludes(this, $getFilters(this, 'excludes'));
  this.name_0 = $getSimpleValue(this.configuration, 'name', null);
  this.description = $getSimpleValue(this.configuration, 'description', null);
  this.isEnabled = $equals_6($getSimpleValue(this.configuration, 'enabled', 'true'), 'true');
  this.interval = valueOf_50(__parseAndValidateLong($getSimpleValue(this.configuration, 'interval', '1800'))).value_0;
  this.driftHandlingMode = valueOf_101($getSimpleValue(this.configuration, 'driftHandlingMode', ($clinit_DriftConfigurationDefinition() , DEFAULT_DRIFT_HANDLING_MODE).name_0));
  this.isPinned = ($clinit_Boolean() , $equalsIgnoreCase('true', $getSimpleValue(this.configuration, 'pinned', 'false'))?TRUE:FALSE).value_0;
  this.attached = $equals_6($getSimpleValue(this.configuration, 'attached', 'true'), 'true');
}

defineSeed(1238, 1, makeCastMap([Q$Serializable, Q$DriftDefinition]), DriftDefinition_1);
function $compare_5(this$static, dc1, dc2){
  var filters1, filters2, hash1, hash2, results;
  if (this$static.compareMode != 1) {
    if (dc1.name_0 != null) {
      if (dc2.name_0 != null) {
        results = compareTo_11(dc1.name_0, dc2.name_0);
        if (results != 0) {
          return results;
        }
      }
       else {
        return 1;
      }
    }
     else if (dc2.name_0 != null) {
      return -1;
    }
    if (dc1.description != null) {
      if (dc2.description != null) {
        results = compareTo_11(dc1.description, dc2.description);
        if (results != 0) {
          return results;
        }
      }
       else {
        return 1;
      }
    }
     else if (dc2.description != null) {
      return -1;
    }
    if (neq(dc1.interval, dc2.interval)) {
      return lt(dc1.interval, dc2.interval)?-1:1;
    }
    if (dc1.driftHandlingMode != dc2.driftHandlingMode) {
      return dc1.driftHandlingMode.ordinal < dc2.driftHandlingMode.ordinal?-1:1;
    }
    if (dc1.isEnabled != dc2.isEnabled) {
      return dc1.isEnabled?1:-1;
    }
    if (dc1.attached != dc2.attached) {
      return dc1.attached?1:-1;
    }
    if (dc1.isPinned != dc2.isPinned) {
      return dc1.isPinned?1:-1;
    }
  }
  if (this$static.compareMode != 0) {
    if ($getBasedir(dc1)) {
      if (!$equals_33($getBasedir(dc1), $getBasedir(dc2))) {
        hash1 = $hashCode_20($getBasedir(dc1));
        hash2 = $getBasedir(dc2)?$hashCode_20($getBasedir(dc2)):0;
        return hash1 < hash2?-1:1;
      }
    }
     else if ($getBasedir(dc2)) {
      return -1;
    }
    filters1 = $getFilters(dc1, 'includes');
    filters2 = $getFilters(dc2, 'includes');
    results = $compareFilters(filters1, filters2);
    if (results != 0) {
      return results;
    }
    filters1 = $getFilters(dc1, 'excludes');
    filters2 = $getFilters(dc2, 'excludes');
    results = $compareFilters(filters1, filters2);
    if (results != 0) {
      return results;
    }
  }
  return 0;
}

function $compareFilters(filters1, filters2){
  if (!filters1) {
    return !filters2?0:-1;
  }
   else if (!filters2) {
    return 1;
  }
  if (filters1.size_1() != filters2.size_1()) {
    return filters1.size_1() < filters2.size_1()?-1:1;
  }
  if (!filters1.containsAll(filters2)) {
    return -1;
  }
  return 0;
}

function DriftDefinitionComparator_0(){
  this.compareMode = 1;
}

defineSeed(1240, 1, makeCastMap([Q$Comparator]), DriftDefinitionComparator_0);
_.compare = function compare_7(dc1, dc2){
  return $compare_5(this, dynamicCast(dc1, Q$DriftDefinition), dynamicCast(dc2, Q$DriftDefinition));
}
;
_.compareMode = 0;
function DriftDefinitionComposite_0(){
}

defineSeed(1241, 1, makeCastMap([Q$Serializable, Q$DriftDefinitionComposite]), DriftDefinitionComposite_0);
_.driftDefinition = null;
_.mostRecentChangeset = null;
function deserialize_269(streamReader, instance){
  setDriftDefinition(instance, dynamicCast($readObject(streamReader), Q$DriftDefinition));
  setMostRecentChangeset(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSet));
}

function instantiate_262(streamReader){
  return new DriftDefinitionComposite_0;
}

function setDriftDefinition(instance, value){
  instance.driftDefinition = value;
}

function setMostRecentChangeset(instance, value){
  instance.mostRecentChangeset = value;
}

function $setTemplateDefinition(this$static, templateDefinition){
  this$static.configuration = $deepCopyWithoutProxies(templateDefinition.configuration);
  this$static.name_0 = templateDefinition.name_0;
  this$static.description = templateDefinition.description;
}

function DriftDetails_0(){
}

defineSeed(1246, 1, makeCastMap([Q$Serializable, Q$DriftDetails]), DriftDetails_0);
_.drift = null;
_.isBinary = false;
_.newFileStatus = null;
_.oldFileStatus = null;
_.previousChangeSet = null;
function deserialize_272(streamReader, instance){
  setDrift_0(instance, dynamicCast($readObject(streamReader), Q$Drift));
  setIsBinary(instance, $readBoolean(streamReader));
  setNewFileStatus(instance, dynamicCast($readObject(streamReader), Q$DriftFileStatus));
  setOldFileStatus(instance, dynamicCast($readObject(streamReader), Q$DriftFileStatus));
  setPreviousChangeSet(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSet));
}

function instantiate_265(streamReader){
  return new DriftDetails_0;
}

function setDrift_0(instance, value){
  instance.drift = value;
}

function setIsBinary(instance, value){
  instance.isBinary = value;
}

function setNewFileStatus(instance, value){
  instance.newFileStatus = value;
}

function setOldFileStatus(instance, value){
  instance.oldFileStatus = value;
}

function setPreviousChangeSet(instance, value){
  instance.previousChangeSet = value;
}

function $clinit_DriftFileStatus(){
  $clinit_DriftFileStatus = nullMethod;
  EMPTY = new DriftFileStatus_0('EMPTY', 0);
  REQUESTED_0 = new DriftFileStatus_0('REQUESTED', 1);
  LOADED = new DriftFileStatus_0('LOADED', 2);
  $VALUES_93 = initValues(_3Lorg_rhq_core_domain_drift_DriftFileStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DriftFileStatus, [EMPTY, REQUESTED_0, LOADED]);
}

function DriftFileStatus_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_102(name_0){
  $clinit_DriftFileStatus();
  return valueOf(($clinit_DriftFileStatus$Map() , $MAP_93), name_0);
}

function values_96(){
  $clinit_DriftFileStatus();
  return $VALUES_93;
}

defineSeed(1248, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$DriftFileStatus]), DriftFileStatus_0);
var $VALUES_93, EMPTY, LOADED, REQUESTED_0;
function $clinit_DriftFileStatus$Map(){
  $clinit_DriftFileStatus$Map = nullMethod;
  $MAP_93 = createValueOfMap(($clinit_DriftFileStatus() , $VALUES_93));
}

var $MAP_93;
function deserialize_273(streamReader, instance){
}

function instantiate_266(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_DriftFileStatus() , $clinit_DriftFileStatus() , $VALUES_93);
  return values[ordinal];
}

function serialize_257(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function $getDriftDirectories(this$static){
  if (!this$static.directoryMap) {
    return null;
  }
  return this$static.directoryMap.values_0();
}

function $getDriftInstances(this$static){
  if (!this$static.driftMap) {
    return null;
  }
  return this$static.driftMap.values_0();
}

function DriftSnapshot_0(){
}

defineSeed(1251, 1, makeCastMap([Q$Serializable, Q$DriftSnapshot]), DriftSnapshot_0);
_.directoryMap = null;
_.driftMap = null;
_.request = null;
_.version_0 = -1;
function DriftSnapshot$DriftSnapshotDirectory_0(){
}

defineSeed(1252, 1, makeCastMap([Q$Serializable, Q$DriftSnapshot$DriftSnapshotDirectory]), DriftSnapshot$DriftSnapshotDirectory_0);
_.added = 0;
_.changed_0 = 0;
_.directoryPath = null;
_.files = 0;
_.removed = 0;
function DriftSnapshotRequest_0(){
}

function DriftSnapshotRequest_1(driftDefinitionId, version, directory, includeDriftDirectories, includeDriftInstances){
  this.driftDefinitionId = valueOf_49(driftDefinitionId);
  this.version_0 = !!version && version.value_0 >= 0?version:null;
  this.startVersion = valueOf_49(0);
  if (null != directory) {
    directory = $trim(directory);
    this.directory = $equals_6('', directory)?'./':directory;
  }
  this.includeDriftDirectories = includeDriftDirectories;
  this.includeDriftInstances = includeDriftInstances;
}

function DriftSnapshotRequest_2(templateChangesetIdString, directory, includeDriftDirectories, includeDriftInstances){
  this.templateChangeSetId = templateChangesetIdString;
  if (null != directory) {
    directory = $trim(directory);
    this.directory = $equals_6('', directory)?'./':directory;
  }
  this.includeDriftDirectories = includeDriftDirectories;
  this.includeDriftInstances = includeDriftInstances;
  this.driftDefinitionId = null;
  this.version_0 = valueOf_49(0);
  this.startVersion = valueOf_49(0);
}

defineSeed(1253, 1, makeCastMap([Q$Serializable, Q$DriftSnapshotRequest]), DriftSnapshotRequest_0, DriftSnapshotRequest_1, DriftSnapshotRequest_2);
_.toString$ = function toString_122(){
  return 'DriftSnapshotRequest [directory=' + this.directory + ', driftDefinitionId=' + this.driftDefinitionId + ', includeDriftDirectories=' + this.includeDriftDirectories + ', includeDriftInstances=' + this.includeDriftInstances + ', startVersion=' + this.startVersion + ', templateChangeSetId=' + this.templateChangeSetId + ', version=' + this.version_0 + ']';
}
;
_.directory = null;
_.driftDefinitionId = null;
_.includeDriftDirectories = false;
_.includeDriftInstances = false;
_.startVersion = null;
_.templateChangeSetId = null;
_.version_0 = null;
function deserialize_274(streamReader, instance){
  setDirectory(instance, $getString(streamReader, $readInt(streamReader)));
  setDriftDefinitionId(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setIncludeDriftDirectories(instance, $readBoolean(streamReader));
  setIncludeDriftInstances(instance, $readBoolean(streamReader));
  setStartVersion(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setTemplateChangeSetId(instance, $getString(streamReader, $readInt(streamReader)));
  setVersion_4(instance, dynamicCast($readObject(streamReader), Q$Integer));
}

function instantiate_267(streamReader){
  return new DriftSnapshotRequest_0;
}

function serialize_258(streamWriter, instance){
  $writeString(streamWriter, instance.directory);
  $writeObject(streamWriter, instance.driftDefinitionId);
  $writeBoolean(streamWriter, instance.includeDriftDirectories);
  $writeBoolean(streamWriter, instance.includeDriftInstances);
  $writeObject(streamWriter, instance.startVersion);
  $writeString(streamWriter, instance.templateChangeSetId);
  $writeObject(streamWriter, instance.version_0);
}

function setDirectory(instance, value){
  instance.directory = value;
}

function setDriftDefinitionId(instance, value){
  instance.driftDefinitionId = value;
}

function setIncludeDriftDirectories(instance, value){
  instance.includeDriftDirectories = value;
}

function setIncludeDriftInstances(instance, value){
  instance.includeDriftInstances = value;
}

function setStartVersion(instance, value){
  instance.startVersion = value;
}

function setTemplateChangeSetId(instance, value){
  instance.templateChangeSetId = value;
}

function setVersion_4(instance, value){
  instance.version_0 = value;
}

function deserialize_275(streamReader, instance){
  setAdded(instance, $readInt(streamReader));
  setChanged(instance, $readInt(streamReader));
  setDirectoryPath(instance, $getString(streamReader, $readInt(streamReader)));
  setFiles(instance, $readInt(streamReader));
  setRemoved(instance, $readInt(streamReader));
}

function instantiate_268(streamReader){
  return new DriftSnapshot$DriftSnapshotDirectory_0;
}

function setAdded(instance, value){
  instance.added = value;
}

function setChanged(instance, value){
  instance.changed_0 = value;
}

function setDirectoryPath(instance, value){
  instance.directoryPath = value;
}

function setFiles(instance, value){
  instance.files = value;
}

function setRemoved(instance, value){
  instance.removed = value;
}

function deserialize_276(streamReader, instance){
  setDirectoryMap(instance, dynamicCast($readObject(streamReader), Q$Map));
  setDriftMap(instance, dynamicCast($readObject(streamReader), Q$Map));
  setRequest(instance, dynamicCast($readObject(streamReader), Q$DriftSnapshotRequest));
  setVersion_5(instance, $readInt(streamReader));
}

function instantiate_269(streamReader){
  return new DriftSnapshot_0;
}

function setDirectoryMap(instance, value){
  instance.directoryMap = value;
}

function setDriftMap(instance, value){
  instance.driftMap = value;
}

function setRequest(instance, value){
  instance.request = value;
}

function setVersion_5(instance, value){
  instance.version_0 = value;
}

function FileDiffReport_0(){
}

defineSeed(1257, 1, makeCastMap([Q$Serializable, Q$FileDiffReport]), FileDiffReport_0);
_.changes = 0;
_.diff = null;
function deserialize_277(streamReader, instance){
  setChanges(instance, $readInt(streamReader));
  instance.diff = dynamicCast($readObject(streamReader), Q$List);
}

function instantiate_270(streamReader){
  return new FileDiffReport_0;
}

function setChanges(instance, value){
  instance.changes = value;
}

function JPADrift_0(){
  this.ctime = valueOf_50(N1_longLit);
}

defineSeed(1260, 1, makeCastMap([Q$Serializable, Q$Drift]), JPADrift_0);
_.getCategory = function getCategory(){
  return this.category;
}
;
_.getChangeSet = function getChangeSet(){
  return this.changeSet;
}
;
_.getCtime = function getCtime(){
  return this.ctime;
}
;
_.getId = function getId(){
  return '' + this.id;
}
;
_.getNewDriftFile = function getNewDriftFile(){
  return this.newDriftFile;
}
;
_.getOldDriftFile = function getOldDriftFile(){
  return this.oldDriftFile;
}
;
_.getPath = function getPath(){
  return this.path;
}
;
_.toString$ = function toString_124(){
  var $e0, sb;
  sb = new StringBuilder_1('JPADrift [');
  $append_13($append_13($append_13(sb, 'id=' + this.id), ', category=' + this.category), ', path=' + this.path);
  try {
    $append_13(sb, ', changeSet=' + this.changeSet);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (!instanceOf($e0, Q$Exception))
      throw $e0;
  }
  sb.impl.string += ']';
  return sb.impl.string;
}
;
_.category = null;
_.changeSet = null;
_.directory = null;
_.id = 0;
_.newDriftFile = null;
_.oldDriftFile = null;
_.path = null;
function JPADriftChangeSet_0(){
  this.ctime = valueOf_50(N1_longLit);
  this.drifts = new LinkedHashSet_0;
}

defineSeed(1261, 1, makeCastMap([Q$Serializable, Q$DriftChangeSet, Q$JPADriftChangeSet]), JPADriftChangeSet_0);
_.getCategory_0 = function getCategory_0(){
  return this.category;
}
;
_.getCtime = function getCtime_0(){
  return this.ctime;
}
;
_.getDriftDefinitionId = function getDriftDefinitionId(){
  if (!this.driftDefinition) {
    return 0;
  }
  return this.driftDefinition.id;
}
;
_.getDriftHandlingMode = function getDriftHandlingMode(){
  return this.driftHandlingMode;
}
;
_.getId = function getId_0(){
  return '' + this.id;
}
;
_.getVersion = function getVersion(){
  return this.version_0;
}
;
_.toString$ = function toString_125(){
  return 'JPADriftChangeSet [id=' + this.id + ', resource=' + this.resource + ', version=' + this.version_0 + ']';
}
;
_.category = null;
_.driftDefinition = null;
_.driftHandlingMode = null;
_.id = 0;
_.initialDriftSet = null;
_.resource = null;
_.version_0 = 0;
function deserialize_278(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setCategory_4(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSetCategory));
  setCtime_16(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDriftDefinition_0(instance, dynamicCast($readObject(streamReader), Q$DriftDefinition));
  setDriftHandlingMode_0(instance, dynamicCast($readObject(streamReader), Q$DriftConfigurationDefinition$DriftHandlingMode));
  setDrifts(instance, dynamicCast($readObject(streamReader), Q$Set));
  setId_64(instance, $readInt(streamReader));
  setInitialDriftSet(instance, dynamicCast($readObject(streamReader), Q$JPADriftSet));
  setResource_11(instance, dynamicCast($readObject(streamReader), Q$Resource));
  setVersion_6(instance, $readInt(streamReader));
}

function instantiate_271(streamReader){
  return new JPADriftChangeSet_0;
}

function serialize_259(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.ctime);
  $writeObject(streamWriter, instance.driftDefinition);
  $writeObject(streamWriter, instance.driftHandlingMode);
  $writeObject(streamWriter, instance.drifts);
  $writeInt(streamWriter, instance.id);
  $writeObject(streamWriter, instance.initialDriftSet);
  $writeObject(streamWriter, instance.resource);
  $writeInt(streamWriter, instance.version_0);
}

function setCategory_4(instance, value){
  instance.category = value;
}

function setCtime_16(instance, value){
  instance.ctime = value;
}

function setDriftDefinition_0(instance, value){
  instance.driftDefinition = value;
}

function setDriftHandlingMode_0(instance, value){
  instance.driftHandlingMode = value;
}

function setDrifts(instance, value){
  instance.drifts = value;
}

function setId_64(instance, value){
  instance.id = value;
}

function setInitialDriftSet(instance, value){
  instance.initialDriftSet = value;
}

function setResource_11(instance, value){
  instance.resource = value;
}

function setVersion_6(instance, value){
  instance.version_0 = value;
}

function JPADriftFile_0(){
  this.ctime = valueOf_50(N1_longLit);
  this.status_0 = ($clinit_DriftFileStatus() , EMPTY);
}

defineSeed(1263, 1217, makeCastMap([Q$Serializable, Q$JPADriftFile]), JPADriftFile_0);
_.getHashId = function getHashId(){
  return this.hashId;
}
;
_.toString$ = function toString_126(){
  return 'JPADriftFile [hashId=' + this.hashId + ', status=' + this.status_0 + ']';
}
;
_.hashId = null;
function deserialize_279(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setHashId(instance, $getString(streamReader, $readInt(streamReader)));
  instance.ctime = dynamicCast($readObject(streamReader), Q$Long);
  instance.dataSize = dynamicCast($readObject(streamReader), Q$Long);
  instance.status_0 = dynamicCast($readObject(streamReader), Q$DriftFileStatus);
}

function instantiate_272(streamReader){
  return new JPADriftFile_0;
}

function serialize_260(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-2'), Q$String));
  $writeString(streamWriter, instance.hashId);
  $writeObject(streamWriter, instance.ctime);
  $writeObject(streamWriter, instance.dataSize);
  $writeObject(streamWriter, instance.status_0);
}

function setHashId(instance, value){
  instance.hashId = value;
}

function JPADriftSet_0(){
  this.drifts = new LinkedHashSet_0;
}

defineSeed(1265, 1, makeCastMap([Q$Serializable, Q$JPADriftSet]), JPADriftSet_0);
_.id = 0;
function deserialize_280(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setDrifts_0(instance, dynamicCast($readObject(streamReader), Q$Set));
  setId_65(instance, $readInt(streamReader));
}

function instantiate_273(streamReader){
  return new JPADriftSet_0;
}

function serialize_261(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeObject(streamWriter, instance.drifts);
  $writeInt(streamWriter, instance.id);
}

function setDrifts_0(instance, value){
  instance.drifts = value;
}

function setId_65(instance, value){
  instance.id = value;
}

function deserialize_281(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setCategory_5(instance, dynamicCast($readObject(streamReader), Q$DriftCategory));
  setChangeSet(instance, dynamicCast($readObject(streamReader), Q$JPADriftChangeSet));
  setCtime_17(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDirectory_0(instance, $getString(streamReader, $readInt(streamReader)));
  setId_66(instance, $readInt(streamReader));
  setNewDriftFile(instance, dynamicCast($readObject(streamReader), Q$JPADriftFile));
  setOldDriftFile(instance, dynamicCast($readObject(streamReader), Q$JPADriftFile));
  setPath_0(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_274(streamReader){
  return new JPADrift_0;
}

function serialize_262(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.changeSet);
  $writeObject(streamWriter, instance.ctime);
  $writeString(streamWriter, instance.directory);
  $writeInt(streamWriter, instance.id);
  $writeObject(streamWriter, instance.newDriftFile);
  $writeObject(streamWriter, instance.oldDriftFile);
  $writeString(streamWriter, instance.path);
}

function setCategory_5(instance, value){
  instance.category = value;
}

function setChangeSet(instance, value){
  instance.changeSet = value;
}

function setCtime_17(instance, value){
  instance.ctime = value;
}

function setDirectory_0(instance, value){
  instance.directory = value;
}

function setId_66(instance, value){
  instance.id = value;
}

function setNewDriftFile(instance, value){
  instance.newDriftFile = value;
}

function setOldDriftFile(instance, value){
  instance.oldDriftFile = value;
}

function setPath_0(instance, value){
  instance.path = value;
}

function DriftChangeSetDTO_0(){
  this.drifts = new HashSet_0;
}

defineSeed(1268, 1, makeCastMap([Q$Serializable, Q$DriftChangeSet, Q$DriftChangeSetDTO]), DriftChangeSetDTO_0);
_.getCategory_0 = function getCategory_1(){
  return this.category;
}
;
_.getCtime = function getCtime_1(){
  return this.ctime;
}
;
_.getDriftDefinitionId = function getDriftDefinitionId_0(){
  return this.driftDefId;
}
;
_.getDriftHandlingMode = function getDriftHandlingMode_0(){
  return this.driftHandlingMode;
}
;
_.getId = function getId_1(){
  return this.id;
}
;
_.getVersion = function getVersion_0(){
  return this.version_0;
}
;
_.category = null;
_.ctime = null;
_.driftDefId = 0;
_.driftHandlingMode = null;
_.id = null;
_.resourceId = 0;
_.version_0 = 0;
function deserialize_282(streamReader, instance){
  setCategory_6(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSetCategory));
  setCtime_18(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDriftDefId(instance, $readInt(streamReader));
  setDriftHandlingMode_1(instance, dynamicCast($readObject(streamReader), Q$DriftConfigurationDefinition$DriftHandlingMode));
  setDrifts_1(instance, dynamicCast($readObject(streamReader), Q$Set));
  setId_67(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId(instance, $readInt(streamReader));
  setVersion_7(instance, $readInt(streamReader));
}

function instantiate_275(streamReader){
  return new DriftChangeSetDTO_0;
}

function serialize_263(streamWriter, instance){
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.ctime);
  $writeInt(streamWriter, instance.driftDefId);
  $writeObject(streamWriter, instance.driftHandlingMode);
  $writeObject(streamWriter, instance.drifts);
  $writeString(streamWriter, instance.id);
  $writeInt(streamWriter, instance.resourceId);
  $writeInt(streamWriter, instance.version_0);
}

function setCategory_6(instance, value){
  instance.category = value;
}

function setCtime_18(instance, value){
  instance.ctime = value;
}

function setDriftDefId(instance, value){
  instance.driftDefId = value;
}

function setDriftHandlingMode_1(instance, value){
  instance.driftHandlingMode = value;
}

function setDrifts_1(instance, value){
  instance.drifts = value;
}

function setId_67(instance, value){
  instance.id = value;
}

function setResourceId(instance, value){
  instance.resourceId = value;
}

function setVersion_7(instance, value){
  instance.version_0 = value;
}

function DriftDTO_0(){
}

defineSeed(1270, 1, makeCastMap([Q$Serializable, Q$Drift]), DriftDTO_0);
_.getCategory = function getCategory_2(){
  return this.category;
}
;
_.getChangeSet = function getChangeSet_0(){
  return this.changeSet;
}
;
_.getCtime = function getCtime_2(){
  return this.ctime;
}
;
_.getId = function getId_2(){
  return this.id;
}
;
_.getNewDriftFile = function getNewDriftFile_0(){
  return this.newDriftFile;
}
;
_.getOldDriftFile = function getOldDriftFile_0(){
  return this.oldDriftFile;
}
;
_.getPath = function getPath_0(){
  return this.path;
}
;
_.category = null;
_.changeSet = null;
_.ctime = null;
_.directory = null;
_.id = null;
_.newDriftFile = null;
_.oldDriftFile = null;
_.path = null;
function deserialize_283(streamReader, instance){
  setCategory_7(instance, dynamicCast($readObject(streamReader), Q$DriftCategory));
  setChangeSet_0(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSetDTO));
  setCtime_19(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDirectory_1(instance, $getString(streamReader, $readInt(streamReader)));
  setId_68(instance, $getString(streamReader, $readInt(streamReader)));
  setNewDriftFile_0(instance, dynamicCast($readObject(streamReader), Q$DriftFileDTO));
  setOldDriftFile_0(instance, dynamicCast($readObject(streamReader), Q$DriftFileDTO));
  setPath_1(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_276(streamReader){
  return new DriftDTO_0;
}

function serialize_264(streamWriter, instance){
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.changeSet);
  $writeObject(streamWriter, instance.ctime);
  $writeString(streamWriter, instance.directory);
  $writeString(streamWriter, instance.id);
  $writeObject(streamWriter, instance.newDriftFile);
  $writeObject(streamWriter, instance.oldDriftFile);
  $writeString(streamWriter, instance.path);
}

function setCategory_7(instance, value){
  instance.category = value;
}

function setChangeSet_0(instance, value){
  instance.changeSet = value;
}

function setCtime_19(instance, value){
  instance.ctime = value;
}

function setDirectory_1(instance, value){
  instance.directory = value;
}

function setId_68(instance, value){
  instance.id = value;
}

function setNewDriftFile_0(instance, value){
  instance.newDriftFile = value;
}

function setOldDriftFile_0(instance, value){
  instance.oldDriftFile = value;
}

function setPath_1(instance, value){
  instance.path = value;
}

function DriftFileDTO_0(){
}

defineSeed(1272, 1, makeCastMap([Q$Serializable, Q$DriftFileDTO]), DriftFileDTO_0);
_.getHashId = function getHashId_0(){
  return this.hash_0;
}
;
_.ctime = null;
_.hash_0 = null;
_.size_0 = null;
_.status_0 = null;
function deserialize_284(streamReader, instance){
  setCtime_20(instance, dynamicCast($readObject(streamReader), Q$Long));
  setHash(instance, $getString(streamReader, $readInt(streamReader)));
  setSize(instance, dynamicCast($readObject(streamReader), Q$Long));
  setStatus_5(instance, dynamicCast($readObject(streamReader), Q$DriftFileStatus));
}

function instantiate_277(streamReader){
  return new DriftFileDTO_0;
}

function serialize_265(streamWriter, instance){
  $writeObject(streamWriter, instance.ctime);
  $writeString(streamWriter, instance.hash_0);
  $writeObject(streamWriter, instance.size_0);
  $writeObject(streamWriter, instance.status_0);
}

function setCtime_20(instance, value){
  instance.ctime = value;
}

function setHash(instance, value){
  instance.hash_0 = value;
}

function setSize(instance, value){
  instance.size_0 = value;
}

function setStatus_5(instance, value){
  instance.status_0 = value;
}

function deserialize_286(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_279(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_event_EventSeverity_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$EventSeverity_$1]), Q$EventSeverity, size, 0);
}

function serialize_267(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function EventComposite_0(){
}

defineSeed(1284, 1, makeCastMap([Q$Serializable, Q$EventComposite]), EventComposite_0);
_.eventDetail = null;
_.eventId = 0;
_.resourceAncestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
_.severity = null;
_.sourceLocation = null;
_.timestamp = N1_longLit;
function deserialize_290(streamReader, instance){
  setEventDetail_0(instance, $getString(streamReader, $readInt(streamReader)));
  setEventId(instance, $readInt(streamReader));
  setResourceAncestry(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_1(instance, $readInt(streamReader));
  setResourceName(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_0(instance, $readInt(streamReader));
  setSeverity_1(instance, dynamicCast($readObject(streamReader), Q$EventSeverity));
  setSourceLocation(instance, $getString(streamReader, $readInt(streamReader)));
  setTimestamp_1(instance, $readLong(streamReader));
}

function instantiate_283(streamReader){
  return new EventComposite_0;
}

function setEventDetail_0(instance, value){
  instance.eventDetail = value;
}

function setEventId(instance, value){
  instance.eventId = value;
}

function setResourceAncestry(instance, value){
  instance.resourceAncestry = value;
}

function setResourceId_1(instance, value){
  instance.resourceId = value;
}

function setResourceName(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_0(instance, value){
  instance.resourceTypeId = value;
}

function setSeverity_1(instance, value){
  instance.severity = value;
}

function setSourceLocation(instance, value){
  instance.sourceLocation = value;
}

function setTimestamp_1(instance, value){
  instance.timestamp = value;
}

function AgentInstallInfo_0(){
  this.steps = new ArrayList_0;
}

defineSeed(1286, 1, makeCastMap([Q$Serializable, Q$AgentInstallInfo]), AgentInstallInfo_0);
_.agentAddress = null;
_.owner = null;
_.path = null;
_.serverAddress = null;
_.version_0 = null;
function deserialize_291(streamReader, instance){
  setAgentAddress(instance, $getString(streamReader, $readInt(streamReader)));
  setOwner_1(instance, $getString(streamReader, $readInt(streamReader)));
  setPath_2(instance, $getString(streamReader, $readInt(streamReader)));
  setServerAddress(instance, $getString(streamReader, $readInt(streamReader)));
  instance.steps = dynamicCast($readObject(streamReader), Q$List);
  setVersion_8(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_284(streamReader){
  return new AgentInstallInfo_0;
}

function setAgentAddress(instance, value){
  instance.agentAddress = value;
}

function setOwner_1(instance, value){
  instance.owner = value;
}

function setPath_2(instance, value){
  instance.path = value;
}

function setServerAddress(instance, value){
  instance.serverAddress = value;
}

function setVersion_8(instance, value){
  instance.version_0 = value;
}

function AgentInstallStep_0(){
}

defineSeed(1288, 1, makeCastMap([Q$Serializable, Q$AgentInstallStep]), AgentInstallStep_0);
_.toString$ = function toString_131(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_11($append_13($append_10($append_13($append_13($append_13($append_13((builder.impl.string += 'AgentInstallStep [description=' , builder), this.description), ', result='), this.result), ', resultCode='), this.resultCode), ', duration='), this.duration), ']');
  return builder.impl.string;
}
;
_.command = null;
_.description = null;
_.duration = P0_longLit;
_.result = null;
_.resultCode = 0;
function deserialize_292(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_285(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_install_remote_AgentInstallStep_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$AgentInstallStep, size, 0);
}

function deserialize_293(streamReader, instance){
  setCommand(instance, $getString(streamReader, $readInt(streamReader)));
  setDescription_23(instance, $getString(streamReader, $readInt(streamReader)));
  setDuration(instance, $readLong(streamReader));
  setResult_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResultCode(instance, $readInt(streamReader));
}

function instantiate_286(streamReader){
  return new AgentInstallStep_0;
}

function setCommand(instance, value){
  instance.command = value;
}

function setDescription_23(instance, value){
  instance.description = value;
}

function setDuration(instance, value){
  instance.duration = value;
}

function setResult_0(instance, value){
  instance.result = value;
}

function setResultCode(instance, value){
  instance.resultCode = value;
}

function RemoteAccessInfo_0(host, port, user, password){
  this.host_0 = host;
  this.port = port;
  this.user = user;
  this.password = password;
}

defineSeed(1291, 1, makeCastMap([Q$Serializable]), RemoteAccessInfo_0);
_.host_0 = null;
_.key_0 = null;
_.password = null;
_.port = 22;
_.user = null;
function serialize_271(streamWriter, instance){
  $writeString(streamWriter, instance.host_0);
  $writeObject(streamWriter, instance.key_0);
  $writeString(streamWriter, instance.password);
  $writeInt(streamWriter, instance.port);
  $writeString(streamWriter, instance.user);
}

function serialize_272(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function $toString_12(this$static){
  return 'Min: ' + this$static.min_0 + ', Max: ' + this$static.max_0 + ', Avg: ' + this$static.avg;
}

function MeasurementAggregate_0(){
}

defineSeed(1306, 1, makeCastMap([Q$Serializable, Q$MeasurementAggregate]), MeasurementAggregate_0);
_.toString$ = function toString_133(){
  return $toString_12(this);
}
;
_.avg = null;
_.max_0 = null;
_.min_0 = null;
function deserialize_299(streamReader, instance){
  instance.avg = dynamicCast($readObject(streamReader), Q$Double);
  instance.max_0 = dynamicCast($readObject(streamReader), Q$Double);
  instance.min_0 = dynamicCast($readObject(streamReader), Q$Double);
}

function instantiate_292(streamReader){
  return new MeasurementAggregate_0;
}

function MeasurementData_0(){
  MeasurementData_1.call(this, new MeasurementDataPK_1(fromDouble(currentTimeMillis0())));
}

function MeasurementData_1(pk){
  if (!pk) {
    throw new NullPointerException_1('pk==null');
  }
  this.id = pk;
}

defineSeed(1313, 1, makeCastMap([Q$Serializable, Q$MeasurementData]));
_.equals$ = function equals_93(o){
  var that;
  if (this === o) {
    return true;
  }
  if (o == null || !instanceOf(o, Q$MeasurementData)) {
    return false;
  }
  that = dynamicCast(o, Q$MeasurementData);
  if (!$equals_35(this.id, that.id)) {
    return false;
  }
  if (this.name_0 != null?!$equals_6(this.name_0, that.name_0):that.name_0 != null) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_93(){
  var result;
  result = $hashCode_22(this.id);
  result = 31 * result + (this.name_0 != null?getHashCode_0(this.name_0):0);
  return result;
}
;
_.toString$ = function toString_136(){
  return 'MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']';
}
;
_.id = null;
_.name_0 = null;
_.schedule = null;
function MeasurementDataNumeric_0(){
  MeasurementData_0.call(this);
}

defineSeed(1314, 1313, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric_0);
_.getValue_1 = function getValue_48(){
  return this.value_0;
}
;
_.toString$ = function toString_137(){
  return 'MeasurementDataNumeric[name=' + this.name_0 + ', value=' + this.value_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']';
}
;
_.value_0 = null;
function MeasurementDataNumeric1D_0(){
  MeasurementData_0.call(this);
}

defineSeed(1315, 1313, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric1D_0);
_.getValue_1 = function getValue_49(){
  return this.value_0;
}
;
_.toString$ = function toString_138(){
  return 'MeasurementDataNumeric1D[average=[' + this.value_0 + '], MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']]';
}
;
_.max_0 = null;
_.min_0 = null;
_.value_0 = null;
function deserialize_302(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setMax_0(instance, dynamicCast($readObject(streamReader), Q$Double));
  setMin_0(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValue_14(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_309(streamReader, instance);
}

function instantiate_295(streamReader){
  return new MeasurementDataNumeric1D_0;
}

function setMax_0(instance, value){
  instance.max_0 = value;
}

function setMin_0(instance, value){
  instance.min_0 = value;
}

function setValue_14(instance, value){
  instance.value_0 = value;
}

function MeasurementDataNumeric1H_0(){
  MeasurementData_0.call(this);
}

defineSeed(1317, 1313, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric1H_0);
_.getValue_1 = function getValue_50(){
  return this.value_0;
}
;
_.toString$ = function toString_139(){
  return 'MeasurementDataNumeric1H[average=[' + this.value_0 + '], MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']]';
}
;
_.max_0 = null;
_.min_0 = null;
_.value_0 = null;
function deserialize_303(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setMax_1(instance, dynamicCast($readObject(streamReader), Q$Double));
  setMin_1(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValue_15(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_309(streamReader, instance);
}

function instantiate_296(streamReader){
  return new MeasurementDataNumeric1H_0;
}

function setMax_1(instance, value){
  instance.max_0 = value;
}

function setMin_1(instance, value){
  instance.min_0 = value;
}

function setValue_15(instance, value){
  instance.value_0 = value;
}

function MeasurementDataNumeric6H_0(){
  MeasurementData_0.call(this);
}

defineSeed(1319, 1313, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric6H_0);
_.getValue_1 = function getValue_51(){
  return this.value_0;
}
;
_.toString$ = function toString_140(){
  return 'MeasurementDataNumeric6H[average=[' + this.value_0 + '], MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']]';
}
;
_.max_0 = null;
_.min_0 = null;
_.value_0 = null;
function deserialize_304(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setMax_2(instance, dynamicCast($readObject(streamReader), Q$Double));
  setMin_2(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValue_16(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_309(streamReader, instance);
}

function instantiate_297(streamReader){
  return new MeasurementDataNumeric6H_0;
}

function setMax_2(instance, value){
  instance.max_0 = value;
}

function setMin_2(instance, value){
  instance.min_0 = value;
}

function setValue_16(instance, value){
  instance.value_0 = value;
}

function deserialize_305(streamReader, instance){
  setValue_17(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_309(streamReader, instance);
}

function instantiate_298(streamReader){
  return new MeasurementDataNumeric_0;
}

function setValue_17(instance, value){
  instance.value_0 = value;
}

function $equals_35(this$static, obj_0){
  var other;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null) {
    return false;
  }
  if (!instanceOf(obj_0, Q$MeasurementDataPK)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$MeasurementDataPK);
  if (this$static.scheduleId != other.scheduleId) {
    return false;
  }
  if (neq(this$static.timestamp, other.timestamp)) {
    return false;
  }
  return true;
}

function $hashCode_22(this$static){
  var result;
  result = 31 + this$static.scheduleId;
  result = 31 * result + toInt(xor(this$static.timestamp, shru(this$static.timestamp, 32)));
  return result;
}

function MeasurementDataPK_0(){
}

function MeasurementDataPK_1(timestamp){
  this.timestamp = timestamp;
  this.scheduleId = 0;
}

defineSeed(1322, 1, makeCastMap([Q$Serializable, Q$MeasurementDataPK]), MeasurementDataPK_0, MeasurementDataPK_1);
_.equals$ = function equals_94(obj_0){
  return $equals_35(this, obj_0);
}
;
_.hashCode$ = function hashCode_94(){
  return $hashCode_22(this);
}
;
_.toString$ = function toString_141(){
  return 'MeasurementDataPK: timestamp=[' + (new Date_3(this.timestamp)).toString$() + '], scheduleId=[' + this.scheduleId + ']';
}
;
_.scheduleId = 0;
_.timestamp = P0_longLit;
function deserialize_306(streamReader, instance){
  instance.scheduleId = $readInt(streamReader);
  instance.timestamp = $readLong(streamReader);
}

function instantiate_299(streamReader){
  return new MeasurementDataPK_0;
}

function MeasurementDataTrait_0(){
  MeasurementData_0.call(this);
}

defineSeed(1324, 1313, makeCastMap([Q$Serializable, Q$MeasurementData, Q$MeasurementDataTrait]), MeasurementDataTrait_0);
_.getValue_1 = function getValue_52(){
  return this.value_0;
}
;
_.toString$ = function toString_142(){
  return 'MeasurementDataTrait[name=' + this.name_0 + ', value="' + this.value_0 + '", scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']';
}
;
_.value_0 = null;
function deserialize_307(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_300(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_measurement_MeasurementDataTrait_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$MeasurementDataTrait, size, 0);
}

function deserialize_308(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setValue_18(instance, $getString(streamReader, $readInt(streamReader)));
  deserialize_309(streamReader, instance);
}

function instantiate_301(streamReader){
  return new MeasurementDataTrait_0;
}

function setValue_18(instance, value){
  instance.value_0 = value;
}

function deserialize_309(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  instance.id = dynamicCast($readObject(streamReader), Q$MeasurementDataPK);
  setName_34(instance, $getString(streamReader, $readInt(streamReader)));
  instance.schedule = dynamicCast($readObject(streamReader), Q$MeasurementSchedule);
}

function setName_34(instance, value){
  instance.name_0 = value;
}

function $getFamilyUnits(this$static){
  var returnList, units, units$array, units$index, units$max;
  returnList = new ArrayList_0;
  for (units$array = $VALUES_99 , units$index = 0 , units$max = units$array.length; units$index < units$max; ++units$index) {
    units = units$array[units$index];
    units.family == this$static.family && returnList.add_0(units);
  }
  return returnList;
}

function calculateOffset(first, second){
  $clinit_MeasurementUnits();
  if (first.family != second.family) {
    throw new MeasurementConversionException_0('Can not convert ' + first.name_0 + ' to ' + second.name_0);
  }
  return calculateOffset_0(first.scale_0, second.scale_0);
}

function getUsingDisplayUnits(displayUnits, family){
  $clinit_MeasurementUnits();
  var units, units$array, units$index, units$max;
  for (units$array = $VALUES_99 , units$index = 0 , units$max = units$array.length; units$index < units$max; ++units$index) {
    units = units$array[units$index];
    if (units.family == family && $equalsIgnoreCase(units.displayUnits, displayUnits)) {
      return units;
    }
  }
  return null;
}

function scaleDown(value, units){
  $clinit_MeasurementUnits();
  if (!units || ($clinit_MeasurementUnits$Family() , RELATIVE_0) != units.family) {
    return value;
  }
  return scaleDown_0(value, units.scale_0);
}

function scaleUp(value, units){
  $clinit_MeasurementUnits();
  if (!units || ($clinit_MeasurementUnits$Family() , RELATIVE_0) != units.family) {
    return value;
  }
  return scaleUp_0(value, units.scale_0);
}

function calculateOffset_0(first, second){
  $clinit_MeasurementUnits$Scale();
  var higher, lower, movingScale, results;
  if (first.type_0 != second.type_0) {
    return null;
  }
  if (!first.comparisonScale && !second.comparisonScale) {
    return new Double_0(1);
  }
  if (!first.comparisonScale) {
    higher = second;
    lower = first;
  }
   else if (!second.comparisonScale) {
    higher = first;
    lower = second;
  }
   else {
    if (first.comparisonScale.ordinal > second.comparisonScale.ordinal) {
      higher = first;
      lower = second;
    }
     else if (first.comparisonScale.ordinal < second.comparisonScale.ordinal) {
      higher = second;
      lower = first;
    }
     else {
      return new Double_0(1);
    }
  }
  results = 1;
  movingScale = higher;
  while (movingScale != lower && !!movingScale.comparisonScale) {
    results *= movingScale.offset;
    movingScale = movingScale.comparisonScale;
  }
  if (first == lower) {
    return new Double_0(1 / results);
  }
  return new Double_0(results);
}

function scaleDown_0(value, scale){
  $clinit_MeasurementUnits$Scale();
  if (!scale) {
    return new Double_0(0);
  }
  return new Double_0(value.value_0 / scale.offset);
}

function scaleUp_0(value, scale){
  $clinit_MeasurementUnits$Scale();
  if (!scale) {
    return new Double_0(0);
  }
  return new Double_0(value.value_0 * scale.offset);
}

function CallTimeDataComposite_0(){
}

defineSeed(1347, 1, makeCastMap([Q$Serializable, Q$CallTimeDataComposite]), CallTimeDataComposite_0);
_.toString$ = function toString_147(){
  return $substring(Lorg_rhq_core_domain_measurement_calltime_CallTimeDataComposite_2_classLit.typeName, Lorg_rhq_core_domain_measurement_calltime_CallTimeDataComposite_2_classLit.typeName.lastIndexOf('.') + 1) + '[callDestination=' + this.callDestination + ', minimum=' + this.minimum + ', maximum=' + this.maximum + ', total=' + this.total + ', count=' + toString_8(this.count) + ', average=' + this.average + ']';
}
;
_.average = 0;
_.callDestination = null;
_.count = P0_longLit;
_.maximum = 0;
_.minimum = 0;
_.total = 0;
function deserialize_316(streamReader, instance){
  setAverage(instance, $readDouble(streamReader));
  instance.callDestination = $getString(streamReader, $readInt(streamReader));
  setCount(instance, $readLong(streamReader));
  setMaximum_1(instance, $readDouble(streamReader));
  setMinimum_1(instance, $readDouble(streamReader));
  setTotal(instance, $readDouble(streamReader));
}

function instantiate_308(streamReader){
  return new CallTimeDataComposite_0;
}

function setAverage(instance, value){
  instance.average = value;
}

function setCount(instance, value){
  instance.count = value;
}

function setMaximum_1(instance, value){
  instance.maximum = value;
}

function setMinimum_1(instance, value){
  instance.minimum = value;
}

function setTotal(instance, value){
  instance.total = value;
}

function MeasurementDataNumericHighLowComposite_0(){
}

defineSeed(1349, 1, makeCastMap([Q$Serializable, Q$MeasurementDataNumericHighLowComposite]), MeasurementDataNumericHighLowComposite_0);
_.toString$ = function toString_148(){
  return 'MeasurementDataNumericHighLowComposite[value=' + this.value_0 + ', lowValue=' + this.lowValue + ', highValue=' + this.highValue + ']';
}
;
_.highValue = 0;
_.lowValue = 0;
_.timestamp = P0_longLit;
_.value_0 = 0;
function deserialize_317(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_309(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_measurement_composite_MeasurementDataNumericHighLowComposite_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$MeasurementDataNumericHighLowComposite, size, 0);
}

function deserialize_318(streamReader, instance){
  setHighValue(instance, $readDouble(streamReader));
  setLowValue(instance, $readDouble(streamReader));
  setTimestamp_2(instance, $readLong(streamReader));
  setValue_19(instance, $readDouble(streamReader));
}

function instantiate_310(streamReader){
  return new MeasurementDataNumericHighLowComposite_0;
}

function setHighValue(instance, value){
  instance.highValue = value;
}

function setLowValue(instance, value){
  instance.lowValue = value;
}

function setTimestamp_2(instance, value){
  instance.timestamp = value;
}

function setValue_19(instance, value){
  instance.value_0 = value;
}

function $clinit_MeasurementNumericValueAndUnits(){
  $clinit_MeasurementNumericValueAndUnits = nullMethod;
  new MeasurementNumericValueAndUnits_0(new Double_0(0), ($clinit_MeasurementUnits() , NONE_9));
}

function MeasurementNumericValueAndUnits_0(value, units){
  $clinit_MeasurementNumericValueAndUnits();
  this.value_0 = value;
  this.units = units;
}

defineSeed(1352, 1, {}, MeasurementNumericValueAndUnits_0);
_.toString$ = function toString_149(){
  return this.value_0 + ' ' + this.units;
}
;
_.units = null;
_.value_0 = null;
function $setFormattedOutlier(this$static, formattedOutlier){
  this$static.formattedOutlier = formattedOutlier;
}

function MeasurementOOBComposite_0(){
}

defineSeed(1353, 1, makeCastMap([Q$Serializable, Q$MeasurementOOBComposite]), MeasurementOOBComposite_0);
_.toString$ = function toString_150(){
  var sb;
  sb = new StringBuilder_0;
  sb.impl.string += 'MeasurementOOBComposite';
  $append_8($append_13((sb.impl.string += "{resourceName='" , sb), this.resourceName), 39);
  $append_10((sb.impl.string += ', resourceId=' , sb), this.resourceId);
  $append_8($append_13((sb.impl.string += ", scheduleName='" , sb), this.scheduleName), 39);
  $append_10((sb.impl.string += ', scheduleId=' , sb), this.scheduleId);
  $append_11((sb.impl.string += ', timestamp=' , sb), this.timestamp);
  $append_10((sb.impl.string += ', definitionId=' , sb), this.definitionId);
  $append_10((sb.impl.string += ', factor=' , sb), this.factor);
  $append_9((sb.impl.string += ', blMin=' , sb), this.blMin);
  $append_9((sb.impl.string += ', blMax=' , sb), this.blMax);
  $append_9((sb.impl.string += ', dataMin=' , sb), this.dataMin);
  $append_9((sb.impl.string += ', dataMax=' , sb), this.dataMax);
  $append_9((sb.impl.string += ', outlier=' , sb), this.outlier);
  $append_12((sb.impl.string += ', units=' , sb), this.units);
  $append_8($append_13((sb.impl.string += ", parentName='" , sb), this.parentName), 39);
  $append_12((sb.impl.string += ', parentId=' , sb), this.parentId);
  sb.impl.string += '}';
  return sb.impl.string;
}
;
_.blMax = 0;
_.blMin = 0;
_.dataMax = 0;
_.dataMin = 0;
_.definitionId = 0;
_.factor = 0;
_.formattedBaseband = null;
_.formattedOutlier = null;
_.outlier = 0;
_.parentId = null;
_.parentName = null;
_.resourceAncestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
_.scheduleId = 0;
_.scheduleName = null;
_.timestamp = P0_longLit;
_.units = null;
function deserialize_319(streamReader, instance){
  setBlMax(instance, $readDouble(streamReader));
  setBlMin(instance, $readDouble(streamReader));
  setDataMax(instance, $readDouble(streamReader));
  setDataMin(instance, $readDouble(streamReader));
  setDefinitionId(instance, $readInt(streamReader));
  setFactor(instance, $readInt(streamReader));
  setFormattedBaseband(instance, $getString(streamReader, $readInt(streamReader)));
  setFormattedOutlier(instance, $getString(streamReader, $readInt(streamReader)));
  setOutlier(instance, $readDouble(streamReader));
  setParentId_0(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setParentName(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceAncestry_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_3(instance, $readInt(streamReader));
  setResourceName_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_1(instance, $readInt(streamReader));
  setScheduleId_0(instance, $readInt(streamReader));
  setScheduleName(instance, $getString(streamReader, $readInt(streamReader)));
  setTimestamp_3(instance, $readLong(streamReader));
  setUnits_2(instance, dynamicCast($readObject(streamReader), Q$MeasurementUnits));
}

function instantiate_311(streamReader){
  return new MeasurementOOBComposite_0;
}

function setBlMax(instance, value){
  instance.blMax = value;
}

function setBlMin(instance, value){
  instance.blMin = value;
}

function setDataMax(instance, value){
  instance.dataMax = value;
}

function setDataMin(instance, value){
  instance.dataMin = value;
}

function setDefinitionId(instance, value){
  instance.definitionId = value;
}

function setFactor(instance, value){
  instance.factor = value;
}

function setFormattedBaseband(instance, value){
  instance.formattedBaseband = value;
}

function setFormattedOutlier(instance, value){
  instance.formattedOutlier = value;
}

function setOutlier(instance, value){
  instance.outlier = value;
}

function setParentId_0(instance, value){
  instance.parentId = value;
}

function setParentName(instance, value){
  instance.parentName = value;
}

function setResourceAncestry_0(instance, value){
  instance.resourceAncestry = value;
}

function setResourceId_3(instance, value){
  instance.resourceId = value;
}

function setResourceName_0(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_1(instance, value){
  instance.resourceTypeId = value;
}

function setScheduleId_0(instance, value){
  instance.scheduleId = value;
}

function setScheduleName(instance, value){
  instance.scheduleName = value;
}

function setTimestamp_3(instance, value){
  instance.timestamp = value;
}

function setUnits_2(instance, value){
  instance.units = value;
}

function MeasurementScheduleComposite_0(){
}

defineSeed(1355, 1, makeCastMap([Q$Serializable, Q$MeasurementScheduleComposite]), MeasurementScheduleComposite_0);
_.toString$ = function toString_151(){
  return 'MeasurementScheduleComposite[measurementDefinition=' + this.measurementDefinition + ', collectionEnabled=' + this.collectionEnabled + ', collectionInterval=' + toString_8(this.collectionInterval) + ']';
}
;
_.collectionEnabled = null;
_.collectionInterval = P0_longLit;
_.measurementDefinition = null;
function deserialize_320(streamReader, instance){
  setCollectionEnabled(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setCollectionInterval(instance, $readLong(streamReader));
  setMeasurementDefinition_0(instance, dynamicCast($readObject(streamReader), Q$MeasurementDefinition));
}

function instantiate_312(streamReader){
  return new MeasurementScheduleComposite_0;
}

function setCollectionEnabled(instance, value){
  instance.collectionEnabled = value;
}

function setCollectionInterval(instance, value){
  instance.collectionInterval = value;
}

function setMeasurementDefinition_0(instance, value){
  instance.measurementDefinition = value;
}

defineSeed(1358, 1, makeCastMap([Q$Serializable, Q$MeasurementSummary]));
_.toString$ = function toString_152(){
  var sb;
  sb = new StringBuffer_2(Lorg_rhq_core_domain_measurement_ui_MeasurementSummary_2_classLit.typeName);
  $append_5((sb.impl.string += '(availUp=' , sb), this.availUp);
  $append_5((sb.impl.string += ',availDown=' , sb), this.availDown);
  $append_5((sb.impl.string += ',availUnknown=' , sb), this.availUnknown);
  sb.impl.string += ')';
  return sb.impl.string;
}
;
_.availDown = null;
_.availUnknown = null;
_.availUp = null;
function $clinit_BaseMetricDisplay(){
  $clinit_BaseMetricDisplay = nullMethod;
  new Arrays$ArrayList_0(($clinit_MetricDisplayConstants() , attrKey));
}

function $getAvgMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'average');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: average');
  }
  return mdv;
}

function $getLastMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'last');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: last');
  }
  return mdv;
}

function $getMaxMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'max');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: max');
  }
  return mdv;
}

function $getMetric(this$static, key){
  if (key == null) {
    throw new IllegalArgumentException_1("'null' is not a valid metric key");
  }
  return dynamicCast(this$static.metrics.get_2(key), Q$MetricDisplayValue);
}

function $getMetricKeys(this$static){
  var ent, ent$iterator, i, key, key$iterator, keys, rv;
  keys = new ArrayList_0;
  for (ent$iterator = this$static.metrics.entrySet().iterator(); ent$iterator.hasNext();) {
    ent = dynamicCast(ent$iterator.next_0(), Q$Map$Entry);
    ent.getKey_0() != null && ent.getValue_1() != null && keys.add_0(dynamicCast(ent.getKey_0(), Q$String));
  }
  i = 0;
  rv = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, keys.size_0, 0);
  for (key$iterator = new AbstractList$IteratorImpl_0(keys); key$iterator.i < key$iterator.this$0_0.size_1();) {
    key = dynamicCast($next_0(key$iterator), Q$String);
    rv[i] = key;
    ++i;
  }
  return rv;
}

function $getMetricValueDoubles(this$static){
  var ent, ent$iterator, i, rv, v, v$iterator, values;
  values = new ArrayList_0;
  for (ent$iterator = this$static.metrics.entrySet().iterator(); ent$iterator.hasNext();) {
    ent = dynamicCast(ent$iterator.next_0(), Q$Map$Entry);
    ent.getKey_0() != null && ent.getValue_1() != null && values.add_0(dynamicCast(ent.getValue_1(), Q$MetricDisplayValue).value_0);
  }
  i = 0;
  rv = initDim(_3D_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, values.size_0, 1);
  for (v$iterator = new AbstractList$IteratorImpl_0(values); v$iterator.i < v$iterator.this$0_0.size_1();) {
    v = dynamicCast($next_0(v$iterator), Q$Double);
    rv[i] = v.value_0;
    ++i;
  }
  return rv;
}

function $getMinMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'min');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: min');
  }
  return mdv;
}

function $setUnits(this$static, units){
  this$static.units = units;
}

function $toString_13(this$static){
  var anAttrKey, anAttrKey$array, anAttrKey$index, anAttrKey$max, sb;
  sb = new StringBuffer_2(Lorg_rhq_core_domain_measurement_ui_BaseMetricDisplay_2_classLit.typeName);
  $append_6((sb.impl.string += '(label=' , sb), this$static.label);
  $append_5((sb.impl.string += ',beginTimeFrame=' , sb), this$static.beginTimeFrame);
  $append_5((sb.impl.string += ',endTimeFrame=' , sb), this$static.endTimeFrame);
  $append_6((sb.impl.string += ',units=' , sb), this$static.units);
  $append_5((sb.impl.string += ',collectionType=' , sb), this$static.collectionType);
  $append_6((sb.impl.string += ',metricSource=' , sb), this$static.metricSource);
  $append_5((sb.impl.string += ',scheduleId=' , sb), this$static.scheduleId);
  $append_5((sb.impl.string += ',showNumberCollecting=' , sb), this$static.showNumberCollecting);
  sb.impl.string += 'metrics[';
  for (anAttrKey$array = ($clinit_MetricDisplayConstants() , attrKey) , anAttrKey$index = 0 , anAttrKey$max = anAttrKey$array.length; anAttrKey$index < anAttrKey$max; ++anAttrKey$index) {
    anAttrKey = anAttrKey$array[anAttrKey$index];
    $append_5($append_6($append_6((sb.impl.string += '\n' , sb), anAttrKey), '='), this$static.metrics.get_2(anAttrKey));
  }
  sb.impl.string += ']\n)';
  return sb.impl.string;
}

defineSeed(1357, 1358, makeCastMap([Q$Serializable, Q$Comparable, Q$BaseMetricDisplay, Q$MeasurementSummary]));
_.compareTo$ = function compareTo_14(arg0){
  var to;
  if (instanceOf(arg0, Q$BaseMetricDisplay)) {
    to = dynamicCast(arg0, Q$BaseMetricDisplay);
    return compareTo_11(this.label, to.label);
  }
  throw new IllegalArgumentException_1('Cannot compare to non-BaseMetricDisplay object: ' + arg0);
}
;
_.toString$ = function toString_153(){
  return $toString_13(this);
}
;
_.beginTimeFrame = null;
_.collectionType = null;
_.definitionId = null;
_.description = null;
_.endTimeFrame = null;
_.label = null;
_.metricName = null;
_.metricSource = null;
_.metricSourceId = 0;
_.metrics = null;
_.numberCollecting = -1;
_.scheduleId = null;
_.showNumberCollecting = null;
_.units = null;
function setBeginTimeFrame(instance, value){
  instance.beginTimeFrame = value;
}

function setCollectionType(instance, value){
  instance.collectionType = value;
}

function setDefinitionId_0(instance, value){
  instance.definitionId = value;
}

function setDescription_25(instance, value){
  instance.description = value;
}

function setEndTimeFrame(instance, value){
  instance.endTimeFrame = value;
}

function setLabel_0(instance, value){
  instance.label = value;
}

function setMetricName(instance, value){
  instance.metricName = value;
}

function setMetricSource(instance, value){
  instance.metricSource = value;
}

function setMetricSourceId(instance, value){
  instance.metricSourceId = value;
}

function setMetrics(instance, value){
  instance.metrics = value;
}

function setNumberCollecting(instance, value){
  instance.numberCollecting = value;
}

function setScheduleId_1(instance, value){
  instance.scheduleId = value;
}

function setShowNumberCollecting(instance, value){
  instance.showNumberCollecting = value;
}

function setUnits_3(instance, value){
  instance.units = value;
}

function setAvailDown(instance, value){
  instance.availDown = value;
}

function setAvailUnknown(instance, value){
  instance.availUnknown = value;
}

function setAvailUp(instance, value){
  instance.availUp = value;
}

function $clinit_MetricDisplayConstants(){
  $clinit_MetricDisplayConstants = nullMethod;
  attrKey = initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, ['max', 'min', 'average', 'last', 'baseline', 'high', 'low', 'summary']);
}

var attrKey;
function MetricDisplaySummary_0(){
  $clinit_BaseMetricDisplay();
  this.metrics = new HashMap_0;
}

defineSeed(1362, 1357, makeCastMap([Q$Serializable, Q$Comparable, Q$BaseMetricDisplay, Q$MeasurementSummary, Q$MetricDisplaySummary]), MetricDisplaySummary_0);
_.toString$ = function toString_154(){
  return 'token=' + this.metricToken + ',' + Lorg_rhq_core_domain_measurement_ui_MetricDisplaySummary_2_classLit.typeName + ',group=' + this.groupId + ',super(' + $toString_13(this) + ')';
}
;
_.alertCount = 0;
_.childTypeId = -1;
_.groupId = -1;
_.isTrait = false;
_.metricToken = null;
_.parent_0 = null;
_.parentId = -1;
_.resource = null;
_.resourceId = 0;
_.timestamp = P0_longLit;
_.value_0 = null;
_.valuesPresent = true;
function deserialize_321(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_313(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_measurement_ui_MetricDisplaySummary_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$MetricDisplaySummary, size, 0);
}

function deserialize_322(streamReader, instance){
  setAlertCount(instance, $readInt(streamReader));
  setChildTypeId(instance, $readInt(streamReader));
  setGroupId(instance, $readInt(streamReader));
  setIsTrait(instance, $readBoolean(streamReader));
  setMetricToken(instance, $getString(streamReader, $readInt(streamReader)));
  setParent(instance, dynamicCast($readObject(streamReader), Q$Resource));
  setParentId_1(instance, $readInt(streamReader));
  setResource_16(instance, dynamicCast($readObject(streamReader), Q$Resource));
  instance.resourceId = $readInt(streamReader);
  setTimestamp_4(instance, $readLong(streamReader));
  setValue_20(instance, $getString(streamReader, $readInt(streamReader)));
  setValuesPresent(instance, $readBoolean(streamReader));
  setBeginTimeFrame(instance, dynamicCast($readObject(streamReader), Q$Long));
  setCollectionType(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setDefinitionId_0(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setDescription_25(instance, $getString(streamReader, $readInt(streamReader)));
  setEndTimeFrame(instance, dynamicCast($readObject(streamReader), Q$Long));
  setLabel_0(instance, $getString(streamReader, $readInt(streamReader)));
  setMetricName(instance, $getString(streamReader, $readInt(streamReader)));
  setMetricSource(instance, $getString(streamReader, $readInt(streamReader)));
  setMetricSourceId(instance, $readInt(streamReader));
  setMetrics(instance, dynamicCast($readObject(streamReader), Q$Map));
  setNumberCollecting(instance, $readInt(streamReader));
  setScheduleId_1(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setShowNumberCollecting(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setUnits_3(instance, $getString(streamReader, $readInt(streamReader)));
  setAvailDown(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setAvailUnknown(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setAvailUp(instance, dynamicCast($readObject(streamReader), Q$Integer));
}

function instantiate_314(streamReader){
  return new MetricDisplaySummary_0;
}

function setAlertCount(instance, value){
  instance.alertCount = value;
}

function setChildTypeId(instance, value){
  instance.childTypeId = value;
}

function setGroupId(instance, value){
  instance.groupId = value;
}

function setIsTrait(instance, value){
  instance.isTrait = value;
}

function setMetricToken(instance, value){
  instance.metricToken = value;
}

function setParent(instance, value){
  instance.parent_0 = value;
}

function setParentId_1(instance, value){
  instance.parentId = value;
}

function setResource_16(instance, value){
  instance.resource = value;
}

function setTimestamp_4(instance, value){
  instance.timestamp = value;
}

function setValue_20(instance, value){
  instance.value_0 = value;
}

function setValuesPresent(instance, value){
  instance.valuesPresent = value;
}

function $setValueFmt(this$static, aValueFmt){
  this$static.valueFmt = aValueFmt;
}

function $toString_14(this$static){
  if (this$static.valueFmt != null) {
    return this$static.valueFmt;
  }
  return '' + this$static.value_0.value_0;
}

function MetricDisplayValue_0(){
}

defineSeed(1365, 1, makeCastMap([Q$Serializable, Q$MetricDisplayValue]), MetricDisplayValue_0);
_.toString$ = function toString_155(){
  return $toString_14(this);
}
;
_.highlighted = null;
_.value_0 = null;
_.valueFmt = null;
function deserialize_323(streamReader, instance){
  setHighlighted(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setValue_21(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValueFmt(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_315(streamReader){
  return new MetricDisplayValue_0;
}

function setHighlighted(instance, value){
  instance.highlighted = value;
}

function setValue_21(instance, value){
  instance.value_0 = value;
}

function setValueFmt(instance, value){
  instance.valueFmt = value;
}

function MeasurementConversionException_0(message){
  RuntimeException_1.call(this, message);
}

defineSeed(1367, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable]), MeasurementConversionException_0);
function $setId_4(this$static, id){
  this$static.id = id;
}

function $setStartedTime(this$static){
  if (neq(this$static.startedTime, P0_longLit)) {
    throw new IllegalArgumentException_1('Can only start an operation once');
  }
  this$static.startedTime = fromDouble(currentTimeMillis0());
}

function OperationHistory_0(subjectName, operationDefinition, parameters){
  $$init_13(this);
  this.jobName = null;
  this.jobGroup = null;
  this.subjectName = subjectName;
  this.operationDefinition = operationDefinition;
  this.parameters = parameters;
  this.status_0 = ($clinit_OperationRequestStatus() , INPROGRESS_1);
}

function GroupOperationHistory_1(){
  OperationHistory_0.call(this, null, null, null);
  $$init_14(this);
  this.group = null;
  $setStartedTime(this);
}

defineSeed(1368, 1369, makeCastMap([Q$Serializable, Q$GroupOperationHistory, Q$OperationHistory]), GroupOperationHistory_1);
function JobId_0(){
}

defineSeed(1373, 1, makeCastMap([Q$Serializable, Q$JobId]), JobId_0);
function deserialize_326(streamReader, instance){
  setJobGroup(instance, $getString(streamReader, $readInt(streamReader)));
  setJobName(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_318(streamReader){
  return new JobId_0;
}

function setJobGroup(instance, value){
  instance.jobGroup = value;
}

function setJobName(instance, value){
  instance.jobName = value;
}

function serialize_290(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function ResourceOperationHistory_1(subjectName, operationDefinition, parameters, resource){
  OperationHistory_0.call(this, subjectName, operationDefinition, parameters);
  this.resource = resource;
  this.groupOperationHistory = null;
  !!this.groupOperationHistory && null.resourceOperationHistories.add_0(this);
}

defineSeed(1382, 1369, makeCastMap([Q$Serializable, Q$OperationHistory, Q$ResourceOperationHistory]), ResourceOperationHistory_1);
function ScheduleJobId_0(){
  JobId_1.call(this, '', '');
}

defineSeed(1385, 1373, makeCastMap([Q$Serializable, Q$JobId]), ScheduleJobId_0);
function deserialize_332(streamReader, instance){
  setJobGroup(instance, $getString(streamReader, $readInt(streamReader)));
  setJobName(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_323(streamReader){
  return new ScheduleJobId_0;
}

function $getOperationDisplayName(this$static){
  if (this$static.operationDisplayName == null || $equals_6(this$static.operationDisplayName, '')) {
    return this$static.operationName;
  }
  return this$static.operationDisplayName;
}

function $setDescription_3(this$static, description){
  this$static.description = description;
}

function $setId_5(this$static, id){
  this$static.id = id;
}

function $setJobGroup(this$static, jobGroup){
  this$static.jobGroup = jobGroup;
}

function $setJobName(this$static, jobName){
  this$static.jobName = jobName;
}

function $setJobTrigger(this$static, jobTrigger){
  this$static.jobTrigger = jobTrigger;
}

function $setNextFireTime(this$static, nextFireTime){
  this$static.nextFireTime = nextFireTime;
}

function $setOperationDisplayName(this$static, operationDisplayName){
  this$static.operationDisplayName = operationDisplayName;
}

function $setOperationName(this$static, operationName){
  this$static.operationName = operationName;
}

function $setSubject(this$static, subject){
  if (!subject) {
    throw new NullPointerException_1('Cannot schedule an operation without a user associated with it');
  }
  this$static.subject = subject;
}

function $toString_17(this$static){
  var str;
  str = new StringBuilder_0;
  $append_13(str, 'job-name=[' + this$static.jobName);
  $append_13(str, '], job-group=[' + this$static.jobGroup);
  $append_13(str, '], operation-name=[' + this$static.operationName);
  $append_13(str, '], subject=[' + this$static.subject);
  $append_13(str, '], description=[' + this$static.description);
  str.impl.string += ']';
  return str.impl.string;
}

defineSeed(1388, 1, makeCastMap([Q$Serializable, Q$OperationSchedule]));
_.toString$ = function toString_163(){
  return $toString_17(this);
}
;
_.description = null;
_.id = 0;
_.jobGroup = null;
_.jobName = null;
_.jobTrigger = null;
_.nextFireTime = null;
_.operationDisplayName = null;
_.operationName = null;
_.parameters = null;
_.subject = null;
function $setGroup_0(this$static, group){
  this$static.group = group;
}

function $setHaltOnFailure(this$static, haltOnFailure){
  this$static.haltOnFailure = haltOnFailure;
}

function GroupOperationSchedule_0(){
}

defineSeed(1387, 1388, makeCastMap([Q$Serializable, Q$GroupOperationSchedule, Q$OperationSchedule]), GroupOperationSchedule_0);
_.toString$ = function toString_164(){
  var str;
  str = new StringBuilder_1('GroupOperationSchedule: ');
  $append_13(str, 'group=[' + this.group);
  $append_13(str, '], execution-order=[' + this.executionOrder);
  $append_13(str, '], halt-on-failure=[' + this.haltOnFailure);
  str.impl.string += '],';
  $append_13(str, $toString_17(this));
  return str.impl.string;
}
;
_.executionOrder = null;
_.group = null;
_.haltOnFailure = false;
function deserialize_333(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_324(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_operation_bean_GroupOperationSchedule_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$GroupOperationSchedule, size, 0);
}

function deserialize_334(streamReader, instance){
  setExecutionOrder(instance, dynamicCast($readObject(streamReader), Q$List));
  setGroup_4(instance, dynamicCast($readObject(streamReader), Q$ResourceGroup));
  setHaltOnFailure(instance, $readBoolean(streamReader));
  deserialize_335(streamReader, instance);
}

function instantiate_325(streamReader){
  return new GroupOperationSchedule_0;
}

function serialize_294(streamWriter, instance){
  $writeObject(streamWriter, instance.executionOrder);
  $writeObject(streamWriter, instance.group);
  $writeBoolean(streamWriter, instance.haltOnFailure);
  serialize_295(streamWriter, instance);
}

function setExecutionOrder(instance, value){
  instance.executionOrder = value;
}

function setGroup_4(instance, value){
  instance.group = value;
}

function setHaltOnFailure(instance, value){
  instance.haltOnFailure = value;
}

function deserialize_335(streamReader, instance){
  setDescription_27(instance, $getString(streamReader, $readInt(streamReader)));
  setId_79(instance, $readInt(streamReader));
  setJobGroup_1(instance, $getString(streamReader, $readInt(streamReader)));
  setJobName_1(instance, $getString(streamReader, $readInt(streamReader)));
  setJobTrigger(instance, dynamicCast($readObject(streamReader), Q$JobTrigger));
  setNextFireTime(instance, dynamicCast($readObject(streamReader), Q$Date));
  setOperationDisplayName(instance, $getString(streamReader, $readInt(streamReader)));
  setOperationName(instance, $getString(streamReader, $readInt(streamReader)));
  setParameters_0(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setSubject_0(instance, dynamicCast($readObject(streamReader), Q$Subject));
}

function serialize_295(streamWriter, instance){
  $writeString(streamWriter, instance.description);
  $writeInt(streamWriter, instance.id);
  $writeString(streamWriter, instance.jobGroup);
  $writeString(streamWriter, instance.jobName);
  $writeObject(streamWriter, instance.jobTrigger);
  $writeObject(streamWriter, instance.nextFireTime);
  $writeString(streamWriter, instance.operationDisplayName);
  $writeString(streamWriter, instance.operationName);
  $writeObject(streamWriter, instance.parameters);
  $writeObject(streamWriter, instance.subject);
}

function setDescription_27(instance, value){
  instance.description = value;
}

function setId_79(instance, value){
  instance.id = value;
}

function setJobGroup_1(instance, value){
  instance.jobGroup = value;
}

function setJobName_1(instance, value){
  instance.jobName = value;
}

function setJobTrigger(instance, value){
  instance.jobTrigger = value;
}

function setNextFireTime(instance, value){
  instance.nextFireTime = value;
}

function setOperationDisplayName(instance, value){
  instance.operationDisplayName = value;
}

function setOperationName(instance, value){
  instance.operationName = value;
}

function setParameters_0(instance, value){
  instance.parameters = value;
}

function setSubject_0(instance, value){
  instance.subject = value;
}

function $setResource_0(this$static, resource){
  this$static.resource = resource;
}

function ResourceOperationSchedule_0(){
}

defineSeed(1392, 1388, makeCastMap([Q$Serializable, Q$OperationSchedule, Q$ResourceOperationSchedule]), ResourceOperationSchedule_0);
_.toString$ = function toString_165(){
  var str;
  str = new StringBuilder_1('ResourceOperationSchedule: ');
  $append_13(str, 'resource=[' + this.resource);
  str.impl.string += '],';
  $append_13(str, $toString_17(this));
  return str.impl.string;
}
;
_.resource = null;
function deserialize_336(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_326(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_operation_bean_ResourceOperationSchedule_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ResourceOperationSchedule, size, 0);
}

function deserialize_337(streamReader, instance){
  setResource_18(instance, dynamicCast($readObject(streamReader), Q$Resource));
  deserialize_335(streamReader, instance);
}

function instantiate_327(streamReader){
  return new ResourceOperationSchedule_0;
}

function serialize_296(streamWriter, instance){
  $writeObject(streamWriter, instance.resource);
  serialize_295(streamWriter, instance);
}

function setResource_18(instance, value){
  instance.resource = value;
}

function $toString_18(this$static){
  var str;
  str = new StringBuilder_0;
  $append_13(str, 'operation-job-id=[' + this$static.id);
  $append_13(str, '], operation-name=[' + this$static.operationName);
  $append_13(str, '], operation-next-fire-time=[' + new Date_3(this$static.operationNextFireTime));
  str.impl.string += ']';
  return str.impl.string;
}

function OperationScheduleComposite_0(){
  this.operationNextFireTime = N1_longLit;
  this.id = 0;
  this.operationName = '(uninitialized)';
}

defineSeed(1396, 1, makeCastMap([Q$Serializable, Q$OperationScheduleComposite]));
_.toString$ = function toString_166(){
  return $toString_18(this);
}
;
_.id = 0;
_.jobId = null;
_.operationName = null;
_.operationNextFireTime = P0_longLit;
function GroupOperationScheduleComposite_0(){
  OperationScheduleComposite_0.call(this);
}

defineSeed(1395, 1396, makeCastMap([Q$Serializable, Q$GroupOperationScheduleComposite, Q$OperationScheduleComposite]), GroupOperationScheduleComposite_0);
_.toString$ = function toString_167(){
  var str;
  str = new StringBuilder_1('GroupOperationScheduleComposite: ' + $toString_18(this));
  $append_13(str, ', group-id=[' + this.groupId);
  $append_13(str, '], group-name=[' + this.groupName);
  $append_13(str, '], group-resource-type-name=[' + this.groupResourceTypeName);
  str.impl.string += ']';
  return str.impl.string;
}
;
_.groupId = 0;
_.groupName = null;
_.groupResourceTypeName = null;
function deserialize_338(streamReader, instance){
  setGroupId_0(instance, $readInt(streamReader));
  setGroupName(instance, $getString(streamReader, $readInt(streamReader)));
  setGroupResourceTypeName(instance, $getString(streamReader, $readInt(streamReader)));
  deserialize_339(streamReader, instance);
}

function instantiate_328(streamReader){
  return new GroupOperationScheduleComposite_0;
}

function setGroupId_0(instance, value){
  instance.groupId = value;
}

function setGroupName(instance, value){
  instance.groupName = value;
}

function setGroupResourceTypeName(instance, value){
  instance.groupResourceTypeName = value;
}

defineSeed(1398, 1, makeCastMap([Q$Serializable]));
_.operationHistoryId = 0;
_.operationName = null;
_.operationStartTime = P0_longLit;
_.operationStatus = null;
function setOperationHistoryId(instance, value){
  instance.operationHistoryId = value;
}

function setOperationName_0(instance, value){
  instance.operationName = value;
}

function setOperationStartTime(instance, value){
  instance.operationStartTime = value;
}

function setOperationStatus(instance, value){
  instance.operationStatus = value;
}

function deserialize_339(streamReader, instance){
  setId_80(instance, $readInt(streamReader));
  setJobId(instance, dynamicCast($readObject(streamReader), Q$JobId));
  setOperationName_1(instance, $getString(streamReader, $readInt(streamReader)));
  setOperationNextFireTime(instance, $readLong(streamReader));
}

function setId_80(instance, value){
  instance.id = value;
}

function setJobId(instance, value){
  instance.jobId = value;
}

function setOperationName_1(instance, value){
  instance.operationName = value;
}

function setOperationNextFireTime(instance, value){
  instance.operationNextFireTime = value;
}

function ResourceOperationLastCompletedComposite_0(){
  this.operationHistoryId = 0;
  this.operationName = '(uninitialized)';
  this.operationStartTime = N1_longLit;
  this.operationStatus = ($clinit_OperationRequestStatus() , FAILURE_6);
  this.resourceId = 0;
  this.resourceTypeId = 0;
  this.resourceName = '(uninitialized)';
  this.ancestry = '(uninitialized)';
}

defineSeed(1401, 1398, makeCastMap([Q$Serializable]), ResourceOperationLastCompletedComposite_0);
_.ancestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
function deserialize_340(streamReader, instance){
  setAncestry(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_4(instance, $readInt(streamReader));
  setResourceName_1(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_2(instance, $readInt(streamReader));
  setOperationHistoryId(instance, $readInt(streamReader));
  setOperationName_0(instance, $getString(streamReader, $readInt(streamReader)));
  setOperationStartTime(instance, $readLong(streamReader));
  setOperationStatus(instance, dynamicCast($readObject(streamReader), Q$OperationRequestStatus));
}

function instantiate_329(streamReader){
  return new ResourceOperationLastCompletedComposite_0;
}

function setAncestry(instance, value){
  instance.ancestry = value;
}

function setResourceId_4(instance, value){
  instance.resourceId = value;
}

function setResourceName_1(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_2(instance, value){
  instance.resourceTypeId = value;
}

function ResourceOperationScheduleComposite_0(){
  OperationScheduleComposite_0.call(this);
  this.resourceId = 0;
  this.resourceTypeId = 0;
  this.resourceName = '(uninitialized)';
  this.ancestry = '(uninitialized)';
}

defineSeed(1403, 1396, makeCastMap([Q$Serializable, Q$OperationScheduleComposite, Q$ResourceOperationScheduleComposite]), ResourceOperationScheduleComposite_0);
_.toString$ = function toString_168(){
  var str;
  str = new StringBuilder_1('ResourceOperationScheduleComposite: ' + $toString_18(this));
  $append_13(str, ', resource-id=[' + this.resourceId);
  $append_13(str, '], resource-name=[' + this.resourceName);
  $append_13(str, '], resource-type-id=[' + this.resourceTypeId);
  str.impl.string += ']';
  return str.impl.string;
}
;
_.ancestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
function deserialize_341(streamReader, instance){
  setAncestry_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_5(instance, $readInt(streamReader));
  setResourceName_2(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_3(instance, $readInt(streamReader));
  deserialize_339(streamReader, instance);
}

function instantiate_330(streamReader){
  return new ResourceOperationScheduleComposite_0;
}

function setAncestry_0(instance, value){
  instance.ancestry = value;
}

function setResourceId_5(instance, value){
  instance.resourceId = value;
}

function setResourceName_2(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_3(instance, value){
  instance.resourceTypeId = value;
}

function $equals_38(this$static, obj_0){
  var that;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$AbstractPlugin)) {
    return false;
  }
  that = dynamicCast(obj_0, Q$AbstractPlugin);
  return $equals_6(this$static.name_0, that.name_0);
}

function AbstractPlugin_0(){
  this.status_0 = ($clinit_PluginStatusType() , INSTALLED_3);
}

defineSeed(1405, 1, makeCastMap([Q$Serializable, Q$AbstractPlugin]));
_.equals$ = function equals_101(obj_0){
  return $equals_38(this, obj_0);
}
;
_.hashCode$ = function hashCode_101(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_169(){
  return '[id=' + this.id + ', name=' + this.name_0 + ', md5=' + this.md5 + ']';
}
;
_.ampsVersion = null;
_.content_0 = null;
_.ctime = P0_longLit;
_.deployment = null;
_.description = null;
_.displayName = null;
_.enabled = true;
_.help = null;
_.helpContentType = null;
_.id = 0;
_.md5 = null;
_.mtime = P0_longLit;
_.name_0 = null;
_.path = null;
_.version_0 = null;
function deserialize_342(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setAmpsVersion(instance, $getString(streamReader, $readInt(streamReader)));
  setContent(instance, dynamicCast($readObject(streamReader), Q$byte_$1));
  setCtime_21(instance, $readLong(streamReader));
  setDeployment(instance, dynamicCast($readObject(streamReader), Q$PluginDeploymentType));
  setDescription_28(instance, $getString(streamReader, $readInt(streamReader)));
  setDisplayName_7(instance, $getString(streamReader, $readInt(streamReader)));
  setEnabled_4(instance, $readBoolean(streamReader));
  setHelp(instance, $getString(streamReader, $readInt(streamReader)));
  setHelpContentType(instance, $getString(streamReader, $readInt(streamReader)));
  setId_81(instance, $readInt(streamReader));
  setMd5_0(instance, $getString(streamReader, $readInt(streamReader)));
  setMtime_9(instance, $readLong(streamReader));
  setName_37(instance, $getString(streamReader, $readInt(streamReader)));
  setPath_3(instance, $getString(streamReader, $readInt(streamReader)));
  setStatus_7(instance, dynamicCast($readObject(streamReader), Q$PluginStatusType));
  setVersion_10(instance, $getString(streamReader, $readInt(streamReader)));
}

function setAmpsVersion(instance, value){
  instance.ampsVersion = value;
}

function setContent(instance, value){
  instance.content_0 = value;
}

function setCtime_21(instance, value){
  instance.ctime = value;
}

function setDeployment(instance, value){
  instance.deployment = value;
}

function setDescription_28(instance, value){
  instance.description = value;
}

function setDisplayName_7(instance, value){
  instance.displayName = value;
}

function setEnabled_4(instance, value){
  instance.enabled = value;
}

function setHelp(instance, value){
  instance.help = value;
}

function setHelpContentType(instance, value){
  instance.helpContentType = value;
}

function setId_81(instance, value){
  instance.id = value;
}

function setMd5_0(instance, value){
  instance.md5 = value;
}

function setMtime_9(instance, value){
  instance.mtime = value;
}

function setName_37(instance, value){
  instance.name_0 = value;
}

function setPath_3(instance, value){
  instance.path = value;
}

function setStatus_7(instance, value){
  instance.status_0 = value;
}

function setVersion_10(instance, value){
  instance.version_0 = value;
}

function $setDeployment(this$static, deployment){
  if (deployment != ($clinit_PluginDeploymentType() , AGENT)) {
    throw new IllegalArgumentException_1('Plugin can only ever have deployment type of AGENT: ' + deployment);
  }
  this$static.deployment = deployment;
}

function Plugin_1(){
  AbstractPlugin_0.call(this);
  $setDeployment(this, ($clinit_PluginDeploymentType() , AGENT));
}

defineSeed(1407, 1405, makeCastMap([Q$Serializable, Q$AbstractPlugin, Q$Plugin]), Plugin_1);
_.equals$ = function equals_102(obj_0){
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$Plugin)) {
    return false;
  }
  return $equals_38(this, obj_0);
}
;
_.hashCode$ = function hashCode_102(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_170(){
  return 'AgentPlugin [id=' + this.id + ', name=' + this.name_0 + ', md5=' + this.md5 + ']';
}
;
function $clinit_PluginDeploymentType(){
  $clinit_PluginDeploymentType = nullMethod;
  AGENT = new PluginDeploymentType_0('AGENT', 0);
  SERVER = new PluginDeploymentType_0('SERVER', 1);
  $VALUES_105 = initValues(_3Lorg_rhq_core_domain_plugin_PluginDeploymentType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PluginDeploymentType, [AGENT, SERVER]);
}

function PluginDeploymentType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_114(name_0){
  $clinit_PluginDeploymentType();
  return valueOf(($clinit_PluginDeploymentType$Map() , $MAP_105), name_0);
}

function values_108(){
  $clinit_PluginDeploymentType();
  return $VALUES_105;
}

defineSeed(1408, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PluginDeploymentType]), PluginDeploymentType_0);
var $VALUES_105, AGENT, SERVER;
function $clinit_PluginDeploymentType$Map(){
  $clinit_PluginDeploymentType$Map = nullMethod;
  $MAP_105 = createValueOfMap(($clinit_PluginDeploymentType() , $VALUES_105));
}

var $MAP_105;
function deserialize_343(streamReader, instance){
}

function instantiate_331(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PluginDeploymentType() , $clinit_PluginDeploymentType() , $VALUES_105);
  return values[ordinal];
}

function serialize_297(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function PluginKey_0(deployment, pluginType, pluginName){
  if (!deployment) {
    throw new IllegalArgumentException_1('deployment==null');
  }
  if (pluginType == null && deployment != ($clinit_PluginDeploymentType() , AGENT)) {
    throw new IllegalArgumentException_1('only agent plugins can have null type');
  }
  if (pluginType != null && deployment == ($clinit_PluginDeploymentType() , AGENT)) {
    throw new IllegalArgumentException_1('agent plugins must have null type');
  }
  if (pluginName == null || pluginName.length == 0) {
    throw new IllegalArgumentException_1('invalid pluginName: ' + pluginName);
  }
  this.deployment = deployment;
  this.pluginType = pluginType;
  this.pluginName = pluginName;
}

function createServerPluginKey(pluginType, pluginName){
  if (pluginType == null || pluginType.length == 0) {
    throw new IllegalArgumentException_1('invalid pluginType: ' + pluginType);
  }
  return new PluginKey_0(($clinit_PluginDeploymentType() , SERVER), pluginType, pluginName);
}

defineSeed(1411, 1, makeCastMap([Q$Serializable, Q$PluginKey]), PluginKey_0);
_.equals$ = function equals_103(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$PluginKey)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$PluginKey);
  if (!$equals_6(this.pluginName, other.pluginName)) {
    return false;
  }
  if (this.pluginType == null) {
    if (other.pluginType != null) {
      return false;
    }
  }
   else if (!$equals_6(this.pluginType, other.pluginType)) {
    return false;
  }
  if (this.deployment != other.deployment) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_103(){
  var result;
  result = 31 + getHashCode(this.deployment);
  result = 31 * result + (this.pluginType == null?0:getHashCode_0(this.pluginType));
  result = 31 * result + getHashCode_0(this.pluginName);
  return result;
}
;
_.toString$ = function toString_171(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_13($append_13($append_13($append_13($append_12((builder.impl.string += 'PluginKey [deployment=' , builder), this.deployment), ', pluginType='), this.pluginType), ', pluginName='), this.pluginName), ']');
  return builder.impl.string;
}
;
_.deployment = null;
_.pluginName = null;
_.pluginType = null;
function serialize_298(streamWriter, instance){
  $writeObject(streamWriter, instance.deployment);
  $writeString(streamWriter, instance.pluginName);
  $writeString(streamWriter, instance.pluginType);
}

function $clinit_PluginStatusType(){
  $clinit_PluginStatusType = nullMethod;
  INSTALLED_3 = new PluginStatusType_0('INSTALLED', 0);
  DELETED_0 = new PluginStatusType_0('DELETED', 1);
  $VALUES_106 = initValues(_3Lorg_rhq_core_domain_plugin_PluginStatusType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PluginStatusType, [INSTALLED_3, DELETED_0]);
}

function PluginStatusType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_115(name_0){
  $clinit_PluginStatusType();
  return valueOf(($clinit_PluginStatusType$Map() , $MAP_106), name_0);
}

function values_109(){
  $clinit_PluginStatusType();
  return $VALUES_106;
}

defineSeed(1413, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PluginStatusType]), PluginStatusType_0);
var $VALUES_106, DELETED_0, INSTALLED_3;
function $clinit_PluginStatusType$Map(){
  $clinit_PluginStatusType$Map = nullMethod;
  $MAP_106 = createValueOfMap(($clinit_PluginStatusType() , $VALUES_106));
}

var $MAP_106;
function deserialize_344(streamReader, instance){
}

function instantiate_332(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PluginStatusType() , $clinit_PluginStatusType() , $VALUES_106);
  return values[ordinal];
}

function deserialize_345(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  deserialize_342(streamReader, instance);
}

function instantiate_333(streamReader){
  return new Plugin_1;
}

function $setDeployment_0(this$static, deployment){
  if (deployment != ($clinit_PluginDeploymentType() , SERVER)) {
    throw new IllegalArgumentException_1('ServerPlugin can only ever have deployment type of SERVER: ' + deployment);
  }
  this$static.deployment = deployment;
}

function ServerPlugin_0(){
  AbstractPlugin_0.call(this);
  $setDeployment_0(this, ($clinit_PluginDeploymentType() , SERVER));
}

defineSeed(1417, 1405, makeCastMap([Q$Serializable, Q$AbstractPlugin, Q$ServerPlugin]), ServerPlugin_0);
_.equals$ = function equals_104(obj_0){
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$ServerPlugin)) {
    return false;
  }
  return $equals_38(this, obj_0);
}
;
_.hashCode$ = function hashCode_104(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_172(){
  return 'ServerPlugin [id=' + this.id + ', name=' + this.name_0 + ', md5=' + this.md5 + ']';
}
;
_.pluginConfiguration = null;
_.scheduledJobsConfiguration = null;
_.type_0 = null;
function ServerPluginControlDefinition_0(){
}

defineSeed(1418, 1, makeCastMap([Q$Serializable, Q$ServerPluginControlDefinition]), ServerPluginControlDefinition_0);
_.toString$ = function toString_173(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_13((builder.impl.string += 'ControlDefinition name=[' , builder), this.name_0), ']');
  $append_13($append_13((builder.impl.string += ', description=[' , builder), this.description), ']');
  return builder.impl.string;
}
;
_.description = null;
_.displayName = null;
_.name_0 = null;
_.parameters = null;
_.results = null;
function deserialize_346(streamReader, instance){
  setDescription_29(instance, $getString(streamReader, $readInt(streamReader)));
  setDisplayName_8(instance, $getString(streamReader, $readInt(streamReader)));
  setName_38(instance, $getString(streamReader, $readInt(streamReader)));
  setParameters_1(instance, dynamicCast($readObject(streamReader), Q$ConfigurationDefinition));
  setResults_2(instance, dynamicCast($readObject(streamReader), Q$ConfigurationDefinition));
}

function instantiate_334(streamReader){
  return new ServerPluginControlDefinition_0;
}

function setDescription_29(instance, value){
  instance.description = value;
}

function setDisplayName_8(instance, value){
  instance.displayName = value;
}

function setName_38(instance, value){
  instance.name_0 = value;
}

function setParameters_1(instance, value){
  instance.parameters = value;
}

function setResults_2(instance, value){
  instance.results = value;
}

function ServerPluginControlResults_0(){
  this.complexResults = new Configuration_0;
}

defineSeed(1420, 1, makeCastMap([Q$Serializable, Q$ServerPluginControlResults]), ServerPluginControlResults_0);
_.toString$ = function toString_174(){
  var str;
  str = new StringBuilder_1('ServerPluginControlResults');
  this.errorMessage_0 != null && $append_13($append_13((str.impl.string += ' error=[' , str), this.errorMessage_0), '];');
  $append_13($append_12((str.impl.string += ' results=[' , str), this.complexResults), ']');
  return str.impl.string;
}
;
_.errorMessage_0 = null;
function deserialize_347(streamReader, instance){
  setComplexResults(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setErrorMessage_5(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_335(streamReader){
  return new ServerPluginControlResults_0;
}

function setComplexResults(instance, value){
  instance.complexResults = value;
}

function setErrorMessage_5(instance, value){
  instance.errorMessage_0 = value;
}

function deserialize_348(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setPluginConfiguration(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setScheduledJobsConfiguration(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setType_1(instance, $getString(streamReader, $readInt(streamReader)));
  deserialize_342(streamReader, instance);
}

function instantiate_336(streamReader){
  return new ServerPlugin_0;
}

function setPluginConfiguration(instance, value){
  instance.pluginConfiguration = value;
}

function setScheduledJobsConfiguration(instance, value){
  instance.scheduledJobsConfiguration = value;
}

function setType_1(instance, value){
  instance.type_0 = value;
}

function InventorySummary_0(){
}

defineSeed(1447, 1, makeCastMap([Q$Serializable, Q$InventorySummary]), InventorySummary_0);
_.compatibleGroupCount = 0;
_.groupDefinitionCount = 0;
_.mixedGroupCount = 0;
_.platformCount = 0;
_.scheduledMeasurementsPerMinute = 0;
_.serverCount = 0;
_.serviceCount = 0;
_.softwareProductCount = 0;
_.softwareUpdateCount = 0;
function deserialize_360(streamReader, instance){
  setCompatibleGroupCount(instance, $readInt(streamReader));
  setGroupDefinitionCount(instance, $readInt(streamReader));
  setMixedGroupCount(instance, $readInt(streamReader));
  setPlatformCount(instance, $readInt(streamReader));
  setScheduledMeasurementsPerMinute(instance, $readInt(streamReader));
  setServerCount_0(instance, $readInt(streamReader));
  setServiceCount(instance, $readInt(streamReader));
  setSoftwareProductCount(instance, $readInt(streamReader));
  setSoftwareUpdateCount(instance, $readInt(streamReader));
}

function instantiate_348(streamReader){
  return new InventorySummary_0;
}

function setCompatibleGroupCount(instance, value){
  instance.compatibleGroupCount = value;
}

function setGroupDefinitionCount(instance, value){
  instance.groupDefinitionCount = value;
}

function setMixedGroupCount(instance, value){
  instance.mixedGroupCount = value;
}

function setPlatformCount(instance, value){
  instance.platformCount = value;
}

function setScheduledMeasurementsPerMinute(instance, value){
  instance.scheduledMeasurementsPerMinute = value;
}

function setServerCount_0(instance, value){
  instance.serverCount = value;
}

function setServiceCount(instance, value){
  instance.serviceCount = value;
}

function setSoftwareProductCount(instance, value){
  instance.softwareProductCount = value;
}

function setSoftwareUpdateCount(instance, value){
  instance.softwareUpdateCount = value;
}

function $getAlertDefinitions(this$static){
  if (!this$static.alertDefinitions) {
    return $clinit_Collections() , $clinit_Collections() , EMPTY_SET;
  }
  return this$static.alertDefinitions;
}

function $getExplicitGroups(this$static){
  if (!this$static.explicitGroups) {
    return $clinit_Collections() , $clinit_Collections() , EMPTY_SET;
  }
  return this$static.explicitGroups;
}

function $setAlertDefinitions(this$static, alertDefinitions){
  this$static.alertDefinitions = alertDefinitions;
}

function $setAncestry(this$static, ancestry){
  this$static.ancestry = ancestry;
}

function $setCurrentAvailability(this$static, currentAvailability){
  this$static.currentAvailability = currentAvailability;
}

function $setDescription_4(this$static, description){
  this$static.description = description;
}

function $setId_6(this$static, id){
  this$static.id = id;
}

function $setLocation(this$static, location_0){
  this$static.location_0 = location_0;
}

function $setName_9(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setResourceType_0(this$static, resourceType){
  this$static.resourceType = resourceType;
}

function $setTags(this$static, tags){
  this$static.tags = tags;
}

function $setUuid(this$static, uuid){
  var i, spacesNeeded;
  if (uuid != null && uuid.length != 36) {
    if (uuid.length > 36) {
      throw new IllegalArgumentException_1('UUIDs must not be longer than [36]');
    }
     else {
      spacesNeeded = 36 - uuid.length;
      for (i = 0; i < spacesNeeded; ++i) {
        uuid = uuid + ' ';
      }
    }
  }
  this$static.uuid = uuid;
}

function $updateAncestryForResource(this$static){
  var ancestry, parentAncestry, parentResource;
  parentResource = this$static.parentResource;
  if (!parentResource || parentResource.id <= 0 || !parentResource.resourceType) {
    return null;
  }
  ancestry = new StringBuilder_0;
  $append_10(ancestry, parentResource.resourceType.id);
  ancestry.impl.string += '_:_';
  $append_10(ancestry, parentResource.id);
  ancestry.impl.string += '_:_';
  $append_13(ancestry, parentResource.name_0);
  parentAncestry = parentResource.ancestry;
  if (null != parentAncestry) {
    ancestry.impl.string += '_::_';
    $append_2(ancestry.impl, parentAncestry);
  }
  ancestry.impl.string.length < 4000 && $setAncestry(this$static, ancestry.impl.string);
  return this$static.ancestry;
}

function Resource_2(id){
  Resource_1.call(this);
  this.id = id;
}

defineSeed(1453, 1, makeCastMap([Q$Serializable, Q$Comparable, Q$Resource]), Resource_2);
function $addDriftDefinitionTemplate(this$static, template){
  !this$static.driftDefinitionTemplates && (this$static.driftDefinitionTemplates = new HashSet_1(1));
  template.resourceType = this$static;
  this$static.driftDefinitionTemplates.add_0(template);
}

function $getResourceTypeBundleConfiguration(this$static){
  return !this$static.bundleConfiguration?null:new ResourceTypeBundleConfiguration_1(this$static.bundleConfiguration);
}

function $isDeletable(this$static){
  return this$static.createDeletePolicy == ($clinit_CreateDeletePolicy() , BOTH_1) || this$static.createDeletePolicy == DELETE_ONLY;
}

function $setIgnored(this$static, ignored){
  this$static.ignored = ignored;
}

function PlatformMetricsSummary_0(){
}

defineSeed(1480, 1, makeCastMap([Q$Serializable, Q$PlatformMetricsSummary]), PlatformMetricsSummary_0);
_.actualFreeMemory = null;
_.actualUsedMemory = null;
_.freeMemory = null;
_.freeSwap = null;
_.idleCPU = null;
_.metricsAvailable = true;
_.resource = null;
_.systemCPU = null;
_.totalMemory = null;
_.totalSwap = null;
_.usedMemory = null;
_.usedSwap = null;
_.userCPU = null;
_.waitCPU = null;
function $clinit_PlatformMetricsSummary$CPUMetric(){
  $clinit_PlatformMetricsSummary$CPUMetric = nullMethod;
  Idle = new PlatformMetricsSummary$CPUMetric_0('Idle', 0, 'CpuPerc.idle');
  System = new PlatformMetricsSummary$CPUMetric_0('System', 1, 'CpuPerc.sys');
  User = new PlatformMetricsSummary$CPUMetric_0('User', 2, 'CpuPerc.user');
  Wait = new PlatformMetricsSummary$CPUMetric_0('Wait', 3, 'CpuPerc.wait');
  $VALUES_116 = initValues(_3Lorg_rhq_core_domain_resource_composite_PlatformMetricsSummary$CPUMetric_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PlatformMetricsSummary$CPUMetric, [Idle, System, User, Wait]);
}

function PlatformMetricsSummary$CPUMetric_0(enum$name, enum$ordinal, property){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.property = property;
}

function valueOf_125(name_0){
  $clinit_PlatformMetricsSummary$CPUMetric();
  return valueOf(($clinit_PlatformMetricsSummary$CPUMetric$Map() , $MAP_116), name_0);
}

function values_119(){
  $clinit_PlatformMetricsSummary$CPUMetric();
  return $VALUES_116;
}

defineSeed(1481, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PlatformMetricsSummary$CPUMetric]), PlatformMetricsSummary$CPUMetric_0);
_.property = null;
var $VALUES_116, Idle, System, User, Wait;
function $clinit_PlatformMetricsSummary$CPUMetric$Map(){
  $clinit_PlatformMetricsSummary$CPUMetric$Map = nullMethod;
  $MAP_116 = createValueOfMap(($clinit_PlatformMetricsSummary$CPUMetric() , $VALUES_116));
}

var $MAP_116;
function $clinit_PlatformMetricsSummary$MemoryMetric(){
  $clinit_PlatformMetricsSummary$MemoryMetric = nullMethod;
  ActualUsed = new PlatformMetricsSummary$MemoryMetric_0('ActualUsed', 0, 'Native.MemoryInfo.actualUsed');
  Used = new PlatformMetricsSummary$MemoryMetric_0('Used', 1, 'Native.MemoryInfo.used');
  ActualFree = new PlatformMetricsSummary$MemoryMetric_0('ActualFree', 2, 'Native.MemoryInfo.actualFree');
  Free = new PlatformMetricsSummary$MemoryMetric_0('Free', 3, 'Native.MemoryInfo.free');
  Total = new PlatformMetricsSummary$MemoryMetric_0('Total', 4, 'Native.MemoryInfo.total');
  $VALUES_117 = initValues(_3Lorg_rhq_core_domain_resource_composite_PlatformMetricsSummary$MemoryMetric_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PlatformMetricsSummary$MemoryMetric, [ActualUsed, Used, ActualFree, Free, Total]);
}

function PlatformMetricsSummary$MemoryMetric_0(enum$name, enum$ordinal, property){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.property = property;
}

function valueOf_126(name_0){
  $clinit_PlatformMetricsSummary$MemoryMetric();
  return valueOf(($clinit_PlatformMetricsSummary$MemoryMetric$Map() , $MAP_117), name_0);
}

function values_120(){
  $clinit_PlatformMetricsSummary$MemoryMetric();
  return $VALUES_117;
}

defineSeed(1483, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PlatformMetricsSummary$MemoryMetric]), PlatformMetricsSummary$MemoryMetric_0);
_.property = null;
var $VALUES_117, ActualFree, ActualUsed, Free, Total, Used;
function $clinit_PlatformMetricsSummary$MemoryMetric$Map(){
  $clinit_PlatformMetricsSummary$MemoryMetric$Map = nullMethod;
  $MAP_117 = createValueOfMap(($clinit_PlatformMetricsSummary$MemoryMetric() , $VALUES_117));
}

var $MAP_117;
function $clinit_PlatformMetricsSummary$SwapMetric(){
  $clinit_PlatformMetricsSummary$SwapMetric = nullMethod;
  Used_0 = new PlatformMetricsSummary$SwapMetric_0('Used', 0, 'Native.SwapInfo.used');
  Free_0 = new PlatformMetricsSummary$SwapMetric_0('Free', 1, 'Native.SwapInfo.free');
  Total_0 = new PlatformMetricsSummary$SwapMetric_0('Total', 2, 'Native.SwapInfo.total');
  $VALUES_118 = initValues(_3Lorg_rhq_core_domain_resource_composite_PlatformMetricsSummary$SwapMetric_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PlatformMetricsSummary$SwapMetric, [Used_0, Free_0, Total_0]);
}

function PlatformMetricsSummary$SwapMetric_0(enum$name, enum$ordinal, property){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.property = property;
}

function valueOf_127(name_0){
  $clinit_PlatformMetricsSummary$SwapMetric();
  return valueOf(($clinit_PlatformMetricsSummary$SwapMetric$Map() , $MAP_118), name_0);
}

function values_121(){
  $clinit_PlatformMetricsSummary$SwapMetric();
  return $VALUES_118;
}

defineSeed(1485, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PlatformMetricsSummary$SwapMetric]), PlatformMetricsSummary$SwapMetric_0);
_.property = null;
var $VALUES_118, Free_0, Total_0, Used_0;
function $clinit_PlatformMetricsSummary$SwapMetric$Map(){
  $clinit_PlatformMetricsSummary$SwapMetric$Map = nullMethod;
  $MAP_118 = createValueOfMap(($clinit_PlatformMetricsSummary$SwapMetric() , $VALUES_118));
}

var $MAP_118;
function deserialize_374(streamReader, instance){
  setActualFreeMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setActualUsedMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setFreeMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setFreeSwap(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setIdleCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setMetricsAvailable(instance, $readBoolean(streamReader));
  setResource_21(instance, dynamicCast($readObject(streamReader), Q$Resource));
  setSystemCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setTotalMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setTotalSwap(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setUsedMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setUsedSwap(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setUserCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setWaitCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
}

function instantiate_362(streamReader){
  return new PlatformMetricsSummary_0;
}

function setActualFreeMemory(instance, value){
  instance.actualFreeMemory = value;
}

function setActualUsedMemory(instance, value){
  instance.actualUsedMemory = value;
}

function setFreeMemory(instance, value){
  instance.freeMemory = value;
}

function setFreeSwap(instance, value){
  instance.freeSwap = value;
}

function setIdleCPU(instance, value){
  instance.idleCPU = value;
}

function setMetricsAvailable(instance, value){
  instance.metricsAvailable = value;
}

function setResource_21(instance, value){
  instance.resource = value;
}

function setSystemCPU(instance, value){
  instance.systemCPU = value;
}

function setTotalMemory(instance, value){
  instance.totalMemory = value;
}

function setTotalSwap(instance, value){
  instance.totalSwap = value;
}

function setUsedMemory(instance, value){
  instance.usedMemory = value;
}

function setUsedSwap(instance, value){
  instance.usedSwap = value;
}

function setUserCPU(instance, value){
  instance.userCPU = value;
}

function setWaitCPU(instance, value){
  instance.waitCPU = value;
}

function $getMTBF(this$static){
  if (this$static.failures <= 1) {
    return P0_longLit;
  }
  return this$static.current == ($clinit_AvailabilityType() , UP)?div(sub(this$static.upTime, sub(this$static.now, this$static.lastChange)), fromInt(this$static.failures - 1)):div(this$static.upTime, fromInt(this$static.failures - 1));
}

function $getMTTR(this$static){
  if (this$static.failures <= 0) {
    return P0_longLit;
  }
  return this$static.current == ($clinit_AvailabilityType() , DOWN_2)?this$static.failures > 1?div(sub(this$static.downTime, sub(this$static.now, this$static.lastChange)), fromInt(this$static.failures - 1)):P0_longLit:div(this$static.downTime, fromInt(this$static.failures));
}

function ResourceComposite_1(resource, availability){
  ResourceComposite_2.call(this, resource, availability, new ResourcePermission_0);
}

function ResourceComposite_2(resource, availability, resourcePermission){
  this.resource = resource;
  this.parent_0 = null;
  this.availability = availability;
  this.resourcePermission = resourcePermission;
}

defineSeed(1495, 1, makeCastMap([Q$Serializable, Q$ResourceComposite]), ResourceComposite_1);
function $getKey(this$static){
  var b, node, node$iterator;
  if (null == this$static.key_0) {
    b = new StringBuilder_0;
    $append_10(b, this$static.clusterGroupId);
    for (node$iterator = new AbstractList$IteratorImpl_0(this$static.hierarchy); node$iterator.i < node$iterator.this$0_0.size_1();) {
      node = dynamicCast($next_0(node$iterator), Q$ClusterKey$Node);
      b.impl.string += '::';
      $append_13(b, node.resourceTypeId + ':' + node.resourceKey);
    }
    this$static.key_0 = b.impl.string;
  }
  return this$static.key_0;
}

function ClusterKey_0(clusterResourceGroupId){
  this.clusterGroupId = clusterResourceGroupId;
  this.hierarchy = new ArrayList_0;
}

function ClusterKey_1(parentKey, childResourceTypeId, childResourceKey){
  var rootClusterNodes;
  rootClusterNodes = parentKey.hierarchy;
  this.clusterGroupId = parentKey.clusterGroupId;
  this.hierarchy = new ArrayList_2(rootClusterNodes);
  this.hierarchy.add_0(new ClusterKey$Node_0(childResourceTypeId, childResourceKey));
}

defineSeed(1509, 1, makeCastMap([Q$Serializable, Q$ClusterKey]), ClusterKey_0, ClusterKey_1);
_.equals$ = function equals_115(o){
  var that;
  if (this === o)
    return true;
  if (!instanceOf(o, Q$ClusterKey))
    return false;
  that = dynamicCast(o, Q$ClusterKey);
  if (!$equals_6($getKey(this), $getKey(that)))
    return false;
  return true;
}
;
_.hashCode$ = function hashCode_115(){
  return getHashCode_0($getKey(this));
}
;
_.toString$ = function toString_189(){
  return $getKey(this);
}
;
_.clusterGroupId = 0;
_.hierarchy = null;
_.key_0 = null;
function ClusterKey$Node_0(resourceTypeId, resourceKey){
  this.resourceTypeId = resourceTypeId;
  this.resourceKey = $replace_1(resourceKey, ':', '%3a');
}

defineSeed(1510, 1, makeCastMap([Q$Serializable, Q$ClusterKey$Node]), ClusterKey$Node_0);
_.toString$ = function toString_190(){
  return this.resourceTypeId + ':' + this.resourceKey;
}
;
_.resourceKey = null;
_.resourceTypeId = 0;
function serialize_324(streamWriter, instance){
  $writeInt(streamWriter, instance.clusterGroupId);
  $writeObject(streamWriter, instance.hierarchy);
  $writeString(streamWriter, instance.key_0);
}

function serialize_325(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function serialize_326(streamWriter, instance){
  $writeString(streamWriter, instance.resourceKey);
  $writeInt(streamWriter, instance.resourceTypeId);
}

function $setDescription_5(this$static, description){
  this$static.description = description;
}

function $setName_10(this$static, name_0){
  this$static.name_0 = name_0;
}

function $getNextCalculationTime(this$static){
  var mt, ri;
  ri = valueOf_50(this$static.recalculationInterval);
  if (!ri || eq(ri.value_0, P0_longLit)) {
    return valueOf_50(P0_longLit);
  }
   else {
    if (this$static.lastCalculationTime) {
      return valueOf_50(add(this$static.lastCalculationTime.value_0, ri.value_0));
    }
     else {
      mt = this$static.modifiedTime;
      return valueOf_50(add(mt?mt.value_0:fromDouble(currentTimeMillis0()), ri.value_0));
    }
  }
}

function $setDescription_6(this$static, description){
  this$static.description = description;
}

function $setExpression(this$static, expression){
  this$static.expression = expression;
}

function $setId_7(this$static, id){
  this$static.id = id;
}

function $setName_11(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setRecalculationInterval(this$static, recalculationInterval){
  this$static.recalculationInterval = recalculationInterval.value_0;
}

function $setRecursive(this$static, recursive){
  this$static.recursive = recursive;
}

function $setDescription_7(this$static, description){
  this$static.description = description;
}

function $setId_8(this$static, id){
  this$static.id = id;
}

function $setName_12(this$static, name_0){
  this$static.name_0 = name_0;
}

function $getExplicitResources(this$static){
  !this$static.explicitResources && (this$static.explicitResources = new HashSet_0);
  return this$static.explicitResources;
}

function $setAutoGroupParentResource(this$static, autoGroupParentResource){
  this$static.autoGroupParentResource = autoGroupParentResource;
}

function $setGroupCategory(this$static, groupCategory){
  this$static.groupCategory = groupCategory;
}

function $setId_9(this$static, id){
  this$static.id = id;
}

function $setRecursive_0(this$static, recursive){
  this$static.recursive = recursive;
}

function $setResourceType_1(this$static, resourceType){
  this$static.resourceType = resourceType;
  !resourceType?$setGroupCategory(this$static, ($clinit_GroupCategory() , MIXED_0)):$setGroupCategory(this$static, ($clinit_GroupCategory() , COMPATIBLE));
}

function $setTags_0(this$static, tags){
  this$static.tags = tags;
}

function ResourceGroup_2(name_0){
  this.name_0 = name_0;
  $$init_15(this);
  this.resourceType = null;
  $setGroupCategory(this, ($clinit_GroupCategory() , MIXED_0));
}

defineSeed(1527, 1517, makeCastMap([Q$Serializable, Q$Group, Q$ResourceGroup]), ResourceGroup_2);
function ClusterFlyweight_0(){
  this.children_0 = new ArrayList_1(0);
}

defineSeed(1530, 1, makeCastMap([Q$Serializable, Q$ClusterFlyweight]), ClusterFlyweight_0);
_.equals$ = function equals_119(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$ClusterFlyweight)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$ClusterFlyweight);
  if (this.groupId != other.groupId) {
    return false;
  }
  if (!this.clusterKey) {
    if (other.clusterKey) {
      return false;
    }
  }
   else if (!$equals_43(this.clusterKey, other.clusterKey)) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_119(){
  var result;
  result = 31 + this.groupId;
  result = 31 * result + (!this.clusterKey?0:$hashCode_27(this.clusterKey));
  return result;
}
;
_.toString$ = function toString_195(){
  var builder;
  builder = new StringBuilder_0;
  $append_13($append_12($append_13($append_13((builder.impl.string += 'ClusterFlyweight [name=' , builder), this.name_0), ', clusterKey='), this.clusterKey), ']');
  return builder.impl.string;
}
;
_.clusterKey = null;
_.clusterSize = 0;
_.groupId = 0;
_.members_0 = 0;
_.name_0 = null;
function deserialize_394(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_382(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_resource_group_composite_ClusterFlyweight_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ClusterFlyweight, size, 0);
}

function deserialize_395(streamReader, instance){
  setChildren_1(instance, dynamicCast($readObject(streamReader), Q$List));
  setClusterKey_0(instance, dynamicCast($readObject(streamReader), Q$ClusterKeyFlyweight));
  setClusterSize(instance, $readInt(streamReader));
  setGroupId_1(instance, $readInt(streamReader));
  setMembers(instance, $readInt(streamReader));
  setName_48(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_383(streamReader){
  return new ClusterFlyweight_0;
}

function setChildren_1(instance, value){
  instance.children_0 = value;
}

function setClusterKey_0(instance, value){
  instance.clusterKey = value;
}

function setClusterSize(instance, value){
  instance.clusterSize = value;
}

function setGroupId_1(instance, value){
  instance.groupId = value;
}

function setMembers(instance, value){
  instance.members_0 = value;
}

function setName_48(instance, value){
  instance.name_0 = value;
}

function $equals_43(this$static, o){
  var node;
  if (this$static === o) {
    return true;
  }
  if (!instanceOf(o, Q$ClusterKeyFlyweight)) {
    return false;
  }
  node = dynamicCast(o, Q$ClusterKeyFlyweight);
  if (this$static.resourceTypeId != node.resourceTypeId) {
    return false;
  }
  if (this$static.resourceKey != null?!$equals_6(this$static.resourceKey, node.resourceKey):node.resourceKey != null) {
    return false;
  }
  return true;
}

function $hashCode_27(this$static){
  var result;
  result = this$static.resourceTypeId;
  result = 31 * result + (this$static.resourceKey != null?getHashCode_0(this$static.resourceKey):0);
  return result;
}

function ClusterKeyFlyweight_0(){
}

defineSeed(1533, 1, makeCastMap([Q$Serializable, Q$ClusterKeyFlyweight]), ClusterKeyFlyweight_0);
_.equals$ = function equals_120(o){
  return $equals_43(this, o);
}
;
_.hashCode$ = function hashCode_120(){
  return $hashCode_27(this);
}
;
_.toString$ = function toString_196(){
  return 'ClusterKeyFlyweight[type=' + this.resourceTypeId + ',key=' + this.resourceKey + ']';
}
;
_.resourceKey = null;
_.resourceTypeId = 0;
function deserialize_396(streamReader, instance){
  setResourceKey_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_6(instance, $readInt(streamReader));
}

function instantiate_384(streamReader){
  return new ClusterKeyFlyweight_0;
}

function setResourceKey_0(instance, value){
  instance.resourceKey = value;
}

function setResourceTypeId_6(instance, value){
  instance.resourceTypeId = value;
}

function ResourceGroupAvailability_0(){
}

defineSeed(1535, 1, makeCastMap([Q$Serializable, Q$ResourceGroupAvailability]), ResourceGroupAvailability_0);
_.endTime = null;
_.groupAvailabilityType = null;
_.resourceGroupId = 0;
_.startTime = null;
function deserialize_397(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_385(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_resource_group_composite_ResourceGroupAvailability_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ResourceGroupAvailability, size, 0);
}

function deserialize_398(streamReader, instance){
  setEndTime_3(instance, dynamicCast($readObject(streamReader), Q$Long));
  setGroupAvailabilityType(instance, dynamicCast($readObject(streamReader), Q$ResourceGroupComposite$GroupAvailabilityType));
  setResourceGroupId(instance, $readInt(streamReader));
  setStartTime_2(instance, dynamicCast($readObject(streamReader), Q$Long));
}

function instantiate_386(streamReader){
  return new ResourceGroupAvailability_0;
}

function setEndTime_3(instance, value){
  instance.endTime = value;
}

function setGroupAvailabilityType(instance, value){
  instance.groupAvailabilityType = value;
}

function setResourceGroupId(instance, value){
  instance.resourceGroupId = value;
}

function setStartTime_2(instance, value){
  instance.startTime = value;
}

function ResourceGroupComposite_1(explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, resourceGroup){
  ResourceGroupComposite_2.call(this, explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, resourceGroup, new ResourcePermission_0);
}

function ResourceGroupComposite_2(explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, resourceGroup, permissions){
  this.implicitCount = implicitCount.value_0;
  this.implicitDown = implicitDown.value_0;
  this.implicitUnknown = implicitUnknown.value_0;
  this.implicitDisabled = implicitDisabled.value_0;
  this.explicitCount = explicitCount.value_0;
  this.explicitDown = explicitDown.value_0;
  this.explicitUnknown = explicitUnknown.value_0;
  this.explicitDisabled = explicitDisabled.value_0;
  this.resourceGroup = resourceGroup;
  if (this.resourceGroup.groupCategory == ($clinit_GroupCategory() , COMPATIBLE)) {
    this.category = COMPATIBLE;
  }
   else if (this.resourceGroup.groupCategory == MIXED_0) {
    this.category = MIXED_0;
  }
   else {
    throw new IllegalArgumentException_1('Unknown category [' + this.resourceGroup.groupCategory + '] for ResourceGroup [' + this.resourceGroup.name_0 + ']');
  }
  this.resourceFacets = null;
  this.resourcePermission = permissions;
}

defineSeed(1538, 1, makeCastMap([Q$Serializable, Q$ResourceGroupComposite]), ResourceGroupComposite_1);
function deserialize_400(streamReader, instance){
}

function instantiate_388(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_ResourceGroupComposite$GroupAvailabilityType() , $clinit_ResourceGroupComposite$GroupAvailabilityType() , $VALUES_120);
  return values[ordinal];
}

function $setName_13(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setNamespace(this$static, namespace){
  this$static.namespace = namespace;
}

function $setSemantic(this$static, semantic){
  this$static.semantic = semantic;
}

function Tag_1(tag){
  if (tag.indexOf(':') != -1) {
    this.namespace = $split(tag, ':', 0)[0];
    tag = $split(tag, ':', 0)[1];
  }
  if (tag.indexOf('=') != -1) {
    this.semantic = $split(tag, '=', 0)[0];
    tag = $split(tag, '=', 0)[1];
  }
  this.name_0 = tag;
}

defineSeed(1555, 1, makeCastMap([Q$Serializable, Q$Tag]), Tag_1);
function $setMajor(this$static, major){
  this$static.major = major;
}

function $setMicro(this$static, micro){
  this$static.micro = micro;
}

function $setMinor(this$static, minor){
  this$static.minor = minor;
}

function OrderingField_1(field, ordering){
  this.field = field;
  this.ordering = ordering?ordering:($clinit_PageOrdering() , ASC);
}

defineSeed(1562, 1, makeCastMap([Q$Serializable, Q$OrderingField]), OrderingField_1);
function $addDefaultOrderingField(this$static, defaultField, defaultPageOrdering){
  var ordering, ordering$iterator;
  if (this$static.orderingFields.size_0 >= 3) {
    return;
  }
  for (ordering$iterator = $listIterator(this$static.orderingFields, 0); ordering$iterator.currentNode != ordering$iterator.this$0.header;) {
    ordering = dynamicCast($next_5(ordering$iterator), Q$OrderingField);
    if ($equals_6(ordering.field, defaultField)) {
      return;
    }
  }
  $add_8(this$static.orderingFields, new OrderingField_1(defaultField, defaultPageOrdering));
}

function $initDefaultOrderingField(this$static, defaultPageOrdering){
  if (this$static.orderingFields.size_0 > 0) {
    return;
  }
  $addDefaultOrderingField(this$static, 'timestamp', defaultPageOrdering);
}

function $removeOrderingField(this$static, doomedField){
  var field, i;
  for (i = $listIterator(this$static.orderingFields, 0); i.currentNode != i.this$0.header;) {
    field = dynamicCast($next_5(i), Q$OrderingField);
    if ($equals_6(field.field, doomedField)) {
      $remove_14(i);
      break;
    }
  }
}

function getExplicitPageControl(firstRecord, recordCount){
  var pc;
  pc = new PageControl_1(-1, recordCount);
  pc.firstRecord = valueOf_49(firstRecord);
  return pc;
}

defineSeed(1564, 1, makeCastMap([Q$Serializable, Q$Cloneable, Q$PageControl]));
_.setPageSize = function setPageSize(pageSize){
  this.pageNumber = pageSize != 0 && pageSize != -1?~~((this.firstRecord?this.firstRecord.value_0:this.pageNumber * this.pageSize) / pageSize):0;
  this.pageSize = pageSize;
}
;
function $getTotalSize(this$static){
  return max_1(this$static.size_0, this$static.totalSize);
}

function $setPageControl_0(this$static, pageControl){
  this$static.pageControl = pageControl;
}

function $setTotalSize(this$static, totalSize){
  this$static.isUnbounded = false;
  this$static.totalSize = totalSize;
}

function $setUnbounded(this$static, isUnbounded){
  this$static.isUnbounded = isUnbounded;
  isUnbounded && (this$static.totalSize = 0);
}

function PageList_1(collection, pageControl){
  ArrayList_2.call(this, collection);
  this.isUnbounded = true;
  this.pageControl = pageControl;
}

function PageList_2(pageControl){
  $$init(this);
  this.isUnbounded = true;
  this.pageControl = pageControl;
}

defineSeed(1566, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess, Q$PageList]), PageList_1, PageList_2);
function deserialize_411(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_399(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_util_PageList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PageList, size, 0);
}

function useForwardSlash(path){
  $clinit_StringUtils();
  return null != path?$replace_0(path, 92, 47):null;
}

defineSeed(1573, 1564, makeCastMap([Q$Serializable, Q$Cloneable, Q$PageControl]));
_.setPageSize = function setPageSize_1(pageSize){
  throw new UnsupportedOperationException_1('page size cannot be changed from -1 for an UnlimitedPageControl.');
}
;
function unwrapArray(input){
  var i, output;
  if (input == null) {
    return null;
  }
  output = initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, input.length, 1);
  for (i = 0; i < input.length; ++i) {
    output[i] = input[i].value_0;
  }
  return output;
}

function unwrapCollection(input){
  var intermediate;
  if (!input) {
    return null;
  }
  intermediate = dynamicCast($toArray(input, initDim(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, input.map_0.size_1(), 0)), Q$Integer_$1);
  return unwrapArray(intermediate);
}

function $createContent(this$static, viewName){
  var canvas, logoutView;
  if ($equals_6(viewName, ($clinit_DashboardsView() , VIEW_ID_18).name_0)) {
    canvas = new DashboardsView_0;
  }
   else if ($equals_6(viewName, ($clinit_InventoryView() , VIEW_ID_23).name_0)) {
    canvas = new InventoryView_0;
  }
   else if ($equals_6(viewName, ($clinit_ResourceTopView() , VIEW_ID_26).name_0)) {
    canvas = new ResourceTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_ResourceGroupTopView() , VIEW_ID_24).name_0)) {
    canvas = new ResourceGroupTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_ReportTopView() , VIEW_ID_29).name_0)) {
    canvas = new ReportTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_BundleTopView() , VIEW_ID_16).name_0)) {
    canvas = new BundleTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_AdministrationView() , VIEW_ID).name_0)) {
    canvas = new AdministrationView_0;
  }
   else if ($equals_6(viewName, ($clinit_HelpView() , VIEW_ID_22).name_0)) {
    canvas = new HelpView_0;
  }
   else if ($equals_6(viewName, 'LogOut')) {
    logout();
    $hide(this$static.rootCanvas);
    logoutView = new LoginView_0;
    canvas = logoutView;
    $showLoginDialog(logoutView);
  }
   else 
    $equals_6(viewName, ($clinit_TaggedView() , VIEW_ID_33).name_0)?(canvas = new TaggedView_0):$equals_6(viewName, 'Subsystems')?(canvas = new AlertHistoryView_0):$equals_6(viewName, ($clinit_TestTopView() , VIEW_ID_34).name_0)?(canvas = new TestTopView_0):(canvas = null);
  return canvas;
}

defineSeed(1584, 1, makeCastMap([Q$RunAsyncCallback]));
_.onSuccess = function onSuccess_0(){
  this.this$1.currentCanvas = $createContent(this.this$1.this$0, this.this$1.currentViewId.path);
  !!this.this$1.currentCanvas && $addChild(this.val$contentCanvas, this.this$1.currentCanvas);
  this.val$contentCanvas.markForRedraw_0();
  $render(this.this$1, this.val$viewPath);
  info_0('Time to Load first codesplit fragment: ' + toString_8(sub(fromDouble(currentTimeMillis0()), this.val$startTime)) + ' ms.');
}
;
function $setupWindow(this$static, title, item){
  $isCreated_1(this$static)?$setProperty_4(this$static, 'title', title):(this$static.config_0['title'] = title , undefined);
  $setShowMinimizeButton(this$static, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setShowMaximizeButton(this$static, TRUE);
  $setIsModal(this$static, TRUE);
  $setShowModalMask(this$static, TRUE);
  $setAutoSize(this$static, TRUE);
  $setAutoCenter(this$static, TRUE);
  $setShowResizer(this$static, TRUE);
  $setCanDragResize_0(this$static, TRUE);
  $centerInPage(this$static);
  $addCloseClickHandler(this$static, new ErrorMessageWindow$1_0(this$static));
  $addItem(this$static, item);
}

function ErrorMessageWindow_0(title, item){
  Window_1.call(this);
  $setupWindow(this, title, item);
}

function ErrorMessageWindow_1(title, message){
  $clinit_BaseWidget();
  var htmlPane;
  Window_1.call(this);
  htmlPane = new HTMLPane_0;
  $setMargin(htmlPane, valueOf_49(10));
  $isCreated_1(htmlPane)?$setProperty_1(htmlPane, 'defaultWidth', 500):(htmlPane.config_0['defaultWidth'] = 500 , undefined);
  $isCreated_1(htmlPane)?$setProperty_1(htmlPane, 'defaultHeight', 400):(htmlPane.config_0['defaultHeight'] = 400 , undefined);
  $isCreated_1(htmlPane)?$setProperty_4(htmlPane, 'contents', message):(htmlPane.config_0['contents'] = message , undefined);
  $setupWindow(this, title, htmlPane);
}

defineSeed(1586, 458, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), ErrorMessageWindow_0, ErrorMessageWindow_1);
function ErrorMessageWindow$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1587, 1, makeCastMap([Q$EventHandler, Q$CloseClickHandler]), ErrorMessageWindow$1_0);
_.onCloseClick_0 = function onCloseClick(event_0){
  $markForDestroy(this.this$0);
}
;
_.this$0 = null;
function EnhancedHLayout_1(){
  HLayout_1.call(this, 0);
}

defineSeed(1589, 571, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$Enhanced, Q$EnhancedHLayout]), EnhancedHLayout_1);
function getAlertNotificationResultIcon(status_0){
  !status_0 && (status_0 = ($clinit_ResultState() , UNKNOWN));
  switch (status_0.ordinal) {
    case 0:
      return getAvailabilityIcon(($clinit_Boolean() , $clinit_Boolean() , TRUE));
    case 2:
      return getAvailabilityIcon(($clinit_Boolean() , $clinit_Boolean() , FALSE));
    case 1:
      return 'subsystems/availability/availability_yellow_16.png';
    case 3:
      return '[skin]/actions/redo.png';
    case 4:
    default:return getAvailabilityIcon(null);
  }
}

function getAvailabilityGroupLargeIcon(groupAvailType){
  switch (groupAvailType.ordinal) {
    case 0:
      return 'subsystems/availability/availability_grey_24.png';
    case 2:
      return 'subsystems/availability/availability_red_24.png';
    case 3:
      return 'subsystems/availability/availability_yellow_24.png';
    case 4:
      return 'subsystems/availability/availability_orange_24.png';
    default:return 'subsystems/availability/availability_green_24.png';
  }
}

function getAvailabilityIcon(status_0){
  var availType;
  availType = !status_0?($clinit_AvailabilityType() , UNKNOWN_0):($clinit_Boolean() , TRUE) == status_0?($clinit_AvailabilityType() , UP):($clinit_AvailabilityType() , DOWN_2);
  return getAvailabilityIconFromAvailTypeAndSize(availType, false);
}

function getAvailabilityIconFromAvailTypeAndSize(availType, isLarge){
  var color;
  !availType && (availType = ($clinit_AvailabilityType() , UNKNOWN_0));
  color = null;
  switch (availType.ordinal) {
    case 1:
      color = 'green';
      break;
    case 0:
      color = 'red';
      break;
    case 3:
      color = 'orange';
      break;
    case 2:
      color = 'grey';
  }
  return 'subsystems/availability/availability_' + color + '_' + (isLarge?'24':'16') + '.png';
}

function getAvailabilityLargeIcon(status_0){
  var availType;
  availType = !status_0?($clinit_AvailabilityType() , UNKNOWN_0):($clinit_Boolean() , TRUE) == status_0?($clinit_AvailabilityType() , UP):($clinit_AvailabilityType() , DOWN_2);
  return getAvailabilityIconFromAvailTypeAndSize(availType, true);
}

function getClusteredResourceIcon(category){
  var categoryName;
  categoryName = null;
  switch (category.ordinal) {
    case 0:
      {
        categoryName = 'Platform';
        break;
      }

    case 1:
      {
        categoryName = 'Server';
        break;
      }

    case 2:
      {
        categoryName = 'Service';
        break;
      }

  }
  return 'resources/' + categoryName + '_Group_16.png';
}

function getDriftCategoryIcon(category){
  if (!category) {
    return 'subsystems/drift/Drift_new_16.png';
  }
  switch (category.ordinal) {
    case 0:
      return 'subsystems/drift/Drift_add_16.png';
    case 1:
      return 'subsystems/drift/Drift_change_16.png';
    case 2:
      return 'subsystems/drift/Drift_remove_16.png';
  }
  return null;
}

function getEventSeverityIcon(severity){
  var icon;
  icon = '';
  if (severity) {
    switch (severity.ordinal) {
      case 0:
        icon = '_debug';
        break;
      case 1:
        icon = '_info';
        break;
      case 2:
        icon = '_warning';
        break;
      case 3:
        icon = '_error';
        break;
      case 4:
        icon = '_fatal';
    }
  }
  return 'subsystems/event/Events' + icon + '_16.png';
}

function getGroupIcon(groupType){
  var category;
  category = groupType == ($clinit_GroupCategory() , COMPATIBLE)?'Cluster':'Group';
  return 'types/' + category + '_up_16.png';
}

function getGroupLargeIcon(groupType){
  var category;
  category = groupType == ($clinit_GroupCategory() , COMPATIBLE)?'Cluster':'Group';
  return 'types/' + category + '_up_24.png';
}

function getOperationResultsIcon(status_0){
  var icon;
  icon = '';
  if (status_0) {
    switch (status_0.ordinal) {
      case 0:
        icon = '_inprogress';
        break;
      case 1:
        icon = '_ok';
        break;
      case 2:
        icon = '_failed';
        break;
      case 3:
        icon = '_cancel';
    }
  }
  return 'subsystems/control/Operation' + icon + '_16.png';
}

function getPluginConfigurationIcon(updateStatus){
  if (updateStatus) {
    switch (updateStatus.ordinal) {
      case 1:
        {
          return 'subsystems/inventory/Connection_ok_16.png';
        }

      case 2:
        {
          return 'subsystems/inventory/Connection_failed_16.png';
        }

      case 0:
        {
          return 'subsystems/inventory/Connection_inprogress_16.png';
        }

      case 3:
        return 'subsystems/inventory/Connection_16.png';
    }
  }
  return 'subsystems/inventory/Connection_16.png';
}

function getResourceConfigurationIcon(updateStatus){
  if (updateStatus) {
    switch (updateStatus.ordinal) {
      case 1:
        {
          return 'subsystems/configure/Configure_ok_16.png';
        }

      case 2:
        {
          return 'subsystems/configure/Configure_failed_16.png';
        }

      case 0:
        {
          return 'subsystems/configure/Configure_inprogress_16.png';
        }

      case 3:
        return 'subsystems/configure/Configure_16.png';
    }
  }
  return 'subsystems/configure/Configure_16.png';
}

function getAlertDetailLink(entityContext, alertId){
  var baseLink, link;
  baseLink = getEntityTabLink(entityContext, 'Alerts', 'History');
  link = baseLink + '/' + alertId;
  return link;
}

function getAutoClusterTabLink(autoClusterGroupId, tabName, subTabName){
  return '#ResourceGroup/AutoCluster/' + autoClusterGroupId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getAutoGroupTabLink(autoGroupId, tabName, subTabName){
  return '#Resource/AutoGroup/' + autoGroupId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getBundleDestinationLink(bundleId, bundleDestinationId){
  return '#Bundles/Bundle/' + bundleId + '/destinations' + (bundleDestinationId == 0?'':'/' + bundleDestinationId);
}

function getBundleVersionLink(bundleId, bundleVersionId){
  return '#Bundles/Bundle/' + bundleId + '/versions' + (bundleVersionId == 0?'':'/' + bundleVersionId);
}

function getDriftCarouselDriftLink(resourceId, driftDefId, driftId){
  driftId.indexOf('0id_') == 0 || (driftId = '0id_' + driftId);
  return '#Resource/' + resourceId + '/Drift/Definitions/' + driftDefId + '/Drift/' + driftId;
}

function getEntityTabLink(entityContext, tabName, subTabName){
  var link;
  switch (entityContext.type_0.ordinal) {
    case 0:
      link = getResourceTabLink(entityContext.resourceId, tabName, subTabName);
      break;
    case 2:
      ($clinit_EntityContext$Type() , ResourceGroup) == entityContext.type_0 && entityContext.isAutoGroup?(link = getAutoGroupTabLink(entityContext.groupId, tabName, subTabName)):ResourceGroup == entityContext.type_0 && entityContext.isAutoCluster?(link = getAutoClusterTabLink(entityContext.groupId, tabName, subTabName)):(link = getResourceGroupTabLink(entityContext.groupId, tabName, subTabName));
      break;
    case 4:
      if ($equals_6(tabName, 'Alerts') && $equals_6(subTabName, 'Definitions')) {
        link = '#Reports/Subsystems/AlertDefinitions';
      }
       else if ($equals_6(tabName, 'Alerts') && $equals_6(subTabName, 'History')) {
        link = '#Reports/Subsystems/RecentAlerts';
      }
       else if ($equals_6(tabName, 'Operations') && $equals_6(subTabName, 'History')) {
        link = '#Reports/Subsystems/RecentOperations';
      }
       else if ($equals_6(tabName, 'Configuration') && $equals_6(subTabName, 'History')) {
        link = '#Reports/Subsystems/ConfigurationHistoryView';
      }
       else {
        throw new IllegalArgumentException_1('Subsystem link not supported for tab ' + tabName + '>' + subTabName + '.');
      }

      break;
    default:throw new IllegalArgumentException_1('Unsupported entity context type: ' + entityContext.type_0);
  }
  return link;
}

function getGroupOperationHistoryLink(group, groupOperationHistoryId){
  return getEntityTabLink(forGroup_0(group), 'Operations', 'History') + '/' + groupOperationHistoryId;
}

function getGroupPluginConfigurationUpdateHistoryLink(group, groupUpdateHistoryId){
  return groupUpdateHistoryId?getEntityTabLink(group, 'Inventory', 'ConnectionSettingsHistory') + '/' + groupUpdateHistoryId:getEntityTabLink(group, 'Inventory', 'ConnectionSettingsHistory');
}

function getGroupResourceConfigurationUpdateHistoryLink(group, groupUpdateHistoryId){
  return groupUpdateHistoryId?getEntityTabLink(group, 'Configuration', 'History') + '/' + groupUpdateHistoryId:getEntityTabLink(group, 'Configuration', 'History');
}

function getHref(url, value){
  var result;
  result = '<a href="' + url + '">' + value + '<\/a>';
  return result;
}

function getResourceGroupTabLink(resourceGroupId, tabName, subTabName){
  return '#ResourceGroup/' + resourceGroupId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getResourceTabLink(resourceId, tabName, subTabName){
  return '#Resource/' + resourceId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getSubsystemAlertDefinitionLink(resourceId, alertDefinitionId){
  var link;
  link = '#Resource/' + resourceId + '/Alerts/Definitions/' + alertDefinitionId;
  return link;
}

function getTagLink(tag){
  return tag == null?'#Reports/Subsystems/Tags':'#Reports/Subsystems/Tags/' + tag;
}

function $getString_0(this$static, arg0){
  var target;
  target = dynamicCast(this$static.cache.get_2(arg0), Q$String);
  if (target != null) {
    return target;
  }
  if ($equals_6(arg0, 'view_help_section_1_item_count')) {
    this$static.cache.put('view_help_section_1_item_count', '4');
    return '4';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_1')) {
    this$static.cache.put('view_help_section_1_propTitle_1', '\u3088\u304F\u3042\u308B\u8CEA\u554F (FAQ) ');
    return '\u3088\u304F\u3042\u308B\u8CEA\u554F (FAQ) ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_2')) {
    this$static.cache.put('view_help_section_1_propTitle_2', '\u30C9\u30AD\u30E5\u30E1\u30F3\u30C6\u30FC\u30B7\u30E7\u30F3\u30BB\u30C3\u30C8');
    return '\u30C9\u30AD\u30E5\u30E1\u30F3\u30C6\u30FC\u30B7\u30E7\u30F3\u30BB\u30C3\u30C8';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_3')) {
    this$static.cache.put('view_help_section_1_propTitle_3', 'API Javadoc ');
    return 'API Javadoc ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_4')) {
    this$static.cache.put('view_help_section_1_propTitle_4', '\u30B9\u30C8\u30EC\u30FC\u30B8\u30AF\u30E9\u30B9\u30BF\u30FC\u7BA1\u7406');
    return '\u30B9\u30C8\u30EC\u30FC\u30B8\u30AF\u30E9\u30B9\u30BF\u30FC\u7BA1\u7406';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_1')) {
    this$static.cache.put('view_help_section_1_propUrl_1', 'https://docs.jboss.org/author/display/RHQ/FAQ');
    return 'https://docs.jboss.org/author/display/RHQ/FAQ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_2')) {
    this$static.cache.put('view_help_section_1_propUrl_2', 'https://docs.jboss.org/author/display/RHQ/User+Documentation');
    return 'https://docs.jboss.org/author/display/RHQ/User+Documentation';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_3')) {
    this$static.cache.put('view_help_section_1_propUrl_3', 'https://docs.jboss.org/author/display/RHQ/API+Documentation');
    return 'https://docs.jboss.org/author/display/RHQ/API+Documentation';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_4')) {
    this$static.cache.put('view_help_section_1_propUrl_4', 'https://docs.jboss.org/author/display/RHQ/RHQ+Storage+Cluster+Administration');
    return 'https://docs.jboss.org/author/display/RHQ/RHQ+Storage+Cluster+Administration';
  }
  if ($equals_6(arg0, 'view_help_section_1_title')) {
    this$static.cache.put('view_help_section_1_title', '\u30C9\u30AD\u30E5\u30E1\u30F3\u30C6\u30FC\u30B7\u30E7\u30F3');
    return '\u30C9\u30AD\u30E5\u30E1\u30F3\u30C6\u30FC\u30B7\u30E7\u30F3';
  }
  if ($equals_6(arg0, 'view_help_section_2_item_count')) {
    this$static.cache.put('view_help_section_2_item_count', '4');
    return '4';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_1')) {
    this$static.cache.put('view_help_section_2_propTitle_1', '\u30C7\u30E2: \u3059\u3079\u3066\u306E\u30C7\u30E2');
    return '\u30C7\u30E2: \u3059\u3079\u3066\u306E\u30C7\u30E2';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_2')) {
    this$static.cache.put('view_help_section_2_propTitle_2', '\u30C7\u30E2: \u30D0\u30F3\u30C9\u30EB\u30D7\u30ED\u30D3\u30B8\u30E7\u30CB\u30F3\u30B0');
    return '\u30C7\u30E2: \u30D0\u30F3\u30C9\u30EB\u30D7\u30ED\u30D3\u30B8\u30E7\u30CB\u30F3\u30B0';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_3')) {
    this$static.cache.put('view_help_section_2_propTitle_3', '\u30B0\u30EB\u30FC\u30D7\u5B9A\u7FA9\u306E\u69CB\u7BC9\u65B9\u6CD5');
    return '\u30B0\u30EB\u30FC\u30D7\u5B9A\u7FA9\u306E\u69CB\u7BC9\u65B9\u6CD5';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_4')) {
    this$static.cache.put('view_help_section_2_propTitle_4', '\u691C\u7D22\u30D0\u30FC\u306E\u4F7F\u7528\u65B9\u6CD5');
    return '\u691C\u7D22\u30D0\u30FC\u306E\u4F7F\u7528\u65B9\u6CD5';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_1')) {
    this$static.cache.put('view_help_section_2_propUrl_1', 'https://docs.jboss.org/author/display/RHQ/Demos');
    return 'https://docs.jboss.org/author/display/RHQ/Demos';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_2')) {
    this$static.cache.put('view_help_section_2_propUrl_2', 'http://management-platform.blogspot.com/2011/01/bundle-provisioning-via-rhq.html ');
    return 'http://management-platform.blogspot.com/2011/01/bundle-provisioning-via-rhq.html ';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_3')) {
    this$static.cache.put('view_help_section_2_propUrl_3', 'https://docs.jboss.org/author/display/RHQ/Group+Definitions');
    return 'https://docs.jboss.org/author/display/RHQ/Group+Definitions';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_4')) {
    this$static.cache.put('view_help_section_2_propUrl_4', 'https://docs.jboss.org/author/display/RHQ/Search');
    return 'https://docs.jboss.org/author/display/RHQ/Search';
  }
  if ($equals_6(arg0, 'view_help_section_2_title')) {
    this$static.cache.put('view_help_section_2_title', '\u30C1\u30E5\u30FC\u30C8\u30EA\u30A2\u30EB');
    return '\u30C1\u30E5\u30FC\u30C8\u30EA\u30A2\u30EB';
  }
  if ($equals_6(arg0, 'view_help_section_count')) {
    this$static.cache.put('view_help_section_count', '2');
    return '2';
  }
  throw new MissingResourceException_0("Cannot find constant '" + arg0 + "'; expecting a method name");
}

function $common_msg_step_x_of_y(arg0, arg1){
  return '\u30B9\u30C6\u30C3\u30D7 ' + arg1 + ' \u4E2D ' + arg0 + ' \u756A\u76EE';
}

function $dataSource_schedules_disableFailure_group(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306E\u53CE\u96C6\u3092\u7121\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306F [' + arg2 + '] \u3067\u3057\u305F\u3002';
}

function $dataSource_schedules_disableFailure_resource(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u306E [' + arg0 + '] \u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306E\u53CE\u96C6\u3092\u7121\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306F [' + arg2 + '] \u3067\u3057\u305F\u3002';
}

function $dataSource_schedules_disableSuccessful_full_group(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u6E2C\u5B9A\u306E\u53CE\u96C6\u3092\u7121\u52B9\u306B\u3057\u307E\u3057\u305F\u3002\u7121\u52B9\u306B\u306A\u3063\u305F\u6E2C\u5B9A\u306F [' + arg2 + '] \u3067\u3059\u3002';
}

function $dataSource_schedules_disableSuccessful_full_resource(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u306E [' + arg0 + '] \u6E2C\u5B9A\u306E\u53CE\u96C6\u3092\u7121\u52B9\u306B\u3057\u307E\u3057\u305F\u3002\u7121\u52B9\u306B\u306A\u3063\u305F\u6E2C\u5B9A\u306F [' + arg2 + '] \u3067\u3057\u305F\u3002';
}

function $dataSource_schedules_enableFailure_group(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306E\u53CE\u96C6\u3092\u6709\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u30E1\u30C8\u30EA\u30C3\u30AF\u30B9: [' + arg2 + ']';
}

function $dataSource_schedules_enableFailure_resource(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u306E [' + arg0 + '] \u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306E\u53CE\u96C6\u3092\u6709\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306F [' + arg2 + '] \u3067\u3057\u305F\u3002';
}

function $dataSource_schedules_enableSuccessful_full_group(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u6E2C\u5B9A\u306E\u53CE\u96C6\u3092\u6709\u52B9\u306B\u3057\u307E\u3057\u305F\u3002\u6709\u52B9\u306B\u306A\u3063\u305F\u6E2C\u5B9A\u306F [' + arg2 + '] \u3067\u3059\u3002';
}

function $dataSource_schedules_enableSuccessful_full_resource(arg0, arg1, arg2){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u306E [' + arg0 + '] \u6E2C\u5B9A\u306E\u53CE\u96C6\u3092\u6709\u52B9\u306B\u3057\u307E\u3057\u305F\u3002\u6709\u52B9\u306B\u306A\u3063\u305F\u6E2C\u5B9A\u306F [' + arg2 + '] \u3067\u3059\u3002';
}

function $dataSource_schedules_updateFailure_group(arg0, arg1, arg2, arg3){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306E\u53CE\u96C6\u9593\u9694\u3092\u8A2D\u5B9A\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306F [' + arg2 + '] \u3067\u3057\u305F\u3002\u53CE\u96C6\u9593\u9694\u306F [' + arg3 + '] \u79D2\u3067\u3057\u305F\u3002';
}

function $dataSource_schedules_updateFailure_resource(arg0, arg1, arg2, arg3){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u306E [' + arg0 + '] \u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306E\u53CE\u96C6\u9593\u9694\u3092\u8A2D\u5B9A\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u30E1\u30C8\u30EA\u30C3\u30AF\u30B9\u306F [' + arg2 + '] \u3067\u3057\u305F\u3002\u53CE\u96C6\u9593\u9694\u306F [' + arg3 + '] \u79D2\u3067\u3057\u305F\u3002';
}

function $dataSource_schedules_updateSuccessful_full_group(arg0, arg1, arg2, arg3){
  return '\u65B0\u3057\u3044\u53CE\u96C6\u9593\u9694\u3068\u3057\u3066\u3001[' + arg0 + '] \u79D2\u304C ID [' + arg2 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7\u306E [' + arg1 + '] \u6E2C\u5B9A\u306B\u8A2D\u5B9A\u3055\u308C\u307E\u3057\u305F\u3002\u66F4\u65B0\u3055\u308C\u305F\u6E2C\u5B9A\u306F [' + arg3 + '] \u3067\u3059\u3002';
}

function $dataSource_schedules_updateSuccessful_full_resource(arg0, arg1, arg2, arg3){
  return '\u65B0\u3057\u3044\u53CE\u96C6\u9593\u9694\u3068\u3057\u3066\u3001[' + arg0 + '] \u79D2\u304C ID [' + arg2 + '] \u3092\u6301\u3064\u30EA\u30BD\u30FC\u30B9\u306E [' + arg1 + '] \u6E2C\u5B9A\u306B\u8A2D\u5B9A\u3055\u308C\u307E\u3057\u305F\u3002\u66F4\u65B0\u3055\u308C\u305F\u6E2C\u5B9A\u306F [' + arg3 + '] \u3067\u3059\u3002';
}

function $datasource_templateSchedules_disabled_detailed(arg0, arg1, arg2){
  return 'ID [' + arg2 + '] \u3092\u6301\u3064 ResourceType \u306B\u5BFE\u3057\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u3067\u30E1\u30C8\u30EA\u30C3\u30AF [' + arg0 + '] [' + arg1 + '] \u306E\u53CE\u96C6\u3092\u7121\u52B9\u306B\u3057\u307E\u3057\u305F\u3002';
}

function $datasource_templateSchedules_disabled_failed(arg0, arg1, arg2){
  return 'ID [' + arg2 + '] \u3092\u6301\u3064 ResourceType \u306B\u5BFE\u3057\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u3067\u30E1\u30C8\u30EA\u30C3\u30AF [' + arg0 + '] [' + arg1 + '] \u306E\u53CE\u96C6\u3092\u7121\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002';
}

function $datasource_templateSchedules_enabled_detailed(arg0, arg1, arg2){
  return 'ID [' + arg2 + '] \u3092\u6301\u3064 ResourceType \u306B\u5BFE\u3057\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u3067\u30E1\u30C8\u30EA\u30C3\u30AF [' + arg0 + '] [' + arg1 + '] \u306E\u53CE\u96C6\u3092\u6709\u52B9\u306B\u3057\u307E\u3057\u305F\u3002';
}

function $datasource_templateSchedules_enabled_failed(arg0, arg1, arg2){
  return 'ID [' + arg2 + '] \u3092\u6301\u3064 ResourceType \u306B\u5BFE\u3057\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u3067\u30E1\u30C8\u30EA\u30C3\u30AF [' + arg0 + '] [' + arg1 + '] \u306E\u53CE\u96C6\u3092\u6709\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002';
}

function $datasource_templateSchedules_updated_detail(arg0, arg1, arg2, arg3){
  return 'ID [' + arg2 + '] \u3092\u6301\u3064 ResourceType \u306B\u5BFE\u3057\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u3067\u30E1\u30C8\u30EA\u30C3\u30AF [' + arg0 + '] [' + arg1 + '] \u306E\u53CE\u96C6\u9593\u9694\u304C [' + arg3 + '] \u79D2\u306B\u8A2D\u5B9A\u3055\u308C\u307E\u3057\u305F\u3002';
}

function $datasource_templateSchedules_updated_failed(arg0, arg1, arg2, arg3){
  return 'ID [' + arg2 + '] \u3092\u6301\u3064 ResourceType \u306B\u5BFE\u3057\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u3067\u30E1\u30C8\u30EA\u30C3\u30AF [' + arg0 + '] [' + arg1 + '] \u306E\u53CE\u96C6\u9593\u9694\u3092 [' + arg3 + '] \u79D2\u306B\u8A2D\u5B9A\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002';
}

function $group_tree_partialClusterTooltip(arg0, arg1, arg2){
  return arg1 + ' \u500B\u4E2D\u3001' + arg0 + " \u500B\u306E\u30B0\u30EB\u30FC\u30D7\u30E1\u30F3\u30D0\u30FC\u304C '" + arg2 + "' \u30EA\u30BD\u30FC\u30B9\u3092\u6301\u3063\u3066\u3044\u307E\u3059";
}

function $view_adminRoles_permissions_illegalDeselectionDueToCorrespondingWritePermSelection(arg0){
  return '\u8AAD\u307F\u53D6\u308A\u6A29\u9650\u3092\u6697\u793A\u3059\u308B ' + arg0 + ' \u66F8\u304D\u8FBC\u307F\u6A29\u9650\u3092\u6700\u521D\u306B\u9078\u629E\u89E3\u9664\u3057\u306A\u3044\u3068\u3001' + arg0 + ' \u8AAD\u307F\u53D6\u308A\u6A29\u9650\u306F\u9078\u629E\u89E3\u9664\u3067\u304D\u307E\u305B\u3093\u3002';
}

function $view_adminRoles_permissions_illegalDeselectionDueToManageBundleGroupsSelection(arg0){
  return arg0 + ' \u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u6697\u793A\u3059\u308B Manage Bundle Groups \u3092\u6700\u521D\u306B\u9078\u629E\u89E3\u9664\u3057\u306A\u3044\u3068\u3001' + arg0 + ' \u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u306E\u9078\u629E\u3092\u89E3\u9664\u3067\u304D\u307E\u305B\u3093\u3002';
}

function $view_admin_downloads_connectors_help(arg0){
  return '\u30B3\u30CD\u30AF\u30BF\u30FC\u306F\u3001\u4E00\u90E8\u306E\u88FD\u54C1\u3092 ' + arg0 + ' \u3067\u7BA1\u7406\u3067\u304D\u308B\u3088\u3046\u306B\u3059\u308B\u305F\u3081\u306B\u5FC5\u8981\u306A\u30BD\u30D5\u30C8\u30A6\u30A7\u30A2\u3067\u3059\u3002\u30B3\u30CD\u30AF\u30BF\u30FC\u3092\u7BA1\u7406\u5BFE\u8C61\u306E\u88FD\u54C1\u306B\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3057\u3001' + arg0 + ' \u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u30B3\u30CD\u30AF\u30BF\u30FC\u3068\u5BFE\u8A71\u3067\u304D\u308B\u3088\u3046\u306B\u3057\u307E\u3059\u3002\u8A73\u7D30\u306F\u30C9\u30AD\u30E5\u30E1\u30F3\u30C8\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044\u3002';
}

function $view_admin_landing(arg0){
  return '\u3053\u306E\u30BB\u30AF\u30B7\u30E7\u30F3\u3088\u308A\u3001' + arg0 + ' \u500B\u306E\u30B0\u30ED\u30FC\u30D0\u30EB\u8A2D\u5B9A\u304C\u7BA1\u7406\u3055\u308C\u307E\u3059\u3002\u3053\u308C\u306B\u306F\u3001\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u306E\u8A2D\u5B9A\u3001\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u8A2D\u5B9A\u3001\u304A\u3088\u3073 ' + arg0 + ' \u30B5\u30FC\u30D0\u30FC\u3068\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u7BA1\u7406\u304C\u542B\u307E\u308C\u307E\u3059\u3002';
}

function $view_alerts_field_ack_status_ackHover(arg0, arg1){
  return arg1 + ' \u306B\u304A\u3044\u3066 ' + arg0 + ' \u304C\u78BA\u8A8D';
}

function $view_bundle_createWizard_createSuccessful(arg0, arg1){
  return '\u30D0\u30FC\u30B8\u30E7\u30F3 [' + arg1 + '] \u306E [' + arg0 + '] \u3068\u3044\u3046\u540D\u524D\u306E\u30D0\u30F3\u30C9\u30EB\u306E\u4F5C\u6210\u306B\u6210\u529F\u3057\u307E\u3057\u305F';
}

function $view_bundle_createWizard_groupsStep_failedAssign(arg0, arg1){
  return '\u6700\u521D\u306E\u30D0\u30F3\u30C9\u30EB\u30B0\u30EB\u30FC\u30D7\u3092\u3001\u30D0\u30FC\u30B8\u30E7\u30F3 [' + arg1 + '] \u306E [' + arg0 + '] \u3068\u3044\u3046\u540D\u524D\u306E\u30D0\u30F3\u30C9\u30EB\u3078\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002\u4F5C\u6210\u30A6\u30A3\u30B6\u30FC\u30C9\u3092\u30AD\u30E3\u30F3\u30BB\u30EB\u3057\u3001\u7BA1\u7406\u8005\u306B\u5831\u544A\u3057\u3066\u304F\u3060\u3055\u3044\u3002';
}

function $view_bundle_createWizard_groupsStep_successAssign(arg0, arg1){
  return '\u30D0\u30FC\u30B8\u30E7\u30F3 [' + arg1 + '] \u306E [' + arg0 + '] \u3068\u3044\u3046\u540D\u524D\u306E\u30D0\u30F3\u30C9\u30EB\u30B0\u30EB\u30FC\u30D7\u306B\u3001\u6700\u521D\u306E\u30D0\u30F3\u30C9\u30EB\u30B0\u30EB\u30FC\u30D7\u3092\u6B63\u5E38\u306B\u5272\u308A\u5F53\u3066\u307E\u3057\u305F';
}

function $view_bundle_deployWizard_deploymentCreatedDetail(arg0, arg1){
  return '\u30C7\u30A3\u30B9\u30AF\u30EA\u30D7\u30B7\u30E7\u30F3 [' + arg1 + '] \u306E\u4ED8\u3044\u305F\u30C7\u30D7\u30ED\u30A4\u30E1\u30F3\u30C8 [' + arg0 + '] \u3092\u4F5C\u6210\u3057\u307E\u3057\u305F';
}

function $view_bundle_deployWizard_destinationCreatedDetail(arg0, arg1){
  return '\u30C7\u30A3\u30B9\u30AF\u30EA\u30D7\u30B7\u30E7\u30F3 [' + arg1 + '] \u306E\u4ED8\u3044\u305F\u30C7\u30D7\u30ED\u30A4\u30E1\u30F3\u30C8 [' + arg0 + '] \u3092\u4F5C\u6210\u3057\u307E\u3057\u305F';
}

function $view_bundle_revertWizard_confirmStep_noPriorDeployment(arg0, arg1){
  return '\u5B9B\u5148 [' + arg1 + '] \u306E\u4EE5\u524D\u306E\u30C7\u30D7\u30ED\u30A4\u30E1\u30F3\u30C8\u304C\u5B58\u5728\u3057\u306A\u3044\u305F\u3081\u3001\u52D5\u4F5C\u4E2D\u306E\u30C7\u30D7\u30ED\u30A4\u30E1\u30F3\u30C8 [' + arg0 + '] \u306F\u53D6\u308A\u6D88\u3059\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F';
}

function $view_bundle_revertWizard_revertStep_scheduledDetails(arg0, arg1){
  return '\u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7 [' + arg1 + '] \u304B\u3089\u30D0\u30F3\u30C9\u30EB\u30C7\u30D7\u30ED\u30A4 [' + arg0 + '] \u306E\u53D6\u308A\u6D88\u3057\u306E\u30B9\u30B1\u30B8\u30E5\u30FC\u30EB\u306B\u6210\u529F\u3057\u307E\u3057\u305F';
}

function $view_configEdit_confirm_3(arg0, arg1){
  return '[' + arg1 + '] \u304C\u9078\u629E\u3055\u308C\u305F [' + arg0 + '] \u3092\u524A\u9664\u3057\u3066\u3082\u3088\u308D\u3057\u3044\u3067\u3059\u304B?';
}

function $view_configurationDetails_messageDetailed(arg0, arg1){
  return '\u30EA\u30BD\u30FC\u30B9 [' + arg1 + '] \u306E\u8A2D\u5B9A\u306F\u30D0\u30FC\u30B8\u30E7\u30F3 ' + arg0 + ' \u3078\u66F4\u65B0\u3055\u308C\u307E\u3057\u305F';
}

function $view_drift_table_title_snapshot(arg0, arg1){
  return '\u5B9A\u7FA9 [' + arg1 + '] \u306E\u305F\u3081\u306E\u30B9\u30CA\u30C3\u30D7\u30B7\u30E7\u30C3\u30C8 [' + arg0 + ']';
}

function $view_drift_wizard_pinTemplate_title(arg0, arg1, arg2){
  return '\u30BF\u30A4\u30D7 [' + arg2 + '] \u306E\u30C9\u30EA\u30D5\u30C8\u30C6\u30F3\u30D7\u30EC\u30FC\u30C8\u3078\u306E\u5B9A\u7FA9 [' + arg1 + '] \u306E\u30B9\u30CA\u30C3\u30D7\u30B7\u30E7\u30C3\u30C8 [' + arg0 + '] \u3092\u30D4\u30F3\u7559\u3081';
}

function $view_groupCreateWizard_createSuccessful_full(arg0, arg1, arg2){
  return '[' + arg2 + '] \u30E1\u30F3\u30D0\u30FC\u30EA\u30BD\u30FC\u30B9\u304C\u542B\u307E\u308C\u308B\u540D\u524D [' + arg1 + '] \u3092\u6301\u3064\u65B0\u3057\u3044 [' + arg0 + '] \u30EA\u30BD\u30FC\u30B9\u30B0\u30EB\u30FC\u30D7\u304C\u4F5C\u6210\u3055\u308C\u307E\u3057\u305F\u3002';
}

function $view_group_pluginConfig_edit_saveFailure(arg0, arg1){
  return '\u30B0\u30EB\u30FC\u30D7\u540D [' + arg1 + '] \u3068\u4E92\u63DB\u6027\u306E\u3042\u308B [' + arg0 + '] \u306E\u305F\u3081\u306E\u30B0\u30EB\u30FC\u30D7\u8A2D\u5B9A\u66F4\u65B0\u306E\u958B\u59CB\u306B\u5931\u6557\u3057\u307E\u3057\u305F';
}

function $view_group_pluginConfig_edit_saveInitiated_full(arg0, arg1){
  return '\u30B0\u30EB\u30FC\u30D7\u63A5\u7D9A\u8A2D\u5B9A\u306E\u66F4\u65B0\u304C\u3001[' + arg1 + '] \u3068\u3044\u3046\u540D\u524D\u306E [' + arg0 + '] \u3068\u4E92\u63DB\u6027\u306E\u3042\u308B\u30B0\u30EB\u30FC\u30D7\u306B\u5BFE\u3057\u3066\u958B\u59CB\u3055\u308C\u307E\u3057\u305F';
}

function $view_group_resConfig_edit_saveFailure(arg0, arg1){
  return '[' + arg1 + '] \u3068\u3044\u3046\u540D\u524D\u306E\u4E92\u63DB\u6027\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u306B\u5BFE\u3057\u3001\u30B0\u30EB\u30FC\u30D7\u8A2D\u5B9A\u306E\u66F4\u65B0\u3092\u958B\u59CB\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F';
}

function $view_group_resConfig_edit_saveInitiated_full(arg0, arg1){
  return '[' + arg1 + '] \u3068\u3044\u3046\u540D\u524D\u306E\u4E92\u63DB\u6027\u30B0\u30EB\u30FC\u30D7\u306E [' + arg0 + '] \u306B\u5BFE\u3057\u3001\u30B0\u30EB\u30FC\u30D7\u8A2D\u5B9A\u306E\u66F4\u65B0\u304C\u958B\u59CB\u3055\u308C\u307E\u3057\u305F';
}

function $view_inventory_eventHistory_deleteSuccessful(arg0, arg1){
  return '[' + arg1 + '] \u306E\u305F\u3081\u306E [' + arg0 + '] \u30A4\u30D9\u30F3\u30C8\u306E\u524A\u9664\u306B\u6210\u529F\u3057\u307E\u3057\u305F';
}

function $view_inventory_eventHistory_purgeSuccessful(arg0, arg1){
  return '[' + arg1 + '] \u306E\u305F\u3081\u306E [' + arg0 + '] \u30A4\u30D9\u30F3\u30C8\u306E\u9664\u53BB\u306B\u6210\u529F\u3057\u307E\u3057\u305F';
}

function $view_leftNav_unknownPage(arg0, arg1){
  return '\u30BB\u30AF\u30B7\u30E7\u30F3 [' + arg1 + '] \u306E\u672A\u77E5\u306E\u30DA\u30FC\u30B8\u540D [' + arg0 + '] - URL\u306F\u4E0D\u6B63\u3067\u3059';
}

function $view_resource_monitor_availability_currentStatus_value(arg0, arg1){
  return '\u3053\u306E\u30EA\u30BD\u30FC\u30B9\u306F ' + arg1 + ' \u304B\u3089 ' + arg0 + ' \u306E\u307E\u307E\u3067\u3059';
}

function $view_titleBar_group_failInfo(arg0, arg1){
  return 'ID [' + arg1 + '] \u3092\u6301\u3064\u30B0\u30EB\u30FC\u30D7 [' + arg0 + '] \u306B\u95A2\u3059\u308B\u4E00\u822C\u60C5\u5831\u306E\u53D6\u5F97\u306B\u5931\u6557\u3057\u307E\u3057\u305F';
}

function $clinit_PermissionsLoader(){
  $clinit_PermissionsLoader = nullMethod;
  $clinit_CoreGUI();
}

function $loadBundleGroupPermissions(bundleGroupId, callback){
  $getBundleGroupPermissions(dynamicCast(secure(getInstance_35(), -1), Q$AuthorizationGWTServiceAsync), bundleGroupId, new PermissionsLoader$5_0(callback, bundleGroupId));
}

function $loadBundlePermissions(bundleId, callback){
  $getBundlePermissions(dynamicCast(secure(getInstance_35(), -1), Q$AuthorizationGWTServiceAsync), bundleId, new PermissionsLoader$4_0(callback, bundleId));
}

function $loadExplicitGlobalPermissions(callback){
  $getExplicitGlobalPermissions(dynamicCast(secure(getInstance_35(), -1), Q$AuthorizationGWTServiceAsync), new PermissionsLoader$1_0(callback));
}

function $processFailure(msg, caught){
  var options, severity;
  options = of(($clinit_Message$Option() , BackgroundJobResult));
  severity = ($clinit_Message$Severity() , Error_2);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_5(msg, caught, severity, options));
}

function $onSuccess_2(this$static, result){
  this$static.val$callback.onPermissionsLoaded(result);
}

function PermissionsLoader$1_0(val$callback){
  this.val$callback = val$callback;
}

defineSeed(1608, 1, makeCastMap([Q$AsyncCallback]), PermissionsLoader$1_0);
_.onFailure = function onFailure_3(caught){
  $processFailure(($clinit_PermissionsLoader() , '\u30B0\u30ED\u30FC\u30D0\u30EB\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F - \u4F55\u3082\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093\u3067\u3057\u305F'), caught);
  this.val$callback.onPermissionsLoaded(null);
}
;
_.onSuccess_0 = function onSuccess_3(result){
  $onSuccess_2(this, dynamicCast(result, Q$Set));
}
;
_.val$callback = null;
function $onSuccess_3(this$static, result){
  $onPermissionsLoaded_0(this$static.val$callback, result);
}

function PermissionsLoader$4_0(val$callback, val$bundleId){
  this.val$callback = val$callback;
  this.val$bundleId = val$bundleId;
}

defineSeed(1609, 1, makeCastMap([Q$AsyncCallback]), PermissionsLoader$4_0);
_.onFailure = function onFailure_4(caught){
  $processFailure('id \u304C [' + ($clinit_PermissionsLoader() , '' + this.val$bundleId) + '] \u306E\u30D0\u30F3\u30C9\u30EB\u306B\u5BFE\u3059\u308B\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F - \u4F55\u3082\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093\u3067\u3057\u305F', caught);
  $onPermissionsLoaded_0(this.val$callback, null);
}
;
_.onSuccess_0 = function onSuccess_4(result){
  $onSuccess_3(this, dynamicCast(result, Q$Set));
}
;
_.val$bundleId = 0;
_.val$callback = null;
function $onSuccess_4(this$static, result){
  $onPermissionsLoaded(this$static.val$callback, result);
}

function PermissionsLoader$5_0(val$callback, val$bundleGroupId){
  this.val$callback = val$callback;
  this.val$bundleGroupId = val$bundleGroupId;
}

defineSeed(1610, 1, makeCastMap([Q$AsyncCallback]), PermissionsLoader$5_0);
_.onFailure = function onFailure_5(caught){
  $processFailure('id \u304C [' + ($clinit_PermissionsLoader() , '' + this.val$bundleGroupId) + '] \u306E\u30D0\u30F3\u30C9\u30EB\u306B\u5BFE\u3059\u308B\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F - \u4F55\u3082\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093\u3067\u3057\u305F', caught);
  $onPermissionsLoaded(this.val$callback, null);
}
;
_.onSuccess_0 = function onSuccess_5(result){
  $onSuccess_4(this, dynamicCast(result, Q$Set));
}
;
_.val$bundleGroupId = 0;
_.val$callback = null;
function ViewChangedException_1(obsoleteView){
  $fillInStackTrace(this);
  this.obsoleteView = obsoleteView != null?obsoleteView:'?';
}

defineSeed(1628, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable, Q$ViewChangedException]), ViewChangedException_1);
function $getCurrent(this$static){
  return this$static.index_0 >= this$static.viewPath.size_0?null:dynamicCast($get_0(this$static.viewPath, this$static.index_0), Q$ViewId);
}

function $getCurrentAsInt(this$static){
  return __parseAndValidateInt((this$static.index_0 >= this$static.viewPath.size_0?null:dynamicCast($get_0(this$static.viewPath, this$static.index_0), Q$ViewId)).path);
}

function $getParentViewPath(this$static){
  return $getPathToIndex(this$static, this$static.index_0 - 1);
}

function $getPathToCurrent(this$static){
  return $getPathToIndex(this$static, this$static.index_0);
}

function $getPathToIndex(this$static, endIndex){
  var i, path;
  path = '';
  for (i = 0; i < endIndex; ++i) {
    i > 0 && (path += '/');
    path += dynamicCast($get_0(this$static.viewPath, i), Q$ViewId).path;
  }
  return path;
}

function $getViewForIndex(this$static, index){
  return dynamicCast($get_0(this$static.viewPath, index), Q$ViewId);
}

function $isCurrent(this$static, providedViewId){
  return !(this$static.viewPath.size_0 <= this$static.index_0 || !providedViewId || !$equals_44(this$static.index_0 >= this$static.viewPath.size_0?null:dynamicCast($get_0(this$static.viewPath, this$static.index_0), Q$ViewId), providedViewId));
}

function $isEnd(this$static){
  return this$static.viewPath.size_0 <= this$static.index_0;
}

function $isNext(this$static, providedViewId){
  return this$static.index_0 + 1 < this$static.viewPath.size_0 && !!providedViewId && $equals_44(dynamicCast($get_0(this$static.viewPath, this$static.index_0 + 1), Q$ViewId), providedViewId);
}

function $isNextEnd(this$static){
  return this$static.viewPath.size_0 <= this$static.index_0 + 1;
}

function $addSection_0(this$static, treeGrid){
  var section, sectionName, sectionTitle;
  sectionName = $getAttributeAsString(getOrCreateRef_15($getAttributeAsJavaScriptObject_2(getOrCreateRef_14($getAttributeAsJavaScriptObject_1(treeGrid, 'data')))), 'name');
  sectionTitle = $getAttributeAsString(getOrCreateRef_15($getAttributeAsJavaScriptObject_2(getOrCreateRef_14($getAttributeAsJavaScriptObject_1(treeGrid, 'data')))), 'title');
  $put_1(this$static.treeGrids, sectionName, treeGrid);
  $addCellClickHandler(treeGrid, new AbstractSectionedLeftNavigationView$2_0(this$static, treeGrid, sectionName));
  section = new SectionStackSection_1(sectionTitle);
  $setAttribute_8(section, 'resizeable', ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setExpanded(section, TRUE);
  $addItemJS(section, $getOrCreateJsObj_0(treeGrid));
  $addSection(this$static.sectionStack, section);
}

function $buildTreeGridForSection(navigationSection){
  var i, item, navigationItems, navigationItemsSize, rootNode, tree, treeGrid, treeNode, treeNodes;
  treeGrid = new TreeGrid_0;
  $setLeaveScrollbarGap(treeGrid, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setShowHeader_0(treeGrid, FALSE);
  $setAttribute_24(treeGrid, 'selectionType', ($clinit_SelectionStyle() , SINGLE).value_0, true);
  $isCreated_1(treeGrid)?$setProperty_1(treeGrid, 'height', 50):(treeGrid.config_0['height'] = 50 , undefined);
  $isCreated_1(treeGrid)?$setProperty_4(treeGrid, 'styleName', 'noOutline'):(treeGrid.config_0['styleName'] = 'noOutline' , undefined);
  $setAttribute_24(treeGrid, 'autoFitData', ($clinit_Autofit() , VERTICAL).value_0, true);
  navigationItems = navigationSection.navigationItems;
  treeNodes = initDim(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, navigationItems.array.length, 0);
  for (i = 0 , navigationItemsSize = navigationItems.array.length; i < navigationItemsSize; ++i) {
    item = dynamicCast((checkIndex(i, navigationItems.array.length) , navigationItems.array[i]), Q$NavigationItem);
    treeNode = new EnhancedTreeNode_1(item.viewName.name_0, item.viewName.title_0, initValues(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, []));
    $setAttribute_13(treeNode, 'icon', item.icon_0);
    $setAttribute_8(treeNode, 'enabled', item.enabled?TRUE:FALSE);
    setCheck(treeNodes, i, treeNode);
  }
  rootNode = new EnhancedTreeNode_1(navigationSection.viewName.name_0, navigationSection.viewName.title_0, treeNodes);
  tree = new Tree_0;
  $setAttribute(tree, rootNode.jsObj);
  $setAttribute_20(treeGrid, 'data', !tree?null:$getOrCreateJsObj(tree), true);
  return treeGrid;
}

function $decorateWithTitleBar(viewName, pageBody){
  var iconPath, vLayout;
  vLayout = new EnhancedVLayout_0;
  $isCreated_1(vLayout)?$setProperty_4(vLayout, 'width', '100%'):(vLayout.config_0['width'] = '100%' , undefined);
  $isCreated_1(vLayout)?$setProperty_4(vLayout, 'height', '100%'):(vLayout.config_0['height'] = '100%' , undefined);
  iconPath = viewName.icon_0.icon24x24Path != null?viewName.icon_0.icon24x24Path:viewName.icon_0.icon16x16Path;
  $addMember(vLayout, new TitleBar_1(viewName.title_0, iconPath));
  $addMember(vLayout, pageBody);
  return vLayout;
}

function $destroyCurrentContent(this$static){
  var children;
  if (this$static.contentCanvas) {
    while ((children = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static.contentCanvas, 'children'))).length > 0) {
      children[0].destroy_0();
    }
  }
}

function $initSectionPageTreeGrids(this$static){
  var name_0, name$iterator, treeGrid;
  for (name$iterator = $iterator($keySet(this$static.treeGrids)); name$iterator.val$outerIter.hasNext();) {
    name_0 = dynamicCast($next_1(name$iterator), Q$String);
    treeGrid = dynamicCast($get_4(this$static.treeGrids, name_0), Q$TreeGrid);
    $deselectAllRecords(treeGrid);
    this$static.currentSectionViewId = null;
    this$static.currentPageViewId = null;
  }
}

function $onInit_0(this$static){
  $onInit(this$static);
  $onInit_Layout(this$static);
  $isCreated_1(this$static)?$setProperty_4(this$static, 'width', '100%'):(this$static.config_0['width'] = '100%' , undefined);
  $isCreated_1(this$static)?$setProperty_4(this$static, 'height', '100%'):(this$static.config_0['height'] = '100%' , undefined);
  this$static.contentCanvas = new Canvas_1;
  $setWidth_0(this$static.contentCanvas, '*');
  $setAttribute_24(this$static.contentCanvas, 'height', '100%', true);
  this$static.sectionStack = new SectionStack_0;
  $setShowResizeBar(this$static.sectionStack, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setAttribute_22(this$static.sectionStack, 'canResizeSections', TRUE, false);
  $setAttribute_24(this$static.sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $setWidth(this$static.sectionStack, 250);
  $setAttribute_24(this$static.sectionStack, 'height', '100%', true);
  $loadExplicitGlobalPermissions(($clinit_PermissionsLoader() , new AbstractSectionedLeftNavigationView$1_0(this$static)));
}

function $renderContentView(this$static, viewPath){
  var content_0, item, pageName, section, sectionName, viewFactory;
  this$static.currentSectionViewId = viewPath.index_0 >= viewPath.viewPath.size_0?null:dynamicCast($get_0(viewPath.viewPath, viewPath.index_0), Q$ViewId);
  this$static.currentPageViewId = dynamicCast($get_0(viewPath.viewPath, viewPath.index_0 + 1), Q$ViewId);
  sectionName = this$static.currentSectionViewId.path;
  pageName = this$static.currentPageViewId.path;
  section = dynamicCast(this$static.sectionsByName.get_2(sectionName), Q$NavigationSection);
  if (!section) {
    throw new IllegalStateException_1('Invalid section: ' + sectionName);
  }
  item = dynamicCast($get_4(section.navigationItemsByName, pageName), Q$NavigationItem);
  if (!item) {
    throw new IllegalStateException_1('Invalid page: ' + pageName);
  }
  item.refreshRequired && (this$static.currentPageViewId = null);
  $selectSectionPageTreeGridNode(this$static, sectionName, pageName);
  viewFactory = item.viewFactory;
  if (viewFactory) {
    $destroyCurrentContent(this$static);
    content_0 = viewFactory.createView();
    if (content_0) {
      $setContent(this$static, content_0);
      instanceOf(content_0, Q$BookmarkableView) && dynamicCast(content_0, Q$BookmarkableView).renderView($next_6((++viewPath.index_0 , viewPath)));
    }
  }
}

function $selectSectionPageTreeGridNode(this$static, sectionName, pageName){
  var name_0, name$iterator, node, tree, treeGrid, self_0, nodeJS, self_1;
  for (name$iterator = $iterator($keySet(this$static.treeGrids)); name$iterator.val$outerIter.hasNext();) {
    name_0 = dynamicCast($next_1(name$iterator), Q$String);
    treeGrid = dynamicCast($get_4(this$static.treeGrids, name_0), Q$TreeGrid);
    if ($equals_6(name_0, sectionName)) {
      tree = getOrCreateRef_14($getAttributeAsJavaScriptObject_1(treeGrid, 'data'));
      node = (self_0 = tree.getOrCreateJsObj() , nodeJS = self_0.find(sectionName + '/' + pageName) , nodeJS == null?null:getOrCreateRef_15(nodeJS));
      node?(self_1 = treeGrid.getOrCreateJsObj() , self_1.selectSingleRecord(node.getJsObj()) , undefined):$handleError_0(($clinit_CoreGUI() , $view_leftNav_unknownPage(($clinit_Enhanced() , pageName), sectionName)), null);
    }
     else {
      $deselectAllRecords(treeGrid);
    }
  }
}

function $setContent(this$static, newContent){
  var decoratedContent;
  this$static.currentContent = newContent;
  if (instanceOf(newContent, Q$HasViewName)) {
    decoratedContent = $decorateWithTitleBar(dynamicCast(newContent, Q$HasViewName).getViewName(), newContent);
    $addChild(this$static.contentCanvas, decoratedContent);
  }
   else {
    $addChild(this$static.contentCanvas, newContent);
  }
  this$static.contentCanvas.markForRedraw_0();
}

function AbstractSectionedLeftNavigationView_0(viewId){
  $clinit_BaseWidget();
  EnhancedHLayout_0.call(this);
  this.treeGrids = new LinkedHashMap_0;
  this.globalPermissions_0 = noneOf(Lorg_rhq_core_domain_authz_Permission_2_classLit);
  this.viewId = viewId;
}

defineSeed(1633, 1589, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$Enhanced, Q$EnhancedHLayout]));
_.isInitialized_0 = function isInitialized(){
  return this.initialized;
}
;
_.onInit = function onInit_7(){
  $onInit_0(this);
}
;
_.renderView = function renderView_0(viewPath){
  if (!$isCurrent(viewPath, this.currentSectionViewId) || !$isNext(viewPath, this.currentPageViewId)) {
    if (viewPath.viewPath.size_0 <= viewPath.index_0) {
      $destroyCurrentContent(this);
      $setContent(this, this.defaultView());
      $initSectionPageTreeGrids(this);
    }
     else {
      $renderContentView(this, viewPath);
    }
  }
   else {
    if (instanceOf(this.currentContent, Q$BookmarkableView)) {
      dynamicCast(this.currentContent, Q$BookmarkableView).renderView($next_6((++viewPath.index_0 , viewPath)));
    }
     else if (instanceOf(this.currentContent, Q$RefreshableView) && $isDrawn(this.currentContent).value_0) {
      debug('Refreshing data for [' + this.currentContent.___clazz$.typeName + ']...');
      dynamicCast(this.currentContent, Q$RefreshableView).refresh_0();
    }
  }
}
;
_.contentCanvas = null;
_.currentContent = null;
_.currentPageViewId = null;
_.currentSectionViewId = null;
_.initialized = false;
_.sectionStack = null;
_.sectionsByName = null;
_.viewId = null;
function AdministrationView_0(){
  $clinit_AdministrationView();
  AbstractSectionedLeftNavigationView_0.call(this, VIEW_ID.name_0);
}

defineSeed(1632, 1633, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$Enhanced, Q$EnhancedHLayout]), AdministrationView_0);
_.defaultView = function defaultView(){
  var vLayout, titleBar, productInfo, label;
  return vLayout = new EnhancedVLayout_0 , $isCreated_1(vLayout)?$setProperty_4(vLayout, 'width', '100%'):(vLayout.config_0['width'] = '100%' , undefined) , titleBar = new TitleBar_1(($clinit_Enhanced() , '\u7BA1\u7406'), ($clinit_IconEnum() , ADMIN).icon24x24Path) , $addMember(vLayout, titleBar) , productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo , label = new Label_4($view_admin_landing(productInfo.shortName)) , $setPadding(label, valueOf_49(10)) , $addMember(vLayout, label) , vLayout;
}
;
_.getNavigationSections = function getNavigationSections(){
  var configurationSection, contentSection, sections, securitySection, topologySection, usersItem, rolesItem, productInfo, isRHQ, remoteAgentInstallItem, serversItem, storageNodesItem, agentsItem, affinityGroupsItem, partitionEventsItem, navigationItems, systemSettingsItem, alertTemplatesItem, driftTemplatesItem, metricTemplatesItem, ignoreResourceTypesItem, downloadsItem, agentPluginsItem, serverPluginsItem, contentSourcesItem, reposItem;
  sections = new ArrayList_0;
  securitySection = (usersItem = new NavigationItem_2(($clinit_UsersView() , VIEW_ID_15), new AdministrationView$1_0(this)) , rolesItem = new NavigationItem_2(($clinit_RolesView() , VIEW_ID_5), new AdministrationView$2_0(this)) , new NavigationSection_0(SECTION_SECURITY_VIEW_ID, initValues(_3Lorg_rhq_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [usersItem, rolesItem])));
  sections.add_0(securitySection);
  topologySection = (productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo , isRHQ = !!productInfo && $equals_6('RHQ', productInfo.shortName) , remoteAgentInstallItem = new NavigationItem_3(($clinit_RemoteAgentInstallView() , VIEW_ID_4), new AdministrationView$3_0, this.globalPermissions_0.contains(($clinit_Permission() , MANAGE_SETTINGS))) , serversItem = new NavigationItem_3(($clinit_ServerTableView() , VIEW_ID_14), new AdministrationView$4_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , storageNodesItem = new NavigationItem_3(($clinit_StorageNodeAdminView() , VIEW_ID_6), new AdministrationView$5_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , agentsItem = new NavigationItem_3(($clinit_AgentTableView() , VIEW_ID_12), new AdministrationView$6_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , affinityGroupsItem = new NavigationItem_3(($clinit_AffinityGroupTableView() , VIEW_ID_11), new AdministrationView$7_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , partitionEventsItem = new NavigationItem_3(($clinit_PartitionEventTableView() , VIEW_ID_13), new AdministrationView$8_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , navigationItems = new ArrayList_2(new Arrays$ArrayList_0(initValues(_3Lorg_rhq_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [serversItem, storageNodesItem, agentsItem, affinityGroupsItem, partitionEventsItem]))) , isRHQ && navigationItems.add_0(remoteAgentInstallItem) , new NavigationSection_0(SECTION_TOPOLOGY_VIEW_ID, dynamicCast($toArray_1(navigationItems, initValues(_3Lorg_rhq_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [])), Q$NavigationItem_$1)));
  sections.add_0(topologySection);
  configurationSection = (systemSettingsItem = new NavigationItem_3(($clinit_SystemSettingsView() , VIEW_ID_3), new AdministrationView$9_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , systemSettingsItem.refreshRequired = true , alertTemplatesItem = new NavigationItem_2(($clinit_AlertDefinitionTemplateTypeView() , VIEW_ID_7), new AdministrationView$10_0) , alertTemplatesItem.refreshRequired = true , driftTemplatesItem = new NavigationItem_2(($clinit_DriftDefinitionTemplateTypeView() , VIEW_ID_8), new AdministrationView$11_0) , driftTemplatesItem.refreshRequired = true , metricTemplatesItem = new NavigationItem_2(($clinit_MetricTemplateTypeView() , VIEW_ID_10), new AdministrationView$12_0) , metricTemplatesItem.refreshRequired = true , ignoreResourceTypesItem = new NavigationItem_2(($clinit_IgnoreResourceTypesView() , VIEW_ID_9), new AdministrationView$13_0) , ignoreResourceTypesItem.refreshRequired = true , downloadsItem = new NavigationItem_2(($clinit_DownloadsView() , VIEW_ID_1), new AdministrationView$14_0) , agentPluginsItem = new NavigationItem_3(($clinit_AgentPluginTableView() , VIEW_ID_0), new AdministrationView$15_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , serverPluginsItem = new NavigationItem_3(($clinit_ServerPluginTableView() , VIEW_ID_2), new AdministrationView$16_0, this.globalPermissions_0.contains(MANAGE_SETTINGS)) , new NavigationSection_0(SECTION_CONFIGURATION_VIEW_ID, initValues(_3Lorg_rhq_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [systemSettingsItem, alertTemplatesItem, driftTemplatesItem, metricTemplatesItem, ignoreResourceTypesItem, downloadsItem, agentPluginsItem, serverPluginsItem])));
  sections.add_0(configurationSection);
  contentSection = (contentSourcesItem = new NavigationItem_3(PAGE_CONTENT_SOURCES_VIEW_ID, new AdministrationView$17_0, this.globalPermissions_0.contains(MANAGE_REPOSITORIES)) , reposItem = new NavigationItem_2(PAGE_REPOS_VIEW_ID, new AdministrationView$18_0) , new NavigationSection_0(SECTION_CONTENT_VIEW_ID, initValues(_3Lorg_rhq_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [contentSourcesItem, reposItem])));
  sections.add_0(contentSection);
  return sections;
}
;
function AdministrationView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1634, 1, {}, AdministrationView$1_0);
_.createView = function createView(){
  return new UsersView_0(this.this$0.globalPermissions_0.contains(($clinit_Permission() , MANAGE_SECURITY)));
}
;
_.this$0 = null;
function AdministrationView$10_0(){
}

defineSeed(1635, 1, {}, AdministrationView$10_0);
_.createView = function createView_0(){
  return new AlertDefinitionTemplateTypeView_0;
}
;
function AdministrationView$11_0(){
}

defineSeed(1636, 1, {}, AdministrationView$11_0);
_.createView = function createView_1(){
  return new DriftDefinitionTemplateTypeView_0;
}
;
function AdministrationView$12_0(){
}

defineSeed(1637, 1, {}, AdministrationView$12_0);
_.createView = function createView_2(){
  return new MetricTemplateTypeView_0;
}
;
function AdministrationView$13_0(){
}

defineSeed(1638, 1, {}, AdministrationView$13_0);
_.createView = function createView_3(){
  return new IgnoreResourceTypesView_0;
}
;
function AdministrationView$14_0(){
}

defineSeed(1639, 1, {}, AdministrationView$14_0);
_.createView = function createView_4(){
  return new DownloadsView_0;
}
;
function AdministrationView$15_0(){
}

defineSeed(1640, 1, {}, AdministrationView$15_0);
_.createView = function createView_5(){
  return new AgentPluginTableView_0;
}
;
function AdministrationView$16_0(){
}

defineSeed(1641, 1, {}, AdministrationView$16_0);
_.createView = function createView_6(){
  return new ServerPluginTableView_0;
}
;
function AdministrationView$17_0(){
}

defineSeed(1642, 1, {}, AdministrationView$17_0);
_.createView = function createView_7(){
  return new FullHTMLPane_0('/portal/rhq/content/listContentProviders-plain.xhtml');
}
;
function AdministrationView$18_0(){
}

defineSeed(1643, 1, {}, AdministrationView$18_0);
_.createView = function createView_8(){
  return new FullHTMLPane_0('/portal/rhq/content/listRepos-plain.xhtml');
}
;
function AdministrationView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1644, 1, {}, AdministrationView$2_0);
_.createView = function createView_9(){
  return new RolesView_0(this.this$0.globalPermissions_0.contains(($clinit_Permission() , MANAGE_SECURITY)));
}
;
_.this$0 = null;
function AdministrationView$3_0(){
}

defineSeed(1645, 1, {}, AdministrationView$3_0);
_.createView = function createView_10(){
  return new RemoteAgentInstallView_0;
}
;
function AdministrationView$4_0(){
}

defineSeed(1646, 1, {}, AdministrationView$4_0);
_.createView = function createView_11(){
  return new ServerTableView_0(null, false);
}
;
function AdministrationView$5_0(){
}

defineSeed(1647, 1, {}, AdministrationView$5_0);
_.createView = function createView_12(){
  return new StorageNodeAdminView_0;
}
;
function AdministrationView$6_0(){
}

defineSeed(1648, 1, {}, AdministrationView$6_0);
_.createView = function createView_13(){
  return new AgentTableView_0(null, false);
}
;
function AdministrationView$7_0(){
}

defineSeed(1649, 1, {}, AdministrationView$7_0);
_.createView = function createView_14(){
  return new AffinityGroupTableView_0;
}
;
function AdministrationView$8_0(){
}

defineSeed(1650, 1, {}, AdministrationView$8_0);
_.createView = function createView_15(){
  return new PartitionEventTableView_0(($clinit_PartitionEventTableView() , VIEW_ID_13).title_0);
}
;
function AdministrationView$9_0(){
}

defineSeed(1651, 1, {}, AdministrationView$9_0);
_.createView = function createView_16(){
  return new SystemSettingsView_0;
}
;
function EnhancedVLayout_1(membersMargin){
  $clinit_BaseWidget();
  VLayout_1.call(this, membersMargin);
}

defineSeed(1653, 459, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced, Q$EnhancedVLayout]), EnhancedVLayout_1);
function $prepareDetailsSection(stack, plugin){
  var ampsItem, descItem, displayNameItem, enabledItem, form, img, kindItem, md5Item, mtimeItem, nameItem, pathItem, section, versionItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  $setWrapItemTitles(form, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $isCreated_1(form)?$setProperty_1(form, 'numCols', 4):(form.config_0['numCols'] = 4 , undefined);
  nameItem = new StaticTextItem_2('name', ($clinit_Enhanced() , '\u540D\u524D'));
  $setValue_7(nameItem, plugin.name_0);
  displayNameItem = new StaticTextItem_2('displayName', '\u8868\u793A\u540D');
  $setValue_7(displayNameItem, plugin.displayName);
  versionItem = new StaticTextItem_2('version', '\u30D0\u30FC\u30B8\u30E7\u30F3');
  $setValue_7(versionItem, plugin.version_0);
  md5Item = new StaticTextItem_2('MD5', 'MD5');
  $setValue_7(md5Item, plugin.md5);
  pathItem = new StaticTextItem_2('path', '\u30D1\u30B9');
  $setValue_7(pathItem, plugin.path);
  ampsItem = new StaticTextItem_2('ampsVersion', 'AMPS \u30D0\u30FC\u30B8\u30E7\u30F3');
  $setValue_7(ampsItem, plugin.ampsVersion);
  descItem = new StaticTextItem_2('desc', '\u8AAC\u660E');
  $setValue_7(descItem, plugin.description);
  mtimeItem = new StaticTextItem_2('mtime', '\u6700\u7D42\u66F4\u65B0');
  $setValue_7(mtimeItem, format_41(valueOf_50(plugin.mtime), ($clinit_TimestampCellFormatter() , DATE_TIME_FORMAT_MEDIUM)));
  kindItem = new StaticTextItem_2('kind', '\u7A2E\u985E');
  switch (plugin.deployment.ordinal) {
    case 0:
      $setValue_7(kindItem, '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8');
      break;
    case 1:
      $setValue_7(kindItem, '\u30B5\u30FC\u30D0\u30FC');
  }
  enabledItem = new CanvasItem_2('enabled', '\u6709\u52B9?');
  img = new Img_2(getAvailabilityIcon(plugin.enabled?TRUE:FALSE), 16, 16);
  $setAttribute_28(enabledItem, 'canvas', !img?null:$getOrCreateJsObj_0(img));
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [displayNameItem, nameItem, versionItem, ampsItem, md5Item, kindItem, descItem, pathItem, mtimeItem, enabledItem]));
  section = new SectionStackSection_1('\u8A73\u7D30');
  $setExpanded(section, TRUE);
  $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $addSection(stack, section);
  return;
}

function $prepareHelpSection(stack, plugin){
  var help, section;
  if (plugin.help != null && plugin.help.length > 0) {
    section = new SectionStackSection_1(($clinit_Enhanced() , '\u30D8\u30EB\u30D7'));
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    help = new Label_4(plugin.help);
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [help]));
    $addSection(stack, section);
  }
  return;
}

function AgentPluginDetailView_0(pluginId){
  $clinit_BaseWidget();
  EnhancedVLayout_0.call(this);
  this.pluginManager = dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync);
  this.pluginId = pluginId;
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
}

defineSeed(1652, 1653, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced, Q$EnhancedVLayout]), AgentPluginDetailView_0);
_.onDraw_0 = function onDraw_2(){
  var sectionStack;
  sectionStack = new SectionStack_0;
  $setAttribute_24(sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $isCreated_1(sectionStack)?$setProperty_4(sectionStack, 'width', '100%'):(sectionStack.config_0['width'] = '100%' , undefined);
  $isCreated_1(sectionStack)?$setProperty_4(sectionStack, 'height', '100%'):(sectionStack.config_0['height'] = '100%' , undefined);
  $setAttribute_24(sectionStack, 'overflow', ($clinit_Overflow() , AUTO_0).value_0, false);
  $getAgentPlugin(this.pluginManager, this.pluginId, new AgentPluginDetailView$1_0(sectionStack));
  $addMember(this, sectionStack);
}
;
_.pluginId = 0;
function $onSuccess_12(this$static, plugin){
  $prepareDetailsSection(this$static.val$sectionStack, plugin);
  $prepareHelpSection(this$static.val$sectionStack, plugin);
}

function AgentPluginDetailView$1_0(val$sectionStack){
  this.val$sectionStack = val$sectionStack;
}

defineSeed(1654, 1, makeCastMap([Q$AsyncCallback]), AgentPluginDetailView$1_0);
_.onFailure = function onFailure_12(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_12(plugin){
  $onSuccess_12(this, dynamicCast(plugin, Q$Plugin));
}
;
_.val$sectionStack = null;
function $addExtraWidget(this$static, widget, aboveFooter){
  aboveFooter?this$static.extraWidgetsAboveFooter.add_0(widget):this$static.extraWidgetsInMainFooter.add_0(widget);
}

function $addTopWidget(this$static, widget){
  this$static.extraWidgetsAtTop.add_0(widget);
}

function $deleteSelectedRecords(this$static){
  var deletedRecordNames, listGrid, selectedRecordCount;
  listGrid = this$static.listGrid;
  selectedRecordCount = $getSelectedRecords(listGrid).length;
  deletedRecordNames = new ArrayList_1(selectedRecordCount);
  $removeSelectedData(listGrid, new Table$8_0(this$static, deletedRecordNames, selectedRecordCount), null);
}

function $getDeletedMessage(numDeleted){
  var num, thing;
  num = '' + numDeleted;
  thing = 1 == numDeleted?($clinit_Enhanced() , '\u9805\u76EE'):($clinit_Enhanced() , '\u9805\u76EE');
  return ($clinit_Enhanced() , num) + ' ' + thing + ' \u304C\u524A\u9664\u3055\u308C\u307E\u3057\u305F\u3002';
}

function $setDataSource(this$static, dataSource){
  this$static.dataSource_1 = dataSource;
}

function $setListGridFields(this$static, forceIdField, fields){
  var dataSourceField, dataSourceFieldName, dataSourceFieldName$iterator, dataSourceFieldNames, dataSourceFieldNamesSet, dataSourceIdField, datasourceFieldTitle, destIndex, hideIdField, listGridField, listGridField$index, listGridField$max, listGridFieldTitle, listGridFieldsMap, listGridIdField, newFields;
  if (!this$static.getDataSource_0()) {
    throw new IllegalStateException_1('setListGridFields() called on ' + this$static.___clazz$.typeName + ', which is not a DataSource-backed Table.');
  }
  dataSourceFieldNames = $getFieldNames(this$static.getDataSource_0(), false);
  dataSourceFieldNamesSet = new LinkedHashSet_0;
  dataSourceFieldNamesSet.addAll(new Arrays$ArrayList_0(dataSourceFieldNames));
  listGridFieldsMap = new LinkedHashMap_0;
  for (listGridField$index = 0 , listGridField$max = fields.length; listGridField$index < listGridField$max; ++listGridField$index) {
    listGridField = fields[listGridField$index];
    $put_1(listGridFieldsMap, getAttribute(listGridField.jsObj, 'name'), listGridField);
  }
  $removeAll_0(dataSourceFieldNamesSet, $keySet(listGridFieldsMap));
  dataSourceIdField = $getField(this$static.getDataSource_0(), 'id');
  hideIdField = ($clinit_CoreGUI() , true) && !forceIdField;
  !!dataSourceIdField && hideIdField && $hideField(this$static.listGrid, 'id');
  listGridIdField = dynamicCast($get_4(listGridFieldsMap, 'id'), Q$ListGridField);
  !!listGridIdField && (listGridIdField.jsObj['showIf'] = hideIdField?'false':'true' , undefined);
  if (dataSourceFieldNamesSet.map_0.size_1() == 0) {
    $setAttribute_25(this$static.listGrid, 'fields', fields, true);
  }
   else {
    newFields = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.length + dataSourceFieldNamesSet.map_0.size_1(), 0);
    destIndex = 0;
    if (dataSourceFieldNamesSet.map_0.containsKey('id')) {
      datasourceFieldTitle = $getAttributeAsString($getField(this$static.getDataSource_0(), 'id'), 'title');
      listGridFieldTitle = datasourceFieldTitle != null?datasourceFieldTitle:($clinit_Enhanced() , 'ID');
      listGridIdField = new ListGridField_4('id', listGridFieldTitle, 55);
      $setAttribute_13(listGridIdField, 'type', ($clinit_ListGridFieldType() , INTEGER_0).value_0);
      $setAttribute_8(listGridIdField, 'canEdit', ($clinit_Boolean() , $clinit_Boolean() , FALSE));
      listGridIdField.jsObj['showIf'] = hideIdField?'false':'true';
      setCheck(newFields, destIndex++, listGridIdField);
      dataSourceFieldNamesSet.map_0.remove_4('id') != null;
    }
    arraycopy(fields, 0, newFields, destIndex, fields.length);
    destIndex += fields.length;
    for (dataSourceFieldName$iterator = $iterator($keySet(dataSourceFieldNamesSet.map_0)); dataSourceFieldName$iterator.val$outerIter.hasNext();) {
      dataSourceFieldName = dynamicCast($next_1(dataSourceFieldName$iterator), Q$String);
      dataSourceField = $getField(this$static.getDataSource_0(), dataSourceFieldName);
      listGridField = new ListGridField_1(getAttribute(dataSourceField.jsObj, 'name'));
      $hideField(this$static.listGrid, dataSourceFieldName);
      listGridField.jsObj['showIf'] = 'false';
      setCheck(newFields, destIndex++, listGridField);
    }
    $setAttribute_25(this$static.listGrid, 'fields', newFields, true);
  }
}

function $setTableActionDisableOverride(this$static, disabled){
  this$static.tableActionDisableOverride = disabled;
  this$static.refreshTableInfo();
}

function $setTitleIcon(this$static, titleIcon){
  this$static.titleIcon = titleIcon;
}

function $setTitleString(this$static, titleString){
  this$static.titleString = titleString;
  !!this$static.titleCanvas && $markForRedraw(this$static.titleCanvas);
}

function $updateTableAction(this$static, title, valueMap, tableAction){
  var info, info$iterator;
  if (title == null) {
    return;
  }
  for (info$iterator = new AbstractList$IteratorImpl_0(this$static.tableActions); info$iterator.i < info$iterator.this$0_0.size_1();) {
    info = dynamicCast($next_0(info$iterator), Q$Table$TableActionInfo);
    if ($equals_6(title, info.title_0)) {
      !!valueMap && (info.valueMap = valueMap);
      !!tableAction && (info.action = tableAction);
      this$static.initialized_0 && this$static.initialized && $drawFooter(this$static);
      break;
    }
  }
}

function Table_1(){
  $clinit_BaseWidget();
  Table_6.call(this, null, null, null, null, true);
}

function Table_2(tableTitle){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, null, null, null, true);
}

function Table_3(tableTitle, criteria){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, criteria, null, null, !criteria);
}

function Table_4(tableTitle, criteria, icon){
  Table_6.call(this, tableTitle, criteria, null, null, !criteria);
  this.titleIcon = icon;
}

function Table_5(tableTitle, criteria, sortSpecifiers, excludedFieldNames){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, criteria, sortSpecifiers, excludedFieldNames, !criteria);
}

function Table_7(tableTitle, autoFetchData){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, null, null, null, autoFetchData);
}

function Table_8(tableTitle, sortSpecifiers){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, null, sortSpecifiers, null, true);
}

defineSeed(1658, 1589, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]), Table_2);
_.getTitleFieldName = function getTitleFieldName(){
  return 'name';
}
;
function $buildDetailsView(this$static){
  var backButton, hlayout, isEditable, verticalSpacer;
  $setAttribute_24(this$static.detailsView_0, 'width', '100%', true);
  $setAttribute_24(this$static.detailsView_0, 'height', '100%', true);
  isEditable = instanceOf(this$static.detailsView_0, Q$DetailsView) && dynamicCast(this$static.detailsView_0, Q$DetailsView).isEditable_0();
  if (!isEditable) {
    backButton = new BackButton_0(($clinit_Enhanced() , '\u30EA\u30B9\u30C8\u3078\u623B\u308B'), this$static.basePath);
    hlayout = new EnhancedHLayout_0;
    $addMember(hlayout, backButton);
    if (this$static.header_0) {
      $setAttribute_24(this$static.header_0, 'width', '100%', true);
      $setAttribute_24(this$static.header_0, 'align', ($clinit_Alignment() , CENTER_0).value_0, true);
      $addMember(hlayout, this$static.header_0);
    }
    $addMember(this$static.detailsHolder, hlayout);
    verticalSpacer = new LayoutSpacer_0;
    $isCreated_1(verticalSpacer)?$setProperty_1(verticalSpacer, 'height', 8):(verticalSpacer.config_0['height'] = 8 , undefined);
    $addMember(this$static.detailsHolder, verticalSpacer);
  }
  $addMember(this$static.detailsHolder, this$static.detailsView_0);
  $animateShow(this$static.detailsHolder, ($clinit_AnimationEffect() , WIPE));
}

function $configureTable(this$static){
  var field, grid;
  if (this$static.isDetailsEnabled()) {
    grid = this$static.listGrid;
    field = grid?$getField_1(grid, this$static.getDetailsLinkColumnName()):null;
    !!field && $setCellFormatter_0(field, this$static.getDetailsLinkColumnCellFormatter());
    $setListGridDoubleClickHandler(this$static, new AbstractTableSection$1_0(this$static));
  }
}

function $isInitialized(this$static){
  return this$static.initialized_0 && this$static.initialized;
}

function $newDetails(this$static){
  $clinit_CoreGUI();
  goToView(this$static.basePath + '/0', null, false);
}

function $onInit_2(this$static){
  $onInit_1(this$static);
  this$static.initialDisplay = true;
  this$static.detailsHolder = new EnhancedVLayout_0;
  $setAttribute_24(this$static.detailsHolder, 'align', ($clinit_VerticalAlignment() , TOP_2).value_0, true);
  $setMargin(this$static.detailsHolder, valueOf_49(4));
  this$static.detailsHolder.hide_0();
  $addMember(this$static, this$static.detailsHolder);
  !!this$static.detailsView_0 && $switchToDetailsView(this$static);
  this$static.initialized = true;
}

function $renderView_0(this$static, viewPath){
  var id;
  this$static.basePath = $getPathToIndex(viewPath, viewPath.index_0);
  if (viewPath.viewPath.size_0 <= viewPath.index_0) {
    $switchToTableView(this$static);
  }
   else {
    id = this$static.convertCurrentViewPathToID((viewPath.index_0 >= viewPath.viewPath.size_0?null:dynamicCast($get_0(viewPath.viewPath, viewPath.index_0), Q$ViewId)).path);
    this$static.detailsView_0 = this$static.getDetailsView(id);
    instanceOf(this$static.detailsView_0, Q$BookmarkableView) && dynamicCast(this$static.detailsView_0, Q$BookmarkableView).renderView(viewPath);
    $switchToDetailsView(this$static);
  }
}

function $switchToDetailsView(this$static){
  var contents;
  contents = this$static.contents_0;
  if (contents) {
    if ($isVisible(contents)) {
      $animateHide_0(contents, ($clinit_AnimationEffect() , WIPE), new AbstractTableSection$3_0(this$static));
    }
     else {
      contents.hide_0();
      destroyMembers(this$static.detailsHolder);
      $buildDetailsView(this$static);
    }
  }
}

function $switchToTableView(this$static){
  var contents;
  contents = this$static.contents_0;
  if (contents) {
    if (this$static.initialDisplay) {
      this$static.initialDisplay = false;
    }
     else {
      debug('Refreshing data for Table [' + this$static.___clazz$.typeName + ']...');
      this$static.refresh_0();
    }
    if (!!this$static.detailsHolder && $isVisible(this$static.detailsHolder)) {
      $animateHide_0(this$static.detailsHolder, ($clinit_AnimationEffect() , WIPE), new AbstractTableSection$4_0(this$static, contents));
    }
     else {
      !!this$static.detailsHolder && destroyMembers(this$static.detailsHolder);
      $animateShow(contents, ($clinit_AnimationEffect() , WIPE));
    }
  }
}

function AbstractTableSection_0(tableTitle, criteria, sortSpecifiers){
  Table_6.call(this, tableTitle, criteria, sortSpecifiers, null, !criteria);
}

defineSeed(1657, 1658, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]));
_.configureTable = function configureTable_0(){
  $configureTable(this);
}
;
_.destroy_0 = function destroy_3(){
  this.initialized = false;
  $destroy_2(this);
}
;
_.getBasePath = function getBasePath(){
  return this.basePath;
}
;
_.getDetailsLinkColumnCellFormatter = function getDetailsLinkColumnCellFormatter(){
  return new AbstractTableSection$2_0(this);
}
;
_.getDetailsLinkColumnName = function getDetailsLinkColumnName(){
  return 'name';
}
;
_.isDetailsEnabled = function isDetailsEnabled(){
  return true;
}
;
_.isInitialized_0 = function isInitialized_1(){
  return this.initialized_0 && this.initialized;
}
;
_.onInit = function onInit_9(){
  $onInit_2(this);
}
;
_.renderView = function renderView_1(viewPath){
  $renderView_0(this, viewPath);
}
;
_.showDetails = function showDetails(record){
  var id;
  if (!record) {
    throw new IllegalArgumentException_1("'record' parameter is null.");
  }
  id = this.getId_0(record);
  this.showDetails_0(id);
}
;
_.basePath = null;
_.detailsHolder = null;
_.detailsView_0 = null;
_.escapeHtmlInDetailsLinkColumn = false;
_.header_0 = null;
_.initialDisplay = false;
_.initialized = false;
function $convertIDToCurrentViewPath(id){
  if (!id) {
    return '0';
  }
  return '' + id.value_0;
}

function $getId(this$static, record){
  var id, msg;
  id = valueOf_49(record?getAttributeAsInt(record.jsObj, 'id').value_0:0);
  if (!id) {
    msg = '\u30C6\u30FC\u30D6\u30EB [' + ($clinit_Enhanced() , $toString_6(this$static.___clazz$)) + '] \u306E\u30EC\u30B3\u30FC\u30C9\u306B id \u5C5E\u6027\u304C\u3042\u308A\u307E\u305B\u3093 - \u3053\u306E\u30D0\u30B0\u3092\u5831\u544A\u3057\u3066\u304F\u3060\u3055\u3044\u3002';
    $handleError_0(($clinit_CoreGUI() , msg), null);
    throw new IllegalStateException_1(msg);
  }
  return id;
}

function $showDetails(this$static, id){
  var msg;
  if (!!id && id.value_0 > 0) {
    $clinit_CoreGUI();
    goToView(this$static.getBasePath() + '/' + id, null, false);
  }
   else {
    msg = '[' + ($clinit_Enhanced() , $toString_6(this$static.___clazz$)) + '] \u306E\u8A73\u7D30\u3092\u8868\u793A\u3067\u304D\u307E\u305B\u3093\u3002\u4E0D\u6B63\u306A id: [' + (!id?'null':'' + id.value_0) + ']\u3002\u3053\u308C\u3092\u30D0\u30B0\u3068\u3057\u3066\u5831\u544A\u3057\u3066\u304F\u3060\u3055\u3044';
    $handleError_0(($clinit_CoreGUI() , msg), null);
    throw new IllegalArgumentException_1(msg);
  }
}

function TableSection_0(tableTitle){
  $clinit_BaseWidget();
  Table_2.call(this, tableTitle);
}

function TableSection_1(tableTitle, criteria){
  $clinit_BaseWidget();
  Table_3.call(this, tableTitle, criteria);
}

function TableSection_2(tableTitle, criteria, sortSpecifiers){
  $clinit_BaseWidget();
  AbstractTableSection_0.call(this, tableTitle, criteria, sortSpecifiers);
}

function TableSection_3(tableTitle, criteria, sortSpecifiers, excludedFieldNames){
  $clinit_BaseWidget();
  Table_5.call(this, tableTitle, criteria, sortSpecifiers, excludedFieldNames);
}

function TableSection_4(tableTitle, sortSpecifiers){
  $clinit_BaseWidget();
  Table_8.call(this, tableTitle, sortSpecifiers);
}

defineSeed(1656, 1657, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]));
_.convertCurrentViewPathToID = function convertCurrentViewPathToID(path){
  return valueOf_49(__parseAndValidateInt(path));
}
;
_.convertIDToCurrentViewPath = function convertIDToCurrentViewPath(id){
  return $convertIDToCurrentViewPath(dynamicCast(id, Q$Integer));
}
;
_.getDetailsView = function getDetailsView(id){
  return this.getDetailsView_0(dynamicCast(id, Q$Integer));
}
;
_.getId_0 = function getId_3(record){
  return $getId(this, record);
}
;
_.showDetails_0 = function showDetails_0(id){
  $showDetails(this, dynamicCast(id, Q$Integer));
}
;
function $clinit_AgentPluginTableView(){
  $clinit_AgentPluginTableView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_0 = new ViewName_2('AgentPlugins', ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3'), ($clinit_IconEnum() , PLUGIN_0));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_0;
}

function $getSelectedIds(selections){
  var i, ids, selection, selection$index, selection$max;
  if (selections == null) {
    return initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, 0, 1);
  }
  ids = initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, selections.length, 1);
  i = 0;
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    ids[i++] = getAttributeAsInt(selection.jsObj, 'id').value_0;
  }
  return ids;
}

function $getSelectedNames(selections){
  var ids, selection, selection$index, selection$max;
  if (selections == null) {
    return new ArrayList_1(0);
  }
  ids = new ArrayList_1(selections.length);
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    ids.add_0(getAttribute(selection.jsObj, 'name'));
  }
  return ids;
}

function AgentPluginTableView_0(){
  $clinit_AgentPluginTableView();
  TableSection_0.call(this, null);
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setDataSource(this, new AgentPluginTableView$AgentPluginDataSource_0(this));
}

defineSeed(1655, 1656, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]), AgentPluginTableView_0);
_.configureTable = function configureTable_1(){
  var fields, listGrid, pluginUploadForm, scanForUpdatesButton, showDeletedButton;
  fields = $getListGridFields(dynamicCast(this.dataSource_1, Q$AgentPluginTableView$AgentPluginDataSource));
  listGrid = this.listGrid;
  $setFields_1(listGrid, dynamicCast($toArray_1(fields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.size_0, 0)), Q$ListGridField_$1));
  $sort(listGrid, 'name', ($clinit_SortDirection() , ASCENDING));
  $addTableAction(this, ($clinit_Enhanced() , '\u6709\u52B9'), '\u3088\u308D\u3057\u3044\u3067\u3059\u304B?', null, new AgentPluginTableView$1_0(this, this, ($clinit_TableActionEnablement() , ANY_1), initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [($clinit_Permission() , MANAGE_SETTINGS)])));
  $addTableAction(this, '\u7121\u52B9', null, null, new AgentPluginTableView$2_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, '\u524A\u9664', null, null, new AgentPluginTableView$3_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, '\u30D1\u30FC\u30B8', '\u3088\u308D\u3057\u3044\u3067\u3059\u304B?', null, new AgentPluginTableView$4_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  scanForUpdatesButton = new EnhancedIButton_1('\u66F4\u65B0\u306E\u30B9\u30AD\u30E3\u30F3');
  $addClickHandler(scanForUpdatesButton, new AgentPluginTableView$5_0(this));
  showDeletedButton = new EnhancedIButton_1('\u524A\u9664\u6E08\u307F\u3092\u8868\u793A');
  $addClickHandler(showDeletedButton, new AgentPluginTableView$6_0(this, showDeletedButton));
  pluginUploadForm = new PluginFileUploadForm_0('\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30A2\u30C3\u30D7\u30ED\u30FC\u30C9');
  this.extraWidgetsAboveFooter.add_0(scanForUpdatesButton);
  this.extraWidgetsAboveFooter.add_0(showDeletedButton);
  this.extraWidgetsAboveFooter.add_0(pluginUploadForm);
  $configureTable(this);
}
;
_.getDetailsView_0 = function getDetailsView_0(id){
  return new AgentPluginDetailView_0(id.value_0);
}
;
_.showDeleted = false;
var VIEW_ID_0;
function $enableIfRecordsExist(listGrid){
  return !!listGrid && $getTotalRows(listGrid) != 0;
}

function AbstractTableAction_0(){
  AbstractTableAction_1.call(this, ($clinit_TableActionEnablement() , ALWAYS));
}

function $isEnabled_0(this$static, selection){
  if (!$isEnabled(this$static, selection)) {
    return false;
  }
  if (!this$static.isGlobalAuthorized) {
    $loadExplicitGlobalPermissions(($clinit_PermissionsLoader() , new AuthorizedTableAction$1_0(this$static)));
    return false;
  }
  return this$static.isGlobalAuthorized.value_0;
}

function AuthorizedTableAction_0(table, enablement, permissions){
  var p, p$index, p$max;
  this.enablement = enablement;
  this.globalPermissions = new HashSet_0;
  this.table = table;
  for (p$index = 0 , p$max = permissions.length; p$index < p$max; ++p$index) {
    p = permissions[p$index];
    switch (p.target_0.ordinal) {
      case 0:
        $add_7(this.globalPermissions, p);
        break;
      default:throw new IllegalArgumentException_1('Does not support non-global permissions');
    }
  }
  this.globalPermissions.map_0.size_1() == 0 && (this.isGlobalAuthorized = ($clinit_Boolean() , $clinit_Boolean() , TRUE));
}

defineSeed(1660, 1661, {});
_.isEnabled_0 = function isEnabled_1(selection){
  return $isEnabled_0(this, selection);
}
;
_.isGlobalAuthorized = null;
_.table = null;
function AgentPluginTableView$1_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1659, 1660, {}, AgentPluginTableView$1_0);
_.executeAction = function executeAction(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds(selections);
  $enableAgentPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$1$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_13(this$static, result){
  var msg;
  msg = new Message_7('\u6709\u52B9\u5316\u3055\u308C\u305F\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function AgentPluginTableView$1$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1662, 1, makeCastMap([Q$AsyncCallback]), AgentPluginTableView$1$1_0);
_.onFailure = function onFailure_13(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3\u3092\u6709\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_13(result){
  $onSuccess_13(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function AgentPluginTableView$2_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1663, 1660, {}, AgentPluginTableView$2_0);
_.executeAction = function executeAction_0(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames(selections);
  message = '<b>\u8B66\u544A!<\/b><br/>\n\u6B21\u306E\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3\u304C\u7121\u52B9\u306B\u306A\u308A\u307E\u3059:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\n\u672C\u5F53\u306B\u3053\u308C\u3089\u3092\u7121\u52B9\u306B\u3057\u3066\u3082\u3088\u308D\u3057\u3044\u3067\u3059\u304B?';
  ask(message, new AgentPluginTableView$2$1_0(this, selections));
}
;
_.this$0 = null;
function AgentPluginTableView$2$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1664, 1, {}, AgentPluginTableView$2$1_0);
_.execute_3 = function execute_11(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds(this.val$selections);
    $disableAgentPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$2$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_14(this$static, result){
  var msg;
  msg = new Message_7('\u7121\u52B9\u5316\u3055\u308C\u305F\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function AgentPluginTableView$2$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1665, 1, makeCastMap([Q$AsyncCallback]), AgentPluginTableView$2$1$1_0);
_.onFailure = function onFailure_14(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3\u3092\u7121\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_14(result){
  $onSuccess_14(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function AgentPluginTableView$3_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1666, 1660, {}, AgentPluginTableView$3_0);
_.executeAction = function executeAction_1(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames(selections);
  message = '<b>\u8B66\u544A!<\/b><br/>\n\u6B21\u306E\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3\u304C\u524A\u9664\u3055\u308C\u307E\u3059:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\n\u672C\u5F53\u306B\u3053\u308C\u3089\u3092\u524A\u9664\u3057\u3066\u3082\u3088\u308D\u3057\u3044\u3067\u3059\u304B?';
  ask(message, new AgentPluginTableView$3$1_0(this, selections));
}
;
_.this$0 = null;
function AgentPluginTableView$3$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1667, 1, {}, AgentPluginTableView$3$1_0);
_.execute_3 = function execute_12(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds(this.val$selections);
    $deleteAgentPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$3$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_15(this$static, result){
  var msg;
  msg = new Message_7('\u524A\u9664\u3055\u308C\u305F\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function AgentPluginTableView$3$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1668, 1, makeCastMap([Q$AsyncCallback]), AgentPluginTableView$3$1$1_0);
_.onFailure = function onFailure_15(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u524A\u9664\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_15(result){
  $onSuccess_15(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function AgentPluginTableView$4_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1669, 1660, {}, AgentPluginTableView$4_0);
_.executeAction = function executeAction_2(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds(selections);
  $purgeAgentPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$4$1_0(this));
}
;
_.isEnabled_0 = function isEnabled_2(selection){
  return this.this$0.showDeleted && $isEnabled_0(this, selection);
}
;
_.this$0 = null;
function $onSuccess_16(this$static, result){
  var msg;
  msg = new Message_7('\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3 ' + ($clinit_Enhanced() , result.toString$()) + ' \u3092\u30D1\u30FC\u30B8\u3059\u308B\u305F\u3081\u306E\u6E96\u5099\u3092\u3057\u3066\u3044\u307E\u3059\u3002\u30D7\u30E9\u30B0\u30A4\u30F3\u304B\u3089\u306E\u5168\u30BF\u30A4\u30D7\u306E\u5B9A\u7FA9\u3092\u3001\u6700\u521D\u306B\u30B7\u30B9\u30C6\u30E0\u304B\u3089\u30D1\u30FC\u30B8\u3059\u308B\u5FC5\u8981\u304C\u3042\u308B\u305F\u3081\u3001\u6E96\u5099\u306B\u306F\u6570\u5206\u304B\u304B\u308B\u3053\u3068\u304C\u3042\u308A\u307E\u3059\u3002\u3053\u308C\u3089\u306E\u30D7\u30E9\u30B0\u30A4\u30F3\u306F\u30D1\u30FC\u30B8\u3055\u308C\u308B\u307E\u3067\u3053\u306E\u30DA\u30FC\u30B8\u306B\u8868\u793A\u3055\u308C\u307E\u3059\u3002\u969C\u5BB3\u304C\u767A\u751F\u3059\u308B\u305F\u3081\u3001\u30D1\u30FC\u30B8\u306E\u5B9F\u884C\u4E2D\u306B\u30D7\u30E9\u30B0\u30A4\u30F3\u3092\u518D\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3057\u306A\u3044\u3067\u304F\u3060\u3055\u3044\u3002\u30D1\u30FC\u30B8\u304C\u5B8C\u5168\u306B\u7D42\u4E86\u3057\u3066\u304B\u3089\u3001\u30D7\u30E9\u30B0\u30A4\u30F3\u3092\u30B7\u30B9\u30C6\u30E0\u306B\u518D\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3057\u3066\u304F\u3060\u3055\u3044\u3002', ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function AgentPluginTableView$4$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1670, 1, makeCastMap([Q$AsyncCallback]), AgentPluginTableView$4$1_0);
_.onFailure = function onFailure_16(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30D1\u30FC\u30B8\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_16(result){
  $onSuccess_16(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function AgentPluginTableView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1671, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), AgentPluginTableView$5_0);
_.onClick = function onClick_3(event_0){
  $scanAndRegister(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), new AgentPluginTableView$5$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_17(this$static){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , '\u66F4\u65B0\u3055\u308C\u305F\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u305F\u3081\u306E\u30B9\u30AD\u30E3\u30F3\u3092\u5B8C\u4E86\u3057\u307E\u3057\u305F'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function AgentPluginTableView$5$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1672, 1, makeCastMap([Q$AsyncCallback]), AgentPluginTableView$5$1_0);
_.onFailure = function onFailure_17(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u66F4\u65B0\u3055\u308C\u305F\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30B9\u30AD\u30E3\u30F3\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_17(result){
  $onSuccess_17(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$1 = null;
function AgentPluginTableView$6_0(this$0, val$showDeletedButton){
  this.this$0 = this$0;
  this.val$showDeletedButton = val$showDeletedButton;
}

defineSeed(1673, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), AgentPluginTableView$6_0);
_.onClick = function onClick_4(event_0){
  this.this$0.showDeleted = !this.this$0.showDeleted;
  if (this.this$0.showDeleted) {
    $setTitle_0(this.val$showDeletedButton, ($clinit_Enhanced() , '\u524A\u9664\u6E08\u307F\u3092\u96A0\u3059'));
    $showField(this.this$0.listGrid, 'deployed');
  }
   else {
    $setTitle_0(this.val$showDeletedButton, ($clinit_Enhanced() , '\u524A\u9664\u6E08\u307F\u3092\u8868\u793A'));
    $hideField(this.this$0.listGrid, 'deployed');
  }
  $refresh(this.this$0, false);
}
;
_.this$0 = null;
_.val$showDeletedButton = null;
function $clinit_RPCDataSource(){
  $clinit_RPCDataSource = nullMethod;
  $clinit_CoreGUI();
}

function $addFields(this$static, fields){
  var field, field$iterator;
  for (field$iterator = new AbstractList$IteratorImpl_0(fields); field$iterator.i < field$iterator.this$0_0.size_1();) {
    field = dynamicCast($next_0(field$iterator), Q$DataSourceField);
    $addField(this$static, field);
  }
}

function $buildDataObjects(this$static, records){
  var record, record$index, record$max, results;
  if (records == null) {
    return null;
  }
  results = new LinkedHashSet_1(records.length);
  for (record$index = 0 , record$max = records.length; record$index < record$max; ++record$index) {
    record = records[record$index];
    $add_7(results, this$static.copyValues(record));
  }
  return results;
}

function $buildRecords(this$static, dataObjects, cascade){
  var i, item, item$iterator, records;
  if (!dataObjects) {
    return null;
  }
  records = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, dataObjects.size_1(), 0);
  i = 0;
  for (item$iterator = dataObjects.iterator(); item$iterator.hasNext();) {
    item = item$iterator.next_0();
    setCheck(records, i++, this$static.copyValues_1(item, cascade));
  }
  return records;
}

function $getPageControl(this$static, request){
  var endRow, pageControl, startRow;
  if (!!this$static.previousCriteria && !equals_134($getCriteria(request), this$static.previousCriteria)) {
    debug('Resetting paging on ' + this$static.___clazz$.typeName + '...');
    $setAttribute_11(request, 'startRow', valueOf_49(0));
    $setAttribute_11(request, 'endRow', this$static.dataPageSize);
  }
  this$static.previousCriteria = $getCriteria(request)?$getCriteria(request):new Criteria_0;
  if (!getAttributeAsInt(request.jsObj, 'endRow')) {
    pageControl = getExplicitPageControl(0, this$static.dataPageSize.value_0);
  }
   else {
    startRow = getAttributeAsInt(request.jsObj, 'startRow')?getAttributeAsInt(request.jsObj, 'startRow').value_0:0;
    endRow = getAttributeAsInt(request.jsObj, 'endRow').value_0;
    pageControl = getExplicitPageControl(startRow, endRow - startRow);
  }
  $initializeSorting(this$static, pageControl, request);
  return pageControl;
}

function $highlightFilterMatches(this$static, request, records){
  var criteriaMap, decoratedData, filterName, filterName$iterator, filterValue, nextRecord, nextRecord$index, nextRecord$max, originalData;
  criteriaMap = convertToMap($getCriteria(request).jsObj);
  for (filterName$iterator = new AbstractList$IteratorImpl_0(this$static.hightlightingFieldNames); filterName$iterator.i < filterName$iterator.this$0_0.size_1();) {
    filterName = dynamicCast($next_0(filterName$iterator), Q$String);
    filterValue = dynamicCast(criteriaMap.get_2(filterName), Q$String);
    for (nextRecord$index = 0 , nextRecord$max = records.length; nextRecord$index < nextRecord$max; ++nextRecord$index) {
      nextRecord = records[nextRecord$index];
      originalData = getAttribute(nextRecord.jsObj, filterName);
      decoratedData = filterValue != null?highlight_0(originalData, filterValue):originalData;
      nextRecord.jsObj[filterName + '-highlight'] = decoratedData;
    }
  }
}

function $initializeSorting(this$static, pageControl, request){
  var columnName, ordering, sortField, sortSpecifier, sortSpecifier$index, sortSpecifier$max, sortSpecifiers;
  sortSpecifiers = $getSortBy(request);
  if (sortSpecifiers != null) {
    for (sortSpecifier$index = 0 , sortSpecifier$max = sortSpecifiers.length; sortSpecifier$index < sortSpecifier$max; ++sortSpecifier$index) {
      sortSpecifier = sortSpecifiers[sortSpecifier$index];
      ordering = dynamicCast(getEnum(($clinit_SortDirection() , $clinit_SortDirection() , $VALUES_36), getAttribute(sortSpecifier.jsObj, 'direction')), Q$SortDirection) == ASCENDING?($clinit_PageOrdering() , ASC):($clinit_PageOrdering() , DESC);
      columnName = getAttribute(sortSpecifier.jsObj, 'property');
      sortField = this$static.getSortFieldForColumn(columnName);
      sortField != null?$addDefaultOrderingField(pageControl, sortField, ordering):warn_0('Field [' + columnName + '] in [' + this$static.___clazz$.typeName + '] could not be mapped to a PageControl ordering field.');
    }
  }
}

function $processResponse_0(this$static, requestId, responseProperties){
  $processResponse(this$static, requestId, responseProperties);
  record_2(requestId, responseProperties);
}

function $sendFailureResponse(this$static, request, response, message, caught){
  $handleError_0(($clinit_CoreGUI() , message), caught);
  response.jsObj['status'] = -1;
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
}

function $sendSuccessResponse(this$static, request, response, record, message){
  response.jsObj['status'] = 0;
  $setAttribute_17(response, 'data', initValues(_3Lcom_smartgwt_client_data_Record_2_classLit, makeCastMap([Q$Record_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Record, [record]));
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
  !!message && $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), message);
}

function $sendSuccessResponse_0(this$static, request, response, dataObject, message){
  var record;
  record = this$static.copyValues_0(dataObject);
  $sendSuccessResponse(this$static, request, response, record, message);
}

function $sendSuccessResponse_1(this$static, request, response, dataObjects){
  var records, recordsPageList;
  records = this$static.buildRecords(dataObjects);
  recordsPageList = new PageList_2(dataObjects.pageControl);
  $setTotalSize(recordsPageList, max_1(dataObjects.size_0, dataObjects.totalSize));
  $setUnbounded(recordsPageList, dataObjects.isUnbounded);
  $addAll_0(recordsPageList, new Arrays$ArrayList_0(records));
  this$static.sendSuccessResponseRecords(request, response, recordsPageList);
}

function $sendSuccessResponseRecords(this$static, request, response, records){
  var recordsArray;
  response.jsObj['status'] = 0;
  recordsArray = dynamicCast($toArray_1(records, initDim(_3Lcom_smartgwt_client_data_Record_2_classLit, makeCastMap([Q$Record_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Record, records.size_0, 0)), Q$Record_$1);
  $setAttribute_17(response, 'data', recordsArray);
  $setPagingInfo(response, records);
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
}

function $sendValidationErrorResponse(this$static, request, response, errorMessages){
  response.jsObj['status'] = -4;
  setAttribute_10(response.jsObj, 'errors', errorMessages);
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
}

function $setDataPageSize(this$static, dataPageSize){
  if (dataPageSize.value_0 <= 0) {
    throw new IllegalArgumentException_1('Page size must be greater than 0.');
  }
  this$static.dataPageSize = dataPageSize;
}

function $setPagingInfo(response, pageList){
  var totalRows;
  totalRows = pageList.isUnbounded?pageList.size_0:max_1(pageList.size_0, pageList.totalSize);
  $setAttribute_11(response, 'totalRows', valueOf_49(totalRows));
}

function RPCDataSource_0(){
  $clinit_RPCDataSource();
  DataSource_0.call(this);
  this.hightlightingFieldNames = new ArrayList_0;
  $setAttribute_0(this, 'clientOnly', ($clinit_Boolean() , $clinit_Boolean() , FALSE), false);
  $setAttribute_0(this, 'autoCacheAllData', FALSE, true);
  $setAttribute_0(this, 'cacheAllData', FALSE, true);
  $setAttribute_1(this, 'dataProtocol', ($clinit_DSProtocol() , CLIENTCUSTOM).value_0, false);
  $setAttribute_1(this, 'dataFormat', ($clinit_DSDataFormat() , CUSTOM).value_0, false);
  $setDataPageSize(this, valueOf_49(50));
}

function convertTimestampToDate(timestamp){
  if (!timestamp) {
    return null;
  }
  return neq(timestamp.value_0, P0_longLit)?new Date_3(timestamp.value_0):null;
}

function createBooleanField(name_0, title, required){
  var textField, valueMap;
  textField = new DataSourceTextField_1(name_0, title);
  $setAttribute_11(textField, 'length', valueOf_49((($clinit_Boolean() , FALSE).value_0?'true':'false').length));
  setAttribute_5(textField.jsObj, 'required', required);
  valueMap = new LinkedHashMap_0;
  $put_1(valueMap, TRUE.value_0?'true':'false', '\u306F\u3044');
  $put_1(valueMap, FALSE.value_0?'true':'false', '\u3044\u3044\u3048');
  setAttribute_10(textField.jsObj, 'valueMap', valueMap);
  return textField;
}

function createIntegerField(minValue, required){
  var integerRangeValidator, textField;
  textField = new DataSourceIntegerField_1('timeout', '\u30BF\u30A4\u30E0\u30A2\u30A6\u30C8 (\u79D2)');
  setAttribute_5(textField.jsObj, 'required', required);
  if (minValue) {
    integerRangeValidator = new IntegerRangeValidator_0;
    minValue?$setAttribute_3(integerRangeValidator, 'min', minValue.value_0):(integerRangeValidator.jsObj['min'] = -2147483648 , undefined);
    integerRangeValidator.jsObj['max'] = 2147483647;
    textField.jsObj['validators'] = convertToJavaScriptArray_0(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [integerRangeValidator]));
  }
  return textField;
}

function createTextField(name_0, title, minLength, maxLength, required){
  var lengthRangeValidator, textField;
  textField = new DataSourceTextField_1(name_0, title);
  setAttribute_8(textField.jsObj, 'length', maxLength);
  setAttribute_5(textField.jsObj, 'required', required);
  if (!!minLength || !!maxLength) {
    lengthRangeValidator = new LengthRangeValidator_0;
    setAttribute_8(lengthRangeValidator.jsObj, 'min', minLength);
    setAttribute_8(lengthRangeValidator.jsObj, 'max', maxLength);
    textField.jsObj['validators'] = convertToJavaScriptArray_0(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [lengthRangeValidator]));
  }
  return textField;
}

function getArrayFilter(criteria, paramName, type){
  $clinit_RPCDataSource();
  var buffer, criteriaMap, index, intermediates, next, next$index, next$max, resultArray, value;
  criteriaMap = convertToMap(criteria.jsObj);
  value = criteriaMap.get_2(paramName);
  if (value == null) {
    resultArray = null;
  }
   else if (type == Ljava_lang_Integer_2_classLit) {
    (getClass__devirtual$(value).modifiers & 4) != 0 || getClass__devirtual$(value) == Ljava_util_ArrayList_2_classLit?(intermediates = getAttributeAsIntArray(criteria.jsObj, paramName)):(intermediates = initValues(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, [getAttributeAsInt(criteria.jsObj, paramName).value_0]));
    resultArray = initDim(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, intermediates.length, 0);
    index = 0;
    for (next$index = 0 , next$max = intermediates.length; next$index < next$max; ++next$index) {
      next = intermediates[next$index];
      setCheck(resultArray, index++, valueOf_49(next));
    }
  }
   else if (type == Ljava_lang_String_2_classLit) {
    (getClass__devirtual$(value).modifiers & 4) != 0 || getClass__devirtual$(value) == Ljava_util_ArrayList_2_classLit?(intermediates = getAttributeAsStringArray(criteria.jsObj, paramName)):(intermediates = initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, [getAttribute(criteria.jsObj, paramName)]));
    resultArray = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, intermediates.length, 0);
    index = 0;
    for (next$index = 0 , next$max = intermediates.length; next$index < next$max; ++next$index) {
      next = intermediates[next$index];
      setCheck(resultArray, index++, next);
    }
  }
   else if ((type.modifiers & 8) != 0) {
    (getClass__devirtual$(value).modifiers & 4) != 0 || getClass__devirtual$(value) == Ljava_util_ArrayList_2_classLit?(intermediates = getAttributeAsStringArray(criteria.jsObj, paramName)):(intermediates = initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, [getAttribute(criteria.jsObj, paramName)]));
    buffer = new ArrayList_0;
    for (next$index = 0 , next$max = intermediates.length; next$index < next$max; ++next$index) {
      next = intermediates[next$index];
      buffer.add_0(valueOf_0(type, next));
    }
    resultArray = $toArray_1(buffer, getEnumArray(type, buffer.size_0));
  }
   else {
    throw new IllegalArgumentException_1('\u30BF\u30A4\u30D7 ' + type.typeName + ' \u306E\u30A2\u30EC\u30A4\u30D5\u30A3\u30EB\u30BF\u30FC\u3092\u6E21\u3059\u52D5\u4F5C\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002');
  }
  ($clinit_Log() , $isLoggable_0(logger_0, ($clinit_Level() , FINE))) && resultArray != null && debug('Array filter: ' + paramName + '=[' + toString_31(resultArray) + ']');
  return resultArray;
}

function getArrayFilter_0(request, paramName, type){
  $clinit_RPCDataSource();
  return getArrayFilter($getCriteria(request), paramName, type);
}

function getDataObject(request){
  var data, newRecord;
  data = getAttributeAsJavaScriptObject(request.jsObj, 'data');
  newRecord = new ListGridRecord_1(data);
  return newRecord;
}

function getEnumArray(genericEnumType, size){
  if (genericEnumType == Lorg_rhq_core_domain_alert_AlertPriority_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_alert_AlertPriority_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$AlertPriority_$1]), Q$AlertPriority, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_event_EventSeverity_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_event_EventSeverity_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$EventSeverity_$1]), Q$EventSeverity, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_operation_OperationRequestStatus_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_operation_OperationRequestStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$OperationRequestStatus_$1]), Q$OperationRequestStatus, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_resource_ResourceCategory_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_resource_ResourceCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$ResourceCategory_$1]), Q$ResourceCategory, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_drift_DriftCategory_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_drift_DriftCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$DriftCategory_$1]), Q$DriftCategory, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_PartitionEvent$ExecutionStatus_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_PartitionEvent$ExecutionStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEvent$ExecutionStatus_$1]), Q$PartitionEvent$ExecutionStatus, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_PartitionEventType_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_PartitionEventType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEventType_$1]), Q$PartitionEventType, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_Server$OperationMode_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_Server$OperationMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$Server$OperationMode_$1]), Q$Server$OperationMode, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_StorageNode$OperationMode_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_StorageNode$OperationMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$StorageNode$OperationMode_$1]), Q$StorageNode$OperationMode, size, 0);
  }
   else {
    throw new IllegalArgumentException_1('RPCDataSource.getEnumArray(Class) \u3078\u5217\u6319 ' + genericEnumType.typeName + ' \u306E\u9069\u5207\u306A\u30B3\u30FC\u30C9\u30D6\u30ED\u30C3\u30AF\u3092\u8FFD\u52A0\u3057\u3066\u304F\u3060\u3055\u3044');
  }
}

function getFilter(criteria, paramName, type){
  $clinit_RPCDataSource();
  var criteriaMap, result, strValue, value;
  criteriaMap = criteria?convertToMap(criteria.jsObj):($clinit_Collections() , $clinit_Collections() , EMPTY_MAP);
  value = criteriaMap.get_2(paramName);
  if (value == null || $equals_6(toString__devirtual$(value), '')) {
    result = null;
  }
   else {
    strValue = toString__devirtual$(value);
    type == Ljava_lang_String_2_classLit?(result = strValue):type == Ljava_lang_Integer_2_classLit?(result = valueOf_49(__parseAndValidateInt(strValue))):type == Ljava_lang_Long_2_classLit?(result = new Long_0(__parseAndValidateLong(strValue))):(type.modifiers & 8) != 0?(result = valueOf_0(type, strValue)):(result = value);
  }
  $clinit_Log();
  $fine_0(logger_0, 'Filter: ' + paramName + '=[' + result + ']');
  return result;
}

function getFilter_0(request, paramName, type){
  $clinit_RPCDataSource();
  return getFilter($getCriteria(request), paramName, type);
}

function printRequestCriteria(request){
  var criteria, criteriaMap, nextEntry, nextEntry$iterator;
  criteria = $getCriteria(request);
  criteriaMap = convertToMap(criteria.jsObj);
  for (nextEntry$iterator = criteriaMap.entrySet().iterator(); nextEntry$iterator.hasNext();) {
    nextEntry = dynamicCast(nextEntry$iterator.next_0(), Q$Map$Entry);
    debug('Request Criteria: ' + dynamicCast(nextEntry.getKey_0(), Q$String) + ':' + nextEntry.getValue_1());
  }
}

defineSeed(1675, 341, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource]));
_.addField = function addField_0(field){
  $addField(this, field);
}
;
_.buildRecords = function buildRecords(dataObjects){
  return $buildRecords(this, dataObjects, true);
}
;
_.copyValues_1 = function copyValues(from, cascade){
  return this.copyValues_0(from);
}
;
_.executeAdd = function executeAdd(recordToAdd, request, response){
  throw new UnsupportedOperationException_1('This dataSource does not support additions.');
}
;
_.executeRemove = function executeRemove(recordToRemove, request, response){
  throw new UnsupportedOperationException_1('This dataSource does not support removals.');
}
;
_.executeUpdate = function executeUpdate(editedRecord, oldRecord, request, response){
  throw new UnsupportedOperationException_1('This dataSource does not support updates.');
}
;
_.getPageControl = function getPageControl(request){
  return $getPageControl(this, request);
}
;
_.getSortFieldForColumn = function getSortFieldForColumn(columnName){
  return columnName;
}
;
_.sendSuccessResponseRecords = function sendSuccessResponseRecords(request, response, records){
  $sendSuccessResponseRecords(this, request, response, records);
}
;
_.setDataPageSize = function setDataPageSize(dataPageSize){
  $setDataPageSize(this, dataPageSize);
}
;
_.transformRequest_0 = function transformRequest_0(request){
  var $e0, criteria, deletedRecord, newRecord, oldRecord, response, t, updatedRecord, data;
  try {
    response = new DSResponse_0;
    $setAttribute_12(response, 'clientContext', getAttributeAsObject(request.jsObj, 'clientContext'));
    response.jsObj['status'] = 0;
    switch (dynamicCast(getEnum(($clinit_DSOperationType() , $clinit_DSOperationType() , $VALUES_10), getAttribute(request.jsObj, 'operationType')), Q$DSOperationType).ordinal) {
      case 0:
        criteria = this.getFetchCriteria(request);
        if (criteria) {
          !criteria.getPageControlOverrides() && criteria.setPageControl(this.getPageControl(request));
          ($clinit_Log() , $isLoggable_0(logger_0, ($clinit_Level() , FINE))) && debug(this.___clazz$.typeName + ' using [' + criteria.getPageControlOverrides() + '] for fetch request.');
        }
         else {
          warn_0(this.___clazz$.typeName + '.getFetchCriteria() returned null - no paging of results will be done.');
        }

        this.executeFetch(request, response, criteria);
        break;
      case 1:
        newRecord = getDataObject(request);
        this.executeAdd(newRecord, request, response);
        break;
      case 2:
        oldRecord = getOrCreateRef_1(getAttributeAsJavaScriptObject(request.jsObj, 'oldValues'));
        updatedRecord = (data = getAttributeAsJavaScriptObject(request.jsObj, 'data') , apply_0(data, oldRecord.jsObj) , new ListGridRecord_1(data));
        this.executeUpdate(updatedRecord, oldRecord, request, response);
        break;
      case 3:
        deletedRecord = getDataObject(request);
        this.executeRemove(deletedRecord, request, response);
        break;
      default:$transformRequest(this, request);
    }
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$Throwable)) {
      t = $e0;
      $handleError_0(($clinit_CoreGUI() , dynamicCast(getEnum(($clinit_DSOperationType() , $clinit_DSOperationType() , $VALUES_10), getAttribute(request.jsObj, 'operationType')), Q$DSOperationType).name_0 + ' \u30EA\u30AF\u30A8\u30B9\u30C8\u306E\u51E6\u7406\u4E2D\u306B\u30C7\u30FC\u30BF\u30BD\u30FC\u30B9\u3067\u969C\u5BB3\u304C\u767A\u751F\u3057\u307E\u3057\u305F\u3002'), t);
      return null;
    }
     else 
      throw $e0;
  }
  return getAttributeAsJavaScriptObject(request.jsObj, 'data');
}
;
_.dataPageSize = null;
_.previousCriteria = null;
function $copyValues(from){
  var record;
  record = new ListGridRecord_0;
  $setAttribute_3(record, 'id', from.id);
  $setAttribute_13(record, 'name', from.displayName);
  $setAttribute_13(record, 'description', from.description);
  $setAttribute_14(record, 'lastUpdate', new Date_3(from.mtime));
  $setAttribute_13(record, 'enabled', getAvailabilityIcon(($clinit_Boolean() , from.enabled?TRUE:FALSE)));
  $setAttribute_13(record, 'deployed', getAvailabilityIcon(from.status_0 == ($clinit_PluginStatusType() , INSTALLED_3)?TRUE:FALSE));
  $setAttribute_13(record, 'version', from.version_0);
  return record;
}

function $executeFetch(this$static, request, response){
  $getAgentPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), this$static.this$0.showDeleted, new AgentPluginTableView$AgentPluginDataSource$1_0(this$static, response, request));
}

function $getListGridFields(){
  var deployedField, descriptionField, enabledField, fields, idField, lastUpdateField, nameField, versionField;
  fields = new ArrayList_0;
  idField = new ListGridField_3('id', 'ID');
  idField.jsObj['showIf'] = 'false';
  fields.add_0(idField);
  nameField = new ListGridField_3('name', '\u540D\u524D');
  fields.add_0(nameField);
  descriptionField = new ListGridField_3('description', '\u8AAC\u660E');
  fields.add_0(descriptionField);
  lastUpdateField = new ListGridField_3('lastUpdate', '\u6700\u7D42\u66F4\u65B0');
  $clinit_TimestampCellFormatter();
  prepareDateField(lastUpdateField, getAttribute(lastUpdateField.jsObj, 'name'));
  fields.add_0(lastUpdateField);
  enabledField = new ListGridField_3('enabled', '\u6709\u52B9?');
  $setAttribute_13(enabledField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  $setAttribute_13(enabledField, 'align', ($clinit_Alignment() , CENTER_0).value_0);
  fields.add_0(enabledField);
  deployedField = new ListGridField_3('deployed', '\u30C7\u30D7\u30ED\u30A4\u6E08\u307F?');
  $setAttribute_13(deployedField, 'type', IMAGE_0.value_0);
  $setAttribute_13(deployedField, 'align', CENTER_0.value_0);
  deployedField.jsObj['showIf'] = 'false';
  fields.add_0(deployedField);
  versionField = new ListGridField_3('version', '\u30D0\u30FC\u30B8\u30E7\u30F3');
  versionField.jsObj['showIf'] = 'false';
  fields.add_0(versionField);
  idField.jsObj['width'] = 100;
  nameField.jsObj['width'] = '30%';
  descriptionField.jsObj['width'] = '*';
  lastUpdateField.jsObj['width'] = '20%';
  enabledField.jsObj['width'] = 65;
  deployedField.jsObj['width'] = 75;
  versionField.jsObj['width'] = 100;
  return fields;
}

function AgentPluginTableView$AgentPluginDataSource_0(this$0){
  var fields_0, idField;
  $clinit_RPCDataSource();
  var fields;
  this.this$0 = this$0;
  RPCDataSource_0.call(this);
  fields = (fields_0 = new ArrayList_0 , idField = new DataSourceIntegerField_2('id', 'ID', 50) , $setAttribute_8(idField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setAttribute_8(idField, 'hidden', TRUE) , fields_0.add_0(idField) , fields_0);
  $addFields(this, fields);
}

defineSeed(1674, 1675, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource, Q$AgentPluginTableView$AgentPluginDataSource]), AgentPluginTableView$AgentPluginDataSource_0);
_.copyValues = function copyValues_0(from){
  return null;
}
;
_.copyValues_0 = function copyValues_1(from){
  return $copyValues(dynamicCast(from, Q$Plugin));
}
;
_.executeFetch = function executeFetch(request, response, criteria){
  $executeFetch(this, request, response, dynamicCast(criteria, Q$Criteria));
}
;
_.getFetchCriteria = function getFetchCriteria(request){
  return null;
}
;
_.this$0 = null;
function $onSuccess_18(this$static, result){
  $setAttribute_17(this$static.val$response, 'data', $buildRecords(this$static.this$1, result, true));
  $setTotalRows(this$static.val$response, valueOf_49(result.size_0));
  $processResponse_0(this$static.this$1, $getAttributeAsString(this$static.val$request, 'requestId'), this$static.val$response);
}

function AgentPluginTableView$AgentPluginDataSource$1_0(this$1, val$response, val$request){
  this.this$1 = this$1;
  this.val$response = val$response;
  this.val$request = val$request;
}

defineSeed(1676, 1, makeCastMap([Q$AsyncCallback]), AgentPluginTableView$AgentPluginDataSource$1_0);
_.onFailure = function onFailure_18(t){
  $handleError_0(($clinit_CoreGUI() , $clinit_RPCDataSource() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), t);
  this.val$response.jsObj['status'] = -1;
  $processResponse_0(this.this$1, $getAttributeAsString(this.val$request, 'requestId'), this.val$response);
}
;
_.onSuccess_0 = function onSuccess_18(result){
  $onSuccess_18(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
_.val$request = null;
_.val$response = null;
function $clinit_DownloadsView(){
  $clinit_DownloadsView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_1 = new ViewName_2('Downloads', ($clinit_Enhanced() , '\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9'), ($clinit_IconEnum() , DOWNLOAD));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_1;
}

function DownloadsView_0(){
  $clinit_DownloadsView();
  EnhancedVLayout_0.call(this);
  this.systemManager = dynamicCast(secure(getInstance_57(), -1), Q$SystemGWTServiceAsync);
  this.productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo;
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  this.sectionStack = new SectionStack_0;
  $setShowResizeBar(this.sectionStack, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setAttribute_24(this.sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $setAttribute_24(this.sectionStack, 'width', '100%', true);
  $setAttribute_24(this.sectionStack, 'height', '100%', true);
  $setAttribute_24(this.sectionStack, 'overflow', ($clinit_Overflow() , AUTO_0).value_0, false);
  this.agentSection = new SectionStackSection_1(($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9'));
  this.cliSection = new SectionStackSection_1('\u30B3\u30DE\u30F3\u30C9\u30E9\u30A4\u30F3\u30AF\u30E9\u30A4\u30A2\u30F3\u30C8\u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9');
  this.bundleSection = new SectionStackSection_1('\u30D0\u30F3\u30C9\u30EB\u30C7\u30D7\u30ED\u30A4\u30E4\u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9');
  this.connectorsSection = new SectionStackSection_1('\u30B3\u30CD\u30AF\u30BF\u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9');
  this.cliAlertScriptsSection = new SectionStackSection_1('CLI \u30A2\u30E9\u30FC\u30C8\u30B9\u30AF\u30EA\u30D7\u30C8\u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9');
  this.scriptModulesSection = new SectionStackSection_1('\u30B9\u30AF\u30EA\u30D7\u30C8\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9');
  $setExpanded(this.agentSection, FALSE);
  $setExpanded(this.cliSection, FALSE);
  $setExpanded(this.bundleSection, FALSE);
  $setExpanded(this.connectorsSection, FALSE);
  $setExpanded(this.cliAlertScriptsSection, FALSE);
  $setExpanded(this.scriptModulesSection, FALSE);
  $addSection(this.sectionStack, this.agentSection);
  $addSection(this.sectionStack, this.cliSection);
  $addSection(this.sectionStack, this.bundleSection);
  $addSection(this.sectionStack, this.connectorsSection);
  $addSection(this.sectionStack, this.cliAlertScriptsSection);
  $addSection(this.sectionStack, this.scriptModulesSection);
  $addMember(this, this.sectionStack);
}

defineSeed(1677, 1653, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced, Q$EnhancedVLayout]), DownloadsView_0);
_.onDraw_0 = function onDraw_4(){
  $getAgentVersionProperties(this.systemManager, new DownloadsView$1_0(this));
  $getClientVersionProperties(this.systemManager, new DownloadsView$2_0(this));
  $getBundleDeployerDownload(this.systemManager, new DownloadsView$3_0(this));
  $getConnectorDownloads(this.systemManager, new DownloadsView$4_0(this));
  $getCliAlertScriptDownloads(this.systemManager, new DownloadsView$5_0(this));
  $getScriptModulesDownloads(this.systemManager, new DownloadsView$6_0(this));
}
;
_.agentSection = null;
_.bundleSection = null;
_.cliAlertScriptsSection = null;
_.cliSection = null;
_.connectorsSection = null;
_.productInfo = null;
_.scriptModulesSection = null;
_.sectionStack = null;
var VIEW_ID_1;
function $onSuccess_19(this$static, result){
  var build, buildItem, form, helpItem, linkItem, md5, md5Item, spacerItem, version, versionItem;
  version = dynamicCast(result.get_2('rhq-agent.latest.version'), Q$String);
  build = dynamicCast(result.get_2('rhq-agent.latest.build-number'), Q$String);
  md5 = dynamicCast(result.get_2('rhq-agent.latest.md5'), Q$String);
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  versionItem = new StaticTextItem_2('agentVersion', ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30D0\u30FC\u30B8\u30E7\u30F3'));
  $setValue_7(versionItem, version);
  $setWrapTitle(versionItem, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  buildItem = new StaticTextItem_2('agentBuild', '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30D3\u30EB\u30C9');
  $setValue_7(buildItem, build);
  $setWrapTitle(buildItem, FALSE);
  md5Item = new StaticTextItem_2('agentMd5', '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8 MD5');
  $setValue_7(md5Item, md5);
  $setWrapTitle(md5Item, FALSE);
  linkItem = new StaticTextItem_1('agentLink');
  $setTitle_1(linkItem, '\u30EA\u30F3\u30AF');
  $setValue_7(linkItem, '<a href="/agentupdate/download">\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8 ' + version + ' (' + build + ') \u306E\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9<\/a>');
  spacerItem = new SpacerItem_1('agentSpacer');
  $isCreated_2(spacerItem)?$setProperty_7(spacerItem, 'height', 10):(spacerItem.jsObj['height'] = 10 , undefined);
  helpItem = new StaticTextItem_1('agentHelp');
  $isCreated_2(helpItem)?$setProperty_7(helpItem, 'colSpan', 2):(helpItem.jsObj['colSpan'] = 2 , undefined);
  $setShowTitle_0(helpItem, FALSE);
  $setValue_7(helpItem, '<p> \u3053\u308C\u306F ' + this$static.this$0.productInfo.shortName + ' \u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u66F4\u65B0\u30D0\u30A4\u30CA\u30EA\u306E jar \u30D5\u30A1\u30A4\u30EB\u3067\u3059\u3002\u3053\u306E jar \u30D5\u30A1\u30A4\u30EB\u306E\u76EE\u7684\u306F\u3001\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u307E\u3060\u5B58\u5728\u3057\u306A\u3044\u30DE\u30B7\u30F3\u4E0A\u306B\u65B0\u3057\u3044\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u3092\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3067\u304D\u308B\u3088\u3046\u306B\u3059\u308B\u3053\u3068\u3068\u3001\u3059\u3067\u306B\u30DE\u30B7\u30F3\u4E0A\u306B\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u3066\u3044\u308B\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u3092\u66F4\u65B0\u3067\u304D\u308B\u3088\u3046\u306B\u3059\u308B\u3053\u3068\u3067\u3059\u3002\u8A73\u7D30\u306F\u3001\u6B21\u306E\u3088\u3046\u306B --help \u30B3\u30DE\u30F3\u30C9\u30E9\u30A4\u30F3\u30AA\u30D7\u30B7\u30E7\u30F3\u3092\u4F7F\u7528\u3057\u3066\u3053\u306E\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9 jar \u3092\u5B9F\u884C\u3057\u3066\u304F\u3060\u3055\u3044\u3002<br/> <b>java -jar &lt;agent-download.jar&gt; --help<\/b> <\/p> <h3>\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB<\/h3> <p> <b>java -jar &lt;agent-download.jar&gt; --install[=&lt;\u65B0\u3057\u3044\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA&gt;]<\/b><br/> \u3053\u306E\u30B3\u30DE\u30F3\u30C9\u306F\u65B0\u3057\u3044\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u3092\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3057\u307E\u3059\u3002\u65B0\u3057\u3044\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u3092\u6307\u5B9A\u3057\u306A\u3044\u3068\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u306F\u300C.\u300D\u306B\u306A\u308A\u307E\u3059\u3002<\/p> <h3>\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u66F4\u65B0<\/h3> <p> <b>java -jar &lt;agent-download.jar&gt; --update[=&lt;\u53E4\u3044\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30DB\u30FC\u30E0&gt;]<\/b><br/> \u3053\u306E\u30B3\u30DE\u30F3\u30C9\u306F\u3059\u3067\u306B\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u3066\u3044\u308B\u65E2\u5B58\u306E\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u3092\u66F4\u65B0\u3057\u307E\u3059\u3002\u65E2\u5B58\u306E\u53E4\u3044\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u3066\u3044\u308B\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u3092\u6307\u5B9A\u3057\u306A\u3044\u3068\u3001\u300Crhq-agent\u300D\u304C\u4EEE\u5B9A\u3055\u308C\u307E\u3059\u3002<\/p>');
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [versionItem, buildItem, md5Item, linkItem, spacerItem, helpItem]));
  $setItems(this$static.this$0.agentSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.agentSection, TRUE);
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1678, 1, makeCastMap([Q$AsyncCallback]), DownloadsView$1_0);
_.onFailure = function onFailure_19(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30D0\u30FC\u30B8\u30E7\u30F3\u60C5\u5831\u3092\u53D6\u5F97\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_19(result){
  $onSuccess_19(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_20(this$static, result){
  var build, buildItem, form, helpItem, linkItem, md5, md5Item, spacerItem, version, versionItem;
  version = dynamicCast(result.get_2('rhq-server.version'), Q$String);
  build = dynamicCast(result.get_2('rhq-server.build-number'), Q$String);
  md5 = dynamicCast(result.get_2('rhq-client.md5'), Q$String);
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  versionItem = new StaticTextItem_2('cliVersion', ($clinit_Enhanced() , 'CLI \u30D0\u30FC\u30B8\u30E7\u30F3'));
  $setValue_7(versionItem, version);
  $setWrapTitle(versionItem, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  buildItem = new StaticTextItem_2('cliBuild', 'CLI \u30D3\u30EB\u30C9');
  $setValue_7(buildItem, build);
  $setWrapTitle(buildItem, FALSE);
  md5Item = new StaticTextItem_2('cliMd5', 'CLI MD5');
  $setValue_7(md5Item, md5);
  $setWrapTitle(md5Item, FALSE);
  linkItem = new StaticTextItem_1('cliLink');
  $setTitle_1(linkItem, '\u30EA\u30F3\u30AF');
  $setValue_7(linkItem, '<a href="/client/download">CLI ' + version + ' (' + build + ') \u3092\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9<\/a>');
  spacerItem = new SpacerItem_1('clientSpacer');
  $isCreated_2(spacerItem)?$setProperty_7(spacerItem, 'height', 1):(spacerItem.jsObj['height'] = 1 , undefined);
  helpItem = new StaticTextItem_1('clientHelp');
  $isCreated_2(helpItem)?$setProperty_7(helpItem, 'colSpan', 2):(helpItem.jsObj['colSpan'] = 2 , undefined);
  $setShowTitle_0(helpItem, FALSE);
  $setValue_7(helpItem, '<p> \u3053\u308C\u306F\u30B3\u30DE\u30F3\u30C9\u30E9\u30A4\u30F3\u30AF\u30E9\u30A4\u30A2\u30F3\u30C8\u30C4\u30FC\u30EB\u3067\u3001CLI \u3068\u3082\u547C\u3070\u308C\u307E\u3059\u3002\u30B3\u30F3\u30BD\u30FC\u30EB\u5185\u304B\u3089\u5B9F\u884C\u3055\u308C\u308B\u30B9\u30BF\u30F3\u30C9\u30A2\u30ED\u30F3\u30C4\u30FC\u30EB\u3067\u3001' + this$static.this$0.productInfo.shortName + ' \u30B5\u30FC\u30D0\u30FC\u306B\u5BFE\u3057\u3066\u30B3\u30DE\u30F3\u30C9\u30E9\u30A4\u30F3\u30A4\u30F3\u30BF\u30D5\u30A7\u30FC\u30B9\u3092\u63D0\u4F9B\u3057\u307E\u3059\u3002\u81EA\u52D5\u5316\u3055\u308C\u305F\u30BF\u30B9\u30AF\u3092\u5B9F\u884C\u3059\u308B\u306B\u306F\u3001CLI \u304B\u3089\u30B3\u30DE\u30F3\u30C9\u3092\u547C\u3073\u51FA\u3059\u304B\u3001\u30B9\u30AF\u30EA\u30D7\u30C8\u3092\u5B9F\u884C\u3057\u307E\u3059\u3002CLI \u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u65B9\u6CD5\u3068\u4F7F\u7528\u6CD5\u306E\u8A73\u7D30\u306B\u3064\u3044\u3066\u306F\u3001\u30C9\u30AD\u30E5\u30E1\u30F3\u30C8\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044\u3002<\/p>');
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [versionItem, buildItem, md5Item, linkItem, spacerItem, helpItem]));
  $setItems(this$static.this$0.cliSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.cliSection, TRUE);
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1679, 1, makeCastMap([Q$AsyncCallback]), DownloadsView$2_0);
_.onFailure = function onFailure_20(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'CLI \u30D0\u30FC\u30B8\u30E7\u30F3\u60C5\u5831\u3092\u53D6\u5F97\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_20(result){
  $onSuccess_20(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_21(this$static, result){
  var form, helpItem, linkItem, name_0, spacerItem, url;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  name_0 = dynamicCast($next_1($iterator($keySet(result))), Q$String);
  url = dynamicCast($next_2($iterator_0($values(result))), Q$String);
  linkItem = new StaticTextItem_1('bundleLink');
  $setTitle_1(linkItem, ($clinit_Enhanced() , '\u30EA\u30F3\u30AF'));
  $setValue_7(linkItem, '<a href="' + url + '">\u30D0\u30F3\u30C9\u30EB\u30C7\u30D7\u30ED\u30A4\u30E4\u30FC ' + name_0 + ' \u3092\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9<\/a>');
  spacerItem = new SpacerItem_1('bundleSpacer');
  $isCreated_2(spacerItem)?$setProperty_7(spacerItem, 'height', 1):(spacerItem.jsObj['height'] = 1 , undefined);
  helpItem = new StaticTextItem_1('bundleHelp');
  $isCreated_2(helpItem)?$setProperty_7(helpItem, 'colSpan', 2):(helpItem.jsObj['colSpan'] = 2 , undefined);
  $setShowTitle_0(helpItem, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setValue_7(helpItem, '<p> \u3053\u308C\u306F\u30D0\u30F3\u30C9\u30EB\u30C7\u30D7\u30ED\u30A4\u30E4\u30C4\u30FC\u30EB\u3067\u3001' + this$static.this$0.productInfo.shortName + ' \u30D0\u30F3\u30C9\u30EB\u306E\u958B\u767A\u8005\u3068\u30D1\u30C3\u30B1\u30FC\u30B8\u30E3\u30FC\u306B\u3088\u3063\u3066\u4F7F\u7528\u3055\u308C\u307E\u3059\u3002\u3053\u306E\u30B9\u30BF\u30F3\u30C9\u30A2\u30ED\u30F3\u30C4\u30FC\u30EB\u3092\u4F7F\u7528\u3059\u308B\u3068\u3001\u30B3\u30F3\u30BD\u30FC\u30EB\u304B\u3089\u30D0\u30F3\u30C9\u30EB\u3084\u30D0\u30F3\u30C9\u30EB\u306E\u30EC\u30B7\u30D4\u3092\u30C6\u30B9\u30C8\u3067\u304D\u307E\u3059\u3002<\/p>');
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [linkItem, spacerItem, helpItem]));
  $setItems(this$static.this$0.bundleSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.bundleSection, TRUE);
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$3_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1680, 1, makeCastMap([Q$AsyncCallback]), DownloadsView$3_0);
_.onFailure = function onFailure_21(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30D0\u30F3\u30C9\u30EB\u30C7\u30D7\u30ED\u30A4\u30E4\u30FC\u60C5\u5831\u3092\u53D6\u5F97\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_21(result){
  $onSuccess_21(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_22(this$static, result){
  var entry, entry$iterator, form, helpText, i, item, items, linkItem, spacerItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  if (!!result && result.size_1() != 0) {
    i = 0;
    items = initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, result.size_1() + 2, 0);
    for (entry$iterator = result.entrySet().iterator(); entry$iterator.hasNext();) {
      entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
      linkItem = new StaticTextItem_1('link' + i);
      $setTitle_1(linkItem, ($clinit_Enhanced() , '\u30EA\u30F3\u30AF'));
      $setValue_7(linkItem, '<a href="' + dynamicCast(entry.getValue_1(), Q$String) + '">' + dynamicCast(entry.getKey_0(), Q$String) + '<\/a>');
      setCheck(items, i++, linkItem);
    }
    spacerItem = new SpacerItem_1('spacer');
    $isCreated_2(spacerItem)?$setProperty_7(spacerItem, 'height', 5):(spacerItem.jsObj['height'] = 5 , undefined);
    setCheck(items, i++, spacerItem);
    helpText = new StaticTextItem_1('connectorHelp');
    $isCreated_2(helpText)?$setProperty_7(helpText, 'colSpan', 2):(helpText.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(helpText, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(helpText, $view_admin_downloads_connectors_help(($clinit_Enhanced() , this$static.this$0.productInfo.shortName)));
    setCheck(items, i++, helpText);
    form.setItems(items);
  }
   else {
    item = new StaticTextItem_1('noConnectors');
    $isCreated_2(item)?$setProperty_7(item, 'colSpan', 2):(item.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(item, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(item, ($clinit_Enhanced() , '\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9\u3067\u304D\u308B\u30B3\u30CD\u30AF\u30BF\u30FC\u304C\u3042\u308A\u307E\u305B\u3093'));
    form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [item]));
  }
  $setItems(this$static.this$0.connectorsSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.connectorsSection, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$4_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1681, 1, makeCastMap([Q$AsyncCallback]), DownloadsView$4_0);
_.onFailure = function onFailure_22(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30B3\u30CD\u30AF\u30BF\u30FC\u60C5\u5831\u3092\u53D6\u5F97\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_22(result){
  $onSuccess_22(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_23(this$static, result){
  var entry, entry$iterator, form, helpText, i, item, items, linkItem, spacerItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  if (!!result && result.size_1() != 0) {
    i = 0;
    items = initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, result.size_1() + 2, 0);
    for (entry$iterator = result.entrySet().iterator(); entry$iterator.hasNext();) {
      entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
      linkItem = new StaticTextItem_1('link' + i);
      $setTitle_1(linkItem, ($clinit_Enhanced() , '\u30EA\u30F3\u30AF'));
      $setValue_7(linkItem, '<a href="' + dynamicCast(entry.getValue_1(), Q$String) + '">' + dynamicCast(entry.getKey_0(), Q$String) + '<\/a>');
      setCheck(items, i++, linkItem);
    }
    spacerItem = new SpacerItem_1('spacer');
    $isCreated_2(spacerItem)?$setProperty_7(spacerItem, 'height', 5):(spacerItem.jsObj['height'] = 5 , undefined);
    setCheck(items, i++, spacerItem);
    helpText = new StaticTextItem_1('cliAlertScriptsHelp');
    $isCreated_2(helpText)?$setProperty_7(helpText, 'colSpan', 2):(helpText.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(helpText, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(helpText, ($clinit_Enhanced() , 'CLI \u30A2\u30E9\u30FC\u30C8\u30B9\u30AF\u30EA\u30D7\u30C8\u306F\u30B9\u30AF\u30EA\u30D7\u30C8\u5316\u3055\u308C\u305F\u30A2\u30E9\u30FC\u30C8\u901A\u77E5\u306E\u4F5C\u6210\u306B\u4F7F\u7528\u3067\u304D\u308B\u3001\u4E8B\u524D\u4F5C\u6210\u3055\u308C\u305F\u30B9\u30AF\u30EA\u30D7\u30C8\u3067\u3059\u3002\u901A\u5E38\u3001\u7279\u5B9A\u306E\u30A2\u30E9\u30FC\u30C8\u5B9A\u7FA9\u306E\u901A\u77E5\u3068\u3057\u3066\u4F7F\u7528\u3059\u308B\u524D\u306B\u3001\u3053\u306E\u30B9\u30AF\u30EA\u30D7\u30C8\u3092\u5FAE\u8ABF\u6574\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059\u3002'));
    setCheck(items, i++, helpText);
    form.setItems(items);
  }
   else {
    item = new StaticTextItem_1('noCliAlertScripts');
    $isCreated_2(item)?$setProperty_7(item, 'colSpan', 2):(item.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(item, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(item, ($clinit_Enhanced() , '\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9\u3067\u304D\u308B\u5229\u7528\u53EF\u80FD\u306A CLI \u30A2\u30E9\u30FC\u30C8\u30B9\u30AF\u30EA\u30D7\u30C8\u306F\u3042\u308A\u307E\u305B\u3093'));
    form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [item]));
  }
  $setItems(this$static.this$0.cliAlertScriptsSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.cliAlertScriptsSection, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1682, 1, makeCastMap([Q$AsyncCallback]), DownloadsView$5_0);
_.onFailure = function onFailure_23(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9\u3067\u304D\u308B\u5229\u7528\u53EF\u80FD\u306A CLI \u30A2\u30E9\u30FC\u30C8\u30B9\u30AF\u30EA\u30D7\u30C8\u306E\u60C5\u5831\u3092\u53D6\u5F97\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_23(result){
  $onSuccess_23(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_24(this$static, result){
  var entry, entry$iterator, form, helpText, i, item, items, linkItem, spacerItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  if (!!result && result.size_1() != 0) {
    i = 0;
    items = initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, result.size_1() + 2, 0);
    for (entry$iterator = result.entrySet().iterator(); entry$iterator.hasNext();) {
      entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
      linkItem = new StaticTextItem_1('link' + i);
      $setTitle_1(linkItem, ($clinit_Enhanced() , '\u30EA\u30F3\u30AF'));
      $setValue_7(linkItem, '<a href="' + dynamicCast(entry.getValue_1(), Q$String) + '">' + dynamicCast(entry.getKey_0(), Q$String) + '<\/a>');
      setCheck(items, i++, linkItem);
    }
    spacerItem = new SpacerItem_1('spacer');
    $isCreated_2(spacerItem)?$setProperty_7(spacerItem, 'height', 5):(spacerItem.jsObj['height'] = 5 , undefined);
    setCheck(items, i++, spacerItem);
    helpText = new StaticTextItem_1('scriptModulesHelp');
    $isCreated_2(helpText)?$setProperty_7(helpText, 'colSpan', 2):(helpText.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(helpText, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(helpText, ($clinit_Enhanced() , '<p> \u30B9\u30AF\u30EA\u30D7\u30C8\u30E2\u30B8\u30E5\u30FC\u30EB\u306F RHQ \u306B\u3088\u3063\u3066\u63D0\u4F9B\u3055\u308C\u308B\u518D\u4F7F\u7528\u53EF\u80FD\u306A\u30B3\u30F3\u30DD\u30FC\u30CD\u30F3\u30C8\u3067\u3001\u30B9\u30AF\u30EA\u30D7\u30C8\u3067\u4F7F\u7528\u3057\u307E\u3059 (\u30A2\u30E9\u30FC\u30C8\u30B9\u30AF\u30EA\u30D7\u30C8\u307E\u305F\u306F CLI \u30B9\u30AF\u30EA\u30D7\u30C8)\u3002\u5E0C\u671B\u306E\u30B9\u30AF\u30EA\u30D7\u30C8\u8A00\u8A9E\u3067 "rhq://downloads/&lt;module-name-without-file-extension&gt;" URI \u3092\u4F7F\u7528\u3057\u3066\u30A2\u30AF\u30BB\u30B9\u3057\u307E\u3059 (\u305F\u3068\u3048\u3070\u3001javascript \u3067 "require" \u95A2\u6570\u3092\u4F7F\u7528\u3057\u307E\u3059)\u3002<\/p>'));
    setCheck(items, i++, helpText);
    form.setItems(items);
  }
   else {
    item = new StaticTextItem_1('noScriptModules');
    $isCreated_2(item)?$setProperty_7(item, 'colSpan', 2):(item.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(item, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(item, ($clinit_Enhanced() , '\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9\u3067\u304D\u308B\u30B9\u30AF\u30EA\u30D7\u30C8\u30E2\u30B8\u30E5\u30FC\u30EB\u306F\u3042\u308A\u307E\u305B\u3093'));
    form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [item]));
  }
  $setItems(this$static.this$0.scriptModulesSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.scriptModulesSection, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$6_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1683, 1, makeCastMap([Q$AsyncCallback]), DownloadsView$6_0);
_.onFailure = function onFailure_24(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u4F7F\u7528\u53EF\u80FD\u306A\u30B9\u30AF\u30EA\u30D7\u30C8\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u30EA\u30B9\u30C8\u3092\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_24(result){
  $onSuccess_24(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function EnhancedVStack_0(){
  $clinit_BaseWidget();
  VStack_0.call(this);
}

function EnhancedVStack_1(){
  Layout_0.call(this);
  $isCreated_1(this)?$setProperty_1(this, 'membersMargin', 6):(this.config_0['membersMargin'] = 6 , undefined);
  this.scClassName = 'VStack';
}

defineSeed(1685, 576, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$Enhanced]), EnhancedVStack_1);
_.destroy_0 = function destroy_4(){
  destroyMembers(this);
  $destroy(this);
}
;
function $getControlDefinition(this$static, controlName){
  var def, def$iterator;
  for (def$iterator = new AbstractList$IteratorImpl_0(this$static.controlDefinitions); def$iterator.i < def$iterator.this$0_0.size_1();) {
    def = dynamicCast($next_0(def$iterator), Q$ServerPluginControlDefinition);
    if ($equals_6(def.name_0, controlName)) {
      return def;
    }
  }
  return null;
}

function $getParameters(this$static){
  if (this$static.selectedParamsDef) {
    if (!$validate_4(this$static.selectedParamsEditor)) {
      throw new IllegalStateException_0;
    }
    return this$static.selectedParamsEditor.configuration;
  }
  return null;
}

function $showParameters(this$static){
  var config, paramsCanvas, paramsForm;
  destroyMembers(this$static.paramsLayout);
  if (this$static.selectedParamsDef) {
    $setAttribute_24(this$static.paramsLayout, 'visibility', ($clinit_Visibility() , INHERIT).value_0, true);
    config = new Configuration_0;
    this$static.selectedParamsEditor = new ConfigurationEditor_1(this$static.selectedParamsDef, config);
    $setAutoHeight(this$static.selectedParamsEditor);
    paramsForm = new DynamicForm_0;
    $isCreated_1(paramsForm)?$setProperty_4(paramsForm, 'width', '100%'):(paramsForm.config_0['width'] = '100%' , undefined);
    $setIsGroup(paramsForm, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    $setGroupTitle(paramsForm, ($clinit_Enhanced() , '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC'));
    paramsCanvas = new CanvasItem_1('paramsCanvas');
    paramsCanvas.setShowTitle(FALSE);
    $isCreated_2(paramsCanvas)?$setProperty_7(paramsCanvas, 'colSpan', 2):(paramsCanvas.jsObj['colSpan'] = 2 , undefined);
    $setCanvas(paramsCanvas, this$static.selectedParamsEditor);
    paramsForm.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [paramsCanvas]));
    $addMember(this$static.paramsLayout, paramsForm);
  }
   else {
    $setAttribute_24(this$static.paramsLayout, 'visibility', ($clinit_Visibility() , HIDDEN_0).value_0, true);
  }
  return;
}

function $showResults(this$static, results){
  var editor, formItems, paramsCanvas, resultsForm, statusItem;
  destroyMembers(this$static.resultsLayout);
  resultsForm = new DynamicForm_0;
  $isCreated_1(resultsForm)?$setProperty_4(resultsForm, 'width', '100%'):(resultsForm.config_0['width'] = '100%' , undefined);
  $setIsGroup(resultsForm, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setGroupTitle(resultsForm, ($clinit_Enhanced() , '\u7D50\u679C'));
  formItems = new ArrayList_1(3);
  statusItem = new StaticTextItem_2('status', '\u30B9\u30C6\u30FC\u30BF\u30B9');
  $setValue_7(statusItem, imgHTML(getAvailabilityIcon(results.errorMessage_0 == null?TRUE:FALSE)));
  formItems.add_0(statusItem);
  if (results.errorMessage_0 != null) {
    $setPrompt_1(statusItem, '\u30A8\u30E9\u30FC\u30E1\u30C3\u30BB\u30FC\u30B8\u3092\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u304F\u3060\u3055\u3044');
    statusItem.addClickHandler(new ServerPluginControlView$3_0(results));
  }
  if (!!this$static.selectedResultsDef && !!results.complexResults) {
    editor = new ConfigurationEditor_1(this$static.selectedResultsDef, results.complexResults);
    editor.readOnly = true;
    $isCreated_1(editor)?$setProperty_1(editor, 'height', 1):(editor.config_0['height'] = 1 , undefined);
    paramsCanvas = new CanvasItem_1('resultsCanvas');
    paramsCanvas.setShowTitle(FALSE);
    $isCreated_2(paramsCanvas)?$setProperty_7(paramsCanvas, 'colSpan', 2):(paramsCanvas.jsObj['colSpan'] = 2 , undefined);
    $setAttribute_28(paramsCanvas, 'canvas', !editor?null:$getOrCreateJsObj_0(editor));
    formItems.add_0(paramsCanvas);
  }
  resultsForm.setItems(dynamicCast($toArray_1(formItems, initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, 0, 0)), Q$FormItem_$1));
  $addMember(this$static.resultsLayout, resultsForm);
  $setAttribute_24(this$static.resultsLayout, 'visibility', ($clinit_Visibility() , INHERIT).value_0, true);
  return;
}

function ServerPluginControlView_0(plugin, controlDefs){
  $clinit_BaseWidget();
  EnhancedVStack_0.call(this);
  this.plugin = plugin;
  this.controlDefinitions = controlDefs;
  $isCreated_1(this)?$setProperty_1(this, 'height', 1):(this.config_0['height'] = 1 , undefined);
  $setMargin(this, valueOf_49(5));
}

defineSeed(1684, 1685, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$Enhanced]), ServerPluginControlView_0);
_.onDraw_0 = function onDraw_5(){
  var controlNames, controlNamesItem, def, def$iterator, executeButton, form, retStr;
  form = new DynamicForm_0;
  $addMember(this, form);
  this.paramsLayout = new EnhancedVLayout_0;
  $setAttribute_24(this.paramsLayout, 'visibility', ($clinit_Visibility() , HIDDEN_0).value_0, true);
  $addMember(this, this.paramsLayout);
  this.resultsLayout = new EnhancedVLayout_0;
  $setAttribute_24(this.resultsLayout, 'visibility', HIDDEN_0.value_0, true);
  $addMember(this, this.resultsLayout);
  executeButton = new FormItemIcon_0;
  executeButton.jsObj['name'] = 'execute';
  executeButton.jsObj['src'] = 'subsystems/control/Operation_16.png';
  $setAttribute_13(executeButton, 'prompt', ($clinit_Enhanced() , '\u5B9F\u884C'));
  controlNamesItem = new SortedSelectItem_2('controlMenu', '\u30B3\u30F3\u30C8\u30ED\u30FC\u30EB');
  controlNames = new LinkedHashMap_0;
  for (def$iterator = new AbstractList$IteratorImpl_0(this.controlDefinitions); def$iterator.i < def$iterator.this$0_0.size_1();) {
    def = dynamicCast($next_0(def$iterator), Q$ServerPluginControlDefinition);
    $put_1(controlNames, def.name_0, (retStr = def.displayName , retStr == null && (retStr = deCamelCase(def.name_0)) , retStr));
  }
  $setValueMap_1(controlNamesItem, controlNames);
  $isCreated_2(controlNamesItem)?$setProperty_7(controlNamesItem, 'width', 300):(controlNamesItem.jsObj['width'] = 300 , undefined);
  $addChangedHandler(controlNamesItem, new ServerPluginControlView$1_0(this, controlNamesItem, executeButton));
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [controlNamesItem]));
  $addFormItemClickHandler(executeButton, new ServerPluginControlView$2_0(this));
}
;
_.controlDefinitions = null;
_.paramsLayout = null;
_.plugin = null;
_.resultsLayout = null;
_.selectedControlName = null;
_.selectedParamsDef = null;
_.selectedParamsEditor = null;
_.selectedResultsDef = null;
function ServerPluginControlView$1_0(this$0, val$controlNamesItem, val$executeButton){
  this.this$0 = this$0;
  this.val$controlNamesItem = val$controlNamesItem;
  this.val$executeButton = val$executeButton;
}

defineSeed(1686, 1, makeCastMap([Q$EventHandler, Q$ChangedHandler]), ServerPluginControlView$1_0);
_.onChanged = function onChanged(event_0){
  var def;
  this.this$0.selectedControlName = dynamicCast($getValue_2(event_0), Q$String);
  def = $getControlDefinition(this.this$0, this.this$0.selectedControlName);
  this.this$0.selectedParamsDef = def.parameters;
  this.this$0.selectedResultsDef = def.results;
  destroyMembers(this.this$0.resultsLayout);
  $setAttribute_24(this.this$0.resultsLayout, 'visibility', ($clinit_Visibility() , HIDDEN_0).value_0, true);
  $showParameters(this.this$0);
  !$getIcon(this.val$controlNamesItem, $getAttributeAsString(this.val$executeButton, 'name')) && $setIcons(this.val$controlNamesItem, initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItemIcon_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItemIcon, [this.val$executeButton]));
}
;
_.this$0 = null;
_.val$controlNamesItem = null;
_.val$executeButton = null;
function ServerPluginControlView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1687, 1, makeCastMap([Q$EventHandler, Q$FormItemClickHandler]), ServerPluginControlView$2_0);
_.onFormItemClick = function onFormItemClick(event_0){
  var $e0, msg, params, pluginKey, pm;
  try {
    params = $getParameters(this.this$0);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$IllegalStateException)) {
      msg = new Message_8(($clinit_Enhanced() , '\u6B63\u3057\u3044\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u5165\u529B\u3057\u3066\u304F\u3060\u3055\u3044'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
      $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
      return;
    }
     else 
      throw $e0;
  }
  pm = dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync);
  pluginKey = createServerPluginKey(this.this$0.plugin.type_0, this.this$0.plugin.name_0);
  $invokeServerPluginControl(pm, pluginKey, this.this$0.selectedControlName, params, new ServerPluginControlView$2$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_25(this$static, results){
  $showResults(this$static.this$1.this$0, results);
}

function ServerPluginControlView$2$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1688, 1, makeCastMap([Q$AsyncCallback]), ServerPluginControlView$2$1_0);
_.onFailure = function onFailure_25(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30B3\u30F3\u30C8\u30ED\u30FC\u30EB\u306E\u547C\u3073\u51FA\u3057\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_25(results){
  $onSuccess_25(this, dynamicCast(results, Q$ServerPluginControlResults));
}
;
_.this$1 = null;
function ServerPluginControlView$3_0(val$results){
  this.val$results = val$results;
}

defineSeed(1689, 1, makeCastMap([Q$EventHandler, Q$ClickHandler_0]), ServerPluginControlView$3_0);
_.onClick_0 = function onClick_5(event_0){
  var win;
  win = new ErrorMessageWindow_1(($clinit_Enhanced() , '\u30A8\u30E9\u30FC'), this.val$results.errorMessage_0);
  $show(win);
}
;
_.val$results = null;
function $prepareControlsSection(this$static, plugin){
  var pluginKey;
  pluginKey = createServerPluginKey(plugin.type_0, plugin.name_0);
  $getServerPluginControlDefinitions(this$static.pluginManager, pluginKey, new ServerPluginDetailView$3_0(this$static, plugin));
}

function $prepareDetailsSection_0(this$static, plugin){
  var ampsItem, descItem, displayNameItem, enabledItem, form, img, kindItem, md5Item, mtimeItem, nameItem, pathItem, section, typeItem, versionItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_49(10));
  $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  $setWrapItemTitles(form, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $isCreated_1(form)?$setProperty_1(form, 'numCols', 4):(form.config_0['numCols'] = 4 , undefined);
  nameItem = new StaticTextItem_2('name', ($clinit_Enhanced() , '\u540D\u524D'));
  $setValue_7(nameItem, plugin.name_0);
  displayNameItem = new StaticTextItem_2('displayName', '\u8868\u793A\u540D');
  $setValue_7(displayNameItem, plugin.displayName);
  versionItem = new StaticTextItem_2('version', '\u30D0\u30FC\u30B8\u30E7\u30F3');
  $setValue_7(versionItem, plugin.version_0);
  md5Item = new StaticTextItem_2('MD5', 'MD5');
  $setValue_7(md5Item, plugin.md5);
  pathItem = new StaticTextItem_2('path', '\u30D1\u30B9');
  $setValue_7(pathItem, plugin.path);
  ampsItem = new StaticTextItem_2('ampsVersion', 'AMPS \u30D0\u30FC\u30B8\u30E7\u30F3');
  $setValue_7(ampsItem, plugin.ampsVersion);
  descItem = new StaticTextItem_2('desc', '\u8AAC\u660E');
  $setValue_7(descItem, plugin.description);
  mtimeItem = new StaticTextItem_2('mtime', '\u6700\u7D42\u66F4\u65B0');
  $setValue_7(mtimeItem, format_41(valueOf_50(plugin.mtime), ($clinit_TimestampCellFormatter() , DATE_TIME_FORMAT_MEDIUM)));
  kindItem = new StaticTextItem_2('kind', '\u7A2E\u985E');
  switch (plugin.deployment.ordinal) {
    case 0:
      $setValue_7(kindItem, '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8');
      break;
    case 1:
      $setValue_7(kindItem, '\u30B5\u30FC\u30D0\u30FC');
  }
  enabledItem = new CanvasItem_2('enabled', '\u6709\u52B9?');
  img = new Img_2(getAvailabilityIcon(plugin.enabled?TRUE:FALSE), 16, 16);
  $setAttribute_28(enabledItem, 'canvas', !img?null:$getOrCreateJsObj_0(img));
  typeItem = new StaticTextItem_2('type', '\u30BF\u30A4\u30D7');
  $setValue_7(typeItem, plugin.type_0);
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [displayNameItem, nameItem, versionItem, ampsItem, md5Item, kindItem, descItem, pathItem, mtimeItem, enabledItem, typeItem]));
  section = new SectionStackSection_1('\u8A73\u7D30');
  $setExpanded(section, TRUE);
  $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  this$static.detailsSection = section;
  ++this$static.initSectionCount;
  return;
}

function $prepareHelpSection_0(this$static, plugin){
  var help, section;
  if (plugin.help != null && plugin.help.length > 0) {
    section = new SectionStackSection_1(($clinit_Enhanced() , '\u30D8\u30EB\u30D7'));
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    help = new Label_4(plugin.help);
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [help]));
    this$static.helpSection = section;
  }
  ++this$static.initSectionCount;
  return;
}

function $preparePluginConfigurationSection(this$static, plugin){
  var pluginKey;
  pluginKey = createServerPluginKey(plugin.type_0, plugin.name_0);
  $getServerPluginConfigurationDefinition(this$static.pluginManager, pluginKey, new ServerPluginDetailView$4_0(this$static, plugin, pluginKey));
  return;
}

function $prepareScheduledJobsSection(this$static, plugin){
  var pluginKey;
  pluginKey = createServerPluginKey(plugin.type_0, plugin.name_0);
  $getServerPluginScheduledJobsDefinition(this$static.pluginManager, pluginKey, new ServerPluginDetailView$5_0(this$static, plugin, pluginKey));
  return;
}

function ServerPluginDetailView_0(pluginId){
  $clinit_BaseWidget();
  EnhancedVLayout_0.call(this);
  this.pluginManager = dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync);
  this.pluginId = pluginId;
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setAttribute_24(this, 'overflow', ($clinit_Overflow() , AUTO_0).value_0, false);
  this.sectionStack = new SectionStack_0;
  $setAttribute_24(this.sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $setAttribute_24(this.sectionStack, 'width', '100%', true);
  $setAttribute_24(this.sectionStack, 'height', '100%', true);
  $setMargin(this.sectionStack, valueOf_49(5));
  $setAttribute_24(this.sectionStack, 'overflow', VISIBLE.value_0, false);
}

defineSeed(1690, 1653, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced, Q$EnhancedVLayout]), ServerPluginDetailView_0);
_.onDraw_0 = function onDraw_6(){
  $run_0(new ServerPluginDetailView$2_0(this));
}
;
_.onInit = function onInit_10(){
  $onInit(this);
  $onInit_Layout(this);
  $getServerPlugin(this.pluginManager, this.pluginId, new ServerPluginDetailView$1_0(this));
}
;
_.controlsSection = null;
_.detailsSection = null;
_.helpSection = null;
_.initSectionCount = 0;
_.pluginConfigSection = null;
_.pluginId = 0;
_.scheduledJobsSection = null;
_.sectionStack = null;
function $onSuccess_26(this$static, plugin){
  $prepareDetailsSection_0(this$static.this$0, plugin);
  $prepareHelpSection_0(this$static.this$0, plugin);
  $prepareControlsSection(this$static.this$0, plugin);
  $preparePluginConfigurationSection(this$static.this$0, plugin);
  $prepareScheduledJobsSection(this$static.this$0, plugin);
}

function ServerPluginDetailView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1691, 1, makeCastMap([Q$AsyncCallback]), ServerPluginDetailView$1_0);
_.onFailure = function onFailure_26(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_26(plugin){
  $onSuccess_26(this, dynamicCast(plugin, Q$ServerPlugin));
}
;
_.this$0 = null;
function $run_0(this$static){
  var elapsedMillis;
  if (this$static.this$0.initSectionCount >= 5) {
    !!this$static.this$0.detailsSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.detailsSection);
    !!this$static.this$0.helpSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.helpSection);
    !!this$static.this$0.controlsSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.controlsSection);
    !!this$static.this$0.pluginConfigSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.pluginConfigSection);
    !!this$static.this$0.scheduledJobsSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.scheduledJobsSection);
    $addMember(this$static.this$0, this$static.this$0.sectionStack);
    $markForRedraw(this$static.this$0);
  }
   else {
    elapsedMillis = sub(fromDouble(currentTimeMillis0()), this$static.startTime);
    gt(elapsedMillis, P4e20_longLit) && (this$static.this$0.initSectionCount = 5);
    $schedule(this$static, 100);
  }
}

function ServerPluginDetailView$2_0(this$0){
  $clinit_Timer();
  this.this$0 = this$0;
  this.startTime = fromDouble(currentTimeMillis0());
}

defineSeed(1692, 74, makeCastMap([Q$Timer]), ServerPluginDetailView$2_0);
_.run = function run_4(){
  $run_0(this);
}
;
_.this$0 = null;
function $onSuccess_27(this$static, result){
  var section;
  if (!!result && result.size_0 != 0) {
    section = new SectionStackSection_1(($clinit_Enhanced() , '\u30B3\u30F3\u30C8\u30ED\u30FC\u30EB'));
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $addItemJS(section, $getOrCreateJsObj_0(new ServerPluginControlView_0(this$static.val$plugin, result)));
    this$static.this$0.controlsSection = section;
  }
  ++this$static.this$0.initSectionCount;
}

function ServerPluginDetailView$3_0(this$0, val$plugin){
  this.this$0 = this$0;
  this.val$plugin = val$plugin;
}

defineSeed(1693, 1, makeCastMap([Q$AsyncCallback]), ServerPluginDetailView$3_0);
_.onFailure = function onFailure_27(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_27(result){
  $onSuccess_27(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$0 = null;
_.val$plugin = null;
function $onSuccess_28(this$static, def){
  var buttons, config, editorPC, layout, resetButtonPC, saveButtonPC, section;
  if (def) {
    layout = new EnhancedVLayout_0;
    buttons = new ToolStrip_0;
    $isCreated_1(buttons)?$setProperty_4(buttons, 'width', '100%'):(buttons.config_0['width'] = '100%' , undefined);
    $isCreated_1(buttons)?undefined:(buttons.config_0['extraSpace'] = 10 , undefined);
    $isCreated_1(buttons)?$setProperty_1(buttons, 'membersMargin', 5):(buttons.config_0['membersMargin'] = 5 , undefined);
    $setLayoutMargin(buttons, valueOf_49(5));
    saveButtonPC = new EnhancedIButton_1(($clinit_Enhanced() , '\u4FDD\u5B58'));
    resetButtonPC = new EnhancedIButton_1('\u30EA\u30BB\u30C3\u30C8');
    config = this$static.val$plugin.pluginConfiguration;
    editorPC = new ConfigurationEditor_1(def, config);
    $setAttribute_24(editorPC, 'overflow', ($clinit_Overflow() , AUTO_0).value_0, false);
    $addPropertyValueChangeListener(editorPC, new ServerPluginDetailView$4$1_0(saveButtonPC));
    $addClickHandler(resetButtonPC, new ServerPluginDetailView$4$2_0(editorPC));
    $addClickHandler(saveButtonPC, new ServerPluginDetailView$4$3_0(this$static, editorPC, this$static.val$pluginKey));
    $addMember(buttons, saveButtonPC);
    $addMember(buttons, resetButtonPC);
    $addMember(layout, buttons);
    $addMember(layout, editorPC);
    section = new SectionStackSection_1('\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u8A2D\u5B9A');
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [layout]));
    this$static.this$0.pluginConfigSection = section;
  }
  ++this$static.this$0.initSectionCount;
}

function ServerPluginDetailView$4_0(this$0, val$plugin, val$pluginKey){
  this.this$0 = this$0;
  this.val$plugin = val$plugin;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1694, 1, makeCastMap([Q$AsyncCallback]), ServerPluginDetailView$4_0);
_.onFailure = function onFailure_28(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_28(def){
  $onSuccess_28(this, dynamicCast(def, Q$ConfigurationDefinition));
}
;
_.this$0 = null;
_.val$plugin = null;
_.val$pluginKey = null;
function ServerPluginDetailView$4$1_0(val$saveButtonPC){
  this.val$saveButtonPC = val$saveButtonPC;
}

defineSeed(1695, 1, makeCastMap([Q$PropertyValueChangeListener]), ServerPluginDetailView$4$1_0);
_.propertyValueChanged = function propertyValueChanged(event_0){
  var invalidPropertyNames;
  if (event_0.invalidPropertySetChanged) {
    invalidPropertyNames = event_0.invalidPropertyNames;
    invalidPropertyNames.size_1() == 0?$enable(this.val$saveButtonPC):$disable(this.val$saveButtonPC);
  }
}
;
_.val$saveButtonPC = null;
function ServerPluginDetailView$4$2_0(val$editorPC){
  this.val$editorPC = val$editorPC;
}

defineSeed(1696, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$4$2_0);
_.onClick = function onClick_6(event_0){
  $reset_2(this.val$editorPC);
}
;
_.val$editorPC = null;
function ServerPluginDetailView$4$3_0(this$1, val$editorPC, val$pluginKey){
  this.this$1 = this$1;
  this.val$editorPC = val$editorPC;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1697, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$4$3_0);
_.onClick = function onClick_7(event_0){
  var msg;
  if (!$validate_4(this.val$editorPC)) {
    msg = new Message_8(($clinit_Enhanced() , '\u6B63\u3057\u3044\u8A2D\u5B9A\u3092\u5165\u529B\u3057\u3066\u304F\u3060\u3055\u3044'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
    return;
  }
  $updateServerPluginConfiguration(this.this$1.this$0.pluginManager, this.val$pluginKey, this.val$editorPC.configuration, new ServerPluginDetailView$4$3$1_0);
}
;
_.this$1 = null;
_.val$editorPC = null;
_.val$pluginKey = null;
function $onSuccess_29(){
  var m_0;
  m_0 = new Message_0(($clinit_Enhanced() , '\u8A2D\u5B9A\u304C\u4FDD\u5B58\u3055\u308C\u307E\u3057\u305F'));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), m_0);
}

function ServerPluginDetailView$4$3$1_0(){
}

defineSeed(1698, 1, makeCastMap([Q$AsyncCallback]), ServerPluginDetailView$4$3$1_0);
_.onFailure = function onFailure_29(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u8A2D\u5B9A\u306E\u4FDD\u5B58\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_29(result){
  $onSuccess_29(throwClassCastExceptionUnlessNull(result));
}
;
function $onSuccess_30(this$static, def){
  var buttons, config, editorSJ, layout, resetButtonSJ, saveButtonSJ, section;
  if (def) {
    layout = new EnhancedVLayout_0;
    buttons = new ToolStrip_0;
    $isCreated_1(buttons)?$setProperty_4(buttons, 'width', '100%'):(buttons.config_0['width'] = '100%' , undefined);
    $isCreated_1(buttons)?undefined:(buttons.config_0['extraSpace'] = 10 , undefined);
    $isCreated_1(buttons)?$setProperty_1(buttons, 'membersMargin', 5):(buttons.config_0['membersMargin'] = 5 , undefined);
    $setLayoutMargin(buttons, valueOf_49(5));
    saveButtonSJ = new EnhancedIButton_1(($clinit_Enhanced() , '\u4FDD\u5B58'));
    $addMember(buttons, saveButtonSJ);
    resetButtonSJ = new EnhancedIButton_1('\u30EA\u30BB\u30C3\u30C8');
    $addMember(buttons, resetButtonSJ);
    config = this$static.val$plugin.scheduledJobsConfiguration;
    editorSJ = new ConfigurationEditor_1(def, config);
    $setAttribute_24(editorSJ, 'overflow', ($clinit_Overflow() , AUTO_0).value_0, false);
    $addPropertyValueChangeListener(editorSJ, new ServerPluginDetailView$5$1_0(saveButtonSJ));
    $addClickHandler(resetButtonSJ, new ServerPluginDetailView$5$2_0(editorSJ));
    $addClickHandler(saveButtonSJ, new ServerPluginDetailView$5$3_0(this$static, editorSJ, this$static.val$pluginKey));
    $addMember(layout, buttons);
    $addMember(layout, editorSJ);
    section = new SectionStackSection_1('\u30B9\u30B1\u30B8\u30E5\u30FC\u30EB\u3055\u308C\u305F\u30B8\u30E7\u30D6');
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [layout]));
    this$static.this$0.scheduledJobsSection = section;
  }
  ++this$static.this$0.initSectionCount;
}

function ServerPluginDetailView$5_0(this$0, val$plugin, val$pluginKey){
  this.this$0 = this$0;
  this.val$plugin = val$plugin;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1699, 1, makeCastMap([Q$AsyncCallback]), ServerPluginDetailView$5_0);
_.onFailure = function onFailure_30(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_30(def){
  $onSuccess_30(this, dynamicCast(def, Q$ConfigurationDefinition));
}
;
_.this$0 = null;
_.val$plugin = null;
_.val$pluginKey = null;
function ServerPluginDetailView$5$1_0(val$saveButtonSJ){
  this.val$saveButtonSJ = val$saveButtonSJ;
}

defineSeed(1700, 1, makeCastMap([Q$PropertyValueChangeListener]), ServerPluginDetailView$5$1_0);
_.propertyValueChanged = function propertyValueChanged_0(event_0){
  var invalidPropertyNames;
  if (event_0.invalidPropertySetChanged) {
    invalidPropertyNames = event_0.invalidPropertyNames;
    invalidPropertyNames.size_1() == 0?$enable(this.val$saveButtonSJ):$disable(this.val$saveButtonSJ);
  }
}
;
_.val$saveButtonSJ = null;
function ServerPluginDetailView$5$2_0(val$editorSJ){
  this.val$editorSJ = val$editorSJ;
}

defineSeed(1701, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$5$2_0);
_.onClick = function onClick_8(event_0){
  $reset_2(this.val$editorSJ);
}
;
_.val$editorSJ = null;
function ServerPluginDetailView$5$3_0(this$1, val$editorSJ, val$pluginKey){
  this.this$1 = this$1;
  this.val$editorSJ = val$editorSJ;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1702, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$5$3_0);
_.onClick = function onClick_9(event_0){
  var msg;
  if (!$validate_4(this.val$editorSJ)) {
    msg = new Message_8(($clinit_Enhanced() , '\u6B63\u3057\u3044\u8A2D\u5B9A\u3092\u5165\u529B\u3057\u3066\u304F\u3060\u3055\u3044'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
    return;
  }
  $updateServerPluginScheduledJobs(this.this$1.this$0.pluginManager, this.val$pluginKey, this.val$editorSJ.configuration, new ServerPluginDetailView$5$3$1_0);
}
;
_.this$1 = null;
_.val$editorSJ = null;
_.val$pluginKey = null;
function $onSuccess_31(){
  var m_0;
  m_0 = new Message_0(($clinit_Enhanced() , '\u8A2D\u5B9A\u304C\u4FDD\u5B58\u3055\u308C\u307E\u3057\u305F'));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), m_0);
}

function ServerPluginDetailView$5$3$1_0(){
}

defineSeed(1703, 1, makeCastMap([Q$AsyncCallback]), ServerPluginDetailView$5$3$1_0);
_.onFailure = function onFailure_31(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u8A2D\u5B9A\u306E\u4FDD\u5B58\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_31(result){
  $onSuccess_31(throwClassCastExceptionUnlessNull(result));
}
;
function $clinit_ServerPluginTableView(){
  $clinit_ServerPluginTableView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_2 = new ViewName_2('ServerPlugins', ($clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3'), ($clinit_IconEnum() , PLUGIN_0));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_2;
}

function $getSelectedIds_0(selections){
  var i, ids, selection, selection$index, selection$max;
  if (selections == null) {
    return initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, 0, 1);
  }
  ids = initDim(_3I_classLit, makeCastMap([Q$int_$1, Q$Serializable, Q$Cloneable]), -1, selections.length, 1);
  i = 0;
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    ids[i++] = getAttributeAsInt(selection.jsObj, 'id').value_0;
  }
  return ids;
}

function $getSelectedNames_0(selections){
  var ids, selection, selection$index, selection$max;
  if (selections == null) {
    return new ArrayList_1(0);
  }
  ids = new ArrayList_1(selections.length);
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    ids.add_0(getAttribute(selection.jsObj, 'name'));
  }
  return ids;
}

function ServerPluginTableView_0(){
  $clinit_ServerPluginTableView();
  TableSection_0.call(this, null);
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setDataSource(this, new ServerPluginTableView$ServerPluginDataSource_0(this));
}

defineSeed(1704, 1656, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]), ServerPluginTableView_0);
_.configureTable = function configureTable_2(){
  var fields, listGrid, pluginUploadForm, restartMasterPCButton, scanForUpdatesButton, showUndeployedButton;
  fields = $getListGridFields_0(dynamicCast(this.dataSource_1, Q$ServerPluginTableView$ServerPluginDataSource));
  listGrid = this.listGrid;
  $setFields_1(listGrid, dynamicCast($toArray_1(fields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.size_0, 0)), Q$ListGridField_$1));
  $sort(listGrid, 'name', ($clinit_SortDirection() , ASCENDING));
  $addTableAction(this, ($clinit_Enhanced() , '\u6709\u52B9'), '\u3088\u308D\u3057\u3044\u3067\u3059\u304B?', null, new ServerPluginTableView$1_0(this, this, ($clinit_TableActionEnablement() , ANY_1), initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [($clinit_Permission() , MANAGE_SETTINGS)])));
  $addTableAction(this, '\u7121\u52B9', null, null, new ServerPluginTableView$2_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, '\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4', null, null, new ServerPluginTableView$3_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, '\u30D1\u30FC\u30B8', '\u3088\u308D\u3057\u3044\u3067\u3059\u304B?', null, new ServerPluginTableView$4_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  scanForUpdatesButton = new EnhancedIButton_1('\u66F4\u65B0\u306E\u30B9\u30AD\u30E3\u30F3');
  $addClickHandler(scanForUpdatesButton, new ServerPluginTableView$5_0(this));
  restartMasterPCButton = new EnhancedIButton_1('\u30DE\u30B9\u30BF\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u30B3\u30F3\u30C6\u30CA\u306E\u518D\u8D77\u52D5');
  $addClickHandler(restartMasterPCButton, new ServerPluginTableView$6_0(this));
  showUndeployedButton = new EnhancedIButton_1('\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u3092\u8868\u793A');
  $addClickHandler(showUndeployedButton, new ServerPluginTableView$7_0(this, showUndeployedButton));
  pluginUploadForm = new PluginFileUploadForm_0('\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30A2\u30C3\u30D7\u30ED\u30FC\u30C9');
  this.extraWidgetsAboveFooter.add_0(scanForUpdatesButton);
  this.extraWidgetsAboveFooter.add_0(restartMasterPCButton);
  this.extraWidgetsAboveFooter.add_0(showUndeployedButton);
  this.extraWidgetsAboveFooter.add_0(pluginUploadForm);
  $configureTable(this);
}
;
_.getDetailsView_0 = function getDetailsView_1(id){
  return new ServerPluginDetailView_0(id.value_0);
}
;
_.showUndeployed = false;
var VIEW_ID_2;
function ServerPluginTableView$1_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1705, 1660, {}, ServerPluginTableView$1_0);
_.executeAction = function executeAction_3(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds_0(selections);
  $enableServerPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$1$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_32(this$static, result){
  var msg;
  msg = new Message_7('\u6709\u52B9\u5316\u3055\u308C\u305F\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$1$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1706, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$1$1_0);
_.onFailure = function onFailure_32(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u3092\u6709\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_32(result){
  $onSuccess_32(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function ServerPluginTableView$2_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1707, 1660, {}, ServerPluginTableView$2_0);
_.executeAction = function executeAction_4(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames_0(selections);
  message = '<b>\u8B66\u544A!<\/b><br/>\n\u6B21\u306E\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u304C\u7121\u52B9\u306B\u306A\u308A\u307E\u3059:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\n\u672C\u5F53\u306B\u3053\u308C\u3089\u3092\u7121\u52B9\u306B\u3057\u3066\u3082\u3088\u308D\u3057\u3044\u3067\u3059\u304B?';
  ask(message, new ServerPluginTableView$2$1_0(this, selections));
}
;
_.this$0 = null;
function ServerPluginTableView$2$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1708, 1, {}, ServerPluginTableView$2$1_0);
_.execute_3 = function execute_13(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds_0(this.val$selections);
    $disableServerPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$2$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_33(this$static, result){
  var msg;
  msg = new Message_7('\u7121\u52B9\u5316\u3055\u308C\u305F\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function ServerPluginTableView$2$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1709, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$2$1$1_0);
_.onFailure = function onFailure_33(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u3092\u7121\u52B9\u306B\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\u3002') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_33(result){
  $onSuccess_33(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function ServerPluginTableView$3_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1710, 1660, {}, ServerPluginTableView$3_0);
_.executeAction = function executeAction_5(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames_0(selections);
  message = '<b>\u8B66\u544A!<\/b><br/>\n\u6B21\u306E\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u304C\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u3055\u308C\u307E\u3059:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\n\u672C\u5F53\u306B\u3053\u308C\u3089\u3092\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u3057\u3066\u3082\u3088\u308D\u3057\u3044\u3067\u3059\u304B?';
  ask(message, new ServerPluginTableView$3$1_0(this, selections));
}
;
_.this$0 = null;
function ServerPluginTableView$3$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1711, 1, {}, ServerPluginTableView$3$1_0);
_.execute_3 = function execute_14(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds_0(this.val$selections);
    $undeployServerPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$3$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_34(this$static, result){
  var msg;
  msg = new Message_7('\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u6E08\u307F\u306E\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function ServerPluginTableView$3$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1712, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$3$1$1_0);
_.onFailure = function onFailure_34(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_34(result){
  $onSuccess_34(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function ServerPluginTableView$4_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1713, 1660, {}, ServerPluginTableView$4_0);
_.executeAction = function executeAction_6(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds_0(selections);
  $purgeServerPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$4$1_0(this));
}
;
_.isEnabled_0 = function isEnabled_3(selection){
  return this.this$0.showUndeployed && $isEnabled_0(this, selection);
}
;
_.this$0 = null;
function $onSuccess_35(this$static, result){
  var msg;
  msg = new Message_7('\u30D1\u30FC\u30B8\u3055\u308C\u305F\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$4$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1714, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$4$1_0);
_.onFailure = function onFailure_35(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30D1\u30FC\u30B8\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_35(result){
  $onSuccess_35(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function ServerPluginTableView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1715, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginTableView$5_0);
_.onClick = function onClick_10(event_0){
  $scanAndRegister(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), new ServerPluginTableView$5$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_36(this$static){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , '\u66F4\u65B0\u3055\u308C\u305F\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u305F\u3081\u306E\u30B9\u30AD\u30E3\u30F3\u3092\u5B8C\u4E86\u3057\u307E\u3057\u305F'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$5$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1716, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$5$1_0);
_.onFailure = function onFailure_36(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u66F4\u65B0\u3055\u308C\u305F\u30D7\u30E9\u30B0\u30A4\u30F3\u306E\u30B9\u30AD\u30E3\u30F3\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_36(result){
  $onSuccess_36(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$1 = null;
function ServerPluginTableView$6_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1717, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginTableView$6_0);
_.onClick = function onClick_11(event_0){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , '\u30DE\u30B9\u30BF\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u30B3\u30F3\u30C6\u30CA\u306E\u518D\u8D77\u52D5\u4E2D...'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $restartMasterPluginContainer(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), new ServerPluginTableView$6$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_37(this$static){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , '\u30DE\u30B9\u30BF\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u30B3\u30F3\u30C6\u30CA\u304C\u518D\u8D77\u52D5\u3055\u308C\u307E\u3057\u305F'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$6$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1718, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$6$1_0);
_.onFailure = function onFailure_37(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , '\u30DE\u30B9\u30BF\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3\u30B3\u30F3\u30C6\u30CA\u306E\u518D\u8D77\u52D5\u306B\u5931\u6557\u3057\u307E\u3057\u305F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_37(result){
  $onSuccess_37(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$1 = null;
function ServerPluginTableView$7_0(this$0, val$showUndeployedButton){
  this.this$0 = this$0;
  this.val$showUndeployedButton = val$showUndeployedButton;
}

defineSeed(1719, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginTableView$7_0);
_.onClick = function onClick_12(event_0){
  this.this$0.showUndeployed = !this.this$0.showUndeployed;
  if (this.this$0.showUndeployed) {
    $setTitle_0(this.val$showUndeployedButton, ($clinit_Enhanced() , '\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u3092\u96A0\u3059'));
    $showField(this.this$0.listGrid, 'deployed');
  }
   else {
    $setTitle_0(this.val$showUndeployedButton, ($clinit_Enhanced() , '\u30A2\u30F3\u30C7\u30D7\u30ED\u30A4\u3092\u8868\u793A'));
    $hideField(this.this$0.listGrid, 'deployed');
  }
  $refresh(this.this$0, false);
}
;
_.this$0 = null;
_.val$showUndeployedButton = null;
function $copyValues_0(from){
  var record;
  record = new ListGridRecord_0;
  $setAttribute_3(record, 'id', from.id);
  $setAttribute_13(record, 'name', from.displayName);
  $setAttribute_13(record, 'description', from.description);
  $setAttribute_14(record, 'lastUpdate', new Date_3(from.mtime));
  $setAttribute_13(record, 'enabled', getAvailabilityIcon(($clinit_Boolean() , from.enabled?TRUE:FALSE)));
  $setAttribute_13(record, 'deployed', getAvailabilityIcon(from.status_0 == ($clinit_PluginStatusType() , INSTALLED_3)?TRUE:FALSE));
  $setAttribute_13(record, 'version', from.version_0);
  return record;
}

function $executeFetch_0(this$static, request, response){
  $getServerPlugins(dynamicCast(secure(getInstance_48(), -1), Q$PluginGWTServiceAsync), this$static.this$0.showUndeployed, new ServerPluginTableView$ServerPluginDataSource$1_0(this$static, response, request));
}

function $getListGridFields_0(){
  var deployedField, descriptionField, enabledField, fields, idField, lastUpdateField, nameField, versionField;
  fields = new ArrayList_0;
  idField = new ListGridField_3('id', 'ID');
  idField.jsObj['showIf'] = 'false';
  fields.add_0(idField);
  nameField = new ListGridField_3('name', '\u540D\u524D');
  fields.add_0(nameField);
  descriptionField = new ListGridField_3('description', '\u8AAC\u660E');
  fields.add_0(descriptionField);
  lastUpdateField = new ListGridField_3('lastUpdate', '\u6700\u7D42\u66F4\u65B0');
  $clinit_TimestampCellFormatter();
  prepareDateField(lastUpdateField, getAttribute(lastUpdateField.jsObj, 'name'));
  fields.add_0(lastUpdateField);
  enabledField = new ListGridField_3('enabled', '\u6709\u52B9?');
  $setAttribute_13(enabledField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  $setAttribute_13(enabledField, 'align', ($clinit_Alignment() , CENTER_0).value_0);
  fields.add_0(enabledField);
  deployedField = new ListGridField_3('deployed', '\u30C7\u30D7\u30ED\u30A4\u6E08\u307F?');
  $setAttribute_13(deployedField, 'type', IMAGE_0.value_0);
  $setAttribute_13(deployedField, 'align', CENTER_0.value_0);
  deployedField.jsObj['showIf'] = 'false';
  fields.add_0(deployedField);
  versionField = new ListGridField_3('version', '\u30D0\u30FC\u30B8\u30E7\u30F3');
  versionField.jsObj['showIf'] = 'false';
  fields.add_0(versionField);
  idField.jsObj['width'] = 100;
  nameField.jsObj['width'] = '30%';
  descriptionField.jsObj['width'] = '*';
  lastUpdateField.jsObj['width'] = '20%';
  enabledField.jsObj['width'] = 65;
  deployedField.jsObj['width'] = 75;
  versionField.jsObj['width'] = 100;
  return fields;
}

function ServerPluginTableView$ServerPluginDataSource_0(this$0){
  var fields_0, idField;
  $clinit_RPCDataSource();
  var fields;
  this.this$0 = this$0;
  RPCDataSource_0.call(this);
  fields = (fields_0 = new ArrayList_0 , idField = new DataSourceIntegerField_2('id', 'ID', 50) , $setAttribute_8(idField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setAttribute_8(idField, 'hidden', TRUE) , fields_0.add_0(idField) , fields_0);
  $addFields(this, fields);
}

defineSeed(1720, 1675, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource, Q$ServerPluginTableView$ServerPluginDataSource]), ServerPluginTableView$ServerPluginDataSource_0);
_.copyValues = function copyValues_2(from){
  return null;
}
;
_.copyValues_0 = function copyValues_3(from){
  return $copyValues_0(dynamicCast(from, Q$ServerPlugin));
}
;
_.executeFetch = function executeFetch_0(request, response, criteria){
  $executeFetch_0(this, request, response, dynamicCast(criteria, Q$Criteria));
}
;
_.getFetchCriteria = function getFetchCriteria_0(request){
  return null;
}
;
_.this$0 = null;
function $onFailure(this$static, t){
  $handleError_0(($clinit_CoreGUI() , $clinit_RPCDataSource() , '\u30D7\u30E9\u30B0\u30A4\u30F3\u30C7\u30FC\u30BF\u306E\u30ED\u30FC\u30C9\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), t);
  this$static.val$response.jsObj['status'] = -1;
  $processResponse_0(this$static.this$1, $getAttributeAsString(this$static.val$request, 'requestId'), this$static.val$response);
}

function $onSuccess_38(this$static, result){
  $setAttribute_17(this$static.val$response, 'data', $buildRecords(this$static.this$1, result, true));
  $setTotalRows(this$static.val$response, valueOf_49(result.size_0));
  $processResponse_0(this$static.this$1, $getAttributeAsString(this$static.val$request, 'requestId'), this$static.val$response);
}

function ServerPluginTableView$ServerPluginDataSource$1_0(this$1, val$response, val$request){
  this.this$1 = this$1;
  this.val$response = val$response;
  this.val$request = val$request;
}

defineSeed(1721, 1, makeCastMap([Q$AsyncCallback]), ServerPluginTableView$ServerPluginDataSource$1_0);
_.onFailure = function onFailure_38(t){
  $onFailure(this, t);
}
;
_.onSuccess_0 = function onSuccess_38(result){
  $onSuccess_38(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
_.val$request = null;
_.val$response = null;
function $clinit_SystemSettingsView(){
  $clinit_SystemSettingsView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_3 = new ViewName_2('SystemSettings', ($clinit_Enhanced() , '\u30B7\u30B9\u30C6\u30E0\u8A2D\u5B9A'), ($clinit_IconEnum() , CONFIGURE));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_3;
}

function $convertMillisToDays(num){
  return num == null?'0':'' + toString_8(div(__parseAndValidateLong(num), P5265c00_longLit));
}

function $convertMillisToHours(num){
  return num == null?'0':'' + toString_8(div(__parseAndValidateLong(num), P36ee80_longLit));
}

function $convertMillisToMinutes(num){
  return num == null?'0':'' + toString_8(div(__parseAndValidateLong(num), Pea60_longLit));
}

function $getSystemSettingsDefinition(config, driftPlugins){
  var allDefinitions, baselineGroup, dataManagerGroup, def, defEntry, defEntry$iterator, driftGroup, entry, entry$iterator, generalGroup, ldapGroup, options, pd, prop, prop$array, prop$index, prop$max, propertyDef, propertyName;
  def = new ConfigurationDefinition_1('sysset', ($clinit_Enhanced() , '\u30B7\u30B9\u30C6\u30E0\u8A2D\u5B9A'));
  generalGroup = new PropertyGroupDefinition_1('general');
  generalGroup.displayName = '\u4E00\u822C\u7684\u306A\u8A2D\u5B9A\u30D7\u30ED\u30D1\u30C6\u30A3';
  generalGroup.defaultHidden = false;
  generalGroup.order = 0;
  dataManagerGroup = new PropertyGroupDefinition_1('datamanager');
  dataManagerGroup.displayName = '\u30C7\u30FC\u30BF\u30DE\u30CD\u30FC\u30B8\u30E3\u30FC\u8A2D\u5B9A\u30D7\u30ED\u30D1\u30C6\u30A3';
  dataManagerGroup.defaultHidden = false;
  dataManagerGroup.order = 1;
  baselineGroup = new PropertyGroupDefinition_1('baseline');
  baselineGroup.displayName = '\u81EA\u52D5\u30D9\u30FC\u30B9\u30E9\u30A4\u30F3\u8A2D\u5B9A\u30D7\u30ED\u30D1\u30C6\u30A3';
  baselineGroup.defaultHidden = false;
  baselineGroup.order = 2;
  ldapGroup = new PropertyGroupDefinition_1('ldap');
  ldapGroup.displayName = 'LDAP \u8A2D\u5B9A\u30D7\u30ED\u30D1\u30C6\u30A3';
  $setDefaultHidden(ldapGroup, ($clinit_Boolean() , !$equalsIgnoreCase('true', $getSimpleValue(config, ($clinit_SystemSetting() , LDAP_BASED_JAAS_PROVIDER).internalName, 'false'))));
  ldapGroup.order = 3;
  driftGroup = new PropertyGroupDefinition_1('drift');
  driftGroup.displayName = '\u30C9\u30EA\u30D5\u30C8\u30B5\u30FC\u30D0\u30FC\u8A2D\u5B9A';
  driftGroup.order = 4;
  driftGroup.defaultHidden = false;
  for (prop$array = $VALUES_70 , prop$index = 0 , prop$max = prop$array.length; prop$index < prop$max; ++prop$index) {
    prop = prop$array[prop$index];
    if (prop.readOnly) {
      continue;
    }
    pd = new PropertyDefinitionSimple_1(prop.internalName, null, prop.requiringValue, prop.type_0);
    $put_6(def, pd);
    switch (prop.ordinal) {
      case 0:
        pd.description = '\u30B5\u30FC\u30D0\u30FC GUI \u3078\u306E URL\u3002\u4E3B\u306B\u30A2\u30E9\u30FC\u30C8\u306E\u96FB\u5B50\u30E1\u30FC\u30EB\u901A\u77E5\u5185\u3067\u4F7F\u7528\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, 'GUI \u30B3\u30F3\u30BD\u30FC\u30EB URL');
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'http://localhost:7080';
        break;
      case 1:
        pd.description = '\u3053\u306E\u671F\u9593\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304B\u3089\u901A\u4FE1\u304C\u306A\u304B\u3063\u305F\u5834\u5408\u3001\u901A\u4FE1\u306E\u306A\u304B\u3063\u305F\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306F\u30C0\u30A6\u30F3\u3057\u305F\u3082\u306E\u3068\u307F\u306A\u3055\u308C\u307E\u3059\u3002\u3053\u306E\u5024\u306F\u5206\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u8A31\u5BB9\u3055\u308C\u308B\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u6700\u5927\u7121\u901A\u4FE1\u6642\u9593');
        pd.propertyGroupDefinition = generalGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P3_longLit), null)]));
        pd.defaultValue = '5';
        break;
      case 36:
        pd.description = '\u30D6\u30E9\u30A6\u30B6\u30FC\u3067\u3053\u306E\u671F\u9593\u30E6\u30FC\u30B6\u30FC\u306E\u5BFE\u8A71\u304C\u306A\u3044\u3068\u3001\u30BB\u30C3\u30B7\u30E7\u30F3\u306E\u671F\u9650\u5207\u308C\u3068\u307F\u306A\u3055\u308C\u3001\u30E6\u30FC\u30B6\u30FC\u306F\u518D\u5EA6\u30ED\u30B0\u30A4\u30F3\u3059\u308B\u3088\u3046\u8981\u6C42\u3055\u308C\u307E\u3059\u3002\u3053\u306E\u5024\u306F\u6642\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, 'GUI \u30BB\u30C3\u30B7\u30E7\u30F3\u30BF\u30A4\u30E0\u30A2\u30A6\u30C8');
        pd.propertyGroupDefinition = generalGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '1';
        break;
      case 2:
        pd.description = '\u30B5\u30FC\u30D0\u30FC\u304C\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u81EA\u52D5\u66F4\u65B0\u3092\u8A31\u53EF\u3059\u308B\u304B\u3069\u3046\u304B\u3092\u6C7A\u5B9A\u3057\u307E\u3059\u3002\u7121\u52B9\u306E\u5834\u5408\u3001\u30B5\u30FC\u30D0\u30FC\u304B\u3089\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30C7\u30A3\u30B9\u30C8\u30EA\u30D3\u30E5\u30FC\u30B7\u30E7\u30F3\u3092\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093\u3002';
        $setDisplayName(pd, '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u81EA\u52D5\u66F4\u65B0\u3092\u6709\u52B9\u306B\u3059\u308B');
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'true';
        break;
      case 3:
        pd.description = '\u6709\u52B9\u306E\u5834\u5408\u3001\u30B5\u30FC\u30D0\u30FC\u306F\u30C7\u30D0\u30C3\u30B0\u30E2\u30FC\u30C9\u306B\u306A\u308A\u307E\u3059\u3002';
        $setDisplayName(pd, '\u30C7\u30D0\u30C3\u30B0\u30E2\u30FC\u30C9\u3092\u6709\u52B9\u306B\u3059\u308B');
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'false';
        break;
      case 4:
        pd.description = '\u6709\u52B9\u306E\u5834\u5408\u3001\u73FE\u5728\u306E\u88FD\u54C1\u306B\u542B\u307E\u308C\u308B\u5B9F\u9A13\u7684\u306A\u6A5F\u80FD\u3092\u4F7F\u7528\u3067\u304D\u308B\u3088\u3046\u306B\u306A\u308A\u307E\u3059\u3002';
        $setDisplayName(pd, '\u5B9F\u9A13\u7684\u6A5F\u80FD\u3092\u6709\u52B9\u306B\u3059\u308B');
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'false';
        break;
      case 5:
        pd.description = '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u306E\u4FDD\u5B88\u304C\u5B9F\u884C\u3055\u308C\u308B\u983B\u5EA6 (\u4F8B\u3048\u3070\u3001Postgres \u3092\u4F7F\u7528\u3057\u3066\u3044\u308B\u5834\u5408\u306F\u30D0\u30AD\u30E5\u30FC\u30E0)\u3002\u6642\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u4FDD\u5B88\u671F\u9593');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '1';
        break;
      case 6:
        pd.description = '\u30A2\u30D9\u30A4\u30E9\u30D3\u30EA\u30C6\u30A3\u30C7\u30FC\u30BF\u3092\u4FDD\u6301\u3059\u308B\u671F\u9593\u3002\u3053\u306E\u671F\u9593\u3092\u904E\u304E\u308B\u3068\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u3088\u308A\u30D1\u30FC\u30B8\u3055\u308C\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u3053\u308C\u3088\u308A\u3082\u53E4\u3044\u30A2\u30D9\u30A4\u30E9\u30D3\u30EA\u30C6\u30A3\u30C7\u30FC\u30BF\u3092\u524A\u9664: ');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '365';
        break;
      case 7:
        pd.description = '\u53E4\u3044\u30A2\u30E9\u30FC\u30C8\u5C65\u6B74\u306E\u30A2\u30A4\u30C6\u30E0\u3092\u4FDD\u6301\u3059\u308B\u671F\u9593\u3002\u3053\u306E\u671F\u9593\u3092\u904E\u304E\u308B\u3068\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u3088\u308A\u30D1\u30FC\u30B8\u3055\u308C\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u3053\u308C\u3088\u308A\u3082\u53E4\u3044\u30A2\u30E9\u30FC\u30C8\u3092\u524A\u9664:');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '31';
        break;
      case 8:
        pd.description = '\u6E2C\u5B9A\u30C8\u30EC\u30A4\u30C8\u30C7\u30FC\u30BF\u306E\u4FDD\u6301\u671F\u9593\u3002\u3053\u306E\u671F\u9593\u3092\u904E\u304E\u308B\u3068\u3001\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u3088\u308A\u30D1\u30FC\u30B8\u3055\u308C\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u3053\u308C\u3088\u308A\u3082\u53E4\u3044\u6E2C\u5B9A\u30C8\u30EC\u30A4\u30C8\u3092\u524A\u9664:');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '365';
        break;
      case 9:
        pd.description = '\u5FDC\u7B54\u6642\u9593\u30C7\u30FC\u30BF\u306E\u4FDD\u6301\u671F\u9593\u3002\u3053\u306E\u671F\u9593\u3092\u904E\u304E\u308B\u3068\u3001\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u304B\u3089\u30D1\u30FC\u30B8\u3055\u308C\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u3053\u308C\u3088\u308A\u3082\u53E4\u3044\u5FDC\u7B54\u6642\u9593\u30C7\u30FC\u30BF\u306E\u524A\u9664:');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '31';
        break;
      case 10:
        pd.description = '\u30A4\u30D9\u30F3\u30C8\u30C7\u30FC\u30BF\u306E\u4FDD\u6301\u671F\u9593\u3002\u3053\u306E\u671F\u9593\u3092\u904E\u304E\u308B\u3068\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u304B\u3089\u30D1\u30FC\u30B8\u3055\u308C\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u3053\u308C\u3088\u308A\u3082\u53E4\u3044\u30A4\u30D9\u30F3\u30C8\u3092\u524A\u9664:');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '14';
        break;
      case 11:
        pd.description = '\u672A\u4F7F\u7528\u307E\u305F\u306F\u30AA\u30FC\u30D5\u30A1\u30F3 (orphan) \u306E\u30C9\u30EA\u30D5\u30C8\u30D5\u30A1\u30A4\u30EB\u3092\u4FDD\u6301\u3059\u308B\u671F\u9593\u3002\u3053\u306E\u671F\u9593\u3092\u904E\u304E\u308B\u3068\u3001\u30D0\u30C3\u30AF\u30A8\u30F3\u30C9\u30B9\u30C8\u30EC\u30FC\u30B8\u304B\u3089\u30D1\u30FC\u30B8\u3055\u308C\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u3053\u308C\u3088\u308A\u3082\u53E4\u3044\u672A\u4F7F\u7528\u30C9\u30EA\u30D5\u30C8\u30D5\u30A1\u30A4\u30EB\u3092\u524A\u9664:');
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '31';
        break;
      case 12:
        pd.description = '\u6709\u52B9\u306A\u5834\u5408\u3001\u7279\u5B9A\u306E\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u30C6\u30FC\u30D6\u30EB\u306F\u5B9A\u671F\u7684\u306B\u30A4\u30F3\u30C7\u30C3\u30AF\u30B9\u304C\u518D\u4F5C\u6210\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u30C7\u30FC\u30BF\u30C6\u30FC\u30D6\u30EB\u306E\u591C\u9593\u3067\u306E\u30A4\u30F3\u30C7\u30C3\u30AF\u30B9\u518D\u4F5C\u6210');
        pd.propertyGroupDefinition = dataManagerGroup;
        pd.defaultValue = 'true';
        break;
      case 13:
        pd.description = '\u30D9\u30FC\u30B9\u30E9\u30A4\u30F3\u306E\u81EA\u52D5\u8A08\u7B97\u304C\u5B9F\u884C\u3055\u308C\u308B\u983B\u5EA6\u30020 \u306E\u5834\u5408\u3001\u30D9\u30FC\u30B9\u30E9\u30A4\u30F3\u306E\u81EA\u52D5\u8A08\u7B97\u306F\u7121\u52B9\u306B\u306A\u308A\u307E\u3059\u3002\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u3001\u6700\u5927\u5024\u306F Baseline Dataset \u3067\u3059\u3002';
        $setDisplayName(pd, '\u30D9\u30FC\u30B9\u30E9\u30A4\u30F3\u8A08\u7B97\u306E\u983B\u5EA6');
        pd.propertyGroupDefinition = baselineGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P0_longLit), null)]));
        pd.defaultValue = '3';
        break;
      case 14:
        pd.description = '\u30D9\u30FC\u30B9\u30E9\u30A4\u30F3\u3092\u6C7A\u5B9A\u3059\u308B\u305F\u3081\u306B\u4F7F\u7528\u3055\u308C\u308B\u904E\u53BB\u306E\u6E2C\u5B9A\u30C7\u30FC\u30BF\u306E\u91CF\u3002\u3053\u308C\u306F\u65E5\u5358\u4F4D\u3067\u6307\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u30D9\u30FC\u30B9\u30E9\u30A4\u30F3\u30C7\u30FC\u30BF\u30BB\u30C3\u30C8');
        pd.propertyGroupDefinition = baselineGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), valueOf_50(Pe_longLit))]));
        pd.defaultValue = '7';
        break;
      case 15:
        pd.description = '\u30E6\u30FC\u30B6\u30FC ID \u306E\u5224\u65AD\u306B LDAP \u3092\u4F7F\u7528\u3059\u3079\u304D\u3067\u3059\u304B?';
        $setDisplayName(pd, 'LDAP \u306E\u6709\u52B9\u5316');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 16:
        pd.description = 'LDAP \u30B5\u30FC\u30D0\u30FC\u3078\u306E URL';
        $setDisplayName(pd, 'LDAP URL');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'ldap://localhost';
        break;
      case 17:
        pd.description = 'LDAP \u30B5\u30FC\u30D0\u30FC\u3068\u306E\u901A\u4FE1\u306F SSL \u3067\u884C\u3044\u307E\u3059\u304B\uFF1F';
        $setDisplayName(pd, 'SSL');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 18:
        pd.description = '\u30E6\u30FC\u30B6\u30FC\u540D\u304C\u542B\u307E\u308C\u308B LDAP \u30D7\u30ED\u30D1\u30C6\u30A3\u30FC\u3002\u30C7\u30D5\u30A9\u30EB\u30C8\u306F "cn" \u3067\u3059\u3002\u4E00\u81F4\u3059\u308B\u30A8\u30F3\u30C8\u30EA\u304C\u8907\u6570\u898B\u3064\u304B\u3063\u305F\u5834\u5408\u3001\u6700\u521D\u306B\u898B\u3064\u304B\u3063\u305F\u30A8\u30F3\u30C8\u30EA\u304C\u4F7F\u7528\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u30ED\u30B0\u30A4\u30F3\u30D7\u30ED\u30D1\u30C6\u30A3\u30FC');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'cn';
        break;
      case 19:
        pd.description = 'LDAP \u691C\u7D22\u4E2D\u306B\u9069\u7528\u3055\u308C\u308B\u8FFD\u52A0\u306E\u30D5\u30A3\u30EB\u30BF\u30FC\u3002\u6307\u5B9A\u306E LDAP \u30D7\u30ED\u30D1\u30C6\u30A3\u30FC\u3092\u4ECB\u3057\u3066\u8A8D\u8A3C\u3059\u308B\u30E6\u30FC\u30B6\u30FC\u3092\u7279\u5B9A\u3067\u304D\u308B\u5834\u5408\u306B\u4FBF\u5229\u3067\u3059\u3002\u4F8B: RHQUser=true';
        $setDisplayName(pd, '\u691C\u7D22\u30D5\u30A3\u30EB\u30BF\u30FC');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = '';
        break;
      case 20:
        pd.description = '\u627F\u8A8D\u306B\u5229\u7528\u53EF\u80FD\u306A\u3059\u3079\u3066\u306E LDAP \u30B0\u30EB\u30FC\u30D7\u3092\u8FD4\u3055\u306A\u3051\u308C\u3070\u306A\u3089\u306A\u3044 LDAP \u691C\u7D22\u30D5\u30A3\u30EB\u30BF\u30FC\u3002LDAP \u30B0\u30EB\u30FC\u30D7\u627F\u8A8D\u306B\u4F7F\u7528\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, '\u30B0\u30EB\u30FC\u30D7\u691C\u7D22\u30D5\u30A3\u30EB\u30BF\u30FC');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'objectclass=groupOfNames';
        break;
      case 22:
        pd.description = 'LDAP \u30B0\u30EB\u30FC\u30D7\u30AF\u30A8\u30EA\u304C RFC 2696 \u306E\u5B9A\u7FA9\u3069\u304A\u308A\u306B Simple Paged Results \u6A5F\u80FD\u3092\u4F7F\u7528\u3059\u308B\u304B\u3069\u3046\u304B\u3092\u5B9A\u7FA9\u3057\u307E\u3059\u3002\u30AF\u30A8\u30EA\u7D50\u679C\u3092\u5236\u9650\u3059\u308B LDAP \u30B5\u30FC\u30D0\u30FC\u3092\u5BFE\u8C61\u3068\u3057\u3001\u30AF\u30E9\u30A4\u30A2\u30F3\u30C8\u306F\u7D42\u4E86\u3059\u308B\u307E\u3067 Groups Page Size \u30C1\u30E3\u30F3\u30AF\u306E\u3059\u3079\u3066\u306E\u7D50\u679C\u306E\u30DA\u30FC\u30B8\u3092\u7D99\u7D9A\u7684\u306B\u79FB\u52D5\u3057\u307E\u3059\u3002\u30C7\u30D5\u30A9\u30EB\u30C8\u306F false \u3067\u3059\u3002';
        $setDisplayName(pd, '\u30B0\u30EB\u30FC\u30D7\u30AF\u30A8\u30EA\u30DA\u30FC\u30B8\u30F3\u30B0\u306E\u4F7F\u7528');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 23:
        pd.description = 'RFC 2696 \u3092\u30B5\u30DD\u30FC\u30C8\u3059\u308B\u305F\u3081\u3001\u3053\u306E LDAP Group Page Size \u691C\u7D22\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u4ED6\u306E\u30B0\u30EB\u30FC\u30D7\u691C\u7D22\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u3068\u3082\u306B\u4F7F\u7528\u3055\u308C\u3001\u5404\u30AF\u30A8\u30EA\u7D50\u679C\u3067\u8FD4\u3055\u308C\u308B\u30B0\u30EB\u30FC\u30D7\u30E1\u30F3\u30D0\u30FC\u306E\u6570\u3092\u5236\u9650\u3057\u307E\u3059\u3002\u3053\u306E\u5024\u306F\u3067\u304D\u308B\u3060\u3051\u5927\u304D\u306A\u5024\u3092\u8A2D\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u3001\u30B5\u30FC\u30D0\u30FC\u5074\u306E\u6700\u5927\u30DA\u30FC\u30B8\u30B5\u30A4\u30BA\u306E\u5024\u3092\u8A2D\u5B9A\u3059\u308B\u306E\u304C\u6700\u9069\u3067\u3059\u3002\u3053\u306E\u5024\u3092\u30B5\u30FC\u30D0\u30FC\u306E\u6700\u5927\u30DA\u30FC\u30B8\u30B5\u30A4\u30BA\u3088\u308A\u5927\u304D\u304F\u3057\u3066\u3082\u52B9\u679C\u306F\u3042\u308A\u307E\u305B\u3093\u3002LDAP \u30B0\u30EB\u30FC\u30D7\u30AF\u30A8\u30EA\u306E\u51E6\u7406\u306B\u6642\u9593\u304C\u304B\u304B\u308A\u3059\u304E\u308B\u5834\u5408\u306F\u3001\u3053\u306E\u5024\u3092\u5C0F\u3055\u304F\u3057\u307E\u3059\u3002\u30C7\u30D5\u30A9\u30EB\u30C8\u306E\u7D50\u679C\u4EF6\u6570\u306F 1000 \u3067\u3059\u3002';
        $setDisplayName(pd, '\u30B0\u30EB\u30FC\u30D7\u691C\u7D22\u30DA\u30FC\u30B8\u30B5\u30A4\u30BA');
        pd.propertyGroupDefinition = ldapGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_50(P1_longLit), null)]));
        pd.defaultValue = '1000';
        break;
      case 21:
        pd.description = '\u30E6\u30FC\u30B6\u30FC\u8A8D\u53EF\u3092\u6C7A\u5B9A\u3059\u308B\u305F\u3081\u306E\u30B0\u30EB\u30FC\u30D7\u691C\u7D22\u30D5\u30A3\u30EB\u30BF\u30FC\u3068\u4E00\u7DD2\u306B\u4F7F\u308F\u308C\u308B LDAP \u691C\u7D22\u30D5\u30A3\u30EB\u30BF\u30FC';
        $setDisplayName(pd, '\u30B0\u30EB\u30FC\u30D7\u30E1\u30F3\u30D0\u30FC\u30D5\u30A3\u30EB\u30BF\u30FC');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'member';
        break;
      case 28:
        pd.description = '\u30B0\u30EB\u30FC\u30D7\u30E1\u30F3\u30D0\u30FC\u30B7\u30C3\u30D7\u306E\u30C1\u30A7\u30C3\u30AF\u306B posixGroup \u30BB\u30DE\u30F3\u30C6\u30A3\u30C3\u30AF\u3092\u4F7F\u7528\u3059\u308B\u304B\u3069\u3046\u304B\u3092\u5B9A\u7FA9\u3057\u307E\u3059\u3002PosixGroups \u3067\u306F\u3001\u901A\u5E38\u3001\u30B0\u30EB\u30FC\u30D7\u30E1\u30F3\u30D0\u30FC\u30D5\u30A3\u30EB\u30BF\u30FC\u304C memberUid \u306B\u8A2D\u5B9A\u3055\u308C\u3001\u30B0\u30EB\u30FC\u30D7\u30D5\u30A3\u30EB\u30BF\u30FC\u304C objectclass=posixGroup \u306B\u8A2D\u5B9A\u3055\u308C\u307E\u3059\u3002';
        $setDisplayName(pd, 'Is PosixGroup');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 24:
        pd.description = '\u30E6\u30FC\u30B6\u30FC\u306E\u8A8D\u8A3C\u4E2D\u306B\u3001\u30E6\u30FC\u30B6\u30FC\u540D\u3068\u30D1\u30B9\u30EF\u30FC\u30C9\u3092\u691C\u7D22\u3059\u308B\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u30C4\u30EA\u30FC\u306E\u30D9\u30FC\u30B9\u3002\u4F8B: ou=People,dc=redhat,dc=com';
        $setDisplayName(pd, '\u691C\u7D22\u30D9\u30FC\u30B9');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'o=RedHat,c=US';
        break;
      case 25:
        pd.description = 'LDAP \u30E6\u30FC\u30B6\u30FC\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u3092\u30AF\u30A8\u30EA\u3059\u308B\u3068\u304D\u306B\u3001LDAP \u30B5\u30FC\u30D0\u30FC\u306B\u63A5\u7D9A\u3059\u308B\u30E6\u30FC\u30B6\u30FC\u540D\u3002\u901A\u5E38\u3001\u30DE\u30CD\u30FC\u30B8\u30E3\u30FC\u30E6\u30FC\u30B6\u30FC\u306E\u5B8C\u5168\u306A LDAP \u8B58\u5225\u540D (DN) \u306B\u306A\u308A\u307E\u3059\u3002\u4F8B: cn=Manager,dc=redhat,dc=com';
        $setDisplayName(pd, '\u30E6\u30FC\u30B6\u30FC\u540D');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = '';
        break;
      case 26:
        pd.description = 'LDAP \u30E6\u30FC\u30B6\u30FC\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u3092\u30AF\u30A8\u30EA\u3059\u308B\u3068\u304D\u306B\u3001LDAP \u30B5\u30FC\u30D0\u30FC\u3078\u63A5\u7D9A\u3059\u308B\u305F\u3081\u306B\u4F7F\u7528\u3059\u308B\u30E6\u30FC\u30B6\u30FC\u306E\u30AF\u30EC\u30C7\u30F3\u30B7\u30E3\u30EB\u3002';
        $setDisplayName(pd, '\u30D1\u30B9\u30EF\u30FC\u30C9');
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = '';
        break;
      case 29:
        pd.description = '\u30C9\u30EA\u30D5\u30C8\u95A2\u9023\u306E\u30A8\u30F3\u30C6\u30A3\u30C6\u30A3\u3068\u30B3\u30F3\u30C6\u30F3\u30C8\u306E\u6C38\u7D9A\u6027\u3092\u7BA1\u7406\u3059\u308B\u30C9\u30EA\u30D5\u30C8\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3';
        $setDisplayName(pd, '\u30A2\u30AF\u30C6\u30A3\u30D6\u30C9\u30EA\u30D5\u30C8\u30B5\u30FC\u30D0\u30FC\u30D7\u30E9\u30B0\u30A4\u30F3');
        pd.propertyGroupDefinition = driftGroup;
        options = new ArrayList_0;
        for (entry$iterator = driftPlugins.entrySet().iterator(); entry$iterator.hasNext();) {
          entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
          options.add_0(new PropertyDefinitionEnumeration_1(dynamicCast(entry.getValue_1(), Q$String), dynamicCast(entry.getKey_0(), Q$String)));
        }

        $setEnumeratedValues(pd, options);
    }
  }
  allDefinitions = (!def.propertyDefinitions && (def.propertyDefinitions = new LinkedHashMap_0) , def.propertyDefinitions);
  for (defEntry$iterator = allDefinitions.entrySet().iterator(); defEntry$iterator.hasNext();) {
    defEntry = dynamicCast(defEntry$iterator.next_0(), Q$Map$Entry);
    propertyName = dynamicCast(defEntry.getKey_0(), Q$String);
    propertyDef = dynamicCast(defEntry.getValue_1(), Q$PropertyDefinition);
    !dynamicCast(config.properties.get_2(propertyName), Q$Property) && instanceOf(propertyDef, Q$PropertyDefinitionSimple) && dynamicCast(propertyDef, Q$PropertyDefinitionSimple).defaultValue != null && $put_4(config, new PropertySimple_1(propertyName, dynamicCast(propertyDef, Q$PropertyDefinitionSimple).defaultValue));
  }
  return def;
}

function $save(this$static){
  var props, settings, simple, simple$iterator, simpleProperties, value;
  if ($validate_4(this$static.editor)) {
    simpleProperties = $getSimpleProperties(this$static.editor.configuration);
    props = new HashMap_0;
    for (simple$iterator = $iterator_0($values(simpleProperties)); simple$iterator.val$outerIter.hasNext();) {
      simple = dynamicCast($next_2(simple$iterator), Q$PropertySimple);
      value = simple.stringValue != null?simple.stringValue:'';
      $equals_6(($clinit_SystemSetting() , AGENT_MAX_QUIET_TIME_ALLOWED).internalName, simple.name_0)?(value = value == null?'0':'' + toString_8(mul(mul(__parseAndValidateLong(value), P3c_longLit), P3e8_longLit))):$equals_6(DATA_MAINTENANCE_PERIOD.internalName, simple.name_0) || $equals_6(RHQ_SESSION_TIMEOUT.internalName, simple.name_0)?(value = value == null?'0':'' + toString_8(mul(mul(mul(__parseAndValidateLong(value), P3c_longLit), P3c_longLit), P3e8_longLit))):($equals_6(AVAILABILITY_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(ALERT_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(TRAIT_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(RT_DATA_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(EVENT_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(DRIFT_FILE_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(BASE_LINE_FREQUENCY.internalName, simple.name_0) || $equals_6(BASE_LINE_DATASET.internalName, simple.name_0)) && (value = value == null?'0':'' + toString_8(mul(mul(mul(mul(__parseAndValidateLong(value), P18_longLit), P3c_longLit), P3c_longLit), P3e8_longLit)));
      props.put(simple.name_0, value);
    }
    settings = fromMap(props);
    $setSystemSettings(dynamicCast(secure(getInstance_57(), -1), Q$SystemGWTServiceAsync), settings, new SystemSettingsView$2_0);
  }
   else {
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_8(($clinit_Enhanced() , '\u4FDD\u5B58\u524D\u306B\u7121\u52B9\u306A\u5024\u3092\u4FEE\u6B63\u3057\u3066\u304F\u3060\u3055\u3044'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient))));
  }
}

function SystemSettingsView_0(){
  $clinit_SystemSettingsView();
  EnhancedVLayout_0.call(this);
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  this.canvas_0 = new EnhancedVLayout_0;
  $setAttribute_24(this.canvas_0, 'height', '100%', true);
  $setAttribute_24(this.canvas_0, 'width', '100%', true);
  $setMargin(this.canvas_0, valueOf_49(15));
  $addMember(this, this.canvas_0);
}

defineSeed(1722, 1653, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$PropertyValueChangeListener, Q$Enhanced, Q$EnhancedVLayout]), SystemSettingsView_0);
_.onDraw_0 = function onDraw_7(){
  $getSystemSettings(dynamicCast(secure(getInstance_57(), -1), Q$SystemGWTServiceAsync), new SystemSettingsView$1_0(this));
}
;
_.propertyValueChanged = function propertyValueChanged_1(event_0){
  var invalidPropertyNames;
  if (event_0.invalidPropertySetChanged) {
    invalidPropertyNames = event_0.invalidPropertyNames;
    invalidPropertyNames.size_1() == 0?$enable(this.saveButton):$disable(this.saveButton);
  }
}
;
_.canvas_0 = null;
_.dumpToLogButton = null;
_.editor = null;
_.saveButton = null;
var VIEW_ID_3;
function $onSuccess_39(this$static, result){
  var config, prop, toolStrip, form, productName, productVersion, productBuildNumber, serverName, serverTimezone, serverTime, serverInstallDir, dbUrl, dbProductName, dbProductVersion, dbDriverName, dbDriverVersion;
  $addMember(this$static.this$0.canvas_0, (form = new DynamicForm_0 , $isCreated_1(form)?$setProperty_4(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined) , $isCreated_1(form)?undefined:(form.config_0['extraSpace'] = 15 , undefined) , $setIsGroup(form, ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setGroupTitle(form, ($clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u8A73\u7D30')) , productName = new StaticTextItem_2('productname', '\u88FD\u54C1\u540D') , productVersion = new StaticTextItem_2('productversion', '\u30D0\u30FC\u30B8\u30E7\u30F3') , productBuildNumber = new StaticTextItem_2('productbuild', '\u30D3\u30EB\u30C9\u756A\u53F7') , serverName = new StaticTextItem_2('servername', '\u30B5\u30FC\u30D0\u30FC\u540D') , serverTimezone = new StaticTextItem_2('timezone', '\u30B5\u30FC\u30D0\u30FC\u30BF\u30A4\u30E0\u30BE\u30FC\u30F3') , serverTime = new StaticTextItem_2('localtime', '\u30B5\u30FC\u30D0\u30FC\u30ED\u30FC\u30AB\u30EB\u6642\u523B') , serverInstallDir = new StaticTextItem_2('installdir', '\u30B5\u30FC\u30D0\u30FC\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA') , dbUrl = new StaticTextItem_2('dbUrl', '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u63A5\u7D9A URL') , dbProductName = new StaticTextItem_2('dbProductName', '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u30D7\u30ED\u30C0\u30AF\u30C8\u540D') , dbProductVersion = new StaticTextItem_2('dbProductVersion', '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u88FD\u54C1\u30D0\u30FC\u30B8\u30E7\u30F3') , dbDriverName = new StaticTextItem_2('dbDriverName', '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u30C9\u30E9\u30A4\u30D0\u30FC\u540D') , dbDriverVersion = new StaticTextItem_2('dbDriverVersion', '\u30C7\u30FC\u30BF\u30D9\u30FC\u30B9\u30C9\u30E9\u30A4\u30D0\u30FC\u30D0\u30FC\u30B8\u30E7\u30F3') , $setWrapTitle(productName, FALSE) , $setWrapTitle(productVersion, FALSE) , $setWrapTitle(productBuildNumber, FALSE) , $setWrapTitle(serverName, FALSE) , $setWrapTitle(serverTimezone, FALSE) , $setWrapTitle(serverTime, FALSE) , $setWrapTitle(serverInstallDir, FALSE) , $setWrapTitle(dbUrl, FALSE) , $setWrapTitle(dbProductName, FALSE) , $setWrapTitle(dbProductVersion, FALSE) , $setWrapTitle(dbDriverName, FALSE) , $setWrapTitle(dbDriverVersion, FALSE) , form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [productName, productVersion, productBuildNumber, serverName, serverTimezone, serverTime, serverInstallDir, dbUrl, dbProductName, dbProductVersion, dbDriverName, dbDriverVersion])) , $getServerDetails(dynamicCast(secure(getInstance_57(), -1), Q$SystemGWTServiceAsync), new SystemSettingsView$4_0(form, productName, productVersion, productBuildNumber, serverName, serverTimezone, serverTime, serverInstallDir, dbUrl, dbProductName, dbProductVersion, dbDriverName, dbDriverVersion)) , form));
  config = $toConfiguration(result);
  prop = $getSimple(config, ($clinit_SystemSetting() , AGENT_MAX_QUIET_TIME_ALLOWED).internalName);
  $setValue_12(prop, $convertMillisToMinutes(prop.stringValue));
  prop = $getSimple(config, RHQ_SESSION_TIMEOUT.internalName);
  $setValue_12(prop, $convertMillisToHours(prop.stringValue));
  prop = $getSimple(config, DATA_MAINTENANCE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToHours(prop.stringValue));
  prop = $getSimple(config, AVAILABILITY_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, ALERT_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, TRAIT_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, RT_DATA_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, EVENT_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, DRIFT_FILE_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, BASE_LINE_FREQUENCY.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, BASE_LINE_DATASET.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  this$static.this$0.editor = new ConfigurationEditor_1($getSystemSettingsDefinition(config, result.driftPlugins), config);
  $addPropertyValueChangeListener(this$static.this$0.editor, this$static.this$0);
  $addMember(this$static.this$0.canvas_0, this$static.this$0.editor);
  toolStrip = new ToolStrip_0;
  $isCreated_1(toolStrip)?$setProperty_4(toolStrip, 'width', '100%'):(toolStrip.config_0['width'] = '100%' , undefined);
  $isCreated_1(toolStrip)?$setProperty_1(toolStrip, 'membersMargin', 5):(toolStrip.config_0['membersMargin'] = 5 , undefined);
  $setLayoutMargin(toolStrip, valueOf_49(5));
  this$static.this$0.saveButton = new EnhancedIButton_1('\u4FDD\u5B58');
  $addClickHandler(this$static.this$0.saveButton, new SystemSettingsView$1$1_0(this$static));
  $addMember(toolStrip, this$static.this$0.saveButton);
  this$static.this$0.dumpToLogButton = new EnhancedIButton_1('\u30C0\u30F3\u30D7\u30B7\u30B9\u30C6\u30E0\u60C5\u5831');
  $addClickHandler(this$static.this$0.dumpToLogButton, new SystemSettingsView$1$2_0);
  $addMember(toolStrip, this$static.this$0.dumpToLogButton);
  $addMember(this$static.this$0.canvas_0, toolStrip);
}

function SystemSettingsView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1723, 1, makeCastMap([Q$AsyncCallback]), SystemSettingsView$1_0);
_.onFailure = function onFailure_39(t){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u73FE\u5728\u306E\u30B7\u30B9\u30C6\u30E0\u8A2D\u5B9A\u3092\u53D6\u5F97\u3067\u304D\u307E\u305B\u3093'), t);
}
;
_.onSuccess_0 = function onSuccess_39(result){
  $onSuccess_39(this, dynamicCast(result, Q$SystemSettings));
}
;
_.this$0 = null;
function SystemSettingsView$1$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1724, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), SystemSettingsView$1$1_0);
_.onClick = function onClick_13(clickEvent){
  $save(this.this$1.this$0);
}
;
_.this$1 = null;
function SystemSettingsView$1$2_0(){
}

defineSeed(1725, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), SystemSettingsView$1$2_0);
_.onClick = function onClick_14(clickEvent){
  $dumpToLog(dynamicCast(secure(getInstance_57(), -1), Q$SystemGWTServiceAsync), new SystemSettingsView$3_0);
}
;
function SystemSettingsView$2_0(){
}

defineSeed(1726, 1, makeCastMap([Q$AsyncCallback]), SystemSettingsView$2_0);
_.onFailure = function onFailure_40(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30B7\u30B9\u30C6\u30E0\u8A2D\u5B9A\u306E\u4FDD\u5B58\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_40(result){
  throwClassCastExceptionUnlessNull(result);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , '\u30B7\u30B9\u30C6\u30E0\u30D7\u30ED\u30D1\u30C6\u30A3\u306E\u4FDD\u5B58\u306B\u6210\u529F\u3057\u307E\u3057\u305F'), ($clinit_Message$Severity() , Info)));
}
;
function SystemSettingsView$3_0(){
}

defineSeed(1727, 1, makeCastMap([Q$AsyncCallback]), SystemSettingsView$3_0);
_.onFailure = function onFailure_41(throwable){
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , '\u30B7\u30B9\u30C6\u30E0\u60C5\u5831\u306E\u30B5\u30FC\u30D0\u30FC\u30ED\u30B0\u30D5\u30A1\u30A4\u30EB\u3078\u306E\u66F8\u304D\u8FBC\u307F\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), ($clinit_Message$Severity() , Warning)));
}
;
_.onSuccess_0 = function onSuccess_41(aVoid){
  throwClassCastExceptionUnlessNull(aVoid);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , '\u30B7\u30B9\u30C6\u30E0\u60C5\u5831\u304C\u6B63\u5E38\u306B\u30B5\u30FC\u30D0\u30FC\u30ED\u30B0\u30D5\u30A1\u30A4\u30EB\u306B\u66F8\u304D\u8FBC\u307E\u308C\u307E\u3057\u305F'), ($clinit_Message$Severity() , Info)));
}
;
function $onSuccess_40(this$static, result){
  var details, productInfo;
  productInfo = result.productInfo;
  $setValue_0(this$static.val$form, $getName(this$static.val$productName), productInfo.name_0);
  $setValue_0(this$static.val$form, $getName(this$static.val$productVersion), productInfo.version_0);
  $setValue_0(this$static.val$form, $getName(this$static.val$productBuildNumber), productInfo.buildNumber);
  details = result.details;
  $setValue_0(this$static.val$form, $getName(this$static.val$serverName), dynamicCast(details.get_2(($clinit_ServerDetails$Detail() , SERVER_IDENTITY)), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$serverTimezone), dynamicCast(details.get_2(SERVER_TIMEZONE), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$serverTime), dynamicCast(details.get_2(SERVER_LOCAL_TIME), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$serverInstallDir), dynamicCast(details.get_2(SERVER_INSTALL_DIR), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbUrl), dynamicCast(details.get_2(DATABASE_CONNECTION_URL), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbProductName), dynamicCast(details.get_2(DATABASE_PRODUCT_NAME), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbProductVersion), dynamicCast(details.get_2(DATABASE_PRODUCT_VERSION), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbDriverName), dynamicCast(details.get_2(DATABASE_DRIVER_NAME), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbDriverVersion), dynamicCast(details.get_2(DATABASE_DRIVER_VERSION), Q$String));
}

function SystemSettingsView$4_0(val$form, val$productName, val$productVersion, val$productBuildNumber, val$serverName, val$serverTimezone, val$serverTime, val$serverInstallDir, val$dbUrl, val$dbProductName, val$dbProductVersion, val$dbDriverName, val$dbDriverVersion){
  this.val$form = val$form;
  this.val$productName = val$productName;
  this.val$productVersion = val$productVersion;
  this.val$productBuildNumber = val$productBuildNumber;
  this.val$serverName = val$serverName;
  this.val$serverTimezone = val$serverTimezone;
  this.val$serverTime = val$serverTime;
  this.val$serverInstallDir = val$serverInstallDir;
  this.val$dbUrl = val$dbUrl;
  this.val$dbProductName = val$dbProductName;
  this.val$dbProductVersion = val$dbProductVersion;
  this.val$dbDriverName = val$dbDriverName;
  this.val$dbDriverVersion = val$dbDriverVersion;
}

defineSeed(1728, 1, makeCastMap([Q$AsyncCallback]), SystemSettingsView$4_0);
_.onFailure = function onFailure_42(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30B5\u30FC\u30D0\u30FC\u8A73\u7D30\u3092\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093'), caught);
}
;
_.onSuccess_0 = function onSuccess_42(result){
  $onSuccess_40(this, dynamicCast(result, Q$ServerDetails));
}
;
_.val$dbDriverName = null;
_.val$dbDriverVersion = null;
_.val$dbProductName = null;
_.val$dbProductVersion = null;
_.val$dbUrl = null;
_.val$form = null;
_.val$productBuildNumber = null;
_.val$productName = null;
_.val$productVersion = null;
_.val$serverInstallDir = null;
_.val$serverName = null;
_.val$serverTime = null;
_.val$serverTimezone = null;
function $clinit_RemoteAgentInstallView(){
  $clinit_RemoteAgentInstallView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_4 = new ViewName_2('RemoteAgentInstall', ($clinit_Enhanced() , '\u30EA\u30E2\u30FC\u30C8\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB'), ($clinit_IconEnum() , AGENT_0));
}

function $agentStatusCheck(this$static){
  $disableButtons(this$static, true);
  $agentStatus(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$7_0(this$static));
}

function $buildInstallInfoCanvas(installInfo, info){
  var config, duration, infoForm, infoHeader, listCanvas, listGrid, listLayout, owner, path, result, resultCode, step, version, buf;
  infoForm = new DynamicForm_0;
  $setMargin(infoForm, valueOf_49(20));
  $isCreated_1(infoForm)?$setProperty_4(infoForm, 'width', '100%'):(infoForm.config_0['width'] = '100%' , undefined);
  $isCreated_1(infoForm)?$setProperty_4(infoForm, 'height', '100%'):(infoForm.config_0['height'] = '100%' , undefined);
  infoHeader = new HeaderItem_0;
  $setValue_7(infoHeader, ($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u60C5\u5831'));
  version = new StaticTextItem_2('version', '\u30D0\u30FC\u30B8\u30E7\u30F3');
  $setValue_7(version, info.version_0);
  path = new StaticTextItem_2('path', '\u30D1\u30B9');
  $setValue_7(path, info.path);
  owner = new StaticTextItem_2('owner', '\u6240\u6709\u8005');
  $setValue_7(owner, info.owner);
  config = new StaticTextItem_2('config', '\u8A2D\u5B9A');
  $setValue_7(config, (buf = new StringBuilder_0 , $append_13($append_13($append_13((buf.impl.string += '-D' , buf), 'rhq.agent.server.bind-address'), '='), info.serverAddress) , buf.impl.string += ' ' , $append_13($append_13($append_13((buf.impl.string += '-D' , buf), 'rhq.communications.connector.bind-address'), '='), info.agentAddress) , buf.impl.string += ' ' , $append_13($append_13($append_13((buf.impl.string += '-D' , buf), 'rhq.agent.configuration-setup-flag'), '='), 'true') , buf.impl.string += ' ' , buf.impl.string += '--daemon ' , buf.impl.string));
  listCanvas = new CanvasItem_0;
  listCanvas.setShowTitle(($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $isCreated_2(listCanvas)?$setProperty_7(listCanvas, 'colSpan', 2):(listCanvas.jsObj['colSpan'] = 2 , undefined);
  listLayout = new VLayout_1(0);
  $isCreated_1(listLayout)?$setProperty_4(listLayout, 'width', '100%'):(listLayout.config_0['width'] = '100%' , undefined);
  $isCreated_1(listLayout)?$setProperty_4(listLayout, 'height', '100%'):(listLayout.config_0['height'] = '100%' , undefined);
  listGrid = new RemoteAgentInstallView$11_0;
  $isCreated_1(listGrid)?$setProperty_4(listGrid, 'width', '100%'):(listGrid.config_0['width'] = '100%' , undefined);
  $isCreated_1(listGrid)?$setProperty_4(listGrid, 'height', '100%'):(listGrid.config_0['height'] = '100%' , undefined);
  $setCanExpandRecords(listGrid, TRUE);
  $setAttribute_24(listGrid, 'expansionMode', ($clinit_ExpansionMode() , DETAIL_FIELD).value_0, true);
  $isCreated_1(listGrid)?$setProperty_4(listGrid, 'detailField', 'result'):(listGrid.config_0['detailField'] = 'result' , undefined);
  step = new ListGridField_3('description', '\u30B9\u30C6\u30C3\u30D7');
  result = new ListGridField_3('result', '\u7D50\u679C');
  resultCode = new ListGridField_4('resultCode', '\u7D50\u679C\u30B3\u30FC\u30C9', 90);
  duration = new ListGridField_4('duration', '\u671F\u9593', 90);
  $isCreated_1(listGrid)?$setProperty_3(listGrid, 'fields', convertToJavaScriptArray_0(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [step, result, resultCode, duration]))):(listGrid.config_0['fields'] = convertToJavaScriptArray_0(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [step, result, resultCode, duration])) , undefined);
  $setData(listGrid, $getStepRecords(info));
  listLayout.addMember_0(listGrid);
  $setAttribute_28(listCanvas, 'canvas', !listLayout?null:$getOrCreateJsObj_0(listLayout));
  infoForm.setFields(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [infoHeader, version, path, owner, config, listCanvas]));
  installInfo.addMember_0(infoForm);
  return;
}

function $disableButtons(this$static, disabled){
  $setDisabled(this$static.installButton, disabled);
  $setDisabled(this$static.startButton, disabled);
  $setDisabled(this$static.stopButton, disabled);
  $setDisabled(this$static.buttonsForm, disabled);
  $setDisabled_2(this$static.findAgentInstallPathButton, ($clinit_Boolean() , disabled?TRUE:FALSE));
  $setDisabled_2(this$static.statusCheckButton, disabled?TRUE:FALSE);
}

function $findAgentInstallPath(this$static){
  var errors, parentPath;
  errors = new HashMap_1(2);
  ($getValueAsString(this$static.connectionForm, 'host') == null || !$trim($getValueAsString(this$static.connectionForm, 'host')).length) && errors.put('host', ($clinit_CoreGUI() , '\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u5024\u306F\u5FC5\u9808\u3067\u3059'));
  ($getValueAsString(this$static.connectionForm, 'username') == null || !$trim($getValueAsString(this$static.connectionForm, 'username')).length) && errors.put('username', ($clinit_CoreGUI() , '\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u5024\u306F\u5FC5\u9808\u3067\u3059'));
  $setErrors(this$static.connectionForm, errors, true);
  if (errors.size_1() == 0) {
    $disableButtons(this$static, true);
    parentPath = $getValueAsString(this$static.connectionForm, 'agentInstallPath');
    $findAgentInstallPath_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), parentPath, new RemoteAgentInstallView$6_0(this$static, parentPath));
  }
}

function $getConnectionForm(this$static){
  var agentInstallPath, agentStatus, host, password, port, username;
  this$static.connectionForm = new DynamicForm_0;
  $setNumCols(this$static.connectionForm, 4);
  $setWrapItemTitles(this$static.connectionForm, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setColWidths(this$static.connectionForm, initValues(_3Ljava_lang_Object_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Object, ['130', '450', '110']));
  host = new TextItem_3('host', ($clinit_Enhanced() , '\u30DB\u30B9\u30C8'));
  $setRequired(host, TRUE);
  $isCreated_2(host)?$setProperty_7(host, 'width', 440):(host.jsObj['width'] = 440 , undefined);
  $setPrompt_1(host, '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u3066\u3044\u308B\u3001\u3042\u308B\u3044\u306F\u3053\u308C\u304B\u3089\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u308B\u30DB\u30B9\u30C8');
  $setHoverWidth_0(host, valueOf_49(300));
  $setEndRow_0(host, TRUE);
  port = new TextItem_3('port', '\u30DD\u30FC\u30C8');
  $setRequired(port, FALSE);
  $isCreated_2(port)?$setProperty_7(port, 'width', 440):(port.jsObj['width'] = 440 , undefined);
  $setPrompt_1(port, 'SSH \u30B5\u30FC\u30D0\u30FC\u304C\u30EA\u30C3\u30B9\u30F3\u3059\u308B\u30DD\u30FC\u30C8\u3002\u6307\u5B9A\u304C\u306A\u3051\u308C\u3070\u3001\u30C7\u30D5\u30A9\u30EB\u30C8\u306F 22 \u306B\u306A\u308A\u307E\u3059\u3002');
  $setHoverWidth_0(port, valueOf_49(300));
  $setEndRow_0(port, TRUE);
  username = new TextItem_3('username', '\u30E6\u30FC\u30B6\u30FC');
  $setRequired(username, TRUE);
  $isCreated_2(username)?$setProperty_7(username, 'width', 440):(username.jsObj['width'] = 440 , undefined);
  $setPrompt_1(username, 'SSH \u3092\u4ECB\u3057\u3066\u30DB\u30B9\u30C8\u306B\u6E21\u3055\u308C\u308B\u30AF\u30EC\u30C7\u30F3\u30B7\u30E3\u30EB\u3092\u4FDD\u6301\u3059\u308B\u30E6\u30FC\u30B6\u30FC\u306E\u540D\u524D');
  $setHoverWidth_0(username, valueOf_49(300));
  $setEndRow_0(username, TRUE);
  password = new PasswordItem_2('\u30D1\u30B9\u30EF\u30FC\u30C9');
  $setRequired(password, FALSE);
  $isCreated_2(password)?$setProperty_7(password, 'width', 440):(password.jsObj['width'] = 440 , undefined);
  $setPrompt_1(password, 'SSH \u3092\u4ECB\u3057\u3066\u30DB\u30B9\u30C8\u4E0A\u306E\u30E6\u30FC\u30B6\u30FC\u3092\u8A8D\u8A3C\u3059\u308B\u305F\u3081\u306B\u4F7F\u308F\u308C\u308B\u30AF\u30EC\u30C7\u30F3\u30B7\u30E3\u30EB');
  $setHoverWidth_0(password, valueOf_49(300));
  $setEndRow_0(password, TRUE);
  agentInstallPath = new TextItem_3('agentInstallPath', '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u30D1\u30B9');
  $isCreated_2(agentInstallPath)?$setProperty_7(agentInstallPath, 'width', 440):(agentInstallPath.jsObj['width'] = 440 , undefined);
  $setPrompt_1(agentInstallPath, "\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u3066\u3044\u308B\u5834\u6240\u3001\u3042\u308B\u3044\u306F\u3053\u308C\u304B\u3089\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u308B\u5834\u6240\u3002\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u3066\u3044\u308B\u5834\u6240\u304C\u5206\u304B\u3089\u306A\u3044\u5834\u5408\u306F\u3001\u89AA\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u3092\u5165\u529B\u3057\u305F\u5F8C\u3001'\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u691C\u7D22' \u30DC\u30BF\u30F3\u3092\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u3001\u305D\u306E\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u4EE5\u4E0B\u3092\u30B9\u30AD\u30E3\u30F3\u3057\u307E\u3059\u3002\u7A7A\u306E\u30D1\u30B9\u3092\u5165\u529B\u3057\u305F\u5834\u5408\u306F\u3001\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u308B\u30DB\u30B9\u30C8\u4E0A\u306E\u5171\u901A\u306E\u5834\u6240\u304C\u691C\u7D22\u3055\u308C\u307E\u3059\u3002");
  $setHoverWidth_0(agentInstallPath, valueOf_49(300));
  $setStartRow_0(agentInstallPath, TRUE);
  $setEndRow_0(agentInstallPath, FALSE);
  this$static.findAgentInstallPathButton = new ButtonItem_1('findAgentInstallPathButton', '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u691C\u7D22');
  $setStartRow_1(this$static.findAgentInstallPathButton, FALSE);
  $setEndRow_1(this$static.findAgentInstallPathButton, TRUE);
  this$static.findAgentInstallPathButton.getTitle().length < 15 && $setWidth_1(this$static.findAgentInstallPathButton, 100);
  $addClickHandler_1(this$static.findAgentInstallPathButton, new RemoteAgentInstallView$1_0(this$static));
  agentStatus = new StaticTextItem_2('agentStatus', '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u72B6\u614B');
  $setDefaultValue_1(agentStatus, '-\u30B9\u30C6\u30FC\u30BF\u30B9\u66F4\u65B0\u30DC\u30BF\u30F3\u3092\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u304F\u3060\u3055\u3044-');
  $isCreated_2(agentStatus)?$setProperty_10(agentStatus, 'redrawOnChange', true):(agentStatus.jsObj['redrawOnChange'] = true , undefined);
  $isCreated_2(agentStatus)?$setProperty_10(agentStatus, 'redrawOnChange', true):(agentStatus.jsObj['redrawOnChange'] = true , undefined);
  $setStartRow_0(agentStatus, TRUE);
  $setEndRow_0(agentStatus, FALSE);
  this$static.statusCheckButton = new ButtonItem_1('updateStatus', '\u30B9\u30BF\u30FC\u30BF\u30B9\u306E\u66F4\u65B0');
  $setStartRow_1(this$static.statusCheckButton, FALSE);
  $setEndRow_1(this$static.statusCheckButton, TRUE);
  this$static.findAgentInstallPathButton.getTitle().length < 15 && $setWidth_1(this$static.statusCheckButton, 100);
  $addClickHandler_1(this$static.statusCheckButton, new RemoteAgentInstallView$2_0(this$static));
  this$static.connectionForm.setFields(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [host, port, username, password, agentInstallPath, this$static.findAgentInstallPathButton, agentStatus, this$static.statusCheckButton]));
  $setExtraSpace(this$static.connectionForm, 15);
  return this$static.connectionForm;
}

function $getRemoteAccessInfo(this$static){
  var $e0, host, info, password, port, portInt, username;
  host = $getValueAsString(this$static.connectionForm, 'host');
  port = $getValueAsString(this$static.connectionForm, 'port');
  username = $getValueAsString(this$static.connectionForm, 'username');
  password = $getValueAsString(this$static.connectionForm, 'password');
  try {
    portInt = __parseAndValidateInt(port);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$NumberFormatException)) {
      portInt = 22;
    }
     else 
      throw $e0;
  }
  $setValue(this$static.connectionForm, 'port', portInt);
  info = new RemoteAccessInfo_0(host, portInt, username, password);
  return info;
}

function $getStepRecords(info){
  var rec, result, step, step$iterator, steps;
  steps = new ArrayList_0;
  for (step$iterator = info.steps.iterator(); step$iterator.hasNext();) {
    step = dynamicCast(step$iterator.next_0(), Q$AgentInstallStep);
    rec = new ListGridRecord_0;
    $setAttribute_13(rec, 'description', step.description);
    result = step.result;
    (result == null || $trim(result).length == 0) && (result = ($clinit_Enhanced() , '\u7D50\u679C\u30B3\u30FC\u30C9') + '=' + step.resultCode);
    rec.jsObj['result'] = result;
    $setAttribute_13(rec, 'resultCode', '' + step.resultCode);
    $setAttribute_13(rec, 'duration', ($clinit_MeasurementConverterClient() , format_105(new Double_0(toDouble(step.duration)), ($clinit_MeasurementUnits() , MILLISECONDS))));
    steps.add_0(rec);
  }
  return dynamicCast($toArray_1(steps, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, steps.size_0, 0)), Q$ListGridRecord_$1);
}

function $installAgent(this$static){
  $disableButtons(this$static, true);
  $installAgent_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$8_0(this$static));
}

function $startAgent(this$static){
  $disableButtons(this$static, true);
  $startAgent_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$9_0(this$static));
}

function $stopAgent(this$static){
  $disableButtons(this$static, true);
  $stopAgent_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$10_0(this$static));
}

function RemoteAgentInstallView_0(){
  $clinit_RemoteAgentInstallView();
  EnhancedVLayout_0.call(this);
  this.remoteInstallService = dynamicCast(secure(getInstance_49(), 600000), Q$RemoteInstallGWTServiceAsync);
  $isCreated_1(this)?$setProperty_1(this, 'membersMargin', 1):(this.config_0['membersMargin'] = 1 , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
}

defineSeed(1729, 1653, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced, Q$EnhancedVLayout]), RemoteAgentInstallView_0);
_.onInit = function onInit_11(){
  var header, layout;
  $onInit(this);
  $onInit_Layout(this);
  layout = new VLayout_0;
  $setPadding(layout, valueOf_49(10));
  header = new HTMLFlow_1(($clinit_Enhanced() , '\u63A5\u7D9A\u60C5\u5831'));
  $isCreated_1(header)?$setProperty_4(header, 'styleName', 'headerItem'):(header.config_0['styleName'] = 'headerItem' , undefined);
  $isCreated_1(header)?undefined:(header.config_0['extraSpace'] = 5 , undefined);
  layout.addMember_0(header);
  layout.addMember_0($getConnectionForm(this));
  header = new HTMLFlow_1('\u64CD\u4F5C');
  $isCreated_1(header)?$setProperty_4(header, 'styleName', 'headerItem'):(header.config_0['styleName'] = 'headerItem' , undefined);
  $isCreated_1(header)?undefined:(header.config_0['extraSpace'] = 5 , undefined);
  layout.addMember_0(header);
  layout.addMember_0((this.buttonsForm = new HLayout_0 , this.installButton = new EnhancedIButton_1('\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB') , $setExtraSpace(this.installButton, 10) , $addClickHandler(this.installButton, new RemoteAgentInstallView$3_0(this)) , this.startButton = new EnhancedIButton_1('\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u8D77\u52D5') , $setExtraSpace(this.startButton, 10) , $addClickHandler(this.startButton, new RemoteAgentInstallView$4_0(this)) , this.stopButton = new EnhancedIButton_1('\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u505C\u6B62') , $setExtraSpace(this.stopButton, 10) , $addClickHandler(this.stopButton, new RemoteAgentInstallView$5_0(this)) , $setMembers(this.buttonsForm, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [this.installButton, this.startButton, this.stopButton])) , this.buttonsForm));
  this.agentInfoLayout = new VLayout_0;
  $setAttribute_24(this.agentInfoLayout, 'width', '100%', true);
  $setAttribute_24(this.agentInfoLayout, 'height', '100%', true);
  $setMembersMargin(this.agentInfoLayout, 1);
  layout.addMember_0(this.agentInfoLayout);
  $addMember(this, layout);
}
;
_.agentInfoLayout = null;
_.buttonsForm = null;
_.connectionForm = null;
_.findAgentInstallPathButton = null;
_.installButton = null;
_.startButton = null;
_.statusCheckButton = null;
_.stopButton = null;
var VIEW_ID_4;
function RemoteAgentInstallView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1730, 1, makeCastMap([Q$EventHandler, Q$ClickHandler_0]), RemoteAgentInstallView$1_0);
_.onClick_0 = function onClick_15(clickEvent){
  $findAgentInstallPath(this.this$0);
}
;
_.this$0 = null;
function $onSuccess_41(this$static, result){
  $disableButtons(this$static.this$0, false);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7('\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u505C\u6B62\u7D50\u679C: [' + ($clinit_Enhanced() , result) + ']', ($clinit_Message$Severity() , Info)));
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$10_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1731, 1, makeCastMap([Q$AsyncCallback]), RemoteAgentInstallView$10_0);
_.onFailure = function onFailure_43(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u505C\u6B62\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_43(result){
  $onSuccess_41(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
function RemoteAgentInstallView$11_0(){
  $clinit_BaseWidget();
  ListGrid_0.call(this);
}

defineSeed(1732, 554, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers]), RemoteAgentInstallView$11_0);
_.getExpansionComponent_0 = function getExpansionComponent_0(record){
  var canvas;
  canvas = $getExpansionComponent(this, record);
  $setPadding(canvas, valueOf_49(5));
  return canvas;
}
;
function RemoteAgentInstallView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1733, 1, makeCastMap([Q$EventHandler, Q$ClickHandler_0]), RemoteAgentInstallView$2_0);
_.onClick_0 = function onClick_16(clickEvent){
  this.this$0.connectionForm.validate_0() && $agentStatusCheck(this.this$0);
}
;
_.this$0 = null;
function RemoteAgentInstallView$3_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1734, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), RemoteAgentInstallView$3_0);
_.onClick = function onClick_17(clickEvent){
  this.this$0.connectionForm.validate_0() && $installAgent(this.this$0);
}
;
_.this$0 = null;
function RemoteAgentInstallView$4_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1735, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), RemoteAgentInstallView$4_0);
_.onClick = function onClick_18(clickEvent){
  this.this$0.connectionForm.validate_0() && $startAgent(this.this$0);
}
;
_.this$0 = null;
function RemoteAgentInstallView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1736, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), RemoteAgentInstallView$5_0);
_.onClick = function onClick_19(clickEvent){
  this.this$0.connectionForm.validate_0() && $stopAgent(this.this$0);
}
;
_.this$0 = null;
function $onSuccess_42(this$static, result){
  var err;
  $disableButtons(this$static.this$0, false);
  if (result != null) {
    $setValue_0(this$static.this$0.connectionForm, 'agentInstallPath', result);
  }
   else {
    this$static.val$parentPath == null || this$static.val$parentPath.length == 0?(err = ($clinit_Enhanced() , '\u5171\u6709\u306E\u5834\u6240\u3067\u306E\u691C\u7D22\u4E2D\u306B\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u305F\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093\u3067\u3057\u305F')):(err = '[' + ($clinit_Enhanced() , this$static.val$parentPath) + '] \u307E\u305F\u306F\u305D\u308C\u4EE5\u4E0B\u306B\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u3055\u308C\u305F\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093\u3067\u3057\u305F');
    $handleError_0(($clinit_CoreGUI() , err), null);
  }
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$6_0(this$0, val$parentPath){
  this.this$0 = this$0;
  this.val$parentPath = val$parentPath;
}

defineSeed(1737, 1, makeCastMap([Q$AsyncCallback]), RemoteAgentInstallView$6_0);
_.onFailure = function onFailure_44(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u30D1\u30B9\u306E\u691C\u7D22\u4E2D\u306B\u30A8\u30E9\u30FC\u304C\u767A\u751F\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_44(result){
  $onSuccess_42(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
_.val$parentPath = null;
function $onSuccess_43(this$static, result){
  $disableButtons(this$static.this$0, false);
  $setValue_0(this$static.this$0.connectionForm, 'agentStatus', result);
}

function RemoteAgentInstallView$7_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1738, 1, makeCastMap([Q$AsyncCallback]), RemoteAgentInstallView$7_0);
_.onFailure = function onFailure_45(caught){
  $disableButtons(this.this$0, false);
  $setValue_0(this.this$0.connectionForm, 'agentStatus', caught.getMessage());
}
;
_.onSuccess_0 = function onSuccess_45(result){
  $onSuccess_43(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
function $onSuccess_44(this$static, result){
  var child, child$array, child$index, child$max;
  $disableButtons(this$static.this$0, false);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u306E\u5B8C\u4E86'), ($clinit_Message$Severity() , Info)));
  for (child$array = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static.this$0.agentInfoLayout, 'children')) , child$index = 0 , child$max = child$array.length; child$index < child$max; ++child$index) {
    child = child$array[child$index];
    child.destroy_0();
  }
  $buildInstallInfoCanvas(this$static.this$0.agentInfoLayout, result);
  this$static.this$0.agentInfoLayout.markForRedraw_0();
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$8_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1739, 1, makeCastMap([Q$AsyncCallback]), RemoteAgentInstallView$8_0);
_.onFailure = function onFailure_46(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30A4\u30F3\u30B9\u30C8\u30FC\u30EB\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_46(result){
  $onSuccess_44(this, dynamicCast(result, Q$AgentInstallInfo));
}
;
_.this$0 = null;
function $onSuccess_45(this$static, result){
  $disableButtons(this$static.this$0, false);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7('\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u958B\u59CB\u7D50\u679C: [' + ($clinit_Enhanced() , result) + ']', ($clinit_Message$Severity() , Info)));
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$9_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1740, 1, makeCastMap([Q$AsyncCallback]), RemoteAgentInstallView$9_0);
_.onFailure = function onFailure_47(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , '\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u958B\u59CB\u306B\u5931\u6557\u3057\u307E\u3057\u305F'), caught);
}
;
_.onSuccess_0 = function onSuccess_47(result){
  $onSuccess_45(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
function $clinit_PermissionsEditor(){
  $clinit_PermissionsEditor = nullMethod;
  $clinit_BaseWidget();
  $clinit_CoreGUI();
}

function $createAuthorizedField(this$static, name_0, title, nameField, grid, readOnlyColumn){
  var authorizedField, editor, recordBeingEdited, valueMap;
  authorizedField = new ListGridField_4(name_0, title, 65);
  $setAttribute_13(authorizedField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  authorizedField.jsObj['imageSize'] = 11;
  valueMap = new LinkedHashMap_1(2);
  if (readOnlyColumn) {
    $put_1(valueMap, ($clinit_Boolean() , TRUE).value_0?'true':'false', 'global/permission_checked_disabled_11.png');
    $put_1(valueMap, FALSE.value_0?'true':'false', 'global/permission_disabled_11.png');
  }
   else {
    $put_1(valueMap, ($clinit_Boolean() , TRUE).value_0?'true':'false', 'global/permission_enabled_11.png');
    $put_1(valueMap, FALSE.value_0?'true':'false', 'global/permission_disabled_11.png');
  }
  setAttribute_10(authorizedField.jsObj, 'valueMap', valueMap);
  $setAttribute_8(authorizedField, 'canEdit', ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  editor = new CheckboxItem_0;
  $setEditorType(authorizedField, editor);
  if (!this$static.isReadOnly) {
    $setAttribute_24(grid, 'editEvent', ($clinit_ListGridEditEvent() , CLICK).value_0, true);
    recordBeingEdited = initValues(_3Lcom_smartgwt_client_data_Record_2_classLit, makeCastMap([Q$Record_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Record, [null]);
    $addRecordClickHandler_0(authorizedField, new PermissionsEditor$1_0(recordBeingEdited));
    $addChangedHandler_0(authorizedField, new PermissionsEditor$2_0(this$static, grid, nameField));
  }
  return authorizedField;
}

function $createIconField(){
  var iconField;
  iconField = new ListGridField_4('icon', '&nbsp;', 28);
  $setAttribute_8(iconField, 'showDefaultContextMenu', ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setAttribute_8(iconField, 'canSort', FALSE);
  $setAttribute_13(iconField, 'align', ($clinit_Alignment() , CENTER_0).value_0);
  $setAttribute_13(iconField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  iconField.jsObj['imageURLSuffix'] = '_16.png';
  iconField.jsObj['imageWidth'] = 16;
  iconField.jsObj['imageHeight'] = 16;
  return iconField;
}

function $createPermissionRecord(this$static, displayName, icon, permission, description){
  var record;
  record = new ListGridRecord_0;
  record.jsObj['displayName'] = displayName;
  record.jsObj['icon'] = icon;
  $setAttribute_13(record, 'name', permission.name_0);
  record.jsObj['description'] = description;
  $setAttribute_16(record, 'authorized', this$static.selectedPermissions.contains(permission));
  return record;
}

function $createPermissionsGrid(){
  var grid;
  grid = new ListGrid_0;
  $setAttribute_24(grid, 'autoFitData', ($clinit_Autofit() , BOTH_0).value_0, true);
  $setWrapCells(grid, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setFixedRecordHeights(grid, FALSE);
  return grid;
}

function $createResourcePermissionRecord(this$static, displayName, icon, readPermission, readDescription, writePermission, writeDescription){
  var record;
  record = new ListGridRecord_0;
  record.jsObj['displayName'] = displayName;
  record.jsObj['icon'] = icon;
  $setAttribute_13(record, 'readName', readPermission.name_0);
  $setAttribute_16(record, 'readAuthorized', this$static.selectedPermissions.contains(readPermission));
  record.jsObj['description'] = '<b>\u8AAD\u307F\u53D6\u308A:<\/b> ' + readDescription + '<br/><b>\u66F8\u304D\u8FBC\u307F:<\/b> ' + writeDescription;
  $setAttribute_13(record, 'writeName', writePermission.name_0);
  $setAttribute_16(record, 'writeAuthorized', this$static.selectedPermissions.contains(writePermission));
  return record;
}

function $createVerticalSpacer(){
  var spacer;
  spacer = new VLayout_0;
  $isCreated_1(spacer)?$setProperty_1(spacer, 'height', 13):(spacer.config_0['height'] = 13 , undefined);
  return spacer;
}

function $redraw_1(this$static){
  var bundleGroupPermissionRecords, globalPermissionRecords, permission, permissionName, readPermission, readPermissionName, record, record$index, record$max, resourcePermissionRecords, writePermission, writePermissionName, nativeArray, permissionRecords;
  this$static.selectedPermissions = (nativeArray = $getValue(this$static.roleEditView.form_0, 'permissions') , this$static.originalValue == null && (this$static.originalValue = nativeArray) , permissionRecords = convertToListGridRecordArray_0(dynamicCastJso(nativeArray)) , toPermissionSet(permissionRecords));
  globalPermissionRecords = this$static.globalPermissionsGrid.getRecords();
  for (record$index = 0 , record$max = globalPermissionRecords.length; record$index < record$max; ++record$index) {
    record = globalPermissionRecords[record$index];
    permissionName = getAttribute(record.jsObj, 'name');
    permission = ($clinit_Permission() , dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_54), permissionName), Q$Permission));
    $setAttribute_16(record, 'authorized', this$static.selectedPermissions.contains(permission));
  }
  resourcePermissionRecords = this$static.resourcePermissionsGrid.getRecords();
  for (record$index = 0 , record$max = resourcePermissionRecords.length; record$index < record$max; ++record$index) {
    record = resourcePermissionRecords[record$index];
    readPermissionName = getAttribute(record.jsObj, 'readName');
    readPermission = ($clinit_Permission() , dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_54), readPermissionName), Q$Permission));
    $setAttribute_16(record, 'readAuthorized', this$static.selectedPermissions.contains(readPermission));
    writePermissionName = getAttribute(record.jsObj, 'writeName');
    writePermission = dynamicCast(valueOf($MAP_54, writePermissionName), Q$Permission);
    $setAttribute_16(record, 'writeAuthorized', this$static.selectedPermissions.contains(writePermission));
  }
  bundleGroupPermissionRecords = this$static.bundleGroupPermissionsGrid.getRecords();
  for (record$index = 0 , record$max = bundleGroupPermissionRecords.length; record$index < record$max; ++record$index) {
    record = bundleGroupPermissionRecords[record$index];
    permissionName = getAttribute(record.jsObj, 'name');
    permission = ($clinit_Permission() , dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_54), permissionName), Q$Permission));
    $setAttribute_16(record, 'authorized', this$static.selectedPermissions.contains(permission));
  }
  $markForRedraw(this$static);
}

function $updatePermissions(this$static, authorized, permission){
  var message, messageString, permissionRecords, redrawRequired;
  messageString = null;
  redrawRequired = false;
  if (authorized.value_0) {
    this$static.selectedPermissions.add_0(permission);
    if (permission == ($clinit_Permission() , MANAGE_SECURITY)) {
      if (this$static.selectedPermissions.addAll(allOf(Lorg_rhq_core_domain_authz_Permission_2_classLit))) {
        messageString = 'MANAGE_INVENTORY \u306F\u4ED6\u306E\u3059\u3079\u3066\u306E\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u6697\u793A\u3059\u308B\u305F\u3081\u3001\u672A\u9078\u629E\u306E\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u304C\u81EA\u52D5\u9078\u629E\u3055\u308C\u307E\u3057\u305F\u3002';
        redrawRequired = true;
      }
    }
     else if (permission == MANAGE_INVENTORY) {
      if (this$static.selectedPermissions.addAll(RESOURCE_ALL)) {
        messageString = 'MANAGE_INVENTORY \u306F\u3059\u3079\u3066\u306E\u30EA\u30BD\u30FC\u30B9\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u6697\u793A\u3059\u308B\u305F\u3081\u3001\u672A\u9078\u629E\u306E\u30EA\u30BD\u30FC\u30B9\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u304C\u81EA\u52D5\u9078\u629E\u3055\u308C\u307E\u3057\u305F\u3002';
        redrawRequired = true;
      }
    }
     else if (permission == CONFIGURE_WRITE) {
      if (this$static.selectedPermissions.add_0(CONFIGURE_READ)) {
        messageString = 'CONFIGURE_WRITE \u304C\u6697\u793A\u3059\u308B\u305F\u3081\u3001CONFIGURE_READ \u304C\u81EA\u52D5\u9078\u629E\u3055\u308C\u307E\u3057\u305F\u3002';
        redrawRequired = true;
      }
    }
     else if (permission == MANAGE_BUNDLE) {
      if (this$static.selectedPermissions.addAll(BUNDLE_ALL)) {
        messageString = 'Manage Bundle \u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u306F\u3001Manage Bundle Groups\u3001Create Bundles\u3001Delete Bundles\u3001View Bundles\u3001\u304A\u3088\u3073 Deploy_Bundles \u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u4ED8\u4E0E\u3059\u308B\u305F\u3081\u3001\u672A\u9078\u629E\u306E\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u304C\u81EA\u52D5\u9078\u629E\u3055\u308C\u307E\u3057\u305F\u3002';
        redrawRequired = true;
      }
    }
     else if (permission == MANAGE_BUNDLE_GROUPS) {
      if (this$static.selectedPermissions.add_0(VIEW_BUNDLES)) {
        messageString = 'Manage Bundle Groups \u306B\u3088\u3063\u3066\u4ED8\u4E0E\u3055\u308C\u308B View Bundle \u304C\u81EA\u52D5\u9078\u629E\u3055\u308C\u307E\u3057\u305F...';
        redrawRequired = true;
      }
    }
  }
   else {
    this$static.selectedPermissions.remove_1(permission);
  }
  permissionRecords = toRecordArray(this$static.selectedPermissions);
  $setValue_2(this$static.roleEditView.form_0, 'permissions', permissionRecords);
  redrawRequired && $redraw_1(this$static);
  if (messageString != null) {
    message = new Message_6(messageString, of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), message);
  }
}

function PermissionsEditor_0(roleEditView, isReadOnly){
  var productInfo, grid, iconField, displayNameField, descriptionField, authorizedField, records, record, grid_0, iconField_0, displayNameField_0, descriptionField_0, readField, writeField, records_0, record_0, grid_1, iconField_1, displayNameField_1, descriptionField_1, authorizedField_0, records_1, record_1;
  $clinit_PermissionsEditor();
  var bundleGroupPermissionsHeader, globalPermissionsHeader, resourcePermissionsHeader, spacer;
  EnhancedVStack_0.call(this);
  this.roleEditView = roleEditView;
  this.isReadOnly = isReadOnly;
  this.selectedPermissions = of_0(($clinit_Permission() , VIEW_RESOURCE), initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [VIEW_BUNDLES_IN_GROUP]));
  $isCreated_1(this)?$setProperty_4(this, 'width', '95%'):(this.config_0['width'] = '95%' , undefined);
  $isCreated_1(this)?$setProperty_4(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  spacer = $createVerticalSpacer();
  $addMember(this, spacer);
  globalPermissionsHeader = new Label_4('<h4>\u30B0\u30ED\u30FC\u30D0\u30EB\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3<\/h4>');
  $isCreated_1(globalPermissionsHeader)?$setProperty_1(globalPermissionsHeader, 'height', 17):(globalPermissionsHeader.config_0['height'] = 17 , undefined);
  $addMember(this, globalPermissionsHeader);
  this.globalPermissionsGrid = (productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo , grid = $createPermissionsGrid() , iconField = $createIconField() , displayNameField = new ListGridField_4('displayName', '\u540D\u524D', 130) , descriptionField = new ListGridField_3('description', '\u8AAC\u660E') , descriptionField.jsObj['wrap'] = true , authorizedField = $createAuthorizedField(this, 'authorized', '\u6A29\u9650\u304C\u3042\u308B\u304B?', 'name', grid, false) , $isCreated_1(grid)?$setProperty_3(grid, 'fields', convertToJavaScriptArray_0(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [iconField, displayNameField, authorizedField, descriptionField]))):(grid.config_0['fields'] = convertToJavaScriptArray_0(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [iconField, displayNameField, authorizedField, descriptionField])) , undefined) , records = new ArrayList_0 , record = $createPermissionRecord(this, '\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u306E\u7BA1\u7406', 'global/Locked', MANAGE_SECURITY, '\u30E6\u30FC\u30B6\u30FC\u304A\u3088\u3073\u30ED\u30FC\u30EB\u306E\u4F5C\u6210\u3001\u66F4\u65B0\u3001\u307E\u305F\u306F\u524A\u9664\u304C\u53EF\u80FD\u3067\u3059 - \u4ED6\u306E\u3059\u3079\u3066\u306E\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u6697\u793A\u3057\u307E\u3059') , records.add_0(record) , record = $createPermissionRecord(this, '\u30A4\u30F3\u30D9\u30F3\u30C8\u30EA\u306E\u7BA1\u7406', 'subsystems/inventory/Inventory', MANAGE_INVENTORY, '\u3059\u3079\u3066\u306E\u30EA\u30BD\u30FC\u30B9\u306B\u5BFE\u3057\u3001\u4E0B\u8A18\u306E\u3068\u304A\u308A\u3059\u3079\u3066\u306E\u30EA\u30BD\u30FC\u30B9\u30D1\u30FC\u30DF\u30C3\u30B7\u30E7\u30F3\u3092\u6301\u3061\u307E\u3059\u3002\u30B0\u30EB\u30FC\u