/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.bean;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.UnlimitedPageControl;
import org.rhq.core.gui.table.model.PagedListDataModel;

public abstract class AbstractPagedDataUIBean<T> {
    private static final int[] PAGE_SIZES = new int[]{15, 30, 45};
    private static final SelectItem[] PAGE_SIZE_SELECT_ITEMS = new SelectItem[PAGE_SIZES.length];
    private static final int MINIMUM_PAGE_SIZE;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DATA_SCROLLER_MAX_PAGES = 7;
    private PageControl pageControl;
    private PagedListDataModel<T> dataModel;

    public SelectItem[] getPageSizeSelectItems() {
        return PAGE_SIZE_SELECT_ITEMS;
    }

    public int getPageSizeCount() {
        return PAGE_SIZES.length;
    }

    public int getMinimumPageSize() {
        return MINIMUM_PAGE_SIZE;
    }

    public int getDefaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public int getDataScrollerMaxPages() {
        return 7;
    }

    public int getDataScrollerPage() {
        return this.getPageControl().getPageNumber() + 1;
    }

    public void setDataScrollerPage(int i) {
        this.getPageControl().setPageNumber(i - 1);
    }

    @NotNull
    public PageControl getPageControl() {
        if (this.pageControl == null) {
            this.pageControl = this.loadPageControl(FacesContext.getCurrentInstance());
            if (this.pageControl == null) {
                this.pageControl = this.getDefaultPageControl();
                if (this.pageControl == null) {
                    throw new IllegalStateException("getDefaultPageControl() returned null - this is not allowed.");
                }
            }
        }
        if (!(this.pageControl instanceof UnlimitedPageControl)) {
            String pageSize = String.valueOf(this.pageControl.getPageSize());
            boolean hasValidSize = false;
            for (SelectItem validPageSize : this.getPageSizeSelectItems()) {
                if (!validPageSize.getValue().toString().equals(pageSize)) continue;
                hasValidSize = true;
                break;
            }
            if (!hasValidSize) {
                this.pageControl.setPageSize(this.getMinimumPageSize());
                this.storePageControl(FacesContext.getCurrentInstance(), this.pageControl);
            }
        }
        return this.pageControl;
    }

    public void setPageControl(PageControl pageControl) {
        this.pageControl = pageControl;
        this.storePageControl(FacesContext.getCurrentInstance(), this.pageControl);
        this.dataModel.reset();
    }

    public void resetPageControl() {
        this.setPageControl(null);
    }

    protected PageControl getDefaultPageControl() {
        return new PageControl(0, MINIMUM_PAGE_SIZE);
    }

    protected PageControl loadPageControl(FacesContext context) {
        return null;
    }

    protected void storePageControl(FacesContext context, PageControl pageControl) {
    }

    public PagedListDataModel<T> getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = this.createDataModel();
        }
        return this.dataModel;
    }

    public void setDataModel(PagedListDataModel<T> dataModel) {
        this.dataModel = dataModel;
    }

    public abstract PagedListDataModel<T> createDataModel();

    static {
        for (int i = 0; i < PAGE_SIZES.length; ++i) {
            AbstractPagedDataUIBean.PAGE_SIZE_SELECT_ITEMS[i] = new SelectItem((Object)PAGE_SIZES[i], Integer.valueOf(PAGE_SIZES[i]).toString());
        }
        MINIMUM_PAGE_SIZE = PAGE_SIZES[0];
        DEFAULT_PAGE_SIZE = PAGE_SIZES[0];
    }
}

