/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.rhq.core.clientapi.util.TimeUtil;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.Formatter;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsUtil;

public class DateFormatter
implements Formatter {
    public FormattedNumber format(UnitNumber val, Locale locale) {
        DateSpecifics specifics = new DateSpecifics();
        specifics.setDateFormat(this.getDefaultFormat(locale));
        return this.format(val, locale, specifics);
    }

    @Override
    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        BigDecimal dec = val.getBaseValue().divide(UnitsUtil.FACT_MILLIS, 6);
        DateFormat df = specifics == null ? this.getDefaultFormat(locale) : ((DateSpecifics)specifics).getDateFormat();
        return new FormattedNumber(df.format(new Date(dec.longValue())), "");
    }

    public FormattedNumber[] formatSame(double[] val, UnitsConstants unitType, ScaleConstants scale, Locale locale) {
        FormattedNumber[] res = new FormattedNumber[val.length];
        for (int i = 0; i < val.length; ++i) {
            res[i] = this.format(new UnitNumber(val[i], unitType, scale), locale);
        }
        return res;
    }

    @Override
    public FormattedNumber[] formatSame(double[] val, UnitsConstants unitType, ScaleConstants scale, Locale locale, FormatSpecifics specifics) {
        FormattedNumber[] res = new FormattedNumber[val.length];
        for (int i = 0; i < val.length; ++i) {
            res[i] = this.format(new UnitNumber(val[i], unitType, scale), locale, specifics);
        }
        return res;
    }

    private DateFormat getDefaultFormat(Locale locale) {
        return DateFormat.getDateTimeInstance(3, 2, locale);
    }

    @Override
    public BigDecimal getBaseValue(double value, ScaleConstants scale) {
        return DateFormatter.getBaseTime(value, scale);
    }

    @Override
    public BigDecimal getScaledValue(BigDecimal value, ScaleConstants targScale) {
        return DateFormatter.getScaledTime(value, targScale);
    }

    public static BigDecimal getScaledTime(BigDecimal value, ScaleConstants targScale) {
        return value.divide(DateFormatter.getScaleCoeff(targScale), 6);
    }

    public static BigDecimal getBaseTime(double value, ScaleConstants scale) {
        BigDecimal res = new BigDecimal(value);
        return res.multiply(DateFormatter.getScaleCoeff(scale));
    }

    private static BigDecimal getScaleCoeff(ScaleConstants scale) {
        switch (scale) {
            case SCALE_NONE: {
                return UnitsUtil.FACT_NONE;
            }
            case SCALE_NANO: {
                return UnitsUtil.FACT_NANOS;
            }
            case SCALE_MICRO: {
                return UnitsUtil.FACT_MICROS;
            }
            case SCALE_MILLI: {
                return UnitsUtil.FACT_MILLIS;
            }
            case SCALE_JIFFY: {
                return UnitsUtil.FACT_JIFFYS;
            }
            case SCALE_SEC: {
                return UnitsUtil.FACT_SECS;
            }
            case SCALE_MIN: {
                return UnitsUtil.FACT_MINS;
            }
            case SCALE_HOUR: {
                return UnitsUtil.FACT_HOURS;
            }
            case SCALE_DAY: {
                return UnitsUtil.FACT_DAYS;
            }
            case SCALE_WEEK: {
                return UnitsUtil.FACT_WEEKS;
            }
            case SCALE_YEAR: {
                return UnitsUtil.FACT_YEARS;
            }
        }
        throw new IllegalArgumentException("Value did not have time based scale");
    }

    @Override
    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        long curTime = System.currentTimeMillis();
        return new UnitNumber(TimeUtil.parseComplexTime(val, curTime, false), UnitsConstants.UNIT_DATE, ScaleConstants.SCALE_MILLI);
    }

    public static class DateSpecifics
    extends FormatSpecifics {
        private DateFormat df;

        public void setDateFormat(DateFormat df) {
            this.df = df;
        }

        public DateFormat getDateFormat() {
            return this.df;
        }
    }
}

