/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.cassandra.util.KeyspaceService;
import org.rhq.plugins.jmx.JMXComponent;

public class KeyspaceComponent
implements ResourceComponent<ResourceComponent<?>>,
ConfigurationFacet,
JMXComponent<ResourceComponent<?>>,
OperationFacet {
    private final Log log = LogFactory.getLog(KeyspaceComponent.class);
    private ResourceContext<ResourceComponent<?>> context;

    public void start(ResourceContext<ResourceComponent<?>> context) throws Exception {
        this.context = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.context.getParentResourceComponent().getAvailability();
    }

    public EmsConnection getEmsConnection() {
        JMXComponent parent = (JMXComponent)this.context.getParentResourceComponent();
        return parent.getEmsConnection();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("name", (Object)this.context.getResourceKey()));
        config.put((Property)this.getKeySpaceDataFileLocations());
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.NOCHANGE);
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("repair")) {
            return this.repairKeyspace(new String[0]);
        }
        if (name.equals("repairPrimaryRange")) {
            return this.repairPrimaryRange();
        }
        if (name.equals("compact")) {
            return this.compactKeyspace(new String[0]);
        }
        if (name.equals("takeSnapshot")) {
            return this.takeSnapshot(parameters, new String[0]);
        }
        if (name.equals("cleanup")) {
            return this.cleanup();
        }
        OperationResult failedOperation = new OperationResult();
        failedOperation.setErrorMessage("Operation not implemented.");
        return failedOperation;
    }

    public OperationResult repairKeyspace(String ... columnFamilies) {
        KeyspaceService keyspaceService = new KeyspaceService(this.getEmsConnection());
        String keyspace = this.context.getResourceKey();
        if (columnFamilies == null) {
            columnFamilies = new String[]{};
        }
        this.log.info((Object)("Executing repair on keyspace [" + keyspace + "]"));
        long start = System.currentTimeMillis();
        keyspaceService.repair(keyspace, columnFamilies);
        long end = System.currentTimeMillis();
        this.log.info((Object)("Finished repair on keyspace [" + keyspace + "] in " + (end - start) + " ms"));
        return new OperationResult();
    }

    public OperationResult repairPrimaryRange() {
        KeyspaceService keyspaceService = new KeyspaceService(this.getEmsConnection());
        String keyspace = this.context.getResourceKey();
        this.log.info((Object)("Executing primary range repair on keyspace [" + keyspace + "]"));
        long start = System.currentTimeMillis();
        keyspaceService.repairPrimaryRange(keyspace, new String[0]);
        long end = System.currentTimeMillis();
        this.log.info((Object)("Finished primary range repair on keyspace [" + keyspace + " in (" + (end - start) + " ms"));
        return new OperationResult();
    }

    public OperationResult cleanup() {
        KeyspaceService keyspaceService = new KeyspaceService(this.getEmsConnection());
        String keyspace = this.context.getResourceKey();
        this.log.info((Object)("Executing cleanup on keyspace [" + keyspace + "]"));
        long start = System.currentTimeMillis();
        keyspaceService.cleanup(keyspace);
        long end = System.currentTimeMillis();
        this.log.info((Object)("Finished cleanup on keyspace [" + keyspace + "] in " + (end - start) + " ms"));
        return new OperationResult();
    }

    public OperationResult compactKeyspace(String ... columnFamilies) {
        KeyspaceService keyspaceService = new KeyspaceService(this.getEmsConnection());
        String keyspace = this.context.getResourceKey();
        if (columnFamilies == null) {
            columnFamilies = new String[]{};
        }
        this.log.info((Object)("Executing compaction on  keyspace [" + keyspace + "]"));
        long start = System.currentTimeMillis();
        keyspaceService.compact(keyspace, columnFamilies);
        long end = System.currentTimeMillis();
        this.log.info((Object)("Finished compaction on keysapce [" + keyspace + "] in " + (end - start) + " ms"));
        return new OperationResult();
    }

    public OperationResult takeSnapshot(Configuration parameters, String ... columnFamilies) {
        EmsOperation operation;
        String keyspace = this.context.getResourceKey();
        String snapshotName = parameters.getSimpleValue("snapshotName");
        if (snapshotName == null || snapshotName.trim().isEmpty()) {
            snapshotName = System.currentTimeMillis() + "";
        }
        this.log.info((Object)("Taking snapshot of keyspace [" + keyspace + "]"));
        this.log.info((Object)("Snapshot name set to [" + snapshotName + "]"));
        long start = System.currentTimeMillis();
        EmsBean emsBean = this.loadBean("org.apache.cassandra.db:type=StorageService");
        if (columnFamilies == null || columnFamilies.length == 0) {
            operation = emsBean.getOperation("takeSnapshot", new Class[]{String.class, String[].class});
            operation.invoke(new Object[]{snapshotName, new String[]{keyspace}});
        } else {
            operation = emsBean.getOperation("takeColumnFamilySnapshot", new Class[]{String.class, String.class, String.class});
            for (String columnFamily : columnFamilies) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Taking snapshot of column family [" + columnFamily + "]"));
                }
                operation.invoke(new Object[]{keyspace, columnFamily, snapshotName});
            }
        }
        long end = System.currentTimeMillis();
        this.log.info((Object)("Finished taking snapshot of keyspace [" + keyspace + "] in " + (end - start) + " ms"));
        return new OperationResult();
    }

    public PropertyList getKeySpaceDataFileLocations() {
        String[] dirs;
        EmsBean emsBean = this.loadBean("org.apache.cassandra.db:type=StorageService");
        EmsAttribute attribute = emsBean.getAttribute("AllDataFileLocations");
        PropertyList list = new PropertyList("keyspaceFileLocations");
        for (String dir : dirs = (String[])attribute.getValue()) {
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            list.add((Property)new PropertySimple("directory", (Object)(dir + this.context.getResourceKey())));
        }
        return list;
    }

    public PropertySimple getCommitLogProperty() {
        EmsBean emsBean = this.loadBean("org.apache.cassandra.db:type=StorageService");
        EmsAttribute attribute = emsBean.getAttribute("CommitLogLocation");
        return new PropertySimple("CommitLogLocation", attribute.refresh());
    }

    public boolean clearCommitLog() {
        File[] commitLogFiles;
        PropertySimple commitLogProperty = this.getCommitLogProperty();
        File commitLogFolder = new File(commitLogProperty.getStringValue());
        for (File file : commitLogFiles = commitLogFolder.listFiles()) {
            file.delete();
        }
        return true;
    }

    public CassandraNodeComponent getCassandraNodeComponent() {
        return (CassandraNodeComponent)this.context.getParentResourceComponent();
    }

    protected EmsBean loadBean(String objectName) {
        EmsConnection emsConnection = this.getEmsConnection();
        if (emsConnection != null) {
            EmsBean bean = emsConnection.getBean(objectName);
            if (bean == null) {
                emsConnection.queryBeans(objectName);
                bean = emsConnection.getBean(objectName);
            }
            return bean;
        }
        return null;
    }

    public String getKeyspaceName() {
        return this.context.getResourceKey();
    }
}

