/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;

public class KeyspaceDiscoveryComponent
implements ResourceDiscoveryComponent<JMXComponent<?>> {
    private static final String STORAGE_SERVICE_BEAN = "org.apache.cassandra.db:type=StorageService";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context) throws Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        for (Object keyspaceName : this.getKeyspaces(((JMXComponent)context.getParentResourceComponent()).getEmsConnection())) {
            details.add(new DiscoveredResourceDetails(context.getResourceType(), keyspaceName.toString(), keyspaceName.toString(), null, null, null, null));
        }
        return details;
    }

    private List<Object> getKeyspaces(EmsConnection emsConnection) {
        EmsAttribute attribute;
        List value = null;
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN, emsConnection);
        if (emsBean != null && (attribute = emsBean.getAttribute("Keyspaces")) != null) {
            value = (List)attribute.refresh();
        }
        if (value == null) {
            value = new ArrayList();
        }
        return value;
    }

    private EmsBean loadBean(String objectName, EmsConnection emsConnection) {
        if (emsConnection != null) {
            EmsBean bean = emsConnection.getBean(objectName);
            if (bean == null) {
                emsConnection.queryBeans(objectName);
                bean = emsConnection.getBean(objectName);
            }
            return bean;
        }
        return null;
    }
}

