/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import org.joda.time.DateTime;
import org.rhq.server.metrics.ArithmeticMeanCalculator;

public class Buckets {
    private int numDataPoints = 60;
    private Bucket[] buckets;
    private long interval;

    public Buckets(DateTime beginTime, DateTime endTime) {
        this(beginTime.getMillis(), endTime.getMillis());
    }

    public Buckets(long beginTime, long endTime, int numberOfDataPoints) {
        if (numberOfDataPoints <= 0) {
            throw new IllegalArgumentException("Number of buckets must be > 0");
        }
        this.numDataPoints = numberOfDataPoints;
        this.buckets = new Bucket[this.numDataPoints];
        this.interval = (endTime - beginTime) / (long)this.numDataPoints;
        for (int i = 1; i <= this.numDataPoints; ++i) {
            this.buckets[i - 1] = new Bucket(beginTime + this.interval * (long)(i - 1), beginTime + this.interval * (long)i);
        }
    }

    public Buckets(long beginTime, long endTime) {
        this(beginTime, endTime, 60);
    }

    public int getNumDataPoints() {
        return this.numDataPoints;
    }

    public long getInterval() {
        return this.interval;
    }

    public Bucket get(int index) {
        return this.buckets[index];
    }

    public void insert(long timestamp, double value, double min, double max) {
        for (Bucket bucket : this.buckets) {
            if (timestamp < bucket.getStartTime() || timestamp >= bucket.getEndTime()) continue;
            bucket.insert(value, min, max);
            return;
        }
    }

    static class Bucket {
        private long startTime;
        private long endTime;
        private ArithmeticMeanCalculator mean;
        private double max;
        private double min;
        private int count;

        public Bucket(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.mean = new ArithmeticMeanCalculator();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Bucket insert(double value, double min, double max) {
            this.mean.add(value);
            if (this.count == 0) {
                this.min = min;
                this.max = max;
            } else if (min < this.min) {
                this.min = min;
            } else if (max > this.max) {
                this.max = max;
            }
            ++this.count;
            return this;
        }

        public double getAvg() {
            if (this.count == 0) {
                return Double.NaN;
            }
            return this.mean.getArithmeticMean();
        }

        public double getMax() {
            if (this.count == 0) {
                return Double.NaN;
            }
            return this.max;
        }

        public double getMin() {
            if (this.count == 0) {
                return Double.NaN;
            }
            return this.min;
        }
    }
}

