/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;

public class OracleAsmDiskGroupDiscoveryComponent
implements ResourceDiscoveryComponent<ResourceComponent<?>> {
    private static final Log LOG = LogFactory.getLog(OracleAsmDiskGroupDiscoveryComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ResourceComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        block9: {
            HashSet<DiscoveredResourceDetails> hashSet;
            String table = "V$ASM_DISKGROUP";
            String keyColumn = "GROUP_NUMBER";
            String nameColumn = "NAME";
            String description = "Oracle ASM Disk Groups";
            ResourceComponent parentComponent = resourceDiscoveryContext.getParentResourceComponent();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                connection = DatabasePluginUtil.getConnectionFromComponent((ResourceComponent)parentComponent);
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT * FROM " + table);
                Configuration config = null;
                HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
                while (resultSet.next()) {
                    config = resourceDiscoveryContext.getDefaultPluginConfiguration();
                    String key = resultSet.getString(keyColumn);
                    String name = resultSet.getString(nameColumn);
                    DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), key, name, null, description, config, null);
                    found.add(details);
                }
                hashSet = found;
                DatabasePluginUtil.safeClose(null, (Statement)statement, (ResultSet)resultSet);
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("table " + table + " column " + keyColumn), (Throwable)e);
                }
                break block9;
            }
            finally {
                DatabasePluginUtil.safeClose(null, (Statement)statement, resultSet);
                if (DatabasePluginUtil.hasConnectionPoolingSupport((ResourceComponent)parentComponent)) {
                    DatabasePluginUtil.safeClose((Connection)connection);
                }
            }
            if (DatabasePluginUtil.hasConnectionPoolingSupport((ResourceComponent)parentComponent)) {
                DatabasePluginUtil.safeClose((Connection)connection);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }
}

