/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.storage;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.plugins.cassandra.CassandraNodeDiscoveryComponent;

public class StorageNodeDiscoveryComponent
extends CassandraNodeDiscoveryComponent {
    private final Log log = LogFactory.getLog(StorageNodeDiscoveryComponent.class);
    private static final String RESOURCE_NAME = "RHQ Storage Node";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        Set discoveredResources = this.scanForResources(context);
        HashSet<DiscoveredResourceDetails> storageNodes = new HashSet<DiscoveredResourceDetails>();
        for (DiscoveredResourceDetails discoveredResource : discoveredResources) {
            String resourceKey;
            Configuration configuration = discoveredResource.getPluginConfiguration();
            if (this.isCassandraNode(discoveredResource)) continue;
            String resourceName = resourceKey = "RHQ Storage Node(" + configuration.getSimpleValue("host", "localhost") + ")";
            discoveredResource.setResourceKey(resourceKey);
            discoveredResource.setResourceName(resourceName);
            try {
                Properties properties = new Properties();
                properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/rhq-storage.properties"));
                discoveredResource.setResourceDescription(properties.getProperty("rhq.storage.description"));
                discoveredResource.setResourceVersion(properties.getProperty("rhq.storage.version"));
            }
            catch (IOException e) {
                this.log.warn((Object)"Failed to load rhq-storage.properties. Some resource details will not be set.", (Throwable)e);
            }
            storageNodes.add(discoveredResource);
        }
        return storageNodes;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext ruc) {
        ResourceUpgradeReport result = null;
        ResourceDiscoveryContext dc = new ResourceDiscoveryContext(ruc.getResourceType(), ruc.getParentResourceComponent(), ruc.getParentResourceContext(), ruc.getSystemInformation(), ruc.getNativeProcessesForType(), ruc.getPluginContainerName(), ruc.getPluginContainerDeployment());
        Set<DiscoveredResourceDetails> discoveredResources = this.discoverResources(dc);
        boolean upgrade = false;
        for (DiscoveredResourceDetails drd : discoveredResources) {
            if (!drd.getResourceKey().equals(ruc.getResourceKey())) continue;
            Configuration newPluginConfig = drd.getPluginConfiguration();
            Configuration oldPluginConfig = ruc.getPluginConfiguration();
            String newCommandLine = newPluginConfig.getSimpleValue("commandLine");
            String oldCommandLine = oldPluginConfig.getSimpleValue("commandLine");
            if (null != newCommandLine && !newCommandLine.equals(oldCommandLine)) {
                oldPluginConfig.put((Property)new PropertySimple("commandLine", (Object)newCommandLine));
                upgrade = true;
            }
            String newBasedir = newPluginConfig.getSimpleValue("baseDir");
            String oldBasedir = oldPluginConfig.getSimpleValue("baseDir");
            if (null != newBasedir && !newBasedir.equals(oldBasedir)) {
                oldPluginConfig.put((Property)new PropertySimple("baseDir", (Object)newBasedir));
                upgrade = true;
            }
            String newYaml = newPluginConfig.getSimpleValue("yamlConfiguration");
            String oldYaml = oldPluginConfig.getSimpleValue("yamlConfiguration");
            if (null != newYaml && !newYaml.equals(oldYaml)) {
                oldPluginConfig.put((Property)new PropertySimple("yamlConfiguration", (Object)newYaml));
                upgrade = true;
            }
            if (!upgrade) break;
            result = new ResourceUpgradeReport();
            result.setNewPluginConfiguration(oldPluginConfig);
            break;
        }
        return result;
    }
}

