/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.SchemaManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class UpdateFile
implements Comparable<UpdateFile> {
    private static final String UPDATE_PLAN_ELEMENT = "updatePlan";
    private static final String STEP_ELEMENT = "step";
    private final Log log = LogFactory.getLog(UpdateFile.class);
    private final String file;

    public UpdateFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public String getNamedStep(String name) {
        return this.getNamedStep(name, null);
    }

    public String getNamedStep(String name, Properties properties) {
        List<Node> stepNodes = this.getStepNodes();
        for (Node stepNode : stepNodes) {
            Node nameNode = stepNode.getAttributes().getNamedItem("name");
            if (nameNode == null || !nameNode.getNodeValue().equals(name)) continue;
            return this.bind(stepNode.getTextContent(), properties);
        }
        return null;
    }

    public List<String> getOrderedSteps() {
        return this.getOrderedSteps(null);
    }

    public List<String> getOrderedSteps(Properties properties) {
        ArrayList<String> boundSteps = new ArrayList<String>();
        List<Node> stepNodes = this.getStepNodes();
        for (Node stepNode : stepNodes) {
            boundSteps.add(this.bind(stepNode.getTextContent(), properties));
        }
        return boundSteps;
    }

    private List<Node> getStepNodes() {
        InputStream stream = null;
        try {
            stream = SchemaManager.class.getClassLoader().getResourceAsStream(this.file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            NodeList updateElements = doc.getElementsByTagName(UPDATE_PLAN_ELEMENT);
            if (updateElements == null || updateElements.getLength() != 1) {
                throw new RuntimeException("No <updatePlan> elements found");
            }
            Node rootDocument = updateElements.item(0);
            NodeList updateStepElements = rootDocument.getChildNodes();
            ArrayList<Node> stepList = new ArrayList<Node>();
            for (int index = 0; index < updateStepElements.getLength(); ++index) {
                Node updateStepElement = updateStepElements.item(index);
                if (!STEP_ELEMENT.equals(updateStepElement.getNodeName()) || updateStepElement.getTextContent() == null) continue;
                stepList.add(updateStepElements.item(index));
            }
            ArrayList<Node> arrayList = stepList;
            return arrayList;
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading the list of steps from " + this.file + " file."), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error closing the stream with the list of steps from " + this.file + " file."), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String bind(String unboundText, Properties properties) {
        HashSet<String> foundProperties = new HashSet<String>();
        Pattern regex = Pattern.compile("\\%([^%]*)\\%");
        Matcher matchPattern = regex.matcher(unboundText);
        while (matchPattern.find()) {
            String matchedString = matchPattern.group();
            String property = matchedString.substring(1, matchedString.length() - 1);
            foundProperties.add(property);
        }
        String boundText = unboundText;
        if (foundProperties.size() != 0 && properties == null) {
            throw new RuntimeException("No properties provided but " + foundProperties.size() + " required for binding.");
        }
        if (foundProperties.size() != 0) {
            for (String foundProperty : foundProperties) {
                String propertyValue = properties.getProperty(foundProperty);
                if (propertyValue == null) {
                    throw new RuntimeException("Cannot bind query. Property [" + foundProperty + "] not found.");
                }
                boundText = boundText.replaceAll("\\%" + foundProperty + "\\%", propertyValue);
            }
        }
        return boundText;
    }

    public int extractVersion() {
        String filename = this.getFile();
        filename = filename.substring(filename.lastIndexOf(47) + 1);
        filename = filename.substring(0, filename.indexOf(46));
        return Integer.parseInt(filename);
    }

    @Override
    public int compareTo(UpdateFile o) {
        return this.getFile().compareTo(o.getFile());
    }
}

