/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.event.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;

public abstract class MultiLineLogEntryProcessor
implements LogEntryProcessor {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected String eventType;
    protected File logFile;
    protected EventSeverity minimumSeverity;
    protected Pattern includesPattern;
    protected DateFormat dateFormat;

    public MultiLineLogEntryProcessor(String eventType, File logFile) {
        this.eventType = eventType;
        this.logFile = logFile;
    }

    @Override
    @Nullable
    public Set<Event> processLines(BufferedReader bufferedReader) throws IOException {
        String line;
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        LogEntry currentEntry = null;
        while ((line = bufferedReader.readLine()) != null) {
            currentEntry = this.processLine(line, events, currentEntry);
        }
        this.addEventForCurrentEntry(events, currentEntry);
        return events;
    }

    public void setMinimumSeverity(EventSeverity minimumSeverity) {
        this.minimumSeverity = minimumSeverity;
    }

    public void setIncludesPattern(Pattern includesPattern) {
        this.includesPattern = includesPattern;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected LogEntry processLine(String line, Set<Event> events, LogEntry currentEntry) {
        Matcher matcher = this.getPattern().matcher(line);
        if (matcher.matches()) {
            this.addEventForCurrentEntry(events, currentEntry);
            try {
                currentEntry = this.processPrimaryLine(matcher);
            }
            catch (ParseException e) {
                this.log.warn((Object)("Failed to parse line [" + line + "]."));
                currentEntry = null;
            }
        } else if (currentEntry != null) {
            currentEntry.appendLineToDetail(line);
        }
        return currentEntry;
    }

    protected abstract Pattern getPattern();

    private void addEventForCurrentEntry(Set<Event> events, LogEntry currentEntry) {
        if (currentEntry != null && currentEntry.getSeverity().isAtLeastAsSevereAs(this.minimumSeverity) && (this.includesPattern == null || this.includesPattern.matcher(currentEntry.getDetail()).find())) {
            Event event = new Event(this.eventType, this.logFile.getPath(), currentEntry.getDate().getTime(), currentEntry.getSeverity(), currentEntry.getDetail());
            events.add(event);
        }
    }

    protected abstract LogEntry processPrimaryLine(Matcher var1) throws ParseException;

    protected abstract DateFormat getDefaultDateFormat();

    protected Date parseDateString(String dateString) throws ParseException {
        DateFormat dateFormat;
        Date timestamp = null;
        DateFormat dateFormat2 = dateFormat = this.dateFormat != null ? this.dateFormat : this.getDefaultDateFormat();
        if (dateFormat != null) {
            try {
                timestamp = dateFormat.parse(dateString);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Unable to parse date [" + dateString + "] using date format [" + dateFormat + "].", e);
            }
            catch (RuntimeException e) {
                throw new ParseException("Unable to parse date [" + dateString + "] using date format [" + dateFormat + "].", e);
            }
            MultiLineLogEntryProcessor.setDateIfNotSet(timestamp);
        }
        return timestamp;
    }

    protected static void setDateIfNotSet(Date timestamp) {
        Calendar date = MultiLineLogEntryProcessor.convertToCalendar(timestamp);
        if (date.get(1) == 1970) {
            Calendar currentDate = Calendar.getInstance();
            date.set(currentDate.get(1), currentDate.get(2), currentDate.get(5));
            timestamp.setTime(date.getTimeInMillis());
        }
    }

    private static Calendar convertToCalendar(Date timestamp) {
        Calendar date = Calendar.getInstance();
        date.setTime(timestamp);
        return date;
    }

    protected static class ParseException
    extends Exception {
        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class LogEntry {
        private Date date;
        private EventSeverity severity;
        private StringBuilder detail;

        public LogEntry(Date date, EventSeverity severity, String detail) {
            this.date = date;
            this.severity = severity;
            this.detail = new StringBuilder(detail);
        }

        Date getDate() {
            return this.date;
        }

        EventSeverity getSeverity() {
            return this.severity;
        }

        String getDetail() {
            return this.detail.toString();
        }

        void appendLineToDetail(String string) {
            this.detail.append("\n");
            this.detail.append(string);
        }
    }
}

