/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssJbnDependency;
import churchillobjects.rss4j.RssJbnPatch;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParser;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import junit.framework.TestCase;

public class RssParserTest
extends TestCase {
    public void testProducts_multiple() {
        File file = new File("testFiles\\jbnPatchFeed_multipleProducts.xml");
        RssDocument actual = null;
        RssDocument expected = null;
        try {
            actual = RssParser.parseRss(file);
            this.printDocData(actual);
            ArrayList<RssJbnDependency> products = new ArrayList<RssJbnDependency>();
            RssJbnDependency product1 = new RssJbnDependency("http://product1.com", "product1; 1.0", "product1", "1.0", "jon_product1", "jon_1.0");
            RssJbnDependency product2 = new RssJbnDependency("http://product2.com", "product2; 1.0", "product2", "1.0", "jon_product2", "jon_1.0");
            products.add(product1);
            products.add(product2);
            Collection requires = null;
            Collection replaces = null;
            Collection isReplacedBy = null;
            Collection compatibleWith = null;
            expected = this.createExpectedRssDocument(products, requires, replaces, isReplacedBy, compatibleWith);
            TestCase.assertEquals((Object)actual, (Object)expected);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public void testIsReplacedBy() {
        File file = new File("testFiles\\jbnPatchFeed_isReplacedBy.xml");
        RssDocument actual = null;
        RssDocument expected = null;
        try {
            actual = RssParser.parseRss(file);
            ArrayList<RssJbnDependency> isReplacedBys = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch1 = new RssJbnDependency("http://patch1.com", "PATCH-1");
            isReplacedBys.add(patch1);
            Collection requires = null;
            Collection replaces = null;
            Collection products = null;
            expected = this.createExpectedRssDocument(products, requires, replaces, isReplacedBys, null);
            TestCase.assertEquals((Object)actual, (Object)expected);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public void testIsReplacedBy_multiple() {
        File file = new File("testFiles\\jbnPatchFeed_multiple_isReplacedBy.xml");
        RssDocument actual = null;
        RssDocument expected = null;
        try {
            actual = RssParser.parseRss(file);
            ArrayList<RssJbnDependency> isReplacedBys = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch1 = new RssJbnDependency("http://patch1.com", "PATCH-1");
            RssJbnDependency patch2 = new RssJbnDependency("http://patch2.com", "PATCH-2");
            isReplacedBys.add(patch1);
            isReplacedBys.add(patch2);
            Collection requires = null;
            Collection replaces = null;
            Collection products = null;
            expected = this.createExpectedRssDocument(products, requires, replaces, isReplacedBys, null);
            TestCase.assertEquals((Object)actual, (Object)expected);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public void testPatchDependencies_multiple() {
        File file = new File("testFiles\\jbnPatchFeed_multiple_patchDependencies.xml");
        RssDocument actual = null;
        RssDocument expected = null;
        try {
            actual = RssParser.parseRss(file);
            ArrayList<RssJbnDependency> products = new ArrayList<RssJbnDependency>();
            RssJbnDependency product1 = new RssJbnDependency("http://product1.com", "product1; 1.0", "product1", "1.0", "jon_product1", "jon_1.0");
            RssJbnDependency product2 = new RssJbnDependency("http://product2.com", "product2; 1.0", "product2", "1.0", "jon_product2", "jon_1.0");
            products.add(product1);
            products.add(product2);
            ArrayList<RssJbnDependency> isReplacedBys = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch1 = new RssJbnDependency("http://patch1.com", "PATCH-1");
            RssJbnDependency patch2 = new RssJbnDependency("http://patch2.com", "PATCH-2");
            isReplacedBys.add(patch1);
            isReplacedBys.add(patch2);
            ArrayList<RssJbnDependency> replaces = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch3 = new RssJbnDependency("http://patch3.com", "PATCH-3");
            RssJbnDependency patch4 = new RssJbnDependency("http://patch4.com", "PATCH-4");
            replaces.add(patch3);
            replaces.add(patch4);
            ArrayList<RssJbnDependency> requires = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch5 = new RssJbnDependency("http://patch5.com", "PATCH-5");
            RssJbnDependency patch6 = new RssJbnDependency("http://patch6.com", "PATCH-6");
            RssJbnDependency patch7 = new RssJbnDependency("http://patch7.com", "PATCH-7");
            requires.add(patch5);
            requires.add(patch6);
            requires.add(patch7);
            ArrayList<RssJbnDependency> compatibleWith = new ArrayList<RssJbnDependency>();
            RssJbnDependency product3 = new RssJbnDependency("http://product3.com", "product3; 1.0");
            RssJbnDependency product4 = new RssJbnDependency("http://product4.com", "product4; 1.0");
            compatibleWith.add(product3);
            compatibleWith.add(product4);
            expected = this.createExpectedRssDocument(products, requires, replaces, isReplacedBys, compatibleWith);
            TestCase.assertEquals((Object)actual, (Object)expected);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public void testReplaces() {
        File file = new File("testFiles\\jbnPatchFeed_replaces.xml");
        RssDocument actual = null;
        RssDocument expected = null;
        try {
            actual = RssParser.parseRss(file);
            ArrayList<RssJbnDependency> replaces = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch1 = new RssJbnDependency("http://patch1.com", "PATCH-1");
            replaces.add(patch1);
            Collection requires = null;
            Collection isReplacedBys = null;
            Collection products = null;
            expected = this.createExpectedRssDocument(products, requires, replaces, isReplacedBys, null);
            TestCase.assertEquals((Object)actual, (Object)expected);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public void testRequires() {
        File file = new File("testFiles\\jbnPatchFeed_requires.xml");
        RssDocument actual = null;
        RssDocument expected = null;
        try {
            actual = RssParser.parseRss(file);
            ArrayList<RssJbnDependency> requires = new ArrayList<RssJbnDependency>();
            RssJbnDependency patch1 = new RssJbnDependency("http://patch1.com", "PATCH-1");
            requires.add(patch1);
            Collection replaces = null;
            Collection isReplacedBys = null;
            Collection products = null;
            expected = this.createExpectedRssDocument(products, requires, replaces, isReplacedBys, null);
            TestCase.assertEquals((Object)actual, (Object)expected);
        }
        catch (ParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
        catch (RssParseException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    private RssDocument createExpectedRssDocument(Collection products, Collection requires, Collection replaces, Collection isReplacedBys, Collection compatibleWiths) throws ParseException {
        RssDocument expected = new RssDocument();
        expected.setVersion("1.0");
        RssChannel channel = new RssChannel();
        channel.setChannelDescription("channelDescription");
        channel.setChannelLink("http://channelLink.com");
        channel.setChannelTitle("channelTitle");
        channel.setChannelUri("http://channelURI");
        expected.addChannel(channel);
        RssChannelItem item = new RssChannelItem();
        item.setItemDescription("itemDescription");
        item.setItemLink("http://itemLink.com");
        item.setItemTitle("itemTitle");
        RssDublinCore dc = new RssDublinCore();
        dc.setDate("2006-01-01T01:01:Z");
        dc.setTitle("rawTitle");
        item.setDublinCore(dc);
        RssJbnPatch jbn = new RssJbnPatch();
        jbn.setCaseId("9876");
        jbn.setLicenseName("LGPL");
        jbn.setLicenseVersion("2.0");
        jbn.setDistributionStatus("available");
        jbn.setCreator("itemCreator");
        jbn.setFileName("fileName.txt");
        jbn.setFileSize("12345");
        jbn.setJira("JBAS-1234");
        jbn.setDownloadUrl("http://downloadUrl.com");
        jbn.setAutomatedDownloadUrl("http://automatedDownloadUrl.com");
        jbn.setInstructionCompatibilityVersion("1.4");
        jbn.setMd5("12345678901234567890123456789012");
        jbn.setSha256("1234567890123456789012345678901234567890123456789012345678901234");
        jbn.setType("itemType");
        jbn.setLongDescription("longDescription");
        jbn.setShortDescription("shortDescription");
        jbn.setManualInstallation("manualInstallation");
        jbn.setAutomatedInstallation("automatedInstallation");
        jbn.setLastUpdated("2006-01-03T01:01:Z");
        if (products != null) {
            Iterator productIterator = products.iterator();
            while (productIterator.hasNext()) {
                RssJbnDependency product = (RssJbnDependency)productIterator.next();
                jbn.addProduct(product);
            }
        }
        if (requires != null) {
            Iterator requiresIterator = requires.iterator();
            while (requiresIterator.hasNext()) {
                RssJbnDependency require = (RssJbnDependency)requiresIterator.next();
                jbn.addRequires(require);
            }
        }
        if (replaces != null) {
            Iterator replacesIterator = replaces.iterator();
            while (replacesIterator.hasNext()) {
                RssJbnDependency replace = (RssJbnDependency)replacesIterator.next();
                jbn.addReplaces(replace);
            }
        }
        if (isReplacedBys != null) {
            Iterator replacedByIterator = isReplacedBys.iterator();
            while (replacedByIterator.hasNext()) {
                RssJbnDependency isReplacedBy = (RssJbnDependency)replacedByIterator.next();
                jbn.addReplacedBy(isReplacedBy);
            }
        }
        if (compatibleWiths != null) {
            Iterator compatibleWithIterator = compatibleWiths.iterator();
            while (compatibleWithIterator.hasNext()) {
                RssJbnDependency compatibleWith = (RssJbnDependency)compatibleWithIterator.next();
                jbn.addCompatibleWith(compatibleWith);
            }
        }
        item.setJbnPatch(jbn);
        channel.addItem(item);
        return expected;
    }

    private void printDocData(RssDocument doc) {
        System.out.println("version: " + doc.getVersion());
        Enumeration channelEnum = doc.channels();
        while (channelEnum.hasMoreElements()) {
            RssChannel channel = (RssChannel)channelEnum.nextElement();
            System.out.println("Channel Description: " + channel.getChannelDescription());
            System.out.println("Channel Link: " + channel.getChannelLink());
            Enumeration itemEnum = channel.items();
            int i = 0;
            while (itemEnum.hasMoreElements()) {
                RssJbnPatch jbnPatch;
                RssChannelItem item = (RssChannelItem)itemEnum.nextElement();
                System.out.println("[Item " + i++ + " ]");
                System.out.println("\t Item Title: " + item.getItemTitle());
                System.out.println("\t Item Link: " + item.getItemLink());
                RssDublinCore dc = item.getDublinCore();
                if (dc != null) {
                    System.out.println("\t dc:date: " + dc.getDate());
                }
                if ((jbnPatch = item.getJbnPatch()) == null) continue;
                System.out.println("\t jbn:jira: " + jbnPatch.getJira());
                System.out.println("\t jbn:caseId: " + jbnPatch.getCaseId());
                System.out.println("\t jbn:md5: " + jbnPatch.getMd5());
                System.out.println("\t jbn:sha256: " + jbnPatch.getSha256());
                System.out.println("\t jbn:manualInstallation: " + jbnPatch.getManualInstallation());
                System.out.println("\t jbn:automatedInstallation: " + jbnPatch.getAutomatedInstallation());
                System.out.println("\t jbn:longDescription: " + jbnPatch.getLongDescription());
                System.out.println("\t jbn:licenseName: " + jbnPatch.getLicenseName());
                System.out.println("\t jbn:licenseVersion: " + jbnPatch.getLicenseVersion());
                System.out.println("\t jbn:lastUpdated: " + jbnPatch.getLastUpdatedAsString());
                System.out.println("\t jbn:distributionStatus: " + jbnPatch.getDistributionStatus());
                System.out.println("\t jbn:product(s): ");
                Collection products = jbnPatch.getProducts();
                Iterator productIterator = products.iterator();
                while (productIterator.hasNext()) {
                    RssJbnDependency product = (RssJbnDependency)productIterator.next();
                    System.out.println("\t\t product name/version: " + product.getProductName() + "/" + product.getProductVersion());
                    System.out.println("\t\t jon name/version: " + product.getJonResourceType() + "/" + product.getJonResourceVersion());
                }
                System.out.println("\t jbn:requires");
                Collection requires = jbnPatch.getRequires();
                Iterator requiresIterator = requires.iterator();
                while (requiresIterator.hasNext()) {
                    RssJbnDependency require = (RssJbnDependency)requiresIterator.next();
                    System.out.println("\t\t" + require.getName() + "; " + require.getUrl());
                }
                System.out.println("\t jbn:replaces");
                Collection replaces = jbnPatch.getReplaces();
                Iterator replacesIterator = replaces.iterator();
                while (replacesIterator.hasNext()) {
                    RssJbnDependency replace = (RssJbnDependency)replacesIterator.next();
                    System.out.println("\t\t" + replace.getName() + "; " + replace.getUrl());
                }
                System.out.println("\t jbn:isReplacedBy");
                Collection isReplacedBys = jbnPatch.getReplacedBy();
                Iterator replacedByIterator = isReplacedBys.iterator();
                while (replacedByIterator.hasNext()) {
                    RssJbnDependency isReplacedBy = (RssJbnDependency)replacedByIterator.next();
                    System.out.println("\t\t" + isReplacedBy.getName() + "; " + isReplacedBy.getUrl());
                }
                System.out.println("\t jbn:compatibleWith");
                Collection compatibleWiths = jbnPatch.getCompatibleWith();
                Iterator compatibleWithIterator = compatibleWiths.iterator();
                while (compatibleWithIterator.hasNext()) {
                    RssJbnDependency compatibleWith = (RssJbnDependency)compatibleWithIterator.next();
                    System.out.println("\t\t" + compatibleWith.getName() + "; " + compatibleWith.getUrl());
                }
            }
        }
    }
}

