/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat.helper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;

public class FileContentDelegate {
    private static final String RHQ_SHA_256 = "RHQ-Sha256";
    private static final String MANIFEST_RELATIVE_PATH = "META-INF/MANIFEST.MF";
    private File deployDirectory;

    public FileContentDelegate(File directory) {
        this.deployDirectory = directory;
    }

    public File getDirectory() {
        return this.deployDirectory;
    }

    public void createContent(File destination, File content, boolean unzip) {
        try {
            if (unzip) {
                ZipUtil.unzipFile((File)content, (File)destination);
                String sha = new MessageDigestGenerator("SHA-256").calcDigestString(content);
                this.writeSHAToManifest(destination, sha);
            } else {
                BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(content));
                FileUtil.writeFile((InputStream)contentStream, (File)destination);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact for contentFile: " + destination, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSHA(File deploymentFile) {
        String sha;
        block9: {
            sha = null;
            try {
                if (deploymentFile.isDirectory()) {
                    File manifestFile = new File(deploymentFile.getAbsolutePath(), MANIFEST_RELATIVE_PATH);
                    if (manifestFile.exists()) {
                        FileInputStream manifestStream = new FileInputStream(manifestFile);
                        Manifest manifest = null;
                        try {
                            manifest = new Manifest(manifestStream);
                            sha = manifest.getMainAttributes().getValue(RHQ_SHA_256);
                        }
                        finally {
                            ((InputStream)manifestStream).close();
                        }
                    }
                    if (sha == null || sha.trim().isEmpty()) {
                        sha = this.computeAndSaveSHA(deploymentFile);
                    }
                    break block9;
                }
                sha = new MessageDigestGenerator("SHA-256").calcDigestString(deploymentFile);
            }
            catch (IOException ex) {
                throw new RuntimeException("Problem calculating digest of package [" + deploymentFile.getPath() + "].", ex);
            }
        }
        return sha;
    }

    public File getPath(PackageDetails details) {
        PackageDetailsKey key = details.getKey();
        String fileName = key.getName();
        int lastPathStart = fileName.lastIndexOf(File.separatorChar);
        if (lastPathStart > -1) {
            fileName = fileName.substring(lastPathStart + 1);
        }
        return new File(this.deployDirectory, fileName);
    }

    public InputStream getContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        try {
            return new BufferedInputStream(new FileInputStream(contentFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Package content not found for package " + contentFile, e);
        }
    }

    public void deleteContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        if (!contentFile.exists()) {
            return;
        }
        try {
            FileUtils.purge((File)contentFile, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete underlying file [" + contentFile + "] for " + details + ".", e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeAndSaveSHA(File deploymentDirectory) {
        String sha = null;
        try {
            if (deploymentDirectory.isDirectory()) {
                MessageDigestGenerator messageDigest = new MessageDigestGenerator("SHA-256");
                Stack<File> unvisitedFolders = new Stack<File>();
                unvisitedFolders.add(deploymentDirectory);
                while (!unvisitedFolders.empty()) {
                    File[] files = ((File)unvisitedFolders.pop()).listFiles();
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File f1, File f2) {
                            try {
                                return f1.getCanonicalPath().compareTo(f2.getCanonicalPath());
                            }
                            catch (IOException iOException) {
                                return 0;
                            }
                        }
                    });
                    for (File file : files) {
                        if (file.isDirectory()) {
                            unvisitedFolders.add(file);
                            continue;
                        }
                        FileInputStream inputStream = null;
                        try {
                            inputStream = new FileInputStream(file);
                            messageDigest.add((InputStream)inputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                }
                sha = messageDigest.getDigestString();
                this.writeSHAToManifest(deploymentDirectory, sha);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact for contentFile: " + deploymentDirectory, e);
        }
        return sha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSHAToManifest(File deploymentFolder, String sha) throws IOException {
        Manifest manifest;
        File manifestFile = new File(deploymentFolder, MANIFEST_RELATIVE_PATH);
        if (manifestFile.exists()) {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
        } else {
            manifest = new Manifest();
            manifestFile.getParentFile().mkdirs();
            manifestFile.createNewFile();
        }
        Attributes attribs = manifest.getMainAttributes();
        if (!attribs.containsKey(Attributes.Name.MANIFEST_VERSION.toString()) && !attribs.containsKey(Attributes.Name.SIGNATURE_VERSION.toString())) {
            attribs.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        attribs.putValue(RHQ_SHA_256, sha);
        FileOutputStream outputStream = new FileOutputStream(manifestFile);
        try {
            manifest.write(outputStream);
        }
        finally {
            outputStream.close();
        }
    }
}

