/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import org.jboss.as.controller.client.ModelControllerClient;

public class MCCHelper {
    private static final String RHQ_JBOSS_MANAGEMENT_PORT_PROPERTY = "jboss.management.native.port";
    private static final int RHQ_JBOSS_MANAGEMENT_PORT_PROPERTY_DEFAULT_VALUE = 6999;

    public static ModelControllerClient createModelControllerClient() {
        return MCCHelper.createModelControllerClient("localhost", MCCHelper.getPort());
    }

    public static ModelControllerClient createModelControllerClient(String host, int port) {
        ModelControllerClient client;
        try {
            if (host == null || host.isEmpty()) {
                host = "localhost";
            }
            if (port <= 0 || port > 65535) {
                port = 6999;
            }
            client = ModelControllerClient.Factory.create((String)host, (int)port);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain client connection to the app server", e);
        }
        return client;
    }

    public static void safeClose(ModelControllerClient mcc) {
        if (mcc != null) {
            try {
                mcc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static int getPort() {
        String result = System.getProperty(RHQ_JBOSS_MANAGEMENT_PORT_PROPERTY, "");
        if (!"".equals(result)) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException nfe) {
                return 6999;
            }
        }
        return 6999;
    }
}

