/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.twitter;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.twitter.TwitterEventPoller;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.conf.PropertyConfiguration;

public class TwitterComponent
implements ResourceComponent<ResourceComponent<?>>,
OperationFacet,
MeasurementFacet {
    private static final String TWIT_EVENT = "TwitterEvent";
    private static final int NOT_YET_SET = -1;
    EventContext eventContext;
    private String username;
    private String password;
    private String serverUrl;
    private String searchBaseUrl;
    private TwitterFactory tFactory;
    private TwitterEventPoller eventPoller;
    private long lastId = -1L;
    private static final String HTTP_TWITTER_COM = "http://twitter.com/";

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws Exception {
        Configuration conf = context.getPluginConfiguration();
        this.username = conf.getSimpleValue("user", null);
        this.password = conf.getSimpleValue("password", null);
        String url = conf.getSimpleValue("baseurl", HTTP_TWITTER_COM);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            new URL(url);
            this.serverUrl = url;
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginConfigurationException(e.getMessage());
        }
        url = conf.getSimpleValue("searchBaseUrl", "http://search.twitter.com/");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            new URL(url);
            this.searchBaseUrl = url;
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginConfigurationException(e.getMessage());
        }
        this.eventContext = context.getEventContext();
        this.eventPoller = new TwitterEventPoller(TWIT_EVENT);
        this.eventContext.registerEventPoller((EventPoller)this.eventPoller, 53);
        Properties props = new Properties();
        props.put("http.userAgent", "Jopr");
        props.put("searchBaseURL", this.searchBaseUrl);
        props.put("restBaseURL", this.serverUrl);
        PropertyConfiguration tconf = new PropertyConfiguration(props);
        this.tFactory = new TwitterFactory((twitter4j.conf.Configuration)tconf);
    }

    public void stop() {
        this.eventContext.unregisterEventPoller(TWIT_EVENT);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Twitter twitter = this.createTwitterInstance();
        for (MeasurementScheduleRequest req : metrics) {
            if (req.getName().equals("tweetCount")) {
                Paging paging = new Paging();
                if (this.lastId == -1L) {
                    paging.setSinceId(1L);
                    paging.setCount(1);
                } else {
                    paging.setSinceId(this.lastId);
                    paging.setCount(100);
                }
                ResponseList statuses = twitter.getHomeTimeline(paging);
                if (this.lastId > 0L) {
                    MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(statuses.size()));
                    this.eventPoller.addStatuses((List<Status>)statuses);
                    report.addData(res);
                }
                if (statuses.size() <= 0) continue;
                this.lastId = ((Status)statuses.get(0)).getId();
                continue;
            }
            if (!req.getName().equals("followerCount")) continue;
            int count = twitter.getFollowersIDs(-1L).getIDs().length;
            MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(count));
            report.addData(res);
        }
    }

    private Twitter createTwitterInstance() {
        Properties props = new Properties();
        props.setProperty("user", this.username);
        props.setProperty("password", this.password);
        PropertyConfiguration propConfig = new PropertyConfiguration(props);
        return this.tFactory.getInstance(AuthorizationFactory.getInstance((twitter4j.conf.Configuration)propConfig));
    }

    public OperationResult invokeOperation(String name, Configuration configuration) throws Exception {
        if (name != null && name.equals("postStatus")) {
            if (this.username == null || this.password == null) {
                throw new IllegalArgumentException("User or password were not set");
            }
            String message = configuration.getSimpleValue("message", null);
            Twitter twitter = this.createTwitterInstance();
            Status status = twitter.updateStatus(message);
            OperationResult result = new OperationResult("Posted " + status.getText());
            return result;
        }
        throw new UnsupportedOperationException("Operation " + name + " is not valid");
    }

    protected String getServerUrl() {
        return this.serverUrl;
    }

    protected String getSearchUrl() {
        return this.searchBaseUrl;
    }
}

